<?php
if ( ! defined( 'ABSPATH' ) ) exit('You need Jesus!'); // Exit if accessed directly

/**
 *
 * Displays calendar via shortcode
 *
 * @author  Andy Moyle
 * @param    null
 * @return   $out
 * @version  0.1
 *
 */
 
function church_admin_display_new_calendar()
{
     $out=church_admin_calendar_container();
     return $out;
}


function church_admin_calendar_container()
{
    global $wp_locale,$wpdb;
    $date=wp_date('Y-m-d');
    $events=church_admin_day_events_array( $date);
    $todayEvents='<li>'.wp_kses_post(implode('<br />',array_filter( $events) )).'</li>';
    $out='<div class="ca-calendar">';
    $out.='<div class="ca-calendar-sidebar">';
    $out.=' <div class="ca-sidebar-title-area"><h3 class="ca-sidebar-heading" id="ca-date">Heading</h3><div class="ca-today-button"><button class="btn btn-warning ca-calendar-nav" data-date="'.date('Y-m-d').'">'.__('Today','church-admin').'</button></div></div><ul class="ca-sidebar-list">'.$todayEvents.'</ul>';
    $out.='</div>';
    $out.=' <div class="ca-calendar-render"><div class="ca-calendar-top-bar"><span class="ca-top-bar-days"><svg viewBox="0 0 100 100">
  <text x="25%" y="50%">'.esc_html( $wp_locale->get_weekday_abbrev( esc_html( $wp_locale->get_weekday(0) )) ).'</text>
</svg></span><span class="ca-top-bar-days"><svg viewBox="0 0 100 100">
  <text x="25%" y="50%">'.esc_html( $wp_locale->get_weekday_abbrev(  esc_html( $wp_locale->get_weekday(1) )) ).'</text>
</svg></span><span class="ca-top-bar-days"><svg viewBox="0 0 100 100">
  <text x="25%" y="50%">'.esc_html( $wp_locale->get_weekday_abbrev( esc_html( $wp_locale->get_weekday(2 ) ) ) ).'</text>
</svg></span><span class="ca-top-bar-days"><svg viewBox="0 0 100 100">
  <text x="25%" y="50%">'.esc_html( $wp_locale->get_weekday_abbrev( esc_html( $wp_locale->get_weekday(3 ) ) ) ).'</text>
</svg></span><span class="ca-top-bar-days"><svg viewBox="0 0 100 100">
  <text x="25%" y="50%">'.esc_html( $wp_locale->get_weekday_abbrev( esc_html( $wp_locale->get_weekday(4) ) ) ).'</text>
</svg></span><span class="ca-top-bar-days"><svg viewBox="0 0 100 100">
  <text x="25%" y="50%">'.esc_html( $wp_locale->get_weekday_abbrev( esc_html( $wp_locale->get_weekday( 5) ) ) ).'</text>
</svg></span><span class="ca-top-bar-days"><svg viewBox="0 0 100 100">
  <text x="25%" y="50%">'.esc_html( $wp_locale->get_weekday_abbrev( esc_html( $wp_locale->get_weekday( 6) ) ) ).'</text>
</svg></span></div>';
    $day=$events=1;
    for ( $week=1; $week<=5; $week++)
    {
        $out.='<div class="ca-week">';
        for ( $d=1; $d<=7; $d++)
        {
            $out.='<div class="ca-day " id="day'.esc_attr($day).'" data-date=""> </div>';
            $day++;
            $events++;
        }
        $out.='</div>';
    }
     $out.='</div></div><!-- End of Church Admin Calendar -->';
    $out.='<script>var caCalendar=1;</script>';
     return $out;
 }

function church_admin_render_month( $month,$year,$day)
{
    global $wpdb;
    if ( empty( $month) )  {$month=date('m');}
    if ( empty( $year) )  {$year=date('Y');}
    if ( empty( $day) )  {$day='01';}
    $date=$year.'-'.$month.'-'.$day;
    $d=new DateTime( $date);
    $prev=church_admin_addMonths( $d,-1);
    $next=church_admin_addMonths( $d,2);
    
    // find out the number of days in the month
    $numDaysInMonth =  date ('t',strtotime( $year.'-'.$month.'-01') );
    //integer for start date (0 Sunday etc)
    $startday = date('w',strtotime( $year.'-'.$month.'-01') );
    church_admin_debug('Year' . $year);
    church_admin_debug('Month' . $month);
    church_admin_debug('num days' . $numDaysInMonth);
    church_admin_debug('start days' . $startday );
    // get the month as a name
    $monthname =date('F',strtotime( $year.'-'.$month.'-01') );
    
    
    $sql='SELECT COUNT(*) AS eventsCount,DAY(start_date) AS day FROM '.CA_DATE_TBL.' WHERE MONTH(start_date)="'. esc_sql($month).'" AND YEAR(start_Date)="'.esc_sql( $year).'" GROUP BY start_date';
    $results=$wpdb->get_results( $sql);
    if(!empty( $results) )
    {
        $events=array();
        foreach( $results AS $row)
        {
            $events[$row->day]=$row->eventsCount;
        }
    }
    //output array of dates, note that on the calendar the first day box is day0
    $dates=array();
    $dayNo=0;
    for ( $calendarDays=0; $calendarDays<=35; $calendarDays++)
    {
        if( $calendarDays<$startday)  {$dates[$calendarDays]=NULL;}
        elseif( $dayNo<=$numDaysInMonth)
        {
            if(date('j')==$dayNo && $date==date('Y-m-d') )
            {
                $dateNumbers[$calendarDays]=str_pad( $dayNo, 2, 0, STR_PAD_LEFT);
                $dates[$calendarDays]='<span class="ca-today">'.$dayNo.'</span>';
                if(!empty( $events[$dayNo] ) )$dates[$calendarDays].='<br /><span class="ca-events">'.esc_html( sprintf(__('%1$s events','church-admin'),$events[$dayNo] ) ).'</span>';
                $dayNo++;
            }
            else
            {
                $dateNumbers[$calendarDays]=str_pad( $dayNo, 2, 0, STR_PAD_LEFT);
                $dates[$calendarDays]=$dayNo;
                 if(!empty( $events[$dayNo] ) )$dates[$calendarDays].='<br /><span class="ca-events">'.esc_html( sprintf(__('%1$s events','church-admin'),$events[$dayNo] )).'</span>';
                $dayNo++;
            }
        }
        else{$dates[$calendarDays]=NULL;}
        
    }
    $title='<p style="text-align:center"><button class="ca-calendar-nav btn btn-info" data-date="'.esc_attr($prev->format('Y-m-d')).'">'.__('Prev','church-admin').'</button> '.mysql2date('M Y',$date).' <button class="ca-calendar-nav  btn btn-info" data-date="'.esc_attr($next->format('Y-m-d') ).'">'.__('Next','church-admin').'</button></p>';
   
    $output=array('dates'=>$dates,'dateNumber'=>$dateNumbers,'title'=> $title ,'eventList'=>church_admin_day_events_array( $date),'partDate'=>esc_html($year.'-'.$month.'-'));
    header('Access-Control-Max-Age: 1728000');
    header('Access-Control-Allow-Origin: *');
    header('Access-Control-Allow-Methods: *');
    header('Access-Control-Allow-Headers: Content-MD5, X-Alt-Referer');
    header('Access-Control-Allow-Credentials: true');
    echo json_encode( $output);
    exit();
    
}

function church_admin_render_day( $date)
{
    
    $output=church_admin_day_events_array( $date);
    header('Access-Control-Max-Age: 1728000');
    header('Access-Control-Allow-Origin: *');
    header('Access-Control-Allow-Methods: *');
    header('Access-Control-Allow-Headers: Content-MD5, X-Alt-Referer');
    header('Access-Control-Allow-Credentials: true');
    echo json_encode( $output);
    exit();
    
}
function church_admin_day_events_array( $date)
{
    global $wpdb;
    //$sql='SELECT a.*, b.* FROM '.CA_DATE_TBL.' a,'.CA_CAT_TBL.' b WHERE a.general_calendar=1 AND a.cat_id=b.cat_id  AND a.start_date="'.esc_sql( $date).'" ORDER BY a.start_time';
    $sql='SELECT a.*, b.* FROM '.CA_DATE_TBL.' a LEFT JOIN '.CA_CAT_TBL.' b ON b.cat_id = a.cat_id WHERE a.start_date="'.esc_sql( $date).'"  ORDER BY a.start_time';
    
    $results=$wpdb->get_results( $sql);
    if(!empty( $results) )
    {
        $output=array('<li style="font-size:larger;margin-bottom:20px">'.esc_html(mysql2date(get_option('date_format'),$date)).'</li>');
        foreach( $results AS $row)
        {
            
            $day[]='<strong>'.esc_html( $row->title).'</strong>';
            if( $row->start_time=='00:00:00' && $row->end_time=='23:59:00')
            {
                $day[]=__('All day event','church-admin');
            }else $day[]=esc_html( mysql2date(get_option('time_format'),$row->start_time).' - '.mysql2date(get_option('time_format'),$row->end_time) );
            $day[]=wp_kses_post(church_admin_excerpt( $row->description,50,'...') );
            $day[]=esc_html( $row->location);
            if(!empty( $row->link) )
            {
                if(!empty( $row->link_title) )  {$title=esc_html( $row->link_title);}else{$title=esc_html(__('More information...','church-admin'));}
                $day[]='<a href="'.esc_url( $row->link).'">'.$title.'</a>';
            }
            $day[]='<a class="vcf-link" href="'.esc_url(site_url().'?ca_download=ical&date_id='.(int)$row->date_id).'"><span class="dashicons dashicons-download"></span></a>';
            
            $output[]='<li style="border-left:5px solid '.esc_attr($row->bgcolor).'">'.wp_kses_post(implode('<br />',array_filter( $day) )).'</li>';
            $day=array();
        }
       
    }else 
    {
        $output=array('<li style="font-size:larger;margin-bottom:20px">'.esc_html(mysql2date(get_option('date_format'),$date)).'</li><li>'.esc_html( __('No events today','church-admin') ).'</li>');
    }
    return $output;
}

