<?php
if ( ! defined( 'ABSPATH' ) ) exit('You need Jesus!'); // Exit if accessed directly

function church_admin_display_volunteer()
{
      global $wpdb;
      $out='<div class="church-admin-volunteer">';
      $out.='<h2>'.__('Serve in a ministry','church-admin').'</h2>';
      $volunteerMessage=get_option('church-admin-volunteer-message');
      if(!empty( $volunteerMessage) ) {$out.=wpautop( $volunteerMessage);}
      else{$out.='<p>'.__('You can volunteer for various ministries in the church here. The team leaders will be in touch','church-admin').'</p>';}
      if(!empty( $_POST['nonce'] )&&wp_verify_nonce( $_POST['nonce'],'volunteer') )
      {
          foreach( $_POST['volunteer'] AS $key=>$value)
          {
              $data=explode("/",$value);
              $ministry_id=$data[0];
              $people_id=$data[1];
              $person=$wpdb->get_row('SELECT CONCAT_WS(" ",first_name,last_name) AS name,email FROM '.CA_PEO_TBL.' WHERE people_id="'.(int)$people_id.'"');
              if(!empty( $ministry_id)&&!empty( $person) )
              {
                church_admin_update_people_meta( $ministry_id,$people_id,'volunteer',NULL);
                $ministry=$wpdb->get_var('SELECT ministry FROM '.CA_MIN_TBL.' WHERE ID="'.(int)$ministry_id.'"');
                $approve=admin_url().'admin.php?page=church_admin/index.php&amp;action=approve_volunteer&ministry_id='.(int)$ministry_id.'&people_id='.(int)$people_id;
                $decline=admin_url().'admin.php?page=church_admin/index.php&amp;action=decline_volunteer&ministry_id='.(int)$ministry_id.'&people_id='.(int)$people_id;
                $contact=__('No contact details','church-admin');
                if(!empty( $person->email) )  {$contact=antispambot($person->email);}
                elseif(!empty( $person->mobile) )  {$contact=$person->mobile;}
                $message='<p>'.sprintf(__('%1$s (%2$s) has just volunteered for %3$s, please approve them or get in touch','church-admin'),$person->name,$contact,$ministry).'</p>';
                $message.='<p><a href="'.$approve.'">'.__('Approve them','church-admin').'</a></p>';
                $message.='<p><a href="'.$decline.'">'.__('Decline them','church-admin').'</a></p>';
                $team_contact=$wpdb->get_var('SELECT people_id FROM '.CA_MET_TBL.' WHERE meta_type="team_contact" AND ID="'.(int)$ministry_id.'"');
                $team_contact_email=$wpdb->get_var('SELECT email FROM '.CA_PEO_TBL.' WHERE people_id="'.(int)$team_contact.'"');
                if ( empty( $team_contact_email) )$team_contact_email=get_option('admin_email');
                $subject=esc_html(sprintf(__('New volunteer request for %1$s','church-admin'),$ministry));

                add_filter('wp_mail_content_type','church_admin_email_type');
                add_filter( 'wp_mail_from_name', 'church_admin_from_name');
                add_filter( 'wp_mail_from', 'church_admin_from_email');
                wp_mail( $team_contact_email,$subject,$message);
                remove_filter('wp_mail_content_type','church_admin_email_type');
              }

              $out.="<p>".esc_html(__('Thank you for volunteering, we will be in touch','church-admin')).'</p>';
          }


      }
      else{


              if(!is_user_logged_in() )
              {
                $out.=esc_html(__('You need to login to volunteer','church-admin'));
                $out.=wp_login_form(array('echo'=>FALSE) );
              }
            else
            {
              $current_user = wp_get_current_user();
              $sql='SELECT household_id FROM '.CA_PEO_TBL.' WHERE user_id="'.(int)$current_user->ID.'"';
              $household_id=$wpdb->get_var( $sql);
              $sql='SELECT first_name, people_id FROM '.CA_PEO_TBL.' WHERE household_id="'.(int)$household_id.'" ORDER BY people_order ASC';

              $people=$wpdb->get_results( $sql);
              if(!empty( $people) )
              {
                  $ministries=$wpdb->get_results('SELECT * FROM '.CA_MIN_TBL.' WHERE volunteer=1 ORDER BY ministry ASC');
                  if(!empty( $ministries) )
                  {
                      $out.='<form action="'.esc_url(get_permalink()).'" method="POST">';
                      $out.='<table class="form-table table-striped table-bordered">';
                      $out.='<thead><tr><th>'.__('Ministry team','church-admin').'</th>';
                      foreach( $people AS $person)
                      {
                          $out.='<th>'.esc_html( $person->first_name).'</th>';
                      }
                      $out.='</tr></thead><tbody>';
                      foreach( $ministries AS $ministry)
                      {
                        $out.='<tr><th scope="row">'.esc_html( $ministry->ministry).'</th>';
                        foreach( $people AS $person)
                        {
                          $already=FALSE;
                          $already=$wpdb->get_var('SELECT meta_id FROM '.CA_MET_TBL.' WHERE meta_type="ministry" AND ID="'.intval( $ministry->ID).'" AND people_id="'.(int)$person->people_id.'"');
                          if( $already)  {$out.='<td>'.__('Already','church-admin').'</td>';}
                          else{$out.='<td><input type="checkbox" name="volunteer[]" value="'.intval( $ministry->ID).'/'.(int)$person->people_id.'"/></td>';}
                        }
                        $out.='</tr>';
                    }

                    $out.='</tbody></table>';
                    $out.=wp_nonce_field( 'volunteer', 'nonce', TRUE, FALSE );
                    $out.='<p><input type="submit" class="btn btn-success" value="'.esc_attr(__('Send request','church-admin')).'"/></p>';
                    $out.='</form>';
                  }
                  else {
                    $out.='<p>'.esc_html(__('No ministries available for volunteering','church-admin')).'</p>';
                  }
                }else {
                        $out.='<p>'.esc_html(__("Sorry, you need to be in our church directory to volunteer.",'church-admin')).'</p>';
                      }
            }
            }
$out.='</div>';
return $out;


}
