<?php
if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly
function church_admin_frontend_birthdays( $member_type_id=0,$people_type_id=0, $deltadays=31,$showAge=FALSE,$email=FALSE,$phone=FALSE)
{
	$out='';

	global $wpdb;
	$wpdb->show_errors;
	if(is_admin())$out.='<p>'.esc_html( __('Admin area shows all birthdays including people who have selected not to be shown publicly in the address list', 'church-admin' )).'</p>';
	$out.='<div class="church-admin-birthdays">';
    $membsql=array();
	if( $member_type_id!=0)
	{
		$memb=explode(',',$member_type_id);

      foreach( $memb AS $key=>$value)  {if(ctype_digit( $value) )  $membsql[]='member_type_id='.esc_sql($value);}

      if(!empty( $membsql) ) {$memb_sql=' ('.implode(' || ',$membsql).')';}
	}
	if( $people_type_id!=0)
    {
	   $peoplesql=array();
	   $people=explode(',',$people_type_id);

      foreach( $people AS $key=>$value)  {if(ctype_digit( $value) )  $peoplesql[]='people_type_id='.esc_sql($value);}

      if(!empty( $peoplesql) ) {$people_sql=' ('.implode(' OR ',$peoplesql).')';}
    }
	
	church_admin_debug('Delta days '.$deltadays);
	
	$today =wp_date('z');
	$max = $today + $deltadays;

	//check for no of days in year
	$year = date('Y');
	if((0 == $year % 4) & (0 != $year % 100) | (0 == $year % 400))
	{
		$days=366;
	}
	else
	{
		$days = 365;
	}

	if($max<$days)
	{
		$dayNoSQL = 'DAYOFYEAR(date_of_birth) BETWEEN '.(int)$today.' AND '.(int)$max;
	}
	else
	{
		$max=$max-$days;
		$dayNoSQL= '(DAYOFYEAR(date_of_birth) BETWEEN '.(int)$today.' AND '.$days.') OR (DAYOFYEAR(date_of_birth) BETWEEN 0 AND '.$max.')';
	}



	 $sql='SELECT * FROM  '.CA_PEO_TBL.' WHERE 1=1 ';
	 if(!is_admin()) $sql.=' AND show_me=1 AND  gdpr_reason!="" ';
	 $sql.=' AND ('.$dayNoSQL.')';
    
	if(!empty( $memb_sql) ) $sql.=' AND '.$memb_sql;
	if(!empty( $people_sql) ) $sql.=' AND '.$people_sql;
	//$sql.=' ORDER BY  DAYOFYEAR(date_of_birth) ASC, MONTH(date_of_birth) ';

	$sql.=' ORDER BY CONCAT(SUBSTR(`date_of_birth`,6) < SUBSTR(CURDATE(),6), SUBSTR(`date_of_birth`,6))';
    church_admin_debug( $sql);
	
    $people_results=$wpdb->get_results( $sql);

	if(!empty( $people_results) )
	{

		$out .= '<p><strong>'.esc_html(sprintf( __('Birthdays within the next %1$s  days','church-admin'), $deltadays) ).':</strong></p>';

		$out .= '<table class="table table-bordered table-striped widefat">';

		$out.='<thead><tr><th>'.__('Name','church-admin').'</strong></th><th>'.__('Birthday','church-admin').'</th>';
		if(!empty($email))$out.='<th>'.__('Email','church-admin').'</th>';
		if(!empty($phone))$out.='<th>'.__('Cell','church-admin').'</th>';
		$out.='</tr></thead><tbody>';

		foreach( $people_results AS $people)

		{

			if(!empty( $people->prefix) )  { $prefix=$people->prefix.' '; } else {	$prefix='';	}

			$name=$people->first_name.' '.$prefix.$people->last_name;
            if(( $showAge) )  {$format ='jS M Y';}else{$format ='jS M ';}
			$birthday = mysql2date( $format,$people->date_of_birth);
			$birthyear = mysql2date("Y",$people->date_of_birth);
			$currentyear = date("Y");
			$age = $currentyear - $birthyear;
			$out.='<tr><td class="ca-names">'.esc_html( $name).'</td><td>'.esc_html( $birthday);
			if(!empty( $showAge) )$out.=', '.esc_html($age).' '.__("years","church-admin");
			$out.='</td>';
			if(!empty($email))
			{
				$out.='<td>';
				if(!empty($people->email)){
					$out.=antispambot($people->email);
				}
				else{
					$out.='&nbsp;';
				}
				$out.='</td>';
			}
			if(!empty($phone))
			{
				$out.='<td>';
				if(!empty($people->e164cell)){
					$out.='<a href="'.esc_url('tel:'.$people->e164cell).'">'.esc_html($people->mobile).'</a>';
				}
				else{
					$out.='&nbsp;';
				}
				$out.='</td>';
			}
			$out.='</tr>';

		}

		$out.='</tbody></table>';
		$out.="\r\n";
	}
	else{$out.='<p>'.__('No upcoming birthdays','church-admin');}

	$out.='</div>';
	return $out;

}

function church_admin_birthday_widget_control()
{

    //get saved options

    $options=get_option('church_admin_birthday_widget');

    //handle user input

    if(!empty( $_POST['widget_submit'] ) )

    {

		$options['title']=strip_tags(stripslashes( $_POST['title'] ) );

        if(ctype_digit( $_POST['days'] ) )  {$options['days']=$_POST['days'];}else{$options['days']='14';}
        $memb=array();
		foreach( $_POST['member_type_id'] AS $key=>$value)$memb[]=$value;
		$options['member_type_id']=implode(',',$memb);
		if(!empty( $_POST['showAge'] ) )  {$options['showAge']=TRUE;}else{$options['showAge']=FALSE;}
        update_option('church_admin_birthday_widget',$options);

    }

    church_admin_birthday_widget_control_form();

}



function church_admin_birthday_widget_control_form()
{

    global $wpdb;
	$member_type=church_admin_member_type_array();





    $option=get_option('church_admin_birthday_widget');
	if ( empty( $option['showAge'] ) )$option['showAge']=FALSE;
    echo '<p><label for="title"><strong>'.__('Title','church-admin').':</strong></label><input type="text" name="title" value="'.esc_attr($option['title']).'" /></p>';
	echo '<p><label for="showAge"><strong>'.__('Show Age?','church-admin').':</strong></label><input type="checkbox" name="showAge" '.checked(TRUE,$option['showAge'],FALSE).'/></p>';
    echo '<p><label for="member_type_id"><strong>'.__('Which Member Types?','church-admin').':</strong></label></p>';

	if(!empty( $option['member_type_id'] ) )$stored=explode(',',$option['member_type_id'] );

	foreach( $member_type AS $key=>$value )

	{

		echo'<p>'.esc_html( $value).' <input type="checkbox" name="member_type_id[]" value="'.esc_html( $key).'" ';

		if(!empty( $stored)&& in_array( $key,$stored) ) echo' checked="checked" ';

		echo'/></p>';

	}

    echo'</p>';

    echo '<p><label for="days"><strong>'.__('How many days to show','church-admin').'?</strong></label><select name="days">';

    if(isset( $option['days'] ) ) echo '<option value="'.esc_html( $option['days'] ).'">'.esc_html( $option['days'] ).'</option>';

    for ( $x=1; $x<=365; $x++)  {echo '<option value="'.(int)$x.'">'.(int)$x.'</option>';}

    echo'</select><input type="hidden" name="widget_submit" value="1"/>';

}
