<?php
if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly
/*
2011-02-04 added calendar single and series delete; fixed slashes problem
2011-03-14 fixed errors not sowing as red since 0.32.4
2012-07-20 Update Internationalisation
2014-09-22 Simplify db and add image
2014-10-06 Added facilities bookings

*/


 /**
 *
 * Calendar Display
 *
 * @author  Andy Moyle
 * @param    $current,$facilities_id
 * @return
 * @version  0.1
 *
 *
 *
 */
 function church_admin_new_calendar( $start_date=NULL,$facilities_id=NULL) {
	if(!church_admin_level_check('Calendar') )
	{
		echo '<div class="notice notice-danger"><h2>'.sprintf(__('You need "%1$s" permissions to access this page','church-admin'),__('Calendar','church-admin') ).'</h2></div>';
		return;
	}
	global $wpdb, $m, $monthnum, $year, $wp_locale;
	if(defined('CA_DEBUG') )$wpdb->show_errors();
	$initial=true;

	if(!empty( $facilities_id) )
	{
		$facility=$wpdb->get_var('SELECT facility_name FROM '.CA_FAC_TBL.' WHERE facilities_id="'.esc_sql( $facilities_id).'"');
		echo '<h2>'.__('Bookings Calendar for ','church-admin').$facility.'</h2>';
        echo '<p>'.__('Click on an event to edit it','church-admin').'</p>';
		echo '<p><a class="button-primary" href="'.wp_nonce_url('admin.php?page=church_admin/index.php&amp;action=edit-calendar&section=facilities','edit_event').'">'.__('Add a booking','church-admin').'</a></p>';
	}else
	{
		echo '<h2>'.__('Calendar','church-admin').'</h2>';
  
        echo '<p>'.__('Click on an event to edit it','church-admin').'</p>';
	echo '<p><a class="button-primary" href="'.wp_nonce_url('admin.php?page=church_admin/index.php&amp;action=edit-calendar','edit_event').'">'.__('Add an event','church-admin').'</a></p>';
	}
	
	
	//use today if something wrong with given dates
	if ( empty( $start_date) )$start_date=wp_date('Y-m-d');
	if(!empty( $_POST['start_date'] )&&church_admin_checkdate( $_POST['start_date'] ) )$start_date=$_POST['start_date'];
	if(!church_admin_checkdate( $start_date) )$start_date=date('Y-m-d');
	$prev=explode('-',date('Y-m-d',strtotime( $start_date.' -1 month') ));
	$next=explode('-',date('Y-m-d',strtotime( $start_date.' +1 month') ));


	// week_begins = 0 stands for Sunday
	$week_begins = (int) get_option( 'start_of_week' );
	$ts = strtotime( $start_date );
	$thisyear = gmdate( 'Y', $ts );
	$thismonth = gmdate( 'm', $ts );
	$thisday = gmdate( 'd', $ts );
	$unixmonth = mktime( 0, 0 , 0, $thismonth, 1, $thisyear );
	$last_day = date( 't', $unixmonth );


    if(!empty( $facilities_id) )  {$type='facility-bookings';}else{$type='calendar';}
	/* translators: Calendar caption: 1: month name, 2: 4-digit year */
	$calendar_caption = _x('%1$s %2$s', 'calendar caption');
	$calendar_output = '<table  class="church_admin_calendar"><thead><tr>';
	$calendar_output .= "\n\t\t".'<th colspan="2" id="prev">'.ca_date_link( $prev[0],$prev[1],'01',__('<','church-admin'),NULL,$type,$facilities_id).'</th>';
	$calendar_output .= "\n\t\t".'<th colspan="3" >' . sprintf(
		$calendar_caption,
		$wp_locale->get_month( $thismonth ),
		date( 'Y', $unixmonth )
	) . '</th>';
	$calendar_output .= "\n\t\t".'<th colspan="2" id="next">'.ca_date_link( $next[0],$next[1],'01',__('>','church-admin'),NULL,$type,$facilities_id).'</th>';
	$calendar_output .= '</tr></thead><tbody>';

	$myweek = array();

	for ( $wdcount = 0; $wdcount <= 6; $wdcount++ ) {
		$myweek[] = $wp_locale->get_weekday( ( $wdcount + $week_begins ) % 7 );
	}

	foreach ( $myweek as $wd ) {
		//$day_name = $initial ? $wp_locale->get_weekday_initial( $wd ) : $wp_locale->get_weekday_abbrev( $wd );
		$wd = esc_attr( $wd );
		$calendar_output .= "\n\t\t<th scope=\"col\" title=\"$wd\" class=\"dayheader\">$wd</th>";
	}

	$calendar_output .= '
	</tr>
	</thead>
	<tbody>
	<tr class="cal">';

	$daywithevent = array();

	// Get days with events
	$dayswithevents = $wpdb->get_results("SELECT DISTINCT DAYOFMONTH(start_date)
		FROM ".CA_DATE_TBL." WHERE start_date >= '{$thisyear}-{$thismonth}-01 00:00:00'
		AND start_date <= '{$thisyear}-{$thismonth}-{$last_day} 23:59:59'", ARRAY_N);
	if ( $dayswithevents ) {
		foreach ( (array) $dayswithevents as $daywith ) {
			$daywithevent[] = $daywith[0];
		}
	}

	// See how much we should pad in the beginning
	$pad = calendar_week_mod( date( 'w', $unixmonth ) - $week_begins );
	if ( 0 != $pad ) {
		$calendar_output .= "\n\t\t".'<td colspan="'. esc_attr( $pad ) .'" class="pad">&nbsp;</td>';
	}

	$newrow = false;
	$daysinmonth = (int) date( 't', $unixmonth );

	for ( $day = 1; $day <= $daysinmonth; ++$day ) {
		if ( isset( $newrow) && $newrow ) {
			$calendar_output .= "\n\t</tr>\n\t<tr class=\"cal\">\n\t\t";
		}
		$newrow = false;
		$class=array('ca-day');
		if ( $day == gmdate( 'j', $ts ) &&
			$thismonth == gmdate( 'm', $ts ) &&
			$thisyear == gmdate( 'Y', $ts ) ) {
			$class[]= "ca-chosen";

		} elseif(
		 	$day == gmdate( 'j', time() ) &&
			$thismonth == gmdate( 'm',  time() ) &&
			$thisyear == gmdate( 'Y',  time() ) )  {
			$class[]="ca-today";

		}
		$day_output='';
		if ( in_array( $day, $daywithevent ) )
		{

			$class[]="ca-event";
			$this_day=esc_sql( $thisyear.'-'.$thismonth.'-'.$day);
			if ( empty( $facilities_id) )  {$sql='SELECT a.*, b.* FROM '.CA_DATE_TBL.' a LEFT JOIN '.CA_CAT_TBL.' b ON a.cat_id=b.cat_id WHERE a.general_calendar=1  AND a.start_date="'.$this_day.'" ORDER BY a.start_time';}
	else{$sql='SELECT a.*, b.* FROM '.CA_DATE_TBL.' a LEFT JOIN '.CA_CAT_TBL.' b ON a.cat_id=b.cat_id WHERE a.facilities_id="'.esc_sql( $facilities_id).'"  AND a.start_date="'.$this_day.'" ORDER BY a.start_time';}
          
			$events=$wpdb->get_results( $sql);
			foreach( $events AS $event)
        	{
				$border=church_admin_adjust_brightness( $event->bgcolor, -50);
				$text=church_admin_adjust_brightness( $event->bgcolor, -100);
				if( $event->start_time=='00:00:00' && $event->end_time=='23:59:00')
    			{//all day
    				$day_output .=   '<div class="cal-item-detail"  id="item'.$event->date_id.'"style="background-color:'.$event->bgcolor.';border-left:3px solid '.$border.';padding:5px;color:'.$text.'" >'.__('All Day','church-admin').' '.esc_html( $event->title).'<br/>';
					
    			}
    			else
    			{
					$day_output .=  '<div class="cal-item-detail" id="item'.$event->date_id.'"style="background-color:'.$event->bgcolor.';border-left:3px solid '.$border.';padding:5px;color:'.$text.'" ><p>'.mysql2date(get_option('time_format'),$event->start_time).' '.esc_html( $event->title).'... </p>';

				}
				$day_output .= '<p><a class="button-secondary" href="'.wp_nonce_url('admin.php?page=church_admin/index.php&amp;action=single-event-edit&section=calendar&amp;event_id='.$event->event_id.'&amp;date_id='.$event->date_id,'single_event_edit').'">'.__('Edit','church-admin').'</a></p>';
				if( $event->recurring!='s'){$day_output .='<p><a class="button-secondary" href="'.wp_nonce_url('admin.php?page=church_admin/index.php&amp;action=series-event-edit&section=calendar&amp;event_id='.$event->event_id.'&amp;date_id='.$event->date_id,'series_event_edit').'">'.__('Edit Series','church-admin').'</a></p>';}
				$day_output .='<p><a class="button-secondary" href="'.wp_nonce_url('admin.php?page=church_admin/index.php&amp;action=single-event-delete&amp;event_id='.$event->event_id.'&amp;date_id='.$event->date_id,'single_event_delete').'">'.__('Delete this one','church-admin').'</a></p>';
				if( $event->recurring!='s'){$day_output .= '<p><a class="button-secondary" href="'.wp_nonce_url('admin.php?page=church_admin/index.php&amp;action=series-event-delete&amp;event_id='.$event->event_id.'&amp;date_id='.$event->date_id,'series_event_delete').'">'.__('Delete Series','church-admin').'</a></p>';}
				$day_output .='</div>';
            }
		}else{$class[]="ca-no-event";}
		$calendar_output .= '<td';
		if(!empty( $class) ) $calendar_output.=' class="'.implode(" ",$class).'"';
		$calendar_output.=' id="'.$thisyear.'-'.$thismonth.'-'.$day.'"';
		$calendar_output.='>'.$day.'<br />';
		$calendar_output.= $day_output.'</td>';

		if ( 6 == calendar_week_mod( date( 'w', mktime(0, 0 , 0, $thismonth, $day, $thisyear ) ) - $week_begins ) ) {
			$newrow = true;
		}
	}

	$pad = 7 - calendar_week_mod( date( 'w', mktime( 0, 0 , 0, $thismonth, $day, $thisyear ) ) - $week_begins );
	if ( $pad != 0 && $pad != 7 ) {
		$calendar_output .= "\n\t\t".'<td class="pad" colspan="'. esc_attr( $pad ) .'">&nbsp;</td>';
	}
	$calendar_output .= "\n\t</tr>\n\t</tbody>\n\t</table>";
	
	/*
	$calendar_output .= '<script type="text/javascript">	
		jQuery(document).ready(function( $) {$(".cal").bind("click", function(event) {
			window.location.href = "'.admin_url().'?page=church_admin/index.php&action=edit-calendar&section=calendar&id="+event.target.id';
			if(!empty( $facilities_id) )$calendar_output.= '+ "&facilities_id='.$facilities_id.'"';
	$calendar_output.= '});});</script>';
	*/

	echo  $calendar_output ;
}




function church_admin_category_list()
{
    global $wpdb;
    //build category tableheader
        $thead='<tr><th>'.__('Edit','church-admin').'</th><th>'.__('Delete','church-admin').'</th><th width="100">'.__('Category','church-admin').'</th><th>'.__('Shortcode','church-admin').'</th></tr>';
    $table= '<table class="widefat striped" ><thead>'.$thead.'</thead><tbody>';
        //grab categories
    $results=$wpdb->get_results('SELECT * FROM '.CA_CAT_TBL);
    foreach( $results AS $row)
    {
        $edit_url='<a href="'.wp_nonce_url('admin.php?page=church_admin/index.php&amp;action=edit-category&section=calendar&amp;id='.$row->cat_id,'edit_category').'">'.__('Edit','church-admin').'</a>';
        $delete_url='<a onclick="return confirm(\''.__('Are you sure?','church-admin').'\');" href="'.wp_nonce_url('admin.php?page=church_admin/index.php&amp;action=delete-category&section=calendar&amp;id='.$row->cat_id,'delete_category').'">'.__('Delete','church-admin').'</a>';
        $shortcode='[church_admin type=calendar-list category='.$row->cat_id.' weeks=4]';
        $table.='<tr><td>'.$edit_url.'</td><td>'.$delete_url.'</td><td style="background:'.esc_attr($row->bgcolor).'">'.esc_html( $row->category).'</td><td>'.$shortcode.'</td></tr>';
    }
    $table.='</tbody><tfoot>'.$thead.'</tfoot></table>';
    echo '<h2>'.__('Calendar Categories','church-admin').'</h2><p><a href="'.wp_nonce_url('admin.php?page=church_admin/index.php&amp;action=edit-category&section=calendar','edit_category').'">'.__('Add a category','church-admin').'</a></p>'.$table;
}



function church_admin_delete_category( $id)
{
    global $wpdb;

    //count how many events have that category
    $count=$wpdb->get_var('SELECT COUNT(*) FROM '.CA_DATE_TBL.' WHERE cat_id="'.esc_sql( $id).'"');
    $wpdb->query('DELETE FROM '.CA_CAT_TBL.' WHERE cat_id="'.esc_sql( $id).'"');
    //adjust events with deleted cat_id to 0
    $wpdb->query('UPDATE '.CA_DATE_TBL.' SET cat_id="1" WHERE cat_id="'.esc_sql( $id).'"');
    echo '<div id="message" class="notice notice-success inline">';
        echo '<p><strong>'.__('Category Deleted','church-admin').'.<br />';
        if( $count==1) printf(__('Please note that %1$s event used that category and will need editing','church-admin'),$count).'.';
        if( $count>1) printf(__('Please note that %1$s events used that category and will need editing','church-admin'),$count).'.';
        echo'</strong></p>';
        echo '</div>';
        church_admin_category_list();


}

function church_admin_edit_category( $id)
{
    global $wpdb;
    if(!empty( $_POST) )
    {
        if(!empty( $id) )
        {
        	$wpdb->query('UPDATE '.CA_CAT_TBL.' SET category="'.esc_sql(sanitize_text_field( $_POST['category'] ) ).'",bgcolor="'.esc_sql( $_POST['color'] ).'" WHERE cat_id="'.esc_sql( $id).'"');
        }
        else
        {
        	$wpdb->query('INSERT INTO '.CA_CAT_TBL.' (category,bgcolor) VALUES("'.esc_sql(sanitize_text_field( $_POST['category'] ) ).'","'.esc_sql( $_POST['color'] ).'")');        }
        echo '<div id="message" class="notice notice-success inline">';
        if( $id)  {echo '<p><strong>'.__('Category Edited','church-admin').'</strong></p>';}else{echo '<p><strong>'.__('Category Added','church-admin').'</strong></p>';}
        echo '</div>';
        church_admin_category_list();
    }
    else
    {
    if ( empty( $id) )  {$which=__("Add category",'church-admin');}else{$which=__('Edit','church-admin');}
    echo'<h2>'.$which.'</h2><form action="" method="post"><table class="form-table">';
    //grab current data
    $data=$wpdb->get_row('SELECT * FROM '.CA_CAT_TBL.' WHERE cat_id="'.esc_sql( $id).'"');
    if ( empty( $data) )$data=new stdClass();

    if ( empty( $data->bgcolor) )$data->bgcolor='#e4afb1';
	echo '<script type="text/javascript" >
  jQuery(document).ready(function( $) {

    $(\'#picker\').farbtastic(\'#color\');


  });
 </script>
 <tr><th scope="row" >'.__('Category Name','church-admin').'</th><td><input type="text" name="category" ';
 if(!empty( $data->category) ) echo 'value="'.esc_html( $data->category).'"';
	echo'/></td></tr>';
 echo'<tr><th scope="row">'.__('Background Colour','church-admin').'</th><td><input type="text" ';
  if(!empty( $data->bgcolor) ) echo' style="background:'.esc_html( $data->bgcolor).'" ';
  echo' id="color" name="color" ';
  if(!empty( $data->bgcolor) )echo' value="'.esc_html( $data->bgcolor).'" ';
  echo'/><br /><div id="picker"></div></td></tr>';
    echo'<tr><th scope="row">&nbsp;</th><td><input type="submit" class="button-primary" name="edit_category" value="'.$which.'"/></p></form>';

    echo'</table>';
    }
}


function church_admin_calendar()
{
    global $wpdb;
    echo'<div class="wrap church_admin"><h2>'.__('Calendar','church-admin').'</h2><p><a href="admin.php?page=church_admin/index.php&amp;action=category-list">'.__('Category List','church-admin').'</a></p>';
    church_admin_calendar_list();
    echo'</div>';
}


 /**
 *
 * Edit an event
 *
 * @author  Andy Moyle
 * @param    $date_id,$event_id,$edit_type,$date,$facilities_id
 * @return
 * @version  0.1
 *
 *
 *
 */
function church_admin_event_edit( $date_id,$event_id,$edit_type,$date,$facilities_id)
{

	global $wpdb;
    $wpdb->show_errors();
	$edit=''.__('Add','church-admin').'';
	if(!empty( $date_id) )
	{
		$data=$wpdb->get_row('SELECT a.*,b.* FROM '.CA_DATE_TBL.' a LEFT JOIN '.CA_CAT_TBL.' b ON a.cat_id=b.cat_id WHERE a.date_id="'.esc_sql( $date_id).'"');
		$edit=''.__('Edit','church-admin').'';
	}
	/********************************************
	 * Correct Title
	 *******************************************/
	$title=__('Add calendar event','church-admin');
	if(!empty($date_id))
	{
		switch($edit_type)
		{
			case 'single':
				$title = __('Edit single event','church-admin' );
			break;
			case 'series':
				$title = __('Edit whole series','church-admin' );
			break;
		}
	}
	if(!empty($facilities_id))
	{
		switch($edit_type)
		{
			case 'single':
				$title = __('Edit single facility booking','church-admin' );
			break;
			case 'series':
				$title = __('Edit whole series facility booking','church-admin' );
			break;
		}
	}
	echo '<h2>'.esc_html($title).'</h2>';

	/********************************************
	 * Process save
	 *******************************************/
	if(!empty( $_POST['save_date'] ) )
	{//process
        if(defined('CA_DEBUG') )church_admin_debug("***************\r\nfunction church_admin_event_edit ".date('Y-m-d H:i:s') );
		if(defined('CA_DEBUG') )church_admin_debug(print_r( $_POST,TRUE) );
		switch( $edit_type)
		{
			case'single':
				if(!empty( $date_id) )  {
					$wpdb->query('DELETE FROM '.CA_DATE_TBL .' WHERE date_id="'.esc_sql( $date_id).'"');
					$recurring='s';
				}
			break;
			case'series':
				if(!empty( $event_id) )  {
					$recurring=$wpdb->get_var('SELECT recurring FROM '.CA_DATE_TBL .' WHERE event_id="'.esc_sql( $event_id).'" AND start_date>="'.esc_sql( $_POST['start_date'] ).'" LIMIT 1');
					$wpdb->query('DELETE FROM '.CA_DATE_TBL .' WHERE event_id="'.esc_sql( $event_id).'" AND start_date>="'.esc_sql( $_POST['start_date'] ).'"');
				
				}
			break;

		}
		
		//get next highest event_id
		$event_id=$wpdb->get_var('SELECT MAX(event_id) FROM '.CA_DATE_TBL)+1;
		$form=array();
		foreach( $_POST AS $key=>$value)$form[$key]=sanitize_text_field( $value) ;
		//adjust data
		$form['start_time'].=':00';
		$form['end_time'].=':00';
		if(!empty( $form['all_day'] ) )  {$form['start_time']='00:00:00'; $form['end_time']='23:59:00';}
		if ( empty( $form['cat_id'] ) )  {$form['cat_id']=1;}
		if ( empty( $form['year_planner'] ) )  {$form['year_planner']=0;}else{$form['year_planner']=1;}
		if ( empty( $form['general_calendar'] ) )  {$form['general_calendar']=0;}else{$form['general_calendar']=1;}
		if ( empty( $form['end_date'] ) )  {$form['end_date']=$form['start_date'];}
        if(!empty( $form['how_many'] )&& $form['how_many']>365)$form['how_many']=365;
		//text link overrides dropdown menu
		$form['link']='';
		if(!empty( $form['link2'] ) )  {$form['link']=$form['link2'];}
		if(!empty( $form['link1'] ) )  {$form['link']=$form['link1'];}
		//only allow one submit!
		$checksql='SELECT date_id FROM '.CA_DATE_TBL.' WHERE title="'.esc_sql( $form['title'] ).'" AND description="'.esc_sql( $form['description'] ).'" AND location="'.esc_sql( $form['location'] ).'"  AND cat_id="'.esc_sql( $form['cat_id'] ).'" AND start_date="'.esc_sql( $form['start_date'] ).'" AND start_time="'.esc_sql( $form['start_time'] ).'" AND end_time="'.esc_sql( $form['end_time'] ).'" AND facilities_id="'.esc_sql( $form['facilities_id'] ).'" LIMIT 1';
		$eventType = 'calendar';
		$check=$wpdb->get_var( $checksql);
		if ( empty( $check)||!empty( $date_id) )
		{
			$form['event_image']=!(empty($_POST['attachment_id']))?(int)$_POST['attachment_id']:null;
			//if ( empty( $recurring) )$recurring=$_POST['recurring'];
			if ( empty( $form['facilities_id'] ) )$form['facilities_id']=0;
			
			switch( $form['recurring'] )
			{
				
				case 's':
					$values[]='("'.esc_sql( $form['title'] ).'","'.esc_sql( $form['description'] ).'","'.esc_sql( $form['location'] ).'","'.esc_sql( $form['start_date'] ).'","'.esc_sql( $form['start_time'] ).'","'.esc_sql( $form['end_time'] ).'","'.(int)$form['cat_id'].'","'.(int)$event_id.'","s","1","1","'.esc_sql( $eventType).'","'.esc_sql($form['link']).'","'.esc_sql($form['link_title']).'")';
				break;
				case '1':
					//daily
					for ( $x=0; $x<$form['how_many']; $x++)
					{
						$start_date=date('Y-m-d',strtotime("{$form['start_date']}+$x day") );
						$values[]='("'.esc_sql( $form['title'] ).'","'.esc_sql( $form['description'] ).'","'.esc_sql( $form['location'] ).'","'.esc_sql( $start_date).'","'.esc_sql( $form['start_time'] ).'","'.esc_sql( $form['end_time'] ).'","'.(int)$form['cat_id'].'","'.(int)$event_id.'","1","'.(int)$form['how_many'].'","1","'.esc_sql( $eventType).'","'.esc_sql($form['link']).'","'.esc_sql($form['link_title']).'")';
					}
				break;
				case '7':
					//weekly
					for ( $x=0; $x<$form['how_many']; $x++)
					{
						$start_date=date('Y-m-d',strtotime("{$form['start_date']}+$x week") );
						$values[]='("'.esc_sql( $form['title'] ).'","'.esc_sql( $form['description'] ).'","'.esc_sql( $form['location'] ).'","'.$start_date.'","'.$form['start_time'].'","'.esc_sql( $form['end_time'] ).'","'.(int)$form['cat_id'].'","'.(int)$event_id.'","7","'.(int)$form['how_many'].'","1","'.esc_sql( $eventType).'","'.esc_sql($form['link']).'","'.esc_sql($form['link_title']).'")';	
					}
				break;
				case '14':
					//fortnightly
					for ( $x=0; $x<$form['how_many']; $x++)
					{
						$start_date=date('Y-m-d',strtotime("{$form['start_date']} + $x fortnight") );
						$values[]='("'.esc_sql( $form['title'] ).'","'.esc_sql( $form['description'] ).'","'.esc_sql( $form['location'] ).'","'.$start_date.'","'.$form['start_time'].'","'.esc_sql( $form['end_time'] ).'","'.(int)$form['cat_id'].'","'.(int)$event_id.'","14","'.(int)$form['how_many'].'","1","'.esc_sql( $eventType).'","'.esc_sql($form['link']).'","'.esc_sql($form['link_title']).'")';	
					}
				break;
				case'm':
					//monthly
					for ( $x=0; $x<$form['how_many']; $x++)
					{
						$start_date=date('Y-m-d',strtotime("{$form['start_date']}+$x month") );
						$values[]='("'.esc_sql( $form['title'] ).'","'.esc_sql( $form['description'] ).'","'.esc_sql( $form['location'] ).'","'.$start_date.'","'.$form['start_time'].'","'.esc_sql( $form['end_time'] ).'","'.(int)$form['cat_id'].'","'.(int)$event_id.'","m","'.(int)$form['how_many'].'","1","'.esc_sql( $eventType).'","'.esc_sql($form['link']).'","'.esc_sql($form['link_title']).'")';	
					}

				break;
				case 'q':
					for ( $x=0; $x<$form['how_many']; $x++)
					{
						$y=$x*84;
						$start_date=date('Y-m-d',strtotime("{$form['start_date']}+$y day") );
						$values[]='("'.esc_sql( $form['title'] ).'","'.esc_sql( $form['description'] ).'","'.esc_sql( $form['location'] ).'","'.$start_date.'","'.$form['start_time'].'","'.esc_sql( $form['end_time'] ).'","'.(int)$form['cat_id'].'","'.(int)$event_id.'","m","'.(int)$form['how_many'].'","1","'.esc_sql( $eventType).'","'.esc_sql($form['link']).'","'.esc_sql($form['link_title']).'")';	
					}

				break;
				case'a':
					//annually
					for ( $x=0; $x<$form['how_many']; $x++)
					{
						$start_date=date('Y-m-d',strtotime("{$form['start_date']}+$x year") );
						$values[]='("'.esc_sql( $form['title'] ).'","'.esc_sql( $form['description'] ).'","'.esc_sql( $form['location'] ).'","'.$start_date.'","'.$form['start_time'].'","'.esc_sql( $form['end_time'] ).'","'.(int)$form['cat_id'].'","'.(int)$event_id.'","a","'.(int)$form['how_many'].'","1","'.esc_sql( $eventType).'","'.esc_sql($form['link']).'","'.esc_sql($form['link_title']).'")';	
					}

				break;
				
				default:
					//nth day
					$type=substr( $form['recurring'],0,1);//whether l or r
					$nth=substr( $form['recurring'],1,1);
					
					$day=substr( $form['recurring'],2,1);
					church_admin_debug($form['recurring']);
					church_admin_debug("Nth day type = $type n = $nth and day = $day");
					$formdate=mysql2date('Y-m-01',$form['start_date']);//needs to be 1st of month to safely add one month each iteration
					for ( $x=0; $x<$form['how_many']; $x++)
					{
						
						$date=new DateTime( $formdate );
						$date->modify("+ $x month");
						if($type=='l'){
							$days=array(0=>'Sunday',1=>"Monday",2=>"Tuesday",3=>"Wednesday",4=>"Thursday",5=>"Friday",6=>"Saturday");
							$start_date=date('Y-m-d',strtotime("last $days[$day]",$date->format('U')));
						}
						else{
							$start_date=church_admin_nth_day( $nth,$day,$date->format('Y-m-d') );
						}
						//church_admin_debug("Start date $start_date");
						if(!empty($start_date)){
							$values[]='("'.esc_sql( $form['title'] ).'","'.esc_sql( $form['description'] ).'","'.esc_sql( $form['location'] ).'","'.$start_date.'","'.$form['start_time'].'","'.esc_sql( $form['end_time'] ).'","'.(int)$form['cat_id'].'","'.(int)$event_id.'","'.esc_sql( $form['recurring'] ).'","'.(int)$form['how_many'].'","1","'.esc_sql( $eventType).'","'.esc_sql($form['link']).'","'.esc_sql($form['link_title']).'")';
						}
					}
				break;
			}
			if( !empty( $values ) ){
				$sql='INSERT INTO '.CA_DATE_TBL.' (title,description,location,start_date,start_time,end_time,cat_id,event_id,recurring,how_many,general_calendar,event_type,link,link_title) VALUES '.implode(",",$values);
				church_admin_debug( $sql);
				if( $wpdb->query( $sql) )
				{
					echo'<div class="notice notice-success inline"><p><strong>'.__('Date(s) saved','church-admin').'</strong></p></div>';
				}
				else
				{
					echo  '<div class="notice notice-success inline"><h2>ERROR</h2>'.esc_html($wpdb->last_query).'</div>';
				}

			}
			else
			{
				echo  '<div class="notice notice-success inline"><h2>ERROR</h2>'.__('An issue occurred with your chosen dates, please try again','church-admin').'</div>';
			}
			
			
			
		}
		else{echo'<div class="notice notice-success inline"><p><strong>'.__('Date(s) already saved','church-admin').'</strong></p></div>';}
		church_admin_new_calendar(strtotime( $form['start_date'] ),$facilities_id);
	}//end process
	else
	{
		/********************************************
		 * Form
		 *******************************************/


		echo'<form action="" enctype="multipart/form-data" id="calendar" method="post">';
		echo'<table class="form-table">';
		if ( empty( $error) )$error =new stdClass();
		if ( empty( $data) ) $data = new stdClass();
		if(!empty( $data->event_id) )
		{
			$multi=$wpdb->get_var('SELECT COUNT(*) FROM '.CA_DATE_TBL.' WHERE event_id="'.esc_sql( $data->event_id).'"');
			if( $multi>1)
			{
				echo'<tr><th scope=row>'.__('Single or Series Edit?','church-admin').'</th><td><input type="radio" name="edit_type" class="single_edit" value="single" /> '.__('Single or ','church-admin').'<input checked="checked" type="radio" name="edit_type" class="series_edit" value="series"/> '.esc_html(__('Series','church-admin')).'</td></tr>';
				if(!empty( $data->event_id) )echo '<tr><th scope="row">&nbsp;</th><td><a class="button" href="'.esc_url(wp_nonce_url('admin.php?page=church_admin/index.php&amp;action=series-event-delete&section=calendar&section=calendar&amp;event_id='.$data->event_id.'&amp;date_id='.$data->date_id,'series_event_delete')).'">'.esc_html(__('Delete this series event','church-admin')).'</a></td></tr>';
			}
		}
		if(!empty( $data->date_id) )echo '<tr><th scope="row">&nbsp;</th><td><a  class="button" href="'.esc_url(wp_nonce_url('admin.php?page=church_admin/index.php&amp;action=single-event-delete&section=calendar&amp;event_id='.$data->event_id.'&amp;date_id='.$data->date_id,'single_event_delete')).'">'.esc_html(__('Delete this single event','church-admin')).'</a></td></tr>';
		echo church_admin_calendar_form( $data,$error,1,$date,$facilities_id);
		echo '<tr><th scope="row">&nbsp;</th><td><input type="submit" class="button-primary" name="edit_event" value="'.esc_html(__('Save Event','church-admin')).'"/></td></tr></table></form>';



		}

}

function church_admin_calendar_form( $data,$error,$recurring,$date,$facilities_id)
{
	global $wpdb;
	if ( empty( $data) ) $data=new stdClass();
    $out='';
	
	/*****************************************
	*
	* Event Title	
	*
	******************************************/
	$out.='<div class="church-admin-form-group"><label>'.__('Event Title','church-admin').'</label><input class="church-admin-form-control" type="text" name="title" ';
		if(!empty( $data->title) )$out.=' value="'.esc_html( $data->title).'" ';
		if(!empty( $error->title) )$out.=esc_html($error->title);
	$out.=' /></div>';
	/*****************************************
	*
	* Event Photo	
	*
	******************************************/
	$out.='<h3>'.esc_html( __( 'Photo','church-admin') ).'</h3><div class="church-admin-form-group"><label>';
		if(!empty( $data->event_image) )
		{
			$out.=wp_get_attachment_image( $data->event_image,'medium','', array('class'=>"current-photo",'id'=>"calendar-frontend-image") );

		}
		else
		{
			$out.= '<img src="'.esc_url(plugins_url('/images/default-avatar.jpg',dirname(__FILE__) )).'" width="300" height="200" id="calendar-frontend-image"  alt="'.esc_html( __( 'Photo of Person','church-admin') ).'"  />';
		}
        $out.='</label>';
		if(is_admin() )
		{//on admin page so use media library
			$out.='<button id="household-image"  class=" button-secondary calendar-upload-button button" >'.esc_html( __( 'Upload Image','church-admin') ).'</button>';

		}else
		{//on front end so use boring update
			$out.='<input type="file" id="file-chooser" class="file-chooser" name="logo" style="display:none;"/><input type="button" id="calendar_image" class="calendar-frontend-button" value="'.esc_html( __( 'Upload Photo','church-admin') ).'" />';
    	}
	    $out.='<input type="hidden" name="attachment_id" class="attachment_id" id="calendar_attachment_id" ';
    	if(!empty( $data->event_image) )$out.=' value="'.(int)$data->event_image.'" ';
    	$out.='/><span id="calendar-upload-message"></span>';
    	$out.='</div>';
	$out.='<script>var mediaUploader;
		jQuery(document).ready(function($){
	$(".calendar-upload-button").click(function(e) {
	  e.preventDefault();
	  var id="#calendar_attachment_id";
	  console.log(id);
	  // If the uploader object has already been created, reopen the dialog
		if (mediaUploader) {
		mediaUploader.open();
		return;
	  }
	  // Extend the wp.media object
	  mediaUploader = wp.media.frames.file_frame = wp.media({
		title: "Choose Image",
		button: {
		text: "Choose Image"
	  }, multiple: false });
  
	  // When a file is selected, grab the URL and set it as the text fields value
	  mediaUploader.on("select", function() {
		var attachment = mediaUploader.state().get("selection").first().toJSON();
		console.log(attachment);
		$(id).val(attachment.id);
		if(attachment.sizes.medium.url)
		{
		  $("#calendar-frontend-image").attr("src",attachment.sizes.medium.url);
		}
		else{$("#calendar-frontend-image").attr("src",attachment.sizes.thumbnail.url);}
		$("#calendar-frontend-image").attr("srcset",null);
	  });
	  // Open the uploader dialog
	  mediaUploader.open();
	});
	});
  </script>';
	/*
	$out.='<div class="church-admin-form-group"><label>'.__('Photo','church-admin').'</label><input type="file" id="photo" name="uploadfiles" size="35" class="uploadfiles" /></div>';
	
	if(!empty( $data->event_image) )
		{//photo available
			$out.= '<div class="church-admin-form-group"><label>'.__('Current Photo','church-admin').'</label>';
			$out.= wp_get_attachment_image( $data->event_image,'ca-people-thumb' );
			
		}//photo available
		else
		{
			$out.= '<div class="church-admin-form-group"><label>'.__('Default','church-admin').'</label>';
			$out.= '<img src="'.plugins_url('images/default-avatar.jpg',dirname(__FILE__) ) .'" width="75" height="75"/>';
			
		}
	$out.='</div>';
		*/
	/*****************************************
	*
	* Event Description		
	*
	******************************************/
	
	$out.='<div class="church-admin-form-group"><label>'.esc_html(__('Event Description','church-admin')).'</label><textarea class="church-admin-form-control" rows="5" cols="50" name="description" ';
	if(!empty( $error->description) )$out.=esc_html($error->description);
	$out.='>';
	if(!empty( $data->description) )$out.=wp_kses_post( $data->description);
	$out.='</textarea></label>';
	/*****************************************
	*
	* Event Location		
	*
	******************************************/
	$out.='<div class="church-admin-form-group"><label>'.esc_html(__('Event Location','church-admin')).'</label><textarea class="church-admin-form-control" rows="5" cols="50" name="location" ';
	if(!empty( $error->location) )$out.=$error->location;
	$out.='>';
	if(!empty( $data->location) )$out.=sanitize_text_field( $data->location);
	$out.='</textarea></div>';
	/*****************************************
	*
	* Facilities		
	*
	******************************************/
	
	$out.='<div class="church-admin-form-group"><label>'.__('Facility/Room','church-admin').'</label><select class="church-admin-form-control" name="facilities_id"> <option value="">'.__('Optional choose facility...').'</option>';
	if(!empty( $data->facilities_id) )$facilities_id=(int)$data->facilities_id;
	$facs=$wpdb->get_results('SELECT * FROM '.CA_FAC_TBL.' ORDER BY facilities_order');
	if(!empty( $facs) )
	{
		foreach( $facs AS $fac)  {$out.='<option value="'.esc_attr($fac->facilities_id).'" '.selected( $facilities_id,$fac->facilities_id,FALSE).'>'.esc_html($fac->facility_name).'</option>';}

	}
	$out.='</select></div>';
	/*****************************************
	*
	* Category		
	*
	******************************************/	
	$out.='<div class="church-admin-form-group"><label> '.esc_html(__('Category','church-admin')).'</label><select class="church-admin-form-control" name="cat_id" ';
	if(!empty( $error->category) ) $out.=$error->category;
	$out.=' >';
	$select='';
	$first='<option value="">'.esc_html(__('Please select','church-admin')).'...</option>';
	$sql="SELECT * FROM ".$wpdb->prefix."church_admin_calendar_category";
	$result3=$wpdb->get_results( $sql);
	foreach( $result3 AS $row)
	{
    	if(!empty( $data->cat_id)&&$data->cat_id==$row->cat_id)
    	{
			$first='<option value="'.(int)$data->cat_id.'" style="background:'.esc_html( $data->bgcolor).'" selected="selected">'.esc_html( $data->category).'</option>';
    	}
    	else
    	{
        	$select.='<option value="'.(int)$row->cat_id.'" style="background:'.esc_html( $row->bgcolor).'">'.esc_html( $row->category).'</option>';
    	}
	}
	$out.=$first.$select;//have original value first!
	$out.='</select></div>';
	/*****************************************
	*
	* Start Date		
	*
	******************************************/		
	if(!empty( $data->recurring) )
	{
		$startDate=$wpdb->get_var('SELECT start_date FROM '.CA_DATE_TBL.' WHERE event_id="'.intval( $data->event_id).'" ORDER BY start_date ASC LIMIT 1');
		$out.='<p>'.esc_html(sprintf(__('The first date of series is %1$s, use that for "Start Date" if editing the whole series','church-admin'),mysql2date(get_option('date_format'),$startDate) )).'</p>';
		$recurring = $data->recurring;
	}else{
		$recurring='s';
	}
	$out.='<div class="church-admin-form-group"><label>'.__('Start Date','church-admin').'</label>';
	if(!empty( $data->start_date) )  {$start_date=$data->start_date;}
	elseif(!empty( $date) )  {$start_date=$date;}
	else{$start_date=NULL;}
	$endDate=date('Y-m-d',strtotime("+20 years") );
	$out.=church_admin_date_picker( $start_date,'start_date',FALSE,$start_date,$endDate,NULL,'start_date');
	$out.='</div>';
	/*****************************************
	*
	* Recurring	
	*
	******************************************/	
	//if( $type=='single')$recurring='s';
	$out .= '<div class="church-admin-form-group"><label>'.__('Recurring','church-admin').'</label>';
	$out .= '<select id="recurring" name="recurring" class="church-admin-form-control">';
	$out .= '<option value="s" '.selected( $recurring,"s",FALSE).'>'.__('Single','church-admin').'</option>';
	$out .= '<option value="1" '.selected( $recurring,1,FALSE).'>'.__('Daily','church-admin').'</option>';
	$out .= '<option value="7" '.selected( $recurring,7,FALSE).'>'.__('Weekly','church-admin').'</option>';
	$out .= '<option value="14" '.selected( $recurring,14,FALSE).'>'.__('Fortnightly','church-admin').'</option>';
	$out .= '<option value="m" '.selected( $recurring,"m",FALSE).'>'.__('Monthly on same date','church-admin').'</option>';
	$out .= '<option value="q" '.selected( $recurring,"q",FALSE).'>'.__('Quarterly (every84 days)','church-admin').'</option>';
	$out .= '<option value="a" '.selected( $recurring,"a",FALSE).'>'.__('Annually on same date','church-admin').'</option>';
	$out .= '<option value="n10" '.selected( $recurring,"n10",FALSE).'>'.__('1st Sunday','church-admin').'</option>';
	$out .= '<option value="n20" '.selected( $recurring,"n20",FALSE).'>'.__('2nd Sunday','church-admin').'</option>';
	$out .= '<option value="n30" '.selected( $recurring,"n30",FALSE).'>'.__('3rd Sunday','church-admin').'</option>';
	$out .= '<option value="n40" '.selected( $recurring,"n40",FALSE).'>'.__('4th Sunday','church-admin').'</option>';
	$out .= '<option value="n50" '.selected( $recurring,"n50",FALSE).'>'.__('5th Sunday','church-admin').'</option>';
	$out .= '<option value="l00" '.selected( $recurring,"l0",FALSE).'>'.__('Last Sunday','church-admin').'</option>';

	$out .= '<option value="n11" '.selected( $recurring,"n11",FALSE).'>'.__('1st Monday','church-admin').'</option>';
	$out .= '<option value="n21" '.selected( $recurring,"n21",FALSE).'>'.__('2nd Monday','church-admin').'</option>';
	$out .= '<option value="n31" '.selected( $recurring,"n31",FALSE).'>'.__('3rd Monday','church-admin').'</option>';
	$out .= '<option value="n41" '.selected( $recurring,"n41",FALSE).'>'.__('4th Monday','church-admin').'</option>';
	$out .= '<option value="n51" '.selected( $recurring,"n51",FALSE).'>'.__('5th Monday','church-admin').'</option>';
	$out .= '<option value="l11" '.selected( $recurring,"l1",FALSE).'>'.__('Last Monday','church-admin').'</option>';

	$out .= '<option value="n12" '.selected( $recurring,"n12",FALSE).'>'.__('1st Tuesday','church-admin').'</option>';
	$out .= '<option value="n22" '.selected( $recurring,"n22",FALSE).'>'.__('2nd Tuesday','church-admin').'</option>';
	$out .= '<option value="n32" '.selected( $recurring,"n32",FALSE).'>'.__('3rd Tuesday','church-admin').'</option>';
	$out .= '<option value="n42" '.selected( $recurring,"n42",FALSE).'>'.__('4th Tuesday','church-admin').'</option>';
	$out .= '<option value="n52" '.selected( $recurring,"n52",FALSE).'>'.__('5th Tuesday','church-admin').'</option>';
	$out .= '<option value="l22" '.selected( $recurring,"l2",FALSE).'>'.__('Last Tuesday','church-admin').'</option>';

	$out .= '<option value="n13" '.selected( $recurring,"n13",FALSE).'>'.__('1st Wednesday','church-admin').'</option>';
	$out .= '<option value="n23" '.selected( $recurring,"n23",FALSE).'>'.__('2nd Wednesday','church-admin').'</option>';
	$out .= '<option value="n33" '.selected( $recurring,"n33",FALSE).'>'.__('3rd Wednesday','church-admin').'</option>';
	$out .= '<option value="n43" '.selected( $recurring,"n43",FALSE).'>'.__('4th Wednesday','church-admin').'</option>';
	$out .= '<option value="n53" '.selected( $recurring,"n53",FALSE).'>'.__('5th Wednesday','church-admin').'</option>';
	$out .= '<option value="l33" '.selected( $recurring,"l3",FALSE).'>'.__('Last Wednesday','church-admin').'</option>';

	$out .= '<option value="n14" '.selected( $recurring,"n14",FALSE).'>'.__('1st Thursday','church-admin').'</option>';
	$out .= '<option value="n24" '.selected( $recurring,"n24",FALSE).'>'.__('2nd Thursday','church-admin').'</option>';
	$out .= '<option value="n34" '.selected( $recurring,"n34",FALSE).'>'.__('3rd Thursday','church-admin').'</option>';
	$out .= '<option value="n44" '.selected( $recurring,"n44",FALSE).'>'.__('4th Thursday','church-admin').'</option>';
	$out .= '<option value="n54" '.selected( $recurring,"n54",FALSE).'>'.__('5th Thursday','church-admin').'</option>';
	$out .= '<option value="l44" '.selected( $recurring,"l5",FALSE).'>'.__('Last Thursday','church-admin').'</option>';

	$out .= '<option value="n15" '.selected( $recurring,"n14",FALSE).'>'.__('1st Friday','church-admin').'</option>';
	$out .= '<option value="n25" '.selected( $recurring,"n24",FALSE).'>'.__('2nd Friday','church-admin').'</option>';
	$out .= '<option value="n35" '.selected( $recurring,"n34",FALSE).'>'.__('3rd Friday','church-admin').'</option>';
	$out .= '<option value="n45" '.selected( $recurring,"n44",FALSE).'>'.__('4th Friday','church-admin').'</option>';
	$out .= '<option value="n55" '.selected( $recurring,"n44",FALSE).'>'.__('5th Friday','church-admin').'</option>';
	$out .= '<option value="l55" '.selected( $recurring,"l5",FALSE).'>'.__('Last Friday','church-admin').'</option>';


	$out .= '<option value="n16" '.selected( $recurring,"n16",FALSE).'>'.__('1st Saturday','church-admin').'</option>';
	$out .= '<option value="n26" '.selected( $recurring,"n26",FALSE).'>'.__('2nd Saturday','church-admin').'</option>';
	$out .= '<option value="n36" '.selected( $recurring,"n36",FALSE).'>'.__('3rd Saturday','church-admin').'</option>';
	$out .= '<option value="n46" '.selected( $recurring,"n46",FALSE).'>'.__('4th Saturday','church-admin').'</option>';
	$out .= '<option value="n56" '.selected( $recurring,"n56",FALSE).'>'.__('5th Friday','church-admin').'</option>';
	$out .= '<option value="l66" '.selected( $recurring,"l6",FALSE).'>'.__('Last Friday','church-admin').'</option>';

	$out .= '</select></div>';	
	$out.='<div class="church-admin-form-group"><label>'.__('How many times in all? (Max 365)','church-admin').'</label><input type="number" min=1 max=365 required="required" class="church-admin-form-control" name="how_many" ';
	if(!empty( $error->how_many) ) $out.=esc_html($error->how_many);
	if(!empty( $data->how_many) )  {$out.=' value="'.esc_attr($data->how_many).'"';}else{$out.='   value="1" ';}
	$out.='/></div>';

    /*
		$out.='<tr class="recurring-row"><th scope="row">'.__('Recurring','church-admin').'</th><td><select class="recurring-item" name="recurring" ';
		if(!empty( $error->recurring) )$out.=$error->recurring;
		$out.=' id="recurring">';
		if(!empty( $data->recurring) )
		{
			$option=array('s'=>__('Once','church-admin'),'1'=>__('Daily','church-admin'),'7'=>__('Weekly','church-admin'),'n'=>__('nth day eg.1st Friday','church-admin'),'m'=>__('Monthly','church-admin'),'a'=>__('Annually','church-admin'),'14'=>__("Fortnightly",'church-admin') );
			$out.= '<option value="'.$data->recurring.'">'.$option[$data->recurring].'</option>';
		}
		$out.='<option value="s">'.__('Once','church-admin').'</option><option value="1">'.__('Daily','church-admin').'</option><option value="7">'.__('Weekly','church-admin').'</option><option value="14">'.__('Fortnightly','church-admin').'</option><option value="n">'.__('nth day (eg 1st Friday)','church-admin').'</option><option value="m">'.__('Monthly on same date','church-admin').'</option><option value="a">'.__('Annually','church-admin').'</option></select></td></tr>';
		$out.='<tr  class="recurring-row" id="nth" ';
		if(!empty( $data->recurring)&&$data->recurring=='n')  {$out.='';}else{$out.='style="display:none"';}
		$out.='><th scope="row">'.__('Recurring on','church-admin').' </th><td><select class="recurring-item"';
		if(!empty( $error->nth) )$out.=$error->nth; $out.=' name="nth">';
		if(!empty( $data->nth) ) $out.='<option value="'.$data->nth.'">'.$data->nth.'</option>';
		$out.='<option value="1">'.__('1st','church-admin').'</option><option value="2">'.__('2nd','church-admin').'</option><option value="3">'.__('3rd','church-admin').'</option><option value="4">'.__('4th','church-admin').'</option><option value="5">'.__('5th','church-admin').'</option><option value="'.__('Last','church-admin').'">'.__('Last').'</option></select>&nbsp;<select name="day"><option value="0">'.__('Sunday','church-admin').'</option><option value="1">'.__('Monday','church-admin').'</option><option value="2">'.__('Tuesday','church-admin').'</option><option value="3">'.__('Wednesday','church-admin').'</option><option value="4">'.__('Thursday','church-admin').'</option><option value="5">'.__('Friday','church-admin').'</option><option value="6">'.__('Saturday','church-admin').'</option></select></td></tr>';

		$out.='<tr  class="recurring-row" id="howmany"';
		if(!empty( $data->recurring) && $data->recurring!='s')  {$out.='';}else{$out.='style="display:none"';}
		
	
    	$out.='<input class="single-item" disabled="disabled" type="hidden" name="recurring" value="s"/>';
	*/
	/*****************************************
	*
	* Start Time	
	*
	******************************************/
	if(!empty( $data->start_time) )$data->start_time=substr( $data->start_time,0,5);//remove seconds
	if(!empty( $data->end_time) )$data->end_time=substr( $data->end_time,0,5);//remove seconds
	$out.='<div class="church-admin-form-group"><label>'.esc_html(__('Start Time of form HH:MM','church-admin')).'</label><input class="church-admin-form-control" type="time" name="start_time" ';
	if(!empty( $error->start_time) )$out.=$error->start_time;
	if(!empty( $data->start_time) )$out.=' value="'.esc_attr($data->start_time).'"';
	$out.='/></div>';
	/*****************************************
	*
	* End Time	
	*
	******************************************/
	$out.='<div class="church-admin-form-group"><label>'.__('End Time of form HH:MM','church-admin').'</label><input class="church-admin-form-control" type="time" name="end_time" ';
	if(!empty( $error->end_time) ) $out.=$error->end_time;
	if(!empty( $data->end_time) )$out.=' value="'.esc_attr($data->end_time).'" ';
	$out.='/></div>';
	/*****************************************
	*
	* All day	
	*
	******************************************/
	$out.='<div class="church-admin-form-check"><input type="checkbox" name="all_day" ';
	if(!empty( $data->start_time)&&$data->start_time='00:00' &&!empty( $data->end_time)&&$data->end_time=='23:59')$out.=' checked="checked" ';
	$out.='/><label>'.__('All day','church-admin').'</label></div>';
	/********************************
	*
	* Add a link
	*
	*********************************/
	$out.='<div class="church-admin-form-group"><label>'.__('Add a link to event page/post','church-admin').'</label><input type="text" name="link1" id="cal-link" class="church-admin-form-control" ';
	if(!empty( $data->link) )$out.=' value="'.esc_html( $data->link).'" ';
	$out.='placeholder="'.__('Add a link','church-admin').'"/></div>';
	$out.='<div class="church-admin-form-group"><label>'.__('Or select one').'</label><select name="link2" class="church-admin-form-control">';
	//add in a dropdown of pages and post_status
	$out.='<option value="">'.__('Select a post or page','church-admin').'</option>';
	$out.=' <optgroup label="'.__('Posts','church-admin').'">';
	$args = array( 'numberposts' => 10);
	$postlinks = get_posts( $args);
	foreach( $postlinks as $postlink ) { setup_postdata( $postlink); $out.='<option value="'.get_permalink( $postlink->ID).'">'.$postlink->post_title.'</option>';}
	$out.='</optgroup>';
	$out.=' <optgroup label="'.__('Pages','church-admin').'">';
	$args = array( 'post_type'=>'page','numberposts' =>-1,'orderby'=>'title','order'=>'ASC');
	$postlinks = get_posts( $args);
	foreach( $postlinks as $postlink ) { setup_postdata( $postlink); $out.='<option value="'.get_permalink( $postlink->ID).'">'.$postlink->post_title.'</option>';}
	$out.='</optgroup>';
	$out.='</select>';
	$out.='</div>';
	/*****************************************
	*
	* Link title		
	*
	******************************************/
	$out.='<div class="church-admin-form-group"><label>'.__('Link title','church-admin').'</label><input class="church-admin-form-control" type="text" name="link_title" ';
	if(!empty( $data->link_title) )  {$out.=' value="'.esc_html( $data->link_title).'" ';}else{$out.=' value="'.__('More information','church-admin').'" ';}
	$out.='/></div>';
	/*****************************************
	*
	* Year planner	
	*
	******************************************/
	$out.='<div class="church-admin-form-check"><input type="checkbox" name="year_planner" value="1"';
	if(!empty( $data->year_planner) ) $out.=' checked="checked"';
	$out.='/><label>'.__('Appear on Year Planner?','church-admin').'</label></div>';


	$out.='<div class="church-admin-form-check"><input type="checkbox" name="general_calendar" value="1"  checked="checked"/>';
	$out.='<input type="hidden" name="save_date" value="yes"/><label>'.__('Appear on General Calendar?','church-admin').'</label></div>';

	/*****************************************
	*
	* jQuery magic		
	*
	******************************************/
	$out.='<script>';
	$out.='
	jQuery(document).ready(function( $)  {
			$(".single_edit").click(function()  {
				$(".recurring-row").hide();
				$(".recurring-item").attr("disabled",true);
				$("single-item").attr("disabled",false);
			});
			$(".series_edit").click(function()  {
				$("recurring-row").show();
				$("recurring-item").attr("disabled",false);
				$("single-item").attr("disabled",true);
			});
			/*
			$("#recurring").change(function()  {
			var recurring=$("#recurring").val();
			switch(recurring)
			{
				case "s": 
					$("#nth").hide();
					$("#howmany").hide();
				break;
				case "1": 
					$("#nth").hide();
					$("#howmany").show();
				break;
				case "7": 
					$("#nth").hide();
					$("#howmany").show();
				break;
				case "14": 
					$("#nth").hide();
					$("#howmany").show();
				break;
				case "n": 
					$("#nth").show();
					$("#howmany").show();
				break;
				case "m": 
					$("#nth").hide();
					$("#howmany").show();
				break;
				case "a": 
					$("#nth").hide();
					$("#howmany").show();
				break;
			};
			});
			*/
		})
	';
	$out.='</script>';
	
	
	return $out;
}


function church_admin_single_event_delete( $date_id)
{
    global $wpdb;
    $date=$wpdb->get_var('SELECT start_date FROM '.CA_DATE_TBL.' WHERE date_id="'.esc_sql( $date_id).'"');
    $wpdb->query('DELETE FROM '.CA_DATE_TBL.' WHERE date_id="'.esc_sql( $date_id).'"');
    echo '<div id="message" class="notice notice-success inline">';
    echo '<p><strong>'.__('Calendar Events deleted','church-admin').'.</strong></p>';
    echo '</div>';


    church_admin_new_calendar( $date);
}

function church_admin_series_event_delete( $event_id)
{
    global $wpdb;
    $date=$wpdb->get_var('SELECT MIN(start_date) FROM '.CA_DATE_TBL.' WHERE event_id="'.esc_sql( $event_id).'"');
    $wpdb->query('DELETE FROM '.CA_DATE_TBL.' WHERE event_id="'.esc_sql( $event_id).'"');
    echo '<div id="message" class="notice notice-success inline">';
    echo '<p><strong>'.__('Calendar Events deleted','church-admin').'.</strong></p>';
    echo '</div>';
    church_admin_new_calendar(strtotime( $date) );
}


function church_admin_calendar_error_check( $data)
{
    global $error,$sqlsafe;
     //check startdate
      $start_date=church_admin_dateCheck( $data['start_date'] );

      $end_date=church_admin_dateCheck( $data['end_date'], $yearepsilon=50);

      if( $start_date)  {$sqlsafe['start_date']=esc_sql( $start_date);}else{$error->start_date==1;}

      //check start time
   if (preg_match ("/([0-2]{1}[0-9]{1}):([0-5]{1}[0-9]{1})/", $data['start_time'] ) )  {$sqlsafe['start_time']=$data['start_time'];}else{$error['start_time']='1';}
        //check end time
  if (preg_match("/([0-2]{1}[0-9]{1}):([0-5]{1}[0-9]{1})/", $data['end_time'] ) )  {$sqlsafe['end_time']=$data['end_time'];}else{$error->end_time='1';}

      //check recurring
      if( $data['recurring']=='s'||$data['recurring']=='1'||$data['recurring']=='7'||$data['recurring']=='14'||$data['recurring']=='n'||$data['recurring']=='m'||$data['recurring']=='a')  {$sqlsafe['recurring']=$data['recurring'];}else{$error['recurring']=1;}
      //check how many
      if( $data['recurring']!='s')
      {
        if(ctype_digit( $data['how_many'] ) )
        {
            $sqlsafe['how_many']=$data['how_many'];
        }
        else
        {
            $error->how_many=1;
        }
      }
      //check nth if necessary
      if( $data['recurring']=='n')
        {
            if(!empty( $data['nth'] ) && $data['nth']<='4')
            {
                $sqlsafe['nth']=$data['nth']; $sqlsafe['day']=$data['day'];
            }
            else
            {
                $error->nth=$error['day']=1;
            }
        }
       if(!empty( $data['title'] ) )  { $sqlsafe['title']= esc_sql( $data['title'] );}else{$error->title=1;}
       if(!empty( $data['description'] ) )  { $sqlsafe['description']= esc_sql(nl2br( $data['description'] ) );}else{$error->description=1;}
       $sqlsafe['description']=strip_tags( $sqlsafe['description'] );
      $sqlsafe['location']=esc_sql( $data['location'] );
      if(!empty( $_POST['category'] )&&ctype_digit( $data['category'] ) )  {$sqlsafe['category']=$data['category'];}else{$error['category']=1;}
      if( $data['year_planner']=='1')  {$sqlsafe['year_planner']=1;}else{$sqlsafe['year_planner']=0;}

    return $error;
}


function church_admin_calendar_list()
{
		global $wpdb;
		if ( empty( $_REQUEST['date'] ) )  {$entereddate=time();}else{$entereddate=$_REQUEST['date'];}
	echo'<div class="wrap church_admin"><p><a href="admin.php?page=church_admin/index.php&amp;action=add-calendar&amp;date='.$entereddate.'">'.__('Add calendar Event','church-admin').'</a></p>';
		$events=$wpdb->get_var('SELECT COUNT(*) FROM '.CA_DATE_TBL);
		if(!empty( $events) )
		{
				//which month to view
			$current=(isset( $_REQUEST['date'] ) ) ? intval( $_REQUEST['date'] ) : time(); //get user date or use today
			$next = strtotime("+1 month",$current);
			$previous = strtotime("-1 month",$current);
			$now=date("M Y",$current);
			$sqlnow=date("Y-m%", $current);
			$sqlnext=date("Y-m-d",$next);

			echo '<table><tr><td><a href="admin.php?page=church_admin/index.php&section=calendar&amp;action=calendar-list&amp;date='.$previous.'">'.__('Prev','church-admin').'</a> '.$now.' <a href="admin.php?page=church_admin/index.php&section=calendar&amp;action=calendar-list&amp;date='.$next.'">'.__('Next','church-admin').'</a></td><td>';
			echo'<form action="admin.php?page=church_admin/index.php&amp;action=calendar-list" method="post"><select name="date">';
			echo '<option value="'.$entereddate.'">'.date('M Y',$entereddate).'</option>';
		//generate a form to access calendar
		for ( $x=0; $x<12; $x++)
		{
			$date=strtotime("+ $x month",time() );
			echo '<option value="'.$date.'">'.date('M Y',$date).'</option>';
		}
		echo '</select><input type="submit" value="'.__('Go to date','church-admin').'"/></form></td></tr></table>';
		//initialise table
		$theader='<tr><th>'.__('Single Edit','church-admin').'</th><th>'.__('Series Edit','church-admin').'</th><th>'.__('Single Delete','church-admin').'</th><th>'.__('Series Delete','church-admin').'</th><th>'.__('Start date','church-admin').'</th><th>'.__('Start Time','church-admin').'</th><th>'.__('End Time','church-admin').'</th><th>'.__('Event Name','church-admin').'</th><th>'.__('Category','church-admin').'</th><th>'.__('Year Planner','church-admin').'?</th></tr>';
		$table='<table class="widefat striped"><thead>'.$theader.'</thead><tbody>';


		$sql='SELECT a.*,b.category FROM '.CA_DATE_TBL.' a, '.CA_CAT_TBL.' b WHERE a.cat_id=b.cat_id AND a.start_date LIKE "'.$sqlnow.'" ORDER BY a.start_date';

	$result=$wpdb->get_results( $sql);
		foreach( $result AS $row)
		{
		//create links
		$single_edit_url='<a href="'.wp_nonce_url('admin.php?page=church_admin/index.php&amp;action=single-event-edit&section=calendar&amp;event_id='.$row->event_id.'&amp;date_id='.(int)$row->date_id.'&amp;'.$entereddate,'single_event_edit').'">'.__('Edit','church-admin').'</a>';
		if( $row->recurring=='s')  {$series_edit_url='&nbsp;';}else{$series_edit_url='<a href="'.wp_nonce_url('admin.php?page=church_admin/index.php&amp;action=series-event-edit&section=calendar&amp;event_id='.$row->event_id.'&amp;date_id='.(int)$row->date_id.'&amp;date='.$entereddate,'series_event_edit').'">'.__('Edit Series','church-admin').'</a>';}
		$single_delete_url='<a href="'.wp_nonce_url('admin.php?page=church_admin/index.php&amp;action=single-event-delete&amp;event_id='.$row->event_id.'&amp;date_id='.(int)$row->date_id.'&amp;date='.$entereddate,'single_event_delete').'">'.__('Delete this one','church-admin').'</a>';

		if( $row->recurring=='s')  {$series_delete_url='&nbsp;';}else{$series_delete_url='<a href="'.wp_nonce_url('admin.php?page=church_admin/index.php&amp;action=series-event-delete&amp;event_id='.$row->event_id.'&amp;date_id='.(int)$row->date_id.'&amp;date='.$entereddate,'series_event_delete').'">'.__('Delete Series','church-admin').'</a>';}

		//sort out category
		if ( empty( $row->bgcolor) )$row->bgcolor='#FFF';
		$table.='<tr><td>'.$single_edit_url.'</td><td>'.$series_edit_url.'</td><td>'.$single_delete_url.'</td><td>'.$series_delete_url.'</td><td>'.mysql2date(get_option('date_format'),$row->start_date).'</td><td>'.esc_html( $row->start_time).'</td><td>'.esc_html( $row->end_time).'</td><td>'.esc_html( $row->title).'</td><td style="background:'.esc_attr($row->bgcolor).'">'.esc_html( $row->category).'</td><td>';
		if( $row->year_planner)  {$table.=__('Yes','church-admin');}else{$table.='&nbsp;';}
		$table.='</td></tr>';
		}
		$table.='</tbody><tfoot>'.$theader.'</tfoot></table>';
		echo $table.'</div>';
	}//end of non empty calendar table

}



function church_admin_import_ical()
{
	
	global $wpdb;
	echo'<h1>'.__('Import ics file or url into calendar','church-admin').'</h1>';
	echo'<p><a class="button-secondary" href="https://www.churchadminplugin.com/tutorials/import-ical">'.__('How to tutorial','church-admin').'</a></p>';
	if(!empty( $_POST['import-ical'] ) )
	{
		
		//get category id
		$cat_id=1;
		if(!empty( $_POST['cat_id'] ) )
		{
			$cat_id=(int)$_POST['cat_id'];
		}
		if(!empty( $_POST['new-category'] ) )
		{
			$category=sanitize_text_field( $_POST['new-category'] );



		}
		//clear just chosen category
		if(!empty( $_POST['clear-category'] ) )
		{
			$wpdb->query('DELETE FROM '.CA_DATE_TBL.' WHERE cat_id="'.(int)$cat_id.'"');
		}
		//clear calendar completely
		if(!empty( $_POST['clear-calendar'] ) )
		{
			$wpdb->query('TRUNCATE TABLE '.CA_DATE_TBL);
		}
		
		require_once(plugin_dir_path(dirname(__FILE__) ).'/includes/ical-parser.php');
		require_once(plugin_dir_path(dirname(__FILE__) ).'/includes/ical-events.php');
		try{
			
			$start=$_POST['start_date'];
			if ( empty( $start) )$start=date('Y-m-d');
			$end=$_POST['end_date'];
			if ( empty( $end) )$end=date('Y-m-d',strtotime('+1 year') );
			$ical = new ICal('ical.ics', array(
				'defaultSpan'                 => 2,     // Default value
				'defaultTimeZone'             => 'UTC',
				'defaultWeekStart'            => 'MO',  // Default value
				'disableCharacterReplacement' => false, // Default value
				'filterDaysAfter'             => null,  // Default value
				'filterDaysBefore'            => null,  // Default value
				'httpUserAgent'               => null,  // Default value
				'skipRecurrence'              => false, // Default value
			) );
			if(!empty( $_POST['ics-url'] ) )  {$ical->initUrl( $_POST['ics-url'] );}
			elseif  ( $_FILES['fileToUpload']['size']>0)
			{
				$upload_dir = wp_upload_dir();
				$filename = $upload_dir['basedir'].'/church-admin-cache/'.$_FILES['fileToUpload']['name'];
				$tmpName  = $_FILES['fileToUpload']['tmp_name'];
				move_uploaded_file( $tmpName,$filename);
				$ical->initFile( $filename);
			}
			if( $ical->hasEvents() )
			{	
				$event_ids=array();
				$cat_id=$_POST['cat_id'];
				if(!empty( $_POST['new-category'] ) )
				{
					$new_category=sanitize_text_field( $_POST['new-category'] );
					$cat_id=$wpdb->get_var('SELECT category FROM '.CA_CAT_TBL.' WHERE category="'.esc_sql( $new_category).'"');
					if ( empty( $cat_id) )
					{
						$wpdb->query('INSERT INTO '.CA_CAT_TBL.' (category)VALUES("'.esc_sql( $new_category).'")');
						$cat_id=$wpdb->insert_id;
					}
				}
				//$events = $ical->eventsFromInterval('365 day');
				$events = $ical->eventsFromRange( $start,$end);
				
				
				echo '<p>'.count( $events).' events to process</p>';
				foreach( $events AS $event)
				{
					$title=$event->summary;
					$startDateTime = $ical->iCalDateToDateTime( $event->dtstart_array[3] );
					$startDate=$startDateTime->format('Y-m-d');
					$startTime=$startDateTime->format('H:i:s');
					$endDateTime = $ical->iCalDateToDateTime( $event->dtend_array[3] );
					$endDate=$endDateTime->format('Y-m-d');
					$endTime=$endDateTime->format('H:i:s');
					if( $endTime=='00:00:00')$endTime='23:59:00';
					$description = $event->description;
					$location = $event->location;
					$recurring = 's';
				
					if(!empty( $event->rrule) )
					{
						//retrieve recurrency frequency from string of form FREQ=WEEKLY;BYDAY=SA
						$rec = $event->rrule;
						if(!empty( $rec) )$rec1=explode(";",$rec);
						
						if(!empty( $rec1) )
						{
							switch( $rec1[0] )
							{
								case 'FREQ=DAILY': $recurring=1;break;
								case 'FREQ=WEEKLY': $recurring=7;break;
								case 'FREQ=MONTHLY':$recurring='m';break;
								case 'FREQ=YEARLY': $recurring='a';break;
							}
						}
					}	
					echo'<h3>'.esc_html( $title).'</h3>';
					if(!empty( $event->description) ) echo '<p>'.esc_html( $event->description).'</p>';
					echo'<p>Start: '.esc_html( $startDateTime->format('d-m-Y H:i') ).'</p>';
					echo'<p>End: '.esc_html( $endDateTime->format('d-m-Y H:i') ).'</p>';
					echo '<p>Recurring: '.esc_html( $recurring).'</p>';

					
					
					
					//check not already saved
					$date_id=$wpdb->get_var('SELECT date_id FROM '.CA_DATE_TBL.' WHERE title="'.esc_sql( $title).'" AND description="'.esc_sql( $description).'" AND location="'.esc_sql( $location).'" AND start_date="'.esc_sql( $startDate).'" AND start_time="'.esc_sql( $startTime).'" AND end_time="'.esc_sql( $endTime).'" AND recurring="'.esc_sql( $recurring).'" AND external_uid="'.esc_sql( $event->uid).'"');

					if(!empty( $date_id) )echo'<p>'.__('Event already in calendar','church-admin').'</p>';
					//sort an event_id if needed
					//get event_id
					// starts at 1, use max + 1; or if recurring event use already used one
					$event_id=1;
					if( $recurring!='s')
					{
						$event_id=$wpdb->get_var('SELECT event_id FROM '.CA_DATE_TBL.' WHERE external_uid="'.esc_sql( $event->uid).'"');
						
						if ( empty( $event_id) )$event_id=$wpdb->get_var('SELECT MAX(event_id) FROM '.CA_DATE_TBL)+1;
					}
					else
					{
						$event_id=$wpdb->get_var('SELECT MAX(event_id) FROM '.CA_DATE_TBL)+1;
					}
					$event_ids[$event_id]++;

					if ( empty( $date_id) )
					{
						$wpdb->query('INSERT INTO '.CA_DATE_TBL.' (title,description,location,start_date,start_time,end_time,recurring,event_id,cat_id,general_calendar,external_uid)VALUES("'.esc_sql( $title).'","'.esc_sql( $description).'","'.esc_sql( $location).'","'.esc_sql( $startDate).'","'.esc_sql( $startTime).'","'.esc_sql( $endTime).'","'.esc_sql( $recurring).'","'.(int)$event_id.'","'.(int)$cat_id.'","1","'.esc_sql( $event->uid).'")');
						echo '<p>'.$wpdb->last_query.'</p>';
					}
				}
				
				foreach( $event_ids AS $event_id=>$count)$wpdb->query('UPDATE '.CA_DATE_TBL.' SET how_many="'.(int)$count.'" WHERE event_id="'.(int)$event_id.'"');
			}
			else
			{
				echo'<div class="notice notice-warning"><h2>'.__('No events found in calendar','church-admin').'<h2></div>';
			}
		} catch (\Exception $e) {
			echo'<div class="notice notice-warning"><h2>'.__('It did not work','church-admin').'</h2><p>';
			echo $e->getMessage();
			echo'</p></div>';
		}
	}
	else
	{

		echo'<form action="" method="post" enctype="multipart/form-data">';
		echo'<table class="form-table">';
		echo'<tr><th colspan="2"><h3>'.__('ICS source','church-admin').'</h3></th></tr>';
		echo'<tr><th scope="row">'.__('Calendar ICS URL','church-admin').'</th><td><input type="text" name="ics-url"/></td></tr>';
		echo'<tr><th scope="row">'.__('Or upload ICS file','church-admin').'</th><td><input type="file" name="fileToUpload" id="fileToUpload"></td></tr>';
		echo'<tr><th colspan="2"><h3>'.__('Date range to import','church-admin').'</h3></th></tr>';
		echo'<tr><th scope="row">'.__('Start date','church-admin').'</th><td>'.church_admin_date_picker(date('Y-m-d'),'start_date',NULL,NULL,NULL,'start_date','start_date',NULL,FALSE,NULL,NULL).'</td></tr>';
		echo'<tr><th scope="row">'.__('End date','church-admin').'</th><td>'.church_admin_date_picker(date('Y-m-d',strtotime('+1 year') ),'end_date',NULL,NULL,NULL,'end_date','end_date',NULL,FALSE,NULL,NULL).'</td></tr>';
		echo'<tr><th colspan="2"><h3>'.__('What to do with current calendar','church-admin').'</h3></th></tr>';
		echo'<tr><th scope="row">'.__('Clear all current calendar events','church-admin').'</th><td><input type="checkbox" name="clear-calendar" value="1"/></td></tr>';
		echo'<tr><th scope="row">'.__('Or clear current calendar events in chosen category below','church-admin').'</th><td><input type="checkbox" name="clear-category" value="1"/></td></tr>';
		//get calendar categories
		$cats=$wpdb->get_results('SELECT * FROM '.CA_CAT_TBL);
		if(!empty( $cats) )
		{
			echo '<tr><th scope="row">'.__('Choose category to put events into','church-admin').'</th><td><select name="cat_id">';
			foreach( $cats AS $cat)
			{
				echo'<option value="'.(int)$cat->cat_id.'" style="background-color:'.esc_html( $cat->bgcolor).'">'.esc_html( $cat->category).'</option>';
			}
			echo '</select></td></tr>';
		}
		echo'<tr><th scope="row">'.__('Or create new calendar category','church-admin').'</th><td><input type="text" name="new-category"/></td></tr>';
		
		echo'<tr><td colspan=2><input type="hidden" name="import-ical" value="1"/><input class="button-primary" type="submit" value="'.__('Import','church-admin').'"/></td></tr></table></form>';
	}

}



