<?php
if ( ! defined( 'ABSPATH' ) ) exit('You need Jesus!'); // Exit if accessed directly

/*****************************************************************************
*
* New save functionality on init so redirect to list page can happen
*
******************************************************************************/
function church_admin_save()
{

    switch( $_POST['church-admin-save'] )
    {
    
        case 'service': 
            church_admin_save_service();
            $message=__('Service saved','church-admin');
            wp_redirect(admin_url('admin.php?page=church_admin/index.php&action=service-list&section=services&message='.$message) );
        break;
    
    }

    return $return;
}
/*****************************************************************************
*
* Service save
*
******************************************************************************/
function church_admin_save_service()
{
    church_admin_debug ("Saving service");
    church_admin_debug ("POST".print_r( $_POST,TRUE) );
    church_admin_debug ("GET".print_r( $_GET,TRUE) );
    global $wpdb;
    $wpdb->show_errors;
    $form=array();
        foreach( $_POST AS $key=>$value)$form[$key]=sanitize_text_field(stripslashes( $value) );
        //deal with new site
        if(!empty( $form['site_name'] ) )
        {
        	$site_id=$wpdb->get_var('SELECT site_id FROM '.CA_SIT_TBL.' WHERE venue="'.esc_sql( $form['site_name'] ).'"');
        	if ( empty( $check) )  {$site_id=$wpdb->query('Insert INTO '.CA_SIT_TBL.' (venue)VALUES("'.esc_sql( $form['site_name'] ).'")');}
        	$form['site_id']=$wpdb->insert_id;
        }
        if(!empty( $form['active'] ) )  {$active=1;}else{$active=0;}
        if(!empty( $_POST['service_id'] ) )$id=(int)$_POST['service_id'];
        if ( empty( $id) )$id=$wpdb->get_var('SELECT service_id FROM '.CA_SER_TBL.' WHERE service_name="'.esc_sql( $form['service_name'] ).'" AND site_id="'.esc_sql( $form['site_id'] ).'" AND service_day="'.esc_sql( $form['service_day'] ).'" AND service_day="'.esc_sql( $form['service_day'] ).'" AND service_time="'.esc_sql( $form['service_time'] ).'" ');
        church_admin_debug ("service id $id");
        if( $id)
        {//update
            $sql='UPDATE '.CA_SER_TBL.' SET service_name="'.esc_sql( $form['service_name'] ).'" , service_day="'.esc_sql( $form['service_day'] ).'" , service_time="'.esc_sql( $form['service_time'] ).'" , site_id="'.esc_sql( $form['site_id'] ).'", active="'.$active.'",max_attendance="'.intval( $form['max_attendance'] ).'",bubbles="'.intval( $form['bubbles'] ).'", bubble_size="'.intval( $form['bubble_size'] ).'" WHERE service_id="'.esc_sql( $id).'"';
            church_admin_debug( $sql);
            $wpdb->query( $sql);
        }//update
        else
        {//insert
           $wpdb->query('INSERT INTO '.CA_SER_TBL.' (service_name,service_day,service_time,site_id,active,max_attendance,bubbles,bubble_size) VALUES ("'.esc_sql( $form['service_name'] ).'","'.esc_sql( $form['service_day'] ).'","'.esc_sql( $form['service_time'] ).'","'.esc_sql( $form['site_id'] ).'","'.$active.'","'.intval( $form['max_attendance'] ).'","'.intval( $form['bubbles'] ).'","'.intval( $form['bubble_size'] ).'")');
            $id=$wpdb->insert_id;
        }//insert
        
        /*******************************************
        *
        *   Handle Calendar
        *
        ********************************************/
        if(!empty( $_POST['event_id'] ) )
        {
            $eventDetails=$wpdb->get_row('SELECT * FROM '.CA_DATE_TBL.' WHERE event_id="'.(int)$_POST['event_id'].'" ORDER BY start_date ASC LIMIT 1');
            if(defined("CA_DEBUG") )church_admin_debug(print_r( $eventDetails,TRUE) );
            if(!empty( $eventDetails) )$wpdb->query('UPDATE '.CA_SER_TBL.' SET first_date="'.esc_sql( $eventDetails->start_date).'", end_time="'.$eventDetails->end_time.'",how_many="'.esc_sql( $eventDetails->how_many).'",recurring="'.esc_sql( $eventDetails->recurring).'",event_id="'.intval( $eventDetails->event_id).'" WHERE service_id="'.(int)$id.'"');
            church_admin_debug( $wpdb->last_query);
        }
        else//only overwrite event if no event id
        {
            if(!empty( $_POST['calendar'] ) )
            {       

                //first remove current event if exists
                $event_id=$wpdb->get_var('SELECT event_id FROM '.CA_SER_TBL .' WHERE service_id="'.(int)$id.'"');
                if( $event_id)$wpdb->query('DELETE FROM '.CA_DATE_TBL.' WHERE event_id="'.(int)$event_id.'"');
                //get next event id
                $event_id=$wpdb->get_var('SELECT MAX(event_id) FROM '.CA_DATE_TBL)+1;


                $form['location']=$wpdb->get_var('SELECT venue FROM '.CA_SIT_TBL.' WHERE site_id="'.intval( $form['site_id'] ).'"');

                switch( $_POST['recurring'] )
                {
                    case's':
                        $sql='INSERT INTO '.CA_DATE_TBL.' (title,location,recurring,year_planner, cat_id,event_id,how_many,start_date,start_time,end_time,general_calendar)VALUES("'.esc_sql( $form['service_name'] ).'","'.esc_sql( $form['location'] ).'","'.esc_sql( $form['recurring'] ).'","1","'.$event_id.'","'.esc_sql( $form['how_many'] ).'","'.esc_sql( $form['first_date'] ).'","'.esc_sql( $form['service_time'] ).'","'.esc_sql( $form['end_time'] ).'",1)';
                    break;
                    case'n':
                        //handle nth
                        $values=array();
                        for ( $x=0; $x<$form['how_many']; $x++)
                        {	
                            if( $form['nth']==__('Last','church-admin') )  {$nth=$form['nth'];}else{$nth="+".$form['nth'];}
                            $date=new DateTime( $form['first_date'] );
                            if(defined('CA_DEBUG') )church_admin_debug(print_r( $date,TRUE) );
                            $date->modify("+ $x month");
                            if(defined('CA_DEBUG') )church_admin_debug("$x months added\r\n".print_r( $date,TRUE) );
                            $start_date=church_admin_nth_day( $nth,$form['day'],$date->format('Y-m-d') );

                            if(defined('CA_DEBUG') )church_admin_debug('Start date '.$start_date);
                            $values[]='("'.esc_sql( $form['service_name'] ).'","'.esc_sql( $form['location'] ).'","'.esc_sql( $form['recurring'] ).'","'.$event_id.'","'.esc_sql( $form['how_many'] ).'","1","'.$start_date.'","'.$form['service_time'].'","'.$form['end_time'].'","1")';
                        }
                        $sql='INSERT INTO '.CA_DATE_TBL.' (title,location,recurring, event_id,how_many,cat_id,start_date,start_time,end_time,general_calendar)VALUES'.implode(",",$values);
                    break;
                    case '14':
                        $values=array();
                        for ( $x=0; $x<$form['how_many']; $x++)
                        {
                            $start_date=date('Y-m-d',strtotime("{$form['first_date']}+$x fortnight") );
                            $values[]='("'.esc_sql( $form['service_name'] ).'","'.esc_sql( $form['location'] ).'","'.esc_sql( $form['recurring'] ).'","'.$event_id.'","'.esc_sql( $form['how_many'] ).'","1","'.$start_date.'","'.$form['service_time'].'","'.$form['end_time'].'",1)';
                        }
                        $sql='INSERT INTO '.CA_DATE_TBL.' (title,location,recurring, event_id,how_many,cat_id,start_date,start_time,end_time,general_calendar)VALUES'.implode(",",$values);
                    break;
                    case '7':
                        $values=array();
                        for ( $x=0; $x<$form['how_many']; $x++)
                        {
                            $start_date=date('Y-m-d',strtotime("{$form['first_date']}+$x week") );
                            $values[]='("'.esc_sql( $form['service_name'] ).'","'.esc_sql( $form['location'] ).'","'.esc_sql( $form['recurring'] ).'","'.$event_id.'","'.esc_sql( $form['how_many'] ).'","1","'.$start_date.'","'.$form['service_time'].'","'.$form['end_time'].'",1)';
                        }
                        $sql='INSERT INTO '.CA_DATE_TBL.' (title,location,recurring,event_id,how_many,cat_id,start_date,start_time,end_time,general_calendar)VALUES'.implode(",",$values);
                    break;
                    case '1':
                        $values=array();
                        for ( $x=0; $x<$form['how_many']; $x++)
                        {
                            $start_date=date('Y-m-d',strtotime("{$form['first_date']}+$x day") );
                            $values[]='("'.esc_sql( $form['service_name'] ).'","'.esc_sql( $form['location'] ).'","'.esc_sql( $form['recurring'] ).'","'.$event_id.'","'.esc_sql( $form['how_many'] ).'","1","'.$start_date.'","'.$form['service_time'].'","'.$form['end_time'].'",1)';
                        }
                        $sql='INSERT INTO '.CA_DATE_TBL.' (title,location,recurring,event_id,how_many,cat_id,start_date,start_time,end_time,general_calendar)VALUES'.implode(",",$values);
                    break;
                    case 'm':
                        $values=array();
                        for ( $x=0; $x<$form['how_many']; $x++)
                        {
                            $start_date=date('Y-m-d',strtotime("{$form['first_date']}+$x month") );
                            $values[]='("'.esc_sql( $form['service_name'] ).'","'.esc_sql( $form['location'] ).'","'.esc_sql( $form['recurring'] ).'","'.$event_id.'","'.esc_sql( $form['how_many'] ).'","1","'.$start_date.'","'.$form['service_time'].'","'.$form['end_time'].'",1)';
                        }
                        $sql='INSERT INTO '.CA_DATE_TBL.' (title,location,recurring, event_image,event_id,how_many,cat_id,start_date,start_time,end_time,general_calendar)VALUES'.implode(",",$values);
                    break;
                    case 'a':
                        $values=array();
                        for ( $x=1; $x<$form['how_many']; $x++)
                        {
                            $start_date=date('Y-m-d',strtotime("{$form['first_date']}+$x year") );
                            $values[]='("'.esc_sql( $form['service_name'] ).'","'.esc_sql( $form['location'] ).'","'.esc_sql( $form['recurring'] ).'","'.$event_id.'","'.esc_sql( $form['how_many'] ).'","1","'.$start_date.'","'.$form['service_time'].'","'.$form['end_time'].'",1)';
                        }
                        $sql='INSERT INTO '.CA_DATE_TBL.' (title,location,recurring,event_id,how_many,cat_id,start_date,start_time,end_time,general_calendar)VALUES'.implode(",",$values);
                    break;

                }

                $wpdb->query( $sql);
                //$event_id=$wpdb->insert_id;
                $wpdb->query('UPDATE '.CA_SER_TBL.' SET first_date="'.esc_sql( $form['first_date'] ).'", end_time="'.$form['end_time'].'",how_many="'.esc_sql( $form['how_many'] ).'",recurring="'.esc_sql( $form['recurring'] ).'",event_id="'.(int)$event_id.'" WHERE service_id="'.(int)$id.'"');
            }
        }//only overwite calendar if event id not picked!
}