<?php
if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

//define('EMAIL_TEST',TRUE);


//2014-02-24 fixed encoding error


function church_admin_test_email( $email=NULL)
{
    echo'<h2>'.__('Send a test email','church-admin').'</h2>';
    if ( empty( $email) )
    {
        echo'<p>'.__("Please note - sometimes hosting companies set website email sending up so you can't send to an email address on the same domain as the site domain name. Contact your host after checking a different email address as well one on this domain.",'church-admin').'</p>';
        echo '<form action="" method="POST">';
        echo '<p><label>'.__('Email address to send to','church-admin').'</label><input type="email" name="test-email"/><input type="submit" class="button-primary" value="'.__('Send email','church-admin').'"/></p></form>';
		$smtp=get_option('church_admin_smtp_settings');
		if(!function_exists('mail') )
		{
			echo'<p>'.__('Your host has not enabled mail() function. You must set up SMTP settings to be able to send email from this site.','church-admin');
			echo'<p><a href="admin.php?page=church_admin/index.php&action=smtp-settings" class="button-primary">'.__('Set up SMTP settings','church-admin').'</a></p>';
			if ( empty( $smtp) ) return;
			
		}
	}
    else
    {
        church_admin_debug("***********************\r\n Email test send");
        add_filter( 'wp_mail_from_name', function( $from ) {return "My website";});
        add_filter( 'wp_mail_from', function( $email ) {return "support@churchadminplugin.com";});
        add_filter('wp_mail_content_type','church_admin_email_type');
        $message='<p>Test email from the church admin plugin</p>';
        if(!empty( $email)&&is_email( $email) )  {$to=$email;}else{$to=get_option('admin_email');}
		if(!empty( $_REQUEST['test-email'] )&&is_email( $_REQUEST['test-email'] ) )$to=$_REQUEST['test-email'];
		try {
			if(wp_mail( $to,'Church Admin Test Email',$message) )echo'<p>'.__('Test email sent successfully','church-admin').'</p>';
		}
		catch(Exception $e)
			{
				echo'<p>'.__('Email send failure','church-admin').'</p>';
				print_r( $e);
				print_r( $GLOBALS['phpmailer'] );
				
			}
		
       
        echo'<h2>'.__('Debug information','church-admin').'</h2>';
		echo '<p>Email attempt to '.esc_html( $_REQUEST['test-email'] ).'</p>';
		echo'<pre>';
        print_r( $GLOBALS['phpmailer'] );
        echo'</pre>';
		remove_filter( 'wp_mail_from_name', function( $from ) {return "My website";});
        remove_filter( 'wp_mail_from', function( $email ) {return "support@churchadminplugin.com";});
        remove_filter('wp_mail_content_type','church_admin_email_type');
    }
}


function church_admin_delete_email( $email_id)
{
	global $wpdb;
	$row=$wpdb->get_row('SELECT * FROM '.CA_EBU_TBL.' WHERE email_id="'.esc_sql( $email_id).'"');
	if(!empty( $data->filename) )$paths=maybe_unserialize( $data->filename);
	if(!empty( $paths) )  {foreach( $paths AS $key=>$value) unlink( $value);}
	$wpdb->query('DELETE FROM '.CA_EBU_TBL.' WHERE email_id="'.esc_sql( $email_id).'"');
	echo'<div class="notice notice-success inline">'.__('Email deleted','church-admin').'</div>';
	church_admin_email_list();
}
/**
 * Church Email list
 *
 * Author:     Andy Moyle
 * Author URI: http://www.churchadminplugin.com
 *
 *
 */
function church_admin_email_list()
{
	echo'<h2>'.__('Email List','church-admin').'</h2>';
	echo'<p><a class="button-primary" href="admin.php?page=church_admin/index.php&action=send-email">'.__('Send email','church-admin').'</a></p>';
	global $wpdb;
	$items=$wpdb->get_var('SELECT COUNT(*) FROM '.CA_EBU_TBL.' WHERE recipients!=""' );
	require_once(plugin_dir_path(dirname(__FILE__) ).'includes/pagination.class.php');
    if( $items > 0)
    {

	$p = new caPagination;
	$p->items( $items);
	$p->limit(get_option('church_admin_page_limit') ); // Limit entries per page
	$p->target("admin.php?page=church_admin/index.php&section=communications&action=email_list");
	if(!isset( $p->paging) )$p->paging=1;
	if(!isset( $_GET[$p->paging] ) )$_GET[$p->paging]=1;
	$p->currentPage((int)$_GET[$p->paging] ); // Gets and validates the current page
	$p->calculate(); // Calculates what to show
	$p->parameterName('paging');
	$p->adjacents(1); //No. of page away from the current page
	if(!isset( $_GET['paging'] ) )
	{
	    $p->page = 1;
	}
	else
	{
	    $p->page = intval( $_GET['paging'] );
	}
        //Query for limit paging
	$limit = esc_sql("LIMIT " . ( $p->page - 1) * $p->limit  . ", " . $p->limit);
    $result=$wpdb->get_results('SELECT * FROM '.CA_EBU_TBL.' WHERE recipients!="" ORDER BY send_date DESC '.$limit );
	if(!empty( $result) )
	{
		echo'<h2>'.__('Sent Emails','church-admin').'</h2>';
		$theader='<tr><th class="column-primary">'.__('Subject','church-admin').'</th><th>'.__('Delete','church-admin').'</th><th>'.__('Date','church-admin').'</th><th>'.__('Number of recipients','church-admin').'</th><th>'.__('Excerpt','church-admin').'</th><th>'.__('Resend','church-admin').'?</th><th>'.__('Resend to new recipients','church-admin').'</th><th>'.__('Edit and resend','church-admin').'</th></tr>';
		echo' <table class="widefat striped wp-list-table"><thead>'.$theader.'</thead><tfoot>'.$theader.'</tfoot><tbody>';
		foreach( $result AS $row)
		{
			$startsAt = strpos( $row->message, "<!--salutation-->") + strlen("{FINDME}");
			$endsAt = strpos( $row->message, "<!--News,events-->", $startsAt);
			$message = strip_tags(substr( $row->message, $startsAt+17, $endsAt - $startsAt) );
			$message=substr( $message,0,500);
			$delete='<a onclick="return confirm(\''.__('Are you sure?','church-admin').'\');" href="'.wp_nonce_url('admin.php?page=church_admin/index.php&section=communications&action=delete_email&email_id='.intval( $row->email_id),'delete_email').'">Delete</a>';
			$resend='<a onclick="return confirm(\''.__('Are you sure?','church-admin').'\');" href="'.wp_nonce_url('admin.php?page=church_admin/index.php&section=communications&action=resend_email&email_id='.intval( $row->email_id),'resend_email').'">Resend to previous recipients</a>';
			$new='<a href="'.wp_nonce_url('admin.php?page=church_admin/index.php&section=communications&action=resend_new&email_id='.intval( $row->email_id),'resend_new').'">'.__('Resend to new recipients','church-admin').'</a>';
			$reedit='<a href="'.wp_nonce_url('admin.php?page=church_admin/index.php&section=communications&action=edit_resend&email_id='.intval( $row->email_id),'resend_new').'">'.__('Edit and send','church-admin').'</a>';

			echo'<tr>
				<td data-colname="'.__('Subject','church-admin').'" class="column-primary">'.$row->subject.'<button type="button" class="toggle-row"><span class="screen-reader-text">show details</span></button></td>	
				<td data-colname="'.__('Delete','church-admin').'">'.$delete.'</td>
				<td data-colname="'.__('Send date','church-admin').'">'.mysql2date(get_option('date_format'),$row->send_date).'</td>
				<td data-colname="'.__('Recipients','church-admin').'">'.count(maybe_unserialize( $row->recipients) ).'</td>
				
				<td data-colname="'.__('Message','church-admin').'">'.$message.'</td>
				<td  data-colname="'.__('Resend','church-admin').'">'.$resend.'</td>
				<td  data-colname="'.__('Resend to new recipients','church-admin').'">'.$new.'</td>
				<td  data-colname="'.__('Edit and send again','church-admin').'">'.$reedit.'</td>
			</tr>';
		}
	}
	}
	else{
		echo'<p>'.__('No emails have been sent yet','church-admin').'</p>';
	}
}
/**
 * Send email function
 *
 * Author:     Andy Moyle
 * Author URI: http://www.churchadminplugin.com
 *
 *
 */
function church_admin_send_email( $email_id=NULL)
{
	global $wpdb;
	
	$member_type=church_admin_member_type_array();
	$gender=get_option('church_admin_gender');
    
	if(!empty( $email_id) )$data=$wpdb->get_row('SELECT * FROM '.CA_EBU_TBL.' WHERE email_id="'.esc_sql( $email_id).'"');
	if(!empty( $_POST['send-email'] ) )
	{

		//handle uploaded attachments
		$upload_dir = wp_upload_dir();
		$attachments=array();
		if  ( $_FILES['userfile1']['size']>0)
		{
			$attachments['1'] = $upload_dir['basedir'].'/church-admin-cache/'.$_FILES['userfile1']['name'];
			$tmpName  = $_FILES['userfile1']['tmp_name'];
			move_uploaded_file( $tmpName,$attachments['1'] );
		}
		if  ( $_FILES['userfile2']['size']>0)
		{
			$attachments['2'] = $upload_dir['basedir'].'/church-admin-cache/'.$_FILES['userfile2']['name'];
			$tmpName  = $_FILES['userfile2']['tmp_name'];
			move_uploaded_file( $tmpName,$attachments['2'] );
		}
		if  ( $_FILES['userfile3']['size']>0)
		{
			$attachments['3'] = $upload_dir['basedir'].'/church-admin-cache/'.$_FILES['userfile3']['name'];
			$tmpName  = $_FILES['userfile3']['tmp_name'];
			move_uploaded_file( $tmpName,$attachments['3'] );
		}

		//handle template & message
		$message=file_get_contents(plugin_dir_path(dirname(__FILE__) ).'includes/email_template.html');
		if(function_exists("mb_convert_encoding") )  {
            $entered_message=wpautop(mb_convert_encoding(stripslashes( $_POST['message'] ), 'HTML-ENTITIES', 'UTF-8') );
        }else
        {
            $entered_message=wpautop(stripslashes( $_POST['message'] ) );
        }
		$message=str_replace('[intro]',$entered_message,$message);
		//sort image floating
		$message=str_replace('class="alignleft','style="float:left;margin:5px;" class="',$message);
		$message=str_replace('class="alignright','style="float:right;margin:5px;" class="',$message);
		$message=str_replace('class="aligncenter','style="  display: block;  margin-left: auto;  margin-right: auto;" class="',$message);
		$message=str_replace('<ol>','<ol style="margin-left:5px;">',$message);
		$message=str_replace('<ul>','<ul style="margin-left:5px;">',$message);
		$message=str_replace('[subject]',$_POST['subject'],$message);//add subject
		if(get_option('church_admin_feedburner') )
		{
			$RSS='&nbsp;<a href="http://feedburner.google.com/fb/a/mailverify?uri='.get_option('church_admin_feedburner').'&amp;loc=en_US">Subscribe to '.get_option('blogname').' blog by Email</a>';
		}else{$RSS='';}
		$message=str_replace('[RSS]',$RSS,$message);
		//twitter url
		if(get_option('church_admin_twitter') )  {$twitter='<a href="http://twitter.com/#!/'.get_option('church_admin_twitter').'" style="text_decoration:none" title="Follow us on Twitter">Twitter</a>&nbsp; ';}else{$twitter='';}
		$message=str_replace('[TWITTER]',$twitter,$message);
		//facebook url
		if(get_option('church_admin_facebook') )  {$facebook='<a href="'.get_option('church_admin_facebook').'" style="text_decoration:none" title="Follow us on Facebook">Facebook</a> &nbsp;';}else{$facebook='';}
		$message=str_replace('[FACEBOOK]',$facebook,$message);
		$message=str_replace('[BLOGINFO]','<a href="'.get_bloginfo('url').'">'.get_bloginfo('url').'</a>',$message);
		$message=str_replace('[HEADER_IMAGE]','<img class="header_image" src="'.get_option('church_admin_email_image').'" alt="" >',$message);
		//copyright year
		$message=str_replace('[year]',date('Y'),$message);
		$filename='Email-'.date('Y-m-d-H-i-s').'.html';
		$message=str_replace('[cache]','<p style="font-size:smaller;text-align:center;margin:0 auto;">'.__('Having trouble reading this?','church-admin').' - <a href="'.content_url('/uploads/church-admin-cache/'.$filename).'">'.__('view in your web browser','church-admin').'</a></p>',$message);

		$handle=fopen( $upload_dir['basedir'].'/church-admin-cache/'.$filename,"w")OR DIE("Couldn't open");
		fwrite( $handle,$message);
		fclose( $handle);
		$sqlsafe['message']=esc_sql( $message);//make message sqlsafe!
		//save build message
		$email_id=$wpdb->get_var('SELECT email_id FROM '.CA_EBU_TBL.' WHERE subject="'.esc_sql(stripslashes( $_POST['subject'] ) ).'" AND message="'.esc_sql( $message).'" AND from_email="'.esc_sql(stripslashes( $_POST['from_email'] ) ).'" AND from_name="'.esc_sql(stripslashes( $_POST['from_name'] ) ).'" AND filename="'.esc_sql(maybe_serialize( $attachments) ).'"');
		if( $email_id)
		{//update
			$wpdb->query('UPDATE '.CA_EBU_TBL.' SET subject="'.esc_sql(stripslashes( $_POST['subject'] ) ).'",message="'.esc_sql( $message).'", from_email="'.esc_sql(stripslashes( $_POST['from_email'] ) ).'" ,from_name="'.esc_sql(stripslashes( $_POST['from_name'] ) ).'",filename="'.esc_sql(maybe_serialize( $attachments) ).'" WHERE email_id="'.esc_sql( $email_id).'"');
		}//end update
		else
		{//insert
			$sql='INSERT INTO '.CA_EBU_TBL.' (subject,message,from_email,from_name,send_date,filename,content) VALUES("'.esc_sql(stripslashes( $_POST['subject'] ) ).'","'.esc_sql( $message).'","'.esc_sql(stripslashes( $_POST['from_email'] ) ).'","'.esc_sql(stripslashes( $_POST['from_name'] ) ).'","'.date('Y-m-d').'","'.esc_sql(maybe_serialize( $attachments) ).'","'.esc_sql( $entered_message).'")';
			$wpdb->query( $sql);
			$email_id=$wpdb->insert_id;
		}//insert
		//when to send!
		$schedule=NULL;
		if(!empty( $_POST['send_date'] ) )
		{
			$check=church_admin_dateCheck( $_POST['send_date'], 5000);
			if( $check)  {$schedule=esc_sql( $_POST['send_date'] );}
		}
		if(!empty( $schedule) )
		{
			//set up wp_cron
			if( !wp_next_scheduled('church_admin_bulk_email') )wp_schedule_event(time(), 'hourly', 'church_admin_bulk_email');
		}
		//find recipients

	if(!empty( $_POST['recipients'] ) )
	{
				$names=array();
				$ids=maybe_unserialize(church_admin_get_people_id(stripslashes( $_POST['recipients'] ) ));
				foreach( $ids AS $value)  {$names[]='people_id = "'.esc_sql( $value).'"';}
				$sql='SELECT  email,first_name, people_id FROM '.CA_PEO_TBL.' WHERE email!="" AND email_send=1 AND '.implode(' OR ',$names).' AND email_send=1 GROUP BY email';
	}

	else
	{
        require_once(plugin_dir_path(__FILE__).'/filter.php');
        $sql=church_admin_build_filter_sql( $_POST['check'],'email');
    }


	//church_admin_debug( $sql);
	//end build recipients sql


	update_option('church_admin_from_name',stripslashes( $_POST['from_name'] ) );
	update_option('church_admin_from_email',stripslashes( $_POST['from_email'] ) );
		$results=$wpdb->get_results( $sql);
		$emails=array();
		if( $results)
		{
			foreach( $results AS $row)
			{
				//add unsub link

				$unsubLink='<strong><a href="'.site_url().'?ca_unsub='.md5( $row->people_id).'">'.__('Unsubscribe','church-admin').'</a> '.__('or','church-admin').' <a href="'.site_url().'/?action=user-email-settings">'.__('update which emails your receive','church-admin').'</a></strong>';
				
				$send_message=str_replace('<!--Unsubscribe-->',$unsubLink,$message);

				if(!empty( $schedule)||get_option('church_admin_cron')!='immediate')
                {

					$emails[]=$row->email;
					if(defined('EMAIL_TEST') )  {church_admin_debug( $row->email."\r\n");echo'<p>'.esc_html( $row->email).' would have got it</p>';}
					elseif(QueueEmail( $row->email,stripslashes( $_POST['subject'] ),str_replace("<!--salutation-->",__('Dear','church-admin').' '.esc_html( $row->first_name).',',$send_message),'',esc_html(stripslashes( $_POST['from_name'] ) ),esc_html(stripslashes( $_POST['from_email'] ) ),$attachments,$schedule) ) echo'<p>'.esc_html( $row->email).' queued</p>';
				}
				else
				{
					$email=$_POST['from_email'];
					$name=$_POST['from_name'];
						add_filter( 'wp_mail_from_name','church_admin_from_name' );
						add_filter( 'wp_mail_from', 'church_admin_from_email');

					add_filter('wp_mail_content_type','church_admin_email_type');
					if(!empty( $row->email) )
					{
						//use native wordpress
						$emails[]=$row->email;

						if(defined('EMAIL_TEST') )  {church_admin_debug( $row->email."\r\n");echo'<p>'.esc_html( $row->email).' would have got it</p>';}
						elseif(wp_mail( $row->email,stripslashes( $_POST['subject'] ),str_replace('<!--salutation-->',__('Dear','church-admin').' '.$row->first_name.',',$send_message),NULL,$attachments) )  {echo'<p>'.esc_html( $row->email).' sent immediately</p>';}
						else {echo $GLOBALS['phpmailer']->ErrorInfo;}
					}
					remove_filter('wp_mail_content_type','church_admin_email_type');
				}
			}
			$wpdb->query('UPDATE '.CA_EBU_TBL.' SET recipients="'.esc_sql(maybe_serialize( $emails) ).'" WHERE email_id="'.esc_sql( $email_id).'"');
		}else{echo '<div class="error fade">'.__('No email addresses found','church-admin').'</p>';}
		//send or queue



	}
	else
	{


		echo'<div class="wrap"><h2>'.__('Bulk Email','church-admin').'</h2>';
		
		echo'<form action="" enctype="multipart/form-data" method="post" >';
		church_admin_recipients();
		//subject
		
		echo'<div class="church-admin-form-group"><label>'.__('Subject','church-admin').'</label><input type="text" class="church-admin-form-control" name="subject" ';
		if(!empty( $data->subject) ) echo ' value="'.esc_html( $data->subject).'"';
		echo'/></div>';

		echo '<p><span id="me" style="text-decoration:underline">'.__('Use me as from name and email values','church-admin').'</span></p>';
		$current_user = wp_get_current_user();
		$user=$wpdb->get_row('SELECT CONCAT_WS(" ",first_name,middle_name,prefix,last_name) AS name, email FROM '.CA_PEO_TBL.' WHERE user_id="'.(int)$current_user->ID.'"');
		if(!empty( $user->email) )
        {
            echo'<script type="text/javascript">
                jQuery(document).ready(function( $)  {
                    $("#me").click(function() {
                        $("#from_name").val("'.esc_html( $user->name).'");
                        $("#from_email").val("'.esc_html( $user->email).'");
                    });
                });
                </script>';
        }
		echo'<div class="church-admin-form-group"><label>'.__('From name','church-admin').'</label><input type="text" class="church-admin-form-control"  id="from_name" name="from_name"  ';
		$from_name=get_option('church_admin_from_name');
		if(!empty( $from_name) ) echo ' value="'.esc_html( $from_name).'"';
		echo'/></div>';
		echo'<div class="church-admin-form-group"><label>'.__('From email','church-admin').'</label><input type="text" class="church-admin-form-control"  id="from_email" name="from_email"  ';
		$from_email=get_option('church_admin_from_email');
		if(!empty( $from_email) ) echo ' value="'.esc_html( $from_email).'"';
		echo'/></div>';
		//attachments
		echo'<div class="church-admin-form-group"><label>'.__('Attachment','church-admin').' 1 (max 500KB):</label><input   type="file" name="userfile1"/></div>';
		echo'<div class="church-admin-form-group"><label>'.__('Attachment','church-admin').' 2 (max 500KB):</label><input   type="file" name="userfile2"/></div>';
		echo'<div class="church-admin-form-group"><label>'.__('Attachment','church-admin').' 3 (max 500KB):</label><input  type="file" name="userfile3"/></div>';
		
		$content = '';
		$editor_id = 'message';
		echo'<div id="poststuff">';
		$content='';
		if(!empty( $data->content) )$content=$data->content;
		wp_editor( $content,'message');
		echo'</div>';
		echo'<div class="church-admin-form-group"><label>'.__('Send now','church-admin').' </label><input type=checkbox id="now" name=schedule value="now" checked="checked"/></div>';
		echo'<div class="church-admin-form-group"><label>'.__('Or schedule?','church-admin').'</label>'.church_admin_date_picker(NULL,'send_date',FALSE,NULL,NULL,NULL,'send_date',FALSE).'</div>';
		echo'<script>jQuery(document).ready(function( $)  {  
		 $("#send_datex").change(function()  {$("#now").prop( "checked", false );});
			});</script>';
        echo'<input type="hidden" name="send-email"  value="TRUE"/>';
		echo'<div class="church-admin-form-group"><input class="button-primary" type="submit" value="'.__('Send','church-admin').'" disabled="disabled"/></div>';

		echo'</form></div>';
	}

}

 /**
 *
 * Recipients form element
 *
 * @author  Andy Moyle
 * @param
 * @return
 * @version  0.945
 *
 *
 *
 */
function church_admin_recipients( $type='email')
{
	global $wpdb;
	if(!empty( $type) && $type=='sms')  {$smsoremail='mobile';}else{$smsoremail='email';}
    $which='email';
    if(!empty( $type) )
    {
        switch( $type)
        {
            case'email': $which='email';break;
            case'sms':$which='sms';break;
            case'push':$which='push';break;
        }
    }
	$member_type=church_admin_member_type_array();
	echo'<p><label>'.__('Type in recipient names, separated by a comma (filters will be ignored)','church-admin').'</label>'.church_admin_autocomplete('recipients','friends','to','').'</p>';
	echo'<p>'.__('Or use the filters below','church-admin').'</p>';
	require_once(plugin_dir_path(__FILE__).'/filter.php');
    church_admin_directory_filter(false,true);

	$response='<h3>'.__('Recipients','church-admin').'</h3><p>'.__('Everyone will get this, unless you add some filters','church-admin').'</p>';
	$nonce = wp_create_nonce("church_admin_filter");
    echo'<script>
		jQuery(document).ready(function( $) {
        $("#filtered-response").html("'.$response.'");
	//handle send button disabled while no selections
     $(\'input[type="submit"]\').prop(\'disabled\', true);
     $(\'input[type="text"]\').keyup(function() {
        if( $(this).val() != "") {
           $(\':input[type="submit"]\').prop(\'disabled\', false);
          
        }
     });



			$(".all").on("change", function()  {
				var id = this.id;

				$("input."+id).prop("checked", !$("."+id).prop("checked") )
			});
		   
		   
		   function doFilter()  {

      			var category_list = [];
				var exclude= $("#exclude").val();
      			$("#filters1 :input:checked").each(function()  {


        			var category = $(this).val();
        			category_list.push(category);

        		});


      			var data = {
				"action": "church_admin",
				"method":"filter_email",
				"type":"'.$which.'",
				"exclude":exclude,
				"data": category_list,
				"nonce": "'.$nonce.'"
				};
				console.log(data);
				$("#filtered-response").html(\'<p style="text-align:center"><img src="'.admin_url().'/images/wpspin_light-2x.gif"/></p>\');
				// since 2.8 ajaxurl is always defined in the admin header and points to admin-ajax.php
				jQuery.post(ajaxurl, data, function(response) {
				console.log(response);
					$("#filtered-response").html("<h3>"+response+"</h3>");
					$(\':input[type="submit"]\').prop(\'disabled\', false);
				});
			};
			$(".category").on("change",doFilter);
			$("#exclude").on("change",doFilter);

		});
	</script>
	';
}

function getTweetUrl( $url, $text)

{

$maxTitleLength = 120 ;

if (strlen( $text) > $maxTitleLength) {

$text = substr( $text, 0, ( $maxTitleLength-3) ).'...';

}

$text=str_replace('"','',$text);

$outputurl='http://twitter.com/share?wrap_links=true&amp;url='.urlencode( $url).'&amp;text='.urlencode( $text);

$output='<a href="http://twitter.com/share" class="twitter-share-button" data-url="'.$outputurl.'" data-text="'.$text.'" data-count="horizontal">Tweet</a>';

return $output;

}

function church_admin_resend( $email_id)
{
	global $wpdb;
	$email=$wpdb->get_row('SELECT * FROM '.CA_EBU_TBL.' WHERE email_id="'.esc_sql( $email_id).'"');

	if(!empty( $email) )
	{
		$addresses=maybe_unserialize( $email->recipients);
		foreach( $addresses AS $key=>$emailadd)
			{
				if(!empty( $schedule)||get_option('church_admin_cron')!='immediate')
                {

					if(QueueEmail( $emailadd,$email->subject,$email->message,'',$email->from_name,$email->from_email,$email->filename,$email->schedule) ) echo'<p>'.esc_html( $emailadd).' queued</p>';
				}
				else
				{
					add_filter('wp_mail_content_type','church_admin_email_type');
					if(!empty( $emailadd) )
					{
						//use native wordpress

						$headers="From: ".esc_html( $email->from_name)." <".esc_html( $email->from_email).">\n";

						if(wp_mail( $emailadd,$email->subject,$email->message,$headers,$email->filename) )  {echo'<p>'.esc_html( $emailadd).' sent immediately</p>';}
						else {echo $GLOBALS['phpmailer']->ErrorInfo;}
					}
					remove_filter('wp_mail_content_type','church_admin_email_type');
				}
			}


	}
}

function church_admin_resend_new( $email_id)
{
 	global $wpdb;
	echo'<h2>'.__('Resending email to new recipients','church-admin').'</h2>';
	//get the original email
	$email=$wpdb->get_row('SELECT * FROM '.CA_EBU_TBL.' WHERE email_id="'.esc_sql( $email_id).'"');
	//process sending
	if(!empty( $_POST['resend_new'] ) )
	{

		//find recipients
		switch( $_POST['type'] )
		{
			case 'gender':
				$sql='SELECT email, first_name FROM '.CA_PEO_TBL.' WHERE email!="" AND email_send=1  AND sex="'.esc_sql( $_POST['sex'] ).'"';
			break;
			case 'site':
				$sql='SELECT email, first_name FROM '.CA_PEO_TBL.' WHERE email!="" AND email_send=1 AND site_id="'.intval( $_POST['site_id'] ).'"';
			break;
			case 'autocomplete':
				$names=array();
				$ids=maybe_unserialize(church_admin_get_people_id(stripslashes( $_POST['recipients'] ) ));

				foreach( $ids AS $value)  {$names[]='people_id = "'.esc_sql( $value).'"';}
				$sql='SELECT  email,first_name FROM '.CA_PEO_TBL.' WHERE email!="" AND email_send=1 AND '.implode(' OR ',$names);

			break;
			case 'smallgroup':
				$sql='SELECT DISTINCT a.email,a.first_name FROM '.CA_PEO_TBL.' a,'.CA_MET_TBL.' b WHERE a.email!="" AND email_send=1 AND b.meta_type="smallgroup"  AND b.ID="'.esc_sql( $_POST['group_id'] ).'" AND a.people_id=b.people_id';
			break;
			case 'member_types':
				 $w=array();
				$where='(';
				foreach( $_POST['member_type'] AS $key=>$value)if(array_key_exists( $value,$member_type) )$w[]=' member_type_id='.$value.' ';
				$where.=implode("||",$w).')';
				$sql='SELECT email, first_name FROM '.CA_PEO_TBL.' WHERE email!="" AND email_send=1 AND "'.$where;
			break;
			case 'individuals':
				$names=array();
				foreach ( $_POST['person'] AS $value)  {$names[]='people_id = "'.esc_sql( $value).'"';}
				$sql='SELECT  email,first_name FROM '.CA_PEO_TBL.' WHERE email!="" AND email_send=1 AND '.implode(' OR ',$names);
			break;
			case 'ministries':
				foreach( $_POST['role_id'] AS $key=>$value)$r[]='b.ID='.$value;
				$sql='SELECT  a.email,a.first_name FROM '.CA_PEO_TBL.' a,'.CA_MET_TBL.' b WHERE b.meta_type="ministry" AND b.people_id=a.people_id AND a.email!="" AND email_send=1 AND ('.implode( " || ",$r).')' ;
			break;
			case 'hope_team':
				foreach( $_POST['hope_team_id'] AS $key=>$value)$r[]='b.ID='.$value;
				$sql='SELECT  a.email,a.first_name FROM '.CA_PEO_TBL.' a,'.CA_MET_TBL.' b WHERE b.meta_type="hope_team" AND b.people_id=a.people_id AND a.email!="" AND email_send=1 AND ('.implode( " || ",$r).')' ;
			break;
		}

		$results=$wpdb->get_results( $sql);
		$emails=array();
		if( $results)
		{
			foreach( $results AS $row)
			{
				if(get_option('church_admin_cron')!='immediate')
                {
					$emails[]=$row->email;
					if(!empty( $row->email) )
					{
                        if(QueueEmail( $row->email,$email->subject,str_replace("<!--salutation-->",__('Dear','church-admin').' '.esc_html( $row->first_name).',',$email->message),'',esc_html( $email->from_name),esc_html( $email->from_email),$email->attachments,$schedule) ) echo'<p>'.esc_html( $row->email).' queued</p>';
                    }
				}
				else
				{
					add_filter('wp_mail_content_type','church_admin_email_type');
					if(!empty( $row->email) )
					{
						//use native wordpress
						$emails[]=$row->email;
						$headers="From: ".esc_html( $row->first_name)." <".esc_html( $email->from_email).">\n";

						if(wp_mail( $row->email,$email->subject,str_replace('<!--salutation-->',__('Dear','church-admin').' '.$row->first_name.',',$email->message),$headers,$email->attachments) )  {echo'<p>'.esc_html( $row->email).' sent immediately</p>';}
						else {echo $GLOBALS['phpmailer']->ErrorInfo;}
					}
					remove_filter('wp_mail_content_type','church_admin_email_type');
				}
			}

		}else{echo '<div class="error fade">'.__('No email addresses found','church-admin').'</p>';}
	}
	else
	{//form to choose and send
		echo'<h2>'.__('Choose recipients to resend to','church-admin').'</h2>';
		echo'<form action="" method="POST">';
		echo church_admin_recipients();
		echo'<table class="form-table"><tr><th scope="row">&nbsp;</th><td><input type="hidden" name="resend_new" value="TRUE"/><input class="button-primary" type="submit" value="'.__('Send','church-admin').'"/></td></tr>';
		echo'</tbody></table></form>';
	}
}


function church_admin_send_mailchimp()
{
	global $wpdb;

	/*****************************
    * Initiate MailChimp
    ****************************/
    require_once(plugin_dir_path(dirname(__FILE__) ).'includes/mailchimp.inc.php');
    require_once(plugin_dir_path(dirname(__FILE__) ).'includes/mailchimp.php');
    $mailChimpSettings=get_option('church_admin_mailchimp');
    if ( empty( $mailChimpSettings['api_key'] )||empty( $mailChimpSettings['listID'] ) )
    {
        if(defined('CA_DEBUG') )church_admin_debug("No MailChimp Settings");
        return;
    }
	try{
		$MailChimp = new MailChimp( $mailChimpSettings['api_key'] );
	}
	catch(Exception $e)
	{
		echo'<div class="notice notice-danger"><h2>'.__('Failed to connect to MailChimp','church-admin').'</h2><p>'.esc_html( $e->getMessage() ).'</p></div>';	
		church_admin_debug( $e->getMessage() );
			return;
	}
  
    $MailChimp->verify_ssl = 'false';
    
    /*****************************
    * Get tag ids
    ****************************/
    church_admin_get_mailchimp_tags();//refresh first
    $mailChimpTags=get_option('church_admin_mailchimp_tags');
    if ( empty( $mailChimpTags) )
    {
        if(defined('CA_DEBUG') )church_admin_debug("No MailChimp Tags");
        return;
    }
	
	$MailChimp = new MailChimp( $mailChimpSettings['api_key'] );
	$MailChimp->verify_ssl = 'false';
	
	if(!empty( $_POST['send'] )&& !empty( $_POST['tags'] ) )
	{
		/*****************
		* get tag id
		*****************/
		$conditions=array();
		foreach( $_POST['tags'] AS $key=>$tagID)
		{
			$conditions[]=array('condition_type'=>'StaticSegment','op'=>'static_is','field'=>'static_segment','value'=>$tagID);
		}
		$segment_opts =array
		(
			'match' => 'any', // or 'all' or 'none'
			'conditions'=>$conditions
		);
		/*****************
		* Add campaign
		*****************/
		/*******************
     	* Create campaign
		* *****************/

		if(!empty( $_POST['from_email'] ) )
		{
			$fromEmail=stripslashes( $_POST['from_email'] );
		}
		else $fromEmail = get_option('admin_email');
		if(!empty( $_POST['from_name'] ) )
		{
			$fromName=stripslashes( $_POST['from_name'] );
		}
		else $fromName = get_option('name');
		$args=array(
			'type'=>'regular',
			'recipients'=>array('list_id'=>$mailChimpSettings['listID'],'segment_opts'=>$segment_opts),
			'settings'=>array('subject_line' => stripslashes( $_POST['subject'] ),
								'reply_to' => $fromEmail ,
								'from_name' => $fromName,
								'from_email' => $fromEmail,
								'to_name' => '*|FNAME|* *|LNAME|*'
							)
		);
		if(defined('CA_DEBUG') )church_admin_debug("Campaign Args");
		if(defined('CA_DEBUG') )church_admin_debug(print_r( $args,TRUE) );
		$response=$MailChimp->post("campaigns",$args);
		/*******************
		 * Log Response
		 ******************/
		if (!empty( $response) && defined('CA_DEBUG') ) 
		{
			church_admin_debug( "Post Campaign Response\r\n");
			church_admin_debug(print_r( $response,TRUE) );
		}
		$campaignID=$response['id'];
		if(defined('CA_DEBUG') )church_admin_debug("Campaign ID: ".$campaignID);
		/*******************
		 * Add Content
		 ******************/
		$message= church_admin_prepare_post_for_email(stripslashes( $_POST['message'] ),NULL,NULL);
		$message.='<p><a href="'.site_url().'/?action=user-email-settings">'.__('Update which emails you receive','church-admin').'</a></p>';
		$response = $MailChimp->put('campaigns/' . $campaignID . '/content', array('html' => $message ) );
		church_admin_debug(print_r( $response,TRUE) );



		/*******************
		 * Send Campaign out
		 ******************/
		
		if(!empty( $campaignID) )
		{
			$response=$MailChimp->post("campaigns/$campaignID/actions/send",$args);
			if(defined('CA_DEBUG') )church_admin_debug(print_r( $response,TRUE) );
		}
		if (!$MailChimp->success() ) 
		{
			if(defined('CA_DEBUG') )church_admin_debug( "Send Campaign Error\r\n".$MailChimp->getLastError() );
			echo '<p>'.__('Oops something went wrong with sending the campaign, please check the debug log under settings','church-admin');
		}
		else
		{
			echo'<div class="notice notice-success inline"><h2>'.__('Mail queued to send with MailChimp','church-admin').'</h2></div>';
		}
		
	
	
	
	
	
	
	}
	else
	{
		echo'<div class="wrap"><h2>'.__('Send MailChimp Email','church-admin').'</h2>';
		echo'<form action="" method="post">';
		;
		echo'<div class="church-admin-form-group"><label>'.__('Subject','church-admin').'</label><input class="church-admin-form-control" type="text" name="subject" ';
		if(!empty( $data->subject) ) echo ' value="'.esc_html( $data->subject).'"';
		echo'/></div>';
		echo '<p><span id="me" style="text-decoration:underline">'.__('Use me as from name and email values','church-admin').'</span></p>';
		$current_user = wp_get_current_user();
		$user=$wpdb->get_row('SELECT CONCAT_WS(" ",first_name,middle_name,prefix,last_name) AS name, email FROM '.CA_PEO_TBL.' WHERE user_id="'.(int)$current_user->ID.'"');
		echo'<div class="church-admin-form-group"><label>'.__('From name','church-admin').'</label><input type="text" class="church-admin-form-control" id="from_name" name="from_name"  ';
		$from_name=get_option('church_admin_from_name');
		if(!empty( $from_name) ) echo ' value="'.esc_html( $from_name).'"';
		echo'/></div>';
		echo'<div class="church-admin-form-group"><label>'.__('From email','church-admin').'</label><input type="text" id="from_email" name="from_email"  ';
		$from_email=get_option('church_admin_from_email');
		if(!empty( $from_email) ) echo ' value="'.esc_html( $from_email).'"';
		echo'/></div>';
		echo'<p><strong>'.__('Recipient Tags','church-admin').'</strong></p>';
		foreach( $mailChimpTags AS $id=>$tag)
		{
			echo'<input type="checkbox" name=tags[] value="'.esc_html( $id).'"> '.esc_html(ucwords( $tag) ).'<br />';
		}
		echo'</div>';
	
		
		$content = '';
		$editor_id = 'message';
		echo'<div id="poststuff">';
		$content='';
		wp_editor( $content,'message');
		echo'<p><input type="hidden" name="send" value="TRUE"/><input class="button-primary" type="submit" value="'.__('Send','church-admin').'"/></p>';
		echo'</div>';
		
	}
}