<?php

if ( ! defined( 'ABSPATH' ) ) exit('You need Jesus!'); // Exit if accessed directly

/**
 * Outputs Events
 *
 * Author:     Andy Moyle
 * Author URI: http://www.churchadminplugin.com
 *
 *
 */
function church_admin_events()
{
    global $wpdb;
    echo'<h1>'.__('Event ticketing','church-admin').'</h1>';
    $premium=get_option('church_admin_payment_gateway');
        
    if ( empty( $premium) )
    {
        echo'<p>'.__('You can set up events with multiple free tickets','church-admin').'</p>';
        $buttonText=__('Upgrade to premium for paid tickets','church-admin');
    }
    else
    {
        echo'<p>'.__('You can set up events with multiple free and/or paid for tickets','church-admin').'</p>';
        $buttonText=__('PayPal setup','church-admin');
    }
    echo'<p><a class="button-secondary" href="'.wp_nonce_url('admin.php?page=church_admin/index.php&amp;action=paypal-setup','paypal-setup').'">'.$buttonText.'</a></p>';
    echo'<p><a class="button-primary" href="'.wp_nonce_url('admin.php?page=church_admin/index.php&amp;action=edit_event','edit_event').'">'.__('Add an event','church-admin').'</a></p>';
    
    $sql='SELECT * FROM '.CA_EVE_TBL.' ORDER BY event_date DESC';
    $results=$wpdb->get_results( $sql);
    if(!empty( $results) )
    {
        $tableheader='<tr><th class="column-primary">'.__('Event Name','church-admin').'</th>
        <th>'.__('Edit','church-admin').'</th>
        <th>'.__('Delete','church-admin').'</th>
        <th>'.__('Add ticketholder','church-admin').'</th>
        <th>'.__('Date','church-admin').'</th>
        
        <th>'.__('Tickets','church-admin').'</th>';
        if(!empty( $premium) )$tableheader.='<th>'.__('Gross revenue','church-admin').'</th>';
        $tableheader.='<th>'.__('Shortcode','church-admin').'</th><th>'.__('Bookings','church-admin').'</th></tr>';
       echo'<table class="widefat striped wp-list-table"><thead>'.$tableheader.'</thead><tbody>';

       foreach( $results AS $row)
       {
            $bookings=$wpdb->get_var('SELECT COUNT(*) FROM '.CA_BOO_TBL.' WHERE event_id="'.(int)$row->event_id.'"');
            $edit='<a href="'.wp_nonce_url('admin.php?page=church_admin/index.php&amp;action=edit_event&amp;event_id='.(int)$row->event_id,'edit_event').'">'.__('Edit','church-admin').'</a>';
         $view_event='<a title="'.__('View event','church-admin').'" href="'.wp_nonce_url('admin.php?page=church_admin/index.php&amp;action=view_event&amp;event_id='.(int)$row->event_id,'view_bookings').'">'.esc_html( $row->title).'</a>';
        if(!empty( $bookings) )
        {
            $edit='<a title="'.__('Edit event','church-admin').'" href="'.wp_nonce_url('admin.php?page=church_admin/index.php&amp;action=edit_event&amp;event_id='.(int)$row->event_id,'view_bookings').'">'.__("Edit",'church-admin').'</a>';
            $delete=__("Can't be deleted",'church-admin');
        }
        else
        {
             $edit='&nbsp;';
             $delete='<a onclick="return confirm(\''.__('Are you sure?','church-admin').'\');" href="'.wp_nonce_url('admin.php?page=church_admin/index.php&amp;action=delete_event&amp;event_id='.(int)$row->event_id,'delete_event').'">'.__('Delete','church-admin').'</a>';
        }
      
         $addTicketHolder='<a href="'.wp_nonce_url('admin.php?page=church_admin/index.php&amp;action=edit_booking&amp;event_id='.(int)$row->event_id,'edit_booking').'">'.__('Add','church-admin').'</a>';
       
        $bookingsLinks='<a title="'.__('View bookings','church-admin').'" href="'.wp_nonce_url('admin.php?page=church_admin/index.php&amp;action=view_bookings&amp;event_id='.(int)$row->event_id,'view_bookings').'">'.__('View bookings','church-admin').'</a><br /><a href="'.site_url().'/?ca_download=bookings_csv&amp;event_id='.(int)$row->event_id.'&_wpnonce='.wp_create_nonce('bookings_csv').'">'.__('Bookings CSV','church-admin').'</a><br /><a href="'.site_url().'/?ca_download=bookings_pdf&amp;event_id='.(int)$row->event_id.'&_wpnonce='.wp_create_nonce('bookings_pdf').'">'.__('Bookings PDF','church-admin').'</a>';
        $tickets=$wpdb->get_results('SELECT * FROM '.CA_TIK_TBL.' WHERE event_id="'.(int)$row->event_id.'"');
        $revenue=0.0;
        if(!empty( $premium) )
        {
            $currency_symbol=!empty( $premium['currency_symbol'] )?$premium['currency_symbol']:'$';
            $revenue=$wpdb->get_var('SELECT SUM(amount) FROM '.CA_PAY_TBL.' WHERE event_id="'.(int)$row->event_id.'"');
            if(!empty( $revenue) )  {$revenueOutput=esc_html( $currency_symbol.$revenue);}
            else{$revenueOutput='&nbsp;';}
        }
        $ticketsOutput=array();
        $ticketsOutput[]='<a href="'.wp_nonce_url('admin.php?page=church_admin/index.php&amp;action=edit_ticket_type&amp;event_id='.(int)$row->event_id,'edit_ticket').'">'.__('Add a ticket type','church-admin').'</a>'; 
        if(!empty( $tickets) )
        {
           foreach( $tickets AS $ticket)
           {
               $bookings=$wpdb->get_var('SELECT COUNT(*) FROM '.CA_BOO_TBL.' WHERE ticket_type="'.(int)$ticket->ticket_id.'"'); 
                if ( empty( $bookings) )
                {
                    $ticketsOutput[]='<a href="'.wp_nonce_url('admin.php?page=church_admin/index.php&amp;action=edit_ticket_type&amp;ticket_id='.(int)$ticket->ticket_id.'&amp;event_id='.(int)$row->event_id,'edit_ticket').'">'.esc_html( $ticket->name).'</a>';
                }
                else $ticketsOutput[]=esc_html( $ticket->name.' ('.(int)$bookings.')');
           }
        }
          
          echo'<tr>';
          echo'<td class="column-primary" data-colname="'.__('Event name','church-admin').'">'.$view_event.'<button type="button" class="toggle-row">
          <span class="screen-reader-text">show details</span></button></td>';
          echo'<td data-colname="'.__('Edit','church-admin').'">'.$edit.'</td>';
          echo '<td data-colname="'.__('Delete','church-admin').'">'.$delete.'</td>';
          echo'<td data-colname="'.__('Add ticketholder','church-admin').'">'.$addTicketHolder.'</td>';
          echo'<td data-colname="'.__('Date','church-admin').'">'.mysql2date(get_option('date_format').' '.get_option('time_format'),$row->event_date).'</td>';
          
          echo'<td data-colname="'.__('Tickets','church-admin').'">'.implode('<br />',$ticketsOutput).'</td>';
          if(!empty( $premium) )echo'<td data-colname="'.__('Revenue','church-admin').'">'.$revenueOutput.'</td>';
          echo'<td data-colname="'.__('Shortcode','church-admin').'">[church_admin type="event_booking" event_id="'.(int)$row->event_id.'"]</td><td>'.$bookingsLinks.'</td></tr>';

       }
       echo'</tbody><tfoot>'.$tableheader.'</tfoot></table>';
    }
    else{echo'<p>'.__('No events created yet','church-admin').'</p>';}
    

}

function church_admin_view_event( $event_id)
{
    global $wpdb;
    $premium=get_option('church_admin_payment_gateway');
    $event=$wpdb->get_row('SELECT * FROM '.CA_EVE_TBL.' WHERE event_id="'.(int)$event_id.'"');
    if(!empty( $event) )
    {
        echo'<h1>'.esc_html( $event->title).'</h1>';
        echo '<p>'.mysql2date(get_option('date_format').' '.get_option('time_format'),$event->event_date).'</p>';
        echo'<p>'.esc_html( $event->location).'</p>';
        echo '<p>Shortcode: [church_admin type="event" event_id="'.(int)$event_id.'"]</p>';
        echo '<p>'.sprintf(__('Event id for block is %1$s','church-admin'),(int)$event_id).'</p>';
        echo '<p><a href="admin.php?page=church_admin/index.php&action=view_bookings&amp;event_id='.(int)$event_id.'">'.__('View Bookings','church-admin').'</a></p>';
        echo '<h2>'.__('Tickets').'</p>';
        echo'<p><a class="button-primary" href="'.wp_nonce_url('admin.php?page=church_admin/index.php&amp;action=edit_ticket_type&amp;event_id='.(int)$event_id,'edit_ticket').'">'.__('Add a ticket type','church-admin').'</a></p>';
        $tickets=$wpdb->get_results('SELECT * FROM '.CA_TIK_TBL.' WHERE event_id="'.(int)$event_id.'"');
        $revenue=0.0;
        if(!empty( $premium) )
        {
            $revenue=$wpdb->get_var('SELECT SUM(amount) FROM '.CA_PAY_TBL.' WHERE event_id="'.(int)$event_id.'"');
            if(!empty( $revenue) )  {$revenueOutput=esc_html( $premium['currency_symbol'].$revenue);}
            else{$revenueOutput='&nbsp;';}
        }
        if(!empty( $tickets) )
        {
            echo'<p>'.__('Tickets cannot be edited or deleted once there are bookings for that ticket','church-admin').'</p>';
            $thead='<tr><th>'.__("Edit",'church-admin').'</th><th>'.__("Delete",'church-admin').'</th><th>'.__("Ticket",'church-admin').'</th><th>'.__("Description",'church-admin').'</th><th>'.__("Quantity available",'church-admin').'</th><th>'.__("Bookings",'church-admin').'</th></tr>';
            if(!empty( $premium) )
            {
                $thead='<tr><th>'.__("Edit",'church-admin').'</th><th>'.__("Delete",'church-admin').'</th><th>'.__("Ticket",'church-admin').'</th><th>'.__("Description",'church-admin').'</th><th>'.__("Quantity available",'church-admin').'</th><th>'.__("Ticket sales",'church-admin').'</th><th>'.__('Price','church-admin').'</th></tr>';
            }
            echo'<table class="widefat striped"><thead>'.$thead.'</thead><tfoot>'.$thead.'</tfoot><tbody>';
           foreach( $tickets AS $ticket)
           {
               $bookings=$wpdb->get_var('SELECT COUNT(*) FROM '.CA_BOO_TBL.' WHERE ticket_type="'.(int)$ticket->ticket_id.'"'); 
                if ( empty( $bookings) )
                {
                    $edit='<a href="'.wp_nonce_url('admin.php?page=church_admin/index.php&amp;action=edit_ticket_type&amp;ticket_id='.(int)$ticket->ticket_id.'&amp;event_id='.(int)$event_id,'edit_ticket').'">'.__('Edit','church-admin').'</a>';
                    $delete='<a href="'.wp_nonce_url('admin.php?page=church_admin/index.php&amp;action=delete_ticket_type&amp;ticket_id='.(int)$ticket->ticket_id.'&amp;event_id='.(int)$event_id,'delete_ticket').'">'.__('Delete','church-admin').'</a>';
                }else
                {
                    $edit='Not editable';
                    $delete='Not deletable';
                }
               echo'<tr><td>'.$edit.'</td><td>'.$delete.'</td><td>'.esc_html( $ticket->name).'</td><td>'.esc_html( $ticket->description).'</td><td>'.(int)$ticket->quantity.'</td><td>'.(int)$bookings.'</td>';
               if(!empty( $premium) )echo'<td>'.$premium['currency_symbol'].$ticket->ticket_price.'</td>';
               echo'</tr>';
               
           }
             echo'</tbody></table>';
        }
          
    }
}



function church_admin_delete_event( $event_id)
{
    global $wpdb;
    $wpdb->query('DELETE FROM '.CA_BOO_TBL.' WHERE event_id="'.(int)$event_id.'"' );
    $wpdb->query('DELETE FROM '.CA_EVE_TBL.' WHERE event_id="'.(int)$event_id.'"' );
    $wpdb->query('DELETE FROM '.CA_TIK_TBL.' WHERE event_id="'.(int)$event_id.'"' );
            echo'<div class="notice notice-inline"><p><strong>'.__('Event deleted','church-admin').'</strong></p></div>';
        church_admin_events();
}

/*
* Add/Edit Event
*
* @author  Andy Moyle
* @param    $event_id
* @return   html string
* @version  0.1
*
*
*/
function old_church_admin_edit_event( $event_id)
{
    global $wpdb;
    
    $premium=get_option('church_admin_payment_gateway');
 
    echo'<h2>'.__('Add/Edit Event','church-admin').'</h2>';
    if(!empty( $event_id) )  {$data=$wpdb->get_row('SELECT * FROM '.CA_EVE_TBL.' WHERE event_id="'.(int)$event_id.'"');}else{$data=new stdClass();}
    if(!empty( $_POST['edit_event'] ) )
    {

        /****************************
        *
        *   Process Event
        *
        *****************************/
        //clean form input
        $sqlsafe=array();
        foreach ( $_POST AS $key=>$value)  {$sqlsafe[$key]=esc_sql(stripslashes_deep( $value) );}
        $sqlsafe['event_datetime']=$sqlsafe['event_date'].' '.$sqlsafe['event_time'].':00';
        if(!empty( $_POST['medical'] ) )  {$medical=1;}else{$medical=0;}
        if(!empty( $_POST['dietary'] ) )  {$dietary=1;}else{$dietary=0;}
        if(!empty( $_POST['photo_permission'] ) )  {$photo_permission=1;}else{$photo_permission=0;}
        if ( empty( $event_id) )
        {
            $event_id=$wpdb->get_var('SELECT event_id FROM '.CA_EVE_TBL.' WHERE title="'.$sqlsafe['event_title'].'" AND location="'.$sqlsafe['event_location'].'" AND event_date="'.$sqlsafe['event_datetime'].'"');
        }
        if ( empty( $event_id) )
        {
            $wpdb->query('INSERT INTO '.CA_EVE_TBL.' (title,location,event_date,medical,dietary,photo_permission) VALUES ("'.$sqlsafe['event_title'].'","'.$sqlsafe['event_location'].'" ,"'.$sqlsafe['event_datetime'].'","'.$medical.'","'.$dietary.'","'.$photo_permission.'")');
            $event_id=$wpdb->insert_id;
        }
        else
        {
            $wpdb->query('UPDATE '.CA_EVE_TBL.' SET title="'.$sqlsafe['event_title'].'", location="'.$sqlsafe['event_location'].'" , event_date="'.$sqlsafe['event_datetime'].'",photo_permission="'.$photo_permission.'",medical="'.$medical.'", dietary="'.$dietary.'" WHERE event_id="'.(int)$event_id.'"' );
        }
        /*********************************
        *
        * Process Tickets
        *
        **********************************/
        $people_types=get_option('church_admin_people_type');
        for ( $x=0; $x<count( $_POST['ticket_name'] ); $x++)
        {
        
            $ptypes=explode(",",$sqlsafe['people_type_id'][$x] );
            $people_type_ids=array();
            if(!empty( $ptypes) )
            {
               foreach( $ptypes AS $key=>$value)
               {
                   if(in_array(trim( $value),$people_types) )$people_type_ids[]=array_search(trim( $value),$people_types);
               }
            }
            else $people_type_ids=array(0);
            //check if ticket exists
            $ticket_id=$wpdb->get_var('SELECT ticket_id FROM '.CA_TIK_TBL.' WHERE name="'.$sqlsafe['ticket_name'][$x].'" AND available_from="'.$sqlsafe['available_from'][$x].'" AND available_until="'.$sqlsafe['available_until'][$x].'" AND quantity="'.$sqlsafe['ticket_quantity'][$x].'" AND people_type_id="'.esc_sql(serialize( $people_type_ids) ).'" AND event_id="'.(int)$event_id.'"');
            if ( empty( $ticket_id) )
            {
                $sql='INSERT INTO '.CA_TIK_TBL.' (name,available_from,available_until,quantity,people_type_id,event_id) VALUES("'.$sqlsafe['ticket_name'][$x].'","'.$sqlsafe['available_from'][$x].'","'.$sqlsafe['available_until'][$x].'","'.$sqlsafe['ticket_quantity'][$x].'","'.esc_sql(serialize( $people_type_ids) ).'","'.(int)$event_id.'" )';
                if(!empty( $premium) )
                {
                    if ( empty( $sqlsafe['ticket_price'][$x] ) )$sqlsafe['ticket_price'][$x]=0;
                    $sql='INSERT INTO '.CA_TIK_TBL.' (name,available_from,available_until,quantity,people_type_id,event_id,ticket_price) VALUES("'.$sqlsafe['ticket_name'][$x].'","'.$sqlsafe['available_from'][$x].'","'.$sqlsafe['available_until'][$x].'","'.$sqlsafe['ticket_quantity'][$x].'","'.esc_sql(serialize( $people_type_ids) ).'","'.(int)$event_id.'","'.$sqlsafe['ticket_price'][$x].'" )';
                }
                $wpdb->query( $sql);
            }
        }
        echo'<div class="notice notice-inline"><p><strong>'.__('Event saved','church-admin').'</strong></p></div>';
        church_admin_events();
    }
    else 
    {
        echo'<form action="" method="POST">';
        echo '<div class="church-admin-form-group"><label>'.__('Event title','church-admin').'</label><input  type="text" id="event_title" name="event_title" ';
        if(!empty( $data->title) ) echo' value="'.esc_html( $data->title).'" ';
        echo' class="churh-admin-form-control" required="required"/></div>'; 
        echo '<div class="church-admin-form-group"><label>'.__('Event location','church-admin').'</label><input  type="text" id="event_location" name="event_location" ';
        if(!empty( $data->location) ) echo' value="'.esc_html( $data->location).'" ';
        echo' class="churh-admin-form-control" required="required"/></div>';  
        echo '<div class="church-admin-form-group"><label>'.__('Dietary Needs field?','church-admin').'</label><input  type="checkbox" id="dietary" name="dietary" value=1 ';
        if(!empty( $data->dietary) ) echo' checked="checked" ';
        echo' /></div>'; 
        echo '<div class="church-admin-form-group"><label>'.__('Medical information/Allergies field?','church-admin').'</label><input  type="checkbox" id="medical" name="medical" value=1 ';
        if(!empty( $data->medical) ) echo' checked="checked" ';
        echo' /></div>'; 
        echo '<div class="church-admin-form-group"><label>'.__('Photo permission checkbox?','church-admin').'</label><input  type="checkbox" id="photo_permission" name="photo_permission" value=1 ';
        if(!empty( $data->photo_permission) ) echo' checked="checked" ';
        echo' /></div>'; 
        if(!empty( $data->event_date) )  {$date=mysql2date('Y-m-d',$data->event_date);}else{$date=NULL;}
        echo'<div class="church-admin-form-group"><label>'.__('Event Date','church-admin');
		echo'</label>'. church_admin_date_picker( $date,'event_date',FALSE,date('Y'),date('Y')+10,'event_date','event_date');
		echo '</div>';
        if(!empty( $data->event_date) )  {$time=mysql2date('H:i',$data->event_date);}else{$time='';}        
        
        echo '<div class="church-admin-form-group"><label>'.__('Event time','church-admin').'</label><input  type="time" id="event_time" name="event_time" ';
        if(!empty( $data->event_date) ) echo' value="'.$time.'" ';
        echo' class="churh-admin-form-control" required="required"/></div>'; 
        /***************************************************
        *
        *   Tickets
        *
        ***************************************************/
        echo'<h3>'.__('Tickets','church-admin').'</h3>';
        $x=1;
        if(!empty( $event_id) )
        {
            $tickets=$wpdb->get_results('SELECT * FROM '.CA_TIK_TBL.' WHERE event_id="'.(int)$event_id.'"');
            
            if(!empty( $tickets) )
            {
                foreach( $tickets AS $ticket)
                {
                    $sales=$wpdb->get_var('SELECT COUNT(*) FROM '.CA_BOO_TBL.' WHERE ticket_type="'.(int)$ticket->ticket_id.'"');
                   
                    if(!empty( $sales) )  {$disabled=$sales;}else{$disabled=FALSE;}
                    echo church_admin_event_ticket_form( $ticket,$x,$disabled);
                    $x++;
                }
            }else echo church_admin_event_ticket_form(NULL,$x,FALSE);
        }else echo church_admin_event_ticket_form(NULL,$x,FALSE);
        echo '<div class="more-tickets"></div><p><button class="ca-add-ticket button-secondary" data-id="'.(int)$x.'">'.__('Add ticket','church-admin').'</button></p>';
        
        echo'<p><input type="hidden" name="edit_event" value="edit_event"/><input type="submit" value="'.__('Save event','church-admin').'" class="button-primary"/>';
        /***************************************************
        *
        *   jQuery Ticket magic
        *
        ****************************************************/
        
        echo '<script>';
        echo 'jQuery(document).ready(function( $)  {
            $("body").on("click",".ca-delete-ticket",function()  {
                var id="ticket"+$(this).data("id");
                $("#"+id).hide();
            });
            $(".ca-add-ticket").click(function(e)  {
                e.preventDefault();
                var id=$(this).data("id")+1;
                var data={"action":"church_admin","method":"add-ticket","id":id};
						console.log(data);
						$.ajax({
                                    url: ajaxurl,
                                    type: "POST",
                                    data: data,
                                    success: function(res) {
                                        $(".more-tickets").append(res);
                                        var id = $(".ca-add-ticket").data("id")+1;
                                        console.log(id);
                                        $(".ca-add-ticket").data("id",id);
                                    }
                                });
            });
        });';
        echo'</script>';
    }


}

function church_admin_edit_event( $event_id=NULL)
{
    global $wpdb;
    
    $premium=get_option('church_admin_payment_gateway');
 
    
    if(!empty( $event_id) )  {$data=$wpdb->get_row('SELECT * FROM '.CA_EVE_TBL.' WHERE event_id="'.(int)$event_id.'"');}else{$data=new stdClass();}   
    if(!empty( $_POST['edit_event'] ) )
    {
        /****************************
        *
        *   Process Event
        *
        *****************************/
        //clean form input
        $sqlsafe=array();
        foreach ( $_POST AS $key=>$value)  {$sqlsafe[$key]=esc_sql(stripslashes_deep( $value) );}
        $sqlsafe['event_datetime']=$sqlsafe['event_date'].' '.$sqlsafe['event_time'].':00';
        if(!empty( $_POST['medical'] ) )  {$medical=1;}else{$medical=0;}
        if(!empty( $_POST['dietary'] ) )  {$dietary=1;}else{$dietary=0;}
        if(!empty( $_POST['photo_permission'] ) )  {$photo_permission=1;}else{$photo_permission=0;}
        if ( empty( $event_id) )
        {
            $event_id=$wpdb->get_var('SELECT event_id FROM '.CA_EVE_TBL.' WHERE title="'.$sqlsafe['event_title'].'" AND location="'.$sqlsafe['event_location'].'" AND event_date="'.$sqlsafe['event_datetime'].'"');
        }
        if ( empty( $event_id) )
        {
            $wpdb->query('INSERT INTO '.CA_EVE_TBL.' (title,location,event_date,medical,dietary,photo_permission) VALUES ("'.$sqlsafe['event_title'].'","'.$sqlsafe['event_location'].'" ,"'.$sqlsafe['event_datetime'].'","'.$medical.'","'.$dietary.'","'.$photo_permission.'")');
            $event_id=$wpdb->insert_id;
        }
        else
        {
            $wpdb->query('UPDATE '.CA_EVE_TBL.' SET title="'.$sqlsafe['event_title'].'", location="'.$sqlsafe['event_location'].'" , event_date="'.$sqlsafe['event_datetime'].'",photo_permission="'.$photo_permission.'",medical="'.$medical.'", dietary="'.$dietary.'" WHERE event_id="'.(int)$event_id.'"' );
        }
        echo'<div class="notice notice-success inline"><h2>'.__('Event saved','church-admin').'</div>';
        church_admin_view_event( $event_id);
    }
    else
    {
        echo'<h2>'.__('Add/Edit Event','church-admin').'</h2>';
        echo'<form action="" method="POST">';
        
        echo '<div class="church-admin-form-group"><label>'.__('Event title','church-admin').'</label><input  type="text" id="event_title" name="event_title" ';
        if(!empty( $data->title) ) echo' value="'.esc_html( $data->title).'" ';
        echo' class="church-admin-form-control" required="required"/></div>'; 
        echo '<div class="church-admin-form-group"><label>'.__('Event location','church-admin').'</label><input  type="text" id="event_location" name="event_location" ';
        if(!empty( $data->location) ) echo' value="'.esc_html( $data->location).'" ';
        echo' class="church-admin-form-control" required="required"/></div>';  
        if(!empty( $data->event_date) )  {$date=mysql2date('Y-m-d',$data->event_date);}else{$date=NULL;}
        echo'<div class="church-admin-form-group"><label>'.__('Event Date','church-admin');
		echo'</label>'. church_admin_date_picker( $date,'event_date',FALSE,date('Y'),date('Y')+10,'event_date','event_date');
		echo '</div>';
        if(!empty( $data->event_date) )  {$time=mysql2date('H:i',$data->event_date);}else{$time='';}        
        
        echo '<div class="church-admin-form-group"><label>'.__('Event time','church-admin').'</label><input  type="time" id="event_time" name="event_time" ';
        if(!empty( $data->event_date) ) echo' value="'.$time.'" ';
        echo' class="church-admin-form-control" required="required"/></div>';
        echo '<div class="checkbox"><label><input type="checkbox"  name="photo_permission" value="1" ';
        if(!empty( $data->photo_permission) ) echo 'checked="checked" ';
        echo'/>'.__("Photo Permission question",'church-admin').'</label></div>';
        echo '<div class="checkbox"><label><input type="checkbox"  name="dietary" value="1" ';
        if(!empty( $data->dietary) ) echo 'checked="checked" ';
        echo'/>'.__("Dietary question",'church-admin').'</label></div>';
        echo '<div class="checkbox"><label><input type="checkbox"  name="medical" value="1" ';
        if(!empty( $data->medical) ) echo 'checked="checked" ';
        echo'/>'.__("Medical needs question",'church-admin').'</label></div>';
         echo'<p><input type="hidden" name="edit_event" value="edit_event"/><input type="submit" value="'.__('Save event','church-admin').'" class="button-primary"/>';
    }
}

function church_admin_edit_ticket_type( $event_id,$ticket_id=NULL)
{
    global $wpdb;
    $premium=get_option('church_admin_payment_gateway');

    $event=$wpdb->get_row('SELECT * FROM '.CA_EVE_TBL.' WHERE event_id="'.(int)$event_id.'"');
    if(!empty( $ticket_id) )
    {
        $ticket=$wpdb->get_row('SELECT * FROM '.CA_TIK_TBL.' WHERE ticket_id="'.(int)$ticket_id.'"');
        
    }
    echo'<h2>'.sprintf(__('Edit ticket for %1$s','church-admin'),$event->title).'</h2>';
    echo'<p><a class="button-primary" href="'.wp_nonce_url('admin.php?page=church_admin/index.php&amp;action=view-event&amp;event_id='.(int)$event_id,'view_event').'">'.__('View event','church-admin').'</a></p>';
    if(!empty( $_POST['edit-ticket-type'] ) )
    {
        $sqlsafe=array();
        foreach( $_POST AS $key=>$value)$sqlsafe[$key]=esc_sql(stripslashes( $value) );
        if ( empty( $sqlsafe['ticket_price'] ) )$sqlsafe['ticket_price']=0;
        if ( empty( $ticket_id) )$ticket_id=$wpdb->get_var('SELECT ticket_id FROM '.CA_TIK_TBL.' WHERE name="'.$sqlsafe['ticket_name'].'" AND available_from="'.$sqlsafe['available_from'].'" AND available_until="'.$sqlsafe['available_until'].'" AND quantity="'.$sqlsafe['quantity'].'"  AND event_id="'.(int)$event_id.'"');
            if ( empty( $ticket_id) )
            {
                $sql='INSERT INTO '.CA_TIK_TBL.' (name,description,available_from,available_until,quantity,event_id) VALUES("'.$sqlsafe['ticket_name'].'","'.$sqlsafe['description'].'","'.$sqlsafe['available_from'].'","'.$sqlsafe['available_until'].'","'.$sqlsafe['quantity'].'","'.(int)$event_id.'" )';
                if(!empty( $premium) )
                {
                    if ( empty( $sqlsafe['ticket_price'] ) )$sqlsafe['ticket_price']=0;
                    $sql='INSERT INTO '.CA_TIK_TBL.' (name,description,available_from,available_until,quantity,event_id,ticket_price) VALUES("'.$sqlsafe['ticket_name'].'","'.$sqlsafe['description'].'","'.$sqlsafe['available_from'].'","'.$sqlsafe['available_until'].'","'.$sqlsafe['quantity'].'","'.(int)$event_id.'","'.$sqlsafe['ticket_price'].'" )';
                }
                
            }
            else
            {
                
                $sql='UPDATE '.CA_TIK_TBL.' SET name="'.$sqlsafe['ticket_name'].'",description="'.$sqlsafe['description'].'",available_from="'.$sqlsafe['available_from'].'",available_until="'.$sqlsafe['available_until'].'",quantity="'.$sqlsafe['quantity'].'",ticket_price="'.$sqlsafe['ticket_price'].'",event_id="'.(int)$event_id.'" WHERE ticket_id="'.(int)$ticket_id.'"';
            }
            $wpdb->query( $sql);
        echo'<div class="notice notice-success"><h2>'.__('Ticket saved','church-admin').'</h2></div>';
        church_admin_view_event( $event_id);
    }
    else
    {
        echo '<form action="" method="post">';
        echo '<div class="church-admin-form-group"><label>'.__("Ticket name",'church-admin').'</label><input class="church-admin-form-control" type="text" name="ticket_name" ';
        if(!empty( $ticket->name) )echo ' value="'.esc_html( $ticket->name).'" ';
        echo'/></div>';
        echo '<div class="church-admin-form-group"><label>'.__("Ticket description",'church-admin').'</label><textarea class="church-admin-form-control" name="description"> ';
        if(!empty( $ticket->description) )echo esc_textarea( $ticket->description);
        echo'</textarea></div>';
        echo '<div class="church-admin-form-group"><label>'.__("Quantity available",'church-admin').'</label><input class="church-admin-form-control" type="text" name="quantity" ';
        if(!empty( $ticket->quantity) )echo ' value="'.esc_html( $ticket->quantity).'" ';
        echo'/></div>';
        echo '<div class="church-admin-form-group"><label>'.__("Available from",'church-admin').'</label>';
        if(!empty( $ticket->available_from) )  {$from=$ticket->available_from;}else{$from=NULL;}
        echo church_admin_date_picker( $from,'available_from',FALSE,NULL,NULL,'church-admin-form-control','available_from',FALSE);
        echo'</div>';
        echo '<div class="church-admin-form-group"><label>'.__("Available until",'church-admin').'</label>';
        if(!empty( $ticket->available_until) )  {$until=$ticket->available_until;}else{$until=NULL;}
        echo church_admin_date_picker( $until,'available_until',FALSE,NULL,NULL,'church-admin-form-control','available_until',FALSE);
        echo'</div>';
        if(!empty( $premium) )
        {
            echo '<div class="church-admin-form-group"><label>'.__("Ticket price",'church-admin').'</label><input class="church-admin-form-control" type="text" name="ticket_price" ';
            if(!empty( $ticket->ticket_price) )echo ' value="'.esc_html( $ticket->ticket_price).'" ';
            echo'/></div>';
        }
        echo'<p><input type="hidden" name="edit-ticket-type" value="1"/><input type="submit" class="button-primary" value="'.__('Save ticket','church-admin').'"/></p></form>';
    }
}
function church_admin_delete_ticket_type( $event_id,$ticket_id=NULL)
{
    global $wpdb;
    $wpdb->query('DELETE FROM '.CA_TIK_TBL.' WHERE event_id="'.(int)$event_id.'" AND ticket_id="'.(int)$ticket_id.'"');
    echo'<div class="notice notice-success"><h2>'.__('Ticket deleted','church-admin').'</h2></div>';
    church_admin_view_event( $event_id);
    
}
function church_admin_bookings_csv( $event_id)
{
    global $wpdb;
    $event_details=$wpdb->get_row('SELECT * FROM '.CA_EVE_TBL.' WHERE event_id="'.(int)$event_id.'"');
    //church_admin_debug(print_r( $event_details,TRUE) );
    $premium=get_option('church_admin_payment_gateway');
    $csv='"'.__('First Name','church-admin').'","'.__('Last Name','church-admin').'","'.__('Ticket Type','church-admin').'","'.__('Booking Date','church-admin').'","'.__('Contact email','church-admin').'"';
    if(!empty( $premium) )$csv.='"'.__('Ticket price','church-admin').'"';
    if(!empty( $event_details->photo_permission) )$csv.='"'.__('Photo Permission','church-admin').'"';
    if(!empty( $event_details->medical) )$csv.='"'.__('Medical','church-admin').'"';
    if(!empty( $event_details->dietary) )$csv.='"'.__('Dietary Needs','church-admin').'"';
    $csv.="\r\n";
    $results=$wpdb->get_results('SELECT * FROM '.CA_BOO_TBL.' WHERE event_id="'.(int)$event_id.'"');
    if(!empty( $results) )
    {
        foreach( $results AS $row)
        {
            
            $ticket=$wpdb->get_var('SELECT name FROM '.CA_TIK_TBL.' WHERE ticket_id="'.(int)$row->ticket_type.'"');
            $csv.='"'.esc_html( $row->first_name).'","'.esc_html( $row->last_name).'","'.esc_html( $ticket).'","'.esc_html( $row->booking_date).'","'.esc_html( $row->email).'"';
            if(!empty( $premium) )$csv.='"'.$ticket->ticket_price.'"';
            if(!empty( $event_details->photo_permission) )$csv.=',"'.$row->photo_permission.'",';
            if(!empty( $event_details->medical) )$csv.='"'.str_replace('"',"'",$row->medical).'",';
            if(!empty( $event_details->dietary) )$csv.='"'.str_replace('"',"'",$row->dietary).'"';
            $csv.="\r\n";
            
        }
    }
    
    
    header('Content-Description: File Transfer');
	header('Content-Type: application/octet-stream');
	header('Content-Disposition: attachment; filename="bookings.csv"');
	header('Content-Transfer-Encoding: binary');
	header('Expires: 0');
	header('Cache-Control: must-revalidate');
	header('Pragma: public');
	header("Content-Disposition: attachment; filename=\"bookings.csv\"");
	echo $csv;
    exit();
}
function church_admin_bookings_pdf( $event_id)
{
    $premium=get_option('church_admin_payment_gateway');
    global $wpdb;
    $event_details=$wpdb->get_row('SELECT * FROM '.CA_EVE_TBL.' WHERE event_id="'.(int)$event_id.'"');
     require_once(plugin_dir_path(dirname(__FILE__) ).'includes/fpdf.php');
    //initiate PDF
     $pdf = new fpdf();
        // Add a Unicode font (uses UTF-8)
    $pdf->AddFont('DejaVu','','DejaVuSans.ttf',true);
    $pdf->AddFont('DejaVu','B','DejaVuSans-Bold.ttf',true);
    $pdf->SetAutoPageBreak(1,10);    

     $pdf->SetAutoPageBreak(1,15);
     $pdf->AddPage('P',get_option('church_admin_pdf_size') );
     $pageWidth=$pdf->GetPageWidth()-30;
    $colWidth=$pageWidth/5;
     $pdf->SetX(10);
    //title
    $event=$wpdb->get_row('SELECT * FROM '.CA_EVE_TBL.' WHERE event_id ="'.(int)$event_id.'"');
     $title=esc_html(sprintf(__('Bookings for %1$s','church-admin'),$event->title) );
    $pdf->SetFont('DejaVu','B',16);
    $pdf->Cell(0,8,$title,0,1,'C');
    //header
    $pdf->SetFont('DejaVu','B',8);
    $pdf->Cell(5,5,__('No.','church-admin'),1,0,'C');
    $pdf->Cell(25,5,__('First Name','church-admin'),1,0,'C');
    $pdf->Cell(25,5,__('Last Name','church-admin'),1,0,'C');
    $pdf->Cell(25,5,__('Ticket Type','church-admin'),1,0,'C');
    if(!empty( $premium) )$pdf->Cell(25,5,__('Ticket price','church-admin'),1,0,'C');
    $pdf->Cell(25,5,__('Booking Date','church-admin'),1,0,'C');
    $pdf->Cell(0,5,__('Email','church-admin'),1,1,'C');
    $pdf->SetFont('DejaVu','',8);
    $results=$wpdb->get_results('SELECT * FROM '.CA_BOO_TBL.' WHERE event_id="'.(int)$event_id.'"');
    
    if(!empty( $results) )
    {
        $total=0;
        $no=1;
        foreach( $results AS $row)
        {
            
            $ticket=$wpdb->get_row('SELECT * FROM '.CA_TIK_TBL.' WHERE ticket_id="'.(int)$row->ticket_type.'"');
            $pdf->Cell(5,5,$no,1,0,'C');
            $pdf->Cell(25,5,esc_html( $row->first_name),1,0,'C');
            $pdf->Cell(25,5,esc_html( $row->last_name),1,0,'C');
            $pdf->Cell(25,5,esc_html( $ticket->name),1,0,'C');
            if(!empty( $premium) )
            {
                $pdf->Cell(25,5,$premium['currency_symbol'].esc_html( $ticket->ticket_price),1,0,'C');
                $total+=$ticket->ticket_price;
            }
            $pdf->Cell(25,5,mysql2date(get_option('date_format'),$row->booking_date),1,0,'C');
            $pdf->Cell(0,5,esc_html( $row->email),1,1,'C');
            
          
            $no++;
        }
        if(!empty( $premium) )$pdf->Cell(0,5,__('Total','church-admin').': '.$premium['currency_symbol'].number_format( $total,2),1,0,'C');
            
    }
    $pdf->Output();
    exit();
}

function church_admin_view_bookings( $event_id)
{
    global $wpdb;
    $premium=get_option('church_admin_payment_gateway');
    $event=$wpdb->get_row('SELECT * FROM '.CA_EVE_TBL.' WHERE event_id ="'.(int)$event_id.'"');
    $title=esc_html(sprintf(__('Bookings for %1$s','church-admin'),$event->title) );
    echo'<h2>'.$title.'</h2>';
    echo'<p><a class="button-primary" href="'.wp_nonce_url('admin.php?page=church_admin/index.php&amp;action=edit_booking&amp;event_id='.(int)$event->event_id,'edit_booking').'">'.__('Add a ticket (new booking)','church-admin').'</a></p>';
    echo'<p><a href="'.site_url().'/?ca_download=bookings_csv&amp;event_id='.(int)$event->event_id.'&_wpnonce='.wp_create_nonce('bookings_csv').'" class="button-secondary">'.__('Bookings CSV','church-admin').'</a></p><p><a href="'.site_url().'/?ca_download=bookings_pdf&amp;event_id='.(int)$event->event_id.'&_wpnonce='.wp_create_nonce('bookings_pdf').'" class="button-secondary">'.__('Bookings PDF','church-admin').'</a></p>';
    /**********************************************
    *
    *   Put ticket types in array $ticket_types
    *
    ***********************************************/
    $ticket_types_results=$wpdb->get_results('SELECT name,ticket_id FROM '.CA_TIK_TBL.' WHERE event_id="'.(int)$event_id.'"');
    if(!empty( $ticket_types_results) )
    {
       $ticket_types=array();
        foreach( $ticket_types_results AS $row )$ticket_types[$row->ticket_id]=$row->name;
    }
    /*********************************************
    *
    *   Grab Bookings
    *
    ***********************************************/
    //$bookings=$wpdb->get_results('SELECT a.*, CONCAT_WS(" ",b.first_name,b.last_name) AS name FROM '.CA_BOO_TBL.' a  LEFT JOIN '.CA_PEO_TBL.' b ON b.people_id = a.person WHERE a.event_id="'.esc_sql( $event_id).'" ');
    $bookings=$wpdb->get_results('SELECT * FROM '.CA_BOO_TBL.' WHERE event_id="'.esc_sql( $event_id).'" GROUP BY booking_ref ORDER BY booking_date DESC');
    if(!empty( $bookings) )
    {
        $x=1;
        foreach( $bookings AS $booking)
        {
            if ( empty( $booking->booking_ref) )
            {
                //fix for v2.4330
                $booking->booking_ref=md5(print_r( $booking,TRUE) );
                $wpdb->query('UPDATE '.CA_BOO_TBL.' SET booking_ref="'.esc_sql( $booking->booking_ref).'" WHERE ticket_id="'.(int)$booking->ticket_id.'"');
            }
            echo '<h2>'.__('Booking','church-admin').' #'.$x.'</h2>'.church_admin_view_booking( $booking->booking_ref);
            $x++;
        }
    
    }
}

function church_admin_view_booking( $booking_ref)
{
    global $wpdb;
    $premium=get_option('church_admin_payment_gateway');
    $wpdb->show_errors;
    $out='';
    $bookings=$wpdb->get_results('SELECT a.*, CONCAT_WS(" ",b.first_name,b.last_name) AS name, c.ticket_price,c.name AS ticket_name FROM ('.CA_BOO_TBL.' a, '.CA_TIK_TBL.' c)  LEFT JOIN '.CA_PEO_TBL.' b ON b.people_id = a.people_id WHERE a.booking_ref="'.esc_sql( $booking_ref).'" AND a.ticket_type=c.ticket_id');
    
    if(!empty( $_POST['token'] ) && wp_verify_nonce( $_POST['token'],'manual_payment') )
    {
        $out.='<p>Processing payment</p>';
        $check=$wpdb->get_var('SELECT payment_id FROM '.CA_PAY_TBL.' WHERE amount="'.esc_sql( $_POST['manual_payment'] ).'" AND txn_id="Manual" AND booking_ref="'.esc_sql( $_POST['booking_ref'] ).'" AND event_id="'.(int)$_POST['event_id'].'"');
        if ( empty( $check) )
        { 
            $wpdb->query('INSERT INTO '.CA_PAY_TBL.' (amount,booking_ref,event_id,txn_id,payment_date) VALUES ("'.esc_sql( $_POST['manual_payment'] ).'","'.esc_sql( $_POST['booking_ref'] ).'","'.(int)$_POST['event_id'].'","Manual","'.date('Y-m-d H:i:s').'")');
            echo'<div class="notice notice-success">'.__('Manual payment added','church-admin').'</div>';
        }
    }
    if(!empty( $bookings) )
    {
        $total=0;
        $out.='<div class="booking">';
        $out.='<p>'.__('Booking date: ','church-admin').mysql2date(get_option('date_format'),$bookings[0]->booking_date).'</p>';
        $out.='<p>'.__('Booking contact email: ','church-admin').esc_html( $bookings[0]->email).'</p>';
        $out.='<p>'.__('Booking phone: ','church-admin').esc_html( $bookings[0]->phone).'</p>';
        $out.='<table class="widefat table table-bordered table-striped"><thead><tr>';
            if(is_admin() )
            {
                $out.='<th>'.__('Edit','church-admin').'</th><th>'.__('Delete','church-admin').'</th>';
            }
            $out.='<th>'.__('Name','church-admin').'</th><th>'.__('Ticket','church-admin').'</th>';
            if(!empty( $premium) )$out.='<th>'.__('Ticket cost','church-admin').'</th>';
            $out.='</tr></thead><tbody>';
        foreach( $bookings AS $booking)
        {
            if ( empty( $booking->name) )$booking->name=$booking->people_id;
            $out.='<tr>';
            if(is_admin() )
            {
                $edit='<a href="'.wp_nonce_url('admin.php?page=church_admin/index.php&amp;action=edit_booking&amp;event_id='.(int)$booking->event_id.'&amp;ticket_id='.(int)$booking->ticket_id.'&booking_ref='.esc_html( $booking->booking_ref),'edit_booking').'">'.__('Edit','church-admin').'</a>';
                $delete='<a onclick="return confirm(\''.__('Are you sure?','church-admin').'\');" href="'.wp_nonce_url('admin.php?page=church_admin/index.php&amp;action=delete_booking&amp;ticket_id='.(int)$booking->ticket_id,'delete_booking').'">'.__('Delete','church-admin').'</a>';
                $out.='<td>'.$edit.'</td><td>'.$delete.'</th>';
            }
            $out.='<td>'.esc_html( $booking->first_name.' '.$booking->last_name).'</td><td>'.esc_html( $booking->ticket_name).'</td>';
            if(!empty( $premium) )
            {
                $out.='<td>'.esc_html( $premium['currency_symbol'].$booking->ticket_price).'</td>';
                $total+=$booking->ticket_price;
            }
            $out.='</tr>';
        }
        if(!empty( $premium) )
        {
            if(is_admin() )
            {
                $out.='<tr><td>&nbsp;</td><td>&nbsp;</td><td>&nbsp;</td><td>'.__('Total:','church-admin').'</td><td><strong>'.$premium['currency_symbol'].number_format( $total,2).'</strong></td></tr>';
            }
            else
            {
                   $out.='<tr><td>&nbsp;</td><td>'.__('Total:','church-admin').'</td><td>'.$premium['currency_symbol'].number_format( $total,2).'</td></tr>';
            }
            $totalPayments=0;
            $paymentsResults=$wpdb->get_results('SELECT amount,payment_date FROM '.CA_PAY_TBL.' WHERE event_id="'.$booking->event_id.'" AND booking_ref="'.$booking->booking_ref.'"');
            //church_admin_debug( $wpdb->last_query);
            //church_admin_debug(print_r( $paymentResults,TRUE) );
            if(!empty( $paymentsResults) )
            {
                
                
                if(is_admin() )
                {
                    foreach( $paymentsResults AS $payment)
                    {
                        $out.='<tr><td>&nbsp;</td><td>&nbsp;</td><td>'.mysql2date(get_option('date_format').' '.get_option('time_format'),$payment->payment_date).'</td><td>'.__('Payments:','church-admin').'</td><td><strong>'.$premium['currency_symbol'].number_format( $payment->amount,2).'</strong></td></tr>';
                        $totalPayments+=$payment->amount;
                    }
                }
                else
                {
                   foreach( $paymentsResults AS $payment)
                   {
                       $out.='<tr><td>'.mysql2date(get_option('date_format').' '.get_option('time_format'),$payment->payment_date).'</td><td>'.__('Payments:','church-admin').'</td><td>'.$premium['currency_symbol'].number_format( $payment->amount,2).'</td></tr>';
                        $totalPayments+=$payment->amount;
                   }
                }
            }
            $left=$total-$totalPayments;
            if(is_admin() )
             {
                  $nonce=wp_create_nonce('manual_payment');
                  $out.='<tr><td>&nbsp;</td><td>&nbsp;</td><td>&nbsp;</td><td>'.__('Left to pay:','church-admin').'</td><td><strong>'.$premium['currency_symbol'].number_format( $left,2).'</strong></td></tr>';
                  if( $left>0)
                  {    
                      $out.='<tr><td colspan="4"><form action="'.wp_nonce_url('admin.php?page=church_admin/index.php&amp;action=view_bookings&event_id='.$booking->event_id,'view_bookings').'" method="POST"><input type="text" name="manual_payment" placeholder="'.__('Manual payment amount','church-admin').'"/><input type="hidden" name="booking_ref" value="'.esc_html( $booking->booking_ref).'"/><input type="hidden" name="event_id" value="'.esc_html( $booking->event_id).'"/><input type=hidden name="token" value="'.$nonce.'"/><br /><input class="button-secondary" type="submit" value="'.__('Add payment','church-admin').'"/></form></td></tr><tr><td colspan=4>'.__('Please press refresh if a payment is not yet showing','church-admin').'</td></tr>';
                  }
                if( $left<0)$out.='<tr><td colspan=3>&nbsp;</td><td colspan=1><h2 style="color:red">'.__('There is an overpayment on this booking - please action a refund','church-admin').'</h2></td></tr>';
            }
            else
            {
                if( $left>0)
                {
                    $out.='<tr><td>&nbsp;</td><td>'.__('Left to pay:','church-admin').'</td><td>'.$premium['currency_symbol'].number_format( $left,2).'</td></tr>';
                    $out.='<tr><td colspan="2">&nbsp;</td><td><form class="booking-form" action="'.CA_PAYPAL.'" method="POST">';
                    $out.='<input type="hidden" name="cmd" value="_xclick"/>';
                    $out.='<input type="hidden" name="business" value="'.$premium['paypal_email'].'"/>';
                    $out.='<input type="hidden" name="receiver_email" value="'.$premium['paypal_email'].'"/>';
                    $out.='<input type="hidden" name="currency_code" value="'.$premium['paypal_currency'].'"/>';
                    $out.='<input type="hidden" name="custom" value="'.esc_html( $booking->booking_ref).'"/>';
                    $out.='<input type="hidden" name="item_name" value="'.__('Booking payment','church-admin').'"/>';
                    $out.='<input type="hidden" name="amount" value="'.$left.'"/>';
                    $out.='<input type="hidden" name="notify_url" value="'.site_url().'/wp-admin/admin-ajax.php?action=church_admin_paypal_ipn"/>';
                    $out.='<button class="btn btn-danger">'.__('Pay balance with PayPal','church-admin').'</button>';
                    $out.='</td></tr>';
                }
            }
                
        }
        if(is_admin() )$out.='<tr><td colspan=4>'.'<a class="button-primary" href="'.wp_nonce_url('admin.php?page=church_admin/index.php&amp;action=edit_booking&amp;event_id='.(int)$booking->event_id.'&amp;booking_ref='.esc_html( $booking->booking_ref),'edit_booking').'">'.__('Add a ticket','church-admin').'</a></td></tr>';
        $out.='</tbody></table></div>';
    }else{$out.='<p>'.__('No booking found','church-admin').'</p>';}
        
        
    return $out;
}


function church_admin_edit_booking( $ticket_id,$event_id,$booking_ref)
{
    global $wpdb;
    if(!empty( $ticket_id) )$booking_ref=$wpdb->get_var('SELECT booking_ref FROM '.CA_BOO_TBL.' WHERE ticket_id="'.(int)$ticket_id.'"');
    if(!empty( $_POST['save_booking'] )&& wp_verify_nonce( $_POST['save_booking'],'save_booking') )
    {
        if(!empty( $ticket_id) )
        {
            $wpdb->query('UPDATE '.CA_BOO_TBL.' SET first_name="'.esc_sql(stripslashes( $_POST['first_name'] ) ).'", last_name="'.esc_sql(stripslashes( $_POST['last_name'] ) ).'", email="'.esc_sql(stripslashes( $_POST['email'] ) ).'", event_id="'.esc_sql(stripslashes( $_POST['event_id'] ) ).'",ticket_type="'.esc_sql(stripslashes( $_POST['ticket'] ) ).'", booking_ref="'.esc_sql( $booking_ref).'" WHERE ticket_id="'.(int)$ticket_id.'"');
        }
        else
        {
            if ( empty( $booking_ref) )$booking_ref=esc_sql(md5(print_r( $_POST,TRUE) ));
            $wpdb->query('INSERT INTO '.CA_BOO_TBL.' (first_name,last_name,email,ticket_type,event_id,booking_ref,booking_date) VALUES("'.esc_sql(stripslashes( $_POST['first_name'] ) ).'","'.esc_sql(stripslashes( $_POST['last_name'] ) ).'","'.esc_sql(stripslashes( $_POST['email'] ) ).'","'.esc_sql(stripslashes( $_POST['ticket'] ) ).'","'.esc_sql(stripslashes( $_POST['event_id'] ) ).'","'.$booking_ref.'","'.date('Y-m-d').'")');
        }
        echo'<div class="notice notice-success"><p><strong>'.__('Ticket updated','church-admin').'</strong></p></div>';
        
        echo church_admin_view_bookings( $event_id);
    }
    else
    {
        $data=$wpdb->get_row('SELECT * FROM '.CA_BOO_TBL.' WHERE ticket_id="'.(int)$ticket_id.'"');
        echo'<h2>'.__('Edit Ticket','church-admin').'</h2>';
        echo'<form action="" method="post">';
        echo   '<div class="church-admin-form-group"><label>'.__('First Name').'</label><input type="text" name="first_name" ';
        if(!empty( $data->first_name) ) echo ' value="'.esc_html( $data->first_name).'" ';
        echo'/></div>';
        echo   '<div class="church-admin-form-group"><label>'.__('Last Name').'</label><input type="text" name="last_name" ';
        if(!empty( $data->last_name) ) echo ' value="'.esc_html( $data->last_name).'" ';
        echo'/></div>';
        echo   '<div class="church-admin-form-group"><label>'.__('Email').'</label><input type="text" name="email" ';
        if(!empty( $data->email) ) echo ' value="'.esc_html( $data->email).'" ';
        echo'/></div>';
        echo   '<div class="church-admin-form-group"><label>'.__('Ticket').'</label>';
        $ticketSQL='SELECT * FROM '.CA_TIK_TBL.' WHERE event_id ="'.(int)$event_id.'"';
         $tickets=$wpdb->get_results( $ticketSQL);
    
        if(!empty( $tickets) )
        {
        
            $ticketChoice=$cost='';
            foreach( $tickets AS $ticket)
            {
            
                if(!empty( $premium) ) $cost=$premium['currency_symbol'].$ticket->ticket_price;
                echo '<input type="radio" class="caTicket" name="ticket"  ';
                if(!empty( $data->ticket_type) && $data->ticket_type==$ticket->ticket_id) echo 'checked="checked" ';
                echo'value="'.$ticket->ticket_id.'"/>&nbsp;'.esc_html( $ticket->name).' ';
                echo'<br />'."\r\n";
            }
        }
        $nonce=wp_create_nonce('save_booking');
        echo'<div class="church-admin-form-group"><input type="hidden" name="event_id" value="'.(int)$event_id.'"/><input type="hidden" name="save_booking" value="'.$nonce.'"/><input type="submit" class="button-primary"  value="'.__('Save','church-admin').'"/></div></form>';
    }
}
function church_admin_delete_booking( $ticket_id)
{
    global $wpdb;
    $event_id=$wpdb->get_var('SELECT event_id FROM '.CA_BOO_TBL.' WHERE ticket_id="'.(int)$ticket_id.'"');
    
    $wpdb->query('DELETE FROM '.CA_BOO_TBL.' WHERE ticket_id="'.(int)$ticket_id.'"');
    echo'<div class="notice notice-success"><p><strong>'.__('Booking deleted','church-admin').'</strong></p></div>';
    church_admin_view_bookings( $event_id);
}