<?php
if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

function church_admin_facilities( $current=NULL,$facilities_id=1)
{
	global $wpdb;
	echo'<h2>'.__('Use this section to organise facilities like rooms, video projectors','church-admin').'</h2>';
	echo' <p><a class="button-primary" href="'.wp_nonce_url('admin.php?page=church_admin/index.php&amp;action=edit_facility&section=facilities','edit_facility').'">'.__('Add Facility','church-admin').'</a></p>';
    church_admin_facilities_list( $current,$facilities_id);
}

function church_admin_facilities_list( $current=NULL,$facilities_id=1)
{ 
    global $wpdb;
   $licence=get_option('church_admin_app_new_licence');

	$facilities=$wpdb->get_results('SELECT * FROM '.CA_FAC_TBL.' ORDER BY facilities_order');
    if(!empty( $facilities) )
	{
		
        $theader='<tr><th class="column-primary">'.__('Facility','church-admin').'</th><th>'.__('Edit','church-admin').'</th><th>'.__('Delete','church-admin').'</th><th>'.__('Facility Shortcode','church-admin').'</th><th>'.__('Hourly rate','church-admin').'</th><th>'.__('Terms documentation','church-admin').'</th><th>'.__('Admin contact email','church-admin').' </th></tr>';
		echo'<table class="widefat striped wp-list-table"><thead>'.$theader.'</thead><tbody class="content">';
		foreach( $facilities AS $facility)
		{
			$edit='<a href="'.wp_nonce_url('admin.php?page=church_admin/index.php&amp;action=edit_facility&amp;facilities_id='.(int)$facility->facilities_id,'edit_facility').'">'.__('Edit','church-admin').'</a>';

            $delete='<a onclick="return confirm(\''.__('Are you sure?','church-admin').'\');" href="'.wp_nonce_url('admin.php?page=church_admin/index.php&amp;action=delete_facility&facilities_id='.$facility->facilities_id,'delete_facility').'">'.__('Delete','church-admin').'</a>';
            if(!empty( $licence) )
            {
                $premium=get_option('church_admin_payment_gateway');
                if(!empty( $premium['currency_symbol'] ) )  {$currSymbol=$premium['currency_symbol'];} else{$currSymbol='';}
                $hourlyrate=$currSymbol.$facility->hourly_rate;
                $hourlyrate=__('Coming soon','church-admin');
            }
            else
            {
                $hourlyrate='<a href="admin.php?page=church_admin/index.php&action=app&section=app">'.__('Please buy the premium version to set an hourly rate','church-admin').'</a>';
                $hourlyrate=__('Coming soon','church-admin');
            }
            if(!empty( $facility->admin_email) )
            {
                $admin_email='<a href="'.esc_url('mailto:'.$facility->admin_email).'">'.esc_html( $facility->admin_email).'</a>';
            }
            else{$admin_email='&nbsp;';}
            if(!empty( $facility->terms_doc) )
            {
                $terms_doc='<a href="'.esc_url( $facility->terms_doc).'">'.esc_html( $facility->terms_doc).'</a>';
                
            }
            else{$terms_doc='&nbsp;';}
            $terms_doc=__('Coming soon','church-admin');
			echo'<tr  id="'.$facility->facilities_id.'">
                <td data-colname="'.__('Facility','church-admin').'" class="column-primary">'.esc_html( $facility->facility_name).'<button type="button" class="toggle-row"><span class="screen-reader-text">'.__('Show details','church-admin').'</span></button></td>
                <td data-colname="'.__('Edit','church-admin').'">'.$edit.'</td>
                <td data-colname="'.__('Delete','church-admin').'">'.$delete.'</td>
                <td data-colname="'.__('Shortcode','church-admin').'">[church_admin type="calendar" facilities_id="'.$facility->facilities_id.'"]</td>
                <td data-colname="'.__('Hourly rate','church-admin').'">'.$hourlyrate.'</td>
                <td data-colname="'.__('Terms documentation','church-admin').'">'.$terms_doc.'</td>
                <td data-colname="'.__('Admin email','church-admin').'">'.$admin_email.'</td>
            </tr>';

		}
		echo'</tbody><tfoot>'.$theader.'</tfoot></table>';
		
	}
	


}

function church_admin_facility_hire( $facilities_id=NULL)
{
    global $wpdb;
    $facilitiesDetails=array();

    echo'<h1>'.__('Facility Hire','church-admin').'</h1>';
    
    $facilities=$wpdb->get_results('SELECT * FROM '.CA_FAC_TBL.' ORDER BY facilities_order');
    if(!empty( $facilities) )
	{
		echo'<form action="admin.php?page=church_admin/index.php&action=facility-hires&section=facilities&amp;facilities_id='.(int)$facilities_id.'" method="POST"><table><tbody><tr><th scope="row">'.__('Choose facility to view','church-admin').'</th><td><select name="facilities_id">';
		foreach( $facilities AS $fac)
        {
            echo'<option value="'.esc_html( $fac->facilities_id).'">'.esc_html( $fac->facility_name).'</option>';
            $facilitiesDetails[$fac->facilities_id]=esc_html( $fac->facility_name);
        }
		echo'</select><td><input type="submit" class="button-primary" name="'.__('Choose facility','church-admin').'"/></td></tr></tbody></table></form>';
	}
    if ( empty( $facilities_id) ) return;
    $date=date('Y-m-01');
    if(!empty( $_POST['date'] )&&church_admin_checkdate( $_REQUEST['date'] ) )$date=$_REQUEST['date'];
    $year=date('Y',strtotime( $date) );
    $month=date('m',strtotime( $date) );
    $readableDate= date('M Y',strtotime( $date) );
    $sql='SELECT * FROM '.CA_FBK_TBL.' WHERE YEAR(start_date)="'.esc_sql( $year).'" AND MONTH(start_date)="'.esc_sql( $month).'" ORDER BY start_date ASC';
    $results=$wpdb->get_results( $sql);
    if ( empty( $results) )return sprintf(__('No %1$s facility booking for %2$s','church-admin'),$facilitiesDetails[$facilities_id],$readableDate);
    $theader='<tr><th>'.__('Event','church-admin').'</th><th>'.__('Approve','church-admin').'</th><th>'.__('Decline','church-admin').'</th><th>'.__('Date').'</th><th>'.__('Hirer details','church-admin').'</th><th>'.__('Cost','church-admin').'</th><th>'.__('Paid','church-admin').'</tr>';
    echo'<table class="widefat striped wp-list-table"><thead>'.$theader.'</thead><tbody>';
    foreach( $results AS $row)
    {
       if ( empty( $row->admin_approved) )
       {
           $approve='<a class="button-prmary" href=admin.php?page=church_admin/index.php&action=approve-facility-booking&ID='.(int)$row->ID.'&section=facilities">'.__('Approve','church-admin').'</a>';
            $decline='<a  class="button-prmary" href=admin.php?page=church_admin/index.php&action=decline-facility-booking&ID='.(int)$row->ID.'&section=facilities">'.__('Decline','church-admin').'</a>';
       }
       else{$approve=$decline='&nbsp;';}
       $details=esc_html( $row->name).'<br />';
       if(!empty( $row->organisation) )$details.=esc_html( $row->organisation).'<br />';
       $details.=esc_html( $row->address).'<br />';
       $details.='<a href="'.esc_url('tel:'.$row->phone).'">'.esc_html( $row->phone).'</a><br />';
       echo'<tr><td class="column-primary" data-colname="event">'.esc_html( $row->event).'</td>
                <td data-colname="approve">'.$approve.'</td>
                <td data-colname="decline">'.$decline.'</td>
                <td data-colname="date">'.mysql2date(get_option('date_format').' '.get_option('time_format'),$row->start_date.' '.$row->start_time).'</td>
                <td date=colname="hirer">'.$details.'</td>
                <td data-colname="cost">'.esc_html( $row->cost).'</th>
                <td data-colname="paid">'.__('Coming soon').'</th>
            </tr>';

    }
    echo'</tbody><tfoot></table>';
}

function church_admin_facility_bookings( $facilities_id=NULL)
{
    global $wpdb;
    echo'<h1>'.__('Facility bookings','church-admin').'</h1>';
    if ( empty( $facilities_id) )$facilities_id=1;
    $facilities=$wpdb->get_results('SELECT * FROM '.CA_FAC_TBL.' ORDER BY facilities_order');
    if(!empty( $facilities) )
	{
		echo'<form action="admin.php?page=church_admin/index.php&action=facility-bookings&section=facilities&amp;facilities_id='.intval( $facilities_id).'" method="POST"><table><tbody><tr><th scope="row">'.__('Choose facility calendar to view','church-admin').'</th><td><select name="facilities_id">';
		foreach( $facilities AS $fac)  {echo'<option value="'.esc_html( $fac->facilities_id).'">'.esc_html( $fac->facility_name).'</option>';}
		echo'</select><td><input type="submit" class="button-primary" name="'.__('Choose facility','church-admin').'"/></td></tr></tbody></table></form>';
	}
    require_once(plugin_dir_path(dirname(__FILE__) ).'includes/calendar.php');
    echo'<p>'.sprintf(__('The shortcode to show this calendar on a website page or post is %1$s','church-admin'),'[church_admin type="calendar" facilities_id="'.(int)$facilities_id.'"]').'</p>';
	church_admin_new_calendar(time(),$facilities_id);
}
function church_admin_edit_facility( $facilities_id=NULL)
{
    church_admin_module_dropdown('facilities');
    global $wpdb;
    $licence=get_option('church_admin_app_new_licence');
    if(isset( $_POST['edit_facility'] ) )
    {
	    
        $sqlsafe=array();
        foreach( $_POST AS $key=>$value)$sqlsafe[$key]=esc_sql(stripslashes( $value) );
        if ( empty( $facilities_id) )$facilities_id=$wpdb->get_var('SELECT facilities_id FROM '.CA_FAC_TBL.' WHERE facility_name="'.$sqlsafe['facility_name'].'"');
        if ( empty( $sqlsafe['hourly_rate'] ) )$sqlsafe['hourly_rate']=0.00;
	    if(!empty( $facilities_id) )
        {
            $wpdb->query('UPDATE '.CA_FAC_TBL.' SET facility_name="'.$sqlsafe['facility_name'].'",hourly_rate="'.$sqlsafe['hourly_rate'].'",admin_email="'.$sqlsafe['admin_email'].'" WHERE facilities_id="'.esc_sql( $facilities_id).'"');
        }
        else
        {
            $nextorder=1+$wpdb->get_var('SELECT facilities_order FROM '.CA_FAC_TBL.' ORDER BY facilities_order LIMIT 1');
            $wpdb->query('INSERT INTO '.CA_FAC_TBL.'(facilities_order,facility_name,hourly_rate,admin_email)VALUES("'.esc_sql( $nextorder).'","'.$sqlsafe['facility_name'].'","'.$sqlsafe['hourly_rate'].'","'.$sqlsafe['admin_email'].'")');
        }
        
        echo'<div class="notice notice-success inline"><p>'.__('Facility Updated','church-admin').'</p></div>';
        require_once(plugin_dir_path(dirname(__FILE__) ).'includes/calendar.php');
        church_admin_facilities();
    }
    else
    {
        if(!empty( $facilities_id) )
        {
            $facility=$wpdb->get_row('SELECT * FROM '.CA_FAC_TBL.' WHERE facilities_id="'.(int)$facilities_id.'"');
        }
        echo'<h2>';
        if( $facilities_id)  {echo' '.__('Edit','church-admin').' ';}else{echo __('Add','church-admin').' ';}
        echo __('Facility','church-admin').'</h2>';
        if ( empty( $licence) )
        {
            echo'<p><a href="admin.php?page=church_admin/index.php&action=app&section=app">'.__('Please buy the premium version to set an hourly rate','church-admin').'</a></p>';
        }
        echo'<form action="" method="POST"><table class="form-table">';
        echo'<tr><th scope="row">'.__('Facility','church-admin').'</th><td><input type="text" name="facility_name" ';
        if(!empty( $facility->facility_name) )  {
            echo'value="'.esc_html( $facility->facility_name).'" ';
        }
        echo'/></td></tr>';
        if(!empty( $licence) )
        {
            echo'<tr><th scope="row">'.__('Hourly rate','church-admin').'</th><td><input type="text" name="hourly_rate"';
            if(!empty( $facility->hourly_rate) ) echo' value="'.(float)$facility->hourly_rate.'" ';
            echo'</td></tr>';
        }
        echo'<tr><th scope="row">'.__('Admin contact email','church-admin').'</th><td><input type="email" name="admin_email" ';
        if(!empty( $facility->admin_email) )  {
            echo'value="'.esc_html( $facility->admin_email).'" ';
            
        }
        else
        {
            $user=wp_get_current_user();
            echo ' value="'.esc_html( $user->user_email).'" ';
        }
        echo'</td></tr>';

       
        echo'<tr><td colspan=2><input type="hidden" name="edit_facility" value="yes"/><input  class="button-primary"  type="submit" value="'.__('Save Facility','church-admin').' &raquo;" /></td></tr></table></form>';
        
    }
}
function church_admin_delete_facility( $facilities_id=NULL)
{
    global $wpdb;

    if( $facilities_id)
    {
        $wpdb->query('DELETE FROM '.CA_FAC_TBL.' WHERE facilities_id="'.esc_sql( $facilities_id).'"');
        echo'<div class="notice notice-success inline"><p><strong>'.__('Facility Deleted','church-admin').'</strong></p></div>';
    }
    require_once(plugin_dir_path(dirname(__FILE__) ).'includes/calendar.php');
    church_admin_facilities();
}


function church_admin_approve_facility_booking( $booking_id)
{
    global $wpdb;
    $out='<h2>'.__('Facility Booking Approval','church-admin').'</h2>';
    if ( empty( $booking_id) )return $out.'<p>'.__('Incorrect booking id specified','church-admin').'</p>';
    $bookingDetails=$wpdb->get_row('SELECT * FROM '.CA_FBK_TBL.' WHERE ID="'.(int)$booking_id.'"');
    if ( empty( $bookingDetails) )return $out.'<p>'.__('No booking found','church-admin').'</p>';
    $facilityDetails=$wpdb->get_row('SELECT * FROM '.CA_FAC_TBL.' WHERE facilities_id="'.(int)$bookingDetails->facilities_id.'"');
    //update booking to approve
    $wpdb->query('UPDATE '.CA_FBK_TBL.' SET admin_approved=1 WHERE ID="'.(int)$booking_id.'"');

    //generate invoice if premium
    if(!church_admin_app_licence_check() )
    {
        church_admin_facility_booking_invoice( $booking_id);
    }
    else
    {
        $subject = sprintf(__('Approved -  Booking for %1$s on %2$s between %3$s - %4$s','church-admin'),esc_html( $facilityDetails->facility_name),$html['start_date'],$html['start_time'],$html['end_time'] );
        $message='<h2>'.$subject.'</h2>';
        $message.='<table>';
        $message.='<tr><th scope="row">'.__('Event','church-admin').'</th><td>'.esc_html( $bookingDetails->event).'</td></tr>';
        $message.='<tr><th scope="row">'.__('Hirer name','church-admin').'</th><td>'.esc_html( $bookingDetails->name).'</td></tr>';
        if(!empty( $bookingDetails->organisation) )$message.='<tr><th scope="row">'.__('Organisation','church-admin').'</th><td>'.esc_html( $bookingDetails->organisation).'</td></tr>';
        $message.='<tr><th scope="row">'.__('Address','church-admin').'</th><td>'.esc_html( $bookingDetails->address).'</td></tr>';
        $message.='<tr><th scope="row">'.__('Contact number','church-admin').'</th><td>'.esc_html( $bookingDetails->mobile).'</td></tr>';
        $message.='<tr><th scope="row">'.__('Email','church-admin').'</th><td>'.esc_html( $bookingDetails->email_address).'</td></tr>';
        if(!empty( $facilityDetails->terms) )$message.='<tr><th scope="row">'.__('Terms and conditions','church-admin').'</th><td><a href="'.esc_url( $facilityDetails->terms).'">'.__('Download').'</a></td></tr>';
        $message.='<tr><th scope="row">'.__('Booking Status','church-admin').'</th><td>'.__('Approved','church-admin').'</td></tr>';
        $message.='</table>';
        //prepare email
        if(!empty( $facilityDetails->admin_email) )  {$admin_email=$facilityDetails->admin_email;}else{$admin_email=get_option('admin_email');}
        $headers=array('Reply To:'.$admin_email);
        $headers[] = 'Content-type: text/html;charset=utf-8';
        add_filter('wp_mail_content_type','church_admin_email_type');
        add_filter( 'wp_mail_from_name','church_admin_from_name' );
        add_filter( 'wp_mail_from', 'church_admin_from_email');
        //send email to hirer
        wp_mail( $form['email_address'],$subject,$message);
        $out.='<p>'.__('Email sent to booker','church-admin').'</p>';
        $out.=$message; 
    }
       
}

function church_admin_facility_booking_invoice( $booking_id)
{
    global $wpdb;
    if ( empty( $booking_id) )return FALSE;
    $bookingDetails=$wpdb->get_row('SELECT * FROM '.CA_FBK_TBL.' WHERE ID="'.(int)$booking_id.'"');
    if ( empty( $bookingDetails) )return FALSE;
    $facilityDetails=$wpdb->get_row('SELECT * FROM '.CA_FAC_TBL.' WHERE facilities_id="'.(int)$bookingDetails->facilities_id.'"');
    $url=get_option('church_admin_facility_booking_page'.$bookingDetails->facilities_id);



}