<?php
if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly


function church_admin_front_end_register( $member_type_id=1, $exclude=array(), $admin_email=TRUE, $allow=NULL,  $allow_registrations=true)
{
    /******************************************
    *
    *   Setup
    *
    ******************************************/
    global $wpdb;
    $out='';
    church_admin_date_picker_script();
    /******************************************
    *
    *   Check for $_POST['ca-cmd']
    *
    ******************************************/
    if(!empty( $_POST['ca-cmd'] ) )
    {
        church_admin_debug('****** FRONT END REGISTER POSTED *******');
        church_admin_debug($_POST);
        if ( empty( $exclude) ) $exclude=array();
        if ( empty( $allow) ) $allow=array();
        if ( empty( $_POST['nonce'] ) ) return '<p>'.__('No bots please','church-admin').'</p>';
        if(!wp_verify_nonce( $_POST['nonce'],$_POST['ca-cmd'] ) )  {
            church_admin_debug('Nonce fail');
            return '<p>'.__('No bots please','church-admin').'</p>';
        }    
       
        $id=!empty( $_POST['id'] )?(int)sanitize_text_field($_POST['id']):NULL;
        if(!empty( $_POST['ca-email'] ) )  {$enteredEmail=sanitize_email( stripslashes( $_POST['ca-email'] ) );}else{$enteredEmail='';}
        switch( $_POST['ca-cmd'] )
        {
            case 'email-check':
                if(!is_email($enteredEmail))
                {
                    church_admin_debug('email-check scenario 1');
                    $out.='<p>'.__("That wasn't a valid email address", 'church-admin').'</p>';
                }
                elseif( email_exists($enteredEmail) && !church_admin_front_end_email_check())
                {
                    church_admin_debug('email-check scenario 2');
                    //weird scenario where they are a user but not in the directory
                    $out.='<p>'.__('Looks like you have a user account for this site, but no directory entry').'</p>';
                    $out.='</p>'.wp_login_form(array('echo'=>FALSE) ).'<p><a href="'.esc_url( wp_lostpassword_url(get_permalink() ) ).'" alt="'.__( 'Lost Password', 'church-admin' ).'">'.__( 'Lost Password', 'church-admin' ).'</a></p>';
                }
                elseif(!church_admin_front_end_email_check() )
                {
                    church_admin_debug('email-check scenario 3');
                    if(!empty($allow_registrations)){
                        church_admin_debug('ALLOW registrations '.$allow_registrations);
                        $out.=church_admin_front_end_basic_register( $member_type_id,$exclude,$admin_email,$enteredEmail);
                    }else{
                        church_admin_debug('no registrations');
                        $out.='<p>'.__('If you would like to register on this site, please fill out our contact form below.','church-admin').'</p>';
                        require_once(plugin_dir_path(dirname(__FILE__) ).'display/contact.php');
                        $out.=church_admin_contact_public();
                    }  
                }
                else {

                    $person=$wpdb->get_row('SELECT * FROM '.CA_PEO_TBL.' WHERE email="'.esc_sql($enteredEmail).'"');
                    if(empty($person))
                    {
                        //this case should not happen
                        $out.='<p>'.__('An error has occurred, sorry come back soon.','church-admin').'</p>';
                    }
                    elseif(empty($person->gdpr_reason))
                    {
                        //user hasn't responded to confirmation email.
                        $out.='<h2>'.__('Welcome back','church-admin').'</h2>';
                        $out.='<p>'.__('It looks like you have registerd but not yet clicked on the link in the confirmation email. If you have not received it yet, please check your spam folder','church-admin').'</p>';

                    }
                    elseif(empty($person->user_id))
                    {
                        //user has responded to confirmation email but awaiting admin approval.
                        $out.='<h2>'.__('Welcome back','church-admin').'</h2>';
                        $out.='<p>'.__('It looks like you have confirmed your email. An admin will check you directory entry and issue a user account soon','church-admin').'</p>';
                    }
                    else
                    {
                        church_admin_debug('Login screen presented');
                       
                        $out.='<p>'.__('Looks like you are on our system, please login','church-admin').'</p>'.wp_login_form(array('echo'=>FALSE) ).'<p><a href="'.esc_url( wp_lostpassword_url(get_permalink() ) ).'" alt="'.__( 'Lost Password', 'church-admin' ).'">'.__( 'Lost Password', 'church-admin' ).'</a></p>';

                    }
                    
                    
                }
            break; 
            case 'basic-register':
                if(church_admin_front_end_email_check() )
                {
                    $out.='<p>'.__('Looks like you are on our system, please login','church-admin').'</p>'.wp_login_form(array('echo'=>FALSE) ).'<p><a href="'.esc_url( wp_lostpassword_url(get_permalink() ) ).'" alt="'.__( 'Lost Password', 'church-admin' ).'">'.__( 'Lost Password', 'church-admin' ).'</a></p>';
                }
                else {
                    if(!empty($allow_registrations)){
                        church_admin_debug('ALLOW registrations '.$allow_registrations);
                        $out.=church_admin_front_end_basic_register( $member_type_id,$exclude,$admin_email,$enteredEmail);
                    }else{
                        $out.='<p>'.__('If you would like to register on this site, please fill out our contact form below.','church-admin').'</p>';
                        require_once(plugin_dir_path(dirname(__FILE__) ).'display/contact.php');
                        $out.=church_admin_contact_public();
                    }
                }
            break;    
            case 'display-household':
                $out.=church_admin_admin_frontend_display_household();
            break;
            case 'edit-address':
                $household_id=church_admin_frontend_user_can('edit-address',$id);
                if(!$household_id)  {return '<p>'.__('Sorry you cannot do that','church-admin').'</p>';}
                $address=$wpdb->get_row('SELECT * FROM '.CA_HOU_TBL.' WHERE household_id="'.(int)$household_id.'"');
                if (empty( $address) )return"<p>".__('No household address to edit','church-admin')."</p>";
                $out.=church_admin_frontend_edit_address( $address);
            break;
            case 'add-household':
                $out.=church_admin_admin_frontend_add_household();
            break;
            case 'add-person':
                $people_id=NULL;
                $household_id=church_admin_frontend_user_can('edit-person',$id);
                if(!$household_id)  {return '<p>'.__('Sorry you cannot do that','church-admin').'</p>';}
                else $out.=church_admin_frontend_edit_people(NULL,$household_id,$exclude,'add',NULL);   
            break;    
            case 'edit-person':
                $household_id=church_admin_frontend_user_can('edit-person',$id);
                if(!$household_id)  {return '<p>'.__('Sorry you cannot do that','church-admin').'</p>';}
                else $out.=church_admin_frontend_edit_people($id,$household_id,$exclude,'edit',$allow);   
            break;
            case 'delete-person':
                if(!church_admin_frontend_user_can('delete-person',$id) )  {return '<p>'.__('Sorry you cannot do that','church-admin').'</p>';}
                else $out=church_admin_frontend_delete_people( $id);   
            break; 
            case 'delete-household':
                $return=church_admin_delete_household($id);
                if( $return)  {$out='<p>'.__('Your household has been completely deleted','church-admin').'</p>';}
                else{$out='<p>'.__('Household deletion failed, please get in touch','church-admin').'</p>';}
            break;  
            
            case 'add-household-from-user':
                church_admin_debug('***** add-household-from-user *****');
                if(!is_user_logged_in()){
                    church_admin_debug('not logged in');
                    $out.=__('Not logged in','church-admin');
                    return $out;
                    exit();
                }
                $user=wp_get_current_user();
                if(empty($user))
                {
                    church_admin_debug('no user found');
                    $out.=__('user not found','church-admin');
                    return $out;
                    exit();
                }
                $check=$wpdb->get_row('SELECT a.*, b.* FROM '.CA_PEO_TBL.' a, '.CA_HOU_TBL.' b WHERE a.household_id=b.household_id AND a.user_id="'.(int)$user->ID.'"');
                if(!empty($check))
                {
                    church_admin_debug('already a household');
                    $out.=church_admin_admin_frontend_display_household();
                    return $out;
                    exit();
                }
                //create quick household
                $wpdb->query('INSERT INTO '.CA_HOU_TBL.' (address) VALUES( "'.__('Add an address','church-admin').'")');
                $household_id=$wpdb->insert_id;
                church_admin_debug($wpdb->last_query);
                $wpdb->query('INSERT INTO '.CA_PEO_TBL.' (first_name,head_of_household,household_id,email,user_id) VALUES("'.esc_sql($user->user_login).'",1,"'.(int)$household_id.'","'.esc_sql($user->user_email).'","'.(int)$user->ID.'")');
                $out.='<div class="notice notice-success"><p>'.__('Quick household created from your login details, please edit','church-admin').'</p></div>';
                church_admin_debug($wpdb->last_query);
                unset($_POST);
                $out.=church_admin_admin_frontend_display_household();
                return $out;
                exit();

            break;
        }
    }
    else
    {
        if(!is_user_logged_in() )
        {
            /***************************************
            *
            *   First step email to check
            *
            ****************************************/      
            $out.='<div id="ca-first-step">';
            $out.='<h2>'.__('Register/Login','church-admin').'</h2>';
            $out.='<form action="" method="POST"><div class="church-admin-form-group"><label>'.__('Please start with your email address','church-admin').'</label>';
            $out.='<input type="email" id="ca-email-address" name="ca-email" class="church-admin-form-control"></div>';
            $out.=wp_nonce_field('email-check','nonce',FALSE,FALSE);
            $out.='<p><input type="hidden" name="ca-cmd" value="email-check"/><input type="submit" class="btn btn-success" value='.__("Next &raquo;",'church-admin').'"/></p></form></div>';
        }
        else
        {
            church_admin_debug('Login Screen');
            $out.=church_admin_admin_frontend_display_household();
        }
        
        
    }
    //$out.='<script> var beginLat=0; var beginLng=0</script>';

    return $out;
}
                   
/**********************************************************
*
*   Front End user check
*
***********************************************************/
function church_admin_frontend_user_can( $what,$people_id)
{
    global $wpdb;
    if(!is_user_logged_in() )return FALSE;
    
    /***************************************
    *
    *   Get household_id for logged in user
    *
    ****************************************/
    $user=wp_get_current_user();
    $household_id=$wpdb->get_var('SELECT household_id FROM '.CA_PEO_TBL.' WHERE user_id="'.(int)$user->ID.'"');
    if ( empty( $household_id) )return FALSE;
    if(!empty( $people_id) )
    {
        $check=$wpdb->get_var('SELECT people_id FROM '.CA_PEO_TBL.' WHERE household_id="'.(int)$household_id.'" AND people_id="'.(int)$people_id.'"');
        if(!$check)  { return FALSE;}
    }
    return $household_id;
}




/**********************************************************
*   Basic Register
***********************************************************/ 
function church_admin_front_end_basic_register( $member_type_id,$exclude,$admin_email,$enteredEmail)
{
    if(defined('CA_DEBUG') )church_admin_debug("***************************\r\nFRONT END REGISTER ".date('Y-m-d H:i:s') );
    global $wpdb;
    $out='';
    if(defined('CA_DEBUG')&&!empty( $_POST) )church_admin_debug(print_r( $_POST,TRUE) );
    if(!empty( $_POST['save-registration'] )&&!(empty( $_POST['first_name'] ) )&&!(empty( $_POST['last_name'] ) )&&empty( $_POST['funky-bit'] ) && wp_verify_nonce( $_POST['nonce'],'basic-register') )
    { 
       if(defined('CA_DEBUG') )church_admin_debug('Passed quick check');
        
       //sanitize
        $sqlsafe=$form=array();
        if ( empty( $_POST['lat'] ) )$_POST['lat']=NULL;
        if ( empty( $_POST['lng'] ) )$_POST['lng']=NULL;
        foreach( $_POST AS $key=>$value)
        {
            if ( empty( $value) )$value=NULL;
            $form[$key]=church_admin_sanitize( $value);
        }
        //escaped array
        foreach( $form AS $key=>$value)$sqlsafe[$key]=esc_sql( $value);
        
        if(church_admin_spam_check( $form['email'],'email') )
        {
            if(defined('CA_DEBUG') )church_admin_debug('Email field is spam');
            $out.=__('You are acting like a spammer','church-admin');
            return $out;
        }
        foreach( $form AS $key=>$value)
        {
            if(!empty( $form[$key] ) )
            {
                if(church_admin_spam_check( $form[$key],'text') )
                {
                    if(defined('CA_DEBUG') )church_admin_debug('Failed '.$key.' field with '.$form[$key] );
                    return '<p>'.sprintf(__('Unfortunately your input  "%1$s" has failed the spam checks','church-admin'),$form[$key] ).'</p>';
                }
            }
        }
        
       
         
        /***********************************
        *   Save household
        ***********************************/
        //First check if person has been saved
        $household=$wpdb->get_row('SELECT * FROM '.CA_PEO_TBL.' WHERE first_name="'.$sqlsafe['first_name'].'" AND last_name="'.$sqlsafe['last_name'].'" AND email="'.$sqlsafe['email'].'"');
        if( $household)
        {
            $out='<p>'.__('You need to login to edit your entry').'</p>'.wp_login_form(array('echo'=>FALSE) ).'<p><a href="'.esc_url( wp_lostpassword_url(get_permalink() ) ).'" alt="'.__( 'Lost Password', 'church-admin' ).'">'.__( 'Lost Password', 'church-admin' ).'</a></p>';
            return $out;
        }
        else
        {
            //insert address
            $wpdb->query('INSERT INTO '.CA_HOU_TBL.' (address,lat,lng,phone) VALUES("'.$sqlsafe['address'].'","'.$sqlsafe['lat'].'","'.$sqlsafe['lng'].'","'.$sqlsafe['phone'].'")');
            $household_id=$wpdb->insert_id;
            if(defined('CA_DEBUG') )church_admin_debug("*****************\r\nHousehold id is $household_id ");
        }
        $people_id=church_admin_frontend_save_person( $household_id,NULL,1,$member_type_id,NULL);
        if(defined('CA_DEBUG') )church_admin_debug("*****************\r\nPeople id is $people_id ");
        /*********************
        *   Send admin email
        *********************/
        if( $admin_email)
        {
            $adminmessage='<p>'.sprintf(__('A new household has registered. Please %1$s check them %2$s out.','church-admin'),'<a href="'.site_url().'/wp-admin/admin.php?page=church_admin/index.php&action=display_household&household_id='.(int)$household_id.'&section=people">','</a>').'</p>';
            $adminmessage.='<p>'.esc_html(implode(" ",array_filter(array( $form['first_name'],$form['prefix'],$form['last_name'] ) )) ).'</p>';
            if(!empty( $form['email'] ) )$adminmessage.='<p><a href="'.esc_url('mailto:'.$form['email'] ).'">'.esc_html( $form['email'] ).'</a></p>';
            if(!empty( $form['mobile'] ) )$adminmessage.='<p><a href="call:'.esc_url( $form['mobile'] ).'">'.esc_html( $form['mobile'] ).'</a></p>';
            if(!empty( $form['address'] ) )$adminmessage.='<p>'.esc_html( $form['address'] ).'</p>';
            
            add_filter('wp_mail_content_type','church_admin_email_type');
            add_filter( 'wp_mail_from_name','church_admin_from_name' );
            add_filter( 'wp_mail_from', 'church_admin_from_email');
            
            wp_mail(get_option('admin_email'),sprintf(__('New household registration on %1$s','church-admin'),site_url() ),$adminmessage);
            remove_filter('wp_mail_content_type','church_admin_email_type');
            remove_filter( 'wp_mail_from_name','church_admin_from_name' );
            remove_filter( 'wp_mail_from', 'church_admin_from_email');
        }
        /*********************
        *   Send user email
        *********************/
        church_admin_email_confirm( $people_id);
        $out.='<p>'.__('Thank you for registering on the site. You will receive a confirmation email shortly. Please click on the link to confirm your email','church-admin').'</p>';
    	//reset app address list cache
        delete_option('church_admin_app_address_cache');
        delete_option('church_admin_app_admin_address_cache');
    }
    else
    {
        $out.='<h3>'.__('Please fill out form to register','church-admin').'</h3>';
        $out.='<form action="" method="POST">';
        $out.='<input type="hidden" name="ca-cmd" value="basic-register"/>';
        $out.=wp_nonce_field('basic-register','nonce',FALSE,FALSE);
        $allow=array('sites');
        $out.=church_admin_frontend_people_form(NULL,NULL,$exclude,$allow,$enteredEmail);
        
        $out.=church_admin_frontend_address_form(NULL,FALSE);
        
        $out.='<div class="church-admin-form-group"><input type="hidden" name="funky-bit" class="funkybit"/><input type="hidden" name="save-registration" value="1"/><input type="submit" value="'.__('Save','church-admin').'"/></div></form>';
    }
    
    return $out;
    
    
}
/***********************************************************
*
*   Front End Display Household
*
***********************************************************/                   
function church_admin_admin_frontend_display_household()
{
    church_admin_debug('********** church_admin_admin_frontend_display_household() **********');
    global $wpdb;
    $out="";
    if(!is_user_logged_in() ){
        church_admin_debug('not logged in');
        return FALSE;
    }
    /***************************************
    *
    *   Get household_id for logged in user
    *
    ****************************************/
    $user=wp_get_current_user();
    church_admin_debug($user);
    $household=$wpdb->get_row('SELECT * FROM '.CA_PEO_TBL.' WHERE user_id="'.(int)$user->ID.'"');
    church_admin_debug($household);
    church_admin_debug( $wpdb->last_query);
    if ( empty( $household) )
    {
        church_admin_debug('No connected directory entry');
        //first let's just check if the user has an unconnected entry. grab first one, pref head of household
        $household=$wpdb->get_row('SELECT * FROM '.CA_PEO_TBL.' WHERE email="'.esc_sql($user->user_email).'"  LIMIT 1');
        church_admin_debug($wpdb->last_query);
        if(!empty($household))
        {
            church_admin_debug('Users email is in directory, we will connect them to account');

            $wpdb->query('UPDATE '.CA_PEO_TBL.' SET user_id="'.(int)$user->ID.'" WHERE people_id="'.(int)$household->people_id.'"');
        }
        $household=$wpdb->get_row('SELECT * FROM '.CA_PEO_TBL.' WHERE user_id="'.(int)$user->ID.'"');
    }


    if(empty($household))
    {
        church_admin_debug("No people table record for login");
       // $out.='<p>'.$wpdb->last_query.'</p>';
        $message = sprintf( __('User "%1$s" has logged in to the site at %2$s, but does not have a directory entry. Please check what has gone wrong!' , 'church-admin'),esc_html( $user->user_login ), make_clickable(get_permalink()) );
        church_admin_debug( $message );
        add_filter('wp_mail_content_type','church_admin_email_type');
        add_filter( 'wp_mail_from_name','church_admin_from_name' );
        add_filter( 'wp_mail_from', 'church_admin_from_email');
        
        wp_mail(get_option('admin_email'),esc_html(__('User logged in with no directory entry','church-admin') ),$message);
        remove_filter('wp_mail_content_type','church_admin_email_type');
        remove_filter( 'wp_mail_from_name','church_admin_from_name' );
        remove_filter( 'wp_mail_from', 'church_admin_from_email');

        $out.='<p>'.__('No household found for your login. An email has been sent to the site administrator.','church-admin').'</p>';
        $out.='<p>'.church_admin_frontend_button_form('add-household-from-user',$user->user_id,__('Quick household creation','church-admin'),'btn-success').'</p><p>'.__('You can edit at the next step','church-admin').'</p>';
        $out.='<p><a href="'.wp_logout_url( get_permalink() ).'">'.__('Logout','church-admin').'</a></p>';
  
        return $out;
    }
    //sage to procees as user has directory entry
    $address=$wpdb->get_row('SELECT * FROM '.CA_HOU_TBL.' WHERE household_id="'.(int)$household->household_id.'"');
    church_admin_debug( $wpdb->last_query);
    
    
    /*********************************************
    *   Household Title
    *********************************************/
    $out.='<div class="church-admin-register-title"><h2>'.esc_html(church_admin_household_title( $household->household_id) ).'</h2></div>';
    /*********************************************
    *   Image
    *********************************************/
    if(!empty( $address->attachment_id) )
    {
        $household_image_attributes=wp_get_attachment_image_src( $address->attachment_id,'medium','' );
		if ( $household_image_attributes )
        {
            $out.='<p><img src="'.$household_image_attributes[0].'" width="'.$household_image_attributes[1].'" height="'.$household_image_attributes[2].'" class="rounded" style="margin-bottom:10px"/></p>';
        }
       
    }
    /*********************************************
    *   Address
    *********************************************/
    if(!empty( $address->address) )$out.='<p>'.__('Address','church-admin').': '.esc_html( $address->address).'</p>';
    if(!empty( $address->phone) )$out.='<p>'.__('Phone','church-admin').': '.esc_html( $address->phone).'</p>';
    $custom_fields=church_admin_get_custom_fields();
    if(!empty( $custom_fields) )
    {
        foreach( $custom_fields AS $ID=>$field)
        {
            if( $field['section']!='household') continue;
            if( $field['show_me']!=1) continue;

            //note people_id on the CA_CUST_MET_TBL can have the value of household_id!
            $thisData=$wpdb->get_row('SELECT * FROM '.CA_CUST_MET_TBL.' WHERE custom_id="'.(int)$ID.'" AND people_id="'.(int)$address->household_id.'"');
            switch( $field['type'] )
            {
                case 'boolean':
                    if(!empty( $thisData->data) )  {$customOut=__('Yes','church-admin');}else{$customOut=__('No','church-admin');}
                break;
                case 'date':
                    if(!empty( $thisData->data) )  {$customOut=mysql2date(get_option('date_format'),$thisData->data);}else{$customOut="";}
                break;
                default:
                    if(!empty( $thisData->data) )  {$customOut=esc_html( $thisData->data);}else{$customOut="";}
                break;
            }
            if(!empty( $customOut) )$out.=esc_html( $field['name'] ).': '.$customOut.'<br />';
        }
    }
    /*********************************************
    *   Map
    **********************************************/
    $api_key=get_option('church_admin_google_api_key');
	if(!empty( $api_key) )
	{
		$api='';
        if(!empty( $api_key) )$api='key='.$api_key;
        if(!empty( $household_image_attributes) )
        {
            $size=$household_image_attributes[1].'x'.$household_image_attributes[2];
            $mapSize=' width="'.$household_image_attributes[1].'" height="'.$household_image_attributes[2].'"';
        }
        else
        {
            $size='300x225';   
            $mapSize=' width="300" height="225"';
        }
        $url='https://maps.google.com/maps/api/staticmap?'.$api.'&center='.$address->lat.','.$address->lng.'&zoom=15&markers=color:blue%7C'.$address->lat.','.$address->lng.'&size='.$size;
		$map_url=esc_url( $url);
       
		$out.='<p><img src="'.$map_url.'" '.$mapSize.' alt="Map"/></p>'."\r\n\t";

	}
    
    /*********************************************
    *   Edit Address button
    *********************************************/
    $out.='<p>'.church_admin_frontend_button_form('edit-address',$household->people_id,__('Edit address','church-admin'),'btn-success').'</p><p>&nbsp;</p>';
    /*********************************************
    *   People
    *********************************************/
    $people=$wpdb->get_results('SELECT * FROM '.CA_PEO_TBL.' WHERE household_id="'.(int)$household->household_id.'"');
    $out.='<table class="table table-bordered ca-table">';
    foreach( $people AS $person)
    {
        $out.='<tr>';
        $out.='<td data-colname="'.esc_html(__('Name','church-admin')).'">'.esc_html( church_admin_formatted_name( $person ) ).'</td>';
        $out.='<td data-colname="'.esc_html(__('Edit','church-admin')).'">'.church_admin_frontend_button_form('edit-person',$person->people_id,__('Edit person','church-admin'),'btn-success',FALSE).'</td>';
        $out.='<td data-colname="'.esc_html(__('Delete','church-admin')).'">'.church_admin_frontend_button_form('delete-person',$person->people_id,__('Delete person','church-admin'),'btn-danger',TRUE).'</td>';
        if(!empty( $person->attachment_id) )
        {
            $out.='<td data-colname="'.__('Image', 'church-admin' ).'" >'.wp_get_attachment_image( $person->attachment_id,'medium').'</td>';
        }
        else
        {
            
        if(isset( $person->sex) &&$person->sex==1)  {$image='man.svg';}else{$image='woman.svg';}
 
        $out.='<td data-colname="'.__('Image', 'church-admin' ).'"  "><img src="'.plugins_url('/', dirname(__FILE__) ) . 'images/'.$image.'" width="300" height="200"  alt="'.__('No photo yet','church-admin').'"  /></td>';}
        
        $out.='</tr>';
    }
    $out.='<tr><td colspan=4>'.church_admin_frontend_button_form('add-person',NULL,__('Add a person','church-admin'),'btn-success',FALSE).'</td>';
    $out.='</table>';
    $out.='<p>'.church_admin_frontend_button_form('delete-household',$person->household_id,__('Delete Household','church-admin'),'btn-danger',TRUE).'</p>';
    return $out;
}
/***********************************************************
*
*   Front End Button form
*
***********************************************************/ 
function church_admin_frontend_button_form( $what,$id,$text,$cssType,$confirm=FALSE)
{
    if ( empty( $what) ) return NULL;
    $out='<form action="" method="post" ';
    if( $confirm)$out.=' onsubmit="return confirm(\''.__('Are you sure? ','church-admin').$text.'\')"';
    $out.='><input type="hidden" name="ca-cmd" value="'.$what.'"/>';
    if( $id)$out.='<input type="hidden" name="id" value="'.(int)$id.'"/>';
    $out.=wp_nonce_field( $what,'nonce',FALSE,FALSE);
    $out.='<input type="submit" class="btn '.$cssType.' church-admin-register-button" value="'.$text.'" ';
    
    $out.='/></form>';
    return $out;
}


/***********************************************************
*
*   Front End Edit address
*
***********************************************************/
function church_admin_frontend_edit_address( $address)
{
    global $wpdb;
    $out='';
    if(!empty( $_POST['save-address'] )&& wp_verify_nonce( $_POST['save-address'],'save-address') )
    {
        if(defined('CA_DEBUG') )church_admin_debug(print_r( $_POST,TRUE) );
        $sqlsafe=array();
        if(empty($_POST['lat']))$_POST['lat']=null;
        if(empty($_POST['lng']))$_POST['lng']=null;
        foreach( $_POST AS $key=>$value)$sqlsafe[$key]=esc_sql(stripslashes( $value) );
        
        if(!empty( $_POST['household_attachment_id'] ) )  {$attachment_id=(int)$_POST['household_attachment_id'];}else{$attachment_id=NULL;}
        $wpdb->query('UPDATE '.CA_HOU_TBL.' SET attachment_id="'.$attachment_id.'" , address="'.$sqlsafe['address'].'",lat="'.$sqlsafe['lat'].'", lng="'.$sqlsafe['lng'].'",phone="'.$sqlsafe['phone'].'" WHERE household_id="'.(int)$address->household_id.'"');
        /*****************************************************
        * Save Household Custom Fields
        *****************************************************/
        $custom_fields=church_admin_get_custom_fields();

        if(!empty( $custom_fields) )
        {
            $wpdb->query('DELETE FROM '.CA_CUST_MET_TBL.' WHERE household_id="'.(int)$address->household_id.'"');
            foreach( $custom_fields AS $id=>$field)
            {
                if( $field['section']!='household')continue;
                if(isset( $_POST['custom-'.$id] ) )
                {
                    $sql='INSERT INTO  '.CA_CUST_MET_TBL.' (data,household_id,custom_id) VALUES ("'.esc_sql(sanitize_text_field( $_POST['custom-'.$id] ) ).'","'.(int)$address->household_id.'","'.(int)$id.'")';
                    if(defined('CA_DEBUG') )church_admin_debug( $sql);
                    $wpdb->query( $sql);
                }
            }

        }
        $out.='<div class="notice notice-success">'.__('Address saved','church-admin').'</div>';
        $out.=church_admin_admin_frontend_display_household();
    }
    else
    {
        $out.='<h2>'.__('Edit Address','church-admin').'</h3>';
        $out.='<form action="" method="post">';
        $out.='<input type="hidden" name="ca-cmd" value="edit-address"/>';
        $out.=wp_nonce_field('edit-address','nonce',FALSE,FALSE);
        $out.=wp_nonce_field('save-address','save-address',FALSE,FALSE);
        $out.=church_admin_frontend_address_form( $address,TRUE);
        $out.='<div class="church-admin-form-group"><input type="submit" value="'.__('Save','church-admin').'"/></div></form>';
    }
    return $out;
}

/***********************************************************
*
*   Front End Edit person
*
***********************************************************/
//church_admin_frontend_edit_people((int)$_POST['id'],$household_id,$exclude,'edit',$allow)
function church_admin_frontend_edit_people( $people_id,$household_id,$exclude,$which,$allow)
{
    global $wpdb;
    
    $out='';
    if ( empty( $allow) )$allow=array();
    if ( empty( $which) )$which='edit';
    if ( empty( $exclude) )$exclude=array();
    if ( empty( $household_id) )return '<p>'.__('You cannot edit that person','church-admin').'</p>';

    //sort of out whether head_of_household needs setting
    $head_of_household=0;
    if(!empty( $people_id) )$head_of_household=$wpdb->get_var('SELECT head_of_household FROM '.CA_PEO_TBL.' WHERE people_id="'.(int)$people_id.'"');
    $data=$wpdb->get_row('SELECT * FROM '.CA_PEO_TBL.' WHERE people_id="'.(int)$people_id.'"');
    
    if(!empty( $_POST['save-person'] )&& wp_verify_nonce( $_POST['save-person'],'save-person')&&!(empty( $_POST['first_name'] ) )&&!(empty( $_POST['last_name'] ) ))
    {
        church_admin_frontend_save_person( $household_id,$people_id,$head_of_household,NULL,$allow);
        /*****************************************************
        * Message
        *****************************************************/
        $out.='<div class="notice notice-success">'.__('Saved person','church-admin').'</div>';
        $out.=church_admin_admin_frontend_display_household();
    }
    else
    {
        switch( $which)
        {
            case 'edit':
                $title=__('Edit Person','church-admin');
                $data=$wpdb->get_row('SELECT * FROM '.CA_PEO_TBL.' WHERE people_id="'.(int)$people_id.'"');
            break;
            case 'add':
                $title=__('Add Person','church-admin');
                $people_id=NULL;
            break;    
        }
       
        $out.='<div class="church-admin-register-title"><h2>'.$title.'</h2></div>';
        $out.='<form action="" method="POST">';
        /*****************************************************
        * Image
        *****************************************************/
        $out.='<div class="ca-upload-area"  data-which="people" data-id="'.(int)$people_id.'" data-nonce="'.wp_create_nonce("people-image-upload").'" id="uploadfile"><h3>'.__('Photo ','church-admin').'</h3><div class="church-admin-form-group"><label>';
        if(!empty( $data->attachment_id) )
        {
            $out.=wp_get_attachment_image( $data->attachment_id,'medium','', array('class'=>"current-photo",'id'=>'people-image'.(int)$people_id) );
        }
        else
        {
            $out.= '<img src="'.plugins_url('/images/default-avatar.jpg',dirname(__FILE__) ).'" width="300" height="200" id="people-image'.(int)$people_id.'"  alt="'.__('Photo of Person','church-admin').'"  />';
        }
        $out.='<p class="drag-message">'.__('Drag and drop image into this box to replace','church-admin').'</p> </div>';
        $out.='<input type="hidden" name="people_attachment_id" class="attachment_id" id="attachment_id" ';
        if(!empty( $data->attachment_id) )$out.=' value="'.intval( $data->attachment_id).'" ';
        $out.='/><span id="upload-message"></span>';
        $out.='</div>';
        if(!empty( $people_id) )  {$out.='<input type="hidden" name="people_id" value="'.(int)$people_id.'"/>';}
        
        switch( $which)
        {
            case 'edit':
                $out.=wp_nonce_field('edit-person','nonce',FALSE,FALSE);
                $out.='<input type="hidden" name="ca-cmd" value="edit-person"/>';
            break;
            case 'add':
                $out.=wp_nonce_field('add-person','nonce',FALSE,FALSE);
                $out.='<input type="hidden" name="ca-cmd" value="add-person"/>';
            break;
        }
        $out.=wp_nonce_field('save-person','save-person',FALSE,FALSE);
        if ( empty( $data) )$data=NULL;
        
        $out.=church_admin_frontend_people_form( $data,$people_id,$exclude,$allow,NULL);
        $out.='<div class="church-admin-form-group"><input type="submit" value="'.__('Save','church-admin').'"/></div></form>';
       
    }

    return $out;                   
}
/******************************************
*   Front End Delete person
******************************************/
function church_admin_frontend_delete_people( $people_id)
{
    global $wpdb;
    $user=wp_get_current_user();
    $out='';
    $person=$wpdb->get_row('SELECT a.*,b.* FROM '.CA_PEO_TBL.' a, '.CA_HOU_TBL.' b WHERE a.people_id="'.(int)$people_id.'" AND a.household_id=b.household_id');
    if( $person)
    {
        $message = sprintf( __(' "%1$s" has been deleted by %2$s, logged in at %3$s.' , 'church-admin'),esc_html( church_admin_formatted_name($person) ), esc_html($user->user_login ), make_clickable(get_permalink()) );
        if(!empty($person->user_id) && !user_can('manage_options', $person->user_id ) )
        {
            wp_delete_user( $person->user_id,1 );

            $message .= '<p>'.esc_html( __('They had a website user account, which has also been deleted', 'church-admin' ) ).'</p>';

        }
        $number=$wpdb->get_var('SELECT COUNT(*) FROM '.CA_PEO_TBL.' WHERE household_id="'.(int)$person->household_id.'"');
        $wpdb->query('DELETE FROM '.CA_PEO_TBL.' WHERE people_id="'.(int)$people_id.'"');
        if( $number==1)
        {
            $wpdb->query('DELETE FROM '.CA_HOU_TBL.' WHERE household_id="'.(int)$person->household_id.'"');
            $message.='<p>'.__('As it was a single person household, the address details have been deleted.');
        }
        church_admin_head_of_household_tidy( $person->household_id);
    }
     //let admin know
    
        
     church_admin_debug( $message );
     add_filter('wp_mail_content_type','church_admin_email_type');
     add_filter( 'wp_mail_from_name','church_admin_from_name' );
     add_filter( 'wp_mail_from', 'church_admin_from_email');
     
     wp_mail(get_option('admin_email'),esc_html(__('Person deleted from directory','church-admin') ),$message);
     remove_filter('wp_mail_content_type','church_admin_email_type');
     remove_filter( 'wp_mail_from_name','church_admin_from_name' );
     remove_filter( 'wp_mail_from', 'church_admin_from_email');
    $out.='<div class="notice notice-success">'.sprintf(__('%1$s deleted','church-admin'),church_admin_formatted_name($person) ).'</div>';
    $out.=church_admin_admin_frontend_display_household();
    return $out;                  
} 
/*******************************************
*   Front End People Form
*******************************************/ 
function church_admin_frontend_people_form( $data,$people_id,$exclude,$allow,$enteredEmail)
{
    global $wpdb;
        if ( empty( $allow) )$allow=array();
        
        if ( empty( $exclude) )$exclude=array();
        $out='';
       
        if(!empty( $_POST['id'] ) )$out.='<input type="hidden" name="id" value="'.(int)sanitize_text_field($_POST['id']).'"/>';
        /**************************************
        *   First name
        ***************************************/      
        $out.='<div class="church-admin-form-group"><label for="first_name">'.__('First Name','church-admin').' *</label><input placeholder="'.__('First Name','church-admin').'" type="text" required="required" class="church-admin-form-control" name="first_name"';
        if(!empty( $data->first_name) )  {$out.=' value="'.esc_html( $data->first_name).'"';}
        $out.='/></div>';
        /**************************************
        *   Prefix
        ***************************************/
        if(is_array( $exclude)&&!in_array('prefix',$exclude) )
        {
            $out.='<div class="church-admin-form-group"><label for="prefix">'.__('Prefix','church-admin').'</label><input placeholder="'.__('Prefix','church-admin').'" type="text"  class="church-admin-form-control" name="prefix" ';
            if(!empty( $data->prefix) )  {$out.=' value="'.esc_html( $data->prefix).'"';}
            $out.='/></div>';
        }
        /**************************************
        *   Last name
        ***************************************/ 
        $out.='<div class="church-admin-form-group"><label for="last_name">'.__('Last Name','church-admin').' *</label><input placeholder="'.__('Last Name','church-admin').'" type="text" required="required" class="church-admin-form-control" name="last_name" ';
        if(!empty( $data->last_name) )  {$out.=' value="'.esc_html( $data->last_name).'"';}
        $out.='/></div>';
        
       
        
        /**************************************
        *   Email
        ***************************************/ 
        $out.='<div class="church-admin-form-group"><label for="email">'.__('Email address','church-admin').' </label><input placeholder="'.__('Email','church-admin').'" type="email"  class="church-admin-form-control ca-email" name="email"';
        if(!empty( $data->email) )  {$out.=' value="'.esc_html( $data->email).'"';}elseif(!empty( $enteredEmail) )  {$out.=' value="'.esc_html( $enteredEmail).'"';}
        $out.='/></div>';

    
        
        /**************************************
        *   Cell
        ***************************************/ 
        $out.='<div class="church-admin-form-group"><label for="cell">'.__('Cellphone number','church-admin').'</label><input placeholder="'.__('Cellphone number','church-admin').'" type="text" class="church-admin-form-control" name="mobile"';
        if(!empty( $data->mobile) )  {$out.=' value="'.esc_html( $data->mobile).'"';}
        $out.='/></div>';
        
        /**************************************
        *   Date of Birth
        ***************************************/
        if(is_array( $exclude)&&!in_array('date_of_birth',$exclude) )
        {
            if(!empty( $data->date_of_birth) )  {$dob=$data->date_of_birth;}else{$dob=NULL;}
            $out.='<div class="church-admin-form-group"><label for="date_of_birth">'.__('Date of birth','church-admin').'</label>';
            $out.=church_admin_date_picker( $dob,'date_of_birth',FALSE,1910,date('Y'),'date_of_birth','date_of_birth');
            $out.='</div>';
            
        }
        /**************************************
        *   People Type
        ***************************************/
        $people_type=get_option('church_admin_people_type');
        $out.='<div class="church-admin-form-group"><label for="people_type_id">'.__('Person type','church-admin').'</label><select name="people_type_id"  class="people_type_id church-admin-form-control">';
        $first=$option='';
        foreach( $people_type AS $id=>$type)
        {

            if(!empty( $data->people_type_id)&& $id==$data->people_type_id)
            {
                $first='<option value="'.$id.'" selected="selected">'.$type.'</option>'."\r\n";
            }else $option.='<option value="'.$id.'">'.$type.'</option>'."\r\n";


        }
        $out.=$first.$option.'</select></div>'."\r\n";
        /**************************************
        *   Gender
        ***************************************/        
        if(is_array( $exclude)&&!in_array('gender',$exclude) )
        {
            $gender=get_option('church_admin_gender');
            $out.='<div class="church-admin-form-group"><label >'.__('Gender','church-admin').'</label><select name="sex" class="sex church-admin-form-control" >';
            $first=$option='';

            foreach( $gender AS $key=>$value)
            {
                if(isset( $data->sex)&&$data->sex == $key)
                    {
                        $first= '<option value="'.esc_html( $key).'" selected="selected">'.esc_html( $value).'</option>';
                    }
                    else
                    {
                        $option.= '<option value="'.esc_html( $key).'" >'.esc_html( $value).'</option>';
                    }

            }
            $out.=$first.$option.'</select></div>'."\r\n";
        }
        /*****************************************
         * User bio
         ****************************************/
        if(!empty( $data->user_id) && user_can( $data->user_id, 'edit_posts' ) )
        {
            $bio=get_user_meta( $data->user_id,'description',TRUE);
            $allowed_html = wp_kses_allowed_html( 'data' );
            $out.='<div class="church-admin-form-group"><label >'.__('Bio for user','church-admin').'</label><textarea name="bio" style="height:150px" class="church-admin-form-control">';
            if(!empty( $bio) )$out.=wp_kses( $bio,$allowed_html);
            $out.='</textarea></div>';
        }
    /*****************************************************
	* Custom Fields
	*****************************************************/
	$custom_fields=church_admin_get_custom_fields();

	if(is_array( $exclude)&&!empty( $custom_fields)&&!in_array('custom',$exclude) )
	{
		foreach( $custom_fields AS $id=>$field)
		{
            if( $field['section']!='people')continue;
			$dataField='';
			if(!empty( $data->people_id) )$dataField=$wpdb->get_var('SELECT data FROM '.CA_CUST_MET_TBL .' WHERE people_id="'.(int)$data->people_id.'" AND custom_id="'.(int)$id.'"');
			$out.='<div class="church-admin-form-group"><label >'.esc_html( $field['name'] ).'</label>';
			switch( $field['type'] )
			{
				case 'boolean':
					$out.='<input type="radio" data-name="custom-'.$id.'" class="church-admin-form-control"  value="1" name="custom-'.(int)$id.'" ';
					if (isset( $dataField)&&$dataField==1)
						$out.= 'checked="checked" ';
					$out.='>'.__('Yes','church-admin').'<br /> <input type="radio" data-name="custom-'.(int)$id.'" class="church-admin-form-control" value="0" name="custom-'.(int)$id.'" ';
					if (isset( $dataField)&& $dataField==0)
						$out.= 'checked="checked" ';
					$out.='>'.__('No','church-admin');
					break;
				case'text':
					$out.='<input type="text" data-name="custom-'.(int)$id.'" class="church-admin-form-control"  name="custom-'.(int)$id.'" ';
					if(!empty( $dataField)||isset( $field['default'] ) )$out.=' value="'.esc_html( $dataField).'"';
					$out.='/>';
				break;
				case'date':
					$out.= church_admin_date_picker( $dataField,'custom-'.(int)$id,FALSE,1910,date('Y'),'custom-'.(int)$id,'custom-'.(int)$id);

				break;
			}
			$out.='</div>';

		}

	}
    
    /*********************************************
     * Ministries
     * Needs to be allowed to keep form simple
     *********************************************/
    if(!empty( $allow) &&is_array( $allow) && in_array('ministries',$allow) )
    {
        if(!empty( $data->people_id) )$personsMinistries=church_admin_get_people_meta( $data->people_id,'ministry');
        $ministries=church_admin_ministries_array();
        $out.='<h3 >'.__('Ministries','church-admin').'</h3>';
        foreach( $ministries AS $ministry_id=>$ministry)
        {
            $out.='<div class="church-admin-form-group"><div class="checkbox"><label><input type="checkbox" data-name="ministry_id" name="ministry_id[]" value="'.(int)$ministry_id.'" ';
            if(!empty( $personsMinistries) && in_array( $ministry_id,$personsMinistries) ) $out.=' checked="checked" ';
            $out.='/>&nbsp;'.esc_html( $ministry).'</label></div></div>';
    
        }

    }
    /*********************************************
     * Groups
     * Needs to be allowed to keep form simple
     *********************************************/
    if(!empty( $allow) &&is_array( $allow) && in_array('groups',$allow) )
    {    
        $out.='<h3>'.__('Small Group','church-admin').'</h3>';
		$smallgroups=$wpdb->get_results('SELECT * FROM '.CA_SMG_TBL);
		if(!empty( $smallgroups) )
		{
			if(!empty( $data->people_id) )$dataSmallGroups=church_admin_get_people_meta( $data->people_id,'smallgroup');
			foreach( $smallgroups AS $smallgroup)
			{
				$out.='<div class="checkbox"><label><input type="checkbox" data-name="smallgroup_id"  name="smallgroup_id[]" value="'.(int)$smallgroup->id.'" ';
				if(!empty( $dataSmallGroups) && in_array( $smallgroup->id,$dataSmallGroups) ) $out.=' checked="checked" ';
				$out.='/> '.esc_html( $smallgroup->group_name).'</label></div>'."\r\n";
			}
			
		}

    }
    /*********************************************
     * Sites
     * Needs to be allowed to keep form simple
     *********************************************/
    if(!empty( $allow) &&is_array( $allow) && in_array('sites',$allow) )
    { 
        $sites=$wpdb->get_results('SELECT venue,site_id FROM '.CA_SIT_TBL.' ORDER BY venue ASC');
        if( $wpdb->num_rows==1)
        {
            $out.='<input type="hidden" name="site_id" '; 
            if(!empty( $data->site_id) )
            {
                $out.=' value="'.(int)$data->site_id.'" ';
            }
            else
            {
                $out.=' value="'.(int)$sites[0]->site_id.'" ';
            } 
            $out.='/>';
        }
        else
        {
            $out.='<div class="church-admin-form-group"><label >'.__('Which site do you attend?','church-admin').'</label> <select name="site_id" data-name="site_id" class="church-admin-form-control">';
            $first=$option='';
            foreach( $sites AS $site)
            {
                if(!empty( $data->site_id)&& $data->site_id==$site->site_id)
                {
                    $first.='<option value="'.intval( $site->site_id).'" selected="selected">'.esc_html( $site->venue).'<option>';
                }
                else
                {
                    $option.='<option value="'.intval( $site->site_id).'">'.esc_html( $site->venue).'<option>';
                }
            }
            $out.=$first.$option.'</select></div>';
        }

    }
        /**************************************
        *   Privacy Permissions
        ***************************************/       
        $out.='<div class="church-admin-form-group"><label>'.__('I give permission...','church-admin').'</label></div>';
        $out.='<div class="checkbox"><label ><input type="checkbox" id="email_send" name="email_send" value="TRUE" data-name="email_send"  class="email-permissions"';
        if(!empty( $data->email_send) )$out.='checked="checked" ';
        $out.='/> '.__('To receive email','church-admin').'</label></div>';
        $out.='<p>'.__('Refine type of email you can receive','church-admin').'</p>';
        $out.='<div class="checkbox"><label ><input type="checkbox" name="news_send" id="news_send" value="TRUE"  class="email-permissions" data-name="news_send"  ';
        if(!empty( $data->people_id) )$news=$wpdb->get_var('SELECT meta_id FROM '.CA_MET_TBL.' WHERE people_id="'.(int)$data->people_id.'" AND meta_type="posts"');
        if(!empty ($news ) )$out.=' checked="checked" ';
        $out.='/> '.__('To receive blog posts by email','church-admin').'</label></div>';
        //PRAYER REQUESTS
        $noPrayer=get_option('church-admin-no-prayer');
	    if ( empty( $noPrayer) ){   
            $out.='<div class="checkbox"><label ><input type="checkbox" value="1" id="prayer_requests" data-name="prayer_chain"  class="email-permissions"  name="prayer_requests" ';
            if(!empty( $data->people_id) )$prayer=$wpdb->get_var('SELECT meta_id FROM '.CA_MET_TBL.' WHERE people_id="'.(int)$data->people_id.'" AND meta_type="prayer-requests"');
            if(!empty( $prayer) ) $out.=' checked="checked" ';
            $out.=' /> '.__('To receive Prayer requests by email','church-admin').'</label></div>';
        }
        //BIBLE READINGS
        $noBibleReadings=get_option('church-admin-no-bible-readings');
	    if ( empty( $noBibleReadings) ){
           $out.='<div class="checkbox"><label ><input type="checkbox" value="1" id="bible_readings" data-name="bible_readings"  class="email-permissions"  name="bible_readings" ';
            if(!empty( $data->people_id) )$bible=$wpdb->get_var('SELECT meta_id FROM '.CA_MET_TBL.' WHERE people_id="'.(int)$data->people_id.'" AND meta_type="bible-readings"');
            if(!empty( $bible) ) $out.=' checked="checked" ';
            $out.=' /> '.__('To receive new Bible Reading notes by email','church-admin').'</label></div>';
        }
        
        $out.='<p>'.__('Other privacy permissions','church-admin').'</p>';
        $out.='<div class="checkbox"><label ><input type="checkbox" name="photo_permission" value="TRUE" data-name="photo_permission"  ';
        if(!empty( $data->photo_permission) )$out.='checked="checked" ';
        $out.='/> '.__('To use my photo in the directory and on the website','church-admin').'</label></div>';
        $out.='<div class="checkbox"><label ><input type="checkbox" name="sms_send" value="TRUE" data-name="sms_send"  ';
        if(!empty( $data->sms_send) )$out.='checked="checked" ';
        $out.='/> '.__('To receive SMS','church-admin').'</label></div>';
        
        $out.='<div class="checkbox"><label ><input type="checkbox" name="mail_send" value="TRUE" data-name="mail_send" ';
        if(!empty( $data->mail_send) )$out.='checked="checked" ';
        $out.='/> '.__('To receive mail','church-admin').'</label></div>';

        $out.='<div class="checkbox"><label ><input type="checkbox" name="show_me" id="show-me" value="TRUE" data-name="show_me" ';
        if(!empty( $data->show_me) )$out.='checked="checked" ';
        $out.='/> '.__('To show me on the password protected address list','church-admin').'</label></div>';
        $out.='<p>'.__('Refine address list privacy','church-admin').'</p>';
        $fine_privacy=!empty($data->privacy)?maybe_unserialize($data->privacy):array();
        //show email
        $out.='<div class="church-admin-form-group"><input type="checkbox" name="show-email" id="show-email" ';
        if(!empty( $fine_privacy['show-email']) )  {$out.=' checked ="checked" ';}
        $out.='/> '.__("Show email address",'church-admin').' </div>';
        //show cell
        $out.='<div class="church-admin-form-group"><input type="checkbox" name="show-cell" id="show-cell" ';
        if(!empty( $fine_privacy['show-cell']) )  {$out.=' checked ="checked" ';}
        $out.='/> '.__("Show cell number",'church-admin').' </div>';
        //show landline
        $out.='<div class="church-admin-form-group"><input type="checkbox" name="show-landline" id="show-landline"  ';
        if(!empty( $fine_privacy['show-landline']) )  {$out.=' checked ="checked" ';}
        $out.='/> '.__("Show landline",'church-admin').' </div>';
        //show address
        $out.='<div class="church-admin-form-group"><input type="checkbox" name="show-address" id="show-address"  ';
        if(!empty( $fine_privacy['show-address']) )  {$out.=' checked ="checked" ';}
        $out.='/> '.__("Show address",'church-admin').' </div>';

        $out.='<script>jQuery(document).ready(function( $)  {
            
            $("#show-me").change(function()
            {
                if( $("#show-me").prop("checked")== false)
                {
                    console.log("Unchecking detailed privacy");
                    $("#show-email").prop( "checked", false );
                    $("#show-cell").prop( "checked", false );
                    $("#show-landline").prop( "checked", false );
                    $("#show-address").prop( "checked", false );
                }
            });
            if( $("#email_send").prop("checked")== false)
            {
                console.log("Unchecking");
                $("#news_send").prop( "checked", false );
                $("#prayer_requests").prop( "checked", false );
                $("#bible_readings").prop( "checked", false );
            }
            $(".email-permissions").change(function()
            {
                var id=$(this).attr("id");
                switch(id)
                {
                    case "email_send":
                        console.log("email send changed");
                        if( $(this).prop("checked")==false)
                        {
                            $("#news_send").prop( "checked", false );
                            $("#prayer_requests").prop( "checked", false );
                            $("#bible_readings").prop( "checked", false );
                        }
                    break;
                    case "news_send":
                    case "prayer_requests":
                    case "bible_readings":
                        console.log("other checkbox changed");
                        if( $(this).prop("checked") ) 
                        {
                            console.log("Other checked");
                            $("#email_send").prop("checked", true);
                        }
                    break;
                }
               
            });
            
            });
        </script>';
    return $out;
}
/*******************************************
*   Front End Address Form
*******************************************/ 
function church_admin_frontend_address_form( $address,$image)
{
    global $wpdb;
    $out='';
    if(!empty( $image) )
    {
        $out.='<script>var nonce="'.wp_create_nonce("household-image-upload").'";
        var whichImage="household";';
        if(!empty( $address->household_id) )  {$out.='var id="'.(int)$address->household_id.'";';}else{$out.= 'var id;';}
        $out.='</script>';
        $out.='<div class="ca-upload-area"  data-which="household" data-id="'.(int)$address->household_id.'" data-nonce="'.wp_create_nonce("household-image-upload").'" id="uploadfile"><h3>'.__('Photo ','church-admin').'</h3><div class="church-admin-form-group"><label>';
        if(!empty( $address->attachment_id) )
        {
            $out.=wp_get_attachment_image( $address->attachment_id,'medium','', array('class'=>"current-photo",'id'=>"household-image") );
        }
        else
        {
            $out.= '<img src="'.plugins_url('/images/default-avatar.jpg',dirname(__FILE__) ).'" width="300" height="200" id="household-image"  alt="'.__('Photo of Person','church-admin').'"  />';
        }
        $out.='<p class="drag-message">'.__('Drag and drop image into this box to replace','church-admin').'</p> </div>';
        $out.='<input type="hidden" name="household_attachment_id" class="attachment_id" id="attachment_id" ';
        if(!empty( $address->attachment_id) )$out.=' value="'.(int)$address->attachment_id.'" ';
        $out.='/><span id="household-upload-message"></span>';
        $out.='</div>';
    }
    $out.= '<!--Address--><div class="church-admin-form-group"><label>'.__('Street Address','church-admin').'</label><input  class="church-admin-form-control" type="text" id="address" name="address" ';
    if(!empty( $address->address) ) $out.=' value="'.esc_html( $address->address).'" ';
	$out.='/></div>';
    $coords=church_admin_center_coordinates(CA_HOU_TBL);
    if(!empty( $address->lat) )  {$lat=$address->lat;}else{$lat=$coords->lat;}
    if(!empty( $address->lng) )  {$lng=$address->lng;}else{$lng=$coords->lng;}
    if(!empty( $address->household_id) )  {$household_id=(int)$address->household_id;}else{$household_id=NULL;}
    $out.=church_admin_frontend_google_map( $lat,$lng,$household_id);
    $out.= '<div class="church-admin-form-group"><label>'.__('Home phone','church-admin').'</label><input  class="church-admin-form-control" type="text" id="phone" name="phone" ';
    if(!empty( $address->phone) ) $out.=' value="'.esc_html( $address->phone).'" ';
	$out.='/></div>';

    //household custom fields
    $custom_fields=church_admin_get_custom_fields();
    if(!empty( $custom_fields) )
    {
		foreach( $custom_fields AS $id=>$field)
		{
            if( $field['section']!='household')continue;
			$dataField='';
			if(!empty( $address->household_id) )$dataField=$wpdb->get_var('SELECT data FROM '.CA_CUST_MET_TBL .' WHERE household_id="'.(int)$address->household_id.'" AND custom_id="'.(int)$id.'"');
			$out.='<div class="church-admin-form-group"><label >'.esc_html( $field['name'] ).'</label>';
			switch( $field['type'] )
			{
				case 'boolean':
					$out.='<input type="radio" data-name="custom-'.$id.'" class="church-admin-form-control"  value="1" name="custom-'.(int)$id.'" ';
					if (isset( $dataField)&&$dataField==1)
						$out.= 'checked="checked" ';
					$out.='>'.__('Yes','church-admin').'<br /> <input type="radio" data-name="custom-'.(int)$id.'" class="church-admin-form-control" value="0" name="custom-'.(int)$id.'" ';
					if (isset( $dataField)&& $dataField==0)
						$out.= 'checked="checked" ';
					$out.='>'.__('No','church-admin');
					break;
				case'text':
					$out.='<input type="text" data-name="custom-'.(int)$id.'" class="church-admin-form-control"  name="custom-'.(int)$id.'" ';
					if(!empty( $dataField)||isset( $field['default'] ) )$out.=' value="'.esc_html( $dataField).'"';
					$out.='/>';
				break;
				case'date':
					$out.= church_admin_date_picker( $dataField,'custom-'.(int)$id,FALSE,1910,date('Y'),'custom-'.(int)$id,'custom-'.(int)$id);

				break;
			}
			$out.='</div>';

		}
    }
	
    return $out;
}
/*******************************************
*   Front End Google Maps
*******************************************/ 
function church_admin_frontend_google_map( $lat=NULL,$lng=NULL,$household_id=NULL)
{
    global $wpdb;
    $out='';    
    $googleMapAPI=get_option('church_admin_google_api_key');
    if(!$googleMapAPI)return NULL;
    /*if ( empty( $lat)||empty( $lng) )
    {   
        $site=$wpdb->get_row('SELECT lat,lng FROM '.CA_SIT_TBL.' ORDER BY site_id LIMIT 1');
        if(!empty( $site) )
        {
            $out.='<script > var beginLat ='.esc_html( $site->lat).';';
            $out.= 'var beginLng ='.esc_html( $site->lng);
            $out.=';</script>';
            $lat=$site->lat;
            $lng=$site->lng;
        }else
        {
            $out.='<script >';
            $out.='var beginLat = 51.50351129583287;var beginLng = -0.148193359375;if (navigator.geolocation) {var location_timeout = setTimeout("geolocFail()", 10000);navigator.geolocation.getCurrentPosition(function(position) {clearTimeout(location_timeout);beginLat = position.coords.latitude;beginLng = position.coords.longitude;}, function(error) {clearTimeout(location_timeout);});}</script>';
            $lat=51.50351129583287;
            $lng=-0.148193359375;
        }
    }else
    {
            $out.='<script > var beginLat ='.esc_html( $lat).';';
            $out.= 'var beginLng ='.esc_html( $lng);
            $out.=';</script>';
    }
    */
    $out.='<script >var ca_method="update-directory";var ID="'.(int)$household_id.'"; var nonce="'.wp_create_nonce('update-directory').'";var beginLat=';
    if(!empty( $lat) ) {$out.= $lat.';';}else {$out.= '0;';}
    if(!empty( $lng) ) {
        $out.= 'var beginLng='.$lng.';var zoom=17';
    }else {
        $out.='var beginLng=0;var zoom=0';
    }
   
    $out.=';</script>';
      
    if(!empty( $googleMapAPI) )
    {
        $out.= '<div class="church-admin-form-group"><label><button id="geocode_address" class="btn btn-info">'.__('Update map','church-admin').'</button></label><span id="finalise" ></span><input type="hidden" name="lat" id="lat" value="'.$lat.'"/><input type="hidden" name="lng" id="lng" value="'.$lng.'"/><div id="map" style="width:500px;height:300px;margin-bottom:20px"></div></div>';
    }



    
    return $out;
}

/*******************************************
*   Front End save person
*******************************************/ 
function church_admin_frontend_save_person( $household_id,$people_id,$head_of_household=0,$member_type_id=1,$allow=NULL)
{
    global $wpdb;

    /************************************
	 * GET $old_email for MailChimp sync
	 ************************************/
    if(!empty( $people_id) )
	{
		$old_email=$wpdb->get_var('SELECT email FROM '.CA_PEO_TBL.' WHERE people_id="'.(int)$people_id.'"');
	}
	else
	{
		$old_email=NULL;
	}
    /**********************
    *  Sanitize input
    ***********************/
        $sqlsafe= array();
        foreach( $_POST AS $key=>$value){
            $sqlsafe[$key]=esc_sql(sanitize_text_field( $value) );
        }
        
        //privacy
        $privacy=array();
        if(!empty($_POST['show-email'])){$privacy['show-email']=1;}
        if(!empty($_POST['show-cell'])){$privacy['show-cell']=1;}
        if(!empty($_POST['show-landline'])){$privacy['show-landline']=1;}
        if(!empty($_POST['show-address'])){$privacy['show-address']=1;}
        $sqlsafe['privacy']=esc_sql(serialize($privacy));


        if ( empty( $sqlsafe['prefix'] ) )$sqlsafe['prefix']=NULL;
        if(!empty( $_POST['people_id'] ) )$people_id=(int)$_POST['people_id'];
        
        if(!empty( $_POST['show_me'] ) )  {$show_me=1;}else{$show_me=0;}
        if(!empty( $_POST['mail_send'] ) )  {$mail_send=1;}else{$mail_send=0;}
        if(!empty( $_POST['email_send'] ) )  {$email_send=1;}else{$email_send=0;}
        if(!empty( $_POST['news_send'] ) )  {$news_send=1;}else{$news_send=0;}
        if(!empty( $_POST['sms_send'] ) )  {$sms_send=1;}else{$sms_send=0;}
        if(!empty( $_POST['photo_permission'] ) )  {$photo_permission=1;}else{$photo_permission=0;}
        if(!empty( $_POST['show_me'] ) )  {$show_me=1;}else{$show_me=0;}
        if(!empty( $_POST['date_of_birth'] ) && church_admin_checkdate( $_POST['date_of_birth'] ) )
        {
            $sqlsafe['date_of_birth']=esc_sql( $_POST['date_of_birth'] );
           
        }
        else
        {
            $sqlsafe['date_of_birth']=NULL;
        }
        if(!empty( $_POST['people_attachment_id'] ) )  {$attachment_id=(int)$_POST['people_attachment_id'];}else{$attachment_id=NULL;}
        $e164cell='';
        if(!empty( $_POST['mobile'] ) )$e164cell=esc_sql(church_admin_e164( $_POST['mobile'] ) );
        /**********************
        *  Check if saved
        ***********************/
        if ( empty( $people_id) )
        {
            $people_id=$wpdb->get_var('SELECT people_id FROM '.CA_PEO_TBL.' WHERE first_name="'.$sqlsafe['first_name'].'" AND prefix="'.$sqlsafe['prefix'].'" AND last_name="'.$sqlsafe['last_name'].'" AND email="'.$sqlsafe['email'].'" AND mobile="'.$sqlsafe['mobile'].'" AND sex="'.$sqlsafe['sex'].'" AND mail_send="'.$mail_send.'" AND people_type_id="'.$sqlsafe['people_type_id'].'" AND sex="'.$sqlsafe['sex'].'" AND email_send="'.$email_send.'" AND sms_send="'.$sms_send.'" AND photo_permission="'.$photo_permission.'" AND attachment_id="'.$attachment_id.'" AND show_me="'.$show_me.'" AND date_of_birth="'.$sqlsafe['date_of_birth'].'" AND household_id="'.(int)$household_id.'"');
        }
        /**********************
        *  Save 
        ***********************/
        if ( empty( $people_id) )
        {
            //include $head_of_household in INSERT
            $wpdb->query('INSERT INTO '.CA_PEO_TBL.' (first_name,prefix,last_name,mobile,e164cell,email,email_send,news_send,mail_send,sms_send,photo_permission, date_of_birth,household_id,people_type_id,sex,active,head_of_household,attachment_id,member_type_id,show_me,privacy,site_id) VALUES("'.$sqlsafe['first_name'].'","'.$sqlsafe['prefix'].'","'.$sqlsafe['last_name'].'","'.$sqlsafe['mobile'].'","'.$e164cell.'","'.$sqlsafe['email'].'","'.$email_send.'","'.$news_send.'","'.$mail_send.'","'.$sms_send.'","'.$photo_permission.'","'.$sqlsafe['date_of_birth'].'","'.(int)$household_id.'","'.(int)$sqlsafe['people_type_id'].'","'.$sqlsafe['sex'].'",1,"'.(int)$head_of_household.'","'.$attachment_id.'","'.(int)$member_type_id.'","'.$sqlsafe['privacy'].'","'.$show_me.'",1)');
            $people_id=$wpdb->insert_id;
            
        }
        else
        {
            //don't update head of household, as it should be set already
            $wpdb->query('UPDATE '.CA_PEO_TBL.' SET first_name="'.$sqlsafe['first_name'].'" , prefix="'.$sqlsafe['prefix'].'" , last_name="'.$sqlsafe['last_name'].'" , email="'.$sqlsafe['email'].'" , sex="'.$sqlsafe['sex'].'" , mail_send="'.$mail_send.'" ,mobile="'.$sqlsafe['mobile'].'",e164cell="'.$e164cell.'" ,people_type_id="'.$sqlsafe['people_type_id'].'" , sex="'.$sqlsafe['sex'].'" , email_send="'.$email_send.'" , news_send="'.$news_send.'" ,sms_send="'.$sms_send.'",  photo_permission="'.$photo_permission.'" , date_of_birth="'.$sqlsafe['date_of_birth'].'", household_id="'.(int)$household_id.'",show_me="'.$show_me.'", privacy="'.$sqlsafe['privacy'].'", active=1,attachment_id="'.$attachment_id.'"  WHERE people_id="'.(int)$people_id.'"');
        }
        //user bio
        $user_id=$wpdb->get_var('SELECT user_id FROM '.CA_PEO_TBL.' WHERE people_id="'.(int)$people_id.'"');
        if(!empty( $user_id) )
        {
            update_user_meta( $user_id,'description',stripslashes( $_POST['bio'] ) );
        }
        //save prayer requests and bible readings
        if(!empty( $_POST['prayer_requests'] ) )  {church_admin_update_people_meta(1,$people_id,"prayer-requests");}
		if(!empty( $_POST['bible_readings'] ) )  {church_admin_update_people_meta(1,$people_id,"bible-readings");}
        /****************************************************
        * Save groups 
        *****************************************************/
        if(!empty( $allow)&&in_array('groups',$allow) )
        {
            church_admin_delete_people_meta(NULL,$people_id,'smallgroup');
            if(!empty( $_POST['smallgroup_id'] ) )
            {
                foreach( $_POST['smallgroup_id'] AS $key=>$id)
                {
                    church_admin_update_people_meta( $id,$people_id,'smallgroup');
                }
            }
            else
            {
                if(defined('CA_DEBUG') )church_admin_debug('Need to put '.$people_id.' in unattached');
                church_admin_update_people_meta(1,$people_id,'smallgroup');
            }
        }
        /*****************************************************
         *  Ministry
         ****************************************************/
        if(!empty( $allow)&&in_array('ministries',$allow) )
        {
            church_admin_delete_people_meta(NULL,$people_id,'ministry');
            if(!empty( $_POST['ministry_id'] ) )
            {    foreach( $_POST['ministry_id'] AS $key=>$id)
                {
                        church_admin_update_people_meta( $id,$people_id,"ministry");
                }
            }
        }
        /*****************************************************
        * Save Custom Fields
        *****************************************************/
        $custom_fields=church_admin_get_custom_fields();

        if(!empty( $custom_fields) )
        {
            $wpdb->query('DELETE FROM '.CA_CUST_MET_TBL.' WHERE people_id="'.(int)$people_id.'"');
            foreach( $custom_fields AS $id=>$field)
            {
                if( $field['section']!='people')continue;
                if(isset( $_POST['custom-'.$id] ) )
                {
                    $sql='INSERT INTO  '.CA_CUST_MET_TBL.' (data,people_id,household_id,custom_id) VALUES ("'.esc_sql(stripslashes( $_POST['custom-'.$id] ) ).'","'.(int)$people_id.'","'.(int)$household_id.'","'.(int)$id.'")';
                    if(defined('CA_DEBUG') )church_admin_debug( $sql);
                    $wpdb->query( $sql);
                }
            }

        }
        //update user_meta
        $data=$wpdb->get_row('SELECT * FROM '.CA_PEO_TBL.' WHERE people_id="'.(int)$people_id.'"');
        if(!empty( $data->user_id) )church_admin_update_user_meta( $people_id,$data->user_id);
        church_admin_update_mailchimp_member( $data,$old_email,FALSE);

    return $people_id;
}

