<?php
if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

function church_admin_search_form()
{
    echo'<form name="ca_search" action="admin.php?page=church_admin/index.php&amp;action=people&amp;section=people" method="POST"><p>'.__('Search','church-admin').'<input name="church_admin_search" style="width:200px;" type="text"/><input type="checkbox" name="all-records" value="TRUE"/>'.__('Include inactive entries','church-admin').'&nbsp;<input class="button-primary" type="submit" value="'.__('Go','church-admin').'"/></p></form>';
}

/*
 * Matches each symbol of PHP date format standard
 * with jQuery equivalent codeword
 * @author Tristan Jahier
 */
function dateformat_PHP_to_jQueryUI( $php_format)
{
    $SYMBOLS_MATCHING = array(
        // Day
        'd' => 'dd',
        'D' => 'D',
        'j' => 'd',
        'l' => 'DD',
        'N' => '',
        'S' => '',
        'w' => '',
        'z' => 'o',
        // Week
        'W' => '',
        // Month
        'F' => 'MM',
        'm' => 'mm',
        'M' => 'M',
        'n' => 'm',
        't' => '',
        // Year
        'L' => '',
        'o' => '',
        'Y' => 'yy',
        'y' => 'y',
        // Time
        'a' => '',
        'A' => '',
        'B' => '',
        'g' => '',
        'G' => '',
        'h' => '',
        'H' => '',
        'i' => '',
        's' => '',
        'u' => ''
    );
    $jqueryui_format = "";
    $escaping = false;
    for ( $i = 0; $i < strlen( $php_format); $i++)
    {
        $char = $php_format[$i];
        if( $char === '\\') // PHP date format escaping character
        {
            $i++;
            if( $escaping) $jqueryui_format .= $php_format[$i];
            else $jqueryui_format .= '\'' . $php_format[$i];
            $escaping = true;
        }
        else
        {
            if( $escaping) { $jqueryui_format .= "'"; $escaping = false; }
            if(isset( $SYMBOLS_MATCHING[$char] ) )
                $jqueryui_format .= $SYMBOLS_MATCHING[$char];
            else
                $jqueryui_format .= $char;
        }
    }
    return $jqueryui_format;
}
function church_admin_date_picker( $db_date,$name,$array=FALSE,$start=NULL,$end=NULL,$class=NULL,$id=NULL,$disabled=FALSE,$datawhat=NULL,$dataid=NULL,$dataCustomID=NULL)
{
    //church_admin_debug(func_get_args() );
    //church_admin_debug("Date picker class ".$class);
	if ( empty( $start) )$start=date('Y');
	if ( empty( $end) )$end=date('Y')+10;
	$out='';
	$date_format=get_option('date_format');
	if ( empty( $date_format) )$date_format='jS M, Y';
    $jsdate_format=dateformat_PHP_to_jQueryUI( $date_format);
    if ( empty( $jsdate_format) )$jsdate_format='d M,yy';
	$out.='<span class="dashicons dashicons-calendar-alt"></span>';
	//text field that can be seen
	$out.='<input autocomplete="off" type="text" ';
    
    $out.='data-name="'.esc_html( $name).'" name="'.esc_html( $name).'x';
	if( $array)$out.='[]';
	$out.='" class="'.sanitize_title( $class).'x  church-admin-form-control clonableDatePicker"' ;
    
    if( $disabled)$out.=' disabled="disabled" ';
	if(!empty( $db_date)&&$db_date!='0000-00-00') $out.= ' value="'.mysql2date(get_option('date_format'),$db_date).'" ';
	$out.=' id="'.esc_html( $id).'x"/>'."\r\n";
	
	//data that will be processed when form submitted
	$out.='<input  id="'.esc_html( $id).'" type="hidden" name="'.esc_html( $name);
	if( $array)$out.='[]';
	$out.='" class="'.esc_html( $class).' clonableHiddenDatePicker church-admin-editable" data-name="'.esc_html( $name).'" ';
	if(!empty( $db_date) )$out.='value="'. esc_html( $db_date).'" ';
    if(!empty( $datawhat) ) $out.='data-what="'.esc_html( $datawhat).'" ';
    if(!empty( $dataid) ) $out.='data-id="'.esc_html( $dataid).'" ';
    if(!empty( $dataCustomID) )$out.='data-custom-id="'.esc_html( $dataCustomID).'" ';
	$out.='/>';
	if(!$disabled)$out.='<script>
		jQuery(document).ready(function( $)  {


         	$("body").on("focus",".'.esc_html( $class).'x", function()  {
         		var hidden = "#"+this.id.slice(0, -1);//need to be able to detect the hidden id field when cloned
                 console.log("hidden id is "+hidden);
                 $(this).datepicker({altFormat: "yy-mm-dd",
                    altField:hidden, 
                    dateFormat : "'.$jsdate_format.'", 
                    changeYear: true ,
                    yearRange: "'.intval( $start).':'.intval( $end).'",
                    onClose: function() {console.log(hidden +" change fired"); $(hidden).trigger("change");}
                }).keyup(function(e)  {
                        if ( e.keyCode == 8 || e.keyCode == 46) {$.datepicker._clearDate(this);}
                    });
			});
		});
		</script>';

	return $out;

}




/**
 * Array of ministries
 *
 * @param
 * deprecated
 *
 * @author andy_moyle
 *
 */
function church_admin_ministries( $childID=NULL)  {
	global $wpdb;
	$ministries=array();
	$sql='SELECT * FROM '.CA_MIN_TBL;
	$where='';
	//if(!empty( $childID) ) {$where=' WHERE childID ="'.intval( $childID).'"';}
	//if( $childID=='None')$where=' WHERE childID =0';
	$order=' ORDER BY ministry';
	$results=$wpdb->get_results( $sql.$where.$order);
	if(!empty( $results) )
	{

		foreach( $results as $row)  {$ministries[$row->ID]=$row->ministry;}

	}

	return $ministries;

}
/**
 * sets wp_mail to html type!
 *
 * Author:     Andy Moyle
 * Author URI: http://www.churchadminplugin.com
 *
 *
 */
 function church_admin_email_type( $content_type)  {
return 'text/html';
}


/**
 * This function initialises wp_mail with stored smtp settings
 *
 * Author:     Andy Moyle
 * Author URI: http://www.churchadminplugin.com
 *
 *
 */
add_action( 'wp_mail_failed', function ( $error ) {
    //church_admin_debug( $error->get_error_message() );
} );
add_action( 'phpmailer_init', 'church_admin_smtp_email' );
function church_admin_smtp_email( $phpmailer ) {
    //church_admin_debug("church_admin_smtp_email fired");
	$smtp=get_option('church_admin_smtp_settings');
	if(!empty( $smtp['username'] )&&!empty( $smtp['host'] )&&!empty( $smtp['port'] )&&!empty( $smtp['password'] )&&!empty( $smtp['secure'] ) )
	{
        //church_admin_debug('Using SMTP for PHPMAILER');
		// Define that we are sending with SMTP
		
        $phpmailer->IsSMTP();
		// The hostname of the mail server
		$phpmailer->Host = $smtp['host'];//"smtp.example.com";

		// Use SMTP authentication (true|false)
		$phpmailer->SMTPAuth = $smtp['auth'];//true;

		// SMTP port number - likely to be 25, 465 or 587
		$phpmailer->Port = $smtp['port'];//"587";

		// Username to use for SMTP authentication
		$phpmailer->Username = $smtp['username'];//yourusername";

		// Password to use for SMTP authentication
		$phpmailer->Password =$smtp['password']; //"yourpassword";

		// Encryption system to use - ssl or tls
		$phpmailer->SMTPSecure =$smtp['secure']; //"tls";

		$phpmailer->From = $smtp['from'];//"you@yourdomail.com";
		$phpmailer->FromName = $smtp['from_name'];//"Your Name";
       
        //$phpmailer->SMTPDebug = PHPMailer\PHPMailer\SMTP::DEBUG_SERVER;
	}
}
//end smtp settings for wp_mail




function church_admin_max_file_upload_in_bytes() {
    //select maximum upload size
    $max_upload = substr(ini_get('upload_max_filesize'),0,-1);
   
    //select post limit
    $max_post = substr(ini_get('post_max_size'),0,-1);
   
    //select memory limit
    $memory_limit = substr(ini_get('memory_limit'),0,-1);
   
    // return the smallest of them, this defines the real limit
    return size_format(min( $max_upload, $max_post, $memory_limit),0);
}

function church_admin_get_id_by_shortcode( $shortcode) {
	global $wpdb;

	$id = NULL;

	$sql = 'SELECT ID
		FROM ' . $wpdb->posts . '
		WHERE
			post_type = "page"
			AND post_status="publish"
			AND post_content LIKE "%' . $shortcode . '%"';

	$id = $wpdb->get_var( $sql);
	return $id;
}
function church_admin_initials( $people)
{
	$people=maybe_unserialize( $people);
	if(!empty( $people) )
	{

		foreach( $people as $id=>$peep)
		{
			if(ctype_digit( $peep) )  {$person=church_admin_get_person( $peep);}else{$person=$peep;}
			$strlen=strlen( $person);
			$initials[$id]='';
			for ( $i=0; $i<=$strlen; $i++)
			{
				$char=substr( $person,$i,1);
				if (ctype_upper( $char) )  {$initials[$id].=$char;}
			}
		}

		return implode(', ',$initials);

	}else return '';
}

function church_admin_checkdate( $date)
{
		$d=explode('-',$date);
		if(is_array( $d) && count( $d)==3 && checkdate( $d[1],$d[2],$d[0] ) )  {return TRUE;}else{return FALSE;}
}
function church_admin_level_check( $what,$user_id=NULL)
{
    ////church_admin_debug('Level check for '.$what);
    ////church_admin_debug('Given user ID: '.$user_id);
    $current_user=wp_get_current_user();
    if(current_user_can('manage_options') )return true;
    if ( empty( $user_id) )$user_id=$current_user->ID;
    if ( empty( $user_id) )return false;
    $user_permissions=maybe_unserialize(get_option('church_admin_user_permissions') );
    ////church_admin_debug('User permissions:');
    ////church_admin_debug( $user_permissions);
    $level=get_option('church_admin_levels');
    ////church_admin_debug('Levels method:');
    ////church_admin_debug( $level);
    if(!empty( $user_permissions[$what] ) )
    {//user permissions have been set for $what
      
        ////church_admin_debug('checking $user_permissions');
        //church_admin_debug(print_r(maybe_unserialize( $user_permissions[$what] ),TRUE) );
        if( in_array( $user_id,maybe_unserialize( $user_permissions[$what] ) ))
        {
            ////church_admin_debug('TRUE');
            return TRUE;
        }
        else
        {
            ////church_admin_debug('FALSE');
            return FALSE;
        }
    }
		//end user permissions have been set
    elseif(!empty( $level[$what] ) && $level[$what]=="administrator")  {return user_can( $user_id,'manage_options');}
    elseif(!empty( $level[$what] ) && $level[$what]=="editor")  {return user_can( $user_id,'delete_others_pages');}
    elseif(!empty( $level[$what] ) &&$level[$what]=="author")  {return user_can( $user_id,'publish_posts');}
    elseif(!empty( $level[$what] ) &&$level[$what]=="contributor")  {return user_can( $user_id,'edit_posts');}
    elseif(!empty( $level[$what] ) &&$level[$what]=="subscriber")  {return user_can( $user_id,'read');}
    else{ return false;}
}

function church_admin_user( $ID)
{
		global $wpdb;
		$people_id=$wpdb->get_var('SELECT people_id FROM '.CA_PEO_TBL.' WHERE user_id="'.esc_sql( $ID).'"');
		if(!empty( $people_id) ) {return $people_id;}else{return FALSE;}
}

function church_admin_collapseBoxForUser( $userId, $boxId) {
    $optionName = "closedpostboxes_church-admin";
    $close = get_user_option( $optionName, $userId);
    $closeIds = explode(',', $close);
    $closeIds[] = $boxId;
    $closeIds = array_unique( $clodeIds); // remove duplicate Ids
    $close = implode(',', $closeIds);
    update_user_option( $userId, $optionName, $close);
}



function church_admin_autocomplete( $name='people',$first_id='friends',$second_id='to',$current_data=array(),$user_id=FALSE,$filter=FALSE)
{
            /**
 *
 * Creates autocomplete field
 *
 * @author  Andy Moyle
 * @param    $name,$first_id,$second_id
 * @return   html string
 * @version  0.1
 *
 *
 */
    $current='';
    
    if(!empty( $current_data) )
    {
        $curr_data=maybe_unserialize( $current_data);
        
        if(!empty( $curr_data)&&is_array( $curr_data) )
		{
			foreach( $curr_data AS $key=>$value)
			{

				if(ctype_digit( $value) )
				{
						if(!$user_id)
						{//people_id
							$peoplename=church_admin_get_person( $value);
						}
						else
						{//user_id
							$peoplename=church_admin_get_name_from_user( $value);
						}
				}else $peoplename=$value;
				$current.=$peoplename.', ';
			}
		}else$current=$current_data;
    }
    $out= "\r\n".'<input autocomplete="off" id="'.sanitize_title_with_dashes( $first_id).'" class="'.sanitize_title_with_dashes( $second_id).' church-admin-form-control" placeholder="'.__('Enter names, separated by commas','church-admin').'" type="text" name="'.esc_html( $name).'" value="'.esc_html( $current).'"/> ';
    $out.="\r\n";
    $ajax_nonce = wp_create_nonce( "church-admin-autocomplete" );
    $out.='<script type="text/javascript">

	jQuery(document).ready(function ( $)  {

	$("#'.sanitize_title_with_dashes( $first_id).'").autocomplete({
		source: function(req, add)  {
			req.action="church_admin";
			req.method="autocomplete";
			req.security="'.$ajax_nonce.'";
			console.log(req);
			$.getJSON("'.site_url().'/wp-admin/admin-ajax.php", req,  function(data) {

                    console.log("Response " + data);
                    //create array for response objects
                    var suggestions = [];

                    //process response
                    $.each(data, function(i, val)  {suggestions.push(val.name);});

                //pass array to callback
                add(suggestions);
                $(".'.sanitize_title_with_dashes( $second_id).'").removeClass(".ui-autocomplete-loading");
            });

		},
		focus: function() {
          // prevent value inserted on focus
          return false;
        },
		select: function (event, ui) {
                var terms = $("#'.sanitize_title_with_dashes( $first_id).'").val().split(", ");
		// remove the current input
                terms.pop();
                console.log("current:"+terms);
		// add the selected item
                terms.push(ui.item.value);
				
                // add placeholder to get the comma-and-space at the end
                terms.push("");
                this.value = terms.join(", ");
                console.log("new:" + terms)
				$("#'.sanitize_title_with_dashes( $first_id).'").val(this.value);
                return false;
            },
		minLength: 3,

	});


});


</script>';
    return $out;
}

             /**
 *
 * Returns person's names from $people_id
 *
 * @author  Andy Moyle
 * @param    $id
 * @return   string
 * @version  0.1
 *
 *
*/
function church_admin_get_person( $id)
{

 global $wpdb;
 if(!ctype_digit( $id) )return $id;
    $row=$wpdb->get_row('SELECT first_name,middle_name,nickname,prefix,last_name FROM '.CA_PEO_TBL.' WHERE people_id="'.esc_sql( $id).'"');
    if( $row)
    {
        $name=church_admin_formatted_name( $row);
    
        return $name;
    }else{return FALSE;}
}
function church_admin_get_name_from_user( $id)
{
             /**
 *
 * Returns person's names from user_id
 *
 * @author  Andy Moyle
 * @param    $id
 * @return   string
 * @version  0.1
 *
 *
*/
 global $wpdb;
 ;
    $row=$wpdb->get_row('SELECT first_name,middle_name,nickname,prefix,last_name FROM '.CA_PEO_TBL.' WHERE user_id="'.esc_sql( $id).'"');

    if( $row)
    {
    	//build name
		$name=$row->first_name.' ';
					$middle_name=get_option('church_admin_use_middle_name');
					if(!empty( $middle_name)&&!empty( $row->middle_name) )$name.=$row->middle_name.' ';
					$nickname=get_option('church_admin_use_nickname');
					if(!empty( $nickname)&&!empty( $row->nickname) )$name.='('.$row->nickname.') ';
					$prefix=get_option('church_admin_use_prefix');
					if(!empty( $prefix)&&!empty( $row->prefix) )		$name.=$row->prefix.' ';
					$name.=$row->last_name;
    	return esc_html( $name);
    }else{return FALSE;}
}


function church_admin_get_people_type_ids( $people_type)
{
	global $wpdb;
	//church_admin_debug("********************\r\n function church_admin_get_people_type_ids( $people_type)");
	$return=array();
	$people_types=get_option('church_admin_people_type');
	$ptype_array=explode(",",$people_type);
	foreach( $ptype_array AS $id=>$type)
	{
		$key=array_search(trim( $type),$people_types);
		if( $key)$return[]=$key;
	}
	return( $return);
}


 /****************************************************************************************************
 *
 * Returns array of valid member_type_ids from string of comma separated list of member types or ids
 *
 * @author  Andy Moyle
 * @param    $member_type
 * @return   array
 * @version  0.2
 *
 ******************************************************************************************************/


function church_admin_get_member_type_ids( $member_type)
{
    /*************************************************************
     * Returns array of member_type_id from comma separated list
     *************************************************************/
	global $wpdb;
	
	$member_type_id=array();
	$member_array=explode(",",$member_type);
	
	foreach ( $member_array AS $key=>$memb)
	{
        if(ctype_digit( $memb) )
        {
            $memberTypeID=$wpdb->get_var('SELECT member_type_id FROM '.CA_MTY_TBL.' WHERE member_type_id="'.(int)$memb.'"');
            if( $memberTypeID)$member_type_id[]=(int)$memberTypeID;

        }
        elseif(!empty( $memb) )
        {
		    $memberTypeID=$wpdb->get_var('SELECT member_type_id FROM '.CA_MTY_TBL.' WHERE member_type LIKE "%'.esc_sql(trim( $memb) ).'%"');
            if( $memberTypeID)$member_type_id[]=(int)$memberTypeID;
        }
	}
	
	if(!empty( $member_type_id) )  { return $member_type_id;} else{return array();}
}
 /**
 *
 * Returns peoples names from serialized array
 *
 * @author  Andy Moyle
 * @param    $idArray
 * @return   string
 * @version  0.1
 *
 */
function church_admin_get_people( $idArray)
{

    global $wpdb;
    $ids=maybe_unserialize( $idArray);
    if(!is_array( $ids) )return $ids;
    if(!empty( $ids) )
    {
        $names=array();
        foreach( $ids AS $key=>$id)
        {
            if(ctype_digit( $id) )
            {//is int
                $row=$wpdb->get_row('SELECT first_name,middle_name,nickname,prefix,last_name FROM '.CA_PEO_TBL.' WHERE people_id="'.esc_sql( $id).'"');
                if(!empty( $row) )
                {
                	$name=$row->first_name.' ';
					$middle_name=get_option('church_admin_use_middle_name');
					if(!empty( $middle_name)&&!empty( $row->middle_name) )$name.=$row->middle_name.' ';
					$nickname=get_option('church_admin_use_nickname');
					if(!empty( $nickname)&&!empty( $row->nickname) )$name.='('.$row->nickname.') ';
					$prefix=get_option('church_admin_use_prefix');
					if(!empty( $prefix)&&!empty( $row->prefix) )		$name.=$row->prefix.' ';
					$name.=$row->last_name;
                	$names[]=$name;
                }
            }//end is int
            else
            {//is text
                $names[]=$id;
            }//end is text
        }
        return implode(", ", array_filter( $names) );
    }
    else
    return " ";
}

function church_admin_get_people_id( $name)
{
        /**
 *
 * Returns serialized array of people_id if $name is in DB
 *
 * @author  Andy Moyle
 * @param    $name
 * @return   serialized array
 * @version  0.1
 *
 */
    global $wpdb;
    $names=explode(',',$name);

    $people_ids=array();
    if(!empty( $names) )
    {
        foreach( $names AS $key=>$value)
        {
			$value=trim( $value );
            if(!empty( $value) )
            {//only look if a name stored!
                $sql='SELECT people_id FROM '.CA_PEO_TBL.' WHERE  CONCAT_WS(" ",first_name,last_name) LIKE "'.esc_sql( $value).'" OR CONCAT_WS(" ",first_name,prefix,last_name) LIKE "'.esc_sql( $value).'" OR CONCAT_WS(" ",first_name,middle_name,prefix,last_name) LIKE "'.esc_sql( $value).'" OR CONCAT_WS(" ",first_name,middle_name,last_name) LIKE "'.esc_sql( $value).'" OR CONCAT_WS(" ",first_name,prefix,last_name) LIKE "'.esc_sql( $value).'" OR  nickname LIKE "'.esc_sql( $value).'" LIMIT 1';

                $result=$wpdb->get_var( $sql);
                if( $result)  {$people_ids[]=$result;}else{$people_ids[]=$value;}
            }
        }
    }
    return maybe_serialize(array_filter( $people_ids) );
}

function church_admin_get_people_ids( $names)
{
        /**
 *
 * Returns array of people_ids if $names is in DB
 *
 * @author  Andy Moyle
 * @param    $name
 * @return   array
 * @version  0.1
 *
 */
    global $wpdb;
    church_admin_debug('church_admin_get_people_ids: '.$names);
    $namesArray=explode(',',$names);

    $people_ids=array();
    if(!empty( $namesArray) )
    {
        foreach( $namesArray AS $key=>$value)
        {
			$value=trim( $value );
            if(!empty( $value) )
            {//only look if a name stored!
                $sql='SELECT people_id FROM '.CA_PEO_TBL.' WHERE first_name="'.esc_sql($value).'" OR last_name="'.esc_sql($value).'" OR CONCAT_WS(" ",first_name,last_name) LIKE "'.esc_sql( $value).'" OR CONCAT_WS(" ",first_name,prefix,last_name) LIKE "'.esc_sql( $value).'" OR CONCAT_WS(" ",first_name,middle_name,prefix,last_name) LIKE "'.esc_sql( $value).'" OR CONCAT_WS(" ",first_name,middle_name,last_name) LIKE "'.esc_sql( $value).'" OR CONCAT_WS(" ",first_name,prefix,last_name) LIKE "'.esc_sql( $value).'" OR  nickname LIKE "'.esc_sql( $value).'"';
                church_admin_debug($sql);
                $results=$wpdb->get_results( $sql);
                church_admin_debug($wpdb->last_query);
                if( !empty($results))
                {
                    foreach($results AS $row){
                        $people_ids[]=$row->people_id;
                    }
                }else{$people_ids[]=$value;}
            }
        }
    }
    church_admin_debug($people_ids);
    church_admin_debug('END church_admin_get_people_ids');
    return array_filter( $people_ids) ;
}




function church_admin_get_push_tokens_from_ids( $ids)
{
    church_admin_debug("**** FUNCTION church_admin_get_push_tokens_from_ids ******");
    church_admin_debug("For array of people_ids");
    church_admin_debug($ids);
        /**
         *
         * Returns  array of pushTokens from array of people_ids
         *
         * @author  Andy Moyle
         * @param    $name
         * @return   serialized array
         * @version  0.1
         *
         */
    global $wpdb;
    
    $pushTokens=array();
    if(!empty( $ids) )
    {
        foreach( $ids AS $key=>$id)
        {
			 $sql='SELECT pushToken FROM '.CA_PEO_TBL.' WHERE people_id="'.(int)$id.'" AND pushToken!="" LIMIT 1';
            church_admin_debug( $sql);
            $result=$wpdb->get_var( $sql);
            church_admin_debug($result);
            if( !empty( $result ) )  {$pushTokens[]=$result;}
         
        }
    }
    church_admin_debug('Array of pushTokens');
    church_admin_debug($pushTokens);
    return array_filter( $pushTokens);
}
function church_admin_get_user_id( $name)
{
        /**
 *
 * Returns serialized array of user_id if $name is in DB
 *
 * @author  Andy Moyle
 * @param    $name
 * @return   serialized array
 * @version  0.1
 *
 */
    global $wpdb;
    $names=explode(',',$name);

    $user_ids=array();
    if(!empty( $names) )
    {
        foreach( $names AS $key=>$value)
        {
			      $value=trim( $value);

            if(!empty( $value) )
            {//only look if a name stored!
                //$sql='SELECT user_id FROM '.CA_PEO_TBL.' WHERE CONCAT_WS(" ",first_name,prefix,last_name) LIKE "'.esc_sql( $value).'"OR CONCAT_WS(" ",first_name,middle_name,prefix,last_name) LIKE "'.esc_sql( $value).'" OR CONCAT_WS(" ",first_name,middle_name,last_name) LIKE "'.esc_sql( $value).'" OR CONCAT_WS(" ",first_name,prefix,last_name) LIKE "'.esc_sql( $value).'" OR  nickname LIKE "'.esc_sql( $value).'" LIMIT 1';
                $sql='SELECT user_id FROM '.CA_PEO_TBL.' WHERE CONCAT_WS(" ",first_name,last_name) LIKE("%'.$value.'%")||CONCAT_WS(" ",first_name,prefix,last_name) LIKE("%'.$value.'%")||first_name LIKE("%'.$value.'%")||last_name LIKE("%'.$value.'%")||nickname LIKE("%'.$value.'%")||email LIKE("%'.$value.'%")||mobile LIKE("%'.$value.'%") LIMIT 1';

                $result=$wpdb->get_var( $sql);

                if( $result)  {$user_ids[]=$result;}else
				        {
					          echo '<p>'.esc_html( $value).' is not stored by Church Admin as Wordpress User. ';
					          $people_id=$wpdb->get_var('SELECT people_id FROM '.CA_PEO_TBL.' WHERE CONCAT_WS(" ",first_name,last_name) REGEXP "^'.esc_sql( $value).'" LIMIT 1');
					          if(!empty( $people_id) )echo'Please <a href="'.wp_nonce_url('admin.php?page=church_admin/index.php&amp;action=edit_people&amp;people_id='.$people_id,'edit_people').'">edit</a> entry to connect/create site user account.';
					          echo'</p>';
				        }
            }
        }
    }
    if(!empty( $user_ids) )  { return maybe_serialize(array_filter( $user_ids) );}else{return NULL;}
}
function church_admin_get_one_id( $name)
{
	global $wpdb;
	$sql='SELECT people_id FROM '.CA_PEO_TBL.' WHERE first_name LIKE "'.esc_sql( $name).'" OR last_name LIKE "'.esc_sql( $name).'" OR CONCAT_WS(" ",first_name,last_name) LIKE "'.esc_sql( $name).'" OR CONCAT_WS(" ",first_name,prefix,last_name) LIKE "'.esc_sql( $name).'" OR CONCAT_WS(" ",first_name,middle_name,prefix,last_name) LIKE "'.esc_sql( $name).'" OR CONCAT_WS(" ",first_name,middle_name,last_name) LIKE "'.esc_sql( $name).'" OR CONCAT_WS(" ",first_name,prefix,last_name) LIKE "'.esc_sql( $name).'" OR  nickname LIKE "'.esc_sql( $name).'" LIMIT 1';
    $result=$wpdb->get_var( $sql);
	if(!empty( $result) )  {return $result;}else{return $name;}
}


function church_admin_update_order( $which='member_type')
{
    global $wpdb;
    if(isset( $_POST['order'] ) )
    {
        switch( $which)
        {
			case'facilities':$tb=CA_FAC_TBL; $field='facilities_order'; $id='facility_id';break;
            case'member_type':$tb=CA_MTY_TBL; $field='member_type_order'; $id='member_type_id';break;
            case'rota_settings':$tb=CA_RST_TBL; $field='rota_order'; $id='rota_id';break;
            case'small_groups':$tb=CA_SMG_TBL; $field='smallgroup_order'; $id='id';break;
			case'people':$tb=CA_PEO_TBL; $field='people_order'; $id='people_id';break;
            case'funnel':$tb=CA_FUN_TBL; $field='funnel_order'; $id='funnel_id';break;
        }
        $order=explode(",",$_POST['order'] );
        foreach( $order AS $order=>$row_id)
        {
            $member_type_order++;
            $head=='';
            if( $which=='people')
            {
            	if( $order==0)  {$head=', head_of_household=1';}else{$head=', head_of_household=0';}
            }
            $sql='UPDATE '.$tb.' SET '.$field.'="'.esc_sql( $order).'" '.$head.' WHERE '.$id.'="'.esc_sql( $row_id).'"';
            //church_admin_debug( $sql);
            $wpdb->query( $sql);
        }
    }
}
function church_admin_sermon_series_array(){
    global $wpdb;
    $out=array();
    $sql='SELECT * FROM '.CA_SERM_TBL.' ORDER BY series_name';
    $results=$wpdb->get_results( $sql );
    if( $results )
    {

        foreach( $results AS $row ){
        
            $out[$row->series_id]= $row->series_name;
        }
    }
    
    return $out;

}
function church_admin_classes_array(){
    global $wpdb;
    $out=array();
    $sql='SELECT * FROM '.CA_CLA_TBL.' WHERE next_start_date>=NOW() ORDER BY name';
    $results=$wpdb->get_results( $sql );
    if( $results )
    {

        foreach( $results AS $row ){
        
            $out[$row->class_id]= $row->name;
        }
    }
    
    return $out;

}
function church_admin_event_array(){
    global $wpdb;
    $out=array();
    $sql='SELECT * FROM '.CA_EVE_TBL.' WHERE event_date>=NOW() ORDER BY title';
    $results=$wpdb->get_results( $sql );
    if( $results )
    {

        foreach( $results AS $row ){
        
            $out[$row->event_id]= $row->title;
        }
    }
    
    return $out;

}
function church_admin_facilities_array(){
    global $wpdb;
    $out=array();
    $sql='SELECT * FROM '.CA_FAC_TBL.' ORDER BY facility_name';
    $results=$wpdb->get_results( $sql );
    if( $results )
    {

        foreach( $results AS $row ){
        
            $out[$row->facilities_id]= $row->facility_name;
        }
    }
    
    return $out;
}

function church_admin_sermon_sermons_array(){
    global $wpdb;
    $out=array();
    $sql='SELECT * FROM '.CA_FIL_TBL.' ORDER BY pub_date DESC LIMIT 100';
    $results=$wpdb->get_results( $sql );
    if( $results )
    {

        foreach( $results AS $row ){
        
            $out[$row->file_id]= $row->file_title.' - ('.mysql2date(get_option('date_format'),$row->pub_date).')';
        }
    }
    
    return $out;

}
function church_admin_services_array(){
    global $wpdb,$wp_locale;
    $out=array();
    $sql='SELECT a.*,b.venue AS site FROM '.CA_SER_TBL.' a ,'.CA_SIT_TBL.' b WHERE a.site_id=b.site_id';
    $results=$wpdb->get_results( $sql);
    if( $results)
    {

        foreach($results AS $row){
            
            $serviceDay=$wp_locale->get_weekday( $row->service_day);
            $out[$row->service_id]=sprintf(__('%1$s on %2$s at %3$s','church-admin'),$row->service_name,$serviceDay,$row->service_time);
        }
    }
    
    return $out;
}
function church_admin_sites_array(){
    global $wpdb;
    $out=array();
    $sql='SELECT * FROM '.CA_SIT_TBL;
    $results=$wpdb->get_results( $sql);
    if( $results)
    {

        foreach($results AS $row){
            
            
            $out[$row->site_id]= esc_html( $row->venue );
        }
    }
    
    return $out;
}
function church_admin_groups_array()
{
    //church_admin_debug('****** CHURCH ADMIN GROUPS ARRAY ******');
    global $wpdb,$wp_locale;
    $groups=array();
    $results=$wpdb->get_results('SELECT * FROM '.CA_SMG_TBL.' ORDER BY group_day ASC, group_name ASC');
    if(!empty( $results) )
    {
        foreach( $results AS $row)
        {
            $groups[(int)$row->id]=$row->group_name;
            if(isset( $row->group_day) )$groups[(int)$row->id].=' ('.$wp_locale->get_weekday( $row->group_day).')';
        }
    }
    //church_admin_debug( $groups);
    //church_admin_debug('**************************************');
    return $groups;
}
function church_admin_units_array()
{
    global $wpdb;
    $units=array();
    $results=$wpdb->get_results('SELECT * FROM '.CA_UNI_TBL.' ORDER BY name');
    if(!empty($results))
    {
        foreach($results AS $row){
            $units[(int)$row->unit_id]=$row->name;
        }
    }
    return $units;
}
function church_admin_calendar_categories_array()
{
    global $wpdb;
    $categories=array();
    $results=$wpdb->get_results('SELECT * FROM '.CA_CAT_TBL.' ORDER BY category ASC');
    foreach( $results AS $row)
    {
        $categories[$row->cat_id]=$row->category;
    }
    return( $categories);
}
function church_admin_member_type_array()
{
    global $wpdb;
    $member_type=array();
    $results=$wpdb->get_results('SELECT * FROM '.CA_MTY_TBL.' ORDER BY member_type_order ASC');
    foreach( $results AS $row)
    {
        $member_type[$row->member_type_id]=$row->member_type;
    }
    return( $member_type);
}
function church_admin_kidswork_array()
{
    global $wpdb;
    $kidswork=array();
    $results=$wpdb->get_results('SELECT * FROM '.CA_KID_TBL.' ORDER BY youngest ASC');
    foreach( $results AS $row)
    {
        $kidswork[$row->id]=$row->group_name;
    }
    return( $kidswork);
}


/**
* This function deletes a person from a hope team
*
* @author     	andymoyle
* @param		$people_id,$meta_type
* @return		array
*
*/
function church_admin_delete_from_hope_team( $people_id)
{
  global $wpdb;
  ;
  $wpdb->query('DELETE FROM '.CA_MET_TBL.' WHERE people_id="'.esc_sql( $people_id).'" AND meta_type="hope_team" ');

}

function church_admin_get_ministry_hierarchy( $ID)
{

	$structure=array();
	while( $ID)
	{
		$thisOne=church_admin_get_ministry( $ID);
		if(!empty( $thisOne->ministry) )$structure[$ID]=$thisOne->ministry;
		if(!empty( $thisOne->parentID) )  {$ID=$thisOne->parentID;}
		else $ID=FALSE;
	}
	return $structure;
	
}
function church_admin_get_ministry( $ID)
{
	global $wpdb;
	$result=$wpdb->get_row('SELECT * FROM '.CA_MIN_TBL.' WHERE id="'.(int)$ID.'"');
	if ( empty( $result) )  {return FALSE;}else{return $result;}

}

function church_admin_get_hierarchy( $ID)
{
		$rand=rand();
  		church_admin_leadership_hierarchy( $ID,$rand);
    	$hierarchy=get_option('church_admin_leadership_hierarchy'.$rand);
    	delete_option('church_admin_leadership_hierarchy'.$rand);
    	return $hierarchy;
}

function church_admin_leadership_hierarchy( $ID,$rand)
{
	global $wpdb;
	$hierarchy=get_option('church_admin_leadership_hierarchy'.$rand);
	if ( empty( $hierarchy)||(is_array( $hierarchy)&&!in_array( $ID,$hierarchy) ))  {$hierarchy=array(1=>$ID);update_option('church_admin_leadership_hierarchy'.$rand,$hierarchy);}
	$sql='SELECT parentID FROM '.CA_MIN_TBL.' WHERE ID="'.esc_sql( $ID).'"';

	$nextlevel=$wpdb->get_var( $sql);
	if ( empty( $nextlevel) )
	{

	 	return $hierarchy;
	}
	else
	{
		$hierarchy[]=(int)$nextlevel;

		update_option('church_admin_leadership_hierarchy'.$rand,$hierarchy);
		church_admin_leadership_hierarchy( $nextlevel,$rand);
	}
}
/**
* This function updates a people meta
*
* @author     	andymoyle
* @param		$people_id,$meta_type,$ID
* @return		array
*
*/
function church_admin_update_people_meta( $ID,$people_id,$meta_type='ministry',$meta_date=NULL)
{
    
  global $wpdb;
  if ( empty( $meta_date) )$meta_date=date('Y-m-d');
 	$wpdb->show_errors();
  	$meta_id=$wpdb->get_var('SELECT meta_id FROM '.CA_MET_TBL.' WHERE people_id="'.esc_sql( $people_id).'" AND meta_type="'.esc_sql( $meta_type).'" AND ID="'.esc_sql( $ID).'" AND meta_date="'.esc_sql( $meta_date).'"');
  	if ( empty( $meta_id) )
  	{
  		$sql='INSERT INTO '.CA_MET_TBL.' (people_id,ID,meta_type,meta_date) VALUES ("'.esc_sql( $people_id).'", "'.esc_sql( $ID).'", "'.esc_sql( $meta_type).'", "'.esc_sql( $meta_date).'" );';
     
  		$wpdb->query( $sql);

  	}
    else
    {
        $wpdb->query('UPDATE '.CA_MET_TBL.' SET ID="'.esc_sql( $ID).'" WHERE meta_id="'.(int)$meta_id.'"');
    }
   church_admin_debug( $wpdb->last_query);
}
function church_admin_person_meta_array( $people_id)
{
    global $wpdb;
    $outputArray=array();
    if ( empty( $people_id) ) return $outputArray;
    $results=$wpdb->get_results('SELECT * FROM '.CA_MET_TBL.' WHERE people_id="'.(int)$people_id.'"');
    if ( empty( $results) ) return $outputArray;
    foreach( $results AS $row)
    {
        $outputArray[esc_html( $row->meta_type)]=(int)$row->ID;
    }
    return $outputArray;
}
function church_admin_get_people_meta_array( $meta_type,$ID)
{
    //church_admin_debug('******** church_admin_get_people_meta_array ************');
	global $wpdb;
    $people=array();
    $displayCurrentPeople='';
    $sql='SELECT people_id FROM '.CA_MET_TBL.' WHERE meta_type="'.esc_sql( $meta_type).'" AND ID="'.(int)$ID.'"';
    //church_admin_debug( $sql);
	$results=$wpdb->get_results( $sql);
    //church_admin_debug(print_r( $results,true) );
    if( $results)
    {
        foreach( $results AS $row)
        {
            if(ctype_digit( $row->people_id) )
            { 
                $sql='SELECT * FROM '.CA_PEO_TBL.' WHERE people_id="'.(int)$row->people_id.'"';
                //church_admin_debug( $sql);
                $person=$wpdb->get_row( $sql);
                //church_admin_debug( $person);
                if(!empty( $person) ) $people[]= church_admin_formatted_name( $person);
            }
            else $people[]=$row->people_id;
        }
    }
  
	return $people;
}

function church_admin_get_people_meta_list( $meta_type,$ID)
{
    $out=NULL;
    $people =  array_filter(church_admin_get_people_meta_array( $meta_type,$ID));
    if(!empty( $people) ) 
    {
        $out= implode(', ',$people);
    }
    return $out;
    
}
/**
* This function produces an array of meta_id for people_id
*
* @author     	andymoyle
* @param		$people_id,$meta_type
* @return		FALSE or array
*
*/
function church_admin_get_people_meta( $people_id,$meta_type='smallgroup')  {
  global $wpdb;
  $out=array();

  $results=$wpdb->get_results('SELECT ID FROM '.CA_MET_TBL.' WHERE people_id="'.esc_sql( $people_id).'" AND meta_type="'.esc_sql( $meta_type).'"');
  if ( empty( $results) )  {return FALSE;}
  else
  {
  	foreach( $results AS $row)$out[]=$row->ID;
  	return $out;
  }
}

function church_admin_people_meta( $ID=NULL,$people_id=NULL,$meta_type=NULL)
{
	global $wpdb;
	$sql='SELECT a.*,b.* FROM '.CA_MET_TBL.' a ,'.CA_PEO_TBL.' b WHERE a.people_id=b.people_id AND ';
	$where=array();
	if(!empty( $ID) ) $where[]= 'a.ID="'.(int)$ID.'" ';
	if(!empty( $people_id) )$where[]=' a.people_id="'.(int)$people_id.'"';
	if(!empty( $meta_type) )$where[]=' a.meta_type="'.esc_sql( $meta_type).'"';
	$query=$sql.implode(' AND ',$where).' ORDER BY b.last_name,b.first_name ASC';

	$results=$wpdb->get_results( $query);
	return $results;
}

/**
* This function deletes a meta data for a given people_id or meta ID
*
* @author     	andymoyle
* @param		$people_id,$meta_type
* @return
*
*/
function church_admin_delete_people_meta( $ID=NULL,$people_id=NULL,$meta_type=NULL)
{
    //church_admin_debug('*** church_admin_delete_people_meta ***');
    //church_admin_debug('ID '.$ID);
    //church_admin_debug('people id '.$people_id);
    //church_admin_debug('meta type '.$meta_type);
	global $wpdb;
	if ( empty( $people_id) )return FALSE;
    if( $ID)  {
		$wpdb->query('DELETE FROM '.CA_MET_TBL.' WHERE people_id="'.esc_sql( $people_id).'" AND meta_type="'.esc_sql( $meta_type).'" AND ID="'.esc_sql( $ID).'"');
	}else{
		$wpdb->query('DELETE FROM '.CA_MET_TBL.' WHERE people_id="'.esc_sql( $people_id).'" AND meta_type="'.esc_sql( $meta_type).'"');
	}
    //church_admin_debug( $wpdb->last_query);
}

function strip_only( $str, $tags)
{
    //this functions strips some tages, but not all
    if(!is_array( $tags) ) {
        $tags = (strpos( $str, '>') !== false ? explode('>', str_replace('<', '', $tags) ) : array( $tags) );
        if ( end( $tags) == '') array_pop( $tags);
    }
    foreach( $tags as $tag) $str = preg_replace('#</?'.$tag.'[^>]*>#is', '', $str);
    return $str;
}

function checkDateFormat( $date)
{
  //match the format of the date
  if (preg_match ("/^([0-9]{4})-([0-9]{2})-([0-9]{2})$/", $date, $parts) )
  {
    //check weather the date is valid of not
        if(checkdate( $parts[2],$parts[3],$parts[1] ) )
          return true;
        else
         return false;
  }
  else
    return false;
}


function QueueEmail( $to,$subject,$message,$copy=NULL,$from_name=NULL,$from_email=NULL,$attachment=NULL,$schedule=NULL)
{
    global $wpdb;

    $sqlsafe=array();
    $sqlsafe['to']=esc_sql( $to);
    $sqlsafe['from_name']=esc_sql( $from_name);
    $sqlsafe['from_email']=esc_sql( $from_email);
    $sqlsafe['subject']=esc_sql( $subject );
    $sqlsafe['message']=esc_sql( $message );
    $sqlsafe['attachment']=!empty( $attachment)?esc_sql(maybe_serialize( $attachment) ):null;
	$sqlsafe['schedule']=!empty( $schedule)?esc_sql( $schedule):null;
    $sqlsafe['copy']=esc_sql(maybe_unserialize( $copy) );
    $sql='INSERT INTO '.CA_EMA_TBL.' (recipient,from_name,from_email,copy,subject,message,attachment,schedule)VALUES("'.$sqlsafe['to'].'","'.$sqlsafe['from_name'].'","'.$sqlsafe['from_email'].'","'.$sqlsafe['copy'].'","'.$sqlsafe['subject'].'","'.$sqlsafe['message'].'","'.$sqlsafe['attachment'].'","'.$sqlsafe['schedule'].'")';

	$result=$wpdb->query( $sql);

    if( $result) {return $wpdb->insert_id;}else{return FALSE;}
}

if(!function_exists('set_html_content_type') )  {function set_html_content_type() {return 'text/html';}}

function church_admin_plays( $file_id)
{
	global $wpdb;
	$plays=$wpdb->get_var('SELECT plays FROM '.CA_FIL_TBL.' WHERE file_id="'.esc_sql( $file_id).'"');
	return $plays;
}

function church_admin_dateCheck( $date, $yearepsilon=5000)
{ // inputs format is "yyyy-mm-dd" ONLY !
if (count( $datebits=explode('-',$date) )!=3) return false;
$year = intval( $datebits[0] );
$month = intval( $datebits[1] );
$day = intval( $datebits[2] );
if ((abs( $year-date('Y') )>$yearepsilon) || // year outside given range
( $month<1) || ( $month>12) || ( $day<1) ||
(( $month==2) && ( $day>28+(!( $year%4) )-(!( $year%100) )+(!( $year%400) )) ) ||
( $day>30+(( $month>7)^( $month&1) )) ) return false; // date out of range
if( checkdate( $month,$day,$year) ) {return ( $year.'-'.sprintf("%02d", $month).'-'.sprintf("%02d", $day) );}else{return FALSE;}
}

/**************************************************************************************************************************************************
*
*
*  Check if logged in user can do what is wanted
* param ID - ID of person about to be edited/deleted or ID of ministry
* admins can do anything
*
*
*
*
***************************************************************************************************************************************************/
function church_admin_user_can( $ID,$meta_type='smallgroup')
{
	$can=FALSE;
	global $current_user;
	wp_get_current_user();
	$user_people_id=$wpdb->get_var('SELECT people_id FROM '.CA_PEO_TBL.' WHERE user_id="'.(int)$current_user->ID.'"');

	//administrator
	if(current_user_can('manage_options') ) return TRUE;

	//if current user is the passed ID
	if( $user_people_id==$ID)return TRUE;

	if( $meta_type=='smallgroup')
	{
		//check if $ID is in a group led or overseen
		$sgID=$wpdb->get_var('SELECT ID FROM '.CA_MET_TBL.' WHERE people_id="'.(int)$id.'" AND meta_key="smallgroup"');
		if(!empty( $sgID) )
		{
			$leaders=maybe_unserialize( $wpdb->get_var('SELECT leadership FROM '.CA_SMG_TBL.' WHERE id="'.intval( $sgID).'"') );
			if(is_array( $leaders) )
			{
				foreach( $leaders AS $leaderlevel)
				{
					if(in_array( $user_people_id,$leaderlevel) ) return TRUE;
				}
			}
		}
	}
	else
	{//ministry
	//see if ministry has a parent
		$parentID=$wpdb->get_var('SELECT parentID FROM '.CA_MIN_TBL.' WHERE ID="'.(int)$id.'"');
		if ( empty( $parentID) ) return FALSE;
		if(parent( $ID) )  {return TRUE;}
		function parent( $ID)
		{
			$check=$wpdb->get_var('SELECT meta_id FROM '.CA_MET_TBL.' WHERE ID="'.(int)$id.'" AND people_id="'.intval( $user_people_id).'" AND meta_type="ministry"');
			if(!empty( $check) ) return TRUE;
			$next_level=$wpdb->get_var('SELECT parentID FROM '.CA_MIN_TBL.' WHERE ID="'.intval( $parentID).'"');
			if(!empty( $next_level) )
			{
				if(parent( $next_level) )  { return TRUE;}else return FALSE;
			}
			else return FALSE;
		}
		//see if user is in that parent ministry

	}
	return FALSE;
}


function church_admin_adjust_brightness( $hex, $steps)
{
    // Steps should be between -255 and 255. Negative = darker, positive = lighter
    $steps = max(-255, min(255, $steps) );

    // Normalize into a six character long hex string
    $hex = str_replace('#', '', $hex);
    if (strlen( $hex) == 3) {
        $hex = str_repeat(substr( $hex,0,1), 2).str_repeat(substr( $hex,1,1), 2).str_repeat(substr( $hex,2,1), 2);
    }

    // Split into three parts: R, G and B
    $color_parts = str_split( $hex, 2);
    $return = '#';

    foreach ( $color_parts as $color) {
        $color   = hexdec( $color); // Convert to decimal
        $color   = max(0,min(255,$color + $steps) ); // Adjust color
        $return .= str_pad(dechex( $color), 2, '0', STR_PAD_LEFT); // Make two char hex code
    }

    return $return;
}
 /**
 *
 * Replace rota entry
 *
 * @author  Andy Moyle
 * @param    $people_id,$date,$mtg_type,$service_id,$rota_task_id
 * @return   BOOL
 * @version  0.1
 *
 */
 function church_admin_update_rota_entry( $rota_task_id,$rota_date,$people_id,$mtg_type,$service_id,$service_time)
 {
 	global $wpdb;
    //church_admin_debug('******** church_admin_update_rota_entry **********');
 	$table=CA_ROTA_TBL;
	
 	$data=array(
 			'rota_task_id'=>$rota_task_id,
 			'people_id'=>$people_id,
 			'mtg_type'=>$mtg_type,
 			'service_id'=>$service_id,
 			'rota_date'=>$rota_date,
			'service_time'=>$service_time
 	);

 	$format=array(
 			'%d',
 			'%s',
 			'%s',
 			'%d',
 			'%s',
		'%s'
 	);
	 $rota_id=$wpdb->get_var('SELECT rota_id FROM '.CA_ROTA_TBL.' WHERE rota_task_id="'.esc_sql( $rota_task_id).'" AND people_id="'.(int)$people_id.'" AND mtg_type="'.esc_sql( $mtg_type).'" AND service_id="'.(int)$service_id.'" AND rota_date="'.esc_sql( $rota_date).'"');

 	if ( empty( $rota_id) )
 	{
 		$wpdb->insert( $table,$data,$format);
 	}
 	else
 	{
 		$where=array('rota_id'=>$rota_id);
 		$wpdb->update( $table, $data, $where, $format  );

	}
    church_admin_debug( $wpdb->last_query);
 }
  /**
 *
 * Grab array of people_ids for particular ministry_id
 *
 * @author  Andy Moyle
 * @param    $ministry_id
 * @return   array( $people_id=>$name)
 * @version  0.1
 *
 */
 function church_admin_ministry_people_array( $ministry_id)
 {
 	global $wpdb;
 	$out=array();
 	$results=$wpdb->get_results('SELECT a.*, b.people_id AS people_id FROM '.CA_PEO_TBL.' a, '.CA_MET_TBL.' b WHERE a.people_id=b.people_id AND b.meta_type="ministry" AND b.ID="'.intval( $ministry_id).'" ');
 	//church_admin_debug( $results);
    if(!empty( $results) )
 	{
 		foreach( $results AS $row)$out[$row->people_id]=church_admin_formatted_name( $row);
 	}

 	return $out;
 }
  /**
 *
 * Grab array of people_ids for particular rota_task_id and event
 *
 * @author  Andy Moyle
 * @param    $rota_date,$rota_taks_id,$service_id,$mtg_type
 * @return   array( $people_id=>$name)
 * @version  0.1
 *
 */
 function church_admin_rota_people_array( $rota_date,$rota_task_id,$service_id,$mtg_type)
 {
 	global $wpdb;
 	$out=array();
	$sql='SELECT * FROM '.CA_ROTA_TBL.' WHERE rota_task_id="'.(int)$rota_task_id.'" AND mtg_type="'.esc_sql( $mtg_type).'" AND service_id="'.(int)$service_id.'" AND rota_date="'.esc_sql( $rota_date).'"';
	
    //church_admin_debug( $sql);
 	
	if(!empty( $rota_date) )$results=$wpdb->get_results( $sql);
 	if(!empty( $results) )
 	{
 		foreach( $results AS $row)  {
            if(!empty( $row->people_id) )$out[$row->people_id]=church_admin_get_person( $row->people_id);
        }
 	}
 	return $out;
 }
   /**
 *
 * Grab comma separated list of people for particular rota_taks_id and event
 *
 * @author  Andy Moyle
 * @param    $rota_date,$rota_taks_id,$service_id,$mtg_type
 * @return   string
 * @version  0.1
 *
 */
 function church_admin_rota_people( $rota_date,$rota_task_id,$service_id,$mtg_type)
 {
 	return implode(", ",church_admin_rota_people_array( $rota_date,$rota_task_id,$service_id,$mtg_type) );
 }
    /**
 *
 * Grab comma separated list of people for particular rota_taks_id and event
 *
 * @author  Andy Moyle
 * @param    $rota_date,$rota_taks_id,$service_id,$mtg_type
 * @return   string
 * @version  0.1
 *
 */
 function church_admin_rota_people_initials( $rota_date,$rota_task_id,$service_id,$mtg_type)
 {
 	$people=church_admin_rota_people_array( $rota_date,$rota_task_id,$service_id,$mtg_type);
 	$initials=array();
 	foreach( $people AS $key=>$person)
 	{
 		$words = explode(" ", $person);
        
		$acronym = "";
		if(!empty( $words) )
        {
            foreach ( $words as $w) {if(!empty( $w[0] ) )$acronym .= strtoupper( $w[0] );}
        }
		$initials[]=$acronym;
 	}
 	return implode(", ",$initials);
 }

function church_admin_rota_people_firstname_initial_last_name( $rota_date,$rota_task_id,$service_id,$mtg_type)
{
    ////church_admin_debug('First name initial Last name initial processing');
    global $wpdb;
    $out=array();
	$sql='SELECT * FROM '.CA_ROTA_TBL.' WHERE rota_task_id="'.(int)$rota_task_id.'" AND mtg_type="'.esc_sql( $mtg_type).'" AND service_id="'.(int)$service_id.'" AND rota_date="'.esc_sql( $rota_date).'"';
	if(!empty( $rota_date) )$results=$wpdb->get_results( $sql);
 	if(!empty( $results) )
 	{
 		foreach( $results AS $row)
        {
            ////church_admin_debug( $row);
            ////church_admin_debug( $row->people_id);
            if(ctype_digit( $row->people_id) )
            {
                ////church_admin_debug("DIGIT");
                //stored as a people id
                $person = $wpdb->get_row('SELECT * FROM '.CA_PEO_TBL.' WHERE people_id="'.(int)$row->people_id.'"');
                ////church_admin_debug( $person);
                if(!empty( $person) )
                {
                    ////church_admin_debug( $person);
                    $firstName=!empty( $person->first_name)?$person->first_name:NULL;
                    $prefix=!empty( $person->prefix)?$person->prefix:NULL;
                    $initialOfLastName=!empty( $person->last_name)?substr( $person->last_name,0,1):NULL;   
                    $out[]=implode(" ",array_filter(array( $firstName,$prefix,$initialOfLastName) ));
                }
            }
            else
            {
                
                //church_admin_debug("WORDS");
                //stored as a name
                $words=explode(" ",$row->people_id);
                ////church_admin_debug( $words);
                //assume first word is first name and last word is last name, everything between a prefix
                $count=count( $words);
                ////church_admin_debug('ARRAY COUNT:'. $count);
                $firstName=$words[0];
                $initialOfLastName=strtoupper(substr( $words[$count-1],0,1) );
                $prefix=array();
                if( $count>2)
                {
                    
                    //there's a prefix eg "van der"
                    for ( $x=1; $x<$count-1; $x++)$prefix[]=$words[$x];
                }
                $prefix=implode(' ',$prefix);
                $out[]=implode(" ",array_filter(array( $firstName,$prefix,$initialOfLastName) ));
                
            }
        }
 	}
 	return implode(", ",$out);
}

/**
 *
 * Works out font size and orientation for data
 *
 * @author  Andy Moyle
 * @param    $lengths, $fontSize
 * @return   array(orientation,font_size,widths)
 * @version  0.1
 *
 */
function church_admin_pdf_settings( $lengths,$fontSize=10)
{
	//M is max width letter and at 1pt Arial will take up 0.35mm approx, will allow 3mm either side
	$colWidth=array();
	foreach( $lengths AS $key=>$length)$colWidth[$key]=( $length*$fontSize*0.2)+6;
	$pdfSettings=array('font_size'=>$fontSize,'widths'=>$colWidth);
	//find total width and check it is less than width of page
	$tableWidth=array_sum( $colWidth);
	//church_admin_debug("Table Width: $tableWidth");
	$pdfSize=get_option('church_admin_pdf_size');

	switch( $pdfSize)
	{
		case 'A4':
					if(( $tableWidth)<190)$pdfSettings['orientation']='P';
					elseif( $tableWidth<277)$pdfSettings['orientation']='L';
					else{return FALSE;}
		break;
		case 'Letter':
					if(( $tableWidth)<195)$pdfSettings['orientation']='P';
					elseif( $tableWidth<259)$pdfSettings['orientation']='L';
					else{return FALSE;}
		break;
		case 'Legal':
					if(( $tableWidth)<200)$pdfSettings['orientation']='P';
					elseif( $tableWidth<346)$pdfSettings['orientation']='L';
					else{return FALSE;}
		break;
	}

	return $pdfSettings;

}

     function church_admin_api_checker( $url) {
        $curl = curl_init( $url);

        //don't fetch the actual page, you only want to check the connection is ok
        curl_setopt( $curl, CURLOPT_NOBODY, true);

        //do request
        $result = curl_exec( $curl);

        $ret = false;

        //if request did not fail
        if ( $result !== false) {
            //if request was ok, check response code
            $statusCode = curl_getinfo( $curl, CURLINFO_HTTP_CODE);
       		$ret=$statusCode;
        }
        curl_close( $curl);

       return $statusCode;
    }
/**
 *
 * Page id of church_admin_register shortcode containing page
 *
 * @author  Andy Moyle
 * @param    $lengths, $fontSize
 * @return   array(orientation,font_size,widths)
 * @version  0.1
 *
 */
function church_admin_register_page_id()
{
	global $wpdb;
	$page_id=$wpdb->get_var('SELECT ID FROM '.$wpdb->posts.' WHERE (post_content LIKE "%[church_admin_register]%" OR post_content LIKE "%wp:church-admin/register%" OR post_content LIKE "%wp:church-admin/basic-register%")AND post_status="publish" LIMIT 1');
    //church_admin_debug("PAGE id is $page_id");
	if(!empty( $page_id) )  {return (int)$page_id;}else{return FALSE;}
}
 /**
 *
 * Page id of church_admin_unsubscribe shortcode containing page
 *
 * @author  Andy Moyle
 * @param    $lengths, $fontSize
 * @return   array(orientation,font_size,widths)
 * @version  0.1
 *
 */
function church_admin_unsubscribe_page_id()
{
	global $wpdb;
	$page_id=$wpdb->get_var('SELECT ID FROM '.$wpdb->posts.' WHERE post_content LIKE "%[church_admin_unsubscribe]%" AND post_status="publish" LIMIT 1');
	if(!empty( $page_id) )  {return intval( $page_id);}else{return FALSE;}
}

 /**
 *
 * Check whether person with peple_id is active or not
 *
 * @author  Andy Moyle
 * @param    $people_id
 * @return   BOOL
 * @version  0.1
 *
 */
function church_admin_deactivated_check( $people_id)
{
	global $wpdb;
	$check=$wpdb->get_var('SELECT active FROM '.CA_PEO_TBL.' WHERE people_id="'.(int)$people_id.'"');
	if( $check)
	{
		return TRUE;
	}
	else
	{
		return FALSE;
	}
}
 /**
 *
 * Output JQuery to handle clicking on Activate/Deactivate
 *
 * @author  Andy Moyle
 * @param
 * @return   $out
 * @version  0.1
 *
 */
function church_admin_activate_script()
{	//jQuery for processing activate/deactivate peopl
		$nonce = wp_create_nonce("church_admin_people_activate");
		$out='

	<script type="text/javascript">
		jQuery(document).ready(function( $) {
			$("body").on("click",".activate", function()  {
				var id = this.id;
        console.log("people_id "+id);
      			var data = {
				"action": "church_admin",
				"method":"people_activate",
				"people_id": id,
				"nonce": "'.$nonce.'"
				};
      console.log( data);
		// since 2.8 ajaxurl is always defined in the admin header and points to admin-ajax.php
		  $.getJSON(ajaxurl, data, function(response) {
      console.log( response)
			if(response.status==1)  {
					$("#"+response.id).removeClass("ca-deactivated");
					$("#active-"+response.id).html("Active ");
				}else{
					$("#"+response.id).addClass("ca-deactivated");
					$("#active-"+response.id).html("Deactive ");
				}
		});
			});
		});
	</script>

	';
	return $out;
}
/*
function church_admin_helper()
{


$out='
	<script>
		jQuery(document).ready(function( $) {
			$("body").on("click"," .help", function()  {
			var id=this.id;
			var message;
				switch(id)
				{
					case "active-message":
						alert("'.__('Click to change active status of person in directory','church-admin').'");
					break;


				}

			});
			});
	</script>';
return $out;


}
*/

class ChurchAdminDateTime extends DateTime {

    public function returnAdd(DateInterval $interval)
    {
        $dt = clone $this;
        $dt->add( $interval);
        return $dt;
    }

    public function returnSub(DateInterval $interval)
    {
        $dt = clone $this;
        $dt->sub( $interval);
        return $dt;
    }

}



/*********************
*
*
*	AJAX operations
*
***********************/
function church_admin_date()
{
	require_once(plugin_dir_path( __FILE__) .'../display/calendar.new.php');
	echo church_admin_display_day( $_POST['date'] );
	exit();
}


function church_admin_note_delete_callback() {

	//check_admin_referer('church_admin_delete_note','nonce');
	global $wpdb;
	$sql='DELETE FROM '.CA_COM_TBL.'  WHERE comment_id="'.intval( $_POST['note_id'] ).'"';
	$wpdb->query( $sql);
	$sql='DELETE FROM '.CA_COM_TBL.'  WHERE parent_id="'.intval( $_POST['note_id'] ).'"';
	$wpdb->query( $sql);
	echo TRUE;
	exit();
}



function church_admin_cron_dismissable_notice() {

    /****************************
     * Set sermon page notice
     ****************************/
    $setSermonPageDismissed=get_option('dismissed-church-admin-set-sermon-page'); 
    if ( empty( $setSermonPageDismissed)&& !empty( $_GET['page'] )&&( $_GET['page']=='church_admin%2Findex.php') )
    {
        echo '<div class="updated notice notice-set-sermon-page is-dismissible" data-notice="prefix_deprecated">
                <h2>Church Admin Plugin - '.__( 'Please set your sermon page', 'my-text-domain' ).'</h2>
                <p>'.__('If you are having unpredictable results with sharing and PDF links on your sermon pages, please set your main sermon page','church-admin').'</p>
                <p><a class="button-primary" target="_blank" href="'.admin_url().'admin.php?page=church_admin%2Findex.php&action=set-sermon-page&amp;section=media">'.__('Set sermon page','church-admin').'</a></p>
                </div>';
            echo'<script>jQuery(document).ready(function( $)  {
                $(".notice-set-sermon-page").on("click",".notice-dismiss",function()  {
                    console.log("dismissed");
                    $.ajax( ajaxurl,
                    {
                      type: "POST",
                      data: {
                        action: "church_admin",
                        method:"dismissed-notice-handler",
                        type: "church-admin-set-sermon-page",
                      },
                      success:function()  {console.log("Ajax dismiss done");}
                    } );

                });

            });</script>';
    }
     /****************************
     * Set Email settings changed notice v3.6.16
     ****************************/
        $dismissed=get_option('dismissed-church-admin-email-settings');
        if ( empty( $dismissed)&& !empty( $_GET['page'] )&&( $_GET['page']=='church_admin%2Findex.php') ) { 
            // Added the class "notice-my-class" so jQuery pick it up and pass via AJAX,
            // and added "data-notice" attribute in order to track multiple / different notices
            // multiple dismissible notice states 
            echo '<div class="updated notice ca-email-settings-changed is-dismissible" data-notice="prefix_deprecated">
                <h2>'.__( 'Email Settings have changed', 'church-admin' ).'</h2>
                <p>'.__('Some email settings have been changed - please check yours are okay still.','church-admin').'</p>
                <p><a  target="_blank" href="admin.php?page=church_admin%2Findex.php&action=email-settings">'.__('Email settings','church-admin').'</a></p>
                </div>';
            echo'<script>jQuery(document).ready(function( $)  {
                $(".ca-email-settings-changed").on("click",".notice-dismiss",function()  {
                    console.log("dismissed");
                    $.ajax( ajaxurl,
                    {
                      type: "POST",
                      data: {
                        action: "church_admin",
                        method:"dismissed-notice-handler",
                        type: "church-admin-email-settings",
                      },
                      success:function()  {console.log("Ajax dismiss done");}
                    } );

                });

            });</script>';
        }
    /****************************
     * Please review
     ****************************/
    $dismissed=get_option('dismissed-church-admin-please-review');
    if ( empty( $dismissed) && !empty( $_GET['page'] )&&( $_GET['page']=='church_admin/index.php') ) { 
        // Added the class "notice-my-class" so jQuery pick it up and pass via AJAX,
        // and added "data-notice" attribute in order to track multiple / different notices
        // multiple dismissible notice states 
        echo '<div class="updated notice ca-please-review is-dismissible" data-notice="prefix_deprecated">
            <h2>'.__( 'Please review the Church Admin Plugin', 'church-admin' ).'</h2>
            <p><img src="'.plugin_dir_url( __DIR__ ).'/images/church-admin-logo.png" class="alignleft" alt="Church Admin Plugin logo"/>'.__('If you are enjoying using the Church Admin plugin, please could you leave a review','church-admin').'</p>
            <p><a  target="_blank" class="button-primary" href="https://wordpress.org/support/plugin/church-admin/reviews/#new-post">'.__('Leave a review','church-admin').'</a></p>
            <p>'.__('If you have any issues, or need help, please do you use our support form or online chat','church-admin').'</p>
            <p><a  target="_blank" class="button-secondary" href="https://www.churchadminplugin.com/support">'.__('Support forum','church-admin').'</a></p>
            </div>';
        echo'<script>jQuery(document).ready(function( $)  {
            $(".ca-please-review").on("click",".notice-dismiss",function()  {
                console.log("dismissed");
                $.ajax( ajaxurl,
                {
                  type: "POST",
                  data: {
                    action: "church_admin",
                    method:"dismissed-notice-handler",
                    type: "dismissed-church-admin-please-review",
                  },
                  success:function()  {console.log("Ajax dismiss done");}
                } );

            });

        });</script>';
    }
}

add_action( 'admin_notices', 'church_admin_cron_dismissable_notice' );

function church_admin_unattach_user()
{

	global $wpdb;
	////church_admin_debug((int)$_POST['people_id'] );
	$wpdb->query('UPDATE '.CA_PEO_TBL.' SET user_id=NULL WHERE people_id="'.(int)$_POST['people_id'].'"');
}
/**
 *
 * Ajax - returns json array with people's names
 * Used by fautoe
 * @author  Andy Moyle
 * @param    null
 * @return   json array
 * @version  0.1
 *
 */
function church_admin_ajax_people( $active=FALSE)
{

    global $wpdb;
    $names=explode(", ", $_GET['term'] );//put passed var into array
    $name=esc_sql(stripslashes(trim(end( $names) )) );//grabs final value for search
    if(!empty( $active) )  { $activeSQL=" active=1 AND ";}else{$activeSQL="";}

   $sql='SELECT CONCAT_WS(" ",first_name,prefix, last_name) AS name FROM '.CA_PEO_TBL.' WHERE '.$activeSQL.' (CONCAT_WS(" ",first_name,last_name) LIKE "%'.esc_sql( $name).'%" OR CONCAT_WS(" ",first_name,prefix,last_name) LIKE "%'.esc_sql( $name).'%" OR CONCAT_WS(" ",first_name,middle_name,prefix,last_name) LIKE "%'.esc_sql( $name).'%" OR CONCAT_WS(" ",first_name,middle_name,last_name) LIKE "%'.esc_sql( $name).'%" OR CONCAT_WS(" ",first_name,prefix,last_name) LIKE "%'.esc_sql( $name).'%" OR  nickname LIKE "%'.esc_sql( $name).'%") ';
    ////church_admin_debug( $sql);
    $result=$wpdb->get_results( $sql);

    if( $result)
    {
        $people=array();
        foreach( $result AS $row)
        {
            $people[]=array('name'=>$row->name);
        }

        //echo JSON to page

    $response =json_encode( $people);

    echo $response;
    }
    exit();
}


function church_admin_mp3_plays() {
	$nonce = $_POST['data']['security'];
 	//if ( ! wp_verify_nonce( $nonce, 'church_admin_mp3_play' ) )die('busted');
    
	global $wpdb;
	$file_id = esc_sql( $_POST['data']['file_id'] );
    $currPlays=$wpdb->get_var('SELECT plays FROM '.CA_FIL_TBL.' WHERE  file_id = "'.$file_id.'"');
    if ( empty( $currPlays) )$currPlays=0;
    $newPlays=$currPlays+1;
	$sql='UPDATE '.CA_FIL_TBL.' SET plays = '.intval( $newPlays).' WHERE file_id = "'.$file_id.'"';
	$wpdb->query( $sql);
	$plays=$wpdb->get_var('SELECT plays FROM '.CA_FIL_TBL.' WHERE file_id = "'.$file_id.'"');

	echo $plays;
	die();
}

function church_admin_username_check()
{
	//check_admin_referer('church_admin_username_check','nonce');

	if(username_exists(stripslashes( $_POST['user_name'] ) ))  {echo'<span class="dashicons dashicons-no" style="color:red"></span>';}else{echo'<span style="color:green" class="dashicons dashicons-yes"></span>';}
	exit();
}

function church_admin_filter_callback() {

	////check_admin_referer('church_admin_filter','nonce');

	require_once(plugin_dir_path(dirname(__FILE__) ).'includes/filter.php');
	////church_admin_debug("callback");

	church_admin_filter_process();

	exit();
}

function church_admin_filter_email_callback() {

	//check_admin_referer('church_admin_filter','nonce');
	require_once(plugin_dir_path(dirname(__FILE__) ).'/includes/filter.php');
	echo church_admin_filter_email( $_POST['type'] );
	exit();
}




function church_admin_people_activate_callback() {

	//check_admin_referer('activate','nonce');
	global $wpdb;
  $people_id=substr( $_REQUEST['people_id'],7);
  ////church_admin_debug( $people_id);
	$sql='UPDATE '.CA_PEO_TBL.' SET active = !active WHERE people_id="'.(int)$people_id.'"';
 // //church_admin_debug( $sql);
	$wpdb->query( $sql);
	$status=$wpdb->get_var('SELECT active FROM '.CA_PEO_TBL.' WHERE people_id="'.(int)$people_id.'"');
    if( $status==0)  {$active=__('Inactive','church-admin');}else{$active=__('Active','church-admin');}
	$output=array('status'=>$active,'id'=>(int)$people_id);
  header('Access-Control-Max-Age: 1728000');
  header('Access-Control-Allow-Origin: *');
  header('Access-Control-Allow-Methods: *');
  header('Access-Control-Allow-Headers: Content-MD5, X-Alt-Referer');
  header('Access-Control-Allow-Credentials: true');
  echo json_encode( $output);
  die();
  exit();
}


function church_admin_ministries_array()
{
	global $wpdb;
	$ministries=array();
	$results=$wpdb->get_results('SELECT * FROM '.CA_MIN_TBL);
	if(!empty( $results) )
	{
		foreach( $results AS $row)$ministries[(int)$row->ID]=esc_html( $row->ministry);
	}
	return $ministries;
}

function church_admin_hope_teams_array()
{
	global $wpdb;
	$hope_team=array();
	$results=$wpdb->get_results('SELECT * FROM '.CA_HOP_TBL);
	if(!empty( $results) )
	{
		foreach( $results AS $row)$hope_team[intval( $row->hope_team_id)]=esc_html( $row->job);
	}
	return $hope_team;
}
function church_admin_small_groups_array()
{
	global $wpdb;
	$small_groups=array();
	$results=$wpdb->get_results('SELECT * FROM '.CA_SMG_TBL);
	if(!empty( $results) )
	{
		foreach( $results AS $row)$small_groups[(int)$row->id]=esc_html( $row->group_name);
	}
	return $small_groups;
}

function church_admin_encode( $word) {

    $word = str_replace("@","%40",$word);
    $word = str_replace("`","%60",$word);
    $word = str_replace("¢","%A2",$word);
    $word = str_replace("£","%A3",$word);
    $word = str_replace("¥","%A5",$word);
    $word = str_replace("|","%A6",$word);
    $word = str_replace("«","%AB",$word);
    $word = str_replace("¬","%AC",$word);
    $word = str_replace("¯","%AD",$word);
    $word = str_replace("º","%B0",$word);
    $word = str_replace("±","%B1",$word);
    $word = str_replace("ª","%B2",$word);
    $word = str_replace("µ","%B5",$word);
    $word = str_replace("»","%BB",$word);
    $word = str_replace("¼","%BC",$word);
    $word = str_replace("½","%BD",$word);
    $word = str_replace("¿","%BF",$word);
    $word = str_replace("À","%C0",$word);
    $word = str_replace("Á","%C1",$word);
    $word = str_replace("Â","%C2",$word);
    $word = str_replace("Ã","%C3",$word);
    $word = str_replace("Ä","%C4",$word);
    $word = str_replace("Å","%C5",$word);
    $word = str_replace("Æ","%C6",$word);
    $word = str_replace("Ç","%C7",$word);
    $word = str_replace("È","%C8",$word);
    $word = str_replace("É","%C9",$word);
    $word = str_replace("Ê","%CA",$word);
    $word = str_replace("Ë","%CB",$word);
    $word = str_replace("Ì","%CC",$word);
    $word = str_replace("Í","%CD",$word);
    $word = str_replace("Î","%CE",$word);
    $word = str_replace("Ï","%CF",$word);
    $word = str_replace("Ð","%D0",$word);
    $word = str_replace("Ñ","%D1",$word);
    $word = str_replace("Ò","%D2",$word);
    $word = str_replace("Ó","%D3",$word);
    $word = str_replace("Ô","%D4",$word);
    $word = str_replace("Õ","%D5",$word);
    $word = str_replace("Ö","%D6",$word);
    $word = str_replace("Ø","%D8",$word);
    $word = str_replace("Ù","%D9",$word);
    $word = str_replace("Ú","%DA",$word);
    $word = str_replace("Û","%DB",$word);
    $word = str_replace("Ü","%DC",$word);
    $word = str_replace("Ý","%DD",$word);
    $word = str_replace("Þ","%DE",$word);
    $word = str_replace("ß","%DF",$word);
    $word = str_replace("à","%E0",$word);
    $word = str_replace("á","%E1",$word);
    $word = str_replace("â","%E2",$word);
    $word = str_replace("ã","%E3",$word);
    $word = str_replace("ä","%E4",$word);
    $word = str_replace("å","%E5",$word);
    $word = str_replace("æ","%E6",$word);
    $word = str_replace("ç","%E7",$word);
    $word = str_replace("è","%E8",$word);
    $word = str_replace("é","%E9",$word);
    $word = str_replace("ê","%EA",$word);
    $word = str_replace("ë","%EB",$word);
    $word = str_replace("ì","%EC",$word);
    $word = str_replace("í","%ED",$word);
    $word = str_replace("î","%EE",$word);
    $word = str_replace("ï","%EF",$word);
    $word = str_replace("ð","%F0",$word);
    $word = str_replace("ñ","%F1",$word);
    $word = str_replace("ò","%F2",$word);
    $word = str_replace("ó","%F3",$word);
    $word = str_replace("ô","%F4",$word);
    $word = str_replace("õ","%F5",$word);
    $word = str_replace("ö","%F6",$word);
    $word = str_replace("÷","%F7",$word);
    $word = str_replace("ø","%F8",$word);
    $word = str_replace("ù","%F9",$word);
    $word = str_replace("ú","%FA",$word);
    $word = str_replace("û","%FB",$word);
    $word = str_replace("ü","%FC",$word);
    $word = str_replace("ý","%FD",$word);
    $word = str_replace("þ","%FE",$word);
    $word = str_replace("ÿ","%FF",$word);
    return $word;
}


function church_admin_in_array_r( $needle, $haystack, $strict = false) {
   if(!empty( $haystack)&&is_array( $haystack) )
   {
   	foreach ( $haystack as $item)
   		{
    	    if (( $strict ? $item === $needle : $item == $needle) || (is_array( $item) && church_admin_in_array_r( $needle, $item, $strict) ))
    	    {
        	    return true;
        	}
    	}
	}
    return false;
}

function church_admin_user_id_exists( $user)  {

    global $wpdb;

    $count = $wpdb->get_var( $wpdb->prepare("SELECT COUNT(*) FROM $wpdb->users WHERE ID = %d", $user) );

    if( $count == 1)  { return true; }else{ return false; }

}


function ca_date_link( $year,$month,$day,$legend=FALSE,$class=NULL,$type=calendar,$facilities_id=NULL)
{
	if ( empty( $legend) )$legend=$day;
    if( $type=='facility-bookings')  {$section='facilities';}else{$section='calendar';}
	if(!empty( $class) )  {$class=' class="'.$class.'"';}else{$class='';}
	if(is_admin() )
    {
        $link='admin.php?page=church_admin/index.php&amp;action='.$type.'&amp;section='.$section;
        if(!empty( $facilities_id) )$link.='&amp;facilities_id='.intval( $facilities_id);
    }else{$link='';}
	$out='<form action="'.$link.'" method="POST">
	<input type="hidden" name="start_date" value="'.esc_html( $year.'-'.$month.'-'.sprintf('%02d', $day) ).'"/><button '.$class.'>'.esc_html( $legend).'</button></form>';
	return $out;

}



function church_admin_scaled_image_path( $attachment_id, $size = 'thumbnail') {
    $file = get_attached_file( $attachment_id, true);
    
    if (empty( $size) || $size === 'full') {
        // for the original size get_attached_file is fine
        return realpath( $file);
    }
    if (! wp_attachment_is_image( $attachment_id) ) {
        return false; // the id is not referring to a media
    }
    $info = image_get_intermediate_size( $attachment_id, $size);
   
    if (!is_array( $info) || ! isset( $info['file'] ) ) {
        return false; // probably a bad size argument
    }
    $path=realpath(str_replace(wp_basename( $file), $info['file'], $file) );
  
    $return=array('path'=>$path,'height'=>$info['height'],'width'=>$info['width'] );
    return $return;
}

function church_admin_detect_runtime_issues()
{
    global $wp_version;
    $error=array();
      if  (!in_array  ('curl', get_loaded_extensions() ))
      {
        $error['curl']=__('cURL is not enabled on your server, please contact your hosting company to get it enabled','church-admin');
      }
      if (version_compare(phpversion(), '5.3.10', '<') )
      {
        $error['php']=__('Your PHP version is low and therefore is not safe and lacks some features needed by WordPress and Church Admin','church-admin');
      }
      if ( version_compare( $wp_version, '4.0', '<=' ) )
      {
        $error['wordpress']=__('Your WordPress version is very out of date. Please update now','church-admin');
      }
      //SPIT OUT ERRORS IF NEEDED
      if(!empty( $error) )
      {
        echo'<div class="notice notice-warning"><h2>'.__('Issues detected by Church Admin plugin','church-admin').'</h2><p><strong>'.implode("<br />",$error).'</strong></div>';

      }


}
function church_admin_refresh_rolling_average()
{
	global $wpdb;
	$results=$wpdb->get_results('SELECT * FROM '.CA_ATT_TBL);
	if(!empty( $results) )
	{
		foreach( $results AS $row)
		{
			$avesql='SELECT FORMAT(AVG(adults),0) AS rolling_adults,FORMAT(AVG(children),0) AS rolling_children FROM '.CA_ATT_TBL.' WHERE `mtg_type`="'.esc_sql( $row->mtg_type).'" AND `service_id`="'.esc_sql( $row->service_id).'" AND `date` >= DATE_SUB("'.esc_sql( $row->date).'",INTERVAL 52 WEEK) AND `date`<= "'.esc_sql( $row->date).'"';
    		$averow=$wpdb->get_row( $avesql);
    		$wpdb->query('UPDATE '.CA_ATT_TBL.' SET rolling_adults= "'.intval( $averow->rolling_adults).'",rolling_children= "'.intval( $averow->rolling_children).'" WHERE attendance_id="'.intval( $row->attendance_id).'"');
		}
	}

}

function church_admin_whosin_kidswork_array()
{
		global $wpdb;
		$kidswork=array();
		//select GROUPS

			$results=$wpdb->get_results('SELECT a.*,a.id AS kidswork_id, b.ministry FROM '.CA_KID_TBL.' a  LEFT JOIN '.CA_MIN_TBL.' b ON a.department_id=b.ID ORDER BY youngest DESC');
			if(!empty( $results) )
			{
					foreach( $results AS $row)
					{
							$kidswork[$row->kidswork_id]=array('name'=>$row->group_name,'youngest'=>$row->youngest,'oldest'=>$row->oldest);
							//get kids in that group
							$sql='SELECT people_id,household_id,kidswork_override FROM '.CA_PEO_TBL.' WHERE  (kidswork_override="'.esc_sql( $row->id).'" OR ((date_of_birth<"'.$row->youngest.'" AND date_of_birth>"'.$row->oldest.'") AND kidswork_override=0 ) )';

							$kids=$wpdb->get_results( $sql);
							if(!empty( $kids) )
							{
								foreach( $kids AS $kid)
								{
										//get parents of that kid
										$parents=array();
										$parents_result=$wpdb->get_results('SELECT people_id FROM '.CA_PEO_TBL.' WHERE household_id="'.intval( $kid->household_id).'" AND people_type_id=1');
										if(!empty( $parents_result) )
										{
											foreach( $parents_result AS $parent)
											{
													$parents[]=$parent->people_id;
											}
										}
										$kidswork[$row->kidswork_id]['children'][]=array('people_id'=>intval( $kid->people_id),'household_id'=>intval( $kid->household_id),'parents'=>$parents);

								}
							}
					}
				}

				return $kidswork;

}
function church_admin_get_kids_groups( $people_id)
{
  //this function finds the kids work groups a parent has children in.
    $groups=array();//array of groups people_id is a parent of a child in that group
    $kidsGroups=church_admin_whosin_kidswork_array();
    if(!empty( $kidsGroups) )
    {
      foreach( $kidsGroups AS $group_id=>$kidsGroup)
      {
        if(!empty( $kidsGroup['children'] ) )
	    {
		  	foreach( $kidsGroup['children'] AS $kids)
          	{
            	if(in_array( $people_id,$kids['parents'] ) )$groups[]=$group_id;
          	}
		}
      }
    }
    //church_admin_debug("people_id: $people_id is a parent of kids in these groups \r\n".print_r( $groups,TRUE) );
    return $groups;
}
/**
 *
 * Returns member level of current user
 *
 * @author  Andy Moyle
 * @param    $member_type_id Comma separated ids
 * @return
 * @version  0.1
 *
 */
 function church_admin_user_member_level( $member_type_id)
 {
   global $wpdb,$current_user;
   wp_get_current_user();
   $permission=FALSE;
   $member_type_ids=explode(',',$member_type_id);
   if(is_user_logged_in() )
   {
     $person_member_type_id=$wpdb->get_var('SELECT member_type_id FROM '.CA_PEO_TBL.' WHERE user_id="'.esc_sql( $current_user->ID).'"');
     if ( empty( $member_type_id) )$permission=TRUE;
     elseif(!empty( $member_type_id) && ((is_array( $member_type_ids)&& in_array( $person_member_type_id,$member_type_ids) )||$member_type_id=='#') )  {$permission=TRUE;}
        
   }
   return $permission;
 }


function church_admin_head_of_household_tidy( $household_id)
{
	global $wpdb;
	/******************************************************************
		*
		* Make sure there is a head of household and tidy up if messy
		*
		*******************************************************************/
		$check=$wpdb->get_results('SELECT people_id FROM '.CA_PEO_TBL.' WHERE head_of_household=1 AND household_id="'.esc_sql( $household_id).'"');
		if(!empty( $check) &$wpdb->num_rows>1)
		{
			//more than one head of household so reset
			$wpdb->query('UPDATE '.CA_PEO_TBL.' SET head_of_household=0 WHERE household_id="'.esc_sql( $household_id).'"');
			unset( $check);
		}
		if ( empty( $check) )
		{
			$people_order=$wpdb->get_results('SELECT people_id FROM '.CA_PEO_TBL.' WHERE people_order=1 AND household_id="'.esc_sql( $household_id).'" ORDER BY people_id ASC');
			if( $people_order)
			{//people_order set and more than 1 is 1
				if( $wpdb->num_rows>1)
				{
					//more than one entry has people order 1 so tidy that first
					$wpdb->query('UPDATE '.CA_PEO_TBL.' SET people_order=0 WHERE household_id="'.esc_sql( $household_id).'"');
					$x=1;
					foreach( $people_order AS $people)
					{
						$wpdb->query('UPDATE '.CA_PEO_TBL.' SET people_order="'.(int)$x.'" WHERE people_id="'.esc_sql( $people->people_id).'"');
						$x++;
					}
				}
				//set household_id for frst person
				$wpdb->query('UPDATE '.CA_PEO_TBL.' SET head_of_household=1 WHERE household_id="'.esc_sql( $household_id).'" AND people_order=1');
			}
			else
			{
				//no people order set or head of household_id
				$people=$wpdb->get_results('SELECT people_id FROM '.CA_PEO_TBL.' WHERE  household_id="'.esc_sql( $household_id).'" ORDER BY people_id ASC');
				if(!empty( $people) )
				{
					$x=1;
					foreach( $people AS $person)
					{
						if( $x==1)  {$wpdb->query('UPDATE '.CA_PEO_TBL.' SET head_of_household=1, people_order=1 WHERE people_id="'.esc_sql( $person->people_id).'"');}
						else{$wpdb->query('UPDATE '.CA_PEO_TBL.' SET  people_order='.$x.' WHERE people_id="'.esc_sql( $person->people_id).'"');}
						$x++;
					}
				
				}
			}
		}
    $people_id=$wpdb->get_var('SELECT people_id FROM '.CA_PEO_TBL.' WHERE head_of_household=1 AND household_id="'.esc_sql( $household_id).'"');
    return $people_id;

}



function church_admin_shortcodes_list()
{
	global $wpdb,$wp_locale;
	//shortcodes
	echo'<h1>'.__('Shortcodes','church-admin').'</h1>';
	echo '<h3>'.__('Communications','church-admin').'</h3>';
	//classes
	echo'<h3>'.__('Classes','church-admin').'</h3>';
	echo'<p>[church_admin type="classes" today=TRUE] '.__('displays a list of classes, today (remove today=TRUE for current classes). Logged in users can book in. Logged in Class leaders can check in students','church-admin').'</p>';
    //calendar
    echo'<h3>'.__('Calendar','church-admin').'</h3>';
    //calendar
    echo'<p>[church_admin type="calendar-list" days="28" category="1,2,3"] '.__('displays a list of calendar events for the next 28 days from (optional) 1,2,3 categories','church-admin').'</p>';
    echo'<p>[church_admin type="calendar" style="old"] '.__('displays a monthly calendar table','church-admin').'</p>';
    echo'<p>[church_admin type="calendar" ] '.__('displays a day to view calendar','church-admin').'</p>';
    echo '<p>'.__('[church_admin type="calendar-list" category="1,2,3" weeks="4"] shows calendar events from categories 1,2 and 3 for the next 4 weeks','church-admin').'</p>';
    $results=$wpdb->get_results("SELECT * FROM ".$wpdb->prefix."church_admin_calendar_category");
    if( $results)
    {
    	echo'<table><thead><tr><th>'.__('Shortcode','church-admin').'</th><th>Category</th></tr></thead><tbody>';
        foreach( $results AS $row)
        {
             $shortcode='<strong>[church_admin type="calendar-list" category="'.esc_html( $row->cat_id).'" weeks="4"]</strong>';
            echo'<tr><th scope="row">'.$shortcode.'</th><td>'.sprintf(__('Calendar List by Category %1$s','church-admin'),esc_html( $row->category) ).'</td></tr>';
        }
        echo'</tbody></table>';
    }
	//directory

    echo'<h3>'.__('Directory','church-admin').'</h3>';
    echo'<p>'.__('The directory shortcode is [church_admin type="address-list" member_type_id="#" photo="1" map="1" site_id="0" pdf="1"]','church-admin').'</strong></p>';
		  echo'<p>'.__('pdf=0 will not display PDF links, pdf=1 displays standard PDF, pdf=2 displays alternate version ','church-admin').'</p>';
		echo'<p>'.__('photo=1 will display a thumbnail if one has been uploaded','church-admin').'</p>';
    echo'<p>'.__('site=0 will display people from all sites, or if comma separated numbers used individual sites.','church-admin').'</p>';
	echo'<p>'.__('map=1 shows a map for households where you have updated location on the google map when editing.','church-admin').' </p>';
    echo'<p>'.__('Member type can include more than one member type separated with commas e.g.:','church-admin').'<strong>[church_admin type=address-list member_type_id=1,2 map=1 photo=1]</strong></p>';
    echo'<p>'.__('kids=0 will stop children being shown','church-admin').'.</p>';
    echo'<p>'.__('loggedin=TRUE makes the page available to logged in users only','church-admin').'</p>';
    echo'<p>'.__("updateable=FALSE disables the edit link on each entry for admins and logged in user's entry",'church-admin').'</p>';

    $member_types=$wpdb->get_results('SELECT * FROM '.CA_MTY_TBL.' ORDER BY member_type_id');
    if( $member_types)
    {
        echo '<p>'.__('These are your current member types','church-admin').'</p>';
        foreach( $member_types AS $row)
        {
            echo'<p><label>'.esc_html( $row->member_type).': </label>member_type_id='.intval( $row->member_type_id).'</p>';
        }
    }
	echo '<h3>'.__('Follow Up funnels','church-admin').'</h3>';
	echo '<p>'.__('[church_admin type="follow-up"] display recent people activity and follow up actions menu','church-admin').'</p>';
    echo'<h3>'.__('Names','church-admin').'</h3>';
    echo'<p>'.__('[church_admin type=names member_type_id=# people_types=#] displays just names','church-admin').'</p>';
     echo'<p>'.__('people_types can be "all","adults","teens","children" or a combination separated by a comma','church-admin').'</p>';

    //media
    echo'<h3>'.__('Media','church-admin').'</h3>';
    echo'<p><strong>[church_admin type=podcast] </strong>'.__('Lists all sermons','church-admin').'</p>';
	echo'<p><strong>[church_admin type=podcast most_popular=FALSE] </strong>'.__('Lists all sermons and turns off Most Popular tab','church-admin').'</p>';
    $results=$wpdb->get_results('SELECT * FROM '.CA_SERM_TBL);
    if( $results)
    {//results
    	echo'<table class="widefat striped">';
    	echo'<thead><tr><th>'.__('Series Name','church-admin').'</th><th>'.__('Number of sermons','church-admin').'</th><th>'.__('Shortcode'.'church-admin').'</th></tr></thead><tfoot><tr><th>'.__('Series Name','church-admin').'</th><th>'.__('Number of sermons','church-admin').'</th><th>'.__('Shortcode'.'church-admin').'</th></tr></tfoot><tbody>';
    	foreach ( $results AS $row)
    	{
    		$files=$wpdb->get_var('SELECT count(*) FROM '.CA_FIL_TBL.' WHERE series_id="'.esc_sql( $row->series_id).'"');
            if(!$files)$files="0";
    		echo'<tr><td>'.esc_html( $row->series_name).'</td><td>'.intval( $files).'</td><td>[church_admin type="podcast" series_id="'.(int)$row->series_id.'"]</td></tr>';
    	}
    	echo'</tbody></table>';
    }
    //member map
    echo'<h3>'.__('Member Map','church-admin').'</h3>';
    echo'<p>'.__('[church_admin_map member_type_id="#" zoom="13" small_group="1"]- zoom is Google map zoom level, small_group=1 for different colours for small groups, 0 for all in red','church-admin').'</p>';
    //ministries
    echo'<h3>'.__('Ministries','church-admin').'</h3>';
    echo'<p><strong>[church_admin type="ministries" ministry_id=# member_type_id="#"] </strong>'.__('Lists people doing various ministries - just specify ministry_ids','church-admin').'</p>';
    $min=get_option('church_admin_ministries');
    if(!empty( $min) )  {
    	foreach( $min AS $id=>$ministry) echo'<p>'.sprintf( esc_html__( '"%1$s" has id %2$s.', 'church-admin' ), $ministry, (int)$id ).'</p>';

    }
    echo'<p>'.__('[church_admin type="kidswork"] shows the childrens groups','church-admin').'.</p>';
	//volunteers
    echo'<h3>'.__('Online serving/volunteer application','church-admin').'</h3>';
	echo'<p>'.__('[church_admin type="volunteer"] allows logged in users to volunteer for ministries where the online volunteer checkbox is checked','church-admin').'.</p>';
    //recent
	echo'<h3>'.__('Recent Visitors','church-admin').'</h3>';
	echo'<p><strong>[church_admin type="recent" member_type_id="#"] </strong>'.__('Lists your recent visitors - just specify member_types_ids','church-admin').'</p>';
    //small groups
    echo'<h3>'.__('Small groups','church-admin').'</h3>';
    echo'<p><strong>[church_admin type="small-groups-list" map="1"]</strong>'.__(' lists all your small group\'s details in map form (map=1)or as a list (map=0)','church-admin').'</p>';
    echo'<p><strong>[church_admin type="small-groups" member_type_id="#" ]</strong>'.__('lists all your small groups and their members for a specific member type','church-admin').'</p>';
    echo'<p>'.__('For the small-groups shortcode you can add loggedin=TRUE and restricted=TRUE to only show groups the user is in or leading','church-admin').'</p>';

    //rotas
    echo'<h3>'.__('Schedules','church-admin').'</h3>';
    echo'<p><strong>[church_admin type="my_rota"]</strong>'.__(' shows a logged in user their schedule involvement.','church-admin').'</p>';
    echo'<p><strong>[church_admin type="rota" service_id="1"]</strong>'.__(' lists the upcoming schedule for a particular service','church-admin').'</p>';

    $results=$wpdb->get_results('SELECT * FROM '.CA_SER_TBL.' ORDER BY service_id');
    if( $results)
    {
        echo '<p>'.__('These are your current services','church-admin').'</p>';
        foreach( $results AS $row)
        {
            if(!(ctype_digit( $row->service_day)&&$row->service_day>=0 &&$row->service_day<=7) )$row->service_day=0;

            	echo'<p><label>'.esc_html( $row->service_name).' on '.$wp_locale->get_weekday( $row->service_day).' at '.esc_html( $row->service_time).' </label>service_id='.intval( $row->service_id).'</p>';

        }
    }

    //user registration
    echo'<h3>'.__('User Registration','church-admin').'</h3>';
    echo'<p><strong>[church_admin_register create_user=FALSE admin_email=TRUE] </strong></p>';
    echo'<p>'.__('This shortcode allows new people to register and logged in users to update their own entry.','church-admin').'</p>';
     echo'<p>'.__('create_user=TRUE will create a subscriber user for each valid email address','church-admin').'</p>';
      echo'<p>'.__('admin_email=TRUE lets the admin email know that a new address entry has been created','church-admin').'</p>';
echo '<p> exclude="middle-name,nickname,prefix,date-of-birth,marital-status,image,small-groups,classes,socials,ministries,mobile,gender,custom" '.__('allows you to exclude and or all of those fields from the form','church-admin').'</p>';
    //recent activity
    echo'<h3>'.__('Recent Directory Activity','church-admin').'</h3>';
    echo'<p><strong>[church_admin_recent]</strong></p>';



	//Attendance
	 echo'<h3>'.__('Attendance','church-admin').'</h3>';
    echo'<p><strong>[church_admin type="graph" width="900" height="500"]</strong> - '.__('displays graph image 900x500px;','church-admin').'</p>';
    //Birthdays
	echo'<h3>'.__('Birthdays','church-admin').'</h3>';
	echo'<p><strong>[church_admin type="birthdays" member_type_id="#" days="#" show_age=FALSE people_type_id="#"]</strong> - '.__('displays upcoming birthdays for the next # days for member_types_ids # and people_type_ids=#. show_age=FALSE stops the year and age displaying!','church-admin').'</p>';
	//Restricted content
	echo'<h3>'.__('Restricted Content','church-admin').'</h3>';
	echo'<p><strong>[church_admin type="restricted" member_type_id="#"]'.__('Some Content','church-admin').'[/church_admin]</strong> - '.__('restrictes the content to certain member_types_ids #, which can be comma separated e.g. 1,2,3','church-admin').'</p>';
	if( $member_types)
	{
			echo '<p>'.__('These are your current member types','church-admin').'</p>';
			foreach( $member_types AS $row)
			{
					echo'<p><label>'.esc_html( $row->member_type).': </label>member_type_id='.intval( $row->member_type_id).'</p>';
			}
	}
}

/*********************************************************
*
* Correctly add $months months to datetime object $date
*
*********************************************************/
function church_admin_addMonths( $date, $months)
{
    $years = floor(abs( $months / 12) );
    $leap = 29 <= $date->format('d');
    $m = 12 * (0 <= $months?1:-1);
    for ( $a = 1; $a < $years;++$a) {
        $date = addMonths( $date, $m);
    }
    $months -= ( $a - 1) * $m;
   
    $init = clone $date;
    if (0 != $months) {
        $modifier = $months . ' months';
       
        $date->modify( $modifier);
        if ( $date->format('m') % 12 != (12 + $months + $init->format('m') ) % 12) {
            $day = $date->format('d');
            $init->modify("-{$day} days");
        }
        $init->modify( $modifier);
    }
   
    $y = $init->format('Y');
    if ( $leap && ( $y % 4) == 0 && ( $y % 100) != 0 && 28 == $init->format('d') ) {
        $init->modify('+1 day');
    }
    return $init;
}


function church_admin_is_post_type( $type)  {
    global $wp_query;
    if( $type == get_post_type() ) 
        return true;
    return false;
}



function church_admin_generateVideoEmbedUrl( $url)  {
    
    //This is a general function for generating an embed link of an FB/Vimeo/Youtube Video.
    $finalUrl = $image = $videoId = NULL;


    if(strpos( $url, 'facebook.com/') !== false) {
        //it is FB video
        $finalUrl.='https://www.facebook.com/plugins/video.php?href='.rawurlencode( $url).'&show_text=1&width=200';
    }else if(strpos( $url, 'vimeo.com/') !== false) {
        //it is Vimeo video
        $videoId = explode("vimeo.com/",$url)[1];
        if(strpos( $videoId, '&') !== false)  {
            $videoId = explode("&",$videoId)[0];
        }
        $finalUrl.='https://player.vimeo.com/video/'.$videoId;
        $image = ca_get_vimeo_data_from_id( $videoId, 'thumbnail_url' );
    }
    if(empty($finalUrl))
    {
        //probably YouTube
        /***********************************************************************************************************
        * I've adjusted regex from https://www.geeksforgeeks.org/how-to-get-youtube-video-id-with-php-regex/ to 
        * include the new style share link https://www.youtube.com/live/l18MjuLZcCo?feature=share
        ***********************************************************************************************************/
        preg_match_all("#(?<=v=|v\/|vi=|vi\/|youtu.be\/|youtube.com\/live\/)[a-zA-Z0-9_-]{11}#", $url, $match);
        if( !empty( $match['0']['0'] ) ){
           $videoId = $match['0']['0'];
           if ( empty( $videoId) )$videoId=NULL;
            $image=null;
            if( $videoId){
                $image='https://img.youtube.com/vi/'.$videoId.'/0.jpg'; 
            }
            $finalUrl = 'https://www.youtube.com/embed/'.$videoId;
        }
    }
    if(empty($finalUrl)){
        //just pass it through as not YT, FB or Vimeo
        $finalUrl = $url;
        $videoId= null;
        $image = null;
    }
    $output=array('embed'=>$finalUrl,'id'=>$videoId,'image'=>$image);
    return $output;
}

function ca_get_vimeo_data_from_id( $video_id, $data ) {
	$request = wp_remote_get( 'https://vimeo.com/api/oembed.json?url=https://vimeo.com/' . $video_id );
	
	$response = wp_remote_retrieve_body( $request );
	
	$video_array = json_decode( $response, true );
	
	return $video_array[$data];
}

function church_admin_youtube_views_api( $embed_id)
{
   //church_admin_debug('church_admin_youtube_views_api: ' . $embed_id);
    $views='';
    $google_api=get_option('church_admin_google_api_key');
    if(!empty( $google_api)&&!empty( $embed_id) )
     {
            $args = array('headers' => array( 'Referer' => site_url() ) );
            $url='https://www.googleapis.com/youtube/v3/videos?part=statistics&id='.esc_html( $embed_id).'&key='.$google_api;
            //church_admin_debug( $url);
           $response=wp_remote_get( $url,$args);
           $api_response =  json_decode(wp_remote_retrieve_body( $response ),TRUE);
           //church_admin_debug( $api_response);
           if(!empty( $api_response['items'] ) )$views=$api_response['items'][0]['statistics']['viewCount'];
     }
    return $views;
}



function church_admin_bible_audio_link( $holy_str,$version)
{
    /*********************************************************************
     * 
     * Returns array $book with keys passage,book,chapter, verses, url (audio)
     *
     * *******************************************************************/
    if ( empty( $version) )$version='ESV';
    if ( empty( $holy_str) )return FALSE;
    //church_admin_debug("**************\r\nFUNCTION church_admin_bible_audio_link $holy_str, $version");
    // split verses from book chapters
    $parts = preg_split('/\s*:\s*/', trim( $holy_str, " ;") );

    // init book
    $book = array('passage'=>'','book' => "", 'chapter' => "", 'verses' => array() );

    // $part[0] = book + chapter, if isset $part[1] is verses
    if(isset( $parts[0] ) )
    {
      // 1.) get chapter
      if(preg_match('/\d+\s*$/', $parts[0], $out) ) {
        $book['chapter'] = rtrim( $out[0] );
      }

      // 2.) book name

        $searchBook = trim(preg_replace('/\d+\s*$/', "", $parts[0] ) );
      ////church_admin_debug('Search book: '.$searchBook);
        $book['book'] =church_admin_bible_gateway_books( $searchBook);    
        
    }

    // 3.) verses
    if(isset( $parts[1] ) ) {
      $book['verses'] = preg_split('~\s*,\s*~', $parts[1] );
    }
    $book['passage'] = $book['book'].' '.$book['chapter'];
    if(!empty($book['verses'])){
        $book['passage'] .=':'.$book['verses'];
    }
    switch( $version)
    {
            
        case 'ESV':case'ESVUK':
            $book['url']='https://www.biblegateway.com/audio/mclean/esv/'.$book['book'].'.'.$book['chapter'];
                $book['linkText']='ESV audio';
        break;
        case 'NIV':case'NIVUK' :                    $book['url']='https://www.biblegateway.com/audio/mclean/niv/'.$book['book'].'.'.$book['chapter'];
            $book['linkText']='NIV audio';
        break;
        case 'NASB':    $book['url']='https://www.biblegateway.com/audio/mcconachie/nasb/'.$book['book'].'.'.$book['chapter'];
            $book['linkText']='NASB audio';
        break;
        case 'NVI':
            $book['url']='https://www.biblegateway.com/audio/single/nvi/'.$book['book'].'.'.$book['chapter'];
            $book['linkText']='Nueva Versión Internacional audio';
        break;
        case 'NTLR':
            $book['url']='https://www.biblegateway.com/audio/biblica/ntlr/'.$book['book'].'.'.$book['chapter'];
            $book['linkText']='Nouă Traducere În Limba Română';
        break;
        case 'NVIPT':
            $book['url']='https://www.biblegateway.com/audio/biblica/nvi-pt/'.$book['book'].'.'.$book['chapter'];
            $book['linkText']='Nova Versão Internacional';
        break;
    }
    //church_admin_debug(print_r( $book,TRUE) );
    return $book;
}
/*************************************************
*
*   This function returns the abbrev biblegateway.com is looking for
*
**************************************************/
function church_admin_bible_gateway_books( $book)
{
    //church_admin_debug("**************\r\nFUNCTION church_admin_bible_gateway_books");
    $books=array("Gen"=>array('Genesis','Gen','Ge','Gn'),
       "Exod"=>array('Exodus','Exo','Ex','Exod'),
       "Lev"=>array('Leviticus','Lev','Le','Lv'),
       "Num"=>array('Numbers','Num','Nu','Nm','Nb'),
       "Deut"=>array('Deuteronomy','Deut','Dt'),
       "Josh"=>array('Joshua','Josh','Jos','Jsh'),
       "Judg"=>array('Judges','Judg','Jdg','Jg','Jdgs'),
        "Ruth"=>array('Ruth','Rth','Ru'),
       "1Sam"=>array('1 Samuel','1 Sam','1 Sa','1Samuel','1S','I Sa','1 Sm','1Sa','I Sam','1Sam','I Samuel','1st Samuel','First Samuel'), 
       "2Sam"=>array('2 Samuel','2 Sam','2 Sa','2S','II Sa','2 Sm','2Sa','II Sam','2Sam','II Samuel','2Samuel','2nd Samuel','Second Samuel'), 
       "1Kgs"=>array('1 Kings','1 Kgs','1 Ki','1K','I Kgs','1Kgs','I Ki','1Ki','I Kings','1Kings','1st Kgs','1st Kings','First Kings','First Kgs','1Kin'), 
       "2Kgs"=>array('2 Kings','2 Kgs','2 Ki','2K','II Kgs','2Kgs','II Ki','2Ki','II Kings','2Kings','2nd Kgs','2nd Kings','Second Kings','Second Kgs','2Kin'), 
       "1Chr"=>array('1 Chronicles','1 Chron','1 Ch','I Ch','1Ch','1 Chr','I Chr','1Chr','I Chron','1Chron','I Chronicles','1Chronicles','1st Chronicles','First Chronicles'), 
       "2Chr"=>array('2 Chronicles','2 Chron','2 Ch','II Ch','2Ch','II Chr','2Chr','II Chron','2Chron','II Chronicles','2Chronicles','2nd Chronicles','Second Chronicles'), "Ezra"=>array('Ezra','Ezra','Ezr'), 
       "Neh"=>array('Nehemiah','Neh','Ne'), 
       "Est"=>array('Esther','Esth','Es'), 
        "Job"=>array('Job','Job','Job','Jb'), 
       "Ps"=>array('Psalm','Pslm','Ps','Psalms','Psa','Psm','Pss'), "Prov"=>array('Proverbs','Prov','Pr','Prv'),
        "Eccl"=>array('Ecclesiastes','Eccles','Ec','Ecc','Qoh','Qoheleth'), 
       "Song"=>array('Song of Solomon','Song','So','Canticle of Canticles','Canticles','Song of Songs','SOS'), 
       "Isa"=>array('Isaiah','Isa','Is'), 
       "Jer"=>array('Jeremiah','Jer','Je','Jr'), 
       "Lam"=>array('Lamentations','Lam','La'), 
       "Eze"=>array('Ezekiel','Ezek','Eze','Ezk'), 
       "Dan"=>array('Daniel','Dan','Da','Dn'), 
       "Hos"=>array('Hosea','Hos','Ho'), 
       "Joel"=>array('Joel','Joel','Joe','Jl'), 
       "Amos"=>array('Amos','Amos','Am'), 
       "Obad"=>array('Obadiah','Obad','Ob'), 
    "Jonah"=>array('Jonah','Jnh','Jon'), 
       "Mic"=>array('Micah','Micah','Mic'), 
       "Nah"=>array('Nahum','Nah','Na'), 
       "Hab"=>array('Habakkuk','Hab','Hab'), 
       "Zeph"=>array('Zephaniah','Zeph','Zep','Zp'), 
       "Hag"=>array('Haggai','Haggai','Hag','Hg'), 
       "Zech"=>array('Zechariah','Zech','Zec','Zc'), 
       "Mal"=>array('Malachi','Mal','Mal','Ml'), 
       "Matt"=>array('Matthew','Matt','Mt'), 
       "Mark"=>array('Mark','Mrk','Mk','Mr'), 
       "Luke"=>array('Luke','Luk','Lk'), 
       "John"=>array('John','John','Jn','Jhn'), 
       "Acts"=>array('Acts','Acts','Ac'), 
    "Rom"=>array('Romans','Rom','Ro','Rm'), 
       "1Cor"=>array('1 Corinthians','1 Cor','1 Co','I Co','1Co','I Cor','1Cor','I Corinthians','1Corinthians','1st Corinthians','First Corinthians'), 
       "2Cor"=>array('2 Corinthians','2 Cor','2 Co','II Co','2Co','II Cor','2Cor','II Corinthians','2Corinthians','2nd Corinthians','Second Corinthians'), 
       "Gal"=>array('Galatians','Gal','Ga'), 
       "Eph"=>array('Ephesians','Ephes','Eph'), 
       "Phil"=>array('Philippians','Phil','Php'), 
       "Col"=>array('Colossians','Col','Col'), 
       "1Thess"=>array('1 Thessalonians','1 Thess','1 Th','I Th','1Th','I Thes','1Thes','I Thess','1Thess','I Thessalonians','1Thessalonians','1st Thessalonians','First Thessalonians'), 
       "2Thess"=>array('2 Thessalonians','2 Thess','2 Th','II Th','2Th','II Thes','2Thes','II Thess','2Thess','II Thessalonians','2Thessalonians','2nd Thessalonians','Second Thessalonians'), 
       "1Tim"=>array('1 Timothy','1 Tim','1 Ti','I Ti','1Ti','I Tim','1Tim','I Timothy','1Timothy','1st Timothy','First Timothy'), 
       "2Tim"=>array('2 Timothy','2 Tim','2 Ti','II Ti','2Ti','II Tim','2Tim','II Timothy','2Timothy','2nd Timothy','Second Timothy'), 
       "Titus"=>array('Titus','Titus','Tit'), 
       "Phlm"=>array('Philemon','Philem','Phm'), 
       "Heb"=>array('Hebrews','Hebrews','Heb'), 
       "Jas"=>array('James','James','Jas','Jm'), 
       "1Pet"=>array('1 Peter','1 Pet','1 Pe','I Pe','1Pe','I Pet','1Pet','I Pt','1 Pt','1Pt','I Peter','1Peter','1st Peter','First Peter'), 
       "2Pet"=>array('2 Peter','2 Pet','2 Pe','II Pe','2Pe','II Pet','2Pet','II Pt','2 Pt','2Pt','II Peter','2Peter','2nd Peter','Second Peter'), 
       "1John"=>array('1 John','1 John','1 Jn','I Jn','1Jn','I Jo','1Jo','I Joh','1Joh','I Jhn','1 Jhn','1Jhn','I John','1John','1st John','First John'), 
       "2John"=>array('2 John','2 John','2 Jn','II Jn','2Jn','II Jo','2Jo','II Joh','2Joh','II Jhn','2 Jhn','2Jhn','II John','2John','2nd John','Second John'), 
       "3John"=>array('3 John','3 John','3 Jn','III Jn','3Jn','III Jo','3Jo','III Joh','3Joh','III Jhn','3 Jhn','3Jhn','III John','3John','3rd John','Third John'), 
       "Jude"=>array('Jude','Jude','Jud'), 
       "Rev"=>array('Revelation','Rev','Re','The Revelation') ); 
    
    foreach( $books AS $key=>$bookArray)
    {
        
        if(in_array( $book,$bookArray) )
        {
            //church_admin_debug("Found $book and using $key");
            return $key;
        }
    }
    return $book;
}






//deprecated
/*
function church_admin_nth_day( $nth,$day,$date)
{
   //Updated 2020-01-01 because of translated plugin issues...
    //don't use wp_locale as doesn't play nicely with strtotime()
	$days=array(0=>'Sunday',1=>"Monday",2=>"Tuesday",3=>"Wednesday",4=>"Thursday",5=>"Friday",6=>"Saturday");
    $month=date('M',strtotime( $date) );
    $year=date('Y',strtotime( $date) );
    return date('Y-m-d',strtotime("$nth {$days[$day]} $month $year") );
}
*/

/**
*   nth_day_of_month(int $nbr, str $day, int $mon, int $year)
*   $nbr = nth weekday to find
*   $day = integer for day no
*   $rough_date = ISO date for caldulating from eg 2023-03-03
*   returns iso date or FALSE if issues or no date exists
*/
function church_admin_nth_day($nbr, $day, $rough_date){ 

    //check valid date
    if(empty($rough_date)||!church_admin_checkdate( $rough_date)){
        //invalid date
       
        return FALSE;
    }

    $date_spilt=explode("-",$rough_date);
    $year=$date_spilt[0];
    $month=$date_spilt[1];
 
    $date = mktime(0, 0, 0, $month, 0, $year);

    if($date == 0){ 
        //invalid date
      
       return(FALSE); 
    } 
    $days=array(0=>'Sunday',1=>"Monday",2=>"Tuesday",3=>"Wednesday",4=>"Thursday",5=>"Friday",6=>"Saturday");
     
    if(empty($days[$day])){ 
        //day number invalid
        
       return(FALSE); 
    }
 
    for($week = 1; $week <= $nbr; $week++){ 
       $date = strtotime("next $days[$day] ", $date); 
    }
    
    //check still in correct month
    $calculated_month=date('m',$date);
    if($calculated_month!=$month){
        // Not in month
        return FALSE;
    }
    if(empty($date))return FALSE;
    return date('Y-m-d',$date);

}




function church_admin_favourites_menu()
{
    global $church_admin_url,$church_admin_menu;
    $user=wp_get_current_user();
/***************************************
*
*   Favourites    
*
****************************************/
echo '<li class="church-admin-top-menu ';
if(!empty( $_GET['section'] )&&$_GET['section']=='favourites')  {echo ' active ';}else{echo' inactive';}
echo'" data-menu-id="favourites">';
echo '<div class="church-admin-top-menu-item favourites"  data-menu-id="favourites" ><a href="admin.php?page=church_admin%2Findex.php&action=favourites&section=favourites"><span class="dashicons dashicons-heart"></span> '.__("Favourites",'church-admin')."</a></div>\r\n";    
$favourites=get_option('church-admin-favourites');
////church_admin_debug(print_r( $favourites,TRUE) );
if(!empty( $favourites) )
{
    if(!empty( $favourites[$user->ID] ) )$fave=$favourites[$user->ID];
    
    if(!empty( $fave) )
        {
            echo'<ul id="favourites" class="church-admin-submenu ';
            if(!empty( $_GET['section'] )&&$_GET['section']=='favourites')  {echo ' active ';}else{echo' inactive';}
            echo'">'."\r\n";;
            $firstSubMenuItem=1;
            foreach( $fave AS $key=>$menuID)
            {
                echo '<li class="favourites ';
                if( $firstSubMenuItem==1)echo' first-item';
                $firstSubMenuItem=0;
                echo'" data-menuItem="'.$menuID.'">'."\r\n";
                echo  '<a href="'.wp_nonce_url(str_replace('section='.$church_admin_menu[$menuID]['parent'],'section=favourites',$church_admin_menu[$menuID]['link'] ),$menuID).'">'.$church_admin_menu[$menuID]['title'].'</a> <span class="ca-favourites-remove dashicons dashicons-no" data-remove="'.esc_html( $menuID).'"></span>'."\r\n";
                echo"</li>\r\n";
            }
            echo'</ul>';
        }
}
    echo'</li>';
}

/***************************************************
*
*   Premium check and signup
*
****************************************************/

function church_admin_paypal_setup()    
{
    echo '<h2>'.__('PayPal Setup','church-admin').'</h2>';

    $licence=church_admin_app_licence_check();
    if(empty($licence)) {
        return  church_admin_buy_app();
    }
    $currencies=array(
                        'USD'=>'US Dollar',
                        'GBP'   =>'Pounds Sterling',
                        'AUD'=>'Australian Dollar',
                        'CAD'=>'Canadian Dollar',
                        'CNY'=>'Chinese Renmenbi',
                        'CZK' =>'Check Krone',
                        'DKK' =>'Danish Krone',
                        'EUR'   => 'Euro',
                        'HKD'   =>  'Hong Kong Dollar',
                        'HUF'   =>  'Hungarian Forint',
                        'ILS'   =>'Israeli New Shequel',
                        'JPY'   =>'Japanese Yen',
                        'MYR'   =>'Malaysian Ringgit',
                        'MXN'   =>'Mexican Peso',
                        'NOK'   =>'Norwegian Krone',
                        'NZD'   =>'New Zealand Dollar',
                        'PHP'   =>'Philippine Peso',
                        'PLN'   =>'Polish Zloty',
                        'SGD'   =>'Singapore Dollar',
                        'SEK'   =>'Swedish Krona',
                        'CHF'   =>'Swiss Franc',
                        'TWD'   =>'Taiwanese Dollar',
                        'THB'   =>'Thao Baht'

    );
    $licence=get_option('church_admin_app_new_licence');
    if(empty($licence))
    {
        //app purchase required
        echo'<h2>Buy the premium version</h2>';
        return;
    }
    if(!empty($_POST['save-paypal']) && church_admin_level_check('Giving')){
        //sanitize
        $sanitized=array();
        foreach($_POST AS $key=>$value){
            $sanitized[$key] = sanitize_text_field( stripslashes( $value ) );
        }
        
        //validate
        $errors=array();
        //check currency
        if(empty($sanitized['paypal_currency']) || empty($currencies[ $sanitized['paypal_currency'] ] ) ){
            $errors[]=__('Invalid PayPal Currency','church-admin');
        }
        if(empty($sanitized['paypal_email']) || !is_email($sanitized['paypal_email'])){$errors[]=__('Email not recognisable','church-admin');}
        $gift_aid =!empty( $sanitized['gift_aid'] )? 1 : 0;
        $show_in_app = !empty( $sanitized['gift_aid'] ) ? 1 : 0;
        if(empty($errors))
        {
            $church_admin_payment_gateway = array(
                'paypal_email'=>$sanitized['paypal_email'],
                'paypal_currency' =>$sanitized['paypal_currency'],
                'currency_symbol' => $sanitized['currency_symbol'],
                'show_in_app' => $show_in_app,
                'gift_aid' => $gift_aid
            );
            
            update_option('church_admin_payment_gateway',$church_admin_payment_gateway);
            echo '<div class="notice notice-success"><h2>'.__('PayPal setting saved','church-admin').'</h2></div>';
        }
    }
   
        
    //do form
    $premium=get_option('church_admin_payment_gateway');
    if(!empty($errors)){
        echo'<p>'.esc_html( __('There were some errors','church-admin' ) ).'</p>';
        foreach($errors AS $key=>$error){
            echo'<p>'.esc_html($error).'</p>';
        }
    }
    echo'<form action=""method="post">';
    echo'<div class="church-admin-form-group"><label>'.__('PayPal Email address').'</label>';
    echo'<input class="church-admin-form-control" type="email" name="paypal_email" ';
    if(!empty($premium['paypal_email'])) echo ' value="'.esc_attr($premium['paypal_email']).'" ';
    echo'/></div>';
    echo'<div class="church-admin-form-group"><label>'.__('PayPal Currency').'</label>';
    echo'<select name="paypal_currency" class="church-admin-form-control">';
    $my_currency=!empty($premium['paypal_currency'])?$premium['paypal_currency']:'USD';
    
    foreach($currencies AS $code=>$name)
    {
        echo'<option value="'.esc_attr($code).'" '.selected($my_currency,$code,FALSE).'>'.esc_html($name).'</option>';
    }
    echo'</select></div>';
    echo'<div class="church-admin-form-group"><label>'.__('Currency symbol').'</label>';
    echo'<input class="church-admin-form-control" type="text" name="currency_symbol" ';
    if(!empty($premium['currency_symbol'])) echo ' value="'.esc_attr($premium['currency_symbol']).'" ';
    echo'/></div>';
    $show_in_app=!empty($premium['show_in_app'])?1:0;
    echo'<div class="church-admin-form-group"><label>'.__('Show giving form in app').'</label>';
    echo'<input type="checkbox" value=1 name="show_in_app" '.checked($show_in_app,1,false).'/></div>';
    $uk_gift_aid=!empty($premium['gift_aid'])?1:0;
    echo'<div class="church-admin-form-group"><label>'.__('UK Gift Aid form?').'</label>';
    echo'<input type="checkbox" value=1 name="gift_aid" '.checked($uk_gift_aid,1,false).'/></div>';
    echo'<p><input type="hidden" name="save-paypal" value=1/><input type="submit" class="button-primary"/></p></form>';
    


}



function church_admin_premium()
{   
    echo '<h2>PayPal Setup</h2>';
    $premium=NULL;
    $licence=church_admin_app_licence_check();
    if(!empty($licence) )
    {
        $premium=get_option('church_admin_payment_gateway');
        
            if(!empty( $_POST['save-paypal-details'] ) )
            {
               $premium=array('paypal_email'=>stripslashes( $_POST['paypal_email'] ),
                              'paypal_currency'=>stripslashes( $_POST['paypal_currency'] ),
                              'currency_symbol'=>stripslashes( $_POST['currency_symbol'] ),
                              );
                if(!empty( $_POST['gift_aid'] ) )
                {
                    $premium['gift_aid']=TRUE;
                }else $premium['gift_aid']=FALSE;
                if(!empty( $_POST['show_in_app'] ) )
                {
                    $premium['show_in_app']=TRUE;
                }else $premium['show_in_app']=FALSE;
                update_option('church_admin_payment_gateway',$premium);
                echo'<div class="notice notice-success"><h2>'.__('PayPal settings saved','church-admin').'</h2></div>';
            }
            if ( empty( $premium['paypal_email'] )||empty( $premium['paypal_currency'] )||empty( $premium['currency_symbol'] ) )  {$paypalClass=' style="color:red" ';}else{$paypalClass='';}
            echo'<h2 class="ca-toggle" id="paypal" '.$paypalClass.'>'.__('Setup  PayPal details','church-admin').'</h2>';
            echo'<div class="paypal"  >';

            echo'<form action="https://www.paypal.com/cgi-bin/webscr" method="post"><input name="cmd" type="hidden" value="_xclick"> <input name="item_name" type="hidden" value="Church Admin Premium Version"> <input type="hidden" name="return" value="https://www.churchadminplugin.com/premium-paid-page"><input type="hidden" name="rm" value="2/"><input type="hidden" name="custom" value="'.site_url().'"/><input name="notify_url" type="hidden" value="https://www.churchadminplugin.com/wp-admin/admin-ajax.php?action=church_admin_frontpage_app_ipn">
                <input name="business" type="hidden" value="support@churchadminplugin.com"> <input type="hidden" name="amount" class="price" value="99">
               <div class="form-group"><select class="currency_code" name="currency_code"><option value="USD">US Dollar $99</option><option value="GBP">GB Pound Sterling £85</option><option value="EUR">Euro €100</option><option value="AUD">Australian Dollar $150</option><option value="BRL">Brazilian Real 550</option><option value="CAD">Canadian Dollar $130</option><option value="MXN">Mexican Peso 2090</option> <option value="CHF">Swiss Franc 95</option></select></div><input class="btn btn-danger button=primary" type="submit" value="Buy now with debit/credit card"></form><p></p><script>
                       jQuery( document ).ready(function( $) {
                           console.log( "ready!" );
                       $("#bank-payment").click(function()  {$(".bank-payment").toggle();});
                           $(".currency_code").change(sortPrice);
                           $(".frequency").change(sortPrice);
                           
                           function sortPrice()  {
                               var currency_code=$(".currency_code").val();
                               var frequency=$(".frequency").val();
                               console.log("Currency "+ currency_code+ "Frequency "+frequency);
                               var price=99;
                               
                               var sign="&pound;";
                               console.log(currency_code)
                               switch(currency_code)
                               {
                                   default:case "GBP":price=85;sign="GBP &pound;";break;	
                                   case "AUD":price=150;sign="AUD &dollar;";break;
                                   case "MXN":price=2090;sign="MXN Peso";break;
                                   case "BRL":price=550;sign="BRL Real ";break;
                                   case "CAD":price=130;sign="CAD &dollar;";break;
                                   case "USD":price=99;sign="USD &dollar;";break;
                                   case"EUR":price=100;sign="EU &euro;";break;
                                   case "CHF":price=95;sign="CHF";break;
                                   
                               }
                               
                               $(".sign").html(sign);
                               var formattedPrice =parseFloat(Math.round(price * 100) / 100).toFixed(2);
                               $(".cost").html(formattedPrice);
                               $(".price").val(formattedPrice);
                               $(".freq").html(freq);
                               
                           };
                           
                       });</script>';
            
        
    }
    else
    {
        echo'<h2>'.__('The Our Church app, the online giving module, paid facility bookings and paid tickets are only available to churches who have the premium version.').'</h2>';
        echo'<p><a href="admin.php?page=church_admin/index.php&action=app&section=app">'.__('Buy the app','church-admin').'</a></p>';
        
    }
      
    return $premium;
}

function church_admin_app_licence_check()
{
    global $church_admin_version;
    $licence=get_option('church_admin_app_new_licence');
   
    if ( empty($licence) || $licence !='subscribed')
    {
        //need to check
        $url = 'https://www.churchadminplugin.com/?licence_check='.md5(site_url() ).'&url='.site_url().'&version='.$church_admin_version;
        //church_admin_debug( $url);
    	$result = wp_remote_get( $url );
       
		if(is_array( $result) && !is_wp_error( $result) && $result['body']!='no-sub' && ctype_digit( $result['body'] ) )
		{
            $premium=array();
            $premium=get_option('church_admin_payment_gateway');
            $premium['licence']='subscribed';
           
            update_option('church_admin_payment_gateway',$premium);
			update_option('church_admin_app_new_licence','subscribed');
			update_option('church_admin_app_id',$result['body'] );
			update_option('church_admin_licence_checked',date('Y-m-d') );
            $licence='subscribed';
            //set up menu
			delete_option('church_admin_app_new_menu');
            $defaultMenu = church_admin_app_default_menu();
            
            update_option('church_admin_app_new_menu',$defaultMenu);
		}
        else{
             delete_option('church_admin_app_new_licence');
             return false;
        }
        
    }
    if( $licence =='subscribed')
    {
        return true;
    }
    else return FALSE;
    
}


function church_admin_current_donations( $people_id,$currYear,$currPledge)
{
    global $wpdb;
    
    $out='';
    $premium=get_option('church_admin_payment_gateway');
    $donations=$wpdb->get_results('SELECT * FROM '.CA_GIV_TBL.' WHERE people_id="'.(int)$people_id.'" AND YEAR(donation_date)="'.intval( $currYear).'" ORDER BY donation_date DESC');
        if(!empty( $donations) )
        {
            $total=0;
            $out.='<h3>'.__('Your generosity so far this year','church-admin').'</h3><table><thead><tr><th>'.__('Date','church-admin').'</th><th>'.__('Amount','church-admin').'</th><th>'.__('How given','church-admin').'</th><th>'.__('Fund','church-admin').'</th></tr></thead><tbody>';
            foreach( $donations AS $donation)
            {
                $total+=$donation->gross_amount;
                $out.='<tr><td>'.mysql2date(get_option('date_format'),$donation->donation_date).'</td><td>';
                if(!empty( $premium['currency_symbol'] ) )$out.=$premium['currency_symbol'];
                $out.=number_format_i18n( $donation->gross_amount,2).'</td><td>'.esc_html( $donation->txn_type).'</td><td>'.esc_html( $donation->fund).'</td></tr>';
            }
            $out.='<tr><td><strong>'.__('Total','church-admin').'</td><td>';
            if(!empty( $premium['currency_symbol'] ) )$out.=$premium['currency_symbol'];
            $out.=number_format( $total,2).'</td><td colspan=2>&nbsp;</td></tr>';
            if(!empty( $currPledge) )
            {
                $out.='<tr><td><strong>'.__('Current Pledge','church-admin').'</td><td>';
                if(!empty( $premium['currency_symbol'] ) )$out.=$premium['currency_symbol'];
                $out.=number_format_i18n( $currPledge,2).'</td><td colspan=2>&nbsp;</td></tr>';
                $out.='<tr><td><strong>'.__('Amount Outstanding','church-admin').'</td><td>';
                if(!empty( $premium['currency_symbol'] ) )$out.=$premium['currency_symbol'];
                $out.=number_format_i18n( $currPledge-$total,2).'</td><td colspan=2>&nbsp;</td></tr>';
            }
            $out.='</tbody></table>';
        }
    return $out;
}
/********************************************************
*
*   attempt to convert phone number to e.164 format
*
*******************************************************/
function church_admin_e164( $mobile)
{
    $mobile=str_replace(' ','',$mobile);
    $mobile=str_replace('-','',$mobile);
    $mobile=str_replace('(','',$mobile);
    $mobile=str_replace(')','',$mobile);
    $mobile=ltrim( $mobile,'0');//Europe
    $country=get_option('church_admin_sms_iso');
    $e164cell='+'.$country.$mobile;
    return $e164cell;
}
/********************************************************
*
*   spam check
*   returns TRUE for spam
*   $type = email,text
*******************************************************/
function church_admin_spam_check( $text,$type)
{
    if ( empty( $text) ) return TRUE;
    
    //church_admin_debug("*****************Spam Check \r\n Checking - $text and type $type");
    //check email type is an email
    if( $type=='email' &&!is_email( $text) )
    {
        ////church_admin_debug('Should be an email');
        return TRUE;
    }    
    //look for links
    if(substr_count( $text, "http") > 0)
    {
        ////church_admin_debug('Contains a link');
        return TRUE;
    }
        //check for spam words
    $needle=array('click here','Page 1 rankings','bitcoin','shemail','lesbian','gay','Make $1000','casino','teen photos','passive income','porn','bitcoin','viagra','fuck','penis','sex','visit your website','www.yandex.ru','сайт','products on this site','business directory','<script','onClick','boobs','tits','horny','all-night');
    foreach( $needle as $query) {
        if(strpos(strtoupper( $text), strtoupper( $query), 0) !== false)
        {
            ////church_admin_debug('Spam words');
            return true; // stop on first true result
        }
    }
    return FALSE;
    
}




/*************************************************************
*
*   Email confirmation send if no GDPR reason and $people_id
*
*************************************************************/
function church_admin_email_confirm( $people_id)
{
    //only send email confirm if no GDPR reason
    global $wpdb;
    $person=$wpdb->get_row('SELECT * FROM '.CA_PEO_TBL.' WHERE people_id="'.(int)$people_id.'"');
    if(!empty( $person) &&!empty( $person->email)&& empty( $person->gdpr_reason) )
    {
        $message='<p>'.__('Thank you for registering.','church-admin');
        $message.='<p><a href="'.site_url().'/?confirm_email='.md5( $person->email).'&amp;people_id='.md5( $people_id).'">'.__('Click to confirm your email','church-admin').'</p>';
        add_filter( 'wp_mail_from_name','church_admin_from_name' );
		add_filter( 'wp_mail_from', 'church_admin_from_email');
        add_filter('wp_mail_content_type','church_admin_email_type');
        wp_mail( $person->email,__('Please confirm your email address','church-admin'),$message);
        remove_filter('wp_mail_content_type','church_admin_email_type');
        remove_filter( 'wp_mail_from_name','church_admin_from_name' );
		remove_filter( 'wp_mail_from', 'church_admin_from_email');
    }
}


function church_admin_excerpt( $string,$length,$end='...')
{
    $string = strip_tags( $string);

    if (strlen( $string) > $length) {

        // truncate string
        $stringCut = substr( $string, 0, $length);

        // make sure it ends in a word so assassinate doesn't become ass...
        $string = substr( $stringCut, 0, strrpos( $stringCut, ' ') ).$end;
    }
    return $string;
}


function church_admin_gz( $source, $level = 9)  { 
    $dest = $source . '.gz'; 
    $mode = 'wb' . $level; 
    $error = false; 
    if ( $fp_out = gzopen( $dest, $mode) ) { 
        if ( $fp_in = fopen( $source,'rb') ) { 
            while (!feof( $fp_in) ) 
                gzwrite( $fp_out, fread( $fp_in, 1024 * 512) ); 
            fclose( $fp_in); 
        } else {
            $error = true; 
        }
        gzclose( $fp_out); 
    } else {
        $error = true; 
    }
    if ( $error)
        return false; 
    else
        return $dest; 
} 

if(!function_exists('array_to_object') ) {
  function array_to_object( $array = array() ) {
    if (!empty( $array) ) {
        $data = false;
        foreach ( $array as $akey => $aval) {
            $data -> {$akey} = $aval;
        }
        return $data;
    }
    return false;
}

}

/*****************************************************
*
* Returns 1st two adults in household
*
*****************************************************/
function church_admin_household_title( $household_id)
{
    global $wpdb;
    if ( empty( $household_id) )return NULL;
    $adults=$wpdb->get_results('SELECT * FROM '.CA_PEO_TBL.' WHERE people_type_id=1 AND household_id="'.(int)$household_id.'" ORDER BY head_of_household DESC LIMIT 2');
    if ( empty( $adults) )return NULL;
    $names=$title=array();
    foreach( $adults AS $row)
    {
        $fullLastName=implode(" ",array_filter(array( $row->prefix,$row->last_name) ));
        $names[$fullLastName][]=$row->first_name;
    }
    if ( empty( $names) )return NULL;
    foreach( $names AS $lastName=>$firstNames)
    {
        $title[]=implode(" & ",$names[$lastName] ).' '.$lastName;
    }
    return implode(" & ",$title);
}

/*****************************************************
*
* Warnings if homeurl and siteurl will cause app issues
*
*****************************************************/
function church_admin_url_check( $echo=TRUE)
{
    global $wpdb;
    // check if changed on wp-config with WP_HOME and WP_SITEURL constants but this would be triggered everytime while the constant is defined on wp-config
    $message='';
    if ( defined('WP_HOME') && '' != WP_HOME ) {
        
        $row = $wpdb->get_row( $wpdb->prepare( "SELECT option_value FROM $wpdb->options WHERE option_name = %s LIMIT 1", 'home' ) );
        $home = $row->option_value;
        if(WP_HOME!=$home)
        {
            
            $message='<h2  style="color:red">'.__('Homepage URL issue','church-admin').'</h2><p>'.__('You have a hard-coded value of the site homepage that is different from the setting in Dashboard>Settings>General','church-admin').'</p>';
            $message.='<p>'.sprintf(__('WP_HOME is %1$s','church-admin'),esc_url(WP_HOME) ).'</p>';
            $message.='<p>'.sprintf(__('Settings value is %1$s','church-admin'),esc_url( $home) ).'</p>';
        }
        
    }

    if ( defined('WP_SITEURL') && '' != WP_SITEURL ) {
        $row = $wpdb->get_row( $wpdb->prepare( "SELECT option_value FROM $wpdb->options WHERE option_name = %s LIMIT 1", 'siteurl' ) );
        $siteurl = $row->option_value;
        if(WP_SITEURL!=$siteurl)
        {
            $message.='<h2 style="color:red">'.__('Site URL issue','church-admin').'</h2><p>'.__('You have a hard-coded value of the site url that is different from the setting in Dashboard>Settings>General','church-admin').'</p>';
            $message.='<p>'.sprintf(__('WP_SITEURL is %1$s','church-admin'),esc_url(WP_SITEURL) ).'</p>';
            $message.='<p>'.sprintf(__('Settings value is %1$s','church-admin'),esc_url( $siteurl) ).'</p>';
        }
        
       
    }
    if(!church_admin_maybe_is_ssl() )$message.='<h2 style="color:red">'.__('SSL issue','church-admin').'</h2><p>'.__('The value in Dashboard>Settings>General Site Address must be https for the app to work on iOS and Android devices','church-admin').'</p>';
    $message.='<p>'.sprintf(__('Site URL is %1$s','church-admin'),esc_url(site_url() )).'</p>';
    
   
    if ( empty( $echo) )  {echo $message;}else{return $message;}
}

function church_admin_maybe_is_ssl() {
    // cloudflare
    if ( ! empty( $_SERVER['HTTP_CF_VISITOR'] ) ) {
        $cfo = json_decode( $_SERVER['HTTP_CF_VISITOR'] );
        if ( isset( $cfo->scheme ) && 'https' === $cfo->scheme ) {
            return true;
        }
    }
 
    // other proxy
    if ( ! empty( $_SERVER['HTTP_X_FORWARDED_PROTO'] ) && 'https' === $_SERVER['HTTP_X_FORWARDED_PROTO'] ) {
        return true;
    }
 
    return function_exists( 'is_ssl' ) ? is_ssl() : false;
}

function church_admin_first_step( $id=0)
{

    $out='<div id="ca-first-step'.(int)$id.'">';
               
    $out.='<div class="church-admin-form-group"><label>'.__('Please start with your email address','church-admin').'</label>';
    $out.='<input type="email" id="ca-email-address'.(int)$id.'" class="church-admin-form-control"></div><p><button id="ca-next-step'.(int)$id.'" class="btn btn-success">'.__("Next &raquo;",'church-admin').'</button></p></div>';
    
    $out.='<div id="ca-login'.(int)$id.'" style="display:none">';
    $out.='<p>'.__('It looks like you are already registed, please login to continue','church-admin').'</p>';
    $out.=wp_login_form(array('echo'=>FALSE) );
    $out.='<a href="'.esc_url( wp_lostpassword_url( get_permalink() ) ).'" alt="'.__( 'Lost Password', 'church-admin' ).'">'.__( "I've forgotten my password", 'church-admin' ).'</a></p></div>';
    $out.='<script type="text/javascript">jQuery(function( $)  {  
       
        $("#ca-next-step'.(int)$id.'").click(function()  {
        console.log("clicked '.(int)$id.'");
            var email=$("#ca-email-address'.(int)$id.'").val();
            $("#ca-email-address'.(int)$id.'").val(email);
            var id="'.(int)$id.'";
            var nonce="'.wp_create_nonce('email-checker').'";
            console.log(email);
            var args = {"action": "church_admin","method": "email-checker","email": email,"nonce":nonce,"id":id};
            console.log(args);
            $.getJSON({
                url: ajaxurl,
                type: "post",
                data:  args,
                success: function(response) {
                    console.log(response);
                    if(response.found)
                    {
                        console.log("login");
                        $("#form'.(int)$id.'").hide();
                        $("#ca-login'.(int)$id.'").show();
                        $("#ca-first-step'.(int)$id.'").hide();
                    }
                    else
                    {
                        $("#form'.(int)$id.'").show();
                        $(".funky-bit").val(response.nonce);
                        $(".ca-email").val(response.email);
                        $("#ca-login'.(int)$id.'").hide();
                        $("#ca-first-step'.(int)$id.'").hide();
                        
                    }
                    
                }
            });
        });
        });</script>'."\r\n";

    return $out;

}
function church_admin_formatted_name_from_user( $userID)
{
    global $wpdb;
    $person=$wpdb->get_row('SELECT * FROM '.CA_PEO_TBL.' WHERE user_id="'.(int)$userID.'"');
    if( $person) return church_admin_formatted_name( $person);
    else return NULL;
}
function church_admin_formatted_name( $person)
{
    if ( empty( $person) )return;
    return implode(" ",array_filter(array( $person->first_name,$person->prefix,$person->last_name) ));
}


function church_admin_mobile_menu()
{
    global $church_admin_url,$church_admin_menu;
    $modules=get_option('church_admin_modules');
    ////church_admin_debug(print_r( $church_admin_menu,TRUE) );
    $parent='people';
    $out='<form action="admin.php" method="GET" id="church-admin-mobile-menu"><input type="hidden" name="page" value="church_admin/index.php"/><select name="action" class="church-mobile-menu-action">';
    if ( empty( $_GET['action'] ) )  {$out.='<option>'.__('Church Admin Menu','church-admin').'</option>';}
    $out.='<optgroup label="'.__('People','church-admin').'">';
    foreach( $church_admin_menu AS $menuID=>$menuItem)    
    {

        $modules['Settings']=TRUE;
        $modules['App']=TRUE;
        if( $menuItem['parent']!=$parent)
        {
            //is a parent so add an optgroup
            $out.='</optgroup><optgroup label="'.esc_html( $menuItem['title'] ).'">';
        }
        if(!empty( $modules[$menuItem['module']] )&& church_admin_level_check( $menuItem['level'] ) )
        {
        if(!empty( $_GET['action'] ) )  {$action=$_GET['action'];}else{$action='';}
           $out.='<option value="'.esc_html( $menuID).'" '.selected( $menuID,$action,FALSE).'>'.esc_html( $menuItem['title'] ).'</option>';           
            
        }
        $parent=$menuItem['parent'];
    }
    $out.='<optgroup></select>';
    $out.='</form><script> jQuery(document).ready(function( $)  {

            $(".church-mobile-menu-action").change(function()  {
                console.log("Submit");
                var form=$("form#church-admin-mobile-menu").serialize();
                console.log(form)
                var url="admin.php?"+ form;
                console.log(url);
                window.location.href = url
            })
        });</script>';
    return $out;
}


function church_admin_check_user_in_directory()
{
    
    global $wpdb,$church_admin_version;
    $user=wp_get_current_user();
    //perform check user is in directory
    $warning='';
    $person=$wpdb->get_row('SELECT * FROM '.CA_PEO_TBL.' WHERE email="'.esc_sql( $user->user_email).'" OR user_id="'.(int)$user->ID.'"');
    if(!empty( $person) )
    {
        if ( empty( $person->user_id) )
        {
            $wpdb->query('UPDATE '.CA_PEO_TBL.' SET user_id="'.(int)$user->ID.'" WHERE people_id="'.(int)$person->people_id.'"');
            $warning=sprintf(__('Your user login email %1$s was not connected to a directory entry, so the plugin connected you to %2$s','church-admin'),$user->user_email,'<a href="'.wp_nonce_url('admin.php?page=church_admin/index.php&amp;action=edit_people&amp;people_id='.(int)$person->people_id,'edit_people').'">'.implode(" ",array_filter(array( $person->first_name,$person->prefix,$person->last_name) )).'</a>');
        }
    }else
    {
        if(!empty( $user->first_name) )  {$first_name=esc_sql( $user->first_name);}else{$first_name='Admin';}
        if(!empty( $user->last_name) )  {$last_name=esc_sql( $user->last_name);}else{$last_name='User';}
        $email=$user->user_email;
        $wpdb->query('INSERT INTO '.CA_HOU_TBL.'(address)VALUES("")');
        $household_id=$wpdb->insert_id;
        $wpdb->query('INSERT INTO '.CA_PEO_TBL.' (first_name,last_name,email,household_id,show_me,user_id,head_of_household,sex,people_type_id,gdpr_reason)VALUES("'.$first_name.'","'.$last_name.'","'.$email.'","'.(int)$household_id.'","0","'.(int)$user->ID.'",1,1,1,"'.__('Created from current user account').'")');
        $people_id=$wpdb->insert_id;
        $warning=sprintf(__('Your user login email %1$s was not in the directory, so the plugin created an entry for you - %2$s','church-admin'),$user->user_email,'<a class="button-primary" href="'.wp_nonce_url('admin.php?page=church_admin/index.php&amp;action=edit_people&amp;people_id='.(int)$people_id,'edit_people').'">'.__('Edit your entry').'</a>');
     
        
    
    }
}
function church_admin_title()
{
   if(!church_admin_level_check('Directory') ) return;
    global $wpdb,$church_admin_version;
    $licence=get_option('church_admin_app_new_licence');
    if(!empty( $licence) )  {$title='Church Admin Premium Plugin';}
    else $title='Church Admin Plugin';
    echo'<h1 class="church-admin-title"><a title="'.__('Back to menu').'" href="'.admin_url().'admin.php?page=church_admin/index.php"><span class="dashicons dashicons-menu-alt3" style="text-decoration:none;"></span></a> '.$title.' v'.$church_admin_version.'</h1>';
    /*echo '<div style="flex-basis: 100%"><script type="text/javascript" src="https://storage.ko-fi.com/cdn/widget/Widget_2.js"></script><script>kofiwidget2.init("Support the Church Admin plugin with a Kofi!", "#69db7c", "Z8Z3IRVTU");kofiwidget2.draw();</script></div>';
    */
}
function church_admin_classic_header()
{
    global $wpdb,$church_admin_version;
    
    
    //header &mailchimp signup
    echo'<div class="church-admin-content">';
    echo'<div id="church-admin-header">';
    church_admin_title();
    church_admin_change_look();
    church_admin_search_form();
    if(!empty( $warning) )
    {
       echo'<div class="notice notice-error inline"><h2>'.__('Your account','church-admin').'</h2><p>'.$warning.'</p></div>';
    }
    if(isset( $_GET['action'] ) )  {$action=esc_html( $_GET['action'] );}else $action='default';
    if(!empty( $_GET['section'] ) && $_GET['section']!='favourites')echo'<p><button class="button-secondary" id="add-to-favourites">'.__('Add this page to favourites menu','church-admin').'</button></p>'; 
    echo'<div class="church_admin_help"><div class="ca-show-help"><p><button class="button-primary ca-helper" data-action="'.$action.'">'.__('Show help for this page','church-admin').'</button></p></div></div><!-- END helper-->
    <script>
    jQuery(document).ready(function( $)  {
        $("body").on("click",".ca-hide-help",function(e)
        {
            console.log("hide help");
            e.preventDefault();
            
            $(".ca-show-help").hide();
        });

        $("body").on("click",".ca-helper",function(e)
        {
            e.preventDefault();
            var which=$(this).data("action");
            console.log("which: "+ which);
            var data = {"action":"church_admin","method": "show-help","which": which};
            console.log(data);
            var request=$.ajax({
                url: ajaxurl,
                type: "post",
                data:  data
            })
            request.error(function()  {console.log("theres an error with AJAX");} );
            request.success(function(response) { $(".ca-show-help").html(response);})
                
        });
    });
    </script>';
    
    
    echo'</div><!-- END .church-admin-header -->';
    
   
    
}

function church_admin_module_dropdown( $module)
{
    global $church_admin_menu;
   
    //create array for dropdowns for each parent
    $parentArray=array();
    foreach( $church_admin_menu AS $name=>$item)
    {
        $item['action']=$name;
        $parentArray[$item['parent']][]=$item;
        

    }
     //dropdown menu
     echo'<p><select class="church-admin-menu-action" name="action" onchange="churchAdminGoTo(this.value)" >';
     echo'<option>'.__('Section menu','church-admin').'</option>';
     foreach( $parentArray[$module] AS $chItem)
     {
         echo'<option value="'.esc_html( $chItem['action'] ).'">'.esc_html( $chItem['title'] ).'</option>';
     }
     echo'</select></p>';
     echo'<script>
     function churchAdminGoTo(val)
     {
             window.location.href="'.admin_url().'admin.php?page=church_admin/index.php&action="+val;
     }  
 </script>';

   
   

}

/**********************************************************
*   Output boxes to main front admin page
***********************************************************/  
function church_admin_boxes_look()
{
    global $church_admin_menu;
    $modules=get_option('church_admin_modules');
    $modules['Settings']=1;//Setting always visible to users with permission
    $modules['App']=1;
    
    church_admin_title();
    //church_admin_change_look();
   
    church_admin_mailchimp_warning_box();
    if( !empty( $modules['Support'] ) ){ 
        church_admin_manual_advert();
    }
    church_admin_new_look_gdpr();


    //create array for dropdowns for each parent
    $parentArray=array();
    foreach( $church_admin_menu AS $name=>$item)
    {
        $item['action']=$name;
        $parentArray[$item['parent']][]=$item;
        
    }
   
 
    foreach( $church_admin_menu AS $name=>$item)
    {
        if( $item['parent']==$name && !empty( $modules[$item['module']] ) )
        {
            echo '<div class="ca-boxes" id="'.esc_html( $name).'">';
            echo    '<div class="ca-boxes-header '.$item['background'].'">'."\r\n";
            echo '<p>'.$item['font-awesome'].'</p>'."\r\n";
            echo'<h3>'.$item['title'].'</h3>'."\r\n";
            echo'</div>'."\r\n";
            echo '<div class="ca-boxes-content">';
            if(church_admin_level_check( $item['level'] ) )
            {
                if(count( $parentArray[$name] )>1)
                {
                    church_admin_module_dropdown( $name);
                }else
                {
                    echo'<p><a class="button-primary" href="'.admin_url().'admin.php?page=church_admin/index.php&action='.esc_html( $name).'">'.esc_html( $item['title'] ).'</a></p>';
                }
                if(is_callable( $item['callback'] ) )call_user_func( $item['callback'] );
            }
            else{echo'<p>'.__("You don't have permissions for this section",'church-admin').'</p>';}
            echo'</div></div>';
        }
    }
    echo "\r\n";
    echo'<script>
            jQuery(document).ready(function( $)  {
                $(".church-admin-menu-action").change(function()  {
                    var action=$(this).val();
                    console.log(action);
                    window.location.href="'.admin_url().'admin.php?page=church_admin/index.php&action="+action;
                });
                $(".ca-toggle").click(function()
                {
                    var toggle=$(this).attr("id");
                    $("."+toggle).toggle()
                });
            });
    </script>';
    
}
/**********************************************************
*   Switcher for look
***********************************************************/  
function church_admin_change_look()
{
    if(!church_admin_level_check('Directory') ) return;
    global $church_admin_url,$church_admin_menu;
    $user=wp_get_current_user();
    $frontpage=get_option('church-admin-frontpage-look'.$user->ID);
    echo'<div class="church-admin-change-look"><form action="" method="post"><p>';
    switch( $frontpage)
    {
        case'classic':default: echo'<input type="hidden" name="change-look" value="boxes"/><input class="button-primary" type="submit" value="'.__('Switch to new style','church-admin').'"/>';break;
        case'boxes': echo'<input type="hidden" name="change-look" value="classic"/><input class="button-secondary" type="submit" value="'.__('Switch to classic style','church-admin').'"/>';break;
    }
    echo'</p></form><div id="church-admin-signup"><form action="//thegatewaychurch.us2.list-manage.com/subscribe/post?u=de873ad10bb6b43b54744b951&amp;id=848214cef0" method="post" id="mc-embedded-subscribe-form" name="mc-embedded-subscribe-form" class="validate" target="_blank" novalidate><div id="mc_embed_signup_scroll"><strong>'.__('Sign up for news and free PDF manual','church-admin').'</strong>';
    if(!empty( $user->user_firstname) )echo'<input type="hidden" name="FNAME" value="'.esc_html( $user->user_firstname).'"/>';
    if(!empty( $user->user_lastname) )echo'<input type="hidden" name="LNAME" value="'.esc_html( $user->user_lastname).'"/>';
    echo'<input type="email" value="" name="EMAIL" class="email" id="mce-EMAIL" placeholder="'.__('Email address','church-admin').'" required><!-- real people should not fill this in and expect good things - do not remove this or risk form bot signups--><div style="position: absolute; left: -5000px;" aria-hidden="true"><input type="text" name="b_de873ad10bb6b43b54744b951_848214cef0" tabindex="-1" value=""></div><input type="submit" value="'.__('News sign up','church-admin').'" name="subscribe" id="mc-embedded-subscribe" class="button-primary"></div></form></div></div>';
 
    
}

/**********************************************************
*   Front End email check
***********************************************************/                   
function church_admin_front_end_email_check()
{
    global $wpdb;
    if(!empty( $_POST['ca-email'] ) )$email=stripslashes( $_POST['ca-email'] );
    if(!empty( $_POST['email'] ) )$email=stripslashes( $_POST['email'] );
    if ( empty( $email) )return FALSE;
    if(!is_email( $email) ) return FALSE;
    $people_id=$wpdb->get_var('SELECT people_id FROM '.CA_PEO_TBL.' WHERE email="'.esc_sql( $email).'"');
    if( $people_id)  {return TRUE;}else{return FALSE;}
}

function church_admin_app_purchase()
{
    echo'<p>Unlock the app and online giving now, for a one-off payment of <strong><span class="sign">USD $</span><span class="cost">99</span></strong> &#8211; you can change the currency below.</p><form action="https://www.paypal.com/cgi-bin/webscr" method="post"><input name="cmd" type="hidden" value="_xclick"> <input name="item_name" type="hidden" value="Church Admin Premium Version"> <input type="hidden" name="return" value="https://www.churchadminplugin.com/premium-paid-page"><input type="hidden" name="rm" value="2/"><input name="notify_url" type="hidden" value="https://www.churchadminplugin.com/wp-admin/admin-ajax.php?action=church_admin_frontpage_app_ipn">
        <input name="business" type="hidden" value="support@churchadminplugin.com"> <input type="hidden" name="amount" class="price" value="99">
       <div class="form-group"><select class="currency_code" name="currency_code"><option class="USD" value="USD">US Dollar $99</option><option class="GBP" value="GBP">GB Pound Sterling £85</option><option value="EUR">Euro €100</option><option value="AUD">Australian Dollar $150</option><option value="BRL">Brazilian Real 550</option><option class="CAD" value="CAD">Canadian Dollar $130</option><option class="MXN" value="MXN">Mexican Peso 2090</option> <option class="CHF" value="CHF">Swiss Franc 95</option></select></div><input class="btn btn-danger button-primary" type="submit" value="Buy now with debit/credit card"></form><p></p><script>
               jQuery( document ).ready(function( $) {
                   console.log( "ready!" );
               $("#bank-payment").click(function()  {$(".bank-payment").toggle();});
                   $(".currency_code").change(sortPrice);
                   
                   
                   function sortPrice()  {
                       var currency_code=$(".currency_code").val();
                       
                    
                       var price=99;
                       
                       var sign="&pound;";
                       console.log(currency_code)
                       switch(currency_code)
                       {
                           default:case "GBP":price=85;sign="GBP &pound;";break;	
                           case "AUD":price=150;sign="AUD &dollar;";break;
                           case "MXN":price=2090;sign="MXN Peso ";break;
                           case "BRL":price=550;sign="BRL Real ";break;
                           case "CAD":price=130;sign="CAD &dollar;";break;
                           case "USD":price=99;sign="USD &dollar;";break;
                           case"EUR":price=100;sign="EU &euro;";break;
                           case "CHF":price=95;sign="CHF";break;
                           
                       }
                       
                       $(".sign").html(sign);
                       var formattedPrice =parseFloat(Math.round(price * 100) / 100).toFixed(2);
                       $(".cost").html(formattedPrice);
                       $(".price").val(formattedPrice);
                       $("."+currency_code).attr("selected","selected")
                       
                   };
                   
               });</script>';
}


function church_admin_app_graph()
{
    return;
    //deprecated
    global $wpdb;
    $pages=$wpdb->get_results('SELECT DISTINCT app_page FROM '.CA_APV_TBL.' WHERE app_page!="" ORDER BY app_page');
    if(!empty( $pages) )
    {
        echo'<h3>'.__("App usage graph",'church-admin').'</h3>';
        echo'<form action="'.admin_url().'admin.php?page=church_admin/index.php#app" method="POST"><p><select name="app_page">';
        if(!empty( $_POST['app_page'] ) )
        {
            echo'<option value="'.esc_html( $_POST['app_page'] ).'">'.esc_html( $_POST['app_page'] ).'</option>';
        }
        foreach( $pages AS $page)echo'<option value="'.esc_html( $page->app_page).'">'.esc_html( $page->app_page).'</option>';
        echo'</select><select name="year">';
        if(!empty( $_POST['year'] ) )
        {
            echo'<option value="'.intval( $_POST['year'] ).'">'.intval( $_POST['year'] ).'</option>';
        }
        for ( $year=date('Y'); $year>=date('Y')-5; $year--)
        {
            echo'<option value="'.intval( $year).'">'.intval( $year).'</option>';
        }
        echo'</select>';
        echo'<input type="submit" class="button-primary"   value="'.__('Show','church-admin').'"/></p></form>';
        $data=$columns=array();

        $sql='SELECT visit_date FROM '.CA_APV_TBL.' WHERE YEAR(visit_date)="'.date('Y').'" GROUP BY visit_date ORDER BY visit_date';
        $dates=$wpdb->get_results( $sql);
        if ( empty( $_POST['app_page'] ) )
        {
            $_POST['app_page']='Home';
            $_POST['year']=date('Y');
        }
        foreach( $dates AS $date)
        {
            $row=array();

                $sql='SELECT visits  FROM '.CA_APV_TBL.' WHERE visit_date="'.esc_sql( $date->visit_date).'" AND app_page="'.esc_sql( $_POST['app_page'] ).'"';
                ////church_admin_debug( $sql);
                $appPageCount=$wpdb->get_var( $sql);
                ////church_admin_debug( $date->visit_date.' '.$appPageCount);
                if(!empty( $appPageCount) )  {$row[]=intval( $appPageCount);}else{$row[]=0;}


           array_unshift( $row,mysql2date(get_option('date_format'),$date->visit_date) );
            $data[]=$row;
        }

            $addRows=json_encode(array('Date',esc_html( $_POST['app_page'] ) )).",\r\n";
            foreach ( $data AS $key=>$value)
            {
                $addRows.=json_encode( $value).",\r\n";
            }



            //var_dump( $data);
            $out='
        <script type="text/javascript">
          google.charts.load("current", {"packages":["corechart"]});
          google.charts.setOnLoadCallback(drawChart);

          function drawChart() {
            var data = google.visualization.arrayToDataTable([
                '.$addRows.'
                 ] );

            var options = {
              title: "'.__('App visits','church-admin').' - '.esc_html( $_POST['app_page'] ) .'",

              legend: { position: "bottom" }
            };

            var chart = new google.visualization.LineChart(document.getElementById("app_graph") );

            chart.draw(data, options);
          }</script>';
                $out.='<div id="app_graph" style="width:100%;height:200px;"></div>';
            echo $out;
    }
}


function church_admin_actions()
{
    global $wpdb;
    //allow people to edit their own entry
    //if(!is_user_logged_in() )exit( __('You must be logged in','church-admin') );
    //if(!is_admin() )exit( __('You must be logged in','church-admin') );
	$self_edit=FALSE;
	$user_id=get_current_user_id();
	if(!empty( $_GET['household_id'] ) )$check=$wpdb->get_var('SELECT user_id FROM '.CA_PEO_TBL.' WHERE user_id="'.esc_sql( $user_id).'" AND household_id="'.esc_sql( $_GET['household_id'] ).'"');
	if(!empty( $check) && $check==$user_id)$self_edit=TRUE;
	$user_id=!empty( $_GET['user_id'] )?sanitize_text_field($_GET['user_id']):NULL;
	$id=isset( $_GET['id'] )?sanitize_text_field($_GET['id']):0;
    $fund_id=isset( $_GET['fund_id'] )?sanitize_text_field($_GET['fund_id']):NULL;
    $gift_id=isset( $_GET['gift_id'] )?sanitize_text_field($_GET['gift_id']):NULL;
    $giving_id=isset( $_GET['giving_id'] )?sanitize_text_field($_GET['giving_id']):NULL;
	$mtg_type=!empty( $_GET['mtg_type'] )?sanitize_text_field($_GET['mtg_type']):'service';
	$rota_date=!empty( $_GET['rota_date'] )?sanitize_text_field($_GET['rota_date']):NULL;
    $date=!empty( $_GET['date'] )?sanitize_text_field($_GET['date']):NULL;
	$rota_id=!empty( $_GET['rota_id'] )?sanitize_text_field($_GET['rota_id']):NULL;
	$copy_id=!empty( $_GET['copy_id'] )?sanitize_text_field($_GET['copy_id']):NULL;
    $date_id=!empty( $_GET['date_id'] )?sanitize_text_field($_GET['date_id']):NULL;
    $event_id=!empty( $_GET['event_id'] )?sanitize_text_field($_GET['event_id']):NULL;
	$email_id=!empty( $_GET['email_id'] )?sanitize_text_field($_GET['email_id']):NULL;
    $people_id=!empty( $_GET['people_id'] )?sanitize_text_field($_GET['people_id']):NULL;
    $household_id=!empty( $_GET['household_id'] )?sanitize_text_field($_GET['household_id']):NULL;
    $service_id=!empty( $_REQUEST['service_id'] )?sanitize_text_field($_REQUEST['service_id']):NULL;
    $mtg_type=!empty( $_REQUEST['mtg_type'] )?sanitize_text_field($_REQUEST['mtg_type']):'service';
    $site_id=!empty( $_REQUEST['site_id'] )?sanitize_text_field($_REQUEST['site_id']):NULL;
    $attendance_id=!empty( $_GET['attendance_id'] )?sanitize_text_field($_GET['attendance_id']):NULL;
	$ministry_id=!empty( $_GET['ministry_id'] )?sanitize_text_field($_GET['ministry_id']):NULL;
    $ID=!empty( $_GET['ID'] )?sanitize_text_field($_GET['ID']):NULL;
    $meeting=!empty($_GET['meeting'])?sanitize_text_field($_GET['meeting']):NULL;
    $unit_id=!empty( $_GET['unit_id'] )?sanitize_text_field($_GET['unit_id']):NULL;
    $subunit_id=!empty( $_GET['subunit_id'] )?sanitize_text_field($_GET['subunit_id']):NULL;
    $funnel_id=!empty( $_GET['funnel_id'] )?sanitize_text_field($_GET['funnel_id']):NULL;
    $ticket_id=!empty( $_GET['ticket_id'] )?sanitize_text_field($_GET['ticket_id']):NULL;
    $booking_ref=!empty( $_GET['booking_ref'] )?sanitize_text_field($_GET['booking_ref']):NULL;
    $people_type_id=isset( $_GET['people_type_id'] )?sanitize_text_field($_GET['people_type_id']):NULL;
    $member_type_id=isset( $_REQUEST['member_type_id'] )?sanitize_text_field($_REQUEST['member_type_id']):NULL;
	$facilities_id=isset( $_REQUEST['facilities_id'] )?sanitize_text_field($_REQUEST['facilities_id']):NULL;
    $edit_type=!empty( $_REQUEST['edit_type'] )?sanitize_text_field($_REQUEST['edit_type']):'single';
    $file=!empty( $_GET['file'] )?sanitize_text_field($_GET['file']):NULL;
    $app_date=!empty( $_GET['app_date'] )?sanitize_text_field($_GET['app_date']):date('Y-m-d');
	$smallgroup_id=!empty( $_GET['smallgroup_id'] )?sanitize_text_field($_GET['smallgroup_id']):NULL;
    $message=!empty( $_GET['message'] )?sanitize_text_field($_GET['message']):NULL;
    if(!empty( $_REQUEST['church_admin_search'] ) )  {
        if(church_admin_level_check('Directory') )  {
        require_once(plugin_dir_path(dirname(__FILE__) ).'includes/directory.php');
        church_admin_search( $_REQUEST['church_admin_search'] );
        }
    }
	elseif(isset( $_GET['action'] ) )
    {
        switch( $_GET['action'] )
        {
            case 'inventory':
                require_once(plugin_dir_path(dirname(__FILE__) ).'includes/inventory.php');
                echo church_admin_inventory_list();
            break;
            case 'edit-inventory':
                require_once(plugin_dir_path(dirname(__FILE__) ).'includes/inventory.php');
                echo church_admin_edit_inventory($id);
            break;
            case 'delete-inventory':
                require_once(plugin_dir_path(dirname(__FILE__) ).'includes/inventory.php');
                echo church_admin_delete_inventory($id);
            break;
            case 'bulk-bible-readings':
                require_once(plugin_dir_path(dirname(__FILE__) ).'includes/bible-readings.php');
                church_admin_bible_reading_bulk_post();
            break;
            case'resend-bible-reading':
                $ID=(int)$_GET['ID'];
                $post=get_post( $ID);
                if( $post)church_admin_mailchimp_post_send( $post);
                echo'<p>'.__('Bible reading resent','church-admin').'</p>';
            break;
            case 'merge-people':
                if(church_admin_level_check('Directory') )
                {
                    require_once(plugin_dir_path(dirname(__FILE__) ).'includes/directory.php');
                    echo church_admin_merge_people( $_GET['people_id1'],$_GET['people_id2'] );
                }else{
                    echo'<div class="error"><p>'.__("You don't have permissions",'church-admin').'</p></div>';
                }
            break;    
            case 'approve-facility-booking':
                if(church_admin_level_check('Calendar') )
                {
                    require_once(plugin_dir_path(dirname(__FILE__) ).'includes/facilities.php');
                    echo church_admin_approve_facility_booking( $booking_id);
                }else{
                    echo'<div class="error"><p>'.__("You don't have permissions",'church-admin').'</p></div>';
                }
            break;
            case 'decline-facility-booking':
                if(church_admin_level_check('Calendar') )
                {
                    require_once(plugin_dir_path(dirname(__FILE__) ).'includes/facilities.php');
                    echo church_admin_decline_facility_booking( $booking_id);
                }else{
                    echo'<div class="error"><p>'.__("You don't have permissions",'church-admin').'</p></div>';
                }
            break;
            case 'spiritual-gifts':
                echo'<p>'.__('Use the shortcode [church_admin type="spiritual-gifts"] for people to fill in the questionnaire','church-admin').'</p>';
                require_once(plugin_dir_path(dirname(__FILE__) ).'includes/spiritual-gifts.php');
                church_admin_spiritual_gifts_list();
                
            break;
            case 'photo-permissions':
                if(church_admin_level_check('Directory') )
                {
                    require_once(plugin_dir_path(dirname(__FILE__) ).'includes/photo-permissions.php');
                    echo church_admin_photo_list( $member_type_id);
                }else{
                    echo'<div class="error"><p>'.__("You don't have permissions",'church-admin').'</p></div>';
                }
            break;
            case 'gender-update':
                if(current_user_can('manage_options') )
                {
                    $genders=explode(",",$_GET['genders'] );
                    update_option('church_admin_gender',$genders);
                    echo '<div class="notice notice-success inline"><h2>Genders updated</h2></div>';
                }
            break;
            case 'delete_cell':
                require_once(plugin_dir_path(dirname(__FILE__) ).'includes/small_groups.php');church_admin_delete_cell( $ID);break;
           
            case 'reset_readings':$wpdb->query('UPDATE '.CA_BRP_TBL.' SET passages=""');echo'Done ;-)';break;
            case 'test_email':
            case 'test-email':
            case 'testemail':
                require_once(plugin_dir_path(dirname(__FILE__) ).'includes/email.php');
                if(!empty( $_POST['test-email'] )&& is_email(stripslashes( $_POST['test-email'] ) ))
                {
                    $email=stripslashes( $_POST['test-email'] );
                    
                }
                else
                {
                    $email=NULL;
                }
                church_admin_test_email( $email);
            break;


            //main menu sections
            case 'single-gdpr-email':
                
                if(church_admin_level_check('Directory') )
                {
                    require_once(plugin_dir_path(dirname(__FILE__) ).'includes/directory.php');
                    if(!empty( $_GET['people_id'] ) )
                    {
                        $row=$wpdb->get_row('SELECT * FROM '.CA_PEO_TBL.' WHERE people_id="'.(int)$_GET['people_id'].'"');
                        if(!empty( $row) )church_admin_gdpr_email_send( $row,TRUE);
                    }
                    
                }
            break;
            
            case 'gdpr-email': if(church_admin_level_check('Directory') )  {require_once(plugin_dir_path(dirname(__FILE__) ).'includes/directory.php');church_admin_gdpr_email();}break;
            case 'gdpr-email-test': if(church_admin_level_check('Directory') )  {require_once(plugin_dir_path(dirname(__FILE__) ).'includes/directory.php');church_admin_gdpr_email_test();}break;

            case'shortcodes':church_admin_shortcodes_list();break;

            case'small_groups':if(church_admin_level_check('Small Groups') )  { echo church_admin_smallgroups_main();}else{echo'<div class="error"><p>'.__("You don't have permissions",'church-admin').'</p></div>';}break;


            case'ministries':
                if(church_admin_level_check('Directory') )
                {   
                    require_once(plugin_dir_path(dirname(__FILE__) ).'includes/departments.php');
                    church_admin_ministries_list();
                    
                }
                else
                {
                    echo'<div class="error"><p>'.__("You don't have permissions",'church-admin').'</p></div>';
                }
                break;
                
                
                
                
            
            case'children':
                if(!church_admin_level_check('Kidswork') )
                {
                    echo '<div class="notice notice-danger"><h2>'.sprintf(__('You need "%1$s" permissions to access this page','church-admin'),__('Kidswork','church-admin') ).'</h2></div>';
                    return;
                }
                church_admin_children();
            break;
            case'communication':if(church_admin_level_check('Prayer Chain') )  {church_admin_communication();}else{echo'<div class="error"><p>'.__("You don't have permissions",'church-admin').'</p></div>';}break;

            case'tracking':if(church_admin_level_check('Attendance') )  {church_admin_tracking();}else{echo'<div class="error"><p>'.__("You don't have permissions",'church-admin').'</p></div>';}break;
            
            //case 'settings':if(current_user_can('manage_options') )  {church_admin_settings_menu();}else{echo'<div class="error"><p>'.__("You don't have permissions",'church-admin').'</p></div>';}break;
            case 'calendar':
                if(!church_admin_level_check('Calendar') )
                {
                    echo '<div class="notice notice-danger"><h2>'.sprintf(__('You need "%1$s" permissions to access this page','church-admin'),__('Calendar','church-admin') ).'</h2></div>';
                    return;
                }
                church_admin_module_dropdown('calendar');
                require_once(plugin_dir_path(dirname(__FILE__) ).'includes/calendar.php');
                church_admin_new_calendar(time(),$facilities_id);
            break;
            
            case 'import-ics':
                if(!church_admin_level_check('Calendar') )
                {
                    echo '<div class="notice notice-danger"><h2>'.sprintf(__('You need "%1$s" permissions to access this page','church-admin'),__('Calendar','church-admin') ).'</h2></div>';
                    return;
                }
                church_admin_module_dropdown('calendar');
                require_once(plugin_dir_path(dirname(__FILE__) ).'includes/calendar.php');
                church_admin_import_ical();
            break;
          
            //csv import
            case'import-csv':
                if(church_admin_level_check('Directory') )
                {
                    
                    require_once(plugin_dir_path(dirname(__FILE__) ).'includes/directory.php');
                    church_admin_import_csv();
                }
            break;
            
            case'replicate-roles':
            case'replicate_roles':
                if(church_admin_level_check('Directory') )
                {
                    require_once(plugin_dir_path(dirname(__FILE__) ).'includes/directory.php');
                    church_admin_replicate_roles();
                }
            break;

            case 'edit_marital_status': if(church_admin_level_check('Directory') )
                                        {require_once(plugin_dir_path(dirname(__FILE__) ).'includes/settings.php');church_admin_edit_marital_status( $ID);}
            break;
            case 'delete_marital_status': if(church_admin_level_check('Directory') )
                                        {require_once(plugin_dir_path(dirname(__FILE__) ).'includes/settings.php');church_admin_delete_marital_status( $ID);}
            break;

            /*************************************
            *
            *		APP
            *
            **************************************/
            case 'logout_app':require_once(plugin_dir_path(dirname(__FILE__) ).'app/app-admin.php');church_admin_logout_app( $user_id);break;
            //case 'app_page':require_once(plugin_dir_path(dirname(__FILE__) ).'app/app-admin.php');church_admin_app_post();break;
            case 'app': 
                church_admin_module_dropdown('app');
                require_once(plugin_dir_path(dirname(__FILE__) ).'app/app-admin.php');
                church_admin_app();
            break;
            case 'reset-app-menu':
                church_admin_module_dropdown('app');
                delete_option('church_admin_app_new_menu');
                church_admin_app();
            break;
            //case 'delete_app_content':if(current_user_can('manage_options') )  {require_once(plugin_dir_path(dirname(__FILE__) ).'app/app-admin.php');church_admin_delete_current_app_content();}break;
            case 'app-settings':
                church_admin_module_dropdown('app');
                require_once(plugin_dir_path(dirname(__FILE__) ).'app/app-admin.php');
                church_admin_app_settings();
                church_admin_app_member_types();
            break;
            case 'app-menu':
                church_admin_module_dropdown('app');
                require_once(plugin_dir_path(dirname(__FILE__) ).'app/app-admin.php');
                church_admin_sortable_script();
                church_admin_app_menu();
            break;
            case 'bible-reading-plan':
                church_admin_module_dropdown('app');
                require_once(plugin_dir_path(dirname(__FILE__) ).'app/app-admin.php');
                church_admin_bible_reading_plan();
            break; 
            case 'app-cache-clear':
                delete_option('church_admin_modified_app_content');
                echo'<div class="notice notice-success"><p>'.esc_html(__('App cache cleared','church-admin')).'</p></div>';
                require_once(plugin_dir_path(dirname(__FILE__) ).'app/app-admin.php');
                church_admin_app_menu();
            break;
            case 'churchwide-my-prayer':
                church_admin_module_dropdown('app');
                require_once(plugin_dir_path(dirname(__FILE__) ).'app/app-setup.php');
                church_admin_churchwide_my_prayer();
            break;
            case 'app-member-types':
                church_admin_module_dropdown('app');
                require_once(plugin_dir_path(dirname(__FILE__) ).'app/app-admin.php');    
                church_admin_app_member_types();
            break;
            case 'app-logout':
                church_admin_module_dropdown('app');
                require_once(plugin_dir_path(dirname(__FILE__) ).'app/app-admin.php');    
                church_admin_logout_app_everyone();
            break;
            case 'app-logins':
            case 'app-users':
                require_once(plugin_dir_path(dirname(__FILE__) ).'app/app-admin.php');    
                church_admin_app_logins();
            break;
           
            /*************************************
            *
            *		ATTENDANCE
            *
            **************************************/
            
            case'show-attendance':
            case 'attendance':  
                if(!church_admin_level_check('Attendance') )
                {
                    echo '<div class="notice notice-danger"><h2>'.sprintf(__('You need "%1$s" permissions to access this page','church-admin'),__('Attendance','church-admin') ).'</h2></div>';
                    return;
                }
                echo'<h1>'.__('Attendance','church-admin').'</h1>';
                church_admin_module_dropdown('attendance');

                require_once(plugin_dir_path(dirname(__FILE__) ).'includes/attendance.php');
                church_admin_attendance_list($meeting);

                echo'<h2>'.__('Attendance graph','church-admin').'</h2>';
                require_once(plugin_dir_path(dirname(__FILE__) ).'display/graph.php');
                echo church_admin_graph( $type='weekly','S/1',date("Y-01-01"),date("Y-12-31"),900,500,TRUE);
                
                
            break; 
            case 'individual-attendance-list':
                if(!church_admin_level_check('Attendance') )
                {
                    echo '<div class="notice notice-danger"><h2>'.sprintf(__('You need "%1$s" permissions to access this page','church-admin'),__('Attendance','church-admin') ).'</h2></div>';
                    return;
                }    
                church_admin_module_dropdown('attendance'); 
                require_once(plugin_dir_path(dirname(__FILE__) ).'includes/individual_attendance.php');
                church_admin_individual_attendance_list();
            break;
            case 'individual-attendance-csv':
                if(!church_admin_level_check('Attendance') )
                {
                    echo '<div class="notice notice-danger"><h2>'.sprintf(__('You need "%1$s" permissions to access this page','church-admin'),__('Attendance','church-admin') ).'</h2></div>';
                    return;
                }   
                church_admin_module_dropdown('attendance'); 
                require_once(plugin_dir_path(dirname(__FILE__) ).'includes/individual_attendance.php');
                echo church_admin_individual_attendance_csv();
            
            break;
            case 'attendance-csv':
                if(!church_admin_level_check('Attendance') )
                {
                    echo '<div class="notice notice-danger"><h2>'.sprintf(__('You need "%1$s" permissions to access this page','church-admin'),__('Attendance','church-admin') ).'</h2></div>';
                    return;
                }   
                church_admin_module_dropdown('attendance');  
                require_once(plugin_dir_path(dirname(__FILE__) ).'includes/csv.php');
                echo church_admin_attendance_csv();
                
            break;
            case 'individual-attendance':
            case 'individual_attendance':
                if(!church_admin_level_check('Attendance') )
                {
                    echo '<div class="notice notice-danger"><h2>'.sprintf(__('You need "%1$s" permissions to access this page','church-admin'),__('Attendance','church-admin') ).'</h2></div>';
                    return;
                }
                church_admin_module_dropdown('attendance');
                require_once(plugin_dir_path(dirname(__FILE__) ).'includes/individual_attendance.php'); 
                echo church_admin_individual_attendance();
            break;
            case 'church_admin_attendance_metrics':
                if(!church_admin_level_check('Attendance') )
                {
                    echo '<div class="notice notice-danger"><h2>'.sprintf(__('You need "%1$s" permissions to access this page','church-admin'),__('Attendance','church-admin') ).'</h2></div>';
                    return;
                }
                church_admin_module_dropdown('attendance');
                require_once(plugin_dir_path(dirname(__FILE__) ).'includes/attendance.php');
                church_admin_attendance_metrics( $service_id);break;
            case 'church_admin_attendance_list':require_once(plugin_dir_path(dirname(__FILE__) ).'includes/attendance.php');church_admin_attendance_list( $service_id);break;
            case 'add-attendance':
            case 'edit_attendance':
                if(!church_admin_level_check('Attendance') )
                {
                    echo '<div class="notice notice-danger"><h2>'.sprintf(__('You need "%1$s" permissions to access this page','church-admin'),__('Attendance','church-admin') ).'</h2></div>';
                    return;
                }
                church_admin_module_dropdown('attendance');
                require_once(plugin_dir_path(dirname(__FILE__) ).'includes/attendance.php');
                church_admin_edit_attendance($attendance_id);
                
            break;
            case 'weeks-attendance':
                if(!church_admin_level_check('Attendance') )
                {
                    echo '<div class="notice notice-danger"><h2>'.sprintf(__('You need "%1$s" permissions to access this page','church-admin'),__('Attendance','church-admin') ).'</h2></div>';
                    return;
                }
                require_once(plugin_dir_path(dirname(__FILE__) ).'includes/attendance.php');church_admin_edit_this_weeks_attendance();
                
            break;
            case 'delete_attendance':
                if(!church_admin_level_check('Attendance') )
                {
                    echo '<div class="notice notice-danger"><h2>'.sprintf(__('You need "%1$s" permissions to access this page','church-admin'),__('Attendance','church-admin') ).'</h2></div>';
                    return;
                }
                church_admin_module_dropdown('attendance');
                require_once(plugin_dir_path(dirname(__FILE__) ).'includes/attendance.php');
                church_admin_delete_attendance( $attendance_id);
            break;


            /*************************************
            *
            *		CALENDAR
            *
            **************************************/
            case 'calendar':
            case 'church_admin_new_calendar':
            case 'new-calendar':
                if(!church_admin_level_check('Calendar') )
                {
                    echo '<div class="notice notice-danger"><h2>'.sprintf(__('You need "%1$s" permissions to access this page','church-admin'),__('Attendance','church-admin') ).'</h2></div>';
                    return;
                }
                church_admin_module_dropdown('calendar');
                require_once(plugin_dir_path(dirname(__FILE__) ).'includes/calendar.php');
                church_admin_new_calendar(time(),$facilities_id);
            break;
            case 'add-calendar':
            case 'church_admin_new_edit_calendar':
            case 'edit-calendar':
                if(!church_admin_level_check('Calendar') )
                {
                    echo '<div class="notice notice-danger"><h2>'.sprintf(__('You need "%1$s" permissions to access this page','church-admin'),__('Attendance','church-admin') ).'</h2></div>';
                    return;
                }
                church_admin_module_dropdown('calendar');
                require_once(plugin_dir_path(dirname(__FILE__) ).'includes/calendar.php');

                if(substr( $id,0,4)=='item')  {church_admin_event_edit(substr( $id,4),NULL,$edit_type,NULL,$facilities_id);}
                else{church_admin_event_edit(NULL,NULL,NULL,$id,$facilities_id);}
            
            break;
            case 'church_admin_calendar_list':
            case 'calendar-list':
                if(!church_admin_level_check('Calendar') )
                {
                    echo '<div class="notice notice-danger"><h2>'.sprintf(__('You need "%1$s" permissions to access this page','church-admin'),__('Attendance','church-admin') ).'</h2></div>';
                    return;
                }
                church_admin_module_dropdown('calendar');
                require_once(plugin_dir_path(dirname(__FILE__) ).'includes/calendar.php');
                church_admin_calendar();
            break;

            case 'church_admin_add_category':
            case 'add-category':
                if(!church_admin_level_check('Calendar') )
                {
                    echo '<div class="notice notice-danger"><h2>'.sprintf(__('You need "%1$s" permissions to access this page','church-admin'),__('Attendance','church-admin') ).'</h2></div>';
                    return;
                }
                church_admin_module_dropdown('calendar'); 
                require_once(plugin_dir_path(dirname(__FILE__) ).'includes/calendar.php');
                church_admin_edit_category(NULL,NULL);
            break;

            case 'edit-category':case 'church_admin_edit_category':
                if(!church_admin_level_check('Calendar') )
                {
                    echo '<div class="notice notice-danger"><h2>'.sprintf(__('You need "%1$s" permissions to access this page','church-admin'),__('Attendance','church-admin') ).'</h2></div>';
                    return;
                }
                church_admin_module_dropdown('calendar'); 
                require_once(plugin_dir_path(dirname(__FILE__) ).'includes/calendar.php');
                church_admin_edit_category( $id,NULL);
            break;

            case 'church_admin_delete_category':
                case 'delete-category':
                
                if(!church_admin_level_check('Calendar') )
                {
                    echo '<div class="notice notice-danger"><h2>'.sprintf(__('You need "%1$s" permissions to access this page','church-admin'),__('Attendance','church-admin') ).'</h2></div>';
                    return;
                }
                require_once(plugin_dir_path(dirname(__FILE__) ).'includes/calendar.php');
                church_admin_delete_category( $id);
            break;

            case 'church_admin_single_event_delete':
            case 'single-event-delete':
              
                    
                if(!church_admin_level_check('Calendar') )
                {
                    echo '<div class="notice notice-danger"><h2>'.sprintf(__('You need "%1$s" permissions to access this page','church-admin'),__('Attendance','church-admin') ).'</h2></div>';
                    return;
                }
                church_admin_module_dropdown('calendar'); 
                require_once(plugin_dir_path(dirname(__FILE__) ).'includes/calendar.php');
                church_admin_single_event_delete( $date_id,$event_id); 
            break;

            case 'church_admin_series_event_delete':
            case 'series-event-delete':
                //check_admin_referer('series_event_delete');
                if(!church_admin_level_check('Calendar') )
                {
                    echo '<div class="notice notice-danger"><h2>'.sprintf(__('You need "%1$s" permissions to access this page','church-admin'),__('Attendance','church-admin') ).'</h2></div>';
                    return;
                }
                church_admin_module_dropdown('calendar'); 
                require_once(plugin_dir_path(dirname(__FILE__) ).'includes/calendar.php');
                church_admin_series_event_delete( $event_id);
            break;

            case'categories':
            case 'church_admin_category_list':    
            case 'category-list':
            case 'view-categories':
                if(!church_admin_level_check('Calendar') )
                {
                    echo '<div class="notice notice-danger"><h2>'.sprintf(__('You need "%1$s" permissions to access this page','church-admin'),__('Attendance','church-admin') ).'</h2></div>';
                    return;
                }
                church_admin_module_dropdown('calendar'); 
                require_once(plugin_dir_path(dirname(__FILE__) ).'includes/calendar.php');
                church_admin_category_list();
            break;

            case 'church_admin_series_event_edit':
            case 'series-event-edit':
                //check_admin_referer('series_event_edit');
                if(!church_admin_level_check('Calendar') )
                {
                    echo '<div class="notice notice-danger"><h2>'.sprintf(__('You need "%1$s" permissions to access this page','church-admin'),__('Attendance','church-admin') ).'</h2></div>';
                    return;
                }
                church_admin_module_dropdown('calendar'); 
                require_once(plugin_dir_path(dirname(__FILE__) ).'includes/calendar.php');
                church_admin_event_edit( $date_id,$event_id,'series',NULL,NULL);
            break;

            case 'church_admin_single_event_edit':
            case 'single-event-edit':
                //check_admin_referer('single_event_edit');
                if(!church_admin_level_check('Calendar') )
                {
                    echo '<div class="notice notice-danger"><h2>'.sprintf(__('You need "%1$s" permissions to access this page','church-admin'),__('Attendance','church-admin') ).'</h2></div>';
                    return;
                }
                church_admin_module_dropdown('calendar'); 
                require_once(plugin_dir_path(dirname(__FILE__) ).'includes/calendar.php');
                church_admin_event_edit( $date_id,$event_id,'single',NULL,NULL);
            break;

            case 'church_admin_add_calendar':
            case 'add-calendar':
                if(!church_admin_level_check('Calendar') )
                {
                    echo '<div class="notice notice-danger"><h2>'.sprintf(__('You need "%1$s" permissions to access this page','church-admin'),__('Attendance','church-admin') ).'</h2></div>';
                    return;
                }
                church_admin_module_dropdown('calendar'); 
                require_once(plugin_dir_path(dirname(__FILE__) ).'includes/calendar.php');
                church_admin_event_edit(NULL,NULL,NULL,NULL,NULL);
            break;
                
            /*************************************
            *
            *		CHECK-IN
            *
            **************************************/
            case 'QRCode':
                require_once(plugin_dir_path(dirname(__FILE__) ).'includes/checkin.php');
                church_admin_create_QR( $people_id);
                break;
            case 'checkin-labels':require_once(plugin_dir_path(dirname(__FILE__) ).'includes/checkin.php');church_admin_checkin_labels();break;
            /******************************************
            *
            *   classes
            *
            *******************************************/
            case 'classes':
            case 'class':
                if(!church_admin_level_check('Classes') )
                {
                    echo '<div class="notice notice-danger"><h2>'.sprintf(__('You need "%1$s" permissions to access this page','church-admin'),__('Classes','church-admin') ).'</h2></div>';
                    return;
                }
                church_admin_module_dropdown('classes'); 
                require_once(plugin_dir_path(dirname(__FILE__) ).'includes/classes.php');
                echo'<h1>'.__("Classes",'church-admin').'</h1>';
                church_admin_classes();
                
            break;

            case 'edit_class':case 'edit-class':
                if(!church_admin_level_check('Classes') )
                {
                    echo '<div class="notice notice-danger"><h2>'.sprintf(__('You need "%1$s" permissions to access this page','church-admin'),__('Classes','church-admin') ).'</h2></div>';
                    return;
                }
                church_admin_module_dropdown('classes'); 
                require_once(plugin_dir_path(dirname(__FILE__) ).'includes/classes.php');
                church_admin_edit_class( $id);
                
            break;
            case 'delete_class':case 'delete-class':
                if(!church_admin_level_check('Classes') )
                {
                    echo '<div class="notice notice-danger"><h2>'.sprintf(__('You need "%1$s" permissions to access this page','church-admin'),__('Classes','church-admin') ).'</h2></div>';
                    return;
                }
                church_admin_module_dropdown('classes'); 
                require_once(plugin_dir_path(dirname(__FILE__) ).'includes/classes.php');
                church_admin_delete_class( $id);
                
            break;
            case 'view_class':case 'view-class':
                if(!church_admin_level_check('Classes') )
                {
                    echo '<div class="notice notice-danger"><h2>'.sprintf(__('You need "%1$s" permissions to access this page','church-admin'),__('Classes','church-admin') ).'</h2></div>';
                    return;
                }
                church_admin_module_dropdown('classes'); 
                require_once(plugin_dir_path(dirname(__FILE__) ).'includes/classes.php');
                    church_admin_view_class( $id);
                
            break;

            /*************************************
            *
            *		COMMUNICATIONS
            *
            **************************************/
            case 'push-to-all':
                if(!church_admin_level_check('Bulk Email') )
                {
                    echo '<div class="notice notice-danger"><h2>'.sprintf(__('You need "%1$s" permissions to access this page','church-admin'),__('Bulk Email','church-admin') ).'</h2></div>';
                    return;
                }
                church_admin_module_dropdown('comms'); 
                require_once(plugin_dir_path(dirname(__FILE__) ).'app/app-admin.php');
                $licence=get_option('church_admin_app_new_licence');
                if( $licence=='subscribed')ca_push_message();
                
            break;
            case'sync-mailchimp':
                if(!church_admin_level_check('Bulk Email') )
                {
                    echo '<div class="notice notice-danger"><h2>'.sprintf(__('You need "%1$s" permissions to access this page','church-admin'),__('Bulk Email','church-admin') ).'</h2></div>';
                    return;
                }
                church_admin_module_dropdown('comms'); 
                require_once(plugin_dir_path(dirname(__FILE__) ).'includes/mailchimp.php');
                church_admin_mailchimp_sync();
                
            break;
            case 'send-mailchimp':
                if(!church_admin_level_check('Bulk Email') )
                {
                    echo '<div class="notice notice-danger"><h2>'.sprintf(__('You need "%1$s" permissions to access this page','church-admin'),__('Bulk Email','church-admin') ).'</h2></div>';
                    return;
                }
                church_admin_module_dropdown('comms'); 
                require_once(plugin_dir_path(dirname(__FILE__) ).'includes/email.php');
                church_admin_send_mailchimp();
                
            break;
            case 'send-sms':
                if(!church_admin_level_check('Bulk SMS') )
                {
                    echo '<div class="notice notice-danger"><h2>'.sprintf(__('You need "%1$s" permissions to access this page','church-admin'),__('Bulk SMS','church-admin') ).'</h2></div>';
                    return;
                }
                church_admin_module_dropdown('comms'); 
                require_once(plugin_dir_path(dirname(__FILE__) ).'includes/sms.php');
                church_admin_send_sms();
                
            break;
            case 'twilio-replies':
                if(!church_admin_level_check('Bulk SMS') )
                {
                    echo '<div class="notice notice-danger"><h2>'.sprintf(__('You need "%1$s" permissions to access this page','church-admin'),__('Bulk SMS','church-admin') ).'</h2></div>';
                    return;
                }
                church_admin_module_dropdown('comms'); 
                require_once(plugin_dir_path(dirname(__FILE__) ).'includes/twilio.php');
                church_admin_twilio_replies_list();
                
            break;   
            case 'view-sms-thread':
                if(church_admin_level_check('Bulk SMS') )
                {
                    church_admin_module_dropdown('comms'); 
                    require_once(plugin_dir_path(dirname(__FILE__) ).'includes/twilio.php');
                    church_admin_view_sms_thread(urldecode( $_GET['mobile'] ) );
                }
            break; 
            case 'delete-sms-thread':
                if(!church_admin_level_check('Bulk SMS') )
                {
                    echo '<div class="notice notice-danger"><h2>'.sprintf(__('You need "%1$s" permissions to access this page','church-admin'),__('Bulk SMS','church-admin') ).'</h2></div>';
                    return;
                }
                church_admin_module_dropdown('comms'); 
                require_once(plugin_dir_path(dirname(__FILE__) ).'includes/twilio.php');
                church_admin_delete_sms_thread(urldecode( $_GET['mobile'] ) );
                
            break; 
            case 'email-settings':
                if(!church_admin_level_check('Bulk Email') )
                {
                    echo '<div class="notice notice-danger"><h2>'.sprintf(__('You need "%1$s" permissions to access this page','church-admin'),__('Bulk Email','church-admin') ).'</h2></div>';
                    return;
                }
                church_admin_module_dropdown('comms'); 
                require_once(plugin_dir_path(dirname(__FILE__) ).'includes/settings.php');            
                church_admin_email_settings();
                
            break;
            case 'smtp-settings':
                if(!church_admin_level_check('Bulk Email') )
                {
                    echo '<div class="notice notice-danger"><h2>'.sprintf(__('You need "%1$s" permissions to access this page','church-admin'),__('Bulk Email','church-admin') ).'</h2></div>';
                    return;
                }
                church_admin_module_dropdown('comms'); 
                require_once(plugin_dir_path(dirname(__FILE__) ).'includes/settings.php');            
                    church_admin_smtp_settings();
                
            break;          
            case 'sms-settings':
                if(church_admin_level_check('Bulk SMS') )
                {
                    church_admin_module_dropdown('comms'); 
                    require_once(plugin_dir_path(dirname(__FILE__) ).'includes/settings.php');            
                    church_admin_sms_settings();
                }
            break;
            case 'push':
            case 'push-message':    
                if(!church_admin_level_check('Bulk SMS') )
                {
                    echo '<div class="notice notice-danger"><h2>'.sprintf(__('You need "%1$s" permissions to access this page','church-admin'),__('Bulk SMS','church-admin') ).'</h2></div>';
                    return;
                }
                church_admin_module_dropdown('comms'); 
                require_once(plugin_dir_path(dirname(__FILE__) ).'includes/push.php');            
                church_admin_push();
                
            break;
            case 'send-email':
                if(!church_admin_level_check('Bulk Email') )
                {
                    echo '<div class="notice notice-danger"><h2>'.sprintf(__('You need "%1$s" permissions to access this page','church-admin'),__('Bulk Email','church-admin') ).'</h2></div>';
                    return;
                }
                church_admin_module_dropdown('comms'); 
                require_once(plugin_dir_path(dirname(__FILE__) ).'includes/email.php');
                church_admin_send_email(NULL);
                
            break;
            case 'comms':
                echo'<h2>'.__('Communications','church-admin').'</h2>';
                church_admin_module_dropdown('comms'); 
                require_once(plugin_dir_path(dirname(__FILE__) ).'includes/new-style-callbacks.php');
                church_admin_comms_callback();
            break;
            case 'email_list':
            case 'email-list':
                if(!church_admin_level_check('Bulk Email') )
                {
                    echo '<div class="notice notice-danger"><h2>'.sprintf(__('You need "%1$s" permissions to access this page','church-admin'),__('Bulk Email','church-admin') ).'</h2></div>';
                    return;
                }
                church_admin_module_dropdown('comms'); 
                require_once(plugin_dir_path(dirname(__FILE__) ).'includes/email.php');
                church_admin_email_list();
                
            break;
            case 'send-to-support':
                if(!church_admin_level_check('Bulk Email') )
                {
                    echo '<div class="notice notice-danger"><h2>'.sprintf(__('You need "%1$s" permissions to access this page','church-admin'),__('Bulk Email','church-admin') ).'</h2></div>';
                    return;
                }
                require_once(plugin_dir_path(dirname(__FILE__) ).'includes/settings.php');
                church_admin_send_debug_to_support();
            break;
            case 'delete_email':
                if(!church_admin_level_check('Bulk Email') )
                {
                    echo '<div class="notice notice-danger"><h2>'.sprintf(__('You need "%1$s" permissions to access this page','church-admin'),__('Bulk Email','church-admin') ).'</h2></div>';
                    return;
                }
                church_admin_module_dropdown('comms'); 
                require_once(plugin_dir_path(dirname(__FILE__) ).'includes/email.php');
                church_admin_delete_email( $email_id);
            break;
            case 'resend_email':
                if(!church_admin_level_check('Bulk Email') )
                {
                    echo '<div class="notice notice-danger"><h2>'.sprintf(__('You need "%1$s" permissions to access this page','church-admin'),__('Bulk Email','church-admin') ).'</h2></div>';
                    return;
                }
                church_admin_module_dropdown('comms'); 
                require_once(plugin_dir_path(dirname(__FILE__) ).'includes/email.php');
                church_admin_resend( $email_id);
            break;
            case 'resend_new':
                if(!church_admin_level_check('Bulk Email') )
                {
                    echo '<div class="notice notice-danger"><h2>'.sprintf(__('You need "%1$s" permissions to access this page','church-admin'),__('Bulk Email','church-admin') ).'</h2></div>';
                    return;
                }
                church_admin_module_dropdown('comms'); 
                require_once(plugin_dir_path(dirname(__FILE__) ).'includes/email.php');
                church_admin_resend_new( $email_id);
            break;

            case 'edit_resend':
                if(!church_admin_level_check('Bulk Email') )
                {
                    echo '<div class="notice notice-danger"><h2>'.sprintf(__('You need "%1$s" permissions to access this page','church-admin'),__('Bulk Email','church-admin') ).'</h2></div>';
                    return;
                }
                church_admin_module_dropdown('comms'); 
                require_once(plugin_dir_path(dirname(__FILE__) ).'includes/email.php');
                church_admin_send_email( $email_id);
            break;

            
            /*************************************
            *
            *		CUSTOM FIELDS
            *
            **************************************/
            case 'custom-fields':
                if(!church_admin_level_check('Directory') )
                {
                    echo '<div class="notice notice-danger"><h2>'.sprintf(__('You need "%1$s" permissions to access this page','church-admin'),__('Directory','church-admin') ).'</h2></div>';
                    return;
                }
                require_once(plugin_dir_path(dirname(__FILE__) ).'includes/custom_fields.php');
                echo church_admin_list_custom_fields();
                
            break;
            case 'edit_custom_field':
            case 'edit-custom-field':    
                //check_admin_referer('edit-custom-field'); 
                if(!church_admin_level_check('Directory') )
                {
                    echo '<div class="notice notice-danger"><h2>'.sprintf(__('You need "%1$s" permissions to access this page','church-admin'),__('Directory','church-admin') ).'</h2></div>';
                    return;
                }
                echo church_admin_edit_custom_field( $id);
            break;
            case 'delete_custom_field':
            case 'delete-custom-field':    
                ////check_admin_referer('delete_custom_field'); 
                if(!church_admin_level_check('Directory') )
                {
                    echo '<div class="notice notice-danger"><h2>'.sprintf(__('You need "%1$s" permissions to access this page','church-admin'),__('Directory','church-admin') ).'</h2></div>';
                    return;
                }
                echo church_admin_delete_custom_field( $id);
            break;
            /*************************************
            *
            *		DIRECTORY
            *
            **************************************/
            case 'import-from-users':
                if(!church_admin_level_check('Directory') )
                {
                    echo '<div class="notice notice-danger"><h2>'.sprintf(__('You need "%1$s" permissions to access this page','church-admin'),__('Directory','church-admin') ).'</h2></div>';
                    return;
                }
                church_admin_module_dropdown('people');  
                require_once(plugin_dir_path(dirname(__FILE__) ).'includes/import.php'); 
                church_admin_import_from_users();
            break;
            case 'check-directory-issues':
                if(!church_admin_level_check('Directory') )
                {
                    echo '<div class="notice notice-danger"><h2>'.sprintf(__('You need "%1$s" permissions to access this page','church-admin'),__('Directory','church-admin') ).'</h2></div>';
                    return;
                }
                church_admin_module_dropdown('people');  
                    church_admin_directory_issues_fixer();
                
            break;
            case'church_admin_people_activity':
                if(!church_admin_level_check('Directory') )
                {
                    echo '<div class="notice notice-danger"><h2>'.sprintf(__('You need "%1$s" permissions to access this page','church-admin'),__('Directory','church-admin') ).'</h2></div>';
                    return;
                }
                church_admin_module_dropdown('people');    
                require_once(plugin_dir_path(dirname(__FILE__) ).'includes/people_activity.php'); 
                echo church_admin_recent_people_activity();
            break;
            case 'smallgroups-map':
                $centre=church_admin_center_coordinates(CA_SMG_TBL);
                echo'<h2>'.__('Smallgroups map','church-admin').'</h2>';
                church_admin_module_dropdown('groups');   
                if ( empty( $centre->lat)||empty( $centre->lng) )$centre=$wpdb->get_row('SELECT lat, lng FROM '.CA_SIT_TBL.' ORDER BY site_id ASC LIMIT 1');
                if(!empty( $centre) )
                {
                    echo'<script type="text/javascript">var xml_url="'.site_url().'/?ca_download=small-group-xml&small-group-xml='.wp_create_nonce('small-group-xml').'";';
                    if(!empty( $centre->lat) )  {echo' var lat='.esc_html( $centre->lat).';';}
                    if(!empty( $centre->lng) )  {echo' var lng='.esc_html( $centre->lng).';';}
                    echo' var zoom=13;';
                    echo'jQuery(document).ready(function()  {sgload(lat,lng,xml_url,zoom);})</script><div id="map" style="width:100%;height:750px;" ></div>';
                    
                }
                
            
                
            break; 
            case 'people-map':
                if(!church_admin_level_check('Directory') )
                {
                    echo '<div class="notice notice-danger"><h2>'.sprintf(__('You need "%1$s" permissions to access this page','church-admin'),__('Directory','church-admin') ).'</h2></div>';
                    return;
                }
                church_admin_module_dropdown('people');   
                $args=array('width'=>'100%','height'=>'750px','zoom'=>13);
                echo church_admin_map(13,NULL,1,1,1,"100%","750px");
            break;
            case 'add-household':
                if(!church_admin_level_check('Directory') )
                {
                    echo '<div class="notice notice-danger"><h2>'.sprintf(__('You need "%1$s" permissions to access this page','church-admin'),__('Directory','church-admin') ).'</h2></div>';
                    return;
                }
                church_admin_module_dropdown('people');   
                require_once(plugin_dir_path(dirname(__FILE__) ).'includes/directory.php');
                church_admin_new_household();
                
            break;
            case 'download-csv':
                if(!church_admin_level_check('Directory') )
                {
                    echo '<div class="notice notice-danger"><h2>'.sprintf(__('You need "%1$s" permissions to access this page','church-admin'),__('Directory','church-admin') ).'</h2></div>';
                    return;
                }
                church_admin_module_dropdown('people');   
                require_once(plugin_dir_path(dirname(__FILE__) ).'includes/directory.php');
                church_admin_export_csv();
                
            break;
            case 'recent-people':
            case 'recent-activity':
                if(!church_admin_level_check('Directory') )
                {
                    echo '<div class="notice notice-danger"><h2>'.sprintf(__('You need "%1$s" permissions to access this page','church-admin'),__('Directory','church-admin') ).'</h2></div>';
                    return;
                }
                church_admin_module_dropdown('people');   
                require_once(plugin_dir_path(dirname(__FILE__) ).'includes/people_activity.php');     
                church_admin_recent_people_activity();    
                
            break;
            case 'view-directory':
                if(!church_admin_level_check('Directory') )
                {
                    echo '<div class="notice notice-danger"><h2>'.sprintf(__('You need "%1$s" permissions to access this page','church-admin'),__('Directory','church-admin') ).'</h2></div>';
                    return;
                }
                church_admin_module_dropdown('people');   
                require_once(plugin_dir_path(dirname(__FILE__) ).'includes/directory.php');
                    church_admin_view_directory();
                
            break;
            case 'export-pdf':
                if(!church_admin_level_check('Directory') )
                {
                    echo '<div class="notice notice-danger"><h2>'.sprintf(__('You need "%1$s" permissions to access this page','church-admin'),__('Directory','church-admin') ).'</h2></div>';
                    return;
                }
                church_admin_module_dropdown('people');   
                require_once(plugin_dir_path(dirname(__FILE__) ).'includes/directory.php');
                church_admin_pdf_menu();
                
            break;

            case 'download-csv':
                if(!church_admin_level_check('Directory') )
                {
                    echo '<div class="notice notice-danger"><h2>'.sprintf(__('You need "%1$s" permissions to access this page','church-admin'),__('Directory','church-admin') ).'</h2></div>';
                    return;
                }
                church_admin_module_dropdown('people');   
                require_once(plugin_dir_path(dirname(__FILE__) ).'includes/directory.php');            
                    church_admin_export_csv();
                
            break;
            case'bulk_geocode':case'bulk-geocode':
                if(!church_admin_level_check('Directory') )
                {
                    echo '<div class="notice notice-danger"><h2>'.sprintf(__('You need "%1$s" permissions to access this page','church-admin'),__('Directory','church-admin') ).'</h2></div>';
                    return;
                }
                church_admin_module_dropdown('people');   
                require_once(plugin_dir_path(dirname(__FILE__) ).'includes/directory.php');
                church_admin_bulk_geocode();
        break;
            case'recent-people':
                if(!church_admin_level_check('Directory') )
                {
                    echo '<div class="notice notice-danger"><h2>'.sprintf(__('You need "%1$s" permissions to access this page','church-admin'),__('Directory','church-admin') ).'</h2></div>';
                    return;
                }
                church_admin_module_dropdown('people');   
                require_once(plugin_dir_path(dirname(__FILE__) ).'includes/people-activity.php');
                church_admin_recent_people_activity();
                
        break;     
            case 'birthdays':
                if(!church_admin_level_check('Directory') )
                {
                    echo '<div class="notice notice-danger"><h2>'.sprintf(__('You need "%1$s" permissions to access this page','church-admin'),__('Directory','church-admin') ).'</h2></div>';
                    return;
                }
                church_admin_module_dropdown('people');   
                echo'<h1>'.__("All birthdays",'church-admin').'</h1>';
                require_once(plugin_dir_path(dirname(__FILE__) ).'includes/birthdays.php');
                echo church_admin_frontend_birthdays(0,0,31,TRUE,1,1);
                
            break; 
            case 'bulk_not_private':
            
                if(!church_admin_level_check('Directory') )
                {
                    echo '<div class="notice notice-danger"><h2>'.sprintf(__('You need "%1$s" permissions to access this page','church-admin'),__('Directory','church-admin') ).'</h2></div>';
                    return;
                }
                church_admin_module_dropdown('people');   
                require_once(plugin_dir_path(dirname(__FILE__) ).'includes/directory.php');
                church_admin_bulk_not_private();
            break;
            case 'gdpr_bulk_confirm':
                if(!church_admin_level_check('Directory') )
                {
                    echo '<div class="notice notice-danger"><h2>'.sprintf(__('You need "%1$s" permissions to access this page','church-admin'),__('Directory','church-admin') ).'</h2></div>';
                    return;
                }
                church_admin_module_dropdown('people');   
                require_once(plugin_dir_path(dirname(__FILE__) ).'includes/directory.php');
                gdpr_confirm_everyone();
            break;
            case 'view_person':
                if(!church_admin_level_check('Directory') )
                {
                    echo '<div class="notice notice-danger"><h2>'.sprintf(__('You need "%1$s" permissions to access this page','church-admin'),__('Directory','church-admin') ).'</h2></div>';
                    return;
                }
                church_admin_module_dropdown('people');   
                require_once(plugin_dir_path(dirname(__FILE__) ).'includes/directory.php'); 
                church_admin_view_person( $people_id);
            break;
            case 'church_admin_move_person':
                if(!church_admin_level_check('Directory') )
                {
                    echo '<div class="notice notice-danger"><h2>'.sprintf(__('You need "%1$s" permissions to access this page','church-admin'),__('Directory','church-admin') ).'</h2></div>';
                    return;
                }
                church_admin_module_dropdown('people');   
                require_once(plugin_dir_path(dirname(__FILE__) ).'includes/directory.php');
                church_admin_move_person( $people_id);
            break;
            case 'view-address-list':case 'church_admin_address_list': 
                if(!church_admin_level_check('Directory') )
                {
                    echo '<div class="notice notice-danger"><h2>'.sprintf(__('You need "%1$s" permissions to access this page','church-admin'),__('Directory','church-admin') ).'</h2></div>';
                    return;
                }
                church_admin_module_dropdown('people');   
                require_once(plugin_dir_path(dirname(__FILE__) ).'includes/directory.php');
                church_admin_address_list( $member_type_id);
            break;
            
            case  'create_confirmed_users':
            case 'create_users':case 'create-users':
                if(!church_admin_level_check('Directory') )
                {
                    echo '<div class="notice notice-danger"><h2>'.sprintf(__('You need "%1$s" permissions to access this page','church-admin'),__('Directory','church-admin') ).'</h2></div>';
                    return;
                }
                church_admin_module_dropdown('people');   
                require_once(plugin_dir_path(dirname(__FILE__) ).'includes/directory.php');
                church_admin_users();
                
            break;
                
            case 'church_admin_create_user':
                //check_admin_referer('create_user');
                if(!church_admin_level_check('Directory') )
                {
                    echo '<div class="notice notice-danger"><h2>'.sprintf(__('You need "%1$s" permissions to access this page','church-admin'),__('Directory','church-admin') ).'</h2></div>';
                    return;
                }
                church_admin_module_dropdown('people');   
                require_once(plugin_dir_path(dirname(__FILE__) ).'includes/directory.php');
                church_admin_create_user( $people_id,$household_id);
                break;
            case 'church_admin_migrate_users':
                //check_admin_referer('migrate_users');
            
                if(!church_admin_level_check('Directory') )
                {
                    echo '<div class="notice notice-danger"><h2>'.sprintf(__('You need "%1$s" permissions to access this page','church-admin'),__('Directory','church-admin') ).'</h2></div>';
                    return;
                }
                church_admin_module_dropdown('people');   
                require_once(plugin_dir_path(dirname(__FILE__) ).'includes/directory.php');
                church_admin_migrate_users();
            break;
            case 'display_household':
            case 'display-household':                
            if(church_admin_level_check('Directory')||$self_edit)
            {
                if(!$self_edit)church_admin_module_dropdown('people'); 
                require_once(plugin_dir_path(dirname(__FILE__) ).'includes/directory.php');
                church_admin_new_household_display( $household_id);
            }else{echo'<p>'.__('You do not have permission to do that','church-admin').'</p>';}break;
            case 'everyone-visible':
                if(!church_admin_level_check('Directory') )
                {
                    echo '<div class="notice notice-danger"><h2>'.sprintf(__('You need "%1$s" permissions to access this page','church-admin'),__('Directory','church-admin') ).'</h2></div>';
                    return;
                }
                church_admin_module_dropdown('people');  
                require_once(plugin_dir_path(dirname(__FILE__) ).'includes/directory.php');
                church_admin_bulk_not_private();
            
            break;
            case 'edit_household':
                if(church_admin_level_check('Directory')||$self_edit)
                {
                    if(!$self_edit)church_admin_module_dropdown('people'); 
                    require_once(plugin_dir_path(dirname(__FILE__) ).'includes/directory.php');
                    church_admin_edit_household( $household_id);
                }else{echo'<p>'.__('You do not have permission to do that','church-admin').'</p>';}
                break;
            case 'delete_household':
            case 'delete-household':
                //check_admin_referer('delete_household');
                if(church_admin_level_check('Directory') )
                {
                    require_once(plugin_dir_path(dirname(__FILE__) ).'includes/directory.php');
                    church_admin_delete_household( $household_id);
                }
            break;
            case 'check-duplicates':
                if(!church_admin_level_check('Directory') )
                {
                    echo '<div class="notice notice-danger"><h2>'.sprintf(__('You need "%1$s" permissions to access this page','church-admin'),__('Directory','church-admin') ).'</h2></div>';
                    return;
                }
                church_admin_module_dropdown('people');   
                church_admin_module_dropdown('people');   
                require_once(plugin_dir_path(dirname(__FILE__) ).'includes/directory.php');
                church_admin_potential_duplicates();
                
            break;
            case 'edit_people':
                if(church_admin_level_check('Directory')||$self_edit)
                {
                    if(!$self_edit)church_admin_module_dropdown('people');   
                    require_once(plugin_dir_path(dirname(__FILE__) ).'includes/directory.php');
                    church_admin_edit_people( $people_id,$household_id);
                
                }else{echo'<p>'.__('You do not have permission to do that','church-admin').'</p>';}
            break;
            case 'delete-all':

                if(!current_user_can('manage_options') )return '<p>'.__('Only site admins can do this','church-admin').'</p>';
                if(!$self_edit)church_admin_module_dropdown('people'); 
                if(!empty( $_POST['sure'] ) )
                {
                    $wpdb->query('TRUNCATE TABLE '.CA_PEO_TBL);
                    $wpdb->query('TRUNCATE TABLE '.CA_HOU_TBL);
                    $wpdb->query('TRUNCATE TABLE '.CA_MET_TBL);
                    echo'<h2>'.__('All households deleted','church-admin').'</h2>';
                }
                else
                {
                    echo'<form action="" method="post"><h2><strong>'.__("Are you sure you want to delete everyone?",'church-admin').'</strong></h2><p><input type="hidden" name="sure" value="yes"/><input type="submit"  class="button-secondary" value="'.__('Yes, delete everyone','church-admin').'"/></p></form>';
                }
                
            break;
            case 'delete_people':
                if(church_admin_level_check('Directory')||$self_edit)
                {
                    if(!$self_edit)church_admin_module_dropdown('people'); 
                    require_once(plugin_dir_path(dirname(__FILE__) ).'includes/directory.php');
                    church_admin_delete_people( $people_id,$household_id,TRUE,TRUE);
                }
                else{echo'<p>'.__('You do not have permission to do that','church-admin').'</p>';}
            break;
            case 'church_admin_search':
                if(wp_verify_nonce('ca_search_nonce','ca_search_nonce') )
                {
                    if(!$self_edit)church_admin_module_dropdown('people'); 
                    require_once(plugin_dir_path(dirname(__FILE__) ).'includes/directory.php');
                    church_admin_search( $_POST['ca_search'] );
                }
            break;
            case'church_admin_recent_visitors': require_once(plugin_dir_path(dirname(__FILE__) ).'includes/recent.php');echo church_admin_recent_visitors( $member_type_id);break;
            /*************************************
            *
            *		contact form
            *
            **************************************/
            case 'contact-form':
                if(!church_admin_level_check('Contact form') )
                {
                    echo '<div class="notice notice-danger"><h2>'.sprintf(__('You need "%1$s" permissions to access this page','church-admin'),__('Events','church-admin') ).'</h2></div>';
                    return;
                }
                church_admin_module_dropdown('contact-form'); 
                require_once(plugin_dir_path(dirname(__FILE__) ).'includes/contact_form.php'); 
                church_admin_contact_form_list();
            break;
            case 'contact-form-settings':
                if(!church_admin_level_check('Contact form') )
                {
                    echo '<div class="notice notice-danger"><h2>'.sprintf(__('You need "%1$s" permissions to access this page','church-admin'),__('Events','church-admin') ).'</h2></div>';
                    return;
                }
                church_admin_module_dropdown('contact-form'); 
                require_once(plugin_dir_path(dirname(__FILE__) ).'includes/contact_form.php'); 
                church_admin_contact_form_settings();
            break;
            case 'delete-contact-message':
                check_admin_referer("delete_contact_message");
                if(!church_admin_level_check('Contact form') )
                {
                    echo '<div class="notice notice-danger"><h2>'.sprintf(__('You need "%1$s" permissions to access this page','church-admin'),__('Events','church-admin') ).'</h2></div>';
                    return;
                }
                church_admin_module_dropdown('contact-form'); 
                require_once(plugin_dir_path(dirname(__FILE__) ).'includes/contact_form.php'); 
                church_admin_delete_contact_message( $_GET['id'] );
            break;
            /*************************************
            *
            *		ERRORS
            *
            **************************************/
            case 'activation-log-clear':
                //check_admin_referer('clear_error');
                church_admin_activation_log_clear();
            break;
                
            case 'error-log':
            case 'installation-errors':
                echo'<h1>'.__('Installation errors','church-admin').'</h1>';	
                $error=get_option('church_admin_plugin_error');
                if(!empty( $error) )
                {
                    
                    echo'<p>'.__('This is what was saved as an error during activation ','church-admin').'"'.$error.'"</p>';
                    echo'<p><a href="'.wp_nonce_url('admin.php?page=church_admin/index.php&amp;section=settings&action=activation-log-clear','clear_error').'">'.__('Clear activation errors log','church-admin').'</a></p><hr/>';
                }
                else{
                    echo'<p>'.__('No installation errors recoreded','church-admin').'</p>';
                }
            break;

            /*************************************
            *
            *		Events
            *
            **************************************/
            case 'add-event':case 'edit_event':
                if(!church_admin_level_check('Events') )
                {
                    echo '<div class="notice notice-danger"><h2>'.sprintf(__('You need "%1$s" permissions to access this page','church-admin'),__('Events','church-admin') ).'</h2></div>';
                    return;
                }
                church_admin_module_dropdown('events'); 
                require_once(plugin_dir_path(dirname(__FILE__) ).'includes/events.php'); 
                    
                church_admin_edit_event( $event_id);

            break;
            case 'edit_ticket_type':
                if(!church_admin_level_check('Events') )
                {
                    echo '<div class="notice notice-danger"><h2>'.sprintf(__('You need "%1$s" permissions to access this page','church-admin'),__('Events','church-admin') ).'</h2></div>';
                    return;
                }
                church_admin_module_dropdown('events'); 
                require_once(plugin_dir_path(dirname(__FILE__) ).'includes/events.php'); 
                church_admin_edit_ticket_type( $event_id,$ticket_id);
                
            break;
            case 'delete_ticket_type':
                if(!church_admin_level_check('Events') )
                {
                    echo '<div class="notice notice-danger"><h2>'.sprintf(__('You need "%1$s" permissions to access this page','church-admin'),__('Events','church-admin') ).'</h2></div>';
                    return;
                }
                church_admin_module_dropdown('events'); 
                require_once(plugin_dir_path(dirname(__FILE__) ).'includes/events.php'); 
                church_admin_delete_ticket_type( $event_id,$ticket_id);
            break;
            case 'view-event':
            case 'view_event':
                if(!church_admin_level_check('Events') )
                {
                    echo '<div class="notice notice-danger"><h2>'.sprintf(__('You need "%1$s" permissions to access this page','church-admin'),__('Events','church-admin') ).'</h2></div>';
                    return;
                }
                church_admin_module_dropdown('events'); 
                require_once(plugin_dir_path(dirname(__FILE__) ).'includes/events.php'); 
                church_admin_view_event( $event_id);
                
            break;
            case   'delete_event':
                //check_admin_referer('delete_event');
                if(!church_admin_level_check('Events') )
                {
                    echo '<div class="notice notice-danger"><h2>'.sprintf(__('You need "%1$s" permissions to access this page','church-admin'),__('Events','church-admin') ).'</h2></div>';
                    return;
                }
                church_admin_module_dropdown('events'); 
                require_once(plugin_dir_path(dirname(__FILE__) ).'includes/events.php'); 
                church_admin_delete_event( $event_id);
            break;
            case 'edit_booking'://check_admin_referer('edit_booking');
            if(!church_admin_level_check('Events') )
                {
                    echo '<div class="notice notice-danger"><h2>'.sprintf(__('You need "%1$s" permissions to access this page','church-admin'),__('Events','church-admin') ).'</h2></div>';
                    return;
                }
                church_admin_module_dropdown('events'); 
                require_once(plugin_dir_path(dirname(__FILE__) ).'includes/events.php'); 
                church_admin_edit_booking( $ticket_id,$event_id,$booking_ref);
            break;
            case 'delete_booking'://check_admin_referer('delete_booking');
            if(!church_admin_level_check('Events') )
                {
                    echo '<div class="notice notice-danger"><h2>'.sprintf(__('You need "%1$s" permissions to access this page','church-admin'),__('Events','church-admin') ).'</h2></div>';
                    return;
                }
                church_admin_module_dropdown('events'); 
                require_once(plugin_dir_path(dirname(__FILE__) ).'includes/events.php'); 
                church_admin_delete_booking( $ticket_id);
            break;
            case 'view_bookings':
                //check_admin_referer('view_bookings');
                if(!church_admin_level_check('Events') )
                {
                    echo '<div class="notice notice-danger"><h2>'.sprintf(__('You need "%1$s" permissions to access this page','church-admin'),__('Events','church-admin') ).'</h2></div>';
                    return;
                }
                church_admin_module_dropdown('events'); 
                require_once(plugin_dir_path(dirname(__FILE__) ).'includes/events.php'); 
                church_admin_view_bookings( $event_id);
            break;
            case 'show-events':case 'events':
                if(!church_admin_level_check('Events') )
                {
                    echo '<div class="notice notice-danger"><h2>'.sprintf(__('You need "%1$s" permissions to access this page','church-admin'),__('Events','church-admin') ).'</h2></div>';
                    return;
                }
                church_admin_module_dropdown('events'); 
                require_once(plugin_dir_path(dirname(__FILE__) ).'includes/events.php'); 
                church_admin_events();
                
            break;

                
            /*************************************
            *
            *		FACILITIES
            *
            **************************************/
            case 'facilities':
            case 'church_admin_facilities':
                if(!church_admin_level_check('Calendar') )
                {
                    echo '<div class="notice notice-danger"><h2>'.sprintf(__('You need "%1$s" permissions to access this page','church-admin'),__('Calendar','church-admin') ).'</h2></div>';
                    return;
                }
                church_admin_module_dropdown('facilities'); 
                require_once(plugin_dir_path(dirname(__FILE__) ).'includes/facilities.php');
                church_admin_facilities();
                
            break;
            case 'edit_facility':
            case 'edit-facility':
                if(!church_admin_level_check('Calendar') )
                {
                    echo '<div class="notice notice-danger"><h2>'.sprintf(__('You need "%1$s" permissions to access this page','church-admin'),__('Calendar','church-admin') ).'</h2></div>';
                    return;
                }
                church_admin_module_dropdown('facilities'); 
                require_once(plugin_dir_path(dirname(__FILE__) ).'includes/facilities.php');
                    church_admin_edit_facility( $facilities_id);
                
            break;
            case 'delete_facility':
                if(!church_admin_level_check('Calendar') )
                {
                    echo '<div class="notice notice-danger"><h2>'.sprintf(__('You need "%1$s" permissions to access this page','church-admin'),__('Calendar','church-admin') ).'</h2></div>';
                    return;
                }
                church_admin_module_dropdown('facilities'); 
                require_once(plugin_dir_path(dirname(__FILE__) ).'includes/facilities.php');
                church_admin_delete_facility( $facilities_id);
                
            break;
            case 'facility-bookings':
                if(!church_admin_level_check('Calendar') )
                {
                    echo '<div class="notice notice-danger"><h2>'.sprintf(__('You need "%1$s" permissions to access this page','church-admin'),__('Calendar','church-admin') ).'</h2></div>';
                    return;
                }
                church_admin_module_dropdown('facilities'); 
                require_once(plugin_dir_path(dirname(__FILE__) ).'includes/facilities.php');
                    church_admin_facility_bookings( $facilities_id);
    
            break;
            case 'facility-hires':
                if(!church_admin_level_check('Calendar') )
                {
                    echo '<div class="notice notice-danger"><h2>'.sprintf(__('You need "%1$s" permissions to access this page','church-admin'),__('Calendar','church-admin') ).'</h2></div>';
                    return;
                }
                church_admin_module_dropdown('facilities'); 
                require_once(plugin_dir_path(dirname(__FILE__) ).'includes/facilities.php');
                church_admin_facility_hire( $facilities_id);
    
            break;  
            /*************************************
            *
            *		FOLLOW UP
            *
            **************************************/
            case'funnel':
            case 'follow-up':
            case 'church_admin_funnel_list':
                church_admin_module_dropdown('follow-up'); 
                if(church_admin_level_check('Directory') )
                { 
                    require_once(plugin_dir_path(dirname(__FILE__) ).'includes/funnel.php');church_admin_funnel_list();
                }
            break;
            case 'add-funnel':
            case 'edit_funnel':
                if(church_admin_level_check('Directory') )
                { 
                    church_admin_module_dropdown('follow-up'); 
                    require_once(plugin_dir_path(dirname(__FILE__) ).'includes/funnel.php');
                    church_admin_edit_funnel( $funnel_id,$people_type_id);
                }
            break;
            case 'delete_funnel':
                //check_admin_referer('delete_funnel');
                church_admin_module_dropdown('follow-up'); 
                require_once(plugin_dir_path(dirname(__FILE__) ).'includes/funnel.php');
                church_admin_delete_funnel( $funnel_id);
                break;
            case 'church_admin_assign_funnel':require_once(plugin_dir_path(dirname(__FILE__) ).'includes/people_activity.php');church_admin_assign_funnel();break;
            case 'church_admin_email_follow_up_activity':
                church_admin_module_dropdown('follow-up'); 
                //check_admin_referer('email_funnels');
                require_once(plugin_dir_path(dirname(__FILE__) ).'includes/people_activity.php');
                church_admin_email_follow_up_activity();
            break;
            case 'follow_up_completed':
                church_admin_module_dropdown('follow-up'); 
                require_once(plugin_dir_path(dirname(__FILE__) ).'includes/funnel.php');
                require_once(plugin_dir_path(dirname(__FILE__) ).'includes/people_activity.php');
                church_admin_follow_up_completed( $id);
            break;
                
                
            /*************************************
            *
            *		HOPETEAM
            *
            **************************************/
            case'hope_team_jobs':
                //check_admin_referer('hope_team_jobs');
                require_once(plugin_dir_path(dirname(__FILE__) ).'includes/hope-team.php');church_admin_hope_team_jobs( $id);
            break;
            case'edit_hope_team_job':
                //check_admin_referer('hope_team_jobs');
                require_once(plugin_dir_path(dirname(__FILE__) ).'includes/hope-team.php');
                church_admin_edit_hope_team_job( $id);
                break;
            case'delete_hope_team_job':
                //check_admin_referer('delete_hope_team_jobs');
                require_once(plugin_dir_path(dirname(__FILE__) ).'includes/hope-team.php');
                church_admin_delete_hope_team_job( $id);
                break;
            case'edit_hope_team':
                //check_admin_referer('edit_hope_team');
                require_once(plugin_dir_path(dirname(__FILE__) ).'includes/hope-team.php');
                church_admin_edit_hope_team( $id);
            break;
            /*************************************
            *
            *		GIVING
            *
            **************************************/
            case 'paypal-setup':
            case 'giving-paypal-setup':    
                if(!church_admin_level_check('Giving') )
                {
                    echo '<div class="notice notice-danger"><h2>'.sprintf(__('You need "%1$s" permissions to access this page','church-admin'),__('Giving','church-admin') ).'</h2></div>';
                    return;
                }
                church_admin_module_dropdown('giving'); 
                church_admin_paypal_setup();
            break;
            case 'giving':
                if(!church_admin_level_check('Giving') )
                {
                    echo '<div class="notice notice-danger"><h2>'.sprintf(__('You need "%1$s" permissions to access this page','church-admin'),__('Giving','church-admin') ).'</h2></div>';
                    return;
                }

                church_admin_module_dropdown('giving'); 
                require_once(plugin_dir_path(dirname(__FILE__) ).'includes/giving.php');
                church_admin_giving_list(); 
                
            break;
            case 'giving-csv':
                if(!church_admin_level_check('Giving') )
                {
                    echo '<div class="notice notice-danger"><h2>'.sprintf(__('You need "%1$s" permissions to access this page','church-admin'),__('Giving','church-admin') ).'</h2></div>';
                    return;
                }
                church_admin_module_dropdown('giving'); 
                require_once(plugin_dir_path(dirname(__FILE__) ).'includes/giving.php');
                church_admin_giving_csv(); 
                
            break;
            case 'gift-aid-csv':
                church_admin_date_picker_script();
                if(!church_admin_level_check('Giving') )
                {
                    echo '<div class="notice notice-danger"><h2>'.sprintf(__('You need "%1$s" permissions to access this page','church-admin'),__('Giving','church-admin') ).'</h2></div>';
                    return;
                }
                church_admin_module_dropdown('giving'); 
                require_once(plugin_dir_path(dirname(__FILE__) ).'includes/giving.php');           
                church_admin_gift_aid_csv();
                
            break;
            /*
            case 'giving-receipts':
                church_admin_date_picker_script();
                if(!church_admin_level_check('Giving') )
                {
                    echo '<div class="notice notice-danger"><h2>'.sprintf(__('You need "%1$s" permissions to access this page','church-admin'),__('Giving','church-admin') ).'</h2></div>';
                    return;
                }
                church_admin_module_dropdown('giving'); 
                require_once(plugin_dir_path(dirname(__FILE__) ).'includes/giving.php');           
                church_admin_giving_receipts();

            break;
            */   
            case 'email-donor-receipt':
                
                if(!church_admin_level_check('Giving') )
                {
                    echo '<div class="notice notice-danger"><h2>'.sprintf(__('You need "%1$s" permissions to access this page','church-admin'),__('Giving','church-admin') ).'</h2></div>';
                    return;
                }
                church_admin_module_dropdown('giving'); 
                require_once(plugin_dir_path(dirname(__FILE__) ).'includes/giving.php');           
                church_admin_email_donor_receipt( $_GET['receipt_id'] );
            break;  
            case 'funds':
                ////check_admin_referer('funds');
                if(!church_admin_level_check('Giving') )
                {
                    echo '<div class="notice notice-danger"><h2>'.sprintf(__('You need "%1$s" permissions to access this page','church-admin'),__('Giving','church-admin') ).'</h2></div>';
                    return;
                }
                church_admin_module_dropdown('giving'); 
                require_once(plugin_dir_path(dirname(__FILE__) ).'includes/giving.php');
                church_admin_giving_funds(); 
                
            break;
                case 'edit-fund':
                ////check_admin_referer('edit-fund');
                if(!church_admin_level_check('Giving') )
                {
                    echo '<div class="notice notice-danger"><h2>'.sprintf(__('You need "%1$s" permissions to access this page','church-admin'),__('Giving','church-admin') ).'</h2></div>';
                    return;
                }
                church_admin_module_dropdown('giving'); 
                require_once(plugin_dir_path(dirname(__FILE__) ).'includes/giving.php');
                church_admin_edit_fund( $fund_id); 
                
            break;
            case 'delete-fund':
                ////check_admin_referer('delete-fund');
                if(!church_admin_level_check('Giving') )
                {
                    echo '<div class="notice notice-danger"><h2>'.sprintf(__('You need "%1$s" permissions to access this page','church-admin'),__('Giving','church-admin') ).'</h2></div>';
                    return;
                }
                church_admin_module_dropdown('giving'); 
                require_once(plugin_dir_path(dirname(__FILE__) ).'includes/giving.php');
                church_admin_delete_fund( $fund_id); 
                
            break;
            case 'edit-gift':
                if(!church_admin_level_check('Giving') )
                {
                    echo '<div class="notice notice-danger"><h2>'.sprintf(__('You need "%1$s" permissions to access this page','church-admin'),__('Giving','church-admin') ).'</h2></div>';
                    return;
                }
                church_admin_module_dropdown('giving'); 
                require_once(plugin_dir_path(dirname(__FILE__) ).'includes/giving.php');
                church_admin_giving_edit( $giving_id); 

            break;
            case 'fix-anon-gifts':
                if(!church_admin_level_check('Giving') )
                {
                    echo '<div class="notice notice-danger"><h2>'.sprintf(__('You need "%1$s" permissions to access this page','church-admin'),__('Giving','church-admin') ).'</h2></div>';
                    return;
                }
                church_admin_module_dropdown('giving'); 
                require_once(plugin_dir_path(dirname(__FILE__) ).'includes/giving.php');
                church_admin_fix_anon_giving();
                church_admin_giving_list();
            break;
            case 'delete-gift':
                //check_admin_referer('delete-gift');
                if(!church_admin_level_check('Giving') )
                {
                    echo '<div class="notice notice-danger"><h2>'.sprintf(__('You need "%1$s" permissions to access this page','church-admin'),__('Giving','church-admin') ).'</h2></div>';
                    return;
                }
                church_admin_module_dropdown('giving'); 
                require_once(plugin_dir_path(dirname(__FILE__) ).'includes/giving.php');
                church_admin_giving_delete( $gift_id); 
                
            break;
            case 'donor-giving':
            case 'donor-gift':
                //check_admin_referer('donor-giving');
                if(!church_admin_level_check('Giving') )
                {
                    echo '<div class="notice notice-danger"><h2>'.sprintf(__('You need "%1$s" permissions to access this page','church-admin'),__('Giving','church-admin') ).'</h2></div>';
                    return;
                }
                church_admin_module_dropdown('giving'); 
                require_once(plugin_dir_path(dirname(__FILE__) ).'includes/giving.php');
                church_admin_donor_giving( $people_id); 

            break; 
            /*************************************
            *
            *		KIDS WORK
            *
            **************************************/
            case 'kidswork-pdf':
            case 'childrens-work-pdf':
                if(!church_admin_level_check('Kidswork') )
                {
                    echo '<div class="notice notice-danger"><h2>'.sprintf(__('You need "%1$s" permissions to access this page','church-admin'),__('Kidswork','church-admin') ).'</h2></div>';
                    return;
                }
                church_admin_module_dropdown('childrens-work'); 
                require_once(plugin_dir_path(dirname(__FILE__) ).'includes/kidswork.php');
                    church_admin_kidswork_PDF();
                
            break;
            case 'kidswork-checkin-pdf':
            case 'childrens-work-checkin-pdf':
                if(!church_admin_level_check('Kidswork') )
                {
                    echo '<div class="notice notice-danger"><h2>'.sprintf(__('You need "%1$s" permissions to access this page','church-admin'),__('Kidswork','church-admin') ).'</h2></div>';
                    return;
                }
                church_admin_module_dropdown('childrens-work'); 
                require_once(plugin_dir_path(dirname(__FILE__) ).'includes/kidswork.php');
                church_admin_kidswork_checkin_PDF();
                
            break;
            case 'edit_kidswork':
                if(!church_admin_level_check('Kidswork') )
                {
                    echo '<div class="notice notice-danger"><h2>'.sprintf(__('You need "%1$s" permissions to access this page','church-admin'),__('Kidswork','church-admin') ).'</h2></div>';
                    return;
                }
                church_admin_module_dropdown('childrens-work'); 
                require_once(plugin_dir_path(dirname(__FILE__) ).'includes/kidswork.php');
                church_admin_edit_kidswork( $id);
                
            break;
            case 'delete_kidswork':
                if(!church_admin_level_check('Kidswork') )
                {
                    echo '<div class="notice notice-danger"><h2>'.sprintf(__('You need "%1$s" permissions to access this page','church-admin'),__('Kidswork','church-admin') ).'</h2></div>';
                    return;
                }
                church_admin_module_dropdown('childrens-work'); 
                require_once(plugin_dir_path(dirname(__FILE__) ).'includes/kidswork.php');
                church_admin_delete_kidswork( $id);
                
            break;
            case 'kidswork': 
            case 'childrens-work':
                if(!church_admin_level_check('Kidswork') )
                {
                    echo '<div class="notice notice-danger"><h2>'.sprintf(__('You need "%1$s" permissions to access this page','church-admin'),__('Kidswork','church-admin') ).'</h2></div>';
                    return;
                }
                church_admin_module_dropdown('childrens-work'); 
                require_once(plugin_dir_path(dirname(__FILE__) ).'includes/kidswork.php');
                    echo'<h1>'.__("Children's Ministry",'church-admin').'</h1>';
                    echo church_admin_kidswork();
            
            break;
            case 'edit_safeguarding':
                if(!church_admin_level_check('Kidswork') )
                {
                    echo '<div class="notice notice-danger"><h2>'.sprintf(__('You need "%1$s" permissions to access this page','church-admin'),__('Kidswork','church-admin') ).'</h2></div>';
                    return;
                }
                church_admin_module_dropdown('childrens-work'); 
                require_once(plugin_dir_path(dirname(__FILE__) ).'includes/kidswork.php');
                    church_admin_edit_safeguarding( $people_id);
                
            break;
            case 'safeguarding':
                if(!church_admin_level_check('Kidswork') )
                {
                    echo '<div class="notice notice-danger"><h2>'.sprintf(__('You need "%1$s" permissions to access this page','church-admin'),__('Kidswork','church-admin') ).'</h2></div>';
                    return;
                }
                church_admin_module_dropdown('childrens-work'); 
                require_once(plugin_dir_path(dirname(__FILE__) ).'includes/kidswork.php');
                church_admin_safeguarding_main();
                
            break;


                
            /*************************************
            *
            *		MEDIA
            *
            **************************************/
            case 'podcast':
            case 'media':
                if(!church_admin_level_check('Sermons') )
                {
                    echo '<div class="notice notice-danger"><h2>'.sprintf(__('You need "%1$s" permissions to access this page','church-admin'),__('Sermons','church-admin') ).'</h2></div>';
                    return;
                }
                require_once(plugin_dir_path(dirname(__FILE__) ).'includes/sermon-podcast.php');
                church_admin_module_dropdown('media');  
                echo'<h1>'.__('Sermon podcast files','church-admin').'</h1>';
                ca_podcast_list_files();
            break;
            case 'migrate_sermon_manager':
                if(!church_admin_level_check('Sermons') )
                {
                    echo '<div class="notice notice-danger"><h2>'.sprintf(__('You need "%1$s" permissions to access this page','church-admin'),__('Sermons','church-admin') ).'</h2></div>';
                    return;
                }
                church_admin_module_dropdown('media'); 
                require_once(plugin_dir_path(dirname(__FILE__) ).'includes/sermon-podcast.php');
                church_admin_migrate_sermon_manager();
            
            break;  
            case 'migrate_advanced_sermons':
                if(!church_admin_level_check('Sermons') )
                {
                    echo '<div class="notice notice-danger"><h2>'.sprintf(__('You need "%1$s" permissions to access this page','church-admin'),__('Sermons','church-admin') ).'</h2></div>';
                    return;
                }
                church_admin_module_dropdown('media'); 
                require_once(plugin_dir_path(dirname(__FILE__) ).'includes/sermon-podcast.php');
                    church_admin_migrate_advanced_sermons();
                
            break; 
            case 'set-sermon-page':
                if(!church_admin_level_check('Sermons') )
                {
                    echo '<div class="notice notice-danger"><h2>'.sprintf(__('You need "%1$s" permissions to access this page','church-admin'),__('Sermons','church-admin') ).'</h2></div>';
                    return;
                }
                church_admin_module_dropdown('media'); 
                require_once(plugin_dir_path(dirname(__FILE__) ).'includes/sermon-podcast.php');
                church_admin_set_sermon_page();
            break;
            case 'migrate_sermon_browser':
                if(!church_admin_level_check('Sermons') )
                {
                    echo '<div class="notice notice-danger"><h2>'.sprintf(__('You need "%1$s" permissions to access this page','church-admin'),__('Sermons','church-admin') ).'</h2></div>';
                    return;
                }
                church_admin_module_dropdown('media'); 
                require_once(plugin_dir_path(dirname(__FILE__) ).'includes/sermon-podcast.php');
                    church_admin_migrate_sermon_browser();
                
            break;          
            case'list_speakers':
                if(church_admin_level_check('Sermons') )
                {
                    require_once(plugin_dir_path(dirname(__FILE__) ).'includes/sermon-podcast.php');
                    church_admin_module_dropdown('media'); 
                    ca_podcast_list_speakers();
                }
            break;
            case'edit_speaker':
                if(!church_admin_level_check('Sermons') )
                {
                    echo '<div class="notice notice-danger"><h2>'.sprintf(__('You need "%1$s" permissions to access this page','church-admin'),__('Sermons','church-admin') ).'</h2></div>';
                    return;
                }
                church_admin_module_dropdown('media'); 
                require_once(plugin_dir_path(dirname(__FILE__) ).'includes/sermon-podcast.php');
                ca_podcast_edit_speaker( $id);
                    
            break;
            case'delete_speaker':
                if(!church_admin_level_check('Sermons') )
                {
                    echo '<div class="notice notice-danger"><h2>'.sprintf(__('You need "%1$s" permissions to access this page','church-admin'),__('Sermons','church-admin') ).'</h2></div>';
                    return;
                }
                church_admin_module_dropdown('media'); 
                require_once(plugin_dir_path(dirname(__FILE__) ).'includes/sermon-podcast.php');
                ca_podcast_delete_speaker( $id);
            break;
            case 'sermon-series':
            case'list_sermon_series':
                if(!church_admin_level_check('Sermons') )
                {
                    echo '<div class="notice notice-danger"><h2>'.sprintf(__('You need "%1$s" permissions to access this page','church-admin'),__('Sermons','church-admin') ).'</h2></div>';
                    return;
                }
                church_admin_module_dropdown('media'); 
                require_once(plugin_dir_path(dirname(__FILE__) ).'includes/sermon-podcast.php');
                        ca_podcast_list_series();
                
            break;
            case 'edit-series':
            case 'edit_sermon_series':
                if(!church_admin_level_check('Sermons') )
                {
                    echo '<div class="notice notice-danger"><h2>'.sprintf(__('You need "%1$s" permissions to access this page','church-admin'),__('Sermons','church-admin') ).'</h2></div>';
                    return;
                }
                church_admin_module_dropdown('media'); 
                require_once(plugin_dir_path(dirname(__FILE__) ).'includes/sermon-podcast.php');
                ca_podcast_edit_series( $id);
                
            break;
            case'delete_sermon_series':
                if(!church_admin_level_check('Sermons') )
                {
                    echo '<div class="notice notice-danger"><h2>'.sprintf(__('You need "%1$s" permissions to access this page','church-admin'),__('Sermons','church-admin') ).'</h2></div>';
                    return;
                }
                //check_admin_referer('delete_sermon_series');
                church_admin_module_dropdown('media'); 
                require_once(plugin_dir_path(dirname(__FILE__) ).'includes/sermon-podcast.php');
                ca_podcast_delete_series( $id);
            break;
            case'list_files':
                church_admin_module_dropdown('media'); 
                require_once(plugin_dir_path(dirname(__FILE__) ).'includes/sermon-podcast.php');
                ca_podcast_list_files();
            break;
            case 'upload-mp3':
            case'edit_file':
                if(!church_admin_level_check('Sermons') )
                {
                    echo '<div class="notice notice-danger"><h2>'.sprintf(__('You need "%1$s" permissions to access this page','church-admin'),__('Sermons','church-admin') ).'</h2></div>';
                    return;
                }
                church_admin_module_dropdown('media'); 
                require_once(plugin_dir_path(dirname(__FILE__) ).'includes/sermon-podcast.php');
                church_admin_edit_sermon( $id);
                
            break;
            case'delete_file':
                //check_admin_referer('delete_podcast_file');
                if(!church_admin_level_check('Sermons') )
                {
                    echo '<div class="notice notice-danger"><h2>'.sprintf(__('You need "%1$s" permissions to access this page','church-admin'),__('Sermons','church-admin') ).'</h2></div>';
                    return;
                }
                church_admin_module_dropdown('media'); 
                require_once(plugin_dir_path(dirname(__FILE__) ).'includes/sermon-podcast.php');
                ca_podcast_delete_file( $id);
            break;
            case 'refresh-podcast':
                church_admin_module_dropdown('media'); 
                require_once(plugin_dir_path(dirname(__FILE__) ).'includes/sermon-podcast.php');
                ca_podcast_xml();
                echo'<div class="notice notice-success"><h2>'.__('Podcast XML file updated','church-admin').'</h2></div>';
                ca_podcast_list_files();
            break;
            case'file_delete':
                //check_admin_referer('file_delete');
                if(!church_admin_level_check('Sermons') )
                {
                    echo '<div class="notice notice-danger"><h2>'.sprintf(__('You need "%1$s" permissions to access this page','church-admin'),__('Sermons','church-admin') ).'</h2></div>';
                    return;
                }
                church_admin_module_dropdown('media'); 
                require_once(plugin_dir_path(dirname(__FILE__) ).'includes/sermon-podcast.php');
                ca_podcast_file_delete( $file);
            break;
            case'file_add':
                //check_admin_referer('file_add');
                if(!church_admin_level_check('Sermons') )
                {
                    echo '<div class="notice notice-danger"><h2>'.sprintf(__('You need "%1$s" permissions to access this page','church-admin'),__('Sermons','church-admin') ).'</h2></div>';
                    return;
                }
                church_admin_module_dropdown('media'); 
                require_once(plugin_dir_path(dirname(__FILE__) ).'includes/sermon-podcast.php');
                ca_podcast_file_add( $file);
            break;
            case'check-files':
                if(!church_admin_level_check('Sermons') )
                {
                    echo '<div class="notice notice-danger"><h2>'.sprintf(__('You need "%1$s" permissions to access this page','church-admin'),__('Sermons','church-admin') ).'</h2></div>';
                    return;
                }
                church_admin_module_dropdown('media'); 
                require_once(plugin_dir_path(dirname(__FILE__) ).'includes/sermon-podcast.php');
                    ca_podcast_check_files();
                
            break;
            case'podcast':case 'media':
                if(!church_admin_level_check('Sermons') )
                {
                    echo '<div class="notice notice-danger"><h2>'.sprintf(__('You need "%1$s" permissions to access this page','church-admin'),__('Sermons','church-admin') ).'</h2></div>';
                    return;
                }
                church_admin_module_dropdown('media'); 
                require_once(plugin_dir_path(dirname(__FILE__) ).'includes/sermon-podcast.php');
                if(ca_podcast_xml() )
                {
                    $upload_dir = wp_upload_dir();
                    $path=$upload_dir['basedir'].'/sermons/';
                    $url=content_url().'/uploads/sermons/';
                    echo'<p>Podcast <a href="'.$url.'podcast.xml">feed</a> updated</p>';
                }
                
            break;
            case'podcast-settings':
                if(!church_admin_level_check('Sermons') )
                {
                    echo '<div class="notice notice-danger"><h2>'.sprintf(__('You need "%1$s" permissions to access this page','church-admin'),__('Sermons','church-admin') ).'</h2></div>';
                    return;
                }
                church_admin_module_dropdown('media'); 
                require_once(plugin_dir_path(dirname(__FILE__) ).'includes/podcast-settings.php');
                ca_podcast_settings();
                
            break;

            /*************************************
            *
            *		MEMBER TYPE
            *
            **************************************/
        case 'member-types':
                if(church_admin_level_check('Directory') )
                {
                    church_admin_module_dropdown('people'); 
                    require_once(plugin_dir_path(dirname(__FILE__) ).'includes/member_type.php');
                    church_admin_member_type();
                }
            break;
            case 'add-member-type':
            case 'edit-member-type':
            case 'church_admin_edit_member_type':
                if(church_admin_level_check('Directory') )
                {   
                    church_admin_module_dropdown('people'); 
                    require_once(plugin_dir_path(dirname(__FILE__) ).'includes/member_type.php');
                    church_admin_edit_member_type( $member_type_id);
                }
            break;
            case 'church_admin_delete_member_type':
            case 'delete-member-type':
                church_admin_module_dropdown('people'); 
                //check_admin_referer('delete-member-type');
                require_once(plugin_dir_path(dirname(__FILE__) ).'includes/member_type.php');
                church_admin_delete_member_type( $member_type_id);
            break;

            /*************************************
            *
            *		MINISTRIES
            *
            **************************************/
            case 'edit-ministry':
            case 'edit_ministry':
                if(!church_admin_level_check('Ministries') )
                {
                    echo '<div class="notice notice-danger"><h2>'.sprintf(__('You need "%1$s" permissions to access this page','church-admin'),__('Ministries','church-admin') ).'</h2></div>';
                    return;
                }
                church_admin_module_dropdown('ministries');
                require_once(plugin_dir_path(dirname(__FILE__) ).'includes/departments.php');
                church_admin_edit_ministry( $id);
                
            break;
            case 'delete_ministry':            
                if(!church_admin_level_check('Ministries') )
                {
                    echo '<div class="notice notice-danger"><h2>'.sprintf(__('You need "%1$s" permissions to access this page','church-admin'),__('Ministries','church-admin') ).'</h2></div>';
                    return;
                }
                church_admin_module_dropdown('ministries');
                require_once(plugin_dir_path(dirname(__FILE__) ).'includes/departments.php');
                church_admin_delete_ministry( $id);
                
            break;
            case 'ministries-list':
            case 'ministry_list':
                if(!church_admin_level_check('Ministries') )
                {
                    echo '<div class="notice notice-danger"><h2>'.sprintf(__('You need "%1$s" permissions to access this page','church-admin'),__('Ministries','church-admin') ).'</h2></div>';
                    return;
                }
                echo'<h1>'.__('Ministries','church-admin').'</h1>';
                church_admin_module_dropdown('ministries');
                    require_once(plugin_dir_path(dirname(__FILE__) ).'includes/departments.php');
                    church_admin_ministries_list();
                
            break;
            case 'view_ministry':            
                if(!church_admin_level_check('Ministries') )
                {
                    echo '<div class="notice notice-danger"><h2>'.sprintf(__('You need "%1$s" permissions to access this page','church-admin'),__('Ministries','church-admin') ).'</h2></div>';
                    return;
                }
                church_admin_module_dropdown('ministries');
                require_once(plugin_dir_path(dirname(__FILE__) ).'includes/departments.php');
                    church_admin_view_ministry( $id);
                
            break;
            case 'volunteers':
                if(!church_admin_level_check('Ministries') )
                {
                    echo '<div class="notice notice-danger"><h2>'.sprintf(__('You need "%1$s" permissions to access this page','church-admin'),__('Ministries','church-admin') ).'</h2></div>';
                    return;
                }
                church_admin_module_dropdown('ministries');
                require_once(plugin_dir_path(dirname(__FILE__) ).'includes/volunteer.php');
                echo church_admin_volunteer_display();
                
            break;

            /*************************************
            *
            *		ROTA
            *
            **************************************/

            case 'show-cron':
                if(!church_admin_level_check('Rota') )
                {
                    echo '<div class="notice notice-danger"><h2>'.sprintf(__('You need "%1$s" permissions to access this page','church-admin'),__('Schedule','church-admin') ).'</h2></div>';
                    return;
                }
                church_admin_module_dropdown('rota');
                require_once(plugin_dir_path(dirname(__FILE__) ).'includes/rota.new.php');
                church_admin_cron_check();
                
            break;
            case'view-rota':
            case 'church_admin_rota_list':
            case 'rota_list':
            case 'rota':
                if(!church_admin_level_check('Rota') )
                {
                    echo '<div class="notice notice-danger"><h2>'.sprintf(__('You need "%1$s" permissions to access this page','church-admin'),__('Schedule','church-admin') ).'</h2></div>';
                    return;
                }
                church_admin_module_dropdown('rota');
                require_once(plugin_dir_path(dirname(__FILE__) ).'includes/rota.new.php');
                church_admin_rota_list( $service_id,$mtg_type);
                
            break;
            case 'add-three-months':
                if(!church_admin_level_check('Rota') )
                {
                    echo '<div class="notice notice-danger"><h2>'.sprintf(__('You need "%1$s" permissions to access this page','church-admin'),__('Schedule','church-admin') ).'</h2></div>';
                    return;
                }
                church_admin_module_dropdown('rota');
                require_once(plugin_dir_path(dirname(__FILE__) ).'includes/rota.new.php');
                church_admin_three_months_rota( $service_id,$mtg_type);
            break;
            case 'ministry-rota':

                require_once(plugin_dir_path(dirname(__FILE__) ).'includes/rota.new.php');
                echo church_admin_edit_ministry_rota($mtg_type,$service_id);
            break;
            case 'edit_rota': 	
                if(!church_admin_level_check('Rota') )
                {
                    echo '<div class="notice notice-danger"><h2>'.sprintf(__('You need "%1$s" permissions to access this page','church-admin'),__('Schedule','church-admin') ).'</h2></div>';
                    return;
                }
                church_admin_module_dropdown('rota');
                require_once(plugin_dir_path(dirname(__FILE__) ).'includes/rota.new.php');
                church_admin_edit_rota( $rota_date,$mtg_type,$service_id);
                
            break;
            case 'delete_rota':
                if(!church_admin_level_check('Rota') )
                {
                    echo '<div class="notice notice-danger"><h2>'.sprintf(__('You need "%1$s" permissions to access this page','church-admin'),__('Schedule','church-admin') ).'</h2></div>';
                    return;
                }
                church_admin_module_dropdown('rota');
                require_once(plugin_dir_path(dirname(__FILE__) ).'includes/rota.new.php');
                church_admin_delete_rota( $rota_date,$mtg_type,$_GET['service_id'] );
                
            break;
            case 'email_rota':
                if(!church_admin_level_check('Rota') )
                {
                    echo '<div class="notice notice-danger"><h2>'.sprintf(__('You need "%1$s" permissions to access this page','church-admin'),__('Schedule','church-admin') ).'</h2></div>';
                    return;
                }
                church_admin_module_dropdown('rota');
                require_once(plugin_dir_path(dirname(__FILE__) ).'includes/rota.new.php');
                church_admin_email_rota( $service_id,$rota_date);
                
            break;
            case 'auto_email_test':
                church_admin_auto_email_rota( $service_id,NULL);
            break;
            /*************************************
            *
            *		ROTA SETTINGS
            *
            **************************************/
            case 'not-available':
                if(!church_admin_level_check('Rota') )
                {
                    echo '<div class="notice notice-danger"><h2>'.sprintf(__('You need "%1$s" permissions to access this page','church-admin'),__('Schedule','church-admin') ).'</h2></div>';
                    return;
                }
                church_admin_module_dropdown('rota');
                require_once(plugin_dir_path(dirname(__FILE__) ).'display/not-available.php');
                echo church_admin_not_available();
            break;
            case 'rota-settings':
                case'church_admin_rota_settings_list':
                if(!church_admin_level_check('Rota') )
                {
                    echo '<div class="notice notice-danger"><h2>'.sprintf(__('You need "%1$s" permissions to access this page','church-admin'),__('Schedule','church-admin') ).'</h2></div>';
                    return;
                }
                church_admin_module_dropdown('rota');
                require_once(plugin_dir_path(dirname(__FILE__) ).'includes/rota_settings.php');
                church_admin_rota_settings_list();
                
            break;
            case 'edit-rota-job':
            case 'church_admin_edit_rota_settings':
                if(!church_admin_level_check('Rota') )
                {
                    echo '<div class="notice notice-danger"><h2>'.sprintf(__('You need "%1$s" permissions to access this page','church-admin'),__('Schedule','church-admin') ).'</h2></div>';
                    return;
                }
                church_admin_module_dropdown('rota');
                require_once(plugin_dir_path(dirname(__FILE__) ).'includes/rota_settings.php');
                church_admin_edit_rota_settings( $id);
                
            break;
            case 'church_admin_delete_rota_settings':
                //check_admin_referer('delete_rota_settings');
                if(!church_admin_level_check('Rota') )
                {
                    echo '<div class="notice notice-danger"><h2>'.sprintf(__('You need "%1$s" permissions to access this page','church-admin'),__('Schedule','church-admin') ).'</h2></div>';
                    return;
                }
                church_admin_module_dropdown('rota');
                require_once(plugin_dir_path(dirname(__FILE__) ).'includes/rota_settings.php');
                church_admin_delete_rota_settings( $id);
            break;
            case 'test-cron-rota':
                if(!church_admin_level_check('Rota') )
                {
                    echo '<div class="notice notice-danger"><h2>'.sprintf(__('You need "%1$s" permissions to access this page','church-admin'),__('Schedule','church-admin') ).'</h2></div>';
                    return;
                }
                church_admin_module_dropdown('rota');
                church_admin_auto_email_rota( $_GET['service_id'],NULL);
            break;
            case 'rota-auto-email':
            case 'auto-email-rota':
                if(!church_admin_level_check('Rota') )
                {
                    echo '<div class="notice notice-danger"><h2>'.sprintf(__('You need "%1$s" permissions to access this page','church-admin'),__('Schedule','church-admin') ).'</h2></div>';
                    return;
                }
                church_admin_module_dropdown('rota');
                require_once(plugin_dir_path(dirname(__FILE__) ).'includes/rota.new.php');
                church_admin_rota_auto_email();
                
            break;
            case 'rota-auto-sms':
                case 'auto-sms-rota':
                    if(!church_admin_level_check('Rota') )
                    {
                        echo '<div class="notice notice-danger"><h2>'.sprintf(__('You need "%1$s" permissions to access this page','church-admin'),__('Schedule','church-admin') ).'</h2></div>';
                        return;
                    }
                    church_admin_module_dropdown('rota');
                    require_once(plugin_dir_path(dirname(__FILE__) ).'includes/rota.new.php');
                    church_admin_rota_auto_sms();
                    
                break;
            case 'email-rota':
                if(!church_admin_level_check('Rota') )
                {
                    echo '<div class="notice notice-danger"><h2>'.sprintf(__('You need "%1$s" permissions to access this page','church-admin'),__('Schedule','church-admin') ).'</h2></div>';
                    return;
                }
                church_admin_module_dropdown('rota');
                require_once(plugin_dir_path(dirname(__FILE__) ).'includes/rota.new.php');
                    if(!empty( $_GET['service_id'] )&&!empty( $_GET['date'] ) )  {church_admin_email_rota( $service_id=1,$date);}
                    else church_admin_email_rota_form();
                
            break; 
            case'pdf-rota':
                if(!church_admin_level_check('Rota') )
                {
                    echo '<div class="notice notice-danger"><h2>'.sprintf(__('You need "%1$s" permissions to access this page','church-admin'),__('Schedule','church-admin') ).'</h2></div>';
                    return;
                }
                church_admin_module_dropdown('rota');
                require_once(plugin_dir_path(dirname(__FILE__) ).'includes/rota.new.php');
                    church_admin_rota_pdf_menu();
                
            
            break;
            case'csv-rota':
                if(!church_admin_level_check('Rota') )
                {
                    echo '<div class="notice notice-danger"><h2>'.sprintf(__('You need "%1$s" permissions to access this page','church-admin'),__('Schedule','church-admin') ).'</h2></div>';
                    return;
                }
                church_admin_module_dropdown('rota');
                require_once(plugin_dir_path(dirname(__FILE__) ).'includes/rota.new.php');
                    church_admin_rota_csv_menu();
                
            
            break;
            case 'sms-rota':
                if(!church_admin_level_check('Rota') )
                {
                    echo '<div class="notice notice-danger"><h2>'.sprintf(__('You need "%1$s" permissions to access this page','church-admin'),__('Schedule','church-admin') ).'</h2></div>';
                    return;
                }
                church_admin_module_dropdown('rota');
                require_once(plugin_dir_path(dirname(__FILE__) ).'includes/rota.new.php');           
                church_admin_sms_rota();
               
            break;
            /*************************************
            *
            *		SERVICES
            *
            **************************************/
            case'services':case'service-list':case 'service_list':case'services-list':
                echo'<h1>'.__('Services','church-admin').'</h2>';
                if(!church_admin_level_check('Service') )
                {
                    echo '<div class="notice notice-danger"><h2>'.sprintf(__('You need "%1$s" permissions to access this page','church-admin'),__('Service','church-admin') ).'</h2></div>';
                    return;
                }
                church_admin_module_dropdown('services');
                require_once(plugin_dir_path(dirname(__FILE__) ).'includes/services.php');
                echo church_admin_service_list( $message);
            
                
            break; 
            case'sites':
                case'site-list':
                echo'<h1>'.__('Sites','church-admin').'</h2>';
                if(!church_admin_level_check('Service') )
                {
                    echo '<div class="notice notice-danger"><h2>'.sprintf(__('You need "%1$s" permissions to access this page','church-admin'),__('Service','church-admin') ).'</h2></div>';
                    return;
                }
                church_admin_module_dropdown('services');
                require_once(plugin_dir_path(dirname(__FILE__) ).'includes/sites.php');
                    
                    church_admin_site_list();
                
                
            break; 
            case 'add-service':
            case 'edit-service':
            case  'edit_service':
                if(!church_admin_level_check('Service') )
                {
                    echo '<div class="notice notice-danger"><h2>'.sprintf(__('You need "%1$s" permissions to access this page','church-admin'),__('Service','church-admin') ).'</h2></div>';
                    return;
                }
                church_admin_module_dropdown('services');
                require_once(plugin_dir_path(dirname(__FILE__) ).'includes/services.php');  church_admin_edit_service( $id);
                
            break;
            case  'service-prebooking':
                if(!church_admin_level_check('Service') )
                {
                    echo '<div class="notice notice-danger"><h2>'.sprintf(__('You need "%1$s" permissions to access this page','church-admin'),__('Service','church-admin') ).'</h2></div>';
                    return;
                }
                church_admin_module_dropdown('services');
                require_once(plugin_dir_path(dirname(__FILE__) ).'includes/covid-prebooking.php');  
                echo church_admin_covid_attendance_list();
                
            break;
            case 'delete_service_booking'  :
                if(!church_admin_level_check('Service') )
                {
                    echo '<div class="notice notice-danger"><h2>'.sprintf(__('You need "%1$s" permissions to access this page','church-admin'),__('Service','church-admin') ).'</h2></div>';
                    return;
                }
                church_admin_module_dropdown('services');
                    require_once(plugin_dir_path(dirname(__FILE__) ).'includes/covid-prebooking.php');
                    echo church_admin_delete_service_booking( $id);
            break;    
            case 'delete_bubble_booking'  :
                if(!church_admin_level_check('Service') )
                {
                    echo '<div class="notice notice-danger"><h2>'.sprintf(__('You need "%1$s" permissions to access this page','church-admin'),__('Service','church-admin') ).'</h2></div>';
                    return;
                }
                        church_admin_module_dropdown('services');
                    require_once(plugin_dir_path(dirname(__FILE__) ).'includes/covid-prebooking.php');
                    echo church_admin_delete_bubble_booking( $id);
            break;  
            case 'edit_bubble_booking'  :
                if(!church_admin_level_check('Service') )
                {
                    echo '<div class="notice notice-danger"><h2>'.sprintf(__('You need "%1$s" permissions to access this page','church-admin'),__('Service','church-admin') ).'</h2></div>';
                    return;
                }
                church_admin_module_dropdown('services');
                    require_once(plugin_dir_path(dirname(__FILE__) ).'includes/covid-prebooking.php');
                    echo church_admin_edit_bubble_booking( $id);
            break;
            case 'add_bubble_booking_to_service'  :
                if(!church_admin_level_check('Service') )
                {
                    echo '<div class="notice notice-danger"><h2>'.sprintf(__('You need "%1$s" permissions to access this page','church-admin'),__('Service','church-admin') ).'</h2></div>';
                    return;
                }
                church_admin_module_dropdown('services');
                require_once(plugin_dir_path(dirname(__FILE__) ).'includes/covid-prebooking.php');
                echo church_admin_add_bubble_booking_to_service( $id);
            break;
            case 'add_bubble_booking'  :
                    
                    require_once(plugin_dir_path(dirname(__FILE__) ).'display/covid-prebooking.php');
                    echo'<h2>'.__('Add service pre-booking','church-admin').'</h2>';

                    echo church_admin_covid_attendance( $service_id,'bubbles',10,365,get_option('admin_email') );
                    require_once(plugin_dir_path(dirname(__FILE__) ).'includes/covid-prebooking.php'); 
                    if(!empty( $_POST) ) echo church_admin_covid_attendance_list();
            break;
            case  'delete_service'://check_admin_referer('delete_service'); 
                if(!church_admin_level_check('Service') )
                {
                    echo '<div class="notice notice-danger"><h2>'.sprintf(__('You need "%1$s" permissions to access this page','church-admin'),__('Service','church-admin') ).'</h2></div>';
                    return;
                }
                church_admin_module_dropdown('services');
                require_once(plugin_dir_path(dirname(__FILE__) ).'includes/services.php');  
                church_admin_delete_service( $id);
            
            break;
            case 'delete_site':
                if(!church_admin_level_check('Service') )
                {
                    echo '<div class="notice notice-danger"><h2>'.sprintf(__('You need "%1$s" permissions to access this page','church-admin'),__('Service','church-admin') ).'</h2></div>';
                    return;
                }
                church_admin_module_dropdown('services');
                require_once(plugin_dir_path(dirname(__FILE__) ).'includes/sites.php'); 
                church_admin_delete_site( $site_id);
            break;
            case 'edit-site':
            case 'edit_site':
                if(!church_admin_level_check('Service') )
                {
                    echo '<div class="notice notice-danger"><h2>'.sprintf(__('You need "%1$s" permissions to access this page','church-admin'),__('Service','church-admin') ).'</h2></div>';
                    return;
                }
                church_admin_module_dropdown('services');
                require_once(plugin_dir_path(dirname(__FILE__) ).'includes/sites.php'); 
                    church_admin_edit_site( $site_id);
                
            break;
            /*************************************
            *
            *       SESSIONS
            *
            *************************************/
            case 'sessions':                
                if(!church_admin_level_check('Sessions') )
                {
                    echo '<div class="notice notice-danger"><h2>'.sprintf(__('You need "%1$s" permissions to access this page','church-admin'),__('Sessions','church-admin') ).'</h2></div>';
                    return;
                }
                require_once(plugin_dir_path(dirname(__FILE__) ).'includes/sessions.php');
                echo'<h1>'.__('Sessions','church-admin').'</h1>';
                echo church_admin_sessions();
            break;
                
            /*************************************
            *
            *		SMALL GROUPS
            *
            **************************************/
            case 'smallgroups-cleanup':
            case 'cleanup-groups':
                if(!church_admin_level_check('Small Groups') )
                {
                    echo '<div class="notice notice-danger"><h2>'.sprintf(__('You need "%1$s" permissions to access this page','church-admin'),__('Small Groups','church-admin') ).'</h2></div>';
                    return;
                }
                wp_enqueue_script('church_admin_google_maps_api');
                wp_enqueue_script('church_admin_sg_map_script');
                require_once(plugin_dir_path(dirname(__FILE__) ).'includes/small_groups.php');
                
                echo church_admin_smallgroups_cleanup();
                
                church_admin_module_dropdown('groups');
               
                require_once(plugin_dir_path(dirname(__FILE__) ).'display/small-group-list.php');
                echo church_admin_small_group_list(1,13,TRUE); 
                
            break;
            case 'show-groups':
                if(!church_admin_level_check('Small Groups') )
                {
                    echo '<div class="notice notice-danger"><h2>'.sprintf(__('You need "%1$s" permissions to access this page','church-admin'),__('Small Groups','church-admin') ).'</h2></div>';
                    return;
                }
                church_admin_module_dropdown('groups');
                require_once(plugin_dir_path(dirname(__FILE__) ).'display/small-groups.php');
                echo church_admin_frontend_small_groups(NULL,FALSE);
                
            break;
            case 'unattached':
                if(!church_admin_level_check('Small Groups') )
                {
                    echo '<div class="notice notice-danger"><h2>'.sprintf(__('You need "%1$s" permissions to access this page','church-admin'),__('Small Groups','church-admin') ).'</h2></div>';
                    return;
                }
                church_admin_module_dropdown('groups');
                require_once(plugin_dir_path(dirname(__FILE__) ).'includes/small_groups.php');
                church_admin_unattached_list();
            break;
            case 'groups':
                if(!church_admin_level_check('Small Groups') )
                {
                    echo '<div class="notice notice-danger"><h2>'.sprintf(__('You need "%1$s" permissions to access this page','church-admin'),__('Small Groups','church-admin') ).'</h2></div>';
                    return;
                }
                    wp_enqueue_script('church_admin_sg_map_script');
                    wp_enqueue_script('church_admin_google_maps_api');
                    
                    echo'<h1>'.__('Small groups','church-admin').'</h1>';
                    church_admin_module_dropdown('groups');
                    require_once(plugin_dir_path(dirname(__FILE__) ).'includes/small_groups.php');
                    require_once(plugin_dir_path(dirname(__FILE__) ).'display/small-group-list.php');
                    echo church_admin_small_group_list(1,1,TRUE);  
            break;
            case 'smallgroup-show-pdf-form':
                if(!church_admin_level_check('Small Groups') )
                {
                    echo '<div class="notice notice-danger"><h2>'.sprintf(__('You need "%1$s" permissions to access this page','church-admin'),__('Small Groups','church-admin') ).'</h2></div>';
                    return;
                }
                church_admin_module_dropdown('groups');    
                require_once(plugin_dir_path(dirname(__FILE__) ).'includes/small_groups.php');
                church_admin_smallgroup_PDF_form();
                
            break;
            case 'small-group-metrics':
                if(!church_admin_level_check('Small Groups') )
                {
                    echo '<div class="notice notice-danger"><h2>'.sprintf(__('You need "%1$s" permissions to access this page','church-admin'),__('Small Groups','church-admin') ).'</h2></div>';
                    return;
                }
                church_admin_module_dropdown('groups');
                    require_once(plugin_dir_path(dirname(__FILE__) ).'includes/small_groups.php');
                    church_admin_smallgroup_metrics();
                
            break;
            
            case 'delete-all-groups':
                if(!church_admin_level_check('Small Groups') )
                {
                    echo '<div class="notice notice-danger"><h2>'.sprintf(__('You need "%1$s" permissions to access this page','church-admin'),__('Small Groups','church-admin') ).'</h2></div>';
                    return;
                }
                church_admin_module_dropdown('groups');   
                if(!empty( $_POST['sure'] ) )
                {
                    require_once(plugin_dir_path(dirname(__FILE__) ).'includes/small_groups.php');
                    church_admin_delete_all_small_groups();
                    echo '<p><a class="button-primary" href="'.wp_nonce_url("admin.php?page=church_admin/index.php&section=small_groups&amp;action=edit_small_group",'edit_small_group').'">'.__('Add a small group','church-admin').'</a></p>';
                
                }
                else
                {
                    echo'<form action="" method="post"><h2><strong>'.__("Are you sure you want to delete all the groups?",'church-admin').'</strong></h2><p><input type="hidden" name="sure" value="yes"/><input type="submit"  class="button-secondary" value="'.__('Yes, delete all the','church-admin').'"/></p></form>';
                }
                
                
            
                
            break;	
            case 'smallgroup-structure':case 'small-group-structure':
                if(!church_admin_level_check('Small Groups') )
                {
                    echo '<div class="notice notice-danger"><h2>'.sprintf(__('You need "%1$s" permissions to access this page','church-admin'),__('Small Groups','church-admin') ).'</h2></div>';
                    return;
                }
                church_admin_module_dropdown('groups');
                require_once(plugin_dir_path(dirname(__FILE__) ).'includes/small_groups.php');
                echo church_admin_small_group_structure();
            break;
            case 'oversight-list':    
                if(!church_admin_level_check('Small Groups') )
                {
                    echo '<div class="notice notice-danger"><h2>'.sprintf(__('You need "%1$s" permissions to access this page','church-admin'),__('Small Groups','church-admin') ).'</h2></div>';
                    return;
                }
                church_admin_module_dropdown('groups');
                require_once(plugin_dir_path(dirname(__FILE__) ).'includes/small_groups.php');            
                    echo church_admin_oversight_list();
            
            break;
            case'remove_from_smallgroup':
                //check_admin_referer('remove');
                church_admin_module_dropdown('groups');
                if(!church_admin_level_check('Small Groups') )
                {
                    echo '<div class="notice notice-danger"><h2>'.sprintf(__('You need "%1$s" permissions to access this page','church-admin'),__('Small Groups','church-admin') ).'</h2></div>';
                    return;
                }
                
                require_once(plugin_dir_path(dirname(__FILE__) ).'includes/small_groups.php');
                church_admin_remove_from_smallgroup( $people_id,$smallgroup_id);
            break;
            case'whosin':
                ////check_admin_referer('whosin');
                if(!church_admin_level_check('Small Groups') )
                {
                    echo '<div class="notice notice-danger"><h2>'.sprintf(__('You need "%1$s" permissions to access this page','church-admin'),__('Small Groups','church-admin') ).'</h2></div>';
                    return;
                }
                require_once(plugin_dir_path(dirname(__FILE__) ).'includes/small_groups.php'); echo church_admin_whosin( $id);
            break;
            case  'edit_small_group':
            case 'edit-group':
            case 'add-group':
                ////check_admin_referer('edit-group');
                if(!church_admin_level_check('Small Groups') )
                {
                    echo '<div class="notice notice-danger"><h2>'.sprintf(__('You need "%1$s" permissions to access this page','church-admin'),__('Small Groups','church-admin') ).'</h2></div>';
                    return;
                }
                church_admin_module_dropdown('groups'); 
                require_once(plugin_dir_path(dirname(__FILE__) ).'includes/small_groups.php'); 
                echo church_admin_edit_small_group( $id);
            break;
            case  'delete_small_group':
                //check_admin_referer('delete_small_group');
                
            
                if(!church_admin_level_check('Small Groups') )
                {
                    echo '<div class="notice notice-danger"><h2>'.sprintf(__('You need "%1$s" permissions to access this page','church-admin'),__('Small Groups','church-admin') ).'</h2></div>';
                    return;
                }
                require_once(plugin_dir_path(dirname(__FILE__) ).'includes/small_groups.php'); 
                echo church_admin_delete_small_group( $id);
            break;
            case 'church_admin_small_groups':
                if(!church_admin_level_check('Small Groups') )
                {
                    echo '<div class="notice notice-danger"><h2>'.sprintf(__('You need "%1$s" permissions to access this page','church-admin'),__('Small Groups','church-admin') ).'</h2></div>';
                    return;
                }
                require_once(plugin_dir_path(dirname(__FILE__) ).'includes/small_groups.php'); 
                echo church_admin_small_groups();
            break;

            /*************************************
            *
            *		SETTINGS
            *
            **************************************/
            case 'choose-filters':
                if(current_user_can('manage_options') )
                {
                    church_admin_module_dropdown('settings');
                    require_once(plugin_dir_path(dirname(__FILE__) ).'includes/settings.php');                 
                    church_admin_choose_filters();
                }
            break;
            case 'delete-mailchimp':
                delete_option('church_admin_mailchimp');
                update_option('church_admin_email_method','native');
                echo '<div class="notice notice-success"><h2>'.__('MailChimp settings deleted','church-admin').'</h2><p>'.__('Email method set to natice WordPress','church-admin').'</p></div>';
                require_once(plugin_dir_path(dirname(__FILE__) ).'includes/settings.php'); 
                church_admin_email_settings();

            break;
            case 'toggle-debug-mode':
                if(current_user_can('manage_options') )
                {
                    church_admin_module_dropdown('settings');
                   
                   
                   
                    church_admin_settings_callback();
                }
                
            break;
            case 'clear-debug':
                church_admin_module_dropdown('settings');
                $upload_dir = wp_upload_dir();
	            $debug_path=$upload_dir['basedir'].'/church-admin-cache/debug_log.php';
                if(file_exists( $debug_path) )unlink( $debug_path);
                echo'<div class="notice notice-success"><h2>'.__("Debug log file deleted",'church-admin').'</h2></div>';
                church_admin_settings_callback();
            break;
            case 'debug-log':
                if(current_user_can('manage_options') )
                {
                    church_admin_module_dropdown('settings');
                    require_once(plugin_dir_path(dirname(__FILE__) ).'includes/settings.php');
                    church_admin_debug_log();
                }
        break;
            case 'restrict-access':
                if(current_user_can('manage_options') )
                {
                    church_admin_module_dropdown('settings');
                    require_once(plugin_dir_path(dirname(__FILE__) ).'includes/settings.php');
                    echo church_admin_restrict_access();
                }
        break;
            case 'people-types':
                if(current_user_can('manage_options') )
                {
                    church_admin_module_dropdown('settings');
                    require_once(plugin_dir_path(dirname(__FILE__) ).'includes/settings.php');
                    church_admin_people_types_list();
                }
        break;
        case'modules':
        case 'choose-modules':
                if(current_user_can('manage_options') )
                {
                    
                    church_admin_module_dropdown('settings');
                    require_once(plugin_dir_path(dirname(__FILE__) ).'includes/settings.php');           
                    church_admin_modules();
                }
            break;
            case 'marital-status':
                if(current_user_can('manage_options') )
                {
                    church_admin_module_dropdown('settings');
                    require_once(plugin_dir_path(dirname(__FILE__) ).'includes/settings.php');           
                    church_admin_marital_status();
                }
            break;       
            case 'permissions':
                if(current_user_can('manage_options') )
                {
                    church_admin_module_dropdown('settings');
                    require_once(plugin_dir_path(dirname(__FILE__) ).'includes/permissions.php');
                    church_admin_permissions();
                }
            break;
            case 'roles':
                if(current_user_can('manage_options') )
                {            
                    church_admin_module_dropdown('settings');
                    require_once(plugin_dir_path(dirname(__FILE__) ).'includes/settings.php');
                    church_admin_roles();
                }
            break;
            case 'email-settings':
                if(current_user_can('manage_options') )
                {            
                    church_admin_module_dropdown('settings');
                    require_once(plugin_dir_path(dirname(__FILE__) ).'includes/settings.php');       
                    church_admin_email_settings();    
                }
            break;
            case 'smtp-settings':
                if(current_user_can('manage_options') )
                {            
                    church_admin_module_dropdown('settings');
                    require_once(plugin_dir_path(dirname(__FILE__) ).'includes/settings.php');       
                    church_admin_smtp_settings();    
                }
            break;
            case 'bible-version':
                if(current_user_can('manage_options') )
                {              
                    church_admin_module_dropdown('settings');
                    require_once(plugin_dir_path(dirname(__FILE__) ).'app/app-admin.php');
                church_admin_bible_version();
                }
            break;
            case 'general-settings':
            case 'church_admin_settings':
            case 'settings':
                if(current_user_can('manage_options') )
                {
                    church_admin_module_dropdown('settings');
                    require_once(plugin_dir_path(dirname(__FILE__) ).'includes/settings.php');
                    church_admin_general_settings();
                }
            break;

            case 'global-communications-settings':
                if(current_user_can('manage_options') )
                {
                    church_admin_module_dropdown('settings');
                    require_once(plugin_dir_path(dirname(__FILE__) ).'includes/settings.php');    
                    church_admin_global_communications_settings();
                }
            break;
            case 'shortcode-generator':
                church_admin_module_dropdown('settings');
                require_once(plugin_dir_path(dirname(__FILE__) ).'includes/shortcode-generator.php');
                echo church_admin_shortcode_generator();
            break;
            case'edit_people_type':
                church_admin_module_dropdown('settings');
                require_once(plugin_dir_path(dirname(__FILE__) ).'includes/settings.php');
                echo church_admin_edit_people_type( $ID);
            
            break;
            case'delete_people_type':require_once(plugin_dir_path(dirname(__FILE__) ).'includes/settings.php');echo church_admin_delete_people_type( $ID);echo church_admin_people_types_list();break;
            /*************************************
            *
            *       UNITS
            *
            **************************************/
            case 'units':
                if(!church_admin_level_check('Units') )
                {
                    echo '<div class="notice notice-danger"><h2>'.sprintf(__('You need "%1$s" permissions to access this page','church-admin'),__('Units','church-admin') ).'</h2></div>';
                    return;
                }
                require_once(plugin_dir_path(dirname(__FILE__) ).'includes/units.php');
                church_admin_units_list();
            break;
            case 'edit-unit':case 'add-unit':
                if(!church_admin_level_check('Units') )
                {
                    echo '<div class="notice notice-danger"><h2>'.sprintf(__('You need "%1$s" permissions to access this page','church-admin'),__('Units','church-admin') ).'</h2></div>';
                    return;
                }
                require_once(plugin_dir_path(dirname(__FILE__) ).'includes/units.php');
                church_admin_edit_unit( $unit_id);
            break;
            case 'show-subunits':
                if(!church_admin_level_check('Units') )
                {
                    echo '<div class="notice notice-danger"><h2>'.sprintf(__('You need "%1$s" permissions to access this page','church-admin'),__('Units','church-admin') ).'</h2></div>';
                    return;
                }
                require_once(plugin_dir_path(dirname(__FILE__) ).'includes/units.php');
                church_admin_show_subunits( $unit_id);
            break;
            case 'edit-subunit':
                if(!church_admin_level_check('Units') )
                {
                    echo '<div class="notice notice-danger"><h2>'.sprintf(__('You need "%1$s" permissions to access this page','church-admin'),__('Units','church-admin') ).'</h2></div>';
                    return;
                }
                require_once(plugin_dir_path(dirname(__FILE__) ).'includes/units.php');
                church_admin_edit_subunit( $unit_id,$subunit_id);
            break;
            case 'delete-unit':
                if(!church_admin_level_check('Units') )
                {
                    echo '<div class="notice notice-danger"><h2>'.sprintf(__('You need "%1$s" permissions to access this page','church-admin'),__('Units','church-admin') ).'</h2></div>';
                    return;
                }
                require_once(plugin_dir_path(dirname(__FILE__) ).'includes/units.php');
                church_admin_delete_unit( $unit_id);
            break;    
            case 'delete-subunit':
                if(!church_admin_level_check('Units') )
                {
                    echo '<div class="notice notice-danger"><h2>'.sprintf(__('You need "%1$s" permissions to access this page','church-admin'),__('Units','church-admin') ).'</h2></div>';
                    return;
                }
                require_once(plugin_dir_path(dirname(__FILE__) ).'includes/units.php');
                church_admin_delete_subunit( $unit_id,$subunit_id);
            break;
            /*************************************
            *
            *       VOLUNTEERS
            *
            **************************************/
            case 'approve_volunteer':
                if(!church_admin_level_check('Ministries') )
                {
                    echo '<div class="notice notice-danger"><h2>'.sprintf(__('You need "%1$s" permissions to access this page','church-admin'),__('Ministries','church-admin') ).'</h2></div>';
                    return;
                }
                require_once(plugin_dir_path(dirname(__FILE__) ).'includes/volunteer.php');
                church_admin_volunteer_approval( $people_id,$ministry_id);
            break;
            case 'decline_volunteer':
                require_once(plugin_dir_path(dirname(__FILE__) ).'includes/volunteer.php');
                church_admin_volunteer_decline( $people_id,$ministry_id);
            break;    
            /*************************************
            *
            *		DEFAULT
            *
            **************************************/
            case 'people':
            default:
            if(church_admin_level_check('Directory') )
            {
                require_once(plugin_dir_path(dirname(__FILE__) ).'includes/directory.php');
                church_admin_module_dropdown('people'); 
                church_admin_search_form();
                church_admin_people_main();
            }else{echo'<p>'.__("You don't have permissions for this page",'church-admin').'</p>';}break;

        }

    }
 
    
}
function church_admin_directory_issues_fixer()
{
        global $wpdb;
        
        $upload_dir = wp_upload_dir();
        $path=$upload_dir['basedir'].'/church-admin-cache/';
        $url=$upload_dir['baseurl'].'/church-admin-cache/';
       
        /******************************************************************
         * Remove Empty households
         ******************************************************************/
        echo'<h2>'.__('Check for empty households','church-admin').'</h2>'."\r\n";
        $households=$wpdb->get_results('SELECT * FROM '.CA_HOU_TBL);
        if(!empty( $households) )
        {
            $x=0;
            foreach( $households AS $household)
            {
                $people=$wpdb->get_var('SELECT COUNT(*) FROM '.CA_PEO_TBL.' WHERE household_id="'.(int)$household->household_id.'"');
                if ( empty( $people) )
                {
                    $wpdb->query('DELETE FROM '.CA_HOU_TBL.' WHERE household_id="'.(int)$household->household_id.'"');
                    $x++;
                }
            }
            if(!empty( $x) )
            {
                echo '<p>'.esc_html(sprintf(__('%1$s empty households deleted','church-admin'),(int)$x) ).'</p>';
            }
            else echo '<p>'.__('No empty households found','church-admin').'<span class="dashicons dashicons-yes"  style="color:green"></span></p>';
        }
        else
        {
            echo '<p>'.__('No households found','church-admin').'<span class="dashicons dashicons-no"  style="color:red"></span></p>';
        }

        /******************************************************************
         * FIX people records that have no houshold or 0 household_id
         ******************************************************************/
        echo'<h2>'.__('Check for people who have become detached from a household','church-admin').'</h2>'."\r\n";
        $people=$wpdb->get_results('SELECT * FROM '.CA_PEO_TBL.' WHERE household_id=0');
        if(!empty( $people) )
        {
            $zeroCount=$wpdb->num_rows;
            echo'<p>'.sprintf(__('%1$s people detached from a  household','church-admin'),(int)$zeroCount).'</p>'."\r\n";
            foreach( $people AS $person)
            {
                $wpdb->query('INSERT INTO '.CA_HOU_TBL.' (address) VALUES ("")');
                $household_id=$wpdb->insert_id;
                $wpdb->query('UPDATE '.CA_PEO_TBL.' SET household_id="'.(int)$household_id.'" WHERE people_id="'.(int)$person->people_id.'"');
                echo'<p>'.sprintf(__('Fixed %1$s','church-admin'),church_admin_formatted_name( $person) ).'<span class="dashicons dashicons-yes" style="color:green"></span></p>'."\r\n";
            }

        }else{echo'<p>'.__('No people detached from a household detected','church-admin').'<span class="dashicons dashicons-yes" style="color:green"></span></p>'."\r\n";}
        /******************************************************************
         * MEMBER TYPE ISSUES
         ******************************************************************/
        echo'<h2>'.__('Check for Member type issues','church-admin').'</h2>'."\r\n";
        $member_types_details_results=$wpdb->get_results('SELECT * FROM '.CA_MTY_TBL);
        if(!empty( $member_types_details_results) )
        {
            //form posted so fix invalid member types
            if(!empty( $_POST['fix-member-types'] ) )
            {
                if(!empty( $_POST['invalidMT'] ) )
                {
                    foreach( $_POST['invalidMT'] AS $key=>$old_mt_id)
                    {
                        $wpdb->query('UPDATE '.CA_PEO_TBL.' SET member_type_id="'.(int)$_POST['new_mt_id'].'" WHERE member_type_id="'.(int)$old_mt_id.'"');
                    }
                }
            }
            $select=$mtSQL=array();
            foreach( $member_types_details_results AS $mtdRow)
            {
                $mtSQL[]=' member_type_id!="'.(int)$mtdRow->member_type_id.'" ';
                $select[]='<option value="'.(int)$mtdRow->member_type_id.'">'.esc_html( $mtdRow->member_type).'</option>';
                $count=$wpdb->get_var('SELECT COUNT(*) FROM '.CA_PEO_TBL.' WHERE member_type_id="'.(int)$mtdRow->member_type_id.'"');
                echo'<p>'.sprintf(__('%1$s people with member type %2$s','church-admin'),(int)$count,esc_html( $mtdRow->member_type) ).'</p>'."\r\n";
            }
            //check for people with no member type
            $count=0;
            $invalidMTs=$wpdb->get_results('SELECT member_type_id,COUNT(*) AS count FROM '.CA_PEO_TBL.' WHERE ('.implode(' AND ',$mtSQL).') GROUP BY member_type_id');
            if(!empty( $invalidMTs) )
            {
                echo '<h3>'.__('You have people in the directory of unknown member type, that needs fixing','church-admin').'<span class="dashicons dashicons-no" style="color:red"></span></h3>'."\r\n";
                echo'<form action="" method="POST">';
                foreach( $invalidMTs AS $invalid)
                {
                    echo'<input type="hidden" name="invalidMT[]" value="'.(int)$invalid->member_type_id.'"/>'."\r\n";
                    $count+=(int)$invalid->count;
                }
                echo'<table class="form-table><tr><th scope="row">'.sprintf(__('Move %1$s people to a valid member type','church-admin'),$count).'</th><select name="new_mt_id">';
                echo implode("\r\n",$select);
                echo'</select></td></tr>'."\r\n";
                echo'<tr><td colspan=2><input type="hidden" name="fix-member-types" value="YES"/><input type="submit" class="button-primary"/></td></tr></table>'."\r\n";
            }else echo'<p>'.__('There are no people with unknown member types stored','church-admin').'<span class="dashicons dashicons-yes" style="color:green"></span></p>'."\r\n";
        }
        /******************************************************************
         * HEAD OF HOUSEHOLD ISSUES
         ******************************************************************/
        $householdsNeedingFixing=array();
        $households=$wpdb->get_results('SELECT household_id FROM '.CA_HOU_TBL);
        if(!empty( $households) )
        {
            /**************************************************
             *  Check and Fix head of household missing issue
             **************************************************/
            echo'<h2>'.__('Checking for issues with head of household not set ','church-admin').'</h2>'."\r\n";
            foreach( $households AS $household)
            {
                $people_id=$wpdb->get_var('SELECT people_id FROM '.CA_PEO_TBL.' WHERE head_of_household=1 AND household_id="'.(int)$household->household_id.'"');
                
                if ( empty( $people_id) )$householdsNeedingFixing[]=$household->household_id;
            }
            if ( empty( $householdsNeedingFixing) )
            {
                echo'<p>'.__('All households have a head of household set','church-admin').'<span class="dashicons dashicons-yes" style="color:green"></span></p>'."\r\n";
            }
            else
            {
                
                $countHouseholds=count( $householdsNeedingFixing);
                echo'<p>'.sprintf(__('%1$s households do not have a head of household set. Fixing now','church-admin'),$countHouseholds).'</p>'."\r\n";
                foreach( $householdsNeedingFixing AS $key=>$household_id)
                {
                    $peopleInHousehold=$wpdb->get_results('SELECT * FROM '.CA_PEO_TBL.' WHERE household_id="'.(int)$household_id.'" ORDER BY people_order ASC, people_type_id ASC, sex DESC');
                    
                //church_admin_debug(print_r( $peopleInHousehold,TRUE) );
                    if(!empty( $peopleInHousehold) )
                    {
                        //church_admin_debug( $peopleInHousehold);
                        if( $wpdb->num_rows==1)
                        {
                            //one person household
                            $wpdb->query('UPDATE '.CA_PEO_TBL.' SET head_of_household=1 WHERE household_id="'.(int)$household_id.'" ');
                        
                            echo'<p>'.__('One person household head of household fixed','church-admin').'<span class="dashicons dashicons-yes"  style="color:green"></span></p>'."\r\n";
                        }
                        else
                        {
                            $wpdb->query('UPDATE '.CA_PEO_TBL.' SET head_of_household=1 WHERE people_id="'.(int)$peopleInHousehold[0]->people_id.'" ');
                            echo'<p>'.__('Multiple person household head of household fixed','church-admin').'<span class="dashicons dashicons-yes" style="color:green"></span></p>'."\r\n";
                        }
                    }
                }
            }
        }
        /******************************************************************
         * Geocoder issues
         ******************************************************************/
        echo'<h2>'.__('Google Maps API and address geocoding ','church-admin').'</h2>';
        $api=get_option('church_admin_google_api_key');
        if( $api)
        {
            $geocodeRequiredCount=$wpdb->get_var('SELECT COUNT(*) FROM '.CA_HOU_TBL.' WHERE address!=", , , ," AND address!=", , ," AND address!="" AND (geocoded=0 OR lat="" OR lng="")');
            if(!empty( $geocodeRequiredCount) )
            {
                $updateButton='<a class="button-primary" href="admin.php?page=church_admin%2Findex.php&action=bulk_geocode&section=people">'.__('Update mapping now','church-admin').'</a>'."\r\n";
				echo'<h2>'.sprintf(_n('%s household needs its address geocoding','%s households need their addresses geocoding',$geocodeRequiredCount,'church-admin'),$geocodeRequiredCount).'</h2><p>'.$updateButton.'</p>'."\r\n";
            }else{
                echo'<p>'.__('All addresses already geocoded','church-admin').'<span class="dashicons dashicons-yes"  style="color:green"></span></p>';
            }
        }else{
            echo'<p>'.__('No Google maps API key set yet','church-admin').'</p>';
            echo'<p><a href="https://www.churchadminplugin.com/tutorials/google-api-key/">Tutorial</a></p>';
        }
         /******************************************************************
         * e164 mobile
         ******************************************************************/
        echo'<h2>'.__('Checking all mobiles also have e164 version saved ','church-admin').'</h2>';
        $noe164=$wpdb->get_results('SELECT * FROM '.CA_PEO_TBL.' WHERE (mobile IS NOT NULL AND mobile!="") AND (e164cell = "" OR e164cell IS NULL)');
        $ISO=get_option('church_admin_sms_iso');
        if(!empty($noe164) && !empty( $ISO ) )
        {
            $x=0;
            foreach($noe164 AS $row)
            {
                $e164 = church_admin_e164($row->mobile);
                $wpdb->query( 'UPDATE '.CA_PEO_TBL.' SET e164cell= "'.esc_sql($e164).'" WHERE people_id="'.(int)$row->people_id.'"');
                $x++;
            }
            echo '<p>'.esc_html( sprintf(__('%1$s mobiles also saved in e164 format', 'church-admin' ), (int)$x ) ).'<span class="dashicons dashicons-yes"  style="color:green"></span></p>';
        }else{
            echo '<p>'.esc_html(__('All mobile phone numbers already also saved in e164 format for SMS','church-admin')).'<span class="dashicons dashicons-yes"  style="color:green"></span></p>';
        }

         /******************************************************************
         * Check if missing from any group including unattached
         ******************************************************************/
        echo'<h2>'.__('Checking all people are in small group or unattached.','church-admin').'</h2>';
         $people=$wpdb->get_results('SELECT * FROM '.CA_PEO_TBL.' WHERE people_id NOT IN (SELECT people_id FROM '.CA_MET_TBL.' WHERE meta_type="smallgroup");');
        if($people){
            $count=$wpdb->num_rows;
            $values=array();
            foreach($people AS $row){
                $values[]='("1","'.(int)$row->people_id.'","smallgroup","'.wp_date('Y-m-d').'")';
            }
            $wpdb->query('INSERT INTO '.CA_MET_TBL.' (ID,people_id,meta_type,meta_date) VALUES '.implode(",",$values));
           
            echo'<p>'.esc_html(sprintf(__('%1$s people who were in no small group, have been marked as unattached.','church-admin'),$count)).'<span class="dashicons dashicons-yes"  style="color:green"></span></p>';
        }
        else
        {
            echo '<p>'.__('Everyone is in a small group or unattached','church-admin').'<span class="dashicons dashicons-yes"  style="color:green"></span></p>';
        }
        /******************************************************************
         * Remove meta table duplicates
         ******************************************************************/
        echo'<h2>'.__('Remove people duplicates in smallgroups, ministries and classes','church-admin').'</h2>';
        $sql='DELETE  t1 FROM '.CA_MET_TBL.' t1 INNER JOIN '.CA_MET_TBL.' t2 WHERE t1.meta_id < t2.meta_id AND t1.people_id = t2.people_id AND t1.ID = t2.ID AND t1.meta_type=t2.meta_type;';
        $wpdb->query($sql);
        echo '<p>'.esc_html( sprintf( __('%1$s duplicates removed','church-admin'),$wpdb->rows_affected)).'<span class="dashicons dashicons-yes"  style="color:green"></span></p>';
        echo'<h2>'.__('Remove orphaned entries  in smallgroups, ministries and classes','church-admin').'</h2>';
        $wpdb->query('DELETE FROM '.CA_MET_TBL.' WHERE people_id REGEXP "^-?[0-9]+$" AND people_id NOT IN (SELECT people_id FROM '.CA_PEO_TBL.');');
        echo '<p>'.esc_html( sprintf( __('%1$s orphan entries removed','church-admin'),$wpdb->rows_affected)).'<span class="dashicons dashicons-yes"  style="color:green"></span></p>';

        /******************************************************************
         * GDPR ISSUES
         ******************************************************************/
        echo'<h2>'.__('Checking some people set to show on address list and have set a data protection reason ','church-admin').'</h2>';
        $countShowMe=$wpdb->get_var('SELECT COUNT(people_id) FROM '.CA_PEO_TBL.' WHERE show_me=1 AND gdpr_reason!=""');
        if ( empty( $countShowMe) )
        {
            echo'<p>'.__('Nobody has set "show me" on the address list','church-admin').'<span class="dashicons dashicons-no" style="color:red"></span></p>';
        }
        else echo'<p>'.sprintf(__('%1$s people have set themselves to show me on the address list','church-admin'),$countShowMe).'<span class="dashicons dashicons-yes" style="color:green"></span></p>';
        /******************************************************************
         * SHOW POSSIBLE DUPLICATES
         ******************************************************************/ 
        echo'<h2>'.__('Checking for duplicate entries','church-admin').'</h2>';
        $sql='SELECT first_name, COUNT(first_name) AS first_name_count,last_name, COUNT(last_name) AS last_name_count FROM '.CA_PEO_TBL.' GROUP BY first_name,last_name HAVING COUNT(first_name)>1 AND COUNT(last_name)>1';
        $results=$wpdb->get_results( $sql);
       
        if(!empty( $results) )
        {
            foreach( $results AS $row)
            {
                echo '<h3>'.sprintf(__('Possible duplication of %1$s, which occurs %2$s times','church-admin'),esc_html( $row->first_name.' '.$row->last_name),(int)$row->last_name_count).'</h3>';
                //grab those details
                $duplicateResult=$wpdb->get_results('SELECT a.*,b.address,b.last_updated AS householdUpdated FROM '.CA_PEO_TBL.' a, '.CA_HOU_TBL.' b WHERE a.household_id=b.household_id AND a.first_name="'.esc_sql( $row->first_name).'" AND last_name="'.esc_sql( $row->last_name).'" ORDER BY people_id ASC');
                $dupeNo=1;
                if(!empty( $duplicateResult) )
                {
                    
                    $theader='<tr><th>'.__('Merge','church-admin').'</th><th>'.__('Delete','church-admin').'</th><th>'.__('Name','church-admin').'</th><th>'.__('Cell','church-admin').'</th><th>'.__('Address','church-admin').'</th><th>'.__('Display household','church-admin').'</th><th>'.__('Last Updated','church-admin').'</th></tr>';
                    echo'<table class="widefat striped bordered"><thead>'.$theader.'</thead><tbody>';
                    foreach( $duplicateResult AS $dupe)
                    {
                        if( $dupeNo==1)
                        { 
                            $merge=__('Original','church-admin');
                            $firstPeopleID=$dupe->people_id;
                        }
                        else
                        {
                            $merge='<a target="_blank" href="'.wp_nonce_url('admin.php?page=church_admin/index.php&amp;action=merge-people&amp;people_id1='.(int)$firstPeopleID.'&people_id2='.$dupe->people_id,'merge-people').'">'.__('Merge','church-admin').'</a>';
                        }
                        $delete='<a target="_blank" onclick="return confirm(\'Are you sure you want to delete '.esc_html( $dupe->first_name).' '.esc_html( $dupe->last_name).'?\');" href="'.wp_nonce_url('admin.php?page=church_admin/index.php&amp;action=delete_people&amp;people_id='.$dupe->people_id,'delete_people').'">'.__('Delete','church-admin').'</a>';
                        $name=church_admin_formatted_name( $dupe);
                        if(!empty( $dupe->cell) )  {$cell=esc_html( $dupe->cell);}else{$cell='&nbsp;';}
                        if(!empty( $dupe->address) )  {$address=esc_html( $dupe->address);}else{$address='&nbsp;';}
                        if(!empty( $row->updated_by) )
                        {
                            $updatedBy=$wpdb->get_var('SELECT CONCAT_WS(" ",first_name,last_name) FROM '.CA_PEO_TBL.' WHERE user_id="'.(int)$dupe->updated_by.'"');
                        }
                        $updated=sprintf(__('Person updated %1$s, Household updated %2$s','church-admin'),mysql2date(get_option('date_format'),$dupe->last_updated),mysql2date(get_option('date_format'),$dupe->householdUpdated) );
                        $householdCount=$wpdb->get_var('SELECT COUNT(*) FROM '.CA_PEO_TBL.' WHERE household_id="'.(int)$dupe->household_id.'"');
                        $display='<a target="_blank" href="admin.php?page=church_admin/index.php&amp;action=display_household&section=people&household_id='.(int)$dupe->household_id.'">'.sprintf(__('Display household (%1$s people)','church-admin'),$householdCount).'</a>';
                        echo'<tr><td>'.$merge.'</td><td>'.$delete.'</td><td>'.$name.'</td><td>'.$cell.'</td><td>'.$address.'</td><td>'.$display.'</td><td>'.$updated.'</td></tr>';
                        $dupeNo++;
                    }
                    echo'</tbody><tfoot>'.$theader.'</tfoot></table>';
                }
            }
        }
        else
        {
            echo'<p>'.__("No duplicates found",'church-admin').'<span class="dashicons dashicons-yes"  style="color:green"></span></p>'."\r\n";
        }
        /******************************************************************
         * SHOW HOUSEHOLDS WHERE LAST NAME IS DIFFERENT
         ******************************************************************/ 
        echo'<h2>'.__('Checking for households with different last names','church-admin').'</h2>'."\r\n";
        echo'<p>'.__('This may show households that have got joined by mistake','church-admin').'</p>'."\r\n";
        $households=$wpdb->get_results('SELECT * FROM '.CA_HOU_TBL);
        if(!empty( $households) )
        {
            $count=0;
            $diffLastNameDisplay='';
            foreach( $households AS $household)
            {
                $check=$wpdb->get_results('SELECT DISTINCT last_name FROM '.CA_PEO_TBL.' WHERE household_id="'.(int)$household->household_id.'" AND ignore_last_name_check=0');
                
                if(!empty( $check)&$wpdb->num_rows>1)
                {
                    $lName=array();
                    foreach( $check AS $diffS)
                    {
                        $lName[]=$diffS->last_name;
                    }
                    $count++;
                    $diffLastNameDisplay.='<p id="h'.(int)$household->household_id.'"> <a target="_blank" href="admin.php?page=church_admin/index.php&amp;action=display_household&section=people&household_id='.(int)$household->household_id.'">'.$count.') '.sprintf(__('Please check this household with last names - %1$s','church-admin'),esc_html(implode(", ",$lName) )).'</a><button class="ignore-last-name button-secondary" data-household-id="'.(int)$household->household_id.'">'.__('Ignore different last names in future','church-admin').'</button></p>'."\r\n";
                    
                }
            }
            if(!empty( $diffLastNameDisplay) )
            {
                echo '<p><strong>'.sprintf(__('%1$s households need checking','church-admin'),$count).'</strong></p>';
                echo $diffLastNameDisplay;
            }else{echo'<p>'.__('No households need checking','church-admin').'<span class="dashicons dashicons-yes" style="color:green"></span></p>';}
        }
        $nonce = wp_create_nonce("ignore-last-name");
        echo '<script>
        
        jQuery(function( $)  {
            $(".ignore-last-name").click(function(e)
            {
                console.log("Ignore clicked");
                e.preventDefault();
                var household_id=$(this).data("household-id");
                var data = {
                    "action":  "church_admin",
                    "method": "ignore-last-name",
                    "household_id":household_id,
                    "nonce":"'.$nonce.'"
                };
                console.log(data);
                $.ajax({
                    url: ajaxurl,
                    type: "post",
                    data:data,
                    success: function( response ) {
                        console.log(response);
                        $("#h"+response).hide();
                    },
                });
            });
        });</script>';
}
function church_admin_get_custom_fields()
{
    global $wpdb;
    $results=$wpdb->get_results('SELECT * FROM '.CA_CUST_TBL);
    if ( empty( $results) ) return array();
    $out=array();
    foreach( $results AS $row)
    {
        $out[$row->ID]=(array)$row;
        $out[$row->ID]['sanitized-name']=sanitize_title($row->name);
    }    
    return $out;
}
function church_admin_address_list_issues_fixer( $member_type_ids)
{
    global $wpdb;
    $output='<div class="notice notice-danger"><h2>'.__('Address list issues detect and fix').'</h2>';

    //first check GDPR and show me!
    $output.='<h3>'.__('Checking some people set to show on address list and have set a data protection reason ','church-admin').'</h3>';
    $countShowMe=$wpdb->get_var('SELECT COUNT(people_id) FROM '.CA_PEO_TBL.' WHERE show_me=1 AND gdpr_reason!=""');
    if ( empty( $countShowMe) )
    {
        $output.='<p>'.__('Nobody has set "show me" on the address list','church-admin').'<span class="dashicons dashicons-no" style="color:red"></span></p>';
    }
    else $output.='<p>'.sprintf(__('%1$s people have set themselves to show_me','church-admin'),$countShowMe).'<span class="dashicons dashicons-yes" style="color:green"></span></p>';
    //second check and fix head of households
    $householdsNeedingFixing=array();
    $households=$wpdb->get_results('SELECT household_id FROM '.CA_HOU_TBL);
    if(!empty( $households) )
    {
        /**************************************************
         *  Check and Fix head of household missing issue
         **************************************************/
        $output.='<h3>'.__('Checking for issues with head of household not set ','church-admin').'</h3>';
        foreach( $households AS $household)
        {
            $people_id=$wpdb->get_var('SELECT people_id FROM '.CA_PEO_TBL.' WHERE head_of_household=1 AND household_id="'.(int)$household->household_id.'"');
            
            if ( empty( $people_id) )$householdsNeedingFixing[]=$household->household_id;
        }
        if ( empty( $householdsNeedingFixing) )
        {
            $output.='<p>'.__('All households have a head of household set','church-admin').'<span class="dashicons dashicons-yes" style="color:green"></span></p>';
        }
        else
        {
            
            $countHouseholds=count( $householdsNeedingFixing);
            $output.='<p>'.sprintf(__('%1$s households do not have a head of household set. Fixing now','church-admin'),$countHouseholds).'</p>';
            foreach( $householdsNeedingFixing AS $key=>$household_id)
            {
                $peopleInHousehold=$wpdb->get_results('SELECT * FROM '.CA_PEO_TBL.' WHERE household_id="'.(int)$household_id.'" ORDER BY people_order ASC, people_type_id ASC, sex DESC');
                $output.=$wpdb->last_query;
                //church_admin_debug(print_r( $peopleInHousehold,TRUE) );
                if(!empty( $peopleInHousehold) )
                {
                    //church_admin_debug( $peopleInHousehold);
                    if( $wpdb->num_rows==1)
                    {
                        //one person household
                        $wpdb->query('UPDATE '.CA_PEO_TBL.' SET head_of_household=1 WHERE household_id="'.(int)$household_id.'" ');
                       
                        $output.='<p>'.__('One person household head of household fixed','church-admin').'<span class="dashicons dashicons-yes"  style="color:green"></span></p>';
                    }
                    else
                    {
                        $wpdb->query('UPDATE '.CA_PEO_TBL.' SET head_of_household=1 WHERE people_id="'.(int)$peopleInHousehold[0]->people_id.'" ');
                        $output.='<p>'.__('Multiple person household head of household fixed','church-admin').'<span class="dashicons dashicons-yes" style="color:green"></span></p>';
                    }
                }
            }
        }
        /**************************************************
         *  Check member types
         **************************************************/
        $output.='<h3>'.__('Check member type','church-admin').'</h3>';
       
        if ( empty( $member_type_ids) )
        {
            $output.='<p>'.__('Directory set to show any member type','church-admin').'</p>';
        }
        else
        {
            $output.='<p>'.__('Directory set to show certain member types, checking...','church-admin').'</p>';
            foreach( $member_type_ids AS $key=>$member_type_id)
            {
                $member_type_detail=$wpdb->get_row('SELECT * FROM '.CA_MTY_TBL.' WHERE member_type_id="'.(int)$member_type_id.'"');
                if ( empty( $member_type_detail) )  {$output.='<p>'.sprintf(__('Member Type  "%1$s" does not exist, so will not be found','church-admin'),(int)$member_type_id).'</p>';}
                else
                {
                    $peopleCount=$wpdb->get_var('SELECT * FROM '.CA_PEO_TBL.' WHERE member_type_id="'.(int)$member_type_id.'"');
                    if(!empty( $peopleCount) )
                    {
                        $output.='<p>'.sprintf(__('People found for member type "%1$s" ID  %2$s','church-admin'),esc_html( $member_type_detail->member_type),(int)$member_type_id).'<span class="dashicons dashicons-yes" style="color:green"></span></p>';
                    }
                    else
                    {
                        $output.='<p>'.sprintf(__('No People found for member type "%1$s" ID  %2$s','church-admin'),esc_html( $member_type_detail->member_type),(int)$member_type_id).'<span class="dashicons dashicons-no" style="color:red"></span></p>';
                    }
                }

            }
        }
    }
    return $output;
}


/*
function church_admin_plugin_notice() {
	
	global $current_user;
	
	$user_id = $current_user->ID;
	
	if (!get_user_meta( $user_id, 'church_admin_plugin_notice_ignore') ) {
		
		echo '<div class="updated notice notice-warning"><h2>'. __('Please note that service prebooking is now defaulted to login only','church-admin') .'</h2><p>'.__('Add loggedin=FALSE to the shortcode or uncheck "Require login?" in the block options.','church-admin').'</p><p> <a href="'.add_query_arg( 'dismiss-ca-service-notice', 'true').'">Dismiss</a></p></div>';
		
	}
	
}
add_action('admin_notices', 'church_admin_plugin_notice');
	
function church_admin_plugin_notice_ignore() {
	
	global $current_user;
	
	$user_id = $current_user->ID;
	
	if (isset( $_GET['dismiss-ca-service-notice'] ) ) {
		
		add_user_meta( $user_id, 'church_admin_plugin_notice_ignore', 'true', true);
		
	}
	
}
add_action('admin_init', 'church_admin_plugin_notice_ignore');
*/
function church_admin_directory_title_name( $people)
{
    $directory=$first_names=$last_names=array();
    //$people should be the result of a people result for a household_id
    foreach( $people AS $row)
  		{
  			if( $row->head_of_household==1)$directory['last_name']=$row->last_name;
  			if( $row->people_type_id==1)
  			{
  				$first_names[]=$row->first_name;
				$last_names[]=implode(" ",array_filter(array( $row->prefix,$row->last_name) ));
				if(!empty( $row->nickname) )  {$nickname='('.$row->nickname.')';}else{$nickname="";}
  				$row->name=implode(" ",array_filter(array( $row->first_name,$row->middle_name,$nickname,$row->prefix,$row->last_name) ));
  				$adults[]=$row;
  			}
  			else
  			{
				if(!empty( $row->nickname) )  {$nickname='('.$row->nickname.')';}else{$nickname="";}
  				$row->name=implode(" ",array_filter(array( $row->first_name,$row->middle_name,$nickname,$row->prefix,$row->last_name) ));
  				$children[]=$row;
  			}
  		}

  		if(count( $last_names)==1)
  		{
  			$directory['directory_name']=$first_names[0].' '.$last_names[0];
  		}
  		elseif(count( $last_names) != count(array_unique( $last_names) ))
  		{//same last names
  			$directory['directory_name']=implode(" &amp; ",$first_names).' '.end( $last_names);
  		}
  		else
  		{//different last names
            $directory_names=array();
  			for ( $x=0; $x < count( $last_names ); $x++ ){
                if(!empty($last_names[$x])) {
                    $directory_names[] = $first_names[$x].' '.$last_names[$x];
                }
            }    
  			$directory['directory_name']=implode(" &amp; ",$directory_names);

  		}
        return $directory['directory_name'];
}
/************************
 * Manual Advert
 ************************/
function church_admin_manual_advert()
{
    $licence=get_option('church_admin_app_new_licence');
    if(!empty($licence) && $licence == 'subscribed'){return;}
    echo '<div class="ca-boxes" id="data-protection">';
    echo    '<div class="ca-boxes-header ca-blue">'."\r\n";
    echo '<p><span class="dashicons dashicons-heart ca-dashicons"></span></p>'."\r\n";
    echo'<h3>'.__('Support Church Admin Plugin','church-admin').'</h3>'."\r\n";
    echo'</div>'."\r\n";
    echo '<div class="ca-boxes-content">';
  
    
   
    echo"<script type='text/javascript' src='https://storage.ko-fi.com/cdn/widget/Widget_2.js'></script><script type='text/javascript'>kofiwidget2.init('Support Me on Ko-fi', '#29abe0', 'Z8Z3IRVTU');kofiwidget2.draw();</script> ";
    echo'<p style="text-align:center"><a target="_blank" href="https://www.lulu.com/en/gb/shop/andy-moyle/church-admin-plugin-manual/paperback/product-7jqzpg.html"><img src="'.plugins_url('/images/church-admin-manual-book.jpg',dirname(__FILE__) ).'" alt="Church Admin Manual"/></a><br />Full Colour Printed Manual</p>';
    echo'<p  style="text-align:center"><a  target="_blank" class="button-primary" href="https://www.lulu.com/en/gb/shop/andy-moyle/church-admin-plugin-manual/paperback/product-7jqzpg.html">'.__('Buy now','church-admin').'</a></p>';
    
    echo'<p>Mailing List (and free PDF manual)</p>';
    echo'<form id="mc-embedded-subscribe-form" class="validate" action="//thegatewaychurch.us2.list-manage.com/subscribe/post?u=de873ad10bb6b43b54744b951&amp;id=848214cef0" method="post" name="mc-embedded-subscribe-form" novalidate="" target="_blank">
    <div id="mc_embed_signup_scroll">
    <div class="indicates-required">
    <div class="form-group"><label for="mce-EMAIL">Email Address</label><br>
    <input id="mce-EMAIL" class="required email" name="EMAIL" type="email" value=""></div>
    <div class="form-group"><label for="mce-FNAME">First Name </label><br>
    <input id="mce-FNAME" class="" name="FNAME" type="text" value=""></div>
    <div id="mce-responses" class="clear">
    <div id="mce-error-response" class="response" style="display: none;">&nbsp;</div>
    <div id="mce-success-response" class="response" style="display: none;">&nbsp;</div>
    </div>
    <p><!-- real people should not fill this in and expect good things - do not remove this or risk form bot signups--></p>
    <div style="position: absolute; left: -5000px;" aria-hidden="true"><input tabindex="-1" name="b_de873ad10bb6b43b54744b951_b49dffa6fa" type="text" value=""></div>
    <div class="clear"><input id="mc-embedded-subscribe" class="btn btn-primary btn-lg" name="subscribe" type="submit" value="Subscribe"></div>
    </div>
    </div>
    </form>
    <p><script type="text/javascript" src="//s3.amazonaws.com/downloads.mailchimp.com/js/mc-validate.js"></script><script type="text/javascript">(function( $) {window.fnames = new Array(); window.ftypes = new Array();fnames[0]="EMAIL";ftypes[0]="email";fnames[1]="FNAME";ftypes[1]="text";fnames[2]="LNAME";ftypes[2]="text";}(jQuery) );var $mcj = jQuery.noConflict(true);</script><br>
    <!--End mc_embed_signup-->';
    echo'</div></div>';
}
/************************
 * GDPR Check
 ************************/
function church_admin_new_look_gdpr()
{

    echo '<div class="ca-boxes" id="data-protection">';
    echo    '<div class="ca-boxes-header ca-red">'."\r\n";
    echo '<p><span class="dashicons dashicons-shield ca-dashicons"></span></p>'."\r\n";
    echo'<h3>'.__('Data Protection','church-admin').'</h3>'."\r\n";
    echo'</div>'."\r\n";
    echo '<div class="ca-boxes-content">';
    church_admin_gdpr_check();
    echo'</div></div>';
}



function church_admin_gdpr_check()
{
    global $wpdb;
     /*************************************
    *
    *   data protection section
   	*
    *************************************/
    echo'<p><a class="button-primary" href="admin.php?page=church_admin/index.php&action=check-directory-issues">'.__('Check for directory issues','church-admin').'</a></p>';
    $sql=' SELECT COUNT(*) FROM '.CA_PEO_TBL.' a, '.CA_HOU_TBL.' b  WHERE a.household_id=b.household_id AND  email!=""  AND (gdpr_reason IS NULL OR gdpr_reason="") ';
    $noncompliant=$wpdb->get_var( $sql);
    if( $noncompliant>0)
    {
            
   			echo '<h2 class="gdpr-minimise">'.sprintf(__('Data Protection %1$s entry not confirmed','church-admin'),$noncompliant).'</h2>';
   			echo '<div id="data-protection" ><p>'.__("UK & EU churches must comply with the General Data Protection regulations from 25th May 2018. They include making sure people are aware of what personal data you store for them and that you have obtained their permission to email, sms or mail them. Common sense, stuff, so I'm making the requirement to confirm permission mandatory from that date to send email and sms. You can obtain verbal permission and edit entries or send an email to everyone with a confirmation link.",'church-admin');
   			echo'<p><a class="button-secondary" href="'.wp_nonce_url('admin.php?page=church_admin/index.php&amp;action=gdpr-email-test&amp;section=people','gdpr-email').'">'.__("Send GDPR test email to yourself",'church-admin').'</a>&nbsp;';
   			echo'<p><a class="button-primary" href="'.wp_nonce_url('admin.php?page=church_admin/index.php&amp;action=gdpr-email&amp;section=people','gdpr-email').'" onclick="return confirm(\'Are you sure?\')">'.__("Send GDPR email to everyone who isn't confirmed already",'church-admin').'</a></p>';
   			echo'<p><a class="button-primary" href="'.site_url('?ca_download=gdpr-pdf').'">'.__("Print GDPR forms for everyone who isn't confirmed already",'church-admin').'</a></p>';

   			echo '<p>'.sprintf(__(' %1$s people (with email addresses) have not confirmed','church-admin'),intval( $noncompliant) ).'</p>';
			church_admin_not_confirmed_gdpr();
   			echo'<p><strong>'.__('This notice will contine to display until everyone has confimed','church-admin').'</strong></p>';
   			echo'<p>'.__('This is bad practice and illegal in the EU from 25th May 2018....','church-admin').'<a href="'.wp_nonce_url('admin.php?page=church_admin/index.php&amp;action=gdpr_bulk_confirm&amp;section=people','gdpr_bulk_confirm').'">'.__("Confirm everyone",'church-admin').'</a></p>';
   			echo'</div>';
	}else{echo'<p>'.__('All directory entries have confirmed for data protection','church-admin').'</p>';}
    //end of data protection section


}
function church_admin_not_confirmed_gdpr()
{
	global $wpdb;
	$result=$wpdb->get_results(' SELECT CONCAT_WS(" ", a.first_name, a.last_name) AS name, a.last_name,a.people_id, a.email ,b.* FROM '.CA_PEO_TBL.' a, '.CA_HOU_TBL.' b  WHERE a.household_id=b.household_id AND  email!=""  AND (gdpr_reason IS NULL OR gdpr_reason="")  GROUP BY email ');
	if(!empty( $result) )
	{
			echo'<h3>'.__('These people have not responded to GDPR confirmation','church-admin').'</h3>';
			foreach( $result AS $row)
			{
				echo'<p>'.esc_html( $row->name).'</p>';
			}
	}
}

function church_admin_user_check( $person,$app=FALSE)
{
    global $wpdb;
    if( $app)  {$appClass=' button action ';}else{$appClass='';}
    //church_admin_debug(print_r( $person,TRUE) );
    if(!empty( $person->email) )
    {//user account only relevant for people with email
        if(!empty( $person->user_id) )
        {
            $user_info=get_userdata( $person->user_id);
            if(!empty( $user_info) )
            {
                $user=$user_info->user_login;
                //church_admin_debug("User id");
            }
            else
            {
                $user=__('Invalid user ID stored','church-admin').'<br /><span data-tab="create-user" class="ca_create_user userinfo'.(int)$person->people_id.' '.$appClass.'" data-peopleid="'.(int)$person->people_id.'" >'.__('Create user account','church-admin').'</span>';
            }
                
        }
        else
        {
            //check if a user exists for this email
            $user_id=email_exists( $person->email);
            $unassigned_user=get_userdata( $user_id);
            if(!empty( $user_id) )
            {
                $user='<span class="ca_connect_user userinfo'.(int)$person->people_id.' '.$appClass.'" data-tab="connect-user-account" data-peopleid="'.(int)$person->people_id.'" data-userid="'.(int)$user_id.'">'.__('Connect','church-admin').' '.$unassigned_user->user_login.'</span>';
                //church_admin_debug("Unassigned user");

            }
            else 
            {
                if(!empty( $person->gdpr_reason) )
                {
                    $user='<span  data-tab="create-user" class="ca_create_user userinfo'.(int)$person->people_id.' '.$appClass.'" data-peopleid="'.(int)$person->people_id.'" >'.__('Create user account','church-admin').'</span>';
                    //church_admin_debug("GDPR reason");
                }
                else
                {    
                    $user=__("No GDPR reason,<br /> so can't create user",'church-admin');
                    //church_admin_debug("No GDPR reason");
                }
            }
        }
    }
    else
    {
        $user=__("No email address,<br /> so can't create user",'church-admin');
        //church_admin_debug("No email");
    }
    return $user;
}

function church_admin_disable_srcset( $sources ) {
    return false;
    }

function church_admin_update_user_meta( $people_id,$user_id)
{
    global $wpdb;
    if ( empty( $people_id) ) return;
    if ( empty( $user_id) ) return;
    $data=$wpdb->get_row('SELECT * FROM '.CA_PEO_TBL.' WHERE people_id="'.(int)$people_id.'" AND user_id="'.(int)$user_id.'"');
    if ( empty( $data) )return;
    update_user_meta( $user_id,'first_name',$data->first_name);
    update_user_meta( $user_id,'last_name',$data->last_name);
    update_user_meta( $user_id,'display_name',$data->first_name.' '.$data->first_name);
    if(!empty( $data->bio) )update_user_meta( $user_id,'description',$data->bio);
}    

function church_admin_center_coordinates( $table)
{
    global $wpdb;
   
    $coords=new StdClass();
    
    /*
    $lng=$wpdb->get_var('SELECT AVG(t.lng) FROM '.$table.' AS t CROSS JOIN ( SELECT AVG(lng) avgr, STD(lng) stdr FROM '.$table.' ) AS stats WHERE t.lng BETWEEN (stats.avgr-stats.stdr) AND (stats.avgr+stats.stdr)');
    //church_admin_debug( $wpdb->last_query);
    $lat=$wpdb->get_var('SELECT AVG(t.lat) FROM '.$table.' AS t CROSS JOIN ( SELECT AVG(lat) avgr, STD(lat) stdr FROM '.$table.' ) AS stats WHERE t.lat BETWEEN (stats.avgr-stats.stdr) AND (stats.avgr+stats.stdr)');
    //church_admin_debug( $wpdb->last_query);
    */
    $lat=$wpdb->get_var('SELECT AVG(lat) FROM '.$table.' WHERE lat!=0');
    $lng=$wpdb->get_var('SELECT AVG(lng) FROM '.$table.' WHERE lng!=0');
    if(!empty( $lat)&&!empty( $lng) )
    {
        $coords->lat=floatval( $lat);
        $coords->lng=floatval( $lng);
    }
    else
    {
        $lat=$wpdb->get_var('SELECT AVG(lat) FROM '.CA_SIT_TBL.' WHERE lat!=0');
        $lng=$wpdb->get_var('SELECT AVG(lng) FROM '.CA_SIT_TBL.' WHERE lng!=0');
        if( !empty( $lat ) && !empty( $lng ) )
        {
            $coords->lat=floatval( $lat );
            $coords->lng=floatval( $lng );
        }
        else
        {
            $coords->lat=0.0;
            $coords->lng=0.0;
        }

    }
    //church_admin_debug("church_admin_coordinates function \r\n".print_r( $coords,TRUE) );
    return $coords;
 
}
/******************************************************
 * Function to update a directory entry with MailChimp
 * 2021-12-09
 * Andy Moyle
 * v3.4.107
 ******************************************************/
function church_admin_update_mailchimp_member( $person,$old_email,$showResult=FALSE)
{
    //church_admin_debug("****************************\r\nUpdate MailChimp MEMBER ".church_admin_formatted_name( $person)."\r\n");
    
    if ( empty( $person) )return;
    
    global $wpdb;
    $mailChimpSettings=get_option('church_admin_mailchimp');
    if ( empty( $mailChimpSettings['api_key'] ) )
    {
        //church_admin_debug("No MailChimp Settings");
        return;
    }
    /*****************************
     * Initiate MailChimp
     ****************************/
    require_once(plugin_dir_path(dirname(__FILE__) ).'includes/mailchimp.inc.php');
    require_once(plugin_dir_path(dirname(__FILE__) ).'includes/mailchimp.php');
    try{$MailChimp = new MailChimp( $mailChimpSettings['api_key'] );}
	catch(Exception $e)
	{
			//church_admin_debug( $e->getMessage() );
			return;
	}
    $MailChimp->verify_ssl = 'false';
    /*****************************
     * Build arguments
     ****************************/
    if(!empty( $old_email) )
    {
        //church_admin_debug("Subscriber hash is old email address");
        $subscriber_hash=md5( $old_email);
    }
    else
    {
        //church_admin_debug("Subscriber hash is new email address");
        $subscriber_hash=md5( $person->email);
    }

    //for safety if they don't want emails, we will make them pending, as API can't resubscribe unsubscribed.
    if(!empty( $person->email_send) )  {$status='subscribed';}else{$status='unsubscribed';}
    $args=array(
        'status'=>$status,
        'email_address'=>$person->email,
        'merge_fields'=>array('FNAME'=>$person->first_name,'LNAME'=>$person->last_name),
        'status_if_new'=>$status,
        'email_type'=>'html',

    );
    //church_admin_debug("* Args array *");
    //church_admin_debug( $args);
    $response=$MailChimp->put("/lists/{$mailChimpSettings['listID']}/members/$subscriber_hash",$args);
    $output=NULL;
    if( $showResult && !empty( $response['id'] ) && $response['id']==$subscriber_hash)$output = '<p>'.esc_html(sprintf(__('%1$s (%2$s) updated','church-admin'),church_admin_formatted_name( $person),$person->email) ).'</p>';
    //church_admin_debug(print_r( $response,TRUE) );
    /***************************************
     * Update person's tags
     **************************************/
    $tags=church_admin_mailchimp_person_tags( $person->people_id);
    //church_admin_debug("* Tags array *");
    //church_admin_debug(print_r( $tags,TRUE) );
    $response=$MailChimp->post("/lists/{$mailChimpSettings['listID']}/members/$subscriber_hash/tags?count=100",array('tags'=>$tags) );
    //church_admin_debug("* Tags response *");
    //church_admin_debug(print_r( $response,TRUE) );
    return $output;
}
/**********************************************************
*   Function to send post out via MailChimp
***********************************************************/  
function church_admin_mailchimp_post_send( $post)
{
    //church_admin_debug("*** FUNCTION church_admin_mailchimp_post_send ***");
    if ( empty( $post) ) return;

    /*****************************
    * User for reply to etc
    ****************************/
    $user=wp_get_current_user();



    /*****************************
    * Initiate MailChimp
    ****************************/
    require_once(plugin_dir_path(dirname(__FILE__) ).'includes/mailchimp.inc.php');
    require_once(plugin_dir_path(dirname(__FILE__) ).'includes/mailchimp.php');
    $mailChimpSettings=get_option('church_admin_mailchimp');
    if ( empty( $mailChimpSettings['api_key'] )||empty( $mailChimpSettings['listID'] ) )
    {
        //church_admin_debug("No MailChimp Settings");
        return;
    }
    $MailChimp = new MailChimp( $mailChimpSettings['api_key'] );
    $MailChimp->verify_ssl = 'false';
    
    /*****************************
    * Get tag ids
    ****************************/
    church_admin_get_mailchimp_tags();//refresh first
    $mailChimpTags=get_option('church_admin_mailchimp_tags');
    if ( empty( $mailChimpTags) )
    {
        //church_admin_debug("No MailChimp Tags");
        return;
    }
   
    

    $postType=get_post_type( $post );
    switch( $postType)
    {

        case 'prayer-requests':
            $title=__('New Prayer Request','church-admin');
            $contactType='prayer';
            $ministry=__('Prayer requests send','church-admin');
            $tag='prayer-requests';	
        break;
        case 'bible-readings':
            $title=__('New Bible Reading','church-admin');
            $contactType='bible';
            $ministry=__('Bible readings send','church-admin');
            $tag='bible-readings';
        break;
        case 'post':
            $title=__('New Blog Post','church-admin');
            $contactType='news-send';
            $ministry=__('News send','church-admin');
            $tag='news-send';
        break;
    }

    /*****************
    * get tag id
    *****************/

    $tagID=array_search( $tag,$mailChimpTags);//MailChimp id for the tag
    $segment_opts =array
    (
        'match' => 'any', // or 'all' or 'none'
        'conditions'=>array(array('condition_type'=>'StaticSegment','op'=>'static_is','field'=>'static_segment','value'=>$tagID) )
    );
    $email_title=$title.' - '.$post->post_title;
    $content=church_admin_prepare_post_for_email( $post->post_content,$postType,$post->ID);
    $content.='<p><a href="'.site_url().'/?action=user-email-settings">'.__('Update which emails you receive','church-admin').'</a></p>';
		
    /*******************
     * Create campaign
     * *****************/
    
    $args=array(
        'type'=>'regular',
        'recipients'=>array('list_id'=>$mailChimpSettings['listID'],'segment_opts'=>$segment_opts),
        'settings'=>array('subject_line' => $email_title,
                            'reply_to' => get_option('admin_email'),
                            'from_name' => get_bloginfo('name'),
                            'from_email' => get_option('admin_email'),
                            'to_name' => '*|FNAME|* *|LNAME|*'
                        )
    );
    //church_admin_debug("Campaign Args");
    //church_admin_debug(print_r( $args,TRUE) );
    $response=$MailChimp->post("campaigns",$args);
    
    /*******************
     * Log Response
     ******************/
    if (!empty( $response) && defined('CA_DEBUG') ) 
    {
        //church_admin_debug( "Post Campaign Response\r\n");
        //church_admin_debug(print_r( $response,TRUE) );
    }
    $campaignID=$response['id'];
    //church_admin_debug("Campaign ID: ".$campaignID);
    /*******************
     * Add Content
     ******************/
    $response = $MailChimp->put('campaigns/' . $campaignID . '/content', array('html' =>  $content) );
    //church_admin_debug(print_r( $response,TRUE) );



    /*******************
     * Send Campaign out
     ******************/
    
    if(!empty( $campaignID) )
    {
        $response=$MailChimp->post("campaigns/$campaignID/actions/send",$args);
        //church_admin_debug(print_r( $response,TRUE) );
    }

}


function church_admin_prepare_post_for_email( $content,$type,$ID)
{
    global $church_admin_for_email;
    $church_admin_for_email=TRUE;
    ////church_admin_debug(print_r(func_get_args(),TRUE) );
        $blocks=parse_blocks( $content);
        //church_admin_debug(print_r( $blocks,TRUE) );
        $content='';
        if(!empty( $blocks) )
        {
            foreach( $blocks AS $block)
            {

                //handle class shortcode
                

                ////church_admin_debug("HANDLING A BLOCK");
                switch( $block['blockName'] )
                {
                    case 'core/embed':
                        ////church_admin_debug("Handling core/embed");
                        $link=$block['attrs']['url'];
                        ////church_admin_debug("Link $link ");
                        switch( $block['attrs']['type'] )
                        {
                            case 'audio':
                            case 'rich':
                                $label=__('Play audio','church-admin');
                            break;
                            case 'video':
                                $label=__('Play video','church-admin');
                            break;
                        }
                        $content.='<table border="0" style="margin-top:10px"  cellspacing="0" cellpadding="0"><tr><td align="center" style="border-radius: 3px;" bgcolor="#e9703e"><a href="'.esc_url( $link).'" target="_blank" style="font-size: 16px; font-family: Helvetica, Arial, sans-serif; color: #ffffff; text-decoration: none; text-decoration: none;border-radius: 3px; padding: 12px 18px; border: 1px solid #e9703e; display: inline-block;">'.$label.'</a></td></tr></table>';
                    break;
                    case 'core/shortcode':
                    case 'wp:shortcode':
                        //church_admin_debug("Handling shortcode");
                        //church_admin_debug( $block);

                        $content.=do_shortcode( $block['innerHTML'] );
                    break;
                    default:
                        ////church_admin_debug("Handling default block");
                        $content.=wpautop(implode("\r\n",$block['innerContent'] ) );
                    break;
                }
            }
        }else{ $content .= do_shortcode( $content);}
        if( $type=='bible-readings'&&!empty( $ID) )
        {
            $custom_content ='';
            $version=get_option('church_admin_bible_version');
            $passage=get_post_meta( $ID ,'bible-passage',TRUE);
            
            if(!empty( $debug) )//church_admin_debug('Passage:'.$passage);
            $content ='<div class="ca-bible-date" style="display: block;border: 1px solid #CF2022;text-align: center;color: #CF2022;text-decoration: none; font-size: 1.4em;padding: 10px;margin: 30px auto 40px;">'.get_the_date(get_option('date_format'),$ID).'</div>'.$content;
            if(!empty( $passage) )
            {
                $link='https://www.biblegateway.com/passage/?search='.urlencode( $passage).'&version='.urlencode( $version).'&interface=print';
                $custom_content .= '<table border="0" style="margin-top:10px"  cellspacing="0" cellpadding="0"><tr><td align="center" style="border-radius: 3px;" bgcolor="#e9703e"><a href="'.esc_url( $link).'" target="_blank" style="font-size: 16px; font-family: Helvetica, Arial, sans-serif; color: #ffffff; text-decoration: none; text-decoration: none;border-radius: 3px; padding: 12px 18px; border: 1px solid #e9703e; display: inline-block;">'.sprintf(__('Read %1$s','church-admin'),esc_html( $passage) ).'</a></td></tr></table>';
               
                $bibleCV=church_admin_bible_audio_link( $passage,$version);

                if(!empty( $bibleCV['url'] ) )
                {
                    $custom_content .= '<table border="0" style="margin-top:10px" cellspacing="0" cellpadding="0"><tr><td align="center" style="border-radius: 3px;" bgcolor="#e9703e"><a href="'.esc_url( $bibleCV['url'] ).'" target="_blank" style="font-size: 16px; font-family: Helvetica, Arial, sans-serif; color: #ffffff; text-decoration: none; text-decoration: none;border-radius: 3px; padding: 12px 18px; border: 1px solid #e9703e; display: inline-block;">'.esc_html(sprintf(__('Listen to  %1$s','church-admin'),$bibleCV['linkText'] ) ).'</a></td></tr></table>';
                }
            }
            $content.=$custom_content;
            
        }
    return $content;
}

function church_admin_delete_household( $household_id)
{
    global $wpdb;
    //church_admin_debug('Attempting to delete household id '.$household_id);
    if ( empty( $household_id) )return FALSE;
    //delete from household table
    $wpdb->query('DELETE FROM '.CA_HOU_TBL.' WHERE household_id="'.(int)$household_id.'"');
    //church_admin_debug( $wpdb->last_query);
    //get people
    $persons=array();
    $people=$wpdb->get_results('SELECT * FROM '.CA_PEO_TBL.' WHERE household_id="'.(int)$household_id.'"');
    //church_admin_debug( $wpdb->last_query);
    if(!empty( $people) )
    {
        foreach( $people AS $person)
        {
            $persons[]=church_admin_formatted_name($person);
            require_once(ABSPATH.'wp-admin/includes/user.php');
            if(!empty( $person->user_id) )wp_delete_user( $person->user_id,1);
            $wpdb->query('DELETE FROM '.CA_MET_TBL.' WHERE people_id="'.(int)$person->people_id.'"');
            //church_admin_debug( $wpdb->last_query);
            $wpdb->query('DELETE FROM '.CA_PEO_TBL.' WHERE people_id="'.(int)$person->people_id.'"');
            //church_admin_debug( $wpdb->last_query);
            $wpdb->query('DELETE FROM '.CA_APP_TBL.' WHERE people_id="'.(int)$person->people_id.'"');
            //church_admin_debug( $wpdb->last_query);
        }

    }
    echo'<div class="notice notice-success"><h2>'.__('Household deleted','church-admin').'</h2>';
    echo'<p>'.implode('<br/>',$persons).'</p></div>';
    $member_type_id=!empty($_GET['member_type_id'])?(int)$_GET['member_type_id']:0;
    church_admin_address_list($member_type_id);

}

/**
 *
 * Create user
 *
 * @author  Andy Moyle
 * @param    $people_id,$household_id,$username
 * @return   html
 * @version  0.1
 *
 */
function church_admin_create_user( $people_id,$household_id,$username=NULL)
{
    global $wpdb;
    //church_admin_debug('**** church_admin_create_user *****');
    //church_admin_debug('People ID: '.$people_id);
    //church_admin_debug('Household ID: '.$household_id);
    $username=strtolower( $username);
	$wpdb->show_errors;
    $out='';
    if(!$people_id)
    {
			$out.="<p>'.__('Nobody was specified to create a wordpress account','church-admin').'</td></tr>";
    }
    else
    {//people_id

	$user=$wpdb->get_row('SELECT * FROM '.CA_PEO_TBL.' WHERE people_id="'.esc_sql( $people_id).'"');
    //church_admin_debug( $wpdb->last_query);

	if ( empty( $user) )
	{
        //church_admin_debug('No user for people id');
	    $out.='<p>'.$username.' - '.__("that people record doesn't exist",'church-admin').'</p>';
	}
	else
	{//user exits in plugin db
	    $user_id=email_exists( $user->email);
        //church_admin_debug('User ID exists: '.$user_id);
	    if(!empty( $user_id) && $user->user_id==$user_id)
	    {//wp user exists and is in plugin db
            $userDetails=get_user_by('id',$user_id);
			church_admin_update_user_meta( $people_id,$user_id);
			$out.='<p>'.$userDetails->user_login.' '.__('user already created','church-admin').'</p>';
            //church_admin_debug('User exists already and is in directory');
	    }
	    elseif(!empty( $user_id) && $user->user_id!=$user_id)
	    {//wp user exists, update plugin
			$wpdb->query('UPDATE '.CA_PEO_TBL.' SET user_id="'.esc_sql( $user_id).'" WHERE people_id="'.esc_sql( $people_id).'"');
            //church_admin_debug('User exists, update plugin');
            //church_admin_debug( $wpdb->last_query);
            $userDetails=get_user_by('id',$user_id);
			$out.='<p>'.$userDetails->user_login.' '.__('user updated','church-admin').'</p>';

	    }
	    else
	    {//wp user needs creating!
				//create unique username
				if ( empty( $username) )$username=strtolower(str_replace(' ','',$user->first_name).str_replace(' ','',$user->middle_name).str_replace(' ','',$user->last_name) );
				$x='';
				while(username_exists( $username.$x ) )
				{
		    	$x+=1;
				}
                //church_admin_debug('Creating user with username: '.$username.$x);
				$random_password = wp_generate_password( $length=12, $include_standard_special_chars=false );
				$user_id = wp_create_user( $username.$x, $random_password, $user->email );
                $wpdb->query('UPDATE '.CA_PEO_TBL.' SET user_id="'.esc_sql( $user_id).'" WHERE people_id="'.esc_sql( $people_id).'"');
                //church_admin_debug( $wpdb->last_query);
				church_admin_update_user_meta( $people_id,$user_id);
				$message=get_option('church_admin_user_created_email');

				if ( empty( $message) )
				{
					$message='<p>'.__('The web team at','church-admin'). '<a href="[SITE_URL]">[SITE_URL]</a> '.__('have just created a user login for you.','church-admin').'</p><p>'.__('Your username is','church-admin').' <strong>[USERNAME]</strong></p><p>'.__('Your password is','church-admin').' <strong>[PASSWORD]</strong></p><p>'.__('We also have an app you can download for [ANDROID] and [IOS]','church-admin').' </p>';
					update_option('church_admin_user_created_email',$message);
				}
				$message=str_replace('[SITE_URL]',site_url(),$message);
				$message=str_replace('[USERNAME]',esc_html( $username.$x),$message);
				$message=str_replace('[PASSWORD]',$random_password,$message);
				//$page_id=church_admin_register_page_id();
                ////church_admin_debug(print_r( $page_id,TRUE) );  
				//if(!empty( $page_id) )$message=str_replace('[EDIT_PAGE]',get_page_link( $page_id),$message);
				$message=str_replace('[ANDROID]','<a href="http://www.tinyurl.com/androidChurchApp">Android</a>',$message);
				$message=str_replace('[IOS]','<a href="http://www.tinyurl.com/iOSChurchApp">iOS</a>',$message);
				$out.='<p>'.__('User created with username','church-admin').' <strong>'.esc_html( $username.$x).'</strong>,'.__('password','church-admin').': <strong>'.$random_password.'</strong> '.__('and this message was queued to them','church-admin').'<br />'.esc_html( $message);
					$headers=array();
					$headers[] = 'From: Web team at '.site_url() .'<'.get_option('admin_email').'>';
					$headers[] = 'Cc: Web team at '.site_url() .'<'.get_option('admin_email').'>';
					add_filter('wp_mail_content_type','church_admin_email_type');
					$subject=get_option('church_admin_user_created_email_subject');

					if ( empty( $subject) )$subject='Login for '.site_url();
				if(wp_mail( $user->email,$subject,$message,$headers) )
				{
		    		//church_admin_debug('Email sent');
                    //church_admin_debug( $message);
                    $out.='<strong>'.__('User creation email sent successfully','church-admin').'</strong></p>';
				}
				else
				{
                    //church_admin_debug('Email not sent');
                    
		    	    $out.='<strong>'.__('User creation email NOT sent successfully','church-admin').'</strong></p>';
				}
				remove_filter('wp_mail_content_type','church_admin_email_type');
				$wpdb->query('UPDATE '.CA_PEO_TBL.' SET user_id="'.esc_sql( $user_id).'" WHERE people_id="'.esc_sql( $people_id).'"');

	    }//wp user needs creating!



	}//user exits in plugin db


    }//people_id
    //church_admin_debug('END FUNCTION');
    return $out;
}//function church_admin_create_user


/**
 *
 * Delete People
 *
 * @author  Andy Moyle
 * @param    $people_id,$household_id
 * @return   html
 * @version  0.1
 *
 */
function church_admin_delete_people( $people_id,$household_id,$echo=TRUE,$confirm_required=TRUE)
{
    //if(!church_admin_level_check('Directory') )wp_die(__('You don\'t have permissions to do that','church-admin') );
    global $wpdb;
    $MailChimpSettings=get_option('church_admin_mailchimp');
    $user_id=get_current_user_id();
    $data=$wpdb->get_row('SELECT * FROM '.CA_PEO_TBL.' WHERE people_id="'.esc_sql( $people_id).'" ');
    if ( empty( $data) )  {
        echo '<h2>'.sprintf(__('No person with ID %1$s exists on the system','church-admin'),(int)$people_id).'</h2>';
        return;
    }
    if(!empty( $confirm_required) && empty( $_POST['delete_confirm'] ) )
    {
        echo '<h2>'.sprintf(__('Confirm deletion of %1$s','church-admin'),implode(" ",array_filter(array( $data->first_name,$data->prefix,$data->last_name) )) ).'</h2>';   
        echo'<form action="" method="post">';
        echo'<table class="form-table">';
        if(!empty( $MailChimpSettings)&&!empty( $data->email) )echo '<tr><th scope="row">'.__('Delete from MailChimp? (Cannot be undone)','church-admin').'</th><td><input type="checkbox" name="mailchimp_delete"/></td></tr>';
        echo'<tr><td colspan=2><input type="hidden" name="delete_confirm" value="'.(int)$people_id.'"/><input class="button-primary" type="submit" value="'.__('Confim deletion','church-admin').'"/></td></tr></table>';
        return;
    }
   
    delete_option('church-admin-directory-output');//get rid of cached directory, so it is updated
    //deletes person with specified people_id
    
    $message='';
    
    if( $data->user_id!=$user_id && !user_can('manage_options',$data->user_id))
    {
        //delete user and log out from app
        wp_delete_user( $data->user_id);
        $wpdb->query('DELETE FROM '.CA_APP_TBL.' WHERE user_id="'.intval( $data->user_id).'"');
        $message.=__('User account deleted','church-admin').'<br />';
    }
    if(!empty( $data->head_of_household) )
    {//need to reassign head of household
        $message.=  esc_html(sprintf(__( '%1$s was head of household','church-admin'),$data->first_name.' '.$data->last_name) ).'<br />';
        //look for another adult
        $next_person=$wpdb->get_row('SELECT * FROM '.CA_PEO_TBL.' WHERE household_id="'.(int)$household_id.'" AND people_type_id=1 AND people_id!="'.(int)$people_id.'" LIMIT 1');
        if(!empty( $next_person) )$message.=sprintf( esc_html__( 'Head of household reassigned to %1$s','church-admin'),$next_person->first_name.' '.$next_person->last_name).'<br />';
        //no adult, find someone!
        if ( empty( $next_person->people_id) )$next_person=$wpdb->get_row('SELECT * from '.CA_PEO_TBL.' WHERE household_id="'.(int)$household_id.'"  AND people_id!="'.(int)$people_id.'" AND people_type_id=1 LIMIT 1');
        if(!empty( $next_person) )$message.=esc_html(sprintf(__( 'Head of household reassigned to %1$s','church-admin'),$next_person->first_name.' '.$next_person->last_name) ).'<br />';else{$message='';}
        //set new head of hosuehold
        if(!empty( $next_person->people_id) )
        {
            $sql='UPDATE '.CA_PEO_TBL.' SET head_of_household=1 WHERE people_id="'.(int)$next_person->people_id.'"';
            $wpdb->query( $sql);
        }
    }
    //Delete from people table
    $wpdb->query('DELETE FROM '.CA_PEO_TBL.' WHERE people_id="'.esc_sql( $people_id).'" ');
    //Delete from custom fields table.
    $wpdb->query('DELETE FROM '.CA_CUST_MET_TBL.' WHERE people_id="'.esc_sql( $people_id).'" ');

    $message.=sprintf( esc_html__( '%1$s has been deleted','church-admin'),$data->first_name.' '.$data->last_name).'<br />';
    $count=$wpdb->get_var('SELECT COUNT(people_id) FROM '.CA_PEO_TBL.' WHERE household_id ="'.esc_sql( $household_id).'" ');
    if ( empty( $count) )
    {
        $wpdb->query('DELETE FROM '.CA_PEO_TBL.' WHERE household_id="'.esc_sql( $household_id).'" ');
        $message=__('Household Deleted','church-admin').'<br />';
    }
    $wpdb->query('DELETE FROM '.CA_MET_TBL.' WHERE people_id="'.esc_sql( $people_id).'"');
    //delete from Mailchimp
    
    if(!empty( $MailChimpSettings)&&!empty( $_POST['mailchimp_delete'] )&&!empty( $data->email) )
    {
    
        require_once(plugin_dir_path(dirname(__FILE__) ).'includes/mailchimp.inc.php');
        $MailChimp = new MailChimp( $MailChimpSettings['api_key'] );
        $MailChimp->verify_ssl = false;
        $list_id=$MailChimpSettings['listID'];
        $subscriber_hash=md5(strtolower( $data->email) );
        $MailChimp->delete("/lists/$list_id/members/$subscriber_hash");
        $message.=__('Deleted from Mailchimp','church-admin');
    
    }
    if(!empty( $echo) )
    {
        echo'<div class="notice notice-success inline"><p><strong>'.$message.'</strong></td></tr></div>';

        if(!empty( $count) )  {church_admin_new_household_display( $household_id);}else{church_admin_people_main();}
    }

    
    

}
function church_admin_what_three_words( $data,$table=CA_HOU_TBL)
{
    
    global $wpdb;
    $out='';
    if ( empty( $data) ) return;
    if(!is_array( $data) )$data=(array)$data;
    $w3w=get_option('church_admin_what_three_words');
    if ( empty( $w3w)|| $w3w=='off') return;
	if(!empty( $data['what-three-words'] ) )
	{
		//output what three words
		$out='<p><a title="'.__('What Three Words precise location','church-admin').'" target="_blank" href="'.esc_url('https://w3w.co/'.$data['what-three-words'] ).'"><span style="color:red">///</span>'.esc_html( $data['what-three-words'] ).'</a></p>';
	}
	else
	{
       

		//lookup
        if ( empty( $data['lat'] )||empty( $data['lng'] ) )return;

        $url="https://api.what3words.com/v3/convert-to-3wa?key=7F5FVM60&coordinates=".$data['lat'].",".$data['lng']."&language=en&format=json";
		
        
        $response = wp_remote_get( esc_url_raw( $url ) );
		$api_response = json_decode( wp_remote_retrieve_body( $response ), true );
       
        if(!empty( $api_response['words'] ) )
        {
            switch( $table)
            {
                case 'CA_HOU_TBL':
                    $wpdb->query('UPDATE '.$table.' SET what_three_words="'.esc_sql( $api_response['words'] ).'" WHERE household_id="'.(int)$data['household_id'].'"');
                break;
                case 'CA_SIT_TBL':
                    $wpdb->query('UPDATE '.$table.' SET what_three_words="'.esc_sql( $api_response['words'] ).'" WHERE site_id="'.(int)$data['household_id'].'"');
                break;
            }
           
            $out='<p><a title="'.__('What Three Words precise location','church-admin').'" target="_blank"  href="'.esc_url('https://w3w.co/'.$api_response['words'] ).'"><span style="color:red">///</span>'.esc_html( $api_response['words'] ).'</a></p>';
	
        }

	}

	return $out;



}

function church_admin_member_type_option( $currentID)
{
    $mt=church_admin_member_type_array();

    $out = '';
    foreach( $mt AS $id=>$type)
    {
        $out.='<option value="'.(int)$id.'" '.selected( $id,$currentID,FALSE).'>'.esc_html( $type).'</option>';
    }
    return $out;
}


function church_admin_getRemoteMimeType( $url) {
    //church_admin_debug('Mime type check for '.$url);
    $ch = curl_init( $url);
    curl_setopt( $ch, CURLOPT_RETURNTRANSFER, true);
    curl_exec( $ch);

    # get the content type
    $mimeType=curl_getinfo( $ch, CURLINFO_CONTENT_TYPE);
    //church_admin_debug('Mime type '.$mimeType);
    return $mimeType;
}


/**
 * Recursive sanitation for text or array
 * 
 * @param $array_or_string (array|string)
 * @since  0.1
 * @return mixed
 */
function church_admin_sanitize($array_or_string) {
    if( is_string($array_or_string) ){
        $array_or_string = sanitize_text_field(stripslashes( $array_or_string ));
    }elseif( is_array($array_or_string) ){
        foreach ( $array_or_string as $key => &$value ) {
            if ( is_array( $value ) ) {
                $value = church_admin_sanitize($value);
                
            }
            else {
                $value = sanitize_text_field( stripslashes( $value ) );
            }
        }
    }
  
    return $array_or_string;
  }


  function church_admin_app_default_menu()
  {
    church_admin_debug('***** church_admin_app_default_menu() ********');
    global $wpdb;
    $defaultMenu = array(
        'home'=>array('edit'=>false,'item'=>__('Home','church-admin'),'order'=>1,'show'=>TRUE,'type'=>'app','loggedinOnly'=>0),
        'account'=>array('edit'=>false,'item'=>__('Account','church-admin'),'order'=>2,'show'=>TRUE,'type'=>'app','loggedinOnly'=>0),
        
        'address'=>array('edit'=>true,'item'=>__('Address','church-admin'),'order'=>4,'show'=>TRUE,'type'=>'app','loggedinOnly'=>1),
        
        'calendar'=>array('edit'=>true,'item'=>__('Calendar','church-admin'),'order'=>7,'show'=>TRUE,'type'=>'app','loggedinOnly'=>0),
        'checkin'=>array('edit'=>true,'item'=>__('Checkin','church-admin'),'order'=>8,'show'=>TRUE,'type'=>'app','loggedinOnly'=>1),
        'classes'=>array('edit'=>true,'item'=>__('Classes','church-admin'),'order'=>9,'show'=>TRUE,'type'=>'app','loggedinOnly'=>0),
        'giving'=>array('edit'=>true,'item'=>__('Giving','church-admin'),'order'=>10,'show'=>TRUE,'type'=>'app','loggedinOnly'=>0),
        'smallgroup'=>array('edit'=>true,'item'=>__('Groups','church-admin'),'order'=>11,'show'=>TRUE,'type'=>'app','loggedinOnly'=>0),
        'media'=>array('edit'=>true,'item'=>__('Media','church-admin'),'order'=>12,'show'=>TRUE,'type'=>'app','loggedinOnly'=>0),
        'messages'=>array('edit'=>TRUE,'item'=>__('Messages','church-admin'),'order'=>13,'show'=>TRUE,'type'=>'app','loggedinOnly'=>0),
        'myprayer'=>array('edit'=>TRUE,'item'=>__('My prayer','church-admin'),'order'=>15,'show'=>TRUE,'type'=>'app','loggedinOnly'=>1),
        'news'=>array('edit'=>true,'item'=>__('News','church-admin'),'order'=>16,'show'=>TRUE,'type'=>'app','loggedinOnly'=>0),
        
        'rota'=>array('edit'=>true,'item'=>__('Schedule','church-admin'),'order'=>17,'show'=>TRUE,'type'=>'app','loggedinOnly'=>0),
        'notifications'=>array('edit'=>false,'item'=>__('Notification settings','church-admin'),'order'=>18,'show'=>TRUE,'type'=>'app','loggedinOnly'=>0),
        'service-prebooking'=>array('edit'=>TRUE,'item'=>__('Service Prebooking','church-admin'),'order'=>19,'show'=>TRUE,'type'=>'app','loggedinOnly'=>1),
        'notifications'=>array('edit'=>false,'item'=>__('Notification Settings','church-admin'),'order'=>20,'show'=>TRUE,'type'=>'app','loggedinOnly'=>0),
        '3circles'=>array('edit'=>false,'item'=>__('3 circles','church-admin'),'order'=>21,'show'=>TRUE,'type'=>'app','loggedinOnly'=>0),
        'not-available'=>array('edit'=>false,'item'=>__('My availability','church-admin'),'order'=>22,'show'=>TRUE,'type'=>'app','loggedinOnly'=>1),			
        'register'=>array('edit'=>false,'item'=>__('Register','church-admin'),'order'=>23,'show'=>TRUE,'type'=>'app','loggedinOnly'=>0),
        'serving'=>array('edit'=>false,'item'=>__('Serving','church-admin'),'order'=>24,'show'=>TRUE,'type'=>'app','loggedinOnly'=>1),
        'logout'=>array('edit'=>false,'item'=>__('Reset church','church-admin'),'order'=>25,'show'=>TRUE,'type'=>'app','loggedinOnly'=>0)
        );

        //add custom post types if existant
        $ACexists=$wpdb->get_var('SELECT COUNT(*) FROM '.$wpdb->posts.' WHERE post_type="acts-of-courage"');
        if( !empty( $ACexists ) )
        {
            church_admin_debug('Found acts of courage, so adding');
            $defaultMenu['courage'] = array('edit'=>true,'item'=>__('Acts of courage','church-admin'),'order'=>13,'show'=>TRUE,'type'=>'app','loggedinOnly'=>0);
                    
        }
        $BRexists=$wpdb->get_var('SELECT COUNT(*) FROM '.$wpdb->posts.' WHERE post_type="bible-readings"');
        if( !empty( $BRexists ) ){
            church_admin_debug('Found bible reading posts, so adding');
            $defaultMenu['bible'] = array('edit'=>true,'item'=>__('Bible Readings','church-admin'),'order'=>5,'show'=>TRUE,'type'=>'app','loggedinOnly'=>0);
            $defaultMenu['bible-readings-archive'] = array('edit'=>true,'item'=>__('All Bible Readings','church-admin'),'order'=>6,'show'=>TRUE,'type'=>'app','loggedinOnly'=>0);       
        }
        $PRexists= $wpdb->get_var('SELECT COUNT(*) FROM '.$wpdb->posts.' WHERE post_type="prayer-requests"');
        
        if(!empty( $PRexists)){
            church_admin_debug('Found prayer requests, so adding');
           $defaultMenu['prayer'] = array('edit'=>true,'item'=>__('Prayer requests','church-admin'),'order'=>14,'show'=>TRUE,'type'=>'app','loggedinOnly'=>0);
        }
       
        church_admin_debug($defaultMenu);
        church_admin_debug('***** END church_admin_app_default_menu() ********');
        return $defaultMenu;

  }

function church_admin_posts_and_pages_dropdown($current=null)
{

    $out='<option value="">'.__('Select a post or page','church-admin').'</option>';
		
    $out .=' <optgroup label="'.__('Pages','church-admin').'">';
    $args = array( 'post_type'=>'page','numberposts' =>-1,'orderby'=>'title','order'=>'ASC');
    $postlinks = get_posts( $args);
    foreach( $postlinks as $postlink ) { setup_postdata( $postlink); $out .= '<option value="'.esc_url( get_permalink( $postlink->ID ) ).'" '.selected(get_permalink( $postlink->ID),$current,FALSE).'>'.esc_html( $postlink->post_title ).'</option>';}
    $out .='</optgroup';
    $out .= ' <optgroup label="'.__('Posts','church-admin').'">';
    $args = array( 'numberposts' => 10);
    $postlinks = get_posts( $args);
    foreach( $postlinks as $postlink ) { setup_postdata( $postlink); $out .= '<option value="'.esc_url( get_permalink( $postlink->ID ) ).'" '.selected(get_permalink( $postlink->ID),$current,FALSE).'>'.esc_html( $postlink->post_title ).'</option>';}
    $out .='</optgroup>';

    return $out;


}

function church_admin_title_case($string) 
{

    // https://www.media-division.com/correct-name-capitalization-in-php/

	$word_splitters = array(' ', '-', "O'", "L'", "D'", 'St.', 'Mc');
	$lowercase_exceptions = array('the', 'van', 'den', 'von', 'und', 'der', 'de', 'da', 'of', 'and', "l'", "d'");
	$uppercase_exceptions = array('III', 'IV', 'VI', 'VII', 'VIII', 'IX');

	$string = strtolower($string);
	foreach ($word_splitters as $delimiter)
	{ 
		$words = explode($delimiter, $string); 
		$newwords = array(); 
		foreach ($words as $word)
		{ 
			if (in_array(strtoupper($word), $uppercase_exceptions))
				$word = strtoupper($word);
			else
			if (!in_array($word, $lowercase_exceptions))
				$word = ucfirst($word); 

			$newwords[] = $word;
		}

		if (in_array(strtolower($delimiter), $lowercase_exceptions))
			$delimiter = strtolower($delimiter);

		$string = join($delimiter, $newwords); 
	} 
	return $string; 
}