<?php
if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly



function church_admin_fix_anon_giving()
{
    global $wpdb;
    $results=$wpdb->get_results('SELECT *  FROM '.CA_GIV_TBL.' WHERE name is NULL OR name="" AND people_id IS NOT NULL AND people_id!=0');
   
    if(!empty( $results) )
    {
        foreach( $results AS $row)
        {
            $person=$wpdb->get_row('SELECT * FROM '.CA_PEO_TBL.' WHERE people_id="'.(int)$row->people_id.'"');
            if(!empty( $person) )
            {
                $name=church_admin_formatted_name( $person);
                $wpdb->query('UPDATE '.CA_GIV_TBL.' SET name="'.esc_sql( $name).'" WHERE giving_id="'.(int)$row->giving_id.'"');
                echo '<p>'.sprintf(__('Gift id %1$s name fixed with "%2$s"','church-admin'),(int)$row->giving_id,esc_html( $name) ).'</p>';
            }
        }
    }
    else
    {echo'<div class="notice notice-warning"><h2>'.__('No anonymous gifts with a people ID saved','church-admin').'</h2></div>';}

}
/*************************************
*
*		GIVING List
*   Updated 2022-01-03 for giving meta table
**************************************/
function church_admin_giving_list()
{
    global $wpdb;
    if(!empty( $_POST['attach_people_id'] )&& !empty( $_POST['giving_id'] ) )
    {
        $wpdb->query('UPDATE '.CA_GIV_TBL.' SET people_id="'.(int)$_POST['attach_people_id'].'" WHERE giving_id="'.(int)$_POST['giving_id'].'"');
    }
    echo'<h1>Giving List</h1>';
    
    
    if ( !church_admin_app_licence_check() )
    {
        echo'<p>'.__('To use the PayPal giving shortcode and block please set up PayPal above. Manual giving logging is below','church-admin').'</p>';
        $premium=array('currency_symbol'=>"$");
    }
   
    
    echo'<p><a class="button-primary" href="'.wp_nonce_url('admin.php?page=church_admin/index.php&amp;action=edit-gift&amp;section=giving','edit-gift').'">'.__('Add donation','church-admin').'</a></p>';
    echo'<form action="admin.php" method="GET"><p><input type="hidden" name="page" value="church_admin/index.php"/><input type="hidden" name="action" value="giving"/><p><input type="text" placeholder="'.__('Search by donor details','church-admin').'" name="search"/><input class="button-primary" type="submit" value="'.__('Search giving records','church-admin').'"/></p></form>';
    echo'<p><a class="button-primary" href="'.wp_nonce_url('admin.php?page=church_admin/index.php&amp;action=fix-anon-gifts&amp;section=giving','fix-anon-gifts').'">  <strong>'.__('Attempt to fix anon gifts','church-admin').'</a></p>';
    
    require_once(plugin_dir_path(dirname(__FILE__) ).'includes/pagination.class.php');
    if(!empty( $_GET['search'] ) )
    {
        if( $_GET['search']== __('Anonymous','church-admin') )  {$s=' WHERE a.name IS NULL or a.name="" ';}
        else
        {
            $s=' WHERE a.name LIKE "%'.esc_sql(stripslashes( $_GET['search'] ) ).'%" OR a.email LIKE "%'.esc_sql(stripslashes( $_GET['search'] ) ).'%" or a.address LIKE "%'.esc_sql(stripslashes( $_GET['search'] ) ).'%" ';
        }
        $sql='SELECT a.*,b.*,c.*,a.gift_aid AS thisGA,a.email AS donor_email,a.address AS donor_address FROM '.CA_GIV_TBL.' a LEFT JOIN '.CA_PEO_TBL.' b ON a.people_id=b.people_id  LEFT JOIN '.CA_SER_TBL.' c ON a.service_id=c.service_id '.$s.' ORDER BY donation_date DESC,giving_id DESC'; 
    }else
    {
    
        $sql='SELECT a.*,b.*,c.*,a.gift_aid AS thisGA,a.email AS donor_email,a.address AS donor_address FROM '.CA_GIV_TBL.' a LEFT JOIN '.CA_PEO_TBL.' b ON a.people_id=b.people_id  LEFT JOIN '.CA_SER_TBL.' c ON a.service_id=c.service_id ORDER BY donation_date DESC,giving_id DESC'; 
    }
    $results=$wpdb->get_results( $sql);
    $items=$wpdb->num_rows;
    if( $items > 0)
    {

	   $p = new caPagination;
	   $p->items( $items);
       
	   $p->limit(25); // Limit entries per page
        $p->target("admin.php?page=church_admin/index.php&section=giving&action=giving");
        if(!isset( $p->paging) )$p->paging=1;
        if(!isset( $_GET[$p->paging] ) )$_GET[$p->paging]=1;
        $p->currentPage((int)$_GET[$p->paging] ); // Gets and validates the current page
        $p->calculate(); // Calculates what to show
        $p->parameterName('paging');
        $p->adjacents(1); //No. of page away from the current page
        if(!isset( $_GET['paging'] ) )
        {
            $p->page = 1;
        }
        else
        {
            $p->page = intval( $_GET['paging'] );
        }
        //Query for limit paging
        $limit = esc_sql(" LIMIT " . ( $p->page - 1) * $p->limit  . ", " . $p->limit);
        $results=$wpdb->get_results( $sql.$limit);
        church_admin_debug( $sql.$limit);
        if(!empty( $_GET['search'] ) )echo '<h3>'.sprintf(__('Results for search "%1$s"','church-admin'),esc_html(stripslashes( $_GET['search'] ) )).'</h3>';
        // Pagination
    	echo '<div class="tablenav"><div class="tablenav-pages">';
    	echo $p->show();
    	echo '</div></div>';
        $action='giving';
        church_admin_giving_table( $results);
        // Pagination
    	echo '<div class="tablenav"><div class="tablenav-pages">';
    	echo $p->show();
    	echo '</div></div>';
    
    }
    else 
    {
        if ( empty( $_GET['search'] ) )  {echo'<p>'.__('No gifts processed yet','church-admin').'</p>';}
        else{echo '<h3>'.sprintf(__('No results for search "%1$s"','church-admin'),esc_html(stripslashes( $_GET['search'] ) )).'</h3>';}
    }
}

function church_admin_giving_table( $results)
{
    global $wpdb;
    $premium=get_option('church_admin_payment_gateway');

        $tableHeader='<tr><th class="column-primary"></span>'.__('Donation date','church-admin').' </th><th>'.__('Edit','church-admin').'</th><th>'.__('Delete','church-admin').'</th><th>'.__('Donor','church-admin').'</th><th>'.__('Attach','church-admin').'</th><th>'.__('Email','church-admin').'</th><th>'.__('Address','church-admin').'</th><th>'.__('Service','church-admin').'</th><th>'.__('Transaction type','church-admin').'</th><th>'.__('Frequency','church-admin').'</th><th>'.__('Amounts (Net of fees)','church-admin').'</th>';
        if(!empty( $premium['gift_aid'] ) )  {$tableHeader.='<th>'.__('Gift Aided?','church-admin').'</th>';}
        $tableHeader.='</tr>';
        //add custom fields to header
        $custom_fields=church_admin_get_custom_fields();
        if(!empty( $custom_fields) )
        {
            foreach( $custom_fields AS $id=>$field)
            {
                if( $field['section']!='giving')continue;
                $tableHeader.='<th>'.esc_html( $field['name'] ).'</th>';
            }
        }
        $tableHeader.='</tr>';
       
        echo'<table class="widefat wp-list-table striped"><thead>'.$tableHeader.'<thead><tfoot>'.$tableHeader.'</tfoot><tbody>';
        foreach( $results AS $row)
        {
            
            $edit='<a class="button-secondary" href="'.wp_nonce_url('admin.php?page=church_admin/index.php&amp;action=edit-gift&amp;section=giving&amp;giving_id='.(int)$row->giving_id,'edit-gift').'">'.__('Edit','church-admin').'</a>';
            $delete='<a onclick="return confirm(\''.__('Are you sure you want to delete this item?','church-admin').'\')" class="button-secondary" href="'.wp_nonce_url('admin.php?page=church_admin/index.php&amp;action=delete-gift&amp;section=giving&amp;gift_id='.(int)$row->giving_id,'delete-gift').'">'.__('Delete','church-admin').'</a>';
            $date=mysql2date(get_option('date_format').' '.get_option('time_format'),$row->donation_date);
            if(!empty( $row->last_name) )
            {
                $donor='<a title="'.__('View donor giving','church-admin').'" href="'.wp_nonce_url('admin.php?page=church_admin/index.php&amp;action=donor-gift&amp;section=giving&amp;people_id='.(int)$row->people_id,'donor-gift').'">'.church_admin_formatted_name( $row).'</a>';
            }
            elseif(!empty( $row->name) )  {$donor=esc_html( $row->name);}
            else{ $donor=esc_html(__('Anonymous','church-admin') );}
            //Ability to attach a people record to donor
            $attach='&nbsp;';
            if ( empty( $row->people_id) )
            {
                //look for people to attach
                $sql='SELECT * FROM '.CA_PEO_TBL.' WHERE CONCAT_WS(" ",first_name, last_name) LIKE "'.esc_sql( $donor).'" ';
                if(!empty( $row->donor_email) )$sql.='OR email="'.esc_sql( $row->donor_email).'"';//only use email if there is one, or it returns all empty email records!
                $people=$wpdb->get_results( $sql );
                church_admin_debug( $wpdb->last_query);
                if(!empty( $people) )
                {
                    $attach='<form action="" method="POST"><select name="attach_people_id">';
                    foreach( $people AS $person)  {$attach.='<option value="'.(int)$person->people_id.'">'.esc_html(church_admin_formatted_name( $person) ).'</option>';}
                    $attach.='</select><input type="hidden" name="giving_id" value="'.(int)$row->giving_id.'"/><input type="submit" value="'.__('Attach','church-admin').'"/></form>'; 
                }

            }
            if(!empty( $row->donor_address) )  {$address=esc_html( $row->donor_address);}else{$address='&nbsp;';}
            if(!empty( $row->donor_email) )  {$email=esc_html( $row->donor_email);}else{$email='&nbsp;';}
            if ( empty( $row->name)&& empty( $row->first_name) && !empty( $row->last_name) )
            {
                $donor=church_admin_formatted_name( $row);
                $wpdb->query('UPDATE '.CA_GIV_TBL.' SET name="'.esc_sql( $donor).'" WHERE giving_id="'.(int)$row->giving_id.'"');
            }
            /******************
             * Grab donations
             ******************/
            $amountCol='&nbsp;';
           $thisDonation=0;
            $amounts=$wpdb->get_results('SELECT * FROM '.CA_GMET_TBL.' WHERE giving_id="'.(int)$row->giving_id.'"');
            if(!empty( $amounts) )
            {
                
                foreach ( $amounts AS $amount)
                {
                    if(!empty( $amount->paypal_fee) )  {$fee=$amount->paypal_fee;}else{$fee=0;}
                    $net_amount=$amount->gross_amount-$fee;
                    $thisDonation+=$net_amount;
                    $currSymbol=!empty( $premium['currency_symbol'] )?$premium['currency_symbol']:"";
                    $amountCol.=esc_html( $amount->fund).': '.$currSymbol.$net_amount.'<br />';
                    
                }
                if( $thisDonation!=$net_amount)$amountCol.='<strong>'.__('Total','church-admin').': '.$currSymbol.floatval( $thisDonation).'</strong>';
               
            }
            
            
            
            if ( empty( $row->service) )$row->service='';
            if ( empty( $row->venue) )$row->venue='';
            if ( empty( $row->service_time) )$row->service_time='';
            $venue=implode(" ",array_filter(array( $row->service_name,$row->venue,$row->service_time) ));
            
            echo'<tr><td class="column-primary" data-colname="'.__('Donation date','church-admin').'">'.$date.' <button type="button" class="toggle-row"><span class="screen-reader-text">show details</span></button></td><td data-colname="'.__('Edit','church-admin').'">'.$edit.'</td><td  data-colname="'.__('Delete','church-admin').'">'.$delete.'</td>
            <td>'.$donor.'</td><td  data-colname="'.__('Attach','church-admin').'">'.$attach.'</td><td  data-colname="'.__('Email','church-admin').'">'.$email.'</td><td  data-colname="'.__('Address','church-admin').'">'.$address.'</td><td  data-colname="'.__('Venue','church-admin').'">'.esc_html( $venue).'</td><td data-colname="'.__('Transaction Type','church-admin').'">'.esc_html( $row->txn_type).'</td><td  data-colname="'.__('Frequency','church-admin').'">'.esc_html( $row->txn_frequency).'</td><td data-colname="'.__('Amounts','church-admin').'">'.$amountCol.'</td>';
            if(!empty( $row->thisGA) )
            {
                $GA=__('Yes','church-admin');
            }
            else
            {
                $GA=__('No','church-admin');
            }
            if(!empty( $premium['gift_aid'] ) )echo'<td  data-colname="'.__('Gift Aid','church-admin').'">'.$GA.'</td>';
            //add custom field data
            if(!empty( $custom_fields) )
                {
                    foreach( $custom_fields AS $id=>$field)
                    {
                        echo'<td>';
                        if( $field['section']!='giving')continue;
                        $thisData=$wpdb->get_row('SELECT * FROM '.CA_CUST_MET_TBL.' WHERE custom_id="'.(int)$id.'" AND gift_id="'.(int)$row->giving_id.'"');
                        
                        switch( $field['type'] )
                        {
                            case 'boolean':
                                if(!empty( $thisData->data) )  {$customOut==__('Yes','church-admin');}else{$customOut=__('No','church-admin');}
                            break;
                            case 'date':
                                if(!empty( $thisData->data) )  {$customOut=mysql2date(get_option('date_format'),$thisData->data);}else{$customOut="";}
                            break;
                            default:
                                if(!empty( $thisData->data) )  {$customOut=esc_html( $thisData->data);}else{$customOut="";}
                            break;
                        }
                        if(!empty( $customOut) )  {echo $customOut;}else{echo'&nbsp;';}
                        echo'</td>';
                    }
                }
            echo'</tr>';
        }
        echo'</tbody></table>';
        
}
/*************************************
*
*		Edit gift
*
**************************************/
function church_admin_giving_edit( $giving_id=NULL)
{
    
    /****************************************************************************
     * 2022-01-03 Update gifts can be split; 
     * giving meta table now holds donations for a particular gift
     ****************************************************************************/
    global $wpdb;
    
    //set up data variables
    $funds=get_option('church_admin_giving_funds');
    $custom_fields=church_admin_get_custom_fields();
    $premium=get_option('church_admin_payment_gateway');
    $currency_symbol=(!empty( $premium['currency_symbol'] ) )?$premium['currency_symbol']:"";
    $name=$person=$email=NULL;
    $donation_date=date('Y-m-d');
    if(!empty( $giving_id) )
    {
        $donation=$wpdb->get_row('SELECT * FROM '.CA_GIV_TBL.' WHERE giving_id="'.(int)$giving_id.'"');
        if(!empty( $donation) )
        {
           
            $donation_date=$donation->donation_date;
            if(!empty( $donation->people_id) )
            {
                $person=$wpdb->get_row('SELECT a.* FROM '. CA_PEO_TBL.' a, '.CA_HOU_TBL.' b WHERE a.people_id="'.(int)$donation->people_id.'" AND a.household_id=b.household_id');
                if(!empty( $person) )$name=esc_html(church_admin_formatted_name( $person) );
                if(!empty( $person) )$email=esc_html( $person->email);
            }
            else
            {
                $name=esc_html( $donation->name);
                $email=esc_html( $donation->email);
            }
            
            $amounts=$wpdb->get_results('SELECT * FROM '.CA_GMET_TBL.' WHERE giving_id="'.(int)$giving_id.'"');    
        }
    }
   

    if(!empty( $_POST['save-gift'] ) )
    {
        
        
        /**************************
         * Delete current values
         **************************/
        if(!empty( $giving_id) )
        {
            $wpdb->query('DELETE FROM '.CA_GIV_TBL.' WHERE giving_id="'.(int)$giving_id.'"');
            $wpdb->query('DELETE FROM '.CA_GMET_TBL.' WHERE giving_id="'.(int)$giving_id.'"');
        }
        $totalAmount=0;
        foreach( $_POST['amount'] AS $key=>$amt)  {$totalAmount+=(int)$amt;}
        
        if ( empty( $totalAmount) )
        {
            echo'<div class="notice notice-danger"><h2>'.__("Empty donation",'church-admin').'</h2>';
            echo'<p><a href="admin.php?page=church_admin/index.php&action=edit-gift">'.__('Enter a new donation','church-admin').'</a></p>';
            echo'</div>';
        }
        else
        {
           
            //donation date
            $donation_date=date('Y-m-d');
            if(!empty( $_POST['donation_date'] ) && church_admin_checkdate( $_POST['donation_date'] ) )
            {
                $donation_date=esc_sql( $_POST['donation_date'] );
            }
            //find people_id
            if(!empty( $_POST['donor'] ) )
            {
                $name=rtrim(stripslashes( $_POST['donor'] ),",");
                //look for people_id
                $sql='SELECT a.*,b.* FROM '.CA_PEO_TBL.' a, '.CA_HOU_TBL.' b WHERE a.household_id=b.household_id AND (a.first_name LIKE "'.esc_sql( $name).'" OR a.last_name LIKE "'.esc_sql( $name).'" OR CONCAT_WS(" ",a.first_name,a.last_name) LIKE "'.esc_sql( $name).'" OR CONCAT_WS(" ",a.first_name,a.prefix,a.last_name) LIKE "'.esc_sql( $name).'" OR CONCAT_WS(" ",a.first_name,a.middle_name,a.prefix,a.last_name) LIKE "'.esc_sql( $name).'" OR CONCAT_WS(" ",a.first_name,a.middle_name,a.last_name) LIKE "'.esc_sql( $name).'" OR CONCAT_WS(" ",a.first_name,a.prefix,a.last_name) LIKE "'.esc_sql( $name).'" OR  a.nickname LIKE "'.esc_sql( $name).'") ';
                //adding email makes it more robust to one person.
                if(!empty( $_POST['email'] ) )$sql.= ' AND a.email="'.esc_sql(stripslashes( $_POST['email'] ) ).'"';
                $sql.= ' LIMIT 1'; 
                $personDetails=$wpdb->get_row( $sql);
                
                if(!empty( $personDetails) )
                {
                    $name=church_admin_formatted_name( $personDetails);
                    $address=$personDetails->address;
                    $people_id=$personDetails->people_id;
                    $email=stripslashes( $_POST['email'] );
                }else
                {
                    $name=stripslashes( $_POST['donor'] );
                    $email=stripslashes( $_POST['email'] );
                    $people_id=NULL;
                    $address=NULL;
                }
            }
            //INSERT into giving table
            $wpdb->query('INSERT INTO '.CA_GIV_TBL.' (name,email,address,txn_type,txn_frequency,donation_date,people_id) VALUES("'.esc_sql( $name).'","'.esc_sql( $email).'","'.esc_sql( $address).'","'.esc_sql(stripslashes( $_POST['txn_type'] ) ).'","'.esc_sql(stripslashes( $_POST['txn_frequency'] ) ).'","'.esc_sql( $donation_date).'","'.(int)$people_id.'")');
            
            $giving_id=$wpdb->insert_id;
            //insert into giving meta
            $values=array();
            foreach( $_POST['fund'] AS $key=>$value)
            {
                $values[]='("'.esc_sql(floatval( $_POST['amount'][$key] ) ).'","'.esc_sql(stripslashes( $_POST['fund'][$key] ) ).'","'.(int)$giving_id.'")';
            }
            if(!empty( $values) )
            {
                $wpdb->query('INSERT INTO '.CA_GMET_TBL.' (gross_amount,fund,giving_id) VALUES '.implode(",",$values) );
            }
           
            echo'<div class="notice notice-success"><h2>'.__('Donation saved','church-admin').'</h2></div>';
            switch( $_POST['submission'] )
            {
                case __('Save and list gifts','church-admin'):
                    church_admin_giving_list();
                   
                break;
                default:
                    unset( $_POST);
                    church_admin_giving_edit(NULL);
                break;

            }  
        }         
    }
    else
    {
        /*********************
         * FORM
         ********************/
        $totalAmount=0;
        echo'<form action="" method="POST">';
        //date
        echo'<div class="church-admin-form-group" id="donation-date"><label>'.__('Donation date','church-admin').'</label>'.church_admin_date_picker( $donation_date,'donation_date',FALSE,date('Y-m-d',strtotime("-10 years") ),NULL,'donation_date','donation_date',FALSE).'</div>';
        //name
        echo'<div class="church-admin-form-group" id="donor"><label>'.__('Donor','church-admin').'</label>'.church_admin_autocomplete('donor','friends','to',$name).'</div>';
        //email
        echo '<div class="church-admin-form-group"  id="donation-email"><label>'.__('Email','church-admin').'</label><input type="email" name="email" value="'.$email.'" class="church-admin-form-control"/></div>';
        //donation type
        echo'<div class="church-admin-form-group"  id="donation-type"><label>'.__('Donation Type','church-admin').'</label><select class="church-admin-form-control" name="txn_type">';
        $types=array(__('Cash','church-admin'),__('Check','church-admin'),__('BACs','church-admin'),__('Standing order','church-admin') );
        foreach( $types AS $key=>$type)
        {
            echo '<option value="'.$type.'"';
            if(!empty( $gift->txn_type) && $gift->txn_type ==$type) echo 'selected="selected" ' ;
            echo'>'.$type.'</option>';
        }
        echo'</select></div>';
        //donation frequency
        $freq=array(__('One off','church-admin'),__('Weekly','church-admin'),__('Monthly','church-admin') );
        echo'<div class="church-admin-form-group"  id="donation-frequency"><label>'.__('Donation Frequency','church-admin').'</label><select class="church-admin-form-control" name="txn_frequency">';
        foreach( $freq AS $key=>$fr)
        {
            echo '<option value="'.$fr.'"';
            if(!empty( $gift->txn_type) && $gift->txn_type ==$fr) echo 'selected="selected" ' ;
            echo'>'.$fr.'</option>';
        }
        echo'</select></div>';
        //donations
        echo'<div class="church-admin-form-group"><label>'.__('Donation amount(s)','church-admin').'</label></div>';
        if(!empty( $amounts) )
        {
            
            foreach ( $amounts as $amount)
            {
                echo'<div class="church-admin-form-row"><div class="church-admin-form-col"><label>'.__('Fund','church-admin').'</label><select class="church-admin-form-control" name="fund[]">';
                foreach( $funds AS $key=>$fund)
                {
                    if(!empty( $amount->fund) && $amount->fund==$fund)  {$sel=' selected="selected" ';}else{$sel='';}
                    echo'<option value="'.esc_html( $fund).'" '.$sel.'>'.esc_html( $fund).'</option>';
                }
                echo'</select></div><div class="church-admin-form-col"><label>'.__('Amount','church-admin').'</label><input class="church-admin-form-control amount" type="number" step=".01" name="amount[]"';
                if(!empty( $amount->gross_amount) ) 
                {
                    echo ' value="'.floatval( $amount->gross_amount).'" ';
                    $totalAmount += $amount->gross_amount;
                }
                echo '/></div></div>';
                }
        }
        echo'<div class="church-admin-form-row" id="donation-row"><div class="church-admin-form-col"><label>'.__('Fund','church-admin').'</label><select class="church-admin-form-control" name="fund[]">';
        foreach( $funds AS $key=>$fund)
        {
            
            echo'<option value="'.esc_html( $fund).'">'.esc_html( $fund).'</option>';
        }
        echo'</select></div><div class="church-admin-form-col"><label>'.__('Amount','church-admin').'</label><input class="church-admin-form-control amount" type="number"  step=".01" name="amount[]" placeholder="'.__('Amount','church-admin').'"/></div></div>';
        //javascript
        echo'<div class="more-funds"></div><p><button class="another-fund button-secondary">'.__('Add another fund split amount','church-admin').'</button>';
        echo'<script>
        jQuery(document).ready(function( $)  {
            $(".another-fund").click(function(e)  {
                e.preventDefault();
                console.log("Clicked");
                $("#donation-row" ).clone().appendTo( ".more-funds" ).find("input").val("");
            });
            $(document).on("change paste keyup",".amount", function() {
                    console.log("Amount changed");
                    var sum = 0;
                    $(".amount").each(function()  {
                        console.log( $(this).val() );
                        sum += + $(this).val();
                    });
                    $(".totalAmount").html(sum);
            });

        });
        
        </script>';

        echo'<p><strong>'.__('Total donation:','church-admin').' '.$currency_symbol.'<span class="totalAmount">'.$totalAmount.'</span></strong></p>';
        //custom fields
        if(!empty( $custom_fields) )
        {
            foreach( $custom_fields AS $id=>$field)
            {
                if( $field['section']!='giving')continue;

                if(!empty( $gift) )
                {
                    $thisGiftCustomData=$wpdb->get_row('SELECT * FROM '.CA_CUST_MET_TBL.' WHERE gift_id="'.(int)$gift->gift_id.'" AND custom_id="'.(int)$id.'"');
                }
                else
                {
                    $gift = new stdClass();
                    $gift->gift_id=0;
                }
                echo'<div class="church-admin-address church-admin-form-group" ><label>'.esc_html( $field['name'] ).'</label>';
                switch( $field['type'] )
                {
                    case 'boolean':
                        echo'<input type="radio" name="custom-'.(int)$id.'" data-what="household-custom" data-custom-id="'.(int)$gift->gift_id.'" data-id="'.(int)$id.'" class="church-admin-form-control church-admin-editable"  value="1" ';
                        if (isset( $thisGiftCustomData->data)&&$thisGiftCustomData->data==1)echo 'checked="checked" ';
                        echo '>'.__('Yes','church-admin').'<br /> <input name="custom-'.(int)$id.'" type="radio" data-custom-id="'.(int)$gift->gift_id.'"  data-what="household-custom" data-ID="'.(int)$gift->gift_id.'" data-id="'.(int)$id.'" class="church-admin-form-control church-admin-editable" value="0" name="custom-'.(int)$id.'" ';
                        if (isset( $thisGiftCustomData->data)&& $$thisGiftCustomData->data==0) echo  'checked="checked" ';
                        echo '>'.__('No','church-admin');
                        break;
                    case'text':
                        echo '<input type="text" data-what="household-custom" data-custom-id="'.(int)$gift->gift_id.'"  data-id="'.(int)$id.'" class="church-admin-form-control church-admin-editable"  name="custom-'.(int)$id.'" ';
                        if(!empty( $thisGiftCustomData->data)||isset( $field['default'] ) )echo ' value="'.esc_html( $thisGiftCustomData->data).'"';
                        echo '/>';
                    break;
                    case'date':
                        if(!empty( $thisGiftCustomData->data) )  {$currentData=$thisGiftCustomData->data;}else{$currentData='';}
                        echo church_admin_date_picker( $currentData,'custom-'.(int)$id,FALSE,1910,date('Y'),'custom-'.(int)$id,'custom-'.(int)$id,FALSE,'household-custom',(int)$gift->gift_id,(int)$id);
                    
                    break;
                }
                echo '</div>';
                
            }

        }
        //submit
        echo'<div class="church-admin-form-group"><input type="hidden" name="save-gift" value="TRUE"/><input type="submit" name="submission" value="'.__('Save and list gifts','church-admin').'"  class="button-primary"/>&nbsp;<input name="submission" type="submit" value="'.__('Save and enter another','church-admin').'"  class="button-primary"/></div>';
        echo'</form>';
    }

}



/*************************************
*
*		refund gift
*
**************************************/
function church_admin_giving_delete( $giving_id=NULL)
{
    global $wpdb;
    echo'<h1>'.__('Delete gift','church-admin').'</h1>';
    $wpdb->query('DELETE FROM '.CA_GIV_TBL.' WHERE giving_id="'.(int)$giving_id.'"');
    $wpdb->query('DELETE FROM '.CA_GMET_TBL.' WHERE giving_id="'.(int)$giving_id.'"');
    echo'<div class="notice notice-success">'.__('Gift deleted','church-admin').'</div>';
    church_admin_giving_list();

}
/*************************************
*
*		View donor
*
**************************************/
function church_admin_donor_giving( $people_id=NULL)
{
    
    global $wpdb;
    $person=$wpdb->get_row('SELECT * FROM '.CA_PEO_TBL.' WHERE people_id="'.(int)$people_id.'"');
    if ( empty( $person) )return '<div class="notice notice-success"><h2>'.__('Person not found','church-admin').'</h2></div>';

    echo'<h1>'.sprintf(__('View donor giving for %1$s','church-admin'),church_admin_formatted_name( $person) ).'</h1>';
    $sql='SELECT a.*,b.*,c.*,a.gift_aid AS thisGA,a.email AS donor_email,a.address AS donor_address FROM '.CA_GIV_TBL.' a LEFT JOIN '.CA_PEO_TBL.' b ON a.people_id=b.people_id  LEFT JOIN '.CA_SER_TBL.' c ON a.service_id=c.service_id WHERE b.people_id="'.(int)$people_id.'" ORDER BY donation_date DESC,giving_id DESC'; 
    $results=$wpdb->get_results( $sql);
    if ( empty( $results) ) return '<div class="notice notice-success"><h2>'.__('No gifts found','church-admin').'</h2></div>';
    church_admin_giving_table( $results);
}
/*************************************
*
*		GIVING funds
*
**************************************/
function church_admin_giving_funds()
{
    echo'<p><a class="button-primary" href="'.wp_nonce_url('admin.php?page=church_admin/index.php&amp;action=edit-fund&amp;section=giving','edit-fund').'">'.__('Add fund','church-admin').'</a></p>';
    $funds=get_option('church_admin_giving_funds');
    if(!empty( $funds) )
    {
        $tableHeader='<tr><th>'.__('Edit','church-admin').'</th><th>'.__('Delete','church-admin').'</th><th>'.__('Fund name','church-admin').'</th></tr>';
        echo'<p>'.__("Deleting a fund won't affect previous donations to that fund",'church-admin').'</p>';
        echo'<table class="widefat striped"><thead>'.$tableHeader.'</thead><tfoot>'.$tableHeader.'<tfoot><tbody>';
        foreach( $funds AS $key=>$fund)
        {
            $edit='<a class="button-secondary" href="'.wp_nonce_url('admin.php?page=church_admin/index.php&amp;action=edit-fund&amp;section=giving&amp;fund_id='.(int)$key,'edit-fund').'">'.__('Edit','church-admin').'</a>';
            $delete='<a onclick="return confirm(\''.__('Are you sure you want to delete this item?','church-admin').'\')" class="button-secondary" href="'.wp_nonce_url('admin.php?page=church_admin/index.php&amp;action=delete-fund&amp;section=giving&amp;fund_id='.(int)$key,'delete-fund').'">'.__('Delete','church-admin').'</a>';
            echo'<tr><td>'.$edit.'</td><td>'.$delete.'</td><td>'.esc_html( $fund).'</td></tr>';
        }
        echo'</tbody></table>';
    }
    
}
/*************************************
*
*		Delete Fund
*
**************************************/

function church_admin_delete_fund( $id)
{
    $funds=get_option('church_admin_giving_funds');
    unset( $funds[$id] );
    update_option('church_admin_giving_funds',$funds);
    echo'<div class="notice notice-success">'.__('Fund deleted','church-admin').'</div>';
        church_admin_giving_funds();
}
/*************************************
*
*		Edit Fund
*
**************************************/
function church_admin_edit_fund( $id)
{
    $funds=get_option('church_admin_giving_funds');
    
    if(!empty( $_POST['save-fund'] ) )
    {
        if(isset( $id) )
        {
            $funds[$id]=stripslashes( $_POST['fund'] );
        }else $funds[]=stripslashes( $_POST['fund'] );
        update_option('church_admin_giving_funds',$funds);
        echo'<div class="notice notice-success">'.__('Fund edited','church-admin').'</div>';
        church_admin_giving_funds();
    }
    else
    {
        echo'<h2>'.__('Edit Fund','church-admin').'</h2>';
        echo'<form action="" method="POST">';
        echo'<div class="church-admin-form-group"><label>'.__('Fund name','church-admin').'</label><input type="text" name="fund" ';
        if(!empty( $id)&&!empty( $funds[$id] ) ) echo ' value="'.esc_html( $funds[$id] ).'"';
        echo'/></div>';
        echo'<div class="church-admin-form-group"><input type="hidden" name="save-fund" value="TRUE"/><input type="submit" value="Save"  class="button-primary">';
        
    }
}
/*************************************
*
*		CSV  Form
*
**************************************/
function church_admin_giving_csv()
{
    global $wpdb; 
    echo'<h2>'.__('Download CSV','church-admin').'</h2>';
    echo'<form action="" method="GET"><input type="hidden" name="ca_download" value="giving-csv"/>';
    echo'<div class="church-admin-form-group"><label>'.__('Start date','church-admin').'</label>'.church_admin_date_picker('start_date','start_date',FALSE,date('Y-m-d',strtotime("-10 years") ),NULL,'start_date','start_date',FALSE).'</div>';
    echo'<div class="church-admin-form-group"><label>'.__('End date','church-admin').'</label>'.church_admin_date_picker('end_date','end_date',FALSE,date('Y-m-d',strtotime("-10 years") ),NULL,'end_date','end_date',FALSE).'</div>';
    //people
    $sql='SELECT a.* FROM '.CA_PEO_TBL.' a, '.CA_GIV_TBL.' b WHERE a.people_id=b.people_id GROUP BY a.people_id ORDER By a.last_name';
   
    $results=$wpdb->get_results( $sql);
    if(!empty( $results) )
    {
        echo'<div class="church-admin-form-group"><label>'.__('People','church-admin').'</label><select name="people_id" class="church-admin-form-control"><option value="0">'.__('Everyone','church-admin').'</option>';
        foreach( $results AS $row)
        {
            $name=implode(" ",array_filter(array( $row->first_name,$row->prefix,$row->last_name) ));
            echo'<option value="'.(int)$row->people_id.'">'.esc_html( $name).'</option>';
        }
        echo '</select></div>';
    }
    
    echo'<div class="church-admin-form-group"><input type="hidden" name="save-fund" value="TRUE"/><input type="submit" value="Save"  class="button-primary"></form>';
}
function church_admin_gift_aid_csv()
{
    global $wpdb; 
    echo'<h2>'.__('Download Gift Aid Report CSV','church-admin').'</h2>';
    $premium=get_option('church_admin_payment_gateway');
    if ( empty( $premium['gift_aid'] ) )
    {
        echo '<p>'.__('You need to be an app subscriber and have setup the Paypal details to include Gift Aid',"church-admin").'</p>';
        return;
    }
    
    echo'<form action="" method="GET"><input type="hidden" name="ca_download" value="gift-aid-csv"/>';
    echo'<div class="church-admin-form-group"><label>'.__('Start date','church-admin').'</label>'.church_admin_date_picker('start_date','start_date',FALSE,date('Y-m-d',strtotime("-10 years") ),NULL,'start_date','start_date',FALSE).'</div>';
    echo'<div class="church-admin-form-group"><label>'.__('End date','church-admin').'</label>'.church_admin_date_picker('end_date','end_date',FALSE,date('Y-m-d',strtotime("-10 years") ),NULL,'end_date','end_date',FALSE).'</div>';
    $funds=get_option('church_admin_giving_funds');
    echo '<div class="church-admin-form-group"><label>'.__('Fund','church-admin').'</label><select name="fund"><option value="All">'.__('All','church-admin').'</option>';
    foreach( $funds AS $key=>$fund)
    {
        echo'<option value="'.urlencode( $fund).'">'.esc_html( $fund).'</option>';
    }
    echo'</select></div>';
    echo'<div class="church-admin-form-group"><input type="hidden" name="save-fund" value="TRUE"/><input type="submit" value="Save"  class="button-primary"></form>';
}

/*******************************
 *  Giving Receipts
 ******************************/

 function church_admin_giving_receipts()
 {
    global $wpdb;
    echo'<h2>'.__("Giving receipts",'church-admin').'</h2>';
    /******************************************
     * Check for previously generated receipts
     ******************************************/
    $maxReceiptID=$wpdb->get_var('SELECT MAX(receipt_id) FROM '.CA_GIV_TBL);
    if(!empty( $maxReceiptID) )
    {
        $nextReceptID = $maxReceiptID + 1;
        update_option('church_admin_receipt_id',(int)$nextReceptID);
        echo '<p>'.sprintf(__('Latest receipt ID is %1$s','church-admin'),(int)$maxReceiptID).'</p>';
    }
    else
    {
        update_option('church_admin_receipt_id',1);
        if(!empty( $_POST['next_receipt_id'] ) )
        {
            update_option('church_admin_receipt_id',(int)$_POST['next_receipt_id'] );
        }
        else
        {
            echo'<form action="" method="POST">';
            echo'<div class="church-admin-form-group"><label>'.__('You can set your next receipt ID if you wish (the default is 1)','church-admin').'</label>';
            echo'<input class="church-admin-form-control" type="number" name="next_receipt_id"/></div>';
            echo'<div class="church-admin-form-group"><input type="hidden" name="save-receipt-id" value="TRUE"/><input type="submit" value="Save"  class="button-primary"></form>';
        }

    }
    /*****************************************
     * Form to get previous receipt numbers
     ****************************************/
    $receipts=$wpdb->get_results('SELECT DISTINCT `receipt_id`, `name`, `donation_date` FROM '.CA_GIV_TBL.' WHERE receipt_id IS NOT NULL ORDER BY receipt_id DESC');
    if(!empty( $receipts) )
    {
        echo'<h3>'.__('Download a previous donor PDF receipt','church-admin').'</h3>';
        echo'<form action="'.site_url().'" method="GET"><input type="hidden" name="ca_download" value="donor-receipt"/>';
        echo'<div class="church-admin-form-group"><label>'.__('Select previous receipt','church-admin').'</label><select name="receipt_id">';
        foreach( $receipts AS $receipt)
        {
            echo '<option value="'.(int)$receipt->receipt_id.'">'.esc_html(mysql2date(get_option('date_format'),$receipt->donation_date).' '. $receipt->name).'</option>';
        }
        echo'</select>';
        echo'<input class="button-primary" type="submit" value="'.__("Download PDF receipt",'church-admin').'"/></div>';
        echo'</form>';
    }
    /*****************************************
     * Form to create receipts between dates
     ****************************************/
    echo '<h3>'.__('Choose dates for new receipts for each donor','church-admin').'</h3>';
    echo '<form action="" method="POST">';
    echo '<div class="church-admin-form-group"><label>'.__('Start date','church-admin').'</label>'.church_admin_date_picker('start_date','start_date',FALSE,date('Y-m-d',strtotime("-10 years") ),NULL,'start_date','start_date',FALSE).'</div>';
    echo '<div class="church-admin-form-group"><label>'.__('End date','church-admin').'</label>'.church_admin_date_picker('end_date','end_date',FALSE,date('Y-m-d',strtotime("-10 years") ),NULL,'end_date','end_date',FALSE).'</div>';
    echo'<div class="church-admin-form-group"><input type="checkbox" name="send-email"/>'.__('Send receipt email to donors','church-admin').'</div>';
    echo '<p><input class="button-primary" type="submit" value="'.__('Generate donor receipts','church-admin').'"/></p>';
    echo '</form>';

    if(!empty( $POST['receipt_id'] ) )church_admin_donor_receipt( $_POST['receipt_id'] );
    elseif(!empty( $_POST['start_date'] )&&!empty( $_POST['end_date'] ) )
    {
        church_admin_create_fund_receipt( $_POST['start_date'],$_POST['end_date'] );
        church_admin_create_donor_receipts( $_POST['start_date'],$_POST['end_date'] );
    }
 }

 function church_admin_create_donor_receipts( $start_date, $end_date)
 {
    global $wpdb;
    if(!church_admin_checkdate( $start_date) ) return __('Invalid start date','church-admin');
    if(!church_admin_checkdate( $end_date) ) return __('Invalid end date','church-admin');
    $date_range=sprintf(__('%1$s to %2$s','church-admin'),mysql2date(get_option('date_format'),$start_date),mysql2date(get_option('date_format'),$end_date) );
    $results=$wpdb->get_results('SELECT a.*,b.* FROM '.CA_GIV_TBL.' a, '.CA_GMET_TBL.' b WHERE a.giving_id=b.giving_id AND a.receipt_id IS NULL AND a.donation_date BETWEEN "'.esc_sql( $start_date).'" AND "'.esc_sql( $end_date).'"');
    if(!empty( $results) )
    {
        $receipt_id=get_option('church_admin_receipt_id');
        $recIDs=array();
        $donorReceipts=array();
        foreach( $results AS $row)
        {
            if ( empty( $recIDS[$row->name] ) )  {$recIDS[$row->name]=$receipt_id++;}

            $ID=$wpdb->get_var('SELECT ID FROM '.CA_REC_TBL.' WHERE person="'.esc_sql( $row->name).'" AND fund="'.esc_sql( $row->fund).'" AND receipt_id="'.(int)$recIDS[$row->name].'"');
            if ( empty( $ID) )
            {
                $wpdb->query('INSERT INTO '.CA_REC_TBL.' (person,email,receipt_id,fund,amount,date_range)VALUES("'.esc_sql( $row->name).'","'.esc_sql( $row->email).'","'.(int)$recIDS[$row->name].'","'.esc_sql( $row->fund).'","'.floatval( $row->gross_amount).'","'.esc_sql( $date_range).'")');
            }
            else
            {
                $wpdb->query('UPDATE '.CA_REC_TBL.' SET amount = amount + "'.floatval( $row->gross_amount).'" WHERE ID="'.(int)$ID.'"');
            }
            church_admin_debug( $wpdb->last_query);
            $wpdb->query('UPDATE '.CA_GIV_TBL.' SET receipt_id="'.(int)$recIDS[$row->name].'" WHERE giving_id="'.(int)$row->giving_id.'"');
            $donorReceipts[$row->name]=$recIDS[$row->name];
        }
        update_option('church_admin_receipt_id',$receipt_id);
        //display
        echo'<h2>'.__('Receipts','church-admin').' '.$date_range.'</h2>';
        $table='<table class="widefat striped bordered"><tr><thead><th>'.__('Email','church-admin').'</th><th>'.__('Download PDF','church-admin').'</th><th>'.__('Receipt ID','church-admin').'</th><th>'.__('Name','church-admin').'</th><th>'.__('Email','church-admin').'</th></tr></thead><tbody>';
        foreach( $donorReceipts AS $key=>$receipt_id)
        {
            if(!empty( $_POST['send-email'] ) )church_admin_email_donor_receipt( $receipt_id);
            $emailReceipt='<a href="admin.php?page=church_admin/index.php&action=email-donor-receipt&receipt_id='.(int)$receipt_id.'">'.__('Email receipt').'</a>';
            $pdf='<a href="'.site_url().'?ca_download=donor-receipt&receipt_id='.(int)$receipt_id.'">'.__('PDF receipt').'</a>';
            $details=$wpdb->get_row('SELECT * FROM '.CA_GIV_TBL.' WHERE receipt_id="'.(int)$receipt_id.'"' );
            $name=esc_html( $details->name);
            $email='<a href="'.esc_url('mailto:'.$details->email).'">'.esc_html( $details->email).'</a>';
            $table.='<tr><td>'.$emailReceipt.'</td><td>'.$pdf.'</td><td>'.(int)$receipt_id.'</td><td>'.$name.'</td><td>'.$email.'</td></tr>';
        }
        echo $table.'</tbody></table>';
    }else
    {
        //no results
        $results=$wpdb->get_results('SELECT DISTINCT a.receipt_id,a.*,b.* FROM '.CA_GIV_TBL.' a, '.CA_GMET_TBL.' b WHERE a.giving_id=b.giving_id AND a.receipt_id IS NOT NULL AND a.donation_date BETWEEN "'.esc_sql( $start_date).'" AND "'.esc_sql( $end_date).'"');
        if(!empty( $results) )
        {
            //receipts already produced, so show them
            echo'<h2>'.sprintf(__('Receipts already produced for %1$s','church-admin'),$date_range).'</h2>';
            echo '<table class="widefat striped bordered"><tr><thead><th>'.__('Email','church-admin').'</th><th>'.__('Download PDF','church-admin').'</th><th>'.__('Receipt ID','church-admin').'</th><th>'.__('Name','church-admin').'</th><th>'.__('Email','church-admin').'</th></tr></thead><tbody>';
            foreach( $results AS $row)
            {

                $emailReceipt='<a href="admin.php?page=church_admin/index.php&action=email-donor-receipt&receipt_id='.(int)$row->receipt_id.'">'.__('Email receipt').'</a>';
                $pdf='<a href="'.site_url().'?ca_download=donor-receipt&receipt_id='.(int)$row->receipt_id.'">'.__('PDF receipt').'</a>';
                
                $name=esc_html( $row->name);
                $email='<a href="'.esc_url('mailto:'.$row->email).'">'.esc_html( $row->email).'</a>';
                echo'<tr><td>'.$emailReceipt.'</td><td>'.$pdf.'</td><td>'.(int)$row->receipt_id.'</td><td>'.$name.'</td><td>'.$email.'</td></tr>';
            }
            echo '</tbody></table>';
        }else{echo'<div class="notice notice-danger"><h2>'.sprintf(__('No donations found for %1$s','church-admin'),$date_range).'</h2></div>';}
    }
 }

 

function church_admin_create_fund_receipt( $start_date, $end_date)
 {  
    global $wpdb;
    $premium=get_option('church_admin_payment_gateway');
    if(!empty( $premium['currency_symbol'] ) )  {$currSymbol=$premium['currency_symbol'];}else{$currSymbol='';}
    if(!church_admin_checkdate( $start_date) ) return __('Invalid start date','church-admin');
    if(!church_admin_checkdate( $end_date) ) return __('Invalid end date','church-admin');
    $date_range=sprintf(__('%1$s to %2$s','church-admin'),mysql2date(get_option('date_format'),$start_date),mysql2date(get_option('date_format'),$end_date) );
    echo'<h2>'.__('Fund Receipt','church-admin').'</h2>';
    $results=$wpdb->get_results('SELECT DISTINCT a.receipt_id,a.*,b.* FROM '.CA_GIV_TBL.' a, '.CA_GMET_TBL.' b WHERE a.giving_id=b.giving_id AND a.receipt_id IS NOT NULL AND a.donation_date BETWEEN "'.esc_sql( $start_date).'" AND "'.esc_sql( $end_date).'"');
    $fundTotals=array();
    if(!empty( $results) )
    {
        foreach( $results AS $row)
        {
            if ( empty( $fundTotals[$row->fund] ) )
            {
                $fundTotals[$row->fund] = $row->gross_amount;
            }
            else
            {
                $fundTotals[$row->fund] += $row->gross_amount;
            }
        }
    }
    if(!empty( $fundTotals) )
    {
        echo'<h3>'.sprintf(__('Fund Totals for %1$s'),$date_range).'</h3>';
        echo'<table class="widefat fixed striped">';
        foreach( $fundTotals AS $fund=>$amount)
        {
            echo'<tr><th scope="row">'.esc_html( $fund).'</th><th>'.esc_html( $currSymbol.$amount).'</td></tr>';
        }
        echo'</table>';

    }
 }


 function church_admin_email_donor_receipt( $receipt_id)
 {
    global $wpdb;
    $total=0;
    $premium=get_option('church_admin_payment_gateway');
    if(!empty( $premium['currency_symbol'] ) )  {$currSymbol=$premium['currency_symbol'];}else{$currSymbol='';}
    $results=$wpdb->get_results('SELECT * FROM '.CA_REC_TBL.' WHERE receipt_id="'.(int)$receipt_id.'" ORDER BY fund ASC');
    if ( empty( $results) ) 
    {
        echo'<div class="notice notice-danger"><h2>'.__('Receipt not found','church-admin').'</h2></div>';
        return FALSE;
    }
    $subject=esc_html(sprintf(__('Receipt for donations %1$s for %2$s','church-admin'),esc_html( $results[0]->date_range),esc_html( $results[0]->person) ));
    $emailMessage = '<h2>'.$subject.'</h2>';
    $emailMessage .= get_option('church_admin_receipt_email_template');
    $emailMessage .= '<table><thead><tr><th>'.__('Fund','church-admin').'</th><th>'.__('Amount','church-admin').'</th></tr></thead><tbody>';
    foreach( $results AS $row)
    {
        $emailMessage .='<tr><td>'.esc_html( $row->fund).'</td><td>'.esc_html( $currSymbol.$row->amount).'</td></tr>';
        $total += $row->amount;
    }
    $emailMessage .='<tr><td><strong>'.__('Total','church-admin').'</strong></td><td><strong>'.esc_html( $currSymbol.$total).'</strong></td></tr>';
    $emailMessage .= '</tbody></tr>';
    $from_name=get_option('church_admin_finance_email_from_name');
    if ( empty( $from_name) )$from_name=church_admin_from_name(NULL);

    $from_email=get_option('church_admin_finance_email_from_email');
    if ( empty( $from_email) )$from_name=church_admin_from_email(NULL);

    if(get_option('church_admin_cron')!='immediate')
    {

        $emails[]=$row->email;
       if(QueueEmail( $row->email,$subject,$emailMessage,NULL,$from_name,$from_email,NULL,NULL) ) echo'<p>'.esc_html( $row->email).' queued</p>';
    }
    else
    {
        $from_name = get_option('church_admin_receipt_email_from_name');
		$from_email = get_option('church_admin_receipt_email_from_email');
        add_filter( 'wp_mail_from_name',function( $from_name)  {return $from_name; } );
        add_filter( 'wp_mail_from', function( $from_email)  {return $from_email; });
        add_filter('wp_mail_content_type','church_admin_email_type');
        if(!empty( $row->email) )
        {
            //use native wordpress
            if(wp_mail( $row->email,$subject,$emailMessage) )  {echo'<p>'.esc_html( $row->email).' sent immediately</p>';}
            else {echo $GLOBALS['phpmailer']->ErrorInfo;}
        }
        remove_filter('wp_mail_content_type','church_admin_email_type');
        remove_filter( 'wp_mail_from',function( $from_name)  {return $from_name; } );
        remove_filter( 'wp_mail_from_name', function( $from_email)  {return $from_email; });
    }


    return;

 }

