<?php

if ( ! defined( 'ABSPATH' ) ) exit('You need Jesus!'); // Exit if accessed directly

/*******************************
 * CHECK FOR MailChimp Webhook
 *******************************/
function church_admin_check_mailchimp_webhook()
{
	require_once(plugin_dir_path(dirname(__FILE__) ).'includes/mailchimp.inc.php');
	
	$settings=get_option('church_admin_mailchimp');
	if ( empty( $settings['api_key'] ) && $settings['listID'] )return FALSE;
	echo'<p>Checking for webhook to sync from MailChimp back to Church Admin</p>';
	$MailChimp = new MailChimp( $settings['api_key'] );
	$MailChimp->verify_ssl = 'false';
	
	$result = $MailChimp->get("/lists/{$settings['listID']}/webhooks");
	
	$hooks=FALSE;
	if(!empty( $result['webhooks'] ) )
	{
		foreach( $result['webhooks'] AS $key=>$hook)
		{
			if( $hook['url']==admin_url().'admin-ajax.php?action=church_admin&method=mailchimp_webhook')
			{
				$hooks=TRUE;
				echo'<p>'.__('MailChimp Webhook found to sync MailChimp subscribes to Church Admin','church-admin').'</p>';
			}
		}
	}
	
	if ( empty( $hooks) )church_admin_create_webhook();
	
}

function church_admin_create_webhook()
{
	require_once(plugin_dir_path(dirname(__FILE__) ).'includes/mailchimp.inc.php');
	$settings=get_option('church_admin_mailchimp');
	if ( empty( $settings['api_key'] ) && $settings['listID'] )return FALSE;
	$MailChimp = new MailChimp( $settings['api_key'] );
	$MailChimp->verify_ssl = 'false';
	//create a webhook
	$args=array(
		'list_id'=>$settings['listID'],
		'url'=>admin_url().'admin-ajax.php?action=church_admin&method=mailchimp_webhook',
		'events'=>array('subscribe'=>true,
					'unsubscribe'=>true,
					'upemail'=>true
				)

	);
	
	$result = $MailChimp->post("/lists/{$settings['listID']}/webhooks",$args);
	if(!empty( $result['errors'] ) )
	{
		foreach( $result['errors'] AS $key=>$error) echo '<p>'.esc_html( $error['message'] ).'</p>';
		echo '<p>URL: '.admin_url().'admin-ajax.php?action=church_admin&method=mailchimp_webhook';
	}
	elseif(!empty( $result['url'] )&& $result['url']==admin_url().'admin-ajax.php?action=church_admin&method=mailchimp_webhook')
	{
		echo'<p><strong>'.__('MailChimp Webhook created to sync MailChimp subscribes to Church Admin','church-admin').'</strong></p>';
	}

}
/****************************
 * MAILCHIMP WebHook
 ***************************/
function church_admin_mailchimp_webhook()
{
	global $wpdb;
	$settings=get_option('church_admin_mailchimp');
	if ( empty( $settings['listID'] ) ) return;
	if ( empty( $_POST['type'] ) ) return;
	if ( empty( $_POST['data']['id'] )||$_POST['data']['id']!=$settings['listID'] ) return;

	$first_name=esc_sql(stripslashes( $_POST['data']['merges']['FNAME'] ) );
	$last_name=esc_sql(stripslashes( $_POST['data']['merges']['LNAME'] ) );
	$email=esc_sql(stripslashes( $_POST['data']['email'] ) );
	
	switch( $_POST['type'] )
	{
		case 'subscribed':
			$people=$wpdb->get_row('SELECT * FROM '.CA_PEO_TBL.' WHERE first_name="'.$first_name.'" AND last_name="'.$last_name.'" AND email="'.$email.'" LIMIT 1');
			if ( empty( $people) )
			{
				$wpdb->query('INSERT INTO '.CA_HOU_TBL.'(address) VALUES("")');
				$household_id=$wpdb->insert_id;
				$wpdb->query('INSERT INTO '.CA_PEO_TBL.'first_name,last_name,email,head_of_household,show_me,household_id,member_type_id,last_updated,gdpr_reason,mail_send) VALUES ("'.$first_name.'","'.$last_name.'","'.$email.'",1,0,"'.(int)$household_id.'",1,"'.date('Y-m-d').'","'.__('Added from MailChimp','church-admin').'",1)');
			}
		break;
		case 'unsubscribed':
			$people=$wpdb->get_row('SELECT * FROM '.CA_PEO_TBL.' WHERE first_name="'.$first_name.'" AND last_name="'.$last_name.'" AND email="'.$email.'" LIMIT 1');
			if(!empty( $people) )
			{
				$wpdb->query('UPDATE '.CA_PEO_TBL.' SET mail_send=0 WHERE people_id="'.(int)$people->people_id.'"');
			}
		break;
		case 'upemail':
			$old_email=esc_sql(stripslashes['data']['old_email'] );
			$new_email=esc_sql(stripslashes['data']['new_email'] );
			$people=$wpdb->get_row('SELECT * FROM '.CA_PEO_TBL.' WHERE first_name="'.$first_name.'" AND last_name="'.$last_name.'" AND email="'.$old_email.'" LIMIT 1');
			if ( empty( $people) )
			{
				$wpdb->query('UPDATE '.CA_PEO_TBL.' SET email="'.$new_email.'" WHERE people_id="'.(int)$people->people_id.'"');
			}
		break;

	}


}




/**
 *
 * Mailchimp sync
 *
 * @author  Andy Moyle
 * @param
 * @return   html string
 * @version  0.1
 *
 *
 */
function church_admin_mailchimp_sync()
{
	global $wpdb;
	require_once(plugin_dir_path(dirname(__FILE__) ).'includes/mailchimp.inc.php');
	echo'<h2>Mailchimp Sync</h2>';
	
	$settings=get_option('church_admin_mailchimp');
	/*********************
	*
	* Set API key
	*
	**********************/
	if(!empty( $_POST['save-api-key'] ) )
	{
		$settings['api_key']=stripslashes( $_POST['api_key'] );
		update_option('church_admin_mailchimp',$settings);
	}

	echo'<h3 id="step1" class="ca-click">'.__('Step 1 - API key','church-admin').'</h3><div class="step1">';
	echo'<p><a target="_blank" href="https://us2.admin.mailchimp.com/account/api">'.__( 'Click here to get your Mailchimp API key','church-admin').'</a></p>';
	echo'<form action="" method="POST">
			<table>
				<tbody>
					<tr>
						<th scope="row">Mailchimp API key</th>
						<td><input type="text" name="api_key" ';
	if(!empty( $settings['api_key'] ) )echo ' value="'.esc_html( $settings['api_key'] ).'"';
	echo '/></td><td><input type="hidden" name="save-api-key" value="true"/><input type="submit" class="button-secondary" value="'.esc_html(__('Save','church-admin') ).'"/>
		</td>
	</tr>
	</table>
	</form></div>';
	
	if(!empty( $settings['api_key'] ) )
	{
		try{$MailChimp = new MailChimp( $settings['api_key'] );}
		catch(Exception $e)
		{
			echo $e->getMessage();
			return;
		}
		
		$MailChimp->verify_ssl = 'false';
	}
	/******************************
	 *  Make sure list is selected
	 ******************************/
	if(!empty( $MailChimp) )
	{
		$result = $MailChimp->get("lists");
		/*********************
		*
		* Set listID
		*
		**********************/
		if(!empty( $_POST['save-listID'] ) )
		{
			$settings['listID']=stripslashes( $_POST['listID'] );
			update_option('church_admin_mailchimp',$settings);
		}

		$lists=$result['lists'];
		echo '<h3 id="step2" class="ca-click">'.__('Step 2 - Your Mailchimp lists','church-admin').'</h3><div class="step2"><form action="" method="POST">';
		foreach( $lists AS $list)
		{
			echo'<p><input type="radio" name="listID" value="'.esc_html( $list['id'] ).'"';
			if(!empty( $settings['listID'] ) && $settings['listID']==$list['id'] ) echo ' checked="checked" ';
			echo'/> '.esc_html( $list['name'] ).'</p>';
		}
		echo'<p><input type="hidden" name="save-listID" value="true"/><input type="submit" class="button-secondary" value="'.esc_html(__('Save','church-admin') ).'"/></p></form></div>';
	}
	
	/*******************************************************
	* only show sync button if api key and listID is set
	********************************************************/
	if(!empty( $settings['api_key'] )&&!empty( $settings['listID'] ) )
	{
			echo'<h3>'.__('Step 3 - Sync mailchimp','church-admin').'</h3>';
			echo'<p><strong>'.__('Please wait after clicking sync button','church-admin').'</strong></p>';
			echo'<p><form action="" method="POST"><input type="hidden" name="sync" value="true"/><input class="button-primary" type="submit" ';
			if(!empty( $_POST['sync'] ) )echo ' disabled="disabled" ';
			echo 'value="'.__('Sync','church-admin').'"/></form></p>';
			
	}
	/**********************************************
 	*  Start Sync
 	**********************************************/
	 if(!empty( $settings['api_key'] )&&!empty( $settings['listID'] ) && !empty( $_POST['sync'] ) )
	 {
		 /*********************************************
		  * Go through directory and update MailChimp
		  ********************************************/
		  $people=$wpdb->get_results('SELECT * FROM '.CA_PEO_TBL.' WHERE email IS NOT NULL');
		  if(!empty( $people) )
		  {
			  foreach( $people AS $person)  echo church_admin_update_mailchimp_member( $person,NULL,TRUE);
		  }
		  church_admin_check_mailchimp_webhook();
		  /************************************************
		  * Get tags from MailChimp and save to options
		  ************************************************/
		  church_admin_get_mailchimp_tags();
		  update_option('church_admin_mail_chimp_syncd',date('Y-m-d') );
	 }
}






/**********************************************************
*  Updates ioptions table with latest tags
*  2021-12-09
* 	Andy Moyle
***********************************************************/  


function church_admin_get_mailchimp_tags()
{
	require_once(plugin_dir_path(dirname(__FILE__) ).'includes/mailchimp.inc.php');
	$mailChimpSettings=get_option('church_admin_mailchimp');
	if ( empty( $mailChimpSettings['api_key'] ) && !empty( $mailChimpSettings['listID'] ) ) return FALSE;
	$MailChimp = new MailChimp( $mailChimpSettings['api_key'] );
	$MailChimp->verify_ssl = 'false';
	$tagList=$MailChimp->get("/lists/{$mailChimpSettings['listID']}/tag-search?count=1000");

	if(!empty( $tagList['tags'] ) )
	{
		$tags=array();
		foreach( $tagList['tags'] AS $key=>$tag)
		{
			$tags[$tag['id']]=$tag['name'];
		}
		
		update_option('church_admin_mailchimp_tags',$tags);
	}
}
/**********************************************************
*   Gets array of tags for a person.
***********************************************************/  
function church_admin_mailchimp_person_tags( $people_id)
{
	
	global $wpdb;
	$tags=array();
	$data=$wpdb->get_row('SELECT * FROM '.CA_PEO_TBL.' WHERE people_id="'.(int)$people_id.'"');
	if(!empty( $data) )
	{
		
		if(!empty( $data->news_send) )  {$active='active';}else{$active='inactive';}
		$tags[]=array('name'=>'news-send','status'=>$active);
		//prayer-requests
		$prayer_requests=$wpdb->get_var('SELECT * FROM '.CA_MET_TBL.' WHERE people_id="'.(int)$people_id.'" AND meta_type="prayer-requests"');
		if(!empty( $prayer_requests) )  {$active='active';}else{$active='inactive';}
		$tags[]=array('name'=>'prayer-requests','status'=>$active);
		//bible-readings
		$bible_readings=$wpdb->get_var('SELECT * FROM '.CA_MET_TBL.' WHERE people_id="'.(int)$people_id.'" AND meta_type="bible-readings"');
		church_admin_debug( $wpdb->last_query);
		if(!empty( $bible_readings) )  {$active='active';}else{$active='inactive';}
		$tags[]=array('name'=>'bible-readings','status'=>$active);
		/*********************
		*
		* Build tag list
		*
		**********************/
		//gender
		$gender=get_option('church_admin_gender');
		foreach( $gender AS $key=>$sex)
		{
			if( $data->sex==$key)  {$active='active';}else{$active='inactive';}
			$tags[]=array('name'=>$sex,'status'=>$active);
		}
		//member types
		$member_types=church_admin_member_type_array();
		foreach( $member_types AS $id=>$member_type)
		{
			if( $data->member_type_id==$id)  {$active='active';}else{$active='inactive';}
			$tags[]=array('name'=>$member_type,'status'=>$active);
			
		}
		//sites
		$sites=church_admin_sites_array();
		foreach( $sites AS $id=>$site)
		{
		
			if( $data->site_id==$id)  {$active='active';}else{$active='inactive';}
			$tags[]=array('name'=>$site,'status'=>$active);
		}
		//ministries
		$ministries=church_admin_ministries_array();
		$personMinistries=church_admin_get_people_meta( $people_id,'ministry');
		foreach( $ministries AS $id=>$ministry)
		{
			if(is_array( $personMinistries)&&In_Array( $id,$personMinistries) )  {$active='active';}else{$active='inactive';}
			$tags[]=array('name'=>$ministry,'status'=>$active);
			
		}	
		//parents of children
		$kidswork=church_admin_kidswork_array();
		$parentOf=church_admin_get_kids_groups( $people_id);
		if(!empty( $kidswork) )
		{
			foreach( $kidswork AS $id=>$kidsworkGroup)
			{
				if(!empty( $parentOf) && is_array( $parentOf) && in_array( $id,$parentOf) )  {$active='active';}else{$active='inactive';}
				$tags[]=array('name'=>$kidsworkGroup,'status'=>$active);
			}
		}
		//smallgroups
		
		$tagCount=count( $tags);
		$small_groups=church_admin_small_groups_array();
		$personGroups=church_admin_get_people_meta( $people_id,'smallgroup');
		if(!empty( $small_groups) )
		{
		
			foreach( $small_groups AS $id=>$smallgroup)
			{
				
				if(!empty( $personGroups) && is_array( $personGroups) && in_array( $id,$personGroups) )  {$active='active';}else{$active='inactive';}
				$tags[]=array('name'=>__('Smallgroup ','church-admin').' - '.str_replace("-"," ",sanitize_title( $smallgroup) ),'status'=>$active);
			}
		}
	}
	return $tags;
}


//DEPRECATED
function church_admin_mailchimp_tags()
{
	
	global $wpdb;
	$tags=array();
	/*********************
	*
	* Build tag list
	*
	**********************/
	//prayer requests
	$tags[]='prayer-requests';
	$tags[]='bible-readings';
	$tags[]='news-send';
	//gender
	$gender=get_option('church_admin_gender');
	foreach( $gender AS $key=>$sex)
	{
		
		$tags[]=$sex;
	}
	//member types
	$member_types=church_admin_member_type_array();
	foreach( $member_types AS $id=>$member_type)
	{
		
		$tags[]=$member_type;
	}
	//sites
	$sites=church_admin_sites_array();
	foreach( $sites AS $id=>$site)
	{
		
		$tags[]=$site;
	}
	//ministries
	$ministries=church_admin_ministries_array();
	foreach( $ministries AS $id=>$ministry)
	{
		
		$tags[]=$ministry;
	}	
	//parents of children
	$kidswork=church_admin_kidswork_array();
	
	if(!empty( $kidswork) )foreach( $kidswork AS $id=>$kidsworkGroup)  {$tags[]=$kidsworkGroup;}
	//current & future classes
	$classes=$wpdb->get_results('SELECT * FROM '.CA_CLA_TBL.' WHERE end_date>NOW()');
	if(!empty( $classes) )
	{
		foreach( $classes AS $class)$tags[]=__('Class','church-admin').' - '.$class->name;
	}
	//smallgroups
	//Only 100 tags allowed
	$tagCount=count( $tags);
	$small_groups=church_admin_small_groups_array();
	if(!empty( $small_groups)&&count( $small_groups)+$tagCount<=100)
	{
		
		foreach( $small_groups AS $id=>$smallgroup)
		{
			
			$tags[]=__('Smallgroup ','church-admin').' - '.str_replace("-"," ",sanitize_title( $smallgroup) );
		}
	}
	return $tags;
}
//DEPRECATED
function church_admin_mailchimp_sync_message( $MailChimp)
{
	
	
	if (!$MailChimp->success() )
	{
		
		if(defined('CA_DEBUG') )church_admin_debug("*********\r\n".$MailChimp->getLastError() );
		
		if(defined('CA_DEBUG') )church_admin_debug(print_r( $MailChimp->getLastRequest(),TRUE) );
		
		echo '<p>'.__('MailChimp Error','church-admin')."\r\n".$MailChimp->getLastError().'<pre>';
		
		print_r( $MailChimp->getLastRequest() );
		
		echo'</pre></p>';

	
	}
	


}