<?PHP

function church_admin_contact_callback()
{
    
    require_once(plugin_dir_path(dirname(__FILE__) ).'includes/contact_form.php');
    church_admin_contact_form_list();
}

function church_admin_attendance_callback()
{
    global $wpdb;
    $service_id=$wpdb->get_var('SELECT service_id FROM '.CA_ATT_TBL.' WHERE mtg_type="service" ORDER by `date` DESC LIMIT 1');
    $meet='s/'.(int)$service_id;
    require_once(plugin_dir_path(dirname(__FILE__) ).'display/graph.php');
    echo church_admin_graph('weekly',$meet,date("y-m-d",strtotime("-12 weeks") ),date("Y-m-d"),'100%','200px',TRUE);
}

function church_admin_app_callback()
{
    //show upgrade message if needed
    //show upgrade message if needed
    if(!church_admin_app_licence_check() )
	{
        church_admin_buy_app();
	}
	else
    {
        /*********
        * PUSH
        *********/
        require_once(plugin_dir_path(dirname(__FILE__) ).'app/app-admin.php');
        ca_push_message();
    }
}

function church_admin_children_callback()
{
    require_once(plugin_dir_path(dirname(__FILE__) ).'includes/kidswork.php');
    church_admin_kidswork();

}


function church_admin_calendar_callback()
{
    require_once(plugin_dir_path(dirname(__FILE__) ).'display/calendar-list.php');
    echo'<h3>'.esc_html( __( 'Next 7 days', 'church-admin' ) ).'</h3>';
    echo church_admin_calendar_list(7,NULL);
}
function church_admin_events_callback()
{
    require_once(plugin_dir_path(dirname(__FILE__) ).'includes/events.php');
    church_admin_events();
}

function church_admin_comms_callback()
{
    /*********
    * Email
    *********/
    echo'<h3>'.esc_html( __('Email','church-admin') ).'</h3>';
    echo'<p><a class="button-secondary" href="admin.php?page=church_admin%2Findex.php&action=email-settings">'.__('Setup Email','church-admin').'</a></p>';
    $email_method=get_option('church_admin_email_method');
    switch( $email_method)
    {
        case 'native':$em=__('Native WordPress email functions','church-admin');break;
        case 'smtp-server':$em=__('Using your SMTP settings','church-admin');break;
        case 'mailchimp':$em=__('MailChimp','church-admin');break;
    }
    echo'<p>'.esc_html( sprintf(__('Bulk email send method: %1$s','church-admin'),$em) );
    $MCsettings=get_option('church_admin_mailchimp');
    if(!empty( $email_method=='mailchimp') )
    {
        echo '<p><a  class="button-secondary" href="admin.php?page=church_admin%2Findex.php&action=sync-mailchimp">'.esc_html( __('Setup/Sync MailChimp', 'church-admin' ) ).'</a></p>';
        echo'<p>'.esc_html( __('Sending via MailChimp enabled','church-admin') ).'</p>';
        require_once(plugin_dir_path(dirname(__FILE__) ).'includes/mailchimp.php');
        church_admin_check_mailchimp_webhook();
    }
   
    /*********
    * SMS
    *********/
    echo'<h3>SMS</h3>';
    echo'<p><a class="button-secondary" href="admin.php?page=church_admin%2Findex.php&action=sms-settings">'.esc_html( __('Setup SMS','church-admin') ).'</a></p>';
    require_once(plugin_dir_path(dirname(__FILE__) ).'includes/sms.php');
    $sms_type=get_option('church_admin_sms_provider');
    if ( empty( $sms_type) )
    {
        echo'<p>'.esc_html( __("Bulk SMS is a great way of communicating with your whole church or targeting specific groupings. Most people check the ping on their phone quickly! Twilio are our preferred partner, who offer you $10 credit when you purchase $10 of credit.",'church-admin') ).'</p>';
        echo'<p><a target="_blank" href="https://www.twilio.com/referral/YjV7bl"><img src="'.esc_url( plugins_url('/images/twilio-logo.png',dirname(__FILE__) ) ).'" alt="Twilio"/></a></p>';

    }
    church_admin_sms_credits();
    /*********
    * PUSH
    *********/
    require_once(plugin_dir_path(dirname(__FILE__) ).'app/app-admin.php');
    ca_push_message();
}

function church_admin_classes_callback()
{
    require_once(plugin_dir_path(dirname(__FILE__) ).'includes/classes.php');
    church_admin_classes();
}

function church_admin_facilities_callback()
{
    require_once(plugin_dir_path(dirname(__FILE__) ).'includes/facilities.php');
    church_admin_facilities_list(NULL,1);
    church_admin_facility_hire(NULL);

}
function church_admin_followup_callback()
{
    require_once(plugin_dir_path(dirname(__FILE__) ).'includes/funnel.php');
    church_admin_funnel_list();
}
function church_admin_gifts_callback()
{
    require_once(plugin_dir_path(dirname(__FILE__) ).'includes/spiritual-gifts.php');
    church_admin_spiritual_gifts_list();
}
function church_admin_giving_callback()
{
    global $wpdb;
    $premiumLicence=get_option('church_admin_app_new_licence');
    if ( empty( $premiumLicence)||$premiumLicence!='subscribed')
    {
        $buttonText=__('Upgrade to premium for PayPal giving','church-admin');
    }
    else
    {
        $buttonText=__('PayPal settings','church-admin');
    }
    echo '<p><a href="admin.php?page=church_admin/index.php&action=paypal-setup" class="button-primary">'.esc_html( $buttonText ).'</a></p>';
    $premium=get_option('church_admin_payment_gateway');
    if(!empty( $premium['gift_aid'] ) )
    {
        $lastGiftAid=get_option('church-admin-last-gift-aid');
        if(!empty( $lastGiftAid) )
        {
            echo'<p>'.esc_html( sprintf(__('Your last Gift Aid report download was to date %1$s','church-admin'),mysql2date(get_option('date_format'),$lastGiftAid) ) ).'</p>';
        }
    }
    /***********************************************
     * 
     * Create giving graph for last 12 weeks
     * 
     * ********************************************/
    $results=$wpdb->get_results('SELECT b.fund, WEEK(a.donation_date) AS date, SUM(b.gross_amount) AS giving FROM '.CA_GIV_TBL.' a, '.CA_GMET_TBL.' b WHERE a.giving_id=b.giving_id AND a.donation_date > DATE(NOW() - INTERVAL 84 DAY) GROUP BY b.fund, WEEK(a.donation_date)
    ORDER BY b.fund,WEEK(a.donation_date)');
   
    if(!empty( $results) )
    {
        $graphData=array();
        $funds=array();
        $columns=$rows='';
        foreach( $results as $row)
        {
            if(!in_array( $row->fund,$funds) )$funds[]=$row->fund;
            
            $graphData[$row->date][$row->fund]=$row->giving;
        }
        church_admin_debug( $graphData);
        foreach( $funds AS $key=>$givingFund)
        {
            $columns.='data.addColumn("number", "'.esc_html( $givingFund).'");'."\r\n";
        }
        foreach( $graphData AS $date=>$givingData)
        {
            //put zero in empty funds for that week
            foreach( $funds AS $key=>$fundName)  {if ( empty( $givingData[$fundName] ) )$givingData[$fundName]=0.0;}
            $rows.='['.$date.','.implode(",",$givingData).'],';
        }
        echo '
        <script type="text/javascript">
          google.charts.load("current", {"packages":["line"]});
          google.charts.setOnLoadCallback(drawChart);
    
          function drawChart() {
            var data = new google.visualization.DataTable();
            data.addColumn("number", "'.__('Week','church-admin').'");'."\r\n";
          echo $columns;
          echo' data.addRows(['.$rows.'] )'."\r\n";
          echo 'var options = {
              title: "'.__('Weekly Giving','church-admin').'",
              curveType: "function",
              legend: { position: "bottom"}
            };

            var chart = new google.charts.Line(document.getElementById("giving_chart") );

            chart.draw(data, google.charts.Line.convertOptions(options) );
          }
        </script><div id="giving_chart"></div>';
    }
    //end giving graph
}

function church_admin_people_callback()
{
    global $wpdb;
    church_admin_search_form();
    echo '<p><a class="button-secondary" href="admin.php?page=church_admin/index.php&action=check-directory-issues">'.__('Check for issues with the directory','church-admin').'</a></p>';
    if(!empty($_POST['country_iso'])){
        $countryISO=sanitize_text_field($_POST['country_iso']);
        update_option('church_admin_sms_iso',(int)$countryISO);
    }
    $countryISO = get_option('church_admin_sms_iso');
    if(empty($countryISO))
    {
        echo'<form action="" method="POST">';
        echo '<div class="church-admin-form-group"><label>'. esc_html('Please set your Country STD (telephone dialling code e.g. 1 for USA, 44 for UK','church-admin').'</label>';
        echo '<input type="number" name="country_iso" /><input type="submit" value="'.esc_html( __( 'Save', 'church-admin' ) ).'"/></div></form>';
    }
    $householdsCount=$wpdb->get_var('SELECT COUNT(*) FROM '.CA_HOU_TBL);
    $recentPeople=$wpdb->get_var('SELECT COUNT(*) FROM '.CA_PEO_TBL.' WHERE last_updated > DATE(NOW() ) + INTERVAL -1 DAY ');
    echo '<p><a href="admin.php?page=church_admin/index.php&action=recent-people&amp;section=people">'.sprintf(__('%1$s people records edited in the last 7 days','church_admin'),$recentPeople).'</a></p>';
    echo'<p>'.sprintf(__('%1$s households stored in total','church-admin'),$householdsCount).'</p>';
    $member_type=church_admin_member_type_array();
    $memberTypeCount=$wpdb->get_results('SELECT COUNT(member_type_id) AS count,member_type_id FROM '.CA_PEO_TBL.' GROUP BY member_type_id');
    
    foreach( $memberTypeCount AS $mtCount)
    {
        if(!empty( $member_type[$mtCount->member_type_id] ) )echo '<p>'.sprintf(__('%1$s people of "%2$s" member type','church-admin'),(int)$mtCount->count,$member_type[$mtCount->member_type_id] ).'</p>';
    }




}
function church_admin_groups_callback()
{
    echo'<p><a href="'.site_url().'/?ca_download=smallgroup-signup" class="button-primary">'.__('Smallgroup signup PDF sheet','church-admin').'</a></p>';
    require_once(plugin_dir_path(dirname(__FILE__) ).'includes/small_groups.php');
    church_admin_smallgroup_metrics();
}
function church_admin_media_callback()
{
    require_once(plugin_dir_path(dirname(__FILE__) ).'includes/sermon-podcast.php');
    $sermonPageID=get_option('church-admin-sermon-page');
    if ( empty( $sermonPageID) )
    {
        echo'<p><a href="admin.php?page=church_admin/index.php&action=set-sermon-page">'.__('Please set where your sermon page is, to activate share links.','church-admin').'</a></p>';
    }



    ca_podcast_list_files();
}
function church_admin_ministries_callback()
{
    require_once(plugin_dir_path(dirname(__FILE__) ).'includes/departments.php');
    church_admin_ministries_list();
}

function church_admin_rota_callback()
{
    require_once(plugin_dir_path(dirname(__FILE__) ).'includes/rota.new.php');
    church_admin_rota_list(NULL,'service');
}
function church_admin_units_callback()
{
    require_once(plugin_dir_path(dirname(__FILE__) ).'includes/units.php');
    church_admin_units_list();
}
function church_admin_inventory_callback()
{
   
    require_once(plugin_dir_path(dirname(__FILE__) ).'includes/inventory.php');
    echo church_admin_inventory_list();
}

function church_admin_settings_callback()
{
    echo'<a class="button-primary" href="admin.php?page=church_admin%2Findex.php&action=shortcode-generator">'.__('Shortcode generator','church-admin').'</a></p>';
   //$debug_mode=get_option('church_admin_debug_mode');
   echo'<h2>'.__('Debugging','church-admin').'</h2>';
   $debug=get_option('church_admin_debug_mode');
   if(defined('CA_DEBUG') )  {
        if(!empty($debug))
        {
            echo '<p>'.esc_html( __( 'Church Admin debug mode is ON','church-admin' ) ).'</p>';
            echo'<p><a class="button-secondary" href="admin.php?page=church_admin/index.php&action=toggle-debug-mode">'.esc_html( __('Toggle debug mode','church-admin') ).'</a></p>';
  
        }
            
        elseif(!empty( $_COOKIE['ca_debug_mode'] ) ){
            echo '<p>'.esc_html( __( 'Church Admin debug mode is ON,set by cookie method','church-admin' ) ).'</p>';
            echo'<p><a class="button-secondary" href="admin.php?page=church_admin/index.php&action=toggle-debug-mode">'.esc_html( __('Toggle debug mode','church-admin') ).'</a></p>';
  
        }else{ 
            echo '<p>'.esc_html( __('Church Admin debug mode is ON, hard-coded probably in wp-config.php','church-admin' ) ) .'</p>';
        }
    }
    else{
        echo'<p>'.esc_html( __('Church Admin debug mode is OFF','church-admin') ).'</p>';
        echo'<p><a class="button-secondary" href="admin.php?page=church_admin/index.php&action=toggle-debug-mode">'.esc_html( __('Toggle debug mode','church-admin') ).'</a></p>';
  
    }
    $upload_dir = wp_upload_dir();
    $debug_path=$upload_dir['basedir'].'/church-admin-cache/debug_log.php';
    if(file_exists( $debug_path) )
    {
        $filesize=filesize( $debug_path);
        $size=size_format( $filesize, $decimals = 2 );
        echo'<p>'.esc_html( sprintf(__('Debug file is currently %1$s','church-admin'),$size) ).'</p>';
        
	    $debug_url=content_url().'/uploads/church-admin-cache/debug_log.php';
        echo'<p><a href="'.esc_url( $debug_url).'" id="download-ca-debug" class="button-secondary">'.esc_html( __('Download debug file (Please right click and save)','church-admin') ).'</a></p>';
        echo'<p><a class="button-primary" href="admin.php?page=church_admin/index.php&action=clear-debug">'.esc_html( __('Delete debug file','church-admin') ).'</a></p>';
    }
    echo'<p><a href="https://patchstack.com/database/vdp/church-admin"><img width="300" src="https://patchstack.com/wp-content/uploads/2022/12/patchstack_badge_program_372x72.svg"/></a></p>';
   
}

function church_admin_services_callback()
{
    require_once(plugin_dir_path(dirname(__FILE__) ).'includes/sites.php');
    church_admin_site_list();
    require_once(plugin_dir_path(dirname(__FILE__) ).'includes/services.php');
    echo church_admin_service_list();
}

