<?php
if ( ! defined( 'ABSPATH' ) ) exit('You need Jesus!'); // Exit if accessed directly


function church_admin_recent_display( $weeks=4,$member_type_id=NULL)
{
    global $wpdb;
    $out='<div class="church-admin-recent"><h2>'.__('Recent address list activity','church-admin').'</h2>';
    $shownMember_types=array();
    $AllMember_types=church_admin_member_type_array();
	if ( empty( $member_type_id) )$shownMember_types=$AllMember_types;
    else
    {
        $givenMember_types=explode(',',$member_type_id);
        foreach( $givenMember_types AS $key=>$Mtype)
        {
            $shownMember_types[$Mtype]=$AllMember_types[$Mtype];
        }
    }
 
    foreach( $shownMember_types AS $type_id=>$type)
    {
        $sql='SELECT a.last_updated AS lastUpdate,a.*,b.* FROM '.CA_PEO_TBL.' a, '.CA_HOU_TBL.' b WHERE a.household_id=b.household_id AND a.last_updated>DATE_SUB(NOW(), INTERVAL '.esc_sql( $weeks).' WEEK) AND a.member_type_id ="'.esc_sql( $type_id).'"';
        
        $results=$wpdb->get_results( $sql);
       church_admin_debug(print_r( $results,TRUE) );
		$out.='<h3>'.sprintf(__('%1$s address list activity in the last %2$s weeks','church-admin'),$type,$weeks).'</h3>';
		if( $results)
        {
            
            $out.='<table  class="church_admin"> <thead><tr><th>'.__('Last Updated','church-admin').'</th><th>'.__('Name','church-admin').'</th><th>'.__('Address','church-admin').'</th><th>'.__('Mobile','church-admin').'</th><th>'.__('Phone','church-admin').'</th><th>'.__('Email','church-admin').'</th></tr></thead><tfoot><tr><th>'.__('LAst Updated','church-admin').'</th><th>'.__('Name','church-admin').'</th><th>'.__('Address','church-admin').'</th><th>'.__('Mobile','church-admin').'</th><th>'.__('Phone','church-admin').'</th><th>'.__('Email','church-admin').'</th></tr></tfoot><tbody>';
            foreach( $results AS $row)
            {
                
                $add=maybe_unserialize( $row->address);
                if(is_array( $add) )  { $address=implode(', ',array_filter(maybe_unserialize( $row->address) ));}
                else{$address=$row->address;}
               $out.='<tr><td>'.mysql2date(get_option('date_format'),$row->lastUpdate).'</td><td>'.esc_html( $row->first_name.' '.$row->last_name).'</td><td>'.esc_html( $address).'</td><td>'.esc_html( $row->mobile).'</td><td>'.esc_html( $row->phone).'</td><td>'.esc_html( $row->email).'</td></tr>';
            }
            $out.='</tbody></table>';
        }else{$out.='<p>'.__('No new address list activity','church-admin').'</p>';}
    }
    $out.='</div>';
   return $out; 
    
}

