<?php
if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

function ca_podcast_list_series()
{
    /**
     *
     * Lists podcast series
     *
     * @author  Andy Moyle
     * @param    null
     * @return   html string
     * @version  0.1
     *
     */
    global $wpdb;


    echo'<h1>'.__('Sermon Series','church-admin').'</h1>';
    echo'<a href="'.wp_nonce_url('admin.php?page=church_admin/index.php&amp;action=edit_sermon_series','edit_sermon_series').'">Add a Sermon Series</a></p>';

    //grab files from table
    $results=$wpdb->get_results('SELECT * FROM '.CA_SERM_TBL.' ORDER BY last_sermon DESC');
    if( $results)
    {//results
        
        $theader='<tr><th class="column-primary">'.__('Series','church-admin').'</th><th>'.__('Edit','church-admin').'</th><th>'.__('Delete','church-admin').'</th><th>'.__('Image','church-admin').'</th><th>'.__('Files','church-admin').'</th><th>'.__('Shortcode','church-admin').'</th></tr>';
        $table='<table class="widefat striped wp-list-table"><thead>'.$theader.'</thead>'."\r\n".'<tfoot>'.$theader.'</tfoot>'."\r\n".'<tbody>';
        foreach( $results AS $row)
        {
            $edit='<a href="'.wp_nonce_url('admin.php?page=church_admin/index.php&amp;action=edit_sermon_series&section=media&amp;id='.(int)$row->series_id,'edit_sermon_series').'">'.__('Edit','church-admin').'</a>';
            $delete='<a onclick="return confirm(\''.__('Are you sure?','church-admin').'\');" href="'.wp_nonce_url('admin.php?page=church_admin/index.php&amp;section=media&amp;action=delete_sermon_series&amp;id='.(int)$row->series_id,'delete_sermon_series').'">'.__('Delete','church-admin').'</a>';
            $files=$wpdb->get_var('SELECT count(*) FROM '.CA_FIL_TBL.' WHERE series_id="'.esc_sql( $row->series_id).'"');
            if(!$files)$files="0";
            $image=wp_get_attachment_image( $row->series_image,'medium');
            if ( empty( $image) )$image='';
        
            $table.='<tr>
                <td data-colname="'.__('Series','church-admin').'" class="column-primary">'.esc_html( $row->series_name).'<button type="button" class="toggle-row"><span class="screen-reader-text">show details</span></button></td>
                <td data-colname="'.__('Edit','church-admin').'">'.$edit.'</td>
                <td data-colname="'.__('Delete','church-admin').'">'.$delete.'</td>
                <td data-colname="'.__('Image','church-admin').'">'.$image.'</td>
                <td data-colname="'.__('Files','church-admin').'">'.(int)$files.'</td>
                <td data-colname="'.__('Shortcode','church-admin').'">[church_admin type="podcast" series_id="'.(int)$row->series_id.'"]</td>
            </tr>';
        }

        $table.='</tbody></table>';
        echo $table;
    }//end results
    else
    {
        echo'<p>'.__('No Sermon Series stored yet','church-admin').'</p>';
    }


}
function ca_podcast_delete_series( $id=NULL)
{
    /**
 *
 * Delete podcast events
 *
 * @author  Andy Moyle
 * @param    $id=null
 * @return   html string
 * @version  0.1
 *
 */

	global $wpdb;
	$wpdb->query('DELETE  FROM '.CA_SERM_TBL.' WHERE series_id="'.esc_sql((int)$id).'"');
	 echo'<div class="notice notice-success inline"><p>'.__('Series Deleted','church-admin').'</p></div>';
        ca_podcast_list_series();

 }
/**************************************************
 *
 * Edit podcast events
 *
 * @author  Andy Moyle
 * @param    $id=null
 * @return   html string
 * @version  0.1
 *
 ***************************************************/
function ca_podcast_edit_series( $id=NULL)
{


    global $wpdb;
    if(!empty( $id) )
    {
        $current_data=$wpdb->get_row('SELECT * FROM '.CA_SERM_TBL.' WHERE series_id="'.(int)$id.'"');
        $title='Edit';
    }
    else
    {
        $id=0;
        $title='Add';
    }
    echo'<h1>'.esc_html( $title).' Sermon Series</h1>';
    if(!empty( $_POST['save_series'] ) )
    {//process form

        $series_name=sanitize_text_field(stripslashes( $_POST['series_name'] ) );
        $series_description=esc_sql(stripslashes( $_POST['series_description'] ) );
        if ( empty( $id) )$id=$wpdb->get_var('SELECT series_id FROM '.CA_SERM_TBL.' WHERE series_name="'.esc_sql( $series_name).'" AND series_description="'.$series_description.'"');
        if(!empty( $id) )
        {//update
            $wpdb->query('UPDATE '.CA_SERM_TBL.' SET series_name="'.esc_sql( $series_name).'",series_description="'.$series_description.'" ,series_image="'.(int)$_POST['attachment_id'].'",series_slug="'.esc_sql(sanitize_title( $series_name) ).'" WHERE series_id="'.(int)$id.'"');
        }//end update
        else
        {//insert
            $wpdb->query('INSERT INTO '.CA_SERM_TBL.' (series_name,series_description,series_image,series_slug)VALUES("'.$series_name.'","'.$series_description.'","'.(int)$_POST['attachment_id'].'","'.esc_sql(sanitize_title( $series_name) ).'")');
        }//end insert
        echo'<div class="notice notice-success inline"><p>'.__('Series Saved','church-admin').'</p></div>';
        ca_podcast_list_series();
    }//end process form
    else
    {//form
        echo '<form action="" method="POST"><table class="form-table">';
        echo'<tr><th scope="row">'.__('Series Name','church-admin').'</th><td><input type="text" name="series_name" id="series_name" class="large-text"';
        if(!empty( $current_data->series_name) ) echo 'value="'.esc_html( $current_data->series_name).'"';
        echo'/></td></tr>';

        echo'<tr><th scope="row">'.__('Photo (600x400px is ideal)','church-admin').'</th><td>';
	
    echo'<div class="church-admin-series-image ca-upload-area" data-nonce="'.wp_create_nonce("series-image-upload").'" data-which="series" data-id="'.(int)$id.'" id="uploadfile"><h3>'.__('Series image','church-admin').'</h3>';
    if(!empty( $current_data->series_image) )
    {
        $series_image_attributes=wp_get_attachment_image_src( $current_data->series_image,'medium','' );
        if ( $series_image_attributes )
        {
            echo'<img id="series-image" src="'.$series_image_attributes[0].'" width="'.$series_image_attributes[1].'" height="'.$series_image_attributes[2].'" class="rounded" alt="'.__('Household image','church-admin').'"/>';
        }else {
            echo'<img id="series-image"  src="'.plugins_url('/images/default-avatar.jpg',dirname(__FILE__) ).'" width="300" height="200" class="rounded" alt="'.__('Series image','church-admin').'"/>';
        }
    }
    else
    {
        echo'<img id="series-image"  src="'.plugins_url('/images/default-avatar.jpg',dirname(__FILE__) ).'" width="300" height="200" class="rounded" alt="'.__('Series image','church-admin').'"/>';
    }
    echo '<br />'.__('Drag and drop new image for series','church-admin');
    echo '<span id="series-upload-message"></span>';

    echo'</div>';

   
    echo'<input type="hidden" name="attachment_id" class="attachment_id" id="attachment_id" ';
    if(!empty( $current_data->series_image) ) echo ' value="'.(int)$current_data->series_image.'" ';
        echo'/><br style="clear:left"/>';
    echo'</td></tr>';
        echo'<tr><th scope="row">'.__('Series Description','church-admin').'</th><td>';
        echo'<textarea name="series_description" id="series_description" class="large-text">';
		if(!empty( $current_data->series_description ) )echo esc_textarea( $current_data->series_description );
		echo'</textarea></td></tr>';
        echo '<tr><td colspacing=2><input type="hidden" name="save_series" value="save_series"/><input type="submit" class="button-primary" value="'.__('Save Sermon Series','church-admin').'"/></td></tr></table></form>';
    
    }//form


}




function ca_podcast_list_files()
{
/**
 *
 * Lists podcast files
 *
 * @author  Andy Moyle
 * @param    null
 * @return   html string
 * @version  0.1
 *
 */ 



    global $wpdb,$church_admin_url;
    $upload_dir = wp_upload_dir();
	$path=$upload_dir['basedir'].'/sermons/';
	$url=content_url().'/uploads/sermons/';

    if(!empty($_POST)){
        church_admin_debug($_POST);
    }

    /***************************
     * Handle bulk actions
     ***************************/
    if(!empty($_POST['method']))
    {
        $message=__('Selected sermons removed from database','church-admin');

        if(!empty($_POST['file_id']))
        {
            foreach($_POST['file_id'] AS $key=>$id){
                $file_id=(!empty($id) && ctype_digit($id))?(int)$id:null;
                if(!empty($file_id)){

                    $data=$wpdb->get_row('SELECT * FROM '.CA_FIL_TBL.' WHERE file_id="'.(int)$file_id.'"');
                    church_admin_debug($wpdb->last_query);
                    if(!empty($data))
                    {
                        $wpdb->query('DELETE FROM '.CA_FIL_TBL.' WHERE file_id="'.(int)$file_id.'"');
                        church_admin_debug($wpdb->last_query);
                        if($_POST['method']=='delete-files'){
                            $fullfilepath=$path.sanitize_file_name($data->file_name);
                            if(!empty($data->file_name) && file_exists($fullfilepath)){
                                unlink($fullfilepath);
                            }
                            $message=__('Selected sermons removed from database and deleted from server','church-admin');
                        }
                    }

                }
           
           
            }
            echo'<div class="notice notice-success"><h2>'.esc_html($message).'</h2></div>';
           
        }
    }
 
    /***************************
     * End Handle bulk actions
     ***************************/
 
    ca_podcast_xml();
    if(defined('CA_DEBUG') )church_admin_debug('List files');
	
    echo'<p><a href="'.$url.'podcast.xml">Podcast RSS file</a></p>';
    if(!empty( $_GET['action'] ) )
    {
        echo '<p><a class="button-primary" href="admin.php?page=church_admin/index.php&amp;action=migrate_advanced_sermons&amp;section=media">'.__('Migrate from Advanced Sermons (and Pro) plugin','church-admin').'</a><p>';
        echo '<p><a class="button-primary" href="admin.php?page=church_admin/index.php&amp;action=migrate_sermon_manager&amp;section=media">'.__('Migrate from Sermon Manager plugin','church-admin').'</a><p>';
        echo '<p><a class="button-primary" href="admin.php?page=church_admin/index.php&amp;action=migrate_sermon_browser&amp;section=media">'.__('Migrate from Sermon Browser plugin','church-admin').'</a><p>';
    
        if(!file_exists( $path.'podcast.xml') )
        {
            ca_podcast_xml();

        }
        if(file_exists( $path.'podcast.xml') )echo'<p><a href="'.$url.'podcast.xml">Podcast RSS File</a></p>';
        echo'<p class="search-box"><form action="admin.php?page=church_admin%2Findex.php&action=podcast&section=podcast" method="POST"><input type="text" name="sermon-search" placeholder="'.__('Search','church-admin').'"/><input class="button-secondary" type="submit" value="'.__('Search sermons','church-admin').'"/></form></p>';
    
    }
    
    if(!empty( $_POST['sermon-search'] ) )
    {
        $s=esc_sql(stripslashes( $_POST['sermon-search'] ) );
        
        $sql='SELECT * FROM '.CA_FIL_TBL.' WHERE file_title LIKE "%'.$s.'%" OR file_description LIKE "%'.$s.'%" OR speaker LIKE "%'.$s.'%" OR bible_texts LIKE "%'.$s.'%" ORDER BY pub_date DESC';
       
        $results=$wpdb->get_results( $sql);
        $searchCount=$wpdb->num_rows;
        if ( empty( $results) )
        {
            echo'<p>'.__('No results','church-admin').'</p>';
            echo'<p><a href="admin.php?page=church_admin%2Findex.php&action=podcast&section=podcast">'.__('View all sermons','church-admin').'</a></p>';
        }
        else
        {
            echo'<h2>'.sprintf(__('Your search for "%1$s" yielded %2$s results','church-admin'),esc_html(stripslashes( $_POST['sermon-search'] ) ),$searchCount).'</h2>';
            echo'<p><a href="admin.php?page=church_admin%2Findex.php&action=podcast&section=podcast">'.__('View all sermons','church-admin').'</a></p>';
            $theader='<tr><th class="column-primary">'.__('Title','church-admin').'</th><th>'.__('Edit','church-admin').'</th><th>'.__('Delete','church-admin').'</th><th>'.__('Publ. Date','church-admin').'</th><th>'.__('Speakers','church-admin').'</th><th>'.__('Mp3 File','church-admin').'</th></th><th>'.__('Mp3 File Okay?','church-admin').'</th><th>'.__('Length','church-admin').'</th><th>'.__('Media','church-admin').'</th><th>'.__('Embed','church-admin').'</th><th>'.__('Series','church-admin').'</th><th>'.__('Plays','church-admin').'</th><th>'.__('Shortcode','church-admin').'</th></tr>';
            
            $table='<table class="widefat striped wp-list-table"><thead>'.$theader.'</thead>'."\r\n".'<tfoot>'.$theader.'</tfoot>'."\r\n".'<tbody>';
            foreach( $results AS $row)
			{
			     print_r($row);
				if(file_exists(plugin_dir_path( $path.$row->file_name) ))  {
                    $okay='<img src="'.plugins_url('images/green.png',dirname(__FILE__) ) .'" width="32" height="32"/>';
                }else{
                    $okay='<img src="'.plugins_url('images/red.png',dirname(__FILE__) ) .'" width="32" height="32"/>';
                }
                
                $edit='<a href="'.wp_nonce_url('admin.php?page=church_admin/index.php&amp;action=edit_file&amp;id='.$row->file_id,'edit_podcast_file').'">'.__('Edit','church-admin').'</a>';
                $delete='<a onclick="return confirm(\''.__('Are you sure?','church-admin').'\');" href="'.wp_nonce_url('admin.php?page=church_admin/index.php&amp;action=delete_file&amp;id='.$row->file_id,'delete_podcast_file').'">'.__('Delete','church-admin').'</a>';
                $series_name=$wpdb->get_var('SELECT series_name FROM '.CA_SERM_TBL.' WHERE series_id="'.esc_sql( $row->series_id).'"');
                if(!empty( $row->file_name)&&file_exists( $path.$row->file_name) )  {
                    $file='<a href="'.esc_url( $url.$row->file_name).'">'.esc_html( $row->file_name).'</a>'; $okay='<img src="'.plugins_url('images/green.png',dirname(__FILE__) ) .'"/>';
                }
                elseif(!empty( $row->external_file) )  {
                    $file='<a class="external_file" href="'.esc_url( $row->external_file).'">'.esc_html( $row->external_file).'</a>'; 
                    $okay='<img src="'.plugins_url('images/green.png',dirname(__FILE__) ) .'"/>';
                    
                    
                
                }
                else
                {
                    $file='&nbsp;'; $okay='<img src="'.plugins_url('images/red.png',dirname(__FILE__) ).'"/>';
                }
                $videoPlays='';
                
                if(!empty( $row->video_url) )
                {
                    
                    $embed=church_admin_generateVideoEmbedUrl( $row->video_url);
                    
                    $views=church_admin_youtube_views_api( $embed['id'] );
                    if(!empty( $views) )  {$videoPlays='<br />'.sprintf(__('%1$s views','church-admin'),$views);}
                }
                $embed_code=!empty($row->embed_code)?__('Yes','church-admin'):__('No','church-admin');
                //output table row
                $table.='<tr>
                    <td data-colname="'.__('Sermon title','church-admin').'" class="column-primary">'.esc_html( $row->file_title).'<button type="button" class="toggle-row"><span class="screen-reader-text">show details</span></button></td>
                    <td data-colname="'.__('Edit','church-admin').'">'.$edit.'</td>
                    <td data-colname="'.__('Delete','church-admin').'">'.$delete.'</td>
                    <td data-colname="'.__('Published','church-admin').'">'.date(get_option('date_format').' '.get_option('time_format'),strtotime( $row->pub_date) ).'</td>
                    <td data-colname="'.__('Speakers','church-admin').'" class="ca-names">'.esc_html(church_admin_get_people( $row->speaker) ).'</td>
                    <td data-colname="'.__('Sermon filename','church-admin').'">'.$file.'</td>
                    <td data-colname="'.__('File exists','church-admin').'">'.$okay.'</td>
                    <td data-colname="'.__('Sermon length','church-admin').'"><span id="length'.(int)$row->file_id.'">'.esc_html( $row->length).'</span></td>
                    <td data-colname="'.__('Video URL','church-admin').'">'.$row->video_url.'</td>
                    <td data-colname="'.__('Embed','church-admin').'">'.$embed_code.'</td>
                    <td data-colname="'.__('Series name','church-admin').'">'.esc_html( $series_name).'</td>
                    <td data-colname="'.__('Video plays','church-admin').'">'.sprintf(__('%1$s mp3 plays','church-admin'),intval( $row->plays) ).$videoPlays.'</td>
                    <td data-colname="'.__('Shortcode','church-admin').'">[church_admin type="single-sermon" file_id="'.intval( $row->file_id).'"]</td>
                </tr>';

			}
       
            $table.='</tbody></table>';
            echo $table;
        }
    }
    else
    {
    
    
    
    
            //grab files from table
            $count=$wpdb->get_var('SELECT SUM(plays) FROM '.CA_FIL_TBL);
            $results=$wpdb->get_results('SELECT a.* FROM '.CA_FIL_TBL.' a  ORDER BY pub_date DESC');

            if(!empty( $count) )echo'<p>'.sprintf(__('%1$s total sermon plays','church_admin'),$count).'</p>';
            $items=$wpdb->num_rows;
            require_once(plugin_dir_path(dirname(__FILE__) ).'includes/pagination.class.php');
            $order='pub_date DESC';
            if( $items > 0)
            {
              $p = new caPagination;
              $p->items( $items);

              $page_limit=get_option('church_admin_pagination_limit');
              if ( empty( $page_limit) )  {$page_limit=20;update_option('church_admin_pagination_limit',20);}
              $p->limit( $page_limit); // Limit entries per page
                if(!empty( $_GET['order'] ) )
                {
                    switch( $_GET['order'] )
                    {
                        case 'title':
                            $order='a.file_title ASC';
                            $p->target("admin.php?page=church_admin%2Findex.php&action=podcast&section=media&order=title");
                        break;
                        case 'speakers':
                            $order='a.speaker ASC';
                            $p->target("admin.php?page=church_admin%2Findex.php&action=podcast&section=media&order=speaker");
                        break;    
                        case 'series':
                            $order='b.series_name ASC';
                            $p->target("admin.php?page=church_admin%2Findex.php&action=podcast&section=media&order=series");
                        break;
                        case 'plays':
                            $order='a.plays DESC';
                            $p->target("admin.php?page=church_admin%2Findex.php&action=podcast&section=media&order=plays");
                        break;
                        default:
                            $order='pub_date DESC';
                            $p->target("admin.php?page=church_admin%2Findex.php&action=podcast&section=media");
                        break;
                    }
                }
                 
                else
                {   $order='pub_date DESC';
                  $p->target("admin.php?page=church_admin%2Findex.php&action=podcast&section=podcast");
                }
              if(!isset( $p->paging) )$p->paging=1;
              if(!isset( $_GET[$p->paging] ) )
              {
                  $_GET[$p->paging]=1;
                $pageNo=  $_GET[$p->paging];  
              }
              $p->currentPage( $pageNo); // Gets and validates the current page
              $p->calculate(); // Calculates what to show
              $p->parameterName('paging');
              $p->adjacents(1); //No. of page away from the current page
              if(!isset( $_GET['paging'] ) )
              {
                  $p->page = 1;
              }
              else
              {
                  $p->page = $_GET['paging'];
              }
              //Query for limit paging
              $limit = " LIMIT " . ( $p->page - 1) * $p->limit  . ", " . $p->limit;


              // Pagination
                echo'<div class="tablenav"><div class="tablenav-pages">';
                echo $p->getOutput();
                echo '</div></div>';
                
              //Pagination
            }else{$limit='';}
            
            $results=$wpdb->get_results('SELECT a.*,b.series_name FROM '.CA_FIL_TBL.' a,'.CA_SERM_TBL.' b WHERE a.series_id=b.series_id  ORDER BY '.$order.' '.$limit);
            if( $results)
            {//results
                $table='';
                $header='<tr><td class="manage-column check-column"><input type="checkbox" id="select-all"></th><th class="column-primary"><a href="admin.php?page=church_admin/index.php&action=podcast&section=media&order=title&paging='.intval( $pageNo).'">'.__('Title','church-admin').'</a></th><th>'.__('Edit','church-admin').'</th><th>'.__('Delete','church-admin').'</th><th>'.__('Publ. Date','church-admin').'</th><th><a href="admin.php?page=church_admin/index.php&action=podcast&section=media&order=speaker&paging='.intval( $pageNo).'">'.__('Speakers','church-admin').'</a></th><th>'.__('Mp3 File','church-admin').'</th><th>'.__('File Okay?','church-admin').'</th><th>'.__('Length','church-admin').'</th><th>'.__('Media','church-admin').'</th><th>'.__('Embed','church-admin').'</th><th><a href="admin.php?page=church_admin/index.php&action=podcast&section=media&order=series&paging='.intval( $pageNo).'">'.__('Series','church-admin').'</a></th><th><a href="admin.php?page=church_admin/index.php&action=podcast&section=media&order=plays&paging='.intval( $pageNo).'">'.__('Plays','church-admin').'</a></th><th>'.__('Shortcode','church-admin').'</th></tr>';
                
                //bulk actions
                $table.='<form action="admin.php?page=church_admin/index.php&action=media" method="post">';
                $table.='<p><select name="method"><option>'.__('Bulk actions','church-admin').'</option>';
                $table.='<option value="remove-database">'.__('Remove from database','church-admin').'</option>';
                $table.='<option value="delete-files">'.__('Delete files and remove','church-admin').'</option>';
                $table.='</select><input type="submit" class="button-secondary" value="'.__('Apply','church-admin').'"/></p>';


                $table.='<table class="widefat striped wp-list-table"><thead>'.$header.'</thead>'."\r\n".'<tbody>';
                foreach( $results AS $row)
                {
                    if(file_exists(plugin_dir_path( $path.$row->file_name) ))  {$okay='<img src="'.plugins_url('images/green.png',dirname(__FILE__) ) .'" width="32" height="32"/>';}else{$okay='<img alt="'.__('No file','church-admin').'" src="'.plugins_url('images/red.png',dirname(__FILE__) ) .'" width="32" height="32"/>';}
                    $edit='<a href="'.wp_nonce_url('admin.php?page=church_admin/index.php&amp;action=edit_file&amp;id='.$row->file_id,'edit_podcast_file').'">'.__('Edit','church-admin').'</a>';
                    $delete='<a onclick="return confirm(\''.__('Are you sure?','church-admin').'\');" href="'.wp_nonce_url('admin.php?page=church_admin/index.php&amp;action=delete_file&amp;id='.$row->file_id,'delete_podcast_file').'">'.__('Delete','church-admin').'</a>';
                    
                    if(!empty( $row->file_name)&&file_exists( $path.$row->file_name) )  {
                        $file='<a href="'.esc_url( $url.$row->file_name).'">'.esc_html( $row->file_name).'</a>'; 
                        $okay='<img alt="'.__('File OK','church-admin').'" src="'.plugins_url('images/green.png',dirname(__FILE__) ) .'"/>';
                    }
                    elseif(!empty( $row->external_file) )  {
                        $file='<a href="'.esc_url( $row->external_file).'">'.esc_html( $row->external_file).'</a>'; 
                        $okay='<img src="'.plugins_url('images/green.png',dirname(__FILE__) ) .'"/>';
                    
                        if(empty($row->length))
                        {
                            //do some sneaky js and ajax magic to work this out and update the database
                            $file.='<script>
                            jQuery(document).ready(function($){
                    
                            var url="'.esc_url($row->external_file).'";
                            var au'.(int)$row->file_id.' = document.createElement("audio");

                            // Define the URL of the MP3 audio file
                            au'.(int)$row->file_id.'.src = url;
                            $("#audio_player'.(int)$row->file_id.'").html(au'.(int)$row->file_id.');
                            // Once the metadata has been loaded, display the duration in the console
                            au'.(int)$row->file_id.'.addEventListener("loadedmetadata", function(){
                                    
                                    var duration = parseInt(au'.(int)$row->file_id.'.duration);
                                    //convert to ISO format
                                    var date'.(int)$row->file_id.' = new Date(null);
                                    date'.(int)$row->file_id.'.setSeconds(duration); 
                                    var hhmmssFormat'.(int)$row->file_id.' = date'.(int)$row->file_id.'.toISOString().substr(11, 8);
                                    console.log("External duration is "+ hhmmssFormat'.(int)$row->file_id.');
                                    $("#length'.(int)$row->file_id.'").html(hhmmssFormat'.(int)$row->file_id.');
                                    var nonce="'.wp_create_nonce('sermon_length').'";
                                    var args'.(int)$row->file_id.'={"action":"church_admin","method":"sermon_length","nonce":nonce,"id":'.(int)$row->file_id.',"length":hhmmssFormat'.(int)$row->file_id.'};
                                    console.log(args'.(int)$row->file_id.');
                                    $.ajax({
                                        url: ajaxurl,
                                        type: "post",
                                        data:  args'.(int)$row->file_id.',
                                        success: function(response) {
                                          
                                            $("#length'.(int)$row->file_id.'").html(response);
                                            }
                                      });

                                },false);
                            

                    });
                    
                    </script>';

                        }
                    
                    }
                    else{$file='&nbsp;'; $okay='<img src="'.plugins_url('images/red.png',dirname(__FILE__) ).'"/>';}
                    $videoPlays='';
                
                    if(!empty( $row->video_url) )
                    {

                        $embed=church_admin_generateVideoEmbedUrl( $row->video_url);
                        
                        $views=church_admin_youtube_views_api( $embed['id'] );
                        if(!empty( $views) )  {$videoPlays='<br />'.sprintf(__('%1$s views','church-admin'),$views);}
                    }
                    $embed_code=!empty($row->embed_code)?__('Yes','church-admin'):__('No','church-admin');
                    $table.='<tr>
                        <th class="check-column"><input type="checkbox" name="file_id[]" value="'.(int)$row->file_id.'"/></th>
                        <td data-colname="'.__('Sermon title','church-admin').'" class="column-primary">'.esc_html( $row->file_title).'<button type="button" class="toggle-row"><span class="screen-reader-text">show details</span></button></td>
                        <td data-colname="'.__('Edit','church-admin').'">'.$edit.'</td>
                        <td data-colname="'.__('Delete','church-admin').'">'.$delete.'</td>
                        <td data-colname="'.__('Published','church-admin').'">'.date(get_option('date_format').' '.get_option('time_format'),strtotime( $row->pub_date) ).'</td>
                        <td data-colname="'.__('Speakers','church-admin').'" class="ca-names">'.esc_html(church_admin_get_people( $row->speaker) ).'</td>
                        <td data-colname="'.__('Sermon filename','church-admin').'">'.$file.'</td>
                        <td data-colname="'.__('File exists','church-admin').'">'.$okay.'</td>
                        <td data-colname="'.__('Sermon length','church-admin').'"><span id="length'.(int)$row->file_id.'">'.esc_html( $row->length).'</span></td>
                        <td data-colname="'.__('Video URL','church-admin').'">'.$row->video_url.'</td>
                        <td data-colname="'.__('Embed code','church-admin').'">'.$embed_code.'</td>
                        <td data-colname="'.__('Series name','church-admin').'">'.esc_html( $row->series_name).'</td>
                        
                        <td data-colname="'.__('Video plays','church-admin').'">'.sprintf(__('%1$s mp3 plays','church-admin'),intval( $row->plays) ).$videoPlays.'</td>
                        <td data-colname="'.__('Shortcode','church-admin').'">[church_admin type="single-sermon" file_id="'.intval( $row->file_id).'"]</td>
                    </tr>';
                }

                $table.='</tbody><tfoot>'.$header.'</tfoot></table>';
                $table.='</form>';
                echo $table;
            }//end results
            else
            {
                echo'<p>'.__('No files stored yet','church-admin').'</p>';
                echo'<p><a class="button-primary" href="'.$church_admin_url.'&action=upload-mp3&amp;section=media">'.__('Upload Sermon','church-admin').'</a></p>';
            }
    }
}


function ca_podcast_delete_file( $id=NULL)
{
  /**
 *
 * Delete File
 *
 * @author  Andy Moyle
 * @param    $id=null
 * @return   html string
 * @version  0.1
 *
 */
    global $wpdb,$rm_podcast_settings;
    if(!empty( $id) )
    {//non empty $id
        $data=$wpdb->get_row('SELECT a.*,b.series_name AS series_name FROM '.CA_FIL_TBL.' a , '.CA_SERM_TBL.' b WHERE a.file_id="'.esc_sql( $id).'" AND a.series_id=b.series_id');
        if(!empty( $_POST['sure'] ) )
        {//end sure so delete
			$upload_dir = wp_upload_dir();
            if(!empty( $data->file_name)&&file_exists( $upload_dir['basedir'].'/sermons/'.$data->file_name) )unlink( $upload_dir['basedir'].'/sermons/'.$data->file_name);
            $wpdb->query('DELETE FROM '.CA_FIL_TBL.' WHERE file_id="'.esc_sql( $id).'"');
            ca_podcast_xml();//update podcast feed
            echo'<div class="notice notice-success inline">'.esc_html( $data->file_title).' '.__('from','church-admin').' '.esc_html( $data->series_name).' '.__('deleted','church-admin').'</p></div>';
            ca_podcast_list_files();
        }//end sure so delete
        else
        {
            echo'<p>'.printf(__('Are you sure you want to delete %1$s sermon form %2s?','church-admin'),esc_html( $data->file_title),esc_html( $data->series_name) );
            echo'<form action="" method="post"><input type="hidden" name="sure" value="YES"/><input type="submit" value="'.__('Yes','church-admin').'" class="button-primary"/></form></p>';
        }

    }//end non empty $id
    else{echo'<p>'.__('No file specified','church-admin').' '.(int)$id.'</p>';}
}

function ca_podcast_check_files()
{
    /**
 *
 * Checks Files in media directory, table of non db stored files
 *
 * @author  Andy Moyle
 * @param    $id=null
 * @return   html string
 * @version  0.2
 * 0.2 fixed empty $form array 2016-03-20
 *
 */
    global $wpdb,$rm_podcast_settings;

	$upload_dir = wp_upload_dir();
	$path=$upload_dir['basedir'].'/sermons/';
	$url=content_url().'/uploads/sermons/';
	$files=scandir( $path);
    $exclude_list = array(".", "..", "index.php","podcast.xml",".htaccess");
    $files = array_diff( $files, $exclude_list);


        $table='<h2>'.__('Unattached Media Files','church-admin').'</h2><table class="widefat striped"><thead><tr><th>'.__('Delete','church-admin').'</th><th>'.__('Filename','church-admin').'</th><th>'.__('Add to podcast','church-admin').'</th></tr></thead><tfoot><tr><th>'.__('Delete','church-admin').'</th><th>'.__('Filename','church-admin').'</th><th>'.__('Add to podcast','church-admin').'</th></tr></tfoot><tbody>';

        foreach( $files as $entry)
        {
            $check=$wpdb->get_var('SELECT file_id FROM '.CA_FIL_TBL.' WHERE file_name="'.esc_sql(basename( $entry) ).'"');

            if(is_file( $path.$entry)&&!$check)
            {

                $delete='<a onclick="return confirm(\''.__('Are you sure?','church-admin').'\');" href="'.wp_nonce_url('admin.php?page=church_admin/index.php&amp;action=file_delete&file='.esc_html( $entry),'file_delete').'">'.__('Delete','church-admin').'</a>';
                $add='<a href="'.wp_nonce_url('admin.php?page=church_admin/index.php&amp;action=file_add&file='.esc_html( $entry),'file_add').'">'.__('Add to podcast','church-admin').'</a>';
                $table.='<tr><td>'.$delete.'</td><td>'.$entry.'</td><td>'.$add.'</td></tr>';
            }
        }
        $table.='</tbody></table>';
        echo $table;

}

function ca_podcast_file_add( $file_name=NULL)
{
  /**
 *
 * Edit podcast file from directory to podcasts
 *
 * @author  Andy Moyle
 * @param    $id=null
 * @return   html string
 * @version  0.2
 * 0.2 fixed no blog post title and featured image
 *
 */
 	$settings=get_option('ca_podcast_settings');
    if(!$file_name)wp_die("No file specified");
	$upload_dir = wp_upload_dir();
	$path=$upload_dir['basedir'].'/sermons/';
	$url=content_url().'/uploads/sermons/';
	$current_data=new stdClass();
	$settings=get_option('ca_podcast_settings');

    global $wpdb;
    $wpdb->show_errors();
    $file_name=basename( $file_name);
    $sanitizedFilename=sanitize_file_name( $file_name);
    $file_url=$url.$sanitizedFilename;
    echo'<h2>'.sprintf(__('Add File - %1$s','church-admin'),$file_name).'</h2>';
    if(!empty( $_POST['save_file'] )&&check_admin_referer('upload_mp3','nonce') )
    {//process form
        
        if( $sanitizedFilename!=$file_name)
        {
        if(!rename( $path.$file_name,$path.$sanitizedFilename) ) exit(__('Filename needs to be sanitized no special characters or whitespaces','church-admin') );
        }
        $speaker=esc_sql( $_POST['speaker'] );
        $length="00:00";
        if ( empty( $sanitizedFilename) &&!empty( $current_data->file_name) )
        {
            //check and fix filename
            $file_name=sanitize_file_name( $current_data->file_name);
            
        }
        if(!empty( $sanitizedFilename)&&file_exists( $path.$sanitizedFilename) )
		{
		
            //from 3.6.20 use WordPress native function
            $audiometadata=wp_read_audio_metadata( $path.$sanitizedFilename );
            $length=!empty( $audiometadata['length_formatted'] )?$audiometadata['length_formatted']:null;


        }
        $form=$sqlsafe=array();
        foreach( $_POST AS $key=>$value)  {$form[$key]=sanitize_text_field(stripslashes( $value) );}
        foreach( $_POST AS $key=>$value)  {$sqlsafe[$key]=esc_sql(sanitize_text_field(stripslashes( $value) ));}
        $allowed=array(
    		'a' => array(
        		'href' => array(),
        		'title' => array()
    		),
    		'br' => array(),
    		'em' => array(),
    		'p' =>array(),
    		'img'=>array(),
    		'strong' => array(),
		);
        $transcript=esc_sql(wp_kses_post(stripslashes( $_POST['transcript'] ),$allowed) );
        $passages=esc_sql(church_admin_podcast_readings( $form['passages'] ) );
        if ( empty( $_POST['pub_date'] ) )  {$sqlsafe['pub_date']=date("Y-m-d" );}else{$sqlsafe['pub_date']=esc_sql( $_POST['pub_date'] );}
        if(!empty( $sqlsafe['pub_time'] ) )
        {
            $sqlsafe['pub_date'].=' '.$sqlsafe['pub_time'].':00';
        }
        else
        {
            $sqlsafe['pub_date'].=' 12:00:00';    
        }
        if(!empty( $_POST['private'] ) )  {$private="1";}else{$private="0";}

        if ( empty( $id) )$id=$wpdb->get_var('SELECT file_id FROM '.CA_FIL_TBL.' WHERE file_name="'.$sanitizedFilename.'"' );
        if(!empty( $id) )
        {//update
            $sql='UPDATE '.CA_FIL_TBL.' SET video_url="'.$sqlsafe['video_url'].'",pub_date="'.$sqlsafe['pub_date'].'", length="'.$length.'", last_modified="'.date("Y-m-d H:i:s" ).'",private="'.$private.'",file_name="'.esc_sql( $sanitizedFilename).'" ,file_subtitle= "'.$sqlsafe['file_subtitle'].'",file_title="'.$sqlsafe['file_title'].'" , file_description="'.$sqlsafe['file_description'].'" , series_id="'.$sqlsafe['series_id'].'" , speaker="'.$speaker.'",transcript="'.$transcript.'",bible_passages="'.$passages.'",bible_texts="'.$sqlsafe['passages'].'",file_slug="'.esc_sql(sanitize_title( $form['file_title'] ) ).'" WHERE file_id="'.esc_sql( $id).'"';

            $wpdb->query( $sql);
        }//end update
        else
        {//insert
            $sql='INSERT INTO '.CA_FIL_TBL.' (file_name,file_subtitle,file_title,file_description,private,length,series_id,service_id,speaker,pub_date,last_modified,video_url,transcript,bible_passages,bible_texts,file_slug)VALUES("'.esc_sql( $sanitizedFilename).'","'.$sqlsafe['file_subtitle'].'","'.$sqlsafe['file_title'].'","'.$sqlsafe['file_description'].'" ,"'.$private.'","'.$length.'","'.$sqlsafe['series_id'].'","'.$sqlsafe['service_id'].'","'.$speaker.'" ,"'.$sqlsafe['pub_date'].'","'.date("Y-m-d H:i:s" ).'","'.$sqlsafe['video_url'].'","'.$transcript.'","'.$passages.'","'.$sqlsafe['passages'].'","'.esc_sql(sanitize_title( $form['file_title'] ) ).'")';

            $wpdb->query( $sql);
            $id=$wpdb->insert_id;
        }//end insert
      
        //email section
        if(!empty( $_POST['email_send'] ) )
        {
          $check=$wpdb->get_var('SELECT email_sent FROM '.CA_FIL_TBL.' WHERE file_id="'.esc_sql( $id).'"');
          if( $check=="0000-00-00")church_admin_send_sermon( $id);
        }
		//post if set
		if(!empty( $_POST['blog'] ) )
		{

			$settings=church_admin_handle_podcast_image( $settings);
			$title=$form['file_title'];
			$content='[church_admin type="single-sermon" file_id="'.(int)$id.'"]';
			$cat_id=wp_create_category( __('Sermon Mp3s','church-admin') );
			$postID=$wpdb->get_var('SELECT postID FROM '.CA_FIL_TBL.' WHERE file_id="'.esc_sql( $id).'"');

			$args=array('post_title'=>$title,'post_content'=>$content,'post_type'=>'post','post_status'=>'publish');

			if ( empty( $postID) )$args['ID']=$postID;
			$postID=wp_insert_post( $args);
			$message ='<p><a href="'.esc_url( get_permalink( $postID) ).'">'.__('Sermon posted.','church-admin').' </a></p>';

			wp_set_post_categories( $postID,array( $cat_id) );
			if(!empty( $settings['thumbnail_id'] ) )  {set_post_thumbnail( $postID, $settings['thumbnail_id'] );echo'<p>'.__('Thumbnail set.','church-admin').'</p>';}
			$wpdb->query('UPDATE '.CA_FIL_TBL.' SET postID="'.$postID.'"');
		}
		//ping where sermons are shown
		$id=church_admin_get_id_by_shortcode('podcast');
		if(!empty( $id) )
		{
			generic_ping( $id);
			$datetime = date("Y-m-d H:i:s");
			$wpdb->query( "UPDATE `$wpdb->posts` SET `post_modified` = '".$datetime."' WHERE `ID` = '".$id."'" );
		}
        ca_podcast_xml();//update podcast feed
        church_admin_update_last_sermon_series();
        echo'<div class="notice notice-success inline"><p>'.__('File Saved','church-admin').'</p></div>';
        echo '<p><a class="button-primary" href="'.wp_nonce_url('admin.php?page=church_admin/index.php&amp;action=edit_file&amp;section=podcast','edit_podcast_file').'">'.__('Upload or add external mp3 File','church-admin').'</a></p>';
          echo '<p><a class="button-secondary" href="'.wp_nonce_url('admin.php?page=church_admin/index.php&amp;action=check-files&amp;sermon=podcast','check_podcast_file').'">'.__('Add Already Uploaded Files','church-admin').'</a></p>';
        echo'<p><a class="button-secondary"  href="'.wp_nonce_url("admin.php?page=church_admin/index.php&amp;action=list_sermon_series&amp;section=podcast",'list_sermon_series').'">'.__('List Sermon Series','church-admin').'</a></p>';
        ca_podcast_list_files();
    }//end process form
    else
    {//form

    	
        echo '<form action="" method="POST" id="churchAdminForm" enctype="multipart/form-data">';
        echo'<table class="form-table"><tbody><tr><th scope="row">'.__('File title (required)','church-admin').'</th><td><input type="text" required="required" name="file_title" id="file_name" ';
        if(!empty( $current_data->file_title) ) echo 'value="'.esc_html( $current_data->file_title).'"';
        echo'/></td></tr>';
        echo'<tr><th scope="row">'.__('File SubTitle (a few words - required)','church-admin').'</th><td><input type="text" required="required"  name="file_subtitle" id="file_subtitle" ';
        if(!empty( $current_data->file_subtitle) ) echo 'value="'.esc_html( $current_data->file_subtitle ).'"';
        echo'/></td></tr>';
        echo'<tr><th scope="row">'.__('File Description','church-admin').'</th><td>';
        echo '<textarea name="file_description">';
        if(!empty( $current_data->file_description) )echo esc_textarea( $current_data->file_description );
        echo'</textarea></td></tr>';
        echo'<tr><th scope="row">'.__('Scripture passage','church-admin').'</th><td><input type="text" class="large-text" name="passages" placeholder="'.__('Bible passages','church-admin').'" ';
        if(!empty( $current_data->bible_text) ) echo 'value="'.esc_html( $current_data->bible_text ).'" ';
        echo '</td></tr>';
        echo'<tr><th scope="row">'.__('Logged in only?','church-admin').'</th><td><input type="checkbox" name="private" value="yes"/></p>';
        $ev_res=$wpdb->get_results('SELECT * FROM '.CA_SERM_TBL.' ORDER BY series_id DESC');
        if( $ev_res)
        {
            echo'<tr><th scope="row">'.__('Service','church-admin').'</th><td><select name="series_id">';
            $first=$option='';
            foreach( $ev_res AS $series_row)
            {
                if( $series_row->series_id==$current_data->series_id)
                {
                    $first='<option value="'.intval( $series_row->series_id).'" selected="selected">'.esc_html( $series_row->series_name).'</option>';
                }
                else
                {
                    $option.='<option value="'.intval( $series_row->series_id).'">'.esc_html( $series_row->series_name).'</option>';
                }

            }
            echo $first.$option.'</select></td></tr>';
        }
        //service
        $service_res=$wpdb->get_results('SELECT CONCAT_WS(" ",service_name,service_time) AS service_name,service_id FROM '.CA_SER_TBL.' ORDER BY service_id DESC');
        if( $service_res)
        {
            echo'<tr><th scope="row">'.__('Service','church-admin').'</th><td><select name="service_id">';
            $first=$option='';
            foreach( $service_res AS $service_row)
            {
                if( $service_row->service_id==$current_data->service_id)
                {
                    $first='<option value="'.intval( $service_row->service_id).'" selected="selected">'.esc_html( $service_row->service_name).'</option>';
                }
                else
                {
                    $option.='<option value="'.intval( $service_row->service_id).'">'.esc_html( $service_row->service_name).'</option>';
                }

            }
            echo $first.$option.'</select></td></tr>';
        }
        echo'<tr><th scope="row">Speaker</th><td>';
        echo church_admin_autocomplete('speaker','friends','to', NULL);
        echo'</td></tr>';
        if ( empty( $current_data->pub_date) )
        {
            $current_data->pub_date=date('Y-m-d ');
            $current_time='12:00:00';
        }
        else
        {
            //make sure only date component passed to date picker!
            $current_time=mysql2date('H:i:s',$current_data->pub_date);
            $current_data->pub_date=date('Y-m-d',strtotime( $current_data->pub_date) );
        }
        //javascript to bring up date picker
       
	
        echo'<tr><th scope="row">'.__('Publication Date','church-admin').'</th><td>'.church_admin_date_picker(NULL,'pub_date',FALSE,date('Y-m-d',strtotime("-15 years") ),NULL,'pub_date','pub_date',FALSE).'</td></tr>';
        echo '<tr><th scope="row">'.__('Publication Time','church-admin').'</th><td><input type="time" name="pub_time"';
         echo ' value="'.mysql2date('H:i:s',$current_time).'" ';
        echo'/></td></tr>';
        
        
        echo'<input type="hidden" name="external_duration" id="external_duration"/>';
            //javascript to detect length of external audio
                echo'<script>
                jQuery(document).ready(function($){
                  
                        var url="'.esc_url($file_url).'";
                        var au = document.createElement("audio");

                        // Define the URL of the MP3 audio file
                        au.src = url;
                        $("#audio_player").html(au);
                        // Once the metadata has been loaded, display the duration in the console
                        au.addEventListener("loadedmetadata", function(){
                                
                                var duration = parseInt(au.duration);
                                //convert to ISO format
                                var date = new Date(null);
                                date.setSeconds(duration); 
                                var hhmmssFormat = date.toISOString().substr(11, 8);
                                console.log("External duration is "+ hhmmssFormat);
                                $("#external_duration").val(hhmmssFormat);
                            },false);
                        

                });
                
                </script>';
         echo'<tr><th scope="row">'.__('Video URL','church-admin').'</th><td><input type="text" name="video_url" id="video_url"';
		if(!empty( $current_data->video_url) )echo' value="'.esc_url( $current_data->video_url).'" ';
		echo'/>'.__('Add [VIDEO_URL] to your sermon files template to display','church-admin').'</td></tr>';
		echo'<tr><th scope="row">'.__('Notes/Transcript','church-admin').'</th><td>';
        if ( empty( $current_data->transcript) )  {$transcript='';}else{$transcript=$current_data->transcript;}
        wp_editor( $transcript, 'transcript' );
        echo'</td></tr>';
		echo'<tr><th scope="row">'.__('Blog the sermon','church-admin').'</th><td><input type="checkbox" checked name="blog" value="1"/></td></tr>';
    $mailchimp=get_option('church_admin_mailchimp_settings');
      if(!empty( $mailchimp)&&$current_data->email_sent=="0000-00-00")	echo'<tr><th scope="row">'.__('Email the sermon using mailchimp','church-admin').'</th><td><input type="checkbox"  name="email_send" value="1"/></td></tr>';
        echo '<tr><th scope="row">&nbsp;</th><td><input type="hidden" name="save_file" value="save_file"/>'.wp_nonce_field('upload_mp3','nonce',TRUE,FALSE).'<input type="submit" class="button-primary" value="'.__('Save File','church-admin').'"/></td></tr></table></form>';
    }//form


}
function ca_podcast_file_delete( $file_name=NULL)
{
	$upload_dir = wp_upload_dir();
	$path=$upload_dir['basedir'].'/sermons/';
	$url=content_url().'/uploads/sermons/';
    if( $file_name &&is_file( $path.basename( $file_name) ))
    {
        unlink( $path.basename( $file_name) );
        echo'<div class="notice notice-success inline"><p>'.esc_html(basename( $file_name) ).' '.__('deleted','church-admin').'</p></div>';
        ca_podcast_check_files();
    }
}




function church_admin_latest_sermons_widget_output( $limit,$title)
{
	global $wpdb;
	$upload_dir = wp_upload_dir();
	$path=$upload_dir['basedir'].'/sermons/';
	$url=content_url().'/uploads/sermons/';
	
	$out='<div class="church-admin-sermons-widget">';
	$ca_podcast_settings=get_option('ca_podcast_settings');

	if(!empty( $ca_podcast_settings['link'] ) )$out.='<p><a title="Download on Itunes" href="'.$ca_podcast_settings['itunes_link'].'">
    <img  alt="badge_itunes-lrg" src="'.plugins_url('/images/badge_itunes-lrg.png',dirname(__FILE__) ).'" width="110" height="40" /></a></p>';
	$options=get_option('church_admin_latest_sermons_widget');

	$limit=$options['sermons'];
	if ( empty( $limit) )$limit=5;
	$sermons=$wpdb->get_results('SELECT a.*,b.* FROM '.CA_FIL_TBL.' a, '.CA_SERM_TBL.' b WHERE a.series_id=b.series_id ORDER BY a.pub_date DESC LIMIT '.$limit);
	if(!empty( $sermons) )
	{
		foreach( $sermons AS $data)
		{
			$speaker=church_admin_get_people( $data->speaker);
			/*if(!empty( $sermon->file_name) )  {$out.='<p><a href="'.esc_url( $url.$sermon->file_name).'"  title="'.esc_html( $sermon->file_title).'">'.esc_html( $sermon->file_title).'</a>';}else{$out.='<p><a href="'.esc_url( $sermon->external_file).'"  title="'.esc_html( $sermon->file_title).'">'.esc_html( $sermon->file_title).'</a>';}
			$out.='<br />By '.esc_html( $speaker).' on '.mysql2date(get_option('date_format'),$sermon->pub_date).'<br />';

			$out.='<audio class="sermonmp3" id="'.$sermon->file_id.'" src="'.esc_url( $url.$sermon->file_name).'" preload="none"></audio><br />';
                */
            if(!empty( $data->file_title) )$out.='<h2>'.esc_html( $data->file_title).'</h2>';
				if(!empty( $data->video_url) )
                {
                    if(strpos( $data->video_url, 'amazonaws.com/') !== false)
                    {
                       $out.='<video class="ca-video" width="560" height="315" controls><source src="'.$data->video_url.'" type="video/mp4">Your browser does not support the video tag.
    </video>'; 
                    }else
                    {
                        $video=church_admin_generateVideoEmbedUrl( $data->video_url);
                        $videoUrl=$video['embed'];
                        $out.='<iframe class="ca-video" width="560" height="315" src="'.esc_url( $videoUrl).'" frameborder="0" allow="accelerometer; autoplay; encrypted-media; gyroscope; picture-in-picture" allowfullscreen></iframe>';
                    }
                }

				if(!empty( $data->file_name)&& file_exists( $path.$data->file_name) )
                {
                    $out.='<p><audio class="sermonmp3" data-id="'.esc_html( $data->file_id).'" src="'.esc_url( $url.$data->file_name).'" preload="auto" controls></audio></p>';
				    $download='<a href="'.esc_url( $url.$data->file_name).'" class="mp3download" data-id="'.(int)$data->file_id.'" title="'.esc_html( $data->file_title).'" download>'.esc_html( $data->file_title).'</a>';
				}
				elseif(!empty( $data->external_file) )
				{
						$out.='<p><audio class="sermonmp3" data-id="'.esc_html( $data->file_id).'" src="'.esc_url( $data->external_file).'" preload="auto" controls></audio></p>';

						$download='<a href="'.esc_url( $data->external_file).'" class="mp3download" data-id="'.(int)$data->file_id.'" title="'.esc_html( $data->file_title).'" download>'.esc_html( $data->file_title).'</a>';
				}
		}
        $out.='<script>var mp3nonce="'.wp_create_nonce("church_admin_mp3_play").';"</script>';
	}



    $out.='</div>';
    return $out;

}


function church_admin_podcast_readings( $passages)
{
	if(!empty( $passages) )
	{
	$version=get_option('church_admin_bible_version');
	$readings=explode(",",$passages);
 $out='';
	$passages=array();
	foreach( $readings AS $key=>$value)
		{

  			$passage = urlencode( $value);

  			switch( $version)
  			{

  				case'KJV':
  					$out='';
  					$url='https://bible-api.com/'.$passage.'?translation=kjv';
  					$ch = curl_init( $url);
  					curl_setopt( $ch, CURLOPT_RETURNTRANSFER, 1);
  					$response = json_decode(curl_exec( $ch),true);
  					if( $response)
  					{
  						curl_close( $ch);
  						$oldChapter='';
  						$out='<p>';
  						foreach( $response['verses']AS $verses)
  						{
  							$chapter=$verses['chapter'];
  							//only outpt chapter number on new chapter
  			 				if( $chapter!=$oldChapter)  {$out.='<span style="font-size:larger">'.$verses['chapter'].':'.$verses['verse'].'</span> ';}
  			 				else{$out.='<span style="font-size:smaller">'.$verses['verse'].'</span> ';}
  			 				//output scripture text
  			 				$out.=$verses['text'].'<br />';
  			 				$oldChapter=$chapter;
  						}
  						$out.='</p>';
  					}
  					$passages[$key]='<h2>'.$value.'</h2><div class="bible-text" id="passage'.$key.'">'.$out.'</div>';
  				break;
  				//old style vesrion using api
  				case'KJV':
				case "ostervald":
				case "schlachter":
				case "statenvertaling":
				case "swedish":
				case "bibelselskap":
				case "sse":
				case "lithuanian":
  					$url='http://api.preachingcentral.com/bible.php?passage='.$passage.'&version='.$version;

  					$ch = curl_init( $url);
  					curl_setopt( $ch,CURLOPT_FAILONERROR,true);
  					curl_setopt( $ch, CURLOPT_RETURNTRANSFER, 1);
  					$out='<p>';
  					$response = simplexml_load_string(curl_exec( $ch) );

  					$oldChapter='';
  					foreach( $response->range->item AS $id=>$passage)
  					{
  						if(defined('CA_DEBUG') )church_admin_debug( $passage->chapter.' '.$oldChapter."\r\n");
  						//only output chapter number on new chapter
  			 			if(intval( $passage->chapter) != intval( $oldChapter) )  {$out.='<span style="font-size:larger">'.$passage->chapter.':'.$passage->verse.'</span> ';}
  			 			else{$out.='<span style="font-size:smaller">'.$passage->verse.'</span> ';}
  			 			//output scripture text
  			 			$out.=$passage->text.' ';
  			 			$oldChapter=$passage->chapter;
  					}
  					$out.='</p>';
  					$passages[$key]='<h2>'.$value.'</h2><div class="bible-text" id="passage'.$key.'">'.$out.'</div>';

  					if(curl_errno( $ch) )  {
    					if(defined('CA_DEBUG') )church_admin_debug( 'Request Error:' . curl_error( $ch) );
					}
  					curl_close( $ch);


  				break;
  				default:
  					$out.='<a href="https://www.biblegateway.com/passage/?search='.urlencode( $passage).'&version='.$version.'&interface=print" target="_blank">'.esc_html( $passage).'</a>';

  				break;
  			}

		}//end of readings grabbed
		return(implode('<br />',$passages) );
	}
}



function church_admin_send_sermon( $id)
{
    global $wpdb;
    if(defined('CA_DEBUG') )church_admin_debug('Church Admin Send Sermon begin');
    $upload_dir = wp_upload_dir();
  	$path=$upload_dir['basedir'].'/sermons/';
  	$url=content_url().'/uploads/sermons/';


    $sql='SELECT a.*,b.* FROM '.CA_FIL_TBL.' a, '.CA_SERM_TBL.' b WHERE a.series_id=b.series_id AND a.file_id="'.(int)$id.'"';
    $data=$wpdb->get_row( $sql);

  
    if(!empty( $data) )
    {
      $subject=__('Latest sermon available','church-admin');
      $message='<p>'.sprintf(__('The latest sermon "%1$s" by %2$s in the %3$s series is online','church-admin'),esc_html( $data->speaker), esc_html( $data->file_title), esc_html( $data->series_name) ).'<p>';
      if(!empty( $data->video_url) )$message.='<p><a href="'.esc_url( $data->video_url).'">'.__('Watch now','church-admin').'</p>';
      if(!empty( $data->file_name) && file_exists( $path.$data->file_name) )
      {
          $message.='<a href="'.esc_url( $url.$data->file_name).'" title="'.esc_html( $data->file_title).'">'.esc_html( $data->file_title).'</a>';
      }
      elseif(!empty( $data->external_file) )
      {
        $message.='<p><a href="'.esc_url( $data->external_file).'" title="'.esc_html( $data->file_title).'">'.esc_html( $data->file_title).'</a></p>';
      }
      if(!empty( $data->bible_texts) )
      {
        $pass=array();
        $version=get_option('church_admin_bible_version');
        $passages=explode(",",$data->bible_texts);
        if(!empty( $passages)&&is_array( $passages) )
        {
          foreach( $passages AS $passage)$pass[]='<a href="https://www.biblegateway.com/passage/?search='.urlencode( $passage).'&version='.$version.'&interface=print" target="_blank">'.esc_html( $passage).'</a>';

        $message.='<p>'.__('Scriptures','church-admin').':&nbsp;</td><td>'.implode(", ",$pass).'</p>';
        }
      }
      if(!empty( $data->transcript) )  {$message.=$data->transcript;}else{$message.='<p>'.__('No Notes saved for this sermon','church-admin').'</p>';}
      $MailChimpSettings=get_option('church_admin_mailchimp');
      if(!empty( $MailChimpSettings) )
      {
        $mailChimpInterests=get_option('church_admin_MailChimpInterests');
        require_once(plugin_dir_path(dirname(__FILE__) ).'/includes/mailchimp.inc.php');
  			$MailChimp = new MailChimp( $MailChimpSettings['api_key'] );
  			$MailChimp->verify_ssl = 'false';
  			$segment_opts =
  			   array(
  						'match' => 'any', // or 'all' or 'none'
  						'conditions' => array (
      						array(
          					'condition_type' => 'Interests', // note capital I
          					'field' => 'interests-'.$MailChimpSettings['ministry_id'], // ID of interest category
                                             // This ID is tricky: it is
                                             // the string "interests-" +
                                             // the ID of interest category
                                             // that you get from MailChimp
                                             // API (31f7aec0ec)
          					'op' => 'interestcontains', // or interestcontainsall, interestcontainsnone
          					'value' => array (
              					$mailChimpInterests[__('Ministries','church-admin')][__('News send','church-admin')]
          					)
      					)
    					)
  			);
  			if ( empty( $user->email) )
  			{
  				$user= new stdClass();
  				$user->email=get_option('admin_email');
  				$user->name=get_option('blogname');
  			}
  			$result = $MailChimp->post("campaigns", array(
  	    'type' => 'regular',
  	    'recipients' => array('list_id' =>$MailChimpSettings['listID'],'segment_opts'=>$segment_opts),
  	    'settings' => array('subject_line' => $subject,

  	           'reply_to' => $user->email,
  	           'from_name' => $user->name
             )
  	    ) );

  			if (!$MailChimp->success() ) {if(defined('CA_DEBUG') )church_admin_debug( "Post Campaign Error\r\n".$MailChimp->getLastError() );}
  			$response = $MailChimp->getLastResponse();
  			$responseObj = json_decode( $response['body'] );
      
  			$result = $MailChimp->put('campaigns/' . $responseObj->id . '/content', array('html' =>  $message) );
  			if (!$MailChimp->success() ) {if(defined('CA_DEBUG') )church_admin_debug( "Put Campaign Error\r\n".$MailChimp->getLastError() );}

  			$result = $MailChimp->post('campaigns/' . $responseObj->id . '/actions/send');
  			if (!$MailChimp->success() ) {if(defined('CA_DEBUG') )church_admin_debug( "Send Campaign Error\r\n".$MailChimp->getLastError() );}
        $wpbd->query('UPDATE '.CA_FIL_TBL.' SET email_sent="'.date('Y-m-d').'" WHERE file_id="'.(int)$id.'"');
      }
    }

}



function church_admin_edit_sermon( $file_id)
{
    if(!church_admin_level_check('Sermons') )wp_die(__('You don\'t have permission to do that','church-admin') );
    if(defined('CA_DEBUG') )church_admin_debug("********************************\r\n church_admin_edit_sermon\r\n".date('Y-m-d H:i:s') );
    
    global $wpdb;
    $wpdb->show_errors;
    $data=NULL;
    if(!empty( $file_id) )$data=$wpdb->get_row('SELECT a.*,b.* FROM '.CA_FIL_TBL.' a, '.CA_SERM_TBL.' b WHERE a.file_id="'.(int)$file_id.'" AND a.series_id=b.series_id');
    
	$settings=get_option('ca_podcast_settings');
    
    $upload_dir = wp_upload_dir();
	$path=$upload_dir['basedir'].'/sermons/';
	$url=content_url().'/uploads/sermons/';
    
    
    echo'<h2>'.__('Sermon Upload','church-admin').'</h2>';
    
    $errors=array();
    if(defined('CA_DEBUG') )church_admin_debug("POSTED DATA");
    if(defined('CA_DEBUG') )church_admin_debug( $_POST);
    if(!empty( $_POST['save_file'] ) )
    {
        if(defined('CA_DEBUG') )church_admin_debug("Includeed Save_file");
        
        
        $form=$sqlsafe=array();
        foreach( $_POST AS $key=>$value)$form[$key]=sanitize_text_field(stripslashes( $value) );
        foreach( $form AS $key=>$value)$sqlsafe[$key]=esc_sql( $value);
        /********************************
        *   Check for sermon title
        *********************************/
        if ( empty( $form['file_title'] ) )$errors['file_title']=__('A title for the sermon is required','church-admin');
        /********************************
        *   Check for mp3/video content
        *********************************/
        if ( empty( $data->file_name) && empty( $_FILES['file']['name'] )&&empty( $form['audio_url'] )&&empty( $form['video_url'] ) && empty( $form['embed_code']) )
        {
            $errors['content']=__('You need to upload an audio file or enter an audio or video url','church-admin');
        }
        /****************************************
         * Handle if Google share url in audio_url
         ***************************************/
        if(!empty( $form['audio_url'] ) )
        {
            $sqlsafe['audio_url']=$form['audio_url'];
            $audioURL=$form['audio_url'];
            if(str_contains( $audioURL,'google.com') )
            {
                church_admin_debug('Audio url from Google' .$audioURL);
                //Google download direct link is of a different form to the public share link, this snippet converts it (not issue if file>100MB)
                
                $url=str_replace('file/d/','uc?id=',$audioURL);
                $url=str_replace('/view?usp=sharing','&export=download',$url);
                $url=str_replace('/view?usp=share_link','&export=download',$url);
                $sqlsafe['audio_url']=$url;        
                church_admin_debug('Audio url changed to ' .$sqlsafe['audio_url'] );
                $mimeType=church_admin_getRemoteMimeType( $sqlsafe['audio_url'] );
                if( $mimeType!='application/binary')$errors['audio_url']=__('External file is not an mp3','church-admin');
                
            }
            else
            {
                $mimeType=church_admin_getRemoteMimeType( $sqlsafe['audio_url'] );
                if( $mimeType!='audio/mpeg')$errors['audio_url']=__('External file is not an mp3','church-admin');
            }
            $length=!empty($form['external_duration'])?$form['external_duration']: NULL;

            $file_name=NULL;
         
            
        }
        /********************
        *   Handle Upload
        *********************/
        if(!empty( $data->file_name) )$file_name=$data->file_name;
        //print_r($_FILES);
        if(!empty( $_FILES['file']['name'] ) )
        {//mp3s
            $arr_file_type = wp_check_filetype(basename( $_FILES['file']['name'] ) );
            $uploaded_file_type = $arr_file_type['type'];
            // Set an array containing a list of acceptable formats
            $allowed_file_types = array('audio/mp4', 'audio/mpeg','audio/mpeg3','audio/x-mpeg-3');
            // If the uploaded file is the right format
            if(in_array( $uploaded_file_type, $allowed_file_types) )
            {//valid file
                    $tmp_name = $_FILES["file"]["tmp_name"];
                    $name = $_FILES["file"]["name"];
                    $x=1;
                
                    $file_name=wp_unique_filename( $path,$_FILES["file"]["name"] );
                    church_admin_debug('File name after wp_unique_filename is '.$file_name);              
                    if(!move_uploaded_file( $tmp_name, $path.$file_name) )
                    {
                        if(defined('CA_DEBUG') )church_admin_debug("Upload error");
                        echo'<p>'.__('File Upload issue','church-admin').'</p>';
                    }else{
                        church_admin_debug('Files saved: '.$path.$file_name);
                    }
            }else{$errors['file']=__('Invalid file type uploaded - has to be audio mp3 or m4a');}
        }
       
        if(!empty( $file_name)&&file_exists( $path.$file_name) )
		{
			church_admin_debug('Getting meta data');
            //from 3.6.20 use WordPress native function
            $file_name=sanitize_file_name( $file_name);
            $audiometadata=wp_read_audio_metadata( $path.$file_name );
            $length=!empty( $audiometadata['length_formatted'] )?$audiometadata['length_formatted']:null;
		}
        if(empty($file_name))$ile_name=null;
        /******************************
        *   Abort if there are errors
        ******************************/
        if(!empty( $errors) )  {
            if(defined('CA_DEBUG') )church_admin_debug("There were errors \r\n".print_r( $errors,TRUE) );
            church_admin_sermon_form( $data,$errors);
        }
        else
        {//save sermon
            if(defined('CA_DEBUG') )church_admin_debug("OK to save sermon");
           
            /********************************
            *   Sanitize input data
            *********************************/
            if(!empty( $sqlsafe['speaker'] ) )  {$speaker=$sqlsafe['speaker'];}else{$speaker='';}
            $passages=esc_sql(church_admin_podcast_readings( $form['passages'] ) );
            /********************************
            *   Transcript
            *********************************/
            if ( empty( $_POST['transcript'] ) )$_POST['transcript']='';
            $allowed_html = ['a'=>['href'=>[],'title'=>[],],'br'=>[],'em'=>[],'strong' =>[],'ul' =>[],'ol' =>[],'li' =>[],'h1' =>[],'h2' =>[],'h3' =>[],'h4' =>[],'img' =>['src'=>[],'width'=>[],'height'=>[]]];
            $transcript=esc_sql(wp_kses( stripslashes( $_POST['transcript'] ), $allowed_html ) );
            if(!empty( $_POST['private'] ) )  {$private="1";}else{$private="0";}
            /***********************************
            *   Fix publication date and time
            ************************************/
            if ( empty( $_POST['pub_date'] ) )  {$sqlsafe['pub_date']=date("Y-m-d" );}else{$sqlsafe['pub_date']=esc_sql( $_POST['pub_date'] );}
            if(!empty( $sqlsafe['pub_time'] ) )
            {
                $sqlsafe['pub_date'].=' '.$sqlsafe['pub_time'].':00';
            }
            else
            {
                $sqlsafe['pub_date'].=' 12:00:00';    
            }
            /********************
            *   Sort series
            *********************/
            if(!empty( $sqlsafe['sermon_series'] ) )
            {
                //check if already exists
                $check=$wpdb->get_var('SELECT series_id FROM '.CA_SERM_TBL.' WHERE series_name="'.$sqlsafe['sermon_series'].'"');
                if(!$check)
                {
                    $wpdb->query('INSERT INTO '.CA_SERM_TBL.' (series_name)VALUES("'.$sqlsafe['sermon_series'].'")');
                    $sqlsafe['series_id']=$wpdb->insert_id;
                }
                else
                {
                    $sqlsafe['series_id']=$check;
                }
            }
            /*************************
             *  SAnitize embed code
             ************************/
            $embed_code='';
            if(!empty($_POST['embed_code']))
            {
                // WP's default allowed tags
                global $allowedtags;

                // allow iframe only in this instance
                $iframe = array( 'iframe' => array(
                                    'src' => array (),
                                    'allow' => array(),
                                    'width' => array (),
                                    'height' => array (),
                                    'frameborder' => array(),
                                    'allowFullScreen' => array() // add any other attributes you wish to allow
                                    ) );

                $allowed_html = array_merge( $allowedtags, $iframe );

                // Sanitize user input.
                $embed_code = wp_kses( $_POST['embed_code'], $allowed_html );
            }
            /********************
            *   Check if already saved
            *********************/           
            if(empty($length)){$length=null;}
            if(empty($file_name)){$file_name=null;}

            if(defined('CA_DEBUG') )church_admin_debug("SQLSAFE data\r\n".print_r( $sqlsafe,TRUE) );
            if ( empty( $file_id) )$file_id=$wpdb->get_var('SELECT file_id FROM '.CA_FIL_TBL.' WHERE external_file="'.$sqlsafe['audio_url'].'" AND length="'.$length.'" AND private="'.$private.'" AND file_name="'.$file_name.'" AND file_title="'.$sqlsafe['file_title'].'" AND file_description="'.$sqlsafe['file_description'].'" AND service_id="'.$sqlsafe['service_id'].'" AND series_id="'.$sqlsafe['series_id'].'" AND speaker="'.$speaker.'"');
            if(defined('CA_DEBUG') )church_admin_debug( $wpdb->last_query);
            if(!empty( $file_id) )
            {//update
                
                $sql='UPDATE '.CA_FIL_TBL.' SET embed_code="'.esc_sql( $embed_code ).'",external_file="'.$sqlsafe['audio_url'].'", video_url="'.$sqlsafe['video_url'].'",transcript="'.$transcript.'",file_subtitle="'.$sqlsafe['file_subtitle'].'",pub_date="'.$sqlsafe['pub_date'].'",length="'.$length.'", private="'.$private.'",last_modified="'.date("Y-m-d H:i:s" ).'",file_name="'.esc_sql($file_name).'" , file_title="'.$sqlsafe['file_title'].'" , file_description="'.$sqlsafe['file_description'].'" , service_id="'.$sqlsafe['service_id'].'",series_id="'.$sqlsafe['series_id'].'" , speaker="'.$speaker.'", bible_passages="'.$passages.'",bible_texts="'.$sqlsafe['passages'].'",file_slug="'.esc_sql(sanitize_title( $form['file_title'] ) ).'" WHERE file_id="'.esc_sql( $file_id).'"';

                $wpdb->query( $sql);
                if(defined('CA_DEBUG') )church_admin_debug("DB Update \r\n".$wpdb->last_query);
            }//end update
            else
            {//insert
                $sql='INSERT INTO '.CA_FIL_TBL.' (file_name,file_title,file_subtitle,file_description,private,length,service_id,series_id,speaker,pub_date,last_modified,transcript,video_url,external_file,bible_passages,bible_texts,file_slug,embed_code)VALUES("'.esc_sql($file_name).'","'.$sqlsafe['file_title'].'","'.$sqlsafe['file_subtitle'].'","'.$sqlsafe['file_description'].'" ,"'.$private.'","'.$length.'","'.$sqlsafe['service_id'].'","'.$sqlsafe['series_id'].'","'.$speaker.'" ,"'.$sqlsafe['pub_date'].'","'.date("Y-m-d H:i:s" ).'","'.$transcript.'","'.$sqlsafe['video_url'].'","'.$sqlsafe['audio_url'].'","'.$passages.'","'.$sqlsafe['passages'].'","'.esc_sql(sanitize_title( $form['file_title'] ) ).'","'.esc_sql( $embed_code ).'")';
                $wpdb->query( $sql);
                if(defined('CA_DEBUG') )church_admin_debug("DB Insert \r\n".$wpdb->last_query);
                $file_id=$wpdb->insert_id;
            }//end insert
            if(!empty( $_POST['blog'] ) )
            {
                if(defined('CA_DEBUG') )church_admin_debug('Going to post sermon blog');
                $title=$form['file_title'];
                $content='[church_admin type="single-sermon" file_id="'.(int)$file_id.'"]';
                $cat_id=wp_create_category( __('Sermon Mp3s','church-admin') );
                $postID=$wpdb->get_var('SELECT postID FROM '.CA_FIL_TBL.' WHERE file_id="'.esc_sql( $file_id).'"');

                $args=array('post_title'=>$title,'post_content'=>$content,'post_type'=>'post','post_status'=>'publish');
                if ( empty( $postID) )$args['ID']=$postID;
                $postID=wp_insert_post( $args);
                $message ='<p><a href="'.esc_url( get_permalink( $postID) ).'">Sermon posted </a></p>';

                wp_set_post_categories( $postID,array( $cat_id) );
                if(!empty( $settings['thumbnail_id'] ) )  {set_post_thumbnail( $postID, $settings['thumbnail_id'] );echo'<p>Thumbnail set</p>';}

                $wpdb->query('UPDATE '.CA_FIL_TBL.' SET postID="'.$postID.'"');
                if(defined('CA_DEBUG') )church_admin_debug( $wpdb->last_query);
            }
            if(defined('CA_DEBUG') )church_admin_debug('UPDATE xml feed');
            ca_podcast_xml();//update podcast feed
            if(defined('CA_DEBUG') )church_admin_debug('XML feed update finished');
            if(defined('CA_DEBUG') )church_admin_debug('Update last sermon series preached');
            church_admin_update_last_sermon_series();
            if ( empty( $message) )$message="";
            echo'<div class="notice notice-success inline"><p>'.__('File','church-admin').' '.esc_html( $file_name).' '.__('Saved','church-admin').'</p>'.$message.'</div>';
            ca_podcast_list_files();
        }
    }
    else
    {
        if ( empty( $data) )$data=NULL;
        church_admin_sermon_form( $data,NULL);
    }
}
    
function church_admin_sermon_form( $current_data,$errors)    
{
    global $wpdb;
    if ( empty( $current_data) &&!empty( $_POST) )$current_data=$_POST;
    if(!empty( $errors) )
    {
        echo'<h3 style="color:red">'.__('There were some errors','church-admin').'</h2><p style="color:red">';
        foreach( $errors AS $item=>$error)echo $error.'<br />';
        echo'</p>';
    }
    
    //Show max file upload size
    $max_upload = (int)(ini_get('upload_max_filesize') );
    $max_post = (int)(ini_get('post_max_size') );
    $memory_limit = (int)(ini_get('memory_limit') );
    $upload_mb = min( $max_upload, $max_post, $memory_limit);
    echo'<p>'.sprintf(__('You can upload a file up to %1$sMB','church-admin'),$upload_mb).'</p>';
    echo'<form action="" method="POST"  enctype="multipart/form-data" id="churchAdminForm">';
    echo'<table class="form-table"><tbody>';
    //Sermon Title
    echo'<tr><th scope="row">'.__('Sermon Title','church-admin').'</th><td><input type="text" required="required" name="file_title" id="file_title" ';
    if(!empty( $errors['file_title'] ) ) echo 'style="border:1px red solid"';
    if(!empty( $current_data->file_title) ) echo 'value="'.esc_html( $current_data->file_title).'"';
    echo'/></td></tr>';
    //Sub Title
    echo'<tr><th scope="row">'.__('Sub Title (a few words)','church-admin').'</th><td><input type="text" name="file_subtitle" id="file_subtitle" ';
    if(!empty( $current_data->file_subtitle) ) echo 'value="'.esc_html( $current_data->file_subtitle).'"';
    echo'/></td></tr>';
    //Description
    echo'<tr><th scope="row">'.__('File Description','church-admin').'</th><td>';
    echo '<textarea name="file_description">';
    if(!empty( $current_data->file_description) ) echo esc_textarea( $current_data->file_description );
    echo'</textarea></td></tr>';
    //Bible passages
    echo'<tr><th scope="row">'.__('Scripture passage','church-admin').'</th><td><input type="text" name="passages" class="large-text" placeholder="'.__('Bible passages','church-admin').'" ';
    if(!empty( $current_data->bible_texts) ) echo 'value="'.esc_html( $current_data->bible_texts).'" ';
    echo '</td></tr>';
    //Logged in only
    echo'<tr><th scope="row">'.__('Logged in only','church-admin').'?</th><td><input type="checkbox" name="private" ';
    if(!empty( $current_data->private) )echo ' checked="checked" ';
    echo'value="yes"/></td></tr>';
    //sermon series
    $series_res=$wpdb->get_results('SELECT * FROM '.CA_SERM_TBL.' ORDER BY series_id DESC');
    if( $series_res)
    {
        $first='<option value="">'.__('Choose a sermon series...','church-admin').'</option>';
        echo'<tr><th scope="row">'.__('Sermon Series','church-admin').'</th><td><select name="series_id">';
        $first=$option='';
        foreach( $series_res AS $series_row)
        {
            if(!empty( $series_row->series_id)&&!empty( $current_data->series_id)&&$series_row->series_id==$current_data->series_id)
            {
               $first='<option value="'.intval( $series_row->series_id).'" selected="selected">'.esc_html( $series_row->series_name).'</option>';
            }
            else
            {
                $option.='<option value="'.intval( $series_row->series_id).'">'.esc_html( $series_row->series_name).'</option>';
            }

        }
        echo $first.$option.'</select></td></tr>';
    }
    echo'<tr><th scope="row">'.__('Create a new sermon series','church-admin').'</th><td><input type="text" name="sermon_series"/></td></tr>';
    //service
    $service_res=$wpdb->get_results('SELECT CONCAT_WS(" ",service_name,service_time) AS service_name,service_id FROM '.CA_SER_TBL.' ORDER BY service_id DESC');
    if( $service_res)
    {
        echo'<tr><th scope="row">'.__('Service','church-admin').'</th><td><select name="service_id">';
        $service_id=!(empty($current_date->service_id))?$current_date->service_id:null;
        foreach( $service_res AS $service_row)
        {
                echo'<option value="'.(int) $service_row->service_id.'" '.selected($service_row->service_id,$service_id,false).'>'.esc_html( $service_row->service_name).'</option>';

        }
       '</select></td></tr>';
    }
    echo'<tr><th scope="row">'.__('Speaker','church-admin').'</th><td>';
    $s=array();
    $speaker=NULL;
    if(!empty( $current_data->speaker) )  {$speaker=$current_data->speaker;}
    echo church_admin_autocomplete('speaker','friends','to',$speaker);
    echo'</td></tr>';
    $pub_date=date('Y-m-d');
    $current_time=date('H:i:s');
    
    if(!empty( $current_data->pub_date) )
    {
        //make sure only date component passed to date picker!
        $current_time=mysql2date('H:i:s',$current_data->pub_date);
        $pub_date=date('Y-m-d',strtotime( $current_data->pub_date) );
    }
    //javascript to bring up date picker
    echo'<tr><th scope="row">'.__('Publication Date','church-admin').'</th><td>'.church_admin_date_picker( $pub_date,'pub_date',FALSE,date('Y-m-d',strtotime("-15 years") ),NULL,'pub_date','pub_date',FALSE).'</td></tr>';
    echo '<tr><th scope="row">'.__('Publication Time','church-admin').'</th><td><input type="time" name="pub_time"';
    echo ' value="'.mysql2date('H:i:s',$current_time).'" ';
    echo'/></td></tr>';
    //file name

    echo'<tr><th scope="row">'.__('Audio Mp3/M4a File','church-admin').'</th><td>';
    if(!empty( $current_data->file_name) )  {
        echo esc_html( sprintf( __( 'Keep file (%1$s) or change.', 'church-admin' ),$current_data->file_name) ).'<br/>';
        
        echo'<input type="hidden" name="file_name" value="'. esc_attr( $current_data->file_name ) .'"/>';
    }
    echo'<input type="file" name="file" id="file"/></td></tr>';

  

    //external file
    echo'<tr><th scope="row">'.__('External Audio mp3/M4a URL','church-admin').'</th><td><input type="text" name="audio_url" id="audio_url"';
    if(!empty( $errors['audio_url'] ) ) echo 'style="border:1px red solid"';
    if(!empty( $current_data->external_file) )echo' value="'.esc_url( $current_data->external_file).'" ';
    echo'/>';
    echo'<input Type="hidden" name="external_duration" id="external_duration" ';
    if( !empty( $current_data->length ) )echo' value="'.esc_attr($current_data->length).'"';
    echo '/></td></tr>';
    //javascript to detect length of external audio
    echo'<script>
    jQuery(document).ready(function($){
        $("#audio_url").change(function(){

            var url=$(this).val();
            console.log(url);
            var au = document.createElement("audio");

            // Define the URL of the MP3 audio file
            au.src = url;

            // Once the metadata has been loaded, display the duration in the console
            au.addEventListener("loadedmetadata", function(){
                    
                    var duration = parseInt(au.duration);
                    //convert to ISO format
                    var date = new Date(null);
                    date.setSeconds(duration); 
                    var hhmmssFormat = date.toISOString().substr(11, 8);
                    console.log("External duration is "+ hhmmssFormat);
                    $("#external_duration").val(hhmmssFormat);
                },false);
            })

    });
    
    </script>';

    //embed code
    echo'<tr><th scope="row">'.__('Embed code','church-admin').'</th><td><input type="text" name="embed_code" id="embed_code"';
    if(!empty( $errors['embed_code'] ) ) echo 'style="border:1px red solid"';
    if(!empty( $current_data->embed_code) )echo' value="'.esc_url( $current_data->embed_code).'" ';
    echo'/></td></tr>';

    echo'<tr><th scope="row">'.__('Video "Share" URL (YouTube, Vimeo or Facebook)','church-admin').'</th><td><input type="text" name="video_url" id="video_url"';
    if(!empty( $errors['video_url'] ) ) echo 'style="border:1px red solid"';
    if(!empty( $current_data->video_url) )echo' value="'.esc_url( $current_data->video_url).'" ';
    echo'/></td></tr>';
    if ( empty( $current_data->postID) )  {
    echo'<tr><th scope="row">'.__('Blog the sermon','church-admin').'</th><td><input type="checkbox"  name="blog" value="1"/></td></tr>';}
    else 
    {
        echo'<tr><th scope="row">'.__('Sermon already posted','church-admin').'</th><td>'.esc_html(get_the_title( $current_data->postID) ).'</td></tr>';
    }
    $mailchimp=get_option('church_admin_mailchimp_settings');
    if ( empty( $current_data)||(!empty( $current_data->email_sent)&&$current_data->email_sent=="0000-00-00") )	echo'<tr><th scope="row">'.__('Email the sermon using mailchimp','church-admin').'</th><td><input type="checkbox"  name="email_send" value="1"/></td></tr>';
    echo'<tr><th scope="row">'.__('Notes/Transcript','church-admin').'</th><td>';
    if ( empty( $current_data->transcript) )  {$transcript='';}else{$transcript=$current_data->transcript;}
    wp_editor( $transcript, 'transcript' );
    echo'</td></tr>';
    echo '<tr><th scope="row">&nbsp;</th><td><input type="hidden" name="save_file" value="save_file"/>'.wp_nonce_field('upload_mp3','nonce',TRUE,FALSE).'<input type="submit"  class="button-primary" id="submit" class="button-primary" value="Save File"/></td></tr></tbody></table></form>';
}




/**********************************************
*
* migrate advanced sermons
*
***********************************************/
function church_admin_migrate_advanced_sermons()
{
    global $wpdb;
    echo'<h2>'.__('Migrate from "Advanced Sermons" plugin','church-admin').'</h2>';
    $sermons=$wpdb->get_results('SELECT * FROM '.$wpdb->posts.' WHERE post_type="sermons" AND post_status="publish" ORDER BY post_date DESC');
    if (empty( $sermons) )return __('No advanced sermons plugins sermons to import','church-admin');
    $total=$wpdb->num_rows;
    echo'<div class="notice notice-info inline"><h2>'.sprintf(__('%1$s possible sermon record(s) to import found','church-admin'),$total).'</h2></div>';
    $count=0;
    foreach( $sermons AS $sermon)
    {
        $title  = $sermon->post_title;
        $file_slug=sanitize_title( $sermon->post_title);
        $file_description=$sermon->post_content;
        $date   = $sermon->post_date;
        $series=wp_get_post_terms( $sermon->ID, 'sermon_series', array("fields" => "all") );
        
        if ( empty( $series->errors) )
        {
            $series_name=$series[0]->name;
            $series_slug=$series[0]->slug;
            
        }
        $speakerData =  wp_get_post_terms( $sermon->ID, 'sermon_speaker', array("fields" => "all") ); 
        if ( empty( $speakerData->errors) )
        {
            $speaker=$speakerData[0]->name;
        }
        $vimeo = get_post_meta( $sermon->ID,'asp_sermon_vimeo',TRUE);
        $youtube =  get_post_meta( $sermon->ID,'asp_sermon_youtube',TRUE);
        $fileURL = get_post_meta( $sermon->ID,'asp_sermon_mp4',TRUE);
        $passage =  get_post_meta( $sermon->ID,'asp_sermon_bible_passage',TRUE);
        if(!empty( $title)&& !empty( $speaker) && !empty( $fileURL) )
        {
            //check and update sermon series
            $series_id=$wpdb->get_var('SELECT series_id FROM '.CA_SERM_TBL.' WHERE series_name="'.esc_sql( $series_name).'"');
            if ( empty( $series_id) )
            {
                $wpdb->query('INSERT INTO '.CA_SERM_TBL.' (series_name,series_slug)VALUES("'.esc_sql( $series_name).'","'.esc_sql( $series_slug).'")');
                
                $series_id=$wpdb->insert_id;
            }

            
            //check if there is a youtube/vimeo and update $video
            $sermonVideo='';
            if(!empty( $vimeo) )$sermonVideo=$vimeo;
            if(!empty( $youtube) )$sermonVideo=$youtube;
            //check if already in sermons table
            $sermon_id=$wpdb->get_var('SELECT file_id FROM '.CA_FIL_TBL.' WHERE file_title="'.esc_sql( $title).'" AND file_description="'.esc_sql( $file_description).'" AND file_slug="'.esc_sql( $file_slug).'" AND bible_texts="'.esc_sql( $passage).'" AND series_id="'.(int)$series_id.'" AND pub_date="'.esc_sql( $date).'" AND speaker="'.esc_sql( $speaker).'" AND video_url="'.esc_sql( $sermonVideo).'" AND external_file="'.esc_sql( $fileURL).'"');
            if ( empty( $sermon_id) )
            {
                $wpdb->query('INSERT INTO '.CA_FIL_TBL.' (file_title,file_description,file_slug,bible_texts,series_id,pub_date,last_modified,speaker,video_url,external_file)VALUES("'.esc_sql( $title).'","'.esc_sql( $file_description).'","'.esc_sql( $file_slug).'","'.esc_sql( $passage).'","'.(int)$series_id.'","'.esc_sql( $date).'","'.esc_sql( $date).'","'.esc_sql( $speaker).'","'.esc_sql( $sermonVideo).'","'.esc_sql( $fileURL).'")');
            $count++;
                $file_id=$wpdb->insert_id;
                $wpdb->query('UPDATE '.CA_SERM_TBL.' SET last_sermon="'.esc_sql( $date).'" WHERE series_id="'.(int)$series_id.'"');
            }
            //show message
            echo '<p> Sermon "'.esc_html( $title).'" preached by '.esc_html( $speaker).' on  '.mysql2date(get_option('date_format'),$date).' imported</p>';
        }else
        {
            echo'<p>'.sprintf(__('Not enough data found to import for this record ID: %1$s','church-admin'),$sermon->ID).'</p>';
            
        }
    }
    //show completion message
    echo'<div class="notice notice-success"><h2>'.sprintf(__('%1$s sermons out of %2$s successfully imported','church-admin'),(int)$count,(int)$total).'</h2></div>';
    
}
/**********************************************
*
* migrate sermon manager
*
***********************************************/
function church_admin_migrate_sermon_manager()
{
	global $wpdb;
    $wpdb->show_errors;
	

	
	
		$upload_dir = wp_upload_dir();
		$path=$upload_dir['basedir'].'/sermons/';
		$results=$wpdb->get_results('SELECT * FROM '.$wpdb->posts.' WHERE post_type="wpfc_sermon" ');
		$wpdb->query('INSERT INTO '.CA_SERM_TBL.' (series_name) VALUES("'.__('Non series sermon','church-admin').'")');
		$defaultSeriesID=$wpdb->insert_id;
        if(!empty( $results) )
		{
			foreach( $results AS $row)
			{
				$series_id=$defaultSeriesID;
                $series=$preacher='';
                $post_meta=get_post_meta( $row->ID);
				if(!empty( $post_meta['sermon_audio'] ) )
				{
					$title=$row->post_title;
					$pub_date=date('Y-m-d H:i:s',$post_meta['sermon_date'][0] );
					$data=explode("|",$row->post_content);
                    $series=$preacher='';
					if(!empty( $data)&&is_array( $data) )
                    {
                        $preacher=explode(':',str_replace(" ","",$data[0] ) );
                        if(!empty( $preacher[1] ) )echo'<p><strong>'.esc_html( $title .'('.$preacher[1].')').'</strong></p>';
                        $preacher=trim(preg_replace('/(?<!\ )[A-Z]/', ' $0', $preacher[1] ) );
                    }
					if(!empty( $data)&&is_array( $data)&&!empty( $data[1] ) )
                    {
                        $series=explode(':',str_replace(" ","",$data[1] ) );
                        $seriesLongForm=trim(preg_replace('/(?<!\ )[A-Z]/', ' $0', $series[1] ) );
                        $seriesShort=explode("\n",$seriesLongForm);
                        $series=$seriesShort[0];
                    }

					echo'<p>Series - '.$series.'</p>';
                    if(!empty( $series) )
				    {
				        $series_id=$wpdb->get_var('SELECT series_id FROM '.CA_SERM_TBL.' WHERE series_name="'.esc_sql( $series).'"');
						if(!empty( $series_is) )echo"Found series_id - $series_id</p>";
                        if ( empty( $series_id) )
							{
								$sql='INSERT INTO '.CA_SERM_TBL.' (series_name) VALUES("'.esc_sql( $series).'")';
                                $wpdb->query( $sql);
								$series_id=$wpdb->insert_id;
                                
							}
				    }
                    echo'<p>Preacher- '.$preacher.'</p>';
                    $pub_date=$row->post_date;
					$fileURL=$post_meta['sermon_audio'][0];
					$fileParts=explode('sermons',$fileURL);
					$filename=end( $fileParts);
					if(file_exists( $path.$filename) )
					{
						
                        //from 3.6.20 use WordPress native function
                        
                    $sanitizedFilename=sanitize_file_name( $filename);
                        $audiometadata=wp_read_audio_metadata( $path.$sanitizedFilename );
                        $length=!empty( $audiometadata['length_formatted'] )?$audiometadata['length_formatted']:null;
					
						
					
						
						$file_id=$wpdb->get_var('SELECT file_id FROM '.CA_FIL_TBL.' WHERE file_title="'.esc_sql( $title).'" AND file_name="'.esc_sql( $filename).'"');
						if ( empty( $file_id) )
						{
							$wpdb->query('INSERT INTO '.CA_FIL_TBL.' (file_title,file_name,speaker,service_id,series_id,length,pub_date) VALUES ("'.esc_sql( $title).'","'.esc_sql( $filename).'","'.esc_sql( $preacher).'","1","'.(int)$series_id.'","'.$length.'","'.esc_sql( $pub_date).'")');
                            
							$wpdb->query('UPDATE '.CA_SERM_TBL.' SET last_sermon="'.esc_sql( $pub_date).'" WHERE series_id="'.(int)$series_id.'"');
                            
							echo'<p>'.__('File added','church-admin').'</p>';
						}else{echo'<p>'.__('File already in Church Admin sermons','church-admin').'</p>';}
					}//file exists
					else{echo'<p>'.__("Can't find sermon file",'church-admin').'</p>';}
				}
			}
			
		}else{echo'<div class="notice notice-warning"><h2>'.__('No sermons found to import','church-admin').'</h2></div>';}


}
/**********************************************
*
* migrate sermon browser
*
***********************************************/
function church_admin_migrate_sermon_browser()
{
    global $wpdb;
    $upload_dir = wp_upload_dir();
	$sermon_path=$upload_dir['basedir'].'/sermons/';
	$sermon_url=content_url().'/uploads/sermons/';
   
    
    $sql='SELECT a.*,b.name AS preacher_name,c.name AS series_name,d.name AS file_name,d.duration AS duration, d.count AS count  FROM '.$wpdb->prefix.'sb_sermons a, '.$wpdb->prefix.'sb_preachers b,'.$wpdb->prefix.'sb_series c,'.$wpdb->prefix.'sb_stuff d WHERE a.preacher_id=b.id AND a.series_id=c.id AND a.id=d.sermon_id ORDER BY a.`datetime` DESC';
    $results=$wpdb->get_results( $sql);
    if(!empty( $results) )
    {
        echo'<h2>'.__('Sermon Browser file adding to Church Admin started','church-admin').'</h2>';
        foreach( $results AS $row)
        {
            
            if(file_exists( $sermon_path.$row->file_name) )
            {
               
                //get passage
                $start=$wpdb->get_row('SELECT * FROM '.$wpdb->prefix.'sb_books_sermons WHERE sermon_id="'.(int)$row->id.'" AND type="start" LIMIT 1');
                $end=$wpdb->get_row('SELECT * FROM '.$wpdb->prefix.'sb_books_sermons WHERE sermon_id="'.(int)$row->id.'" AND type="end" LIMIT 1');
                if(!empty( $start)&&!empty( $end) )
                {
                    if( $start->book_name==$end->book_name&& $start->chapter=$end->chapter)$passage=$start->book_name.' '.$start->chapter.':'.$start->verse.'-'.$end->verse;
                    elseif( $start->book_name==$end->book_name&& $start->chapter=$end->chapter)$passage=$start->book_name.' '.$start->chapter.':'.$start->verse.'-'.$end->chapter.':'.$end->verse;
                    else{$passage=$start->book_name.' '.$start->chapter.':'.$start->verse.'-'.$end->book_name.' '.$end->chapter.':'.$end->verse;}
                }else{$passage='';}
                //check series id
                $new_series_id=$wpdb->get_var('SELECT series_id FROM '.CA_SERM_TBL.' WHERE series_name="'.esc_sql( $row->series_name).'"');
                if ( empty( $new_series_id) )
                {
                    $series_slug=sanitize_title( $row->series_name);
                    $wpdb->query('INSERT INTO '.CA_SERM_TBL.' (series_name,series_slug,last_sermon)VALUES("'.esc_sql( $row->series_name).'","'.esc_sql( $series_slug).'","'.esc_sql( $row->datetime).'")');
                    $new_series_id=$wpdb->last_insert_id;
                }
                //check not already added
                $sermon_id=$wpdb->get_var('SELECT file_id FROM '.CA_FIL_TBL.' WHERE file_name="'.esc_sql( $row->file_name).'"');
                
                if ( empty( $sermon_id) )
                {
                    $file_slug=sanitize_title( $row->title);
                    $wpdb->query('INSERT INTO '.CA_FIL_TBL.' (file_name,file_title,pub_date,series_id,speaker, plays,length,file_slug,bible_texts)VALUES("'.esc_sql( $row->file_name).'","'.esc_sql( $row->title).'","'.esc_sql( $row->datetime).'","'.(int)$new_series_id.'","'.esc_sql( $row->preacher_name).'","'.(int)$row->count.'","'.esc_sql( $row->duration).'","'.esc_sql( $file_slug).'","'.esc_sql( $passage).'")');
                    echo '<p>'.esc_html(sprintf(__('%1$s preached by %2$s on %3$s added','church-admin'),$row->preacher_name,$row->preacher_name,mysql2date(get_option('date_format').' '.get_option('time_format'),$row->datetime) )).'</p>';
                } else{echo '<p>'.esc_html(sprintf(__('%1$s preached by %2$s on %3$s already added','church-admin'),$row->title,$row->preacher_name,mysql2date(get_option('date_format').' '.get_option('time_format'),$row->datetime) )).'</p>'; }
            }

        }
        echo'<div class="notice"><h2>'.__('Sermon Browser files migrated','church-admin').'</h2></div>';
    }
    else
    {
        echo'<div class="notice"><h2>'.__('No Sermon Browser plugin entries detected','church-admin').'</h2></div>';
    }

}

/**********************************************
*
*   Podcast Settings
*
***********************************************/
function ca_podcast_xml()
{
    global $wpdb,$ca_podcast_settings;
    $settings=get_option('ca_podcast_settings');
	$upload_dir = wp_upload_dir();
	$path=$upload_dir['basedir'].'/sermons/';
	$sermonFilesDirURL=content_url().'/uploads/sermons/';
    $results=$wpdb->get_results('SELECT DATE_FORMAT(a.pub_date,"%a, %d %b %Y %T") AS publ_date,a.*,c.series_name AS series_name FROM '. CA_FIL_TBL.' a, '.CA_SERM_TBL.' c WHERE a.private="0" AND a.series_id=c.series_id ORDER BY pub_date DESC');
    church_Admin_debug( $wpdb->last_query);
    if(!empty( $results)&&!empty( $settings['title'] ) )
    {

        //CONSTRUCT RSS FEED HEADERS
        $output = '<rss xmlns:itunes="http://www.itunes.com/dtds/podcast-1.0.dtd" version="2.0">';
        $output .= '<channel>';
        $output .= '<title>'.htmlspecialchars( $settings['title'], ENT_XML1, 'UTF-8').'</title>';
        $output .= '<link>'.htmlspecialchars(site_url(), ENT_XML1, 'UTF-8').'</link>';
        $output .= '<language>'.htmlspecialchars( $settings['language'], ENT_XML1, 'UTF-8').'</language>';
        $output .= '<copyright>&#x2117; &amp; &#xA9; '.date('Y').' '.htmlspecialchars( $settings['copyright'], ENT_XML1, 'UTF-8').'</copyright>';
        $output .= '<itunes:type>episodic</itunes:type>';
        $output .= '<itunes:subtitle>'.htmlspecialchars( $settings['subtitle'] ).'</itunes:subtitle>';
        $output .= '<itunes:author>'.htmlspecialchars( $settings['author'], ENT_XML1, 'UTF-8').'</itunes:author>';
        $output .= '<itunes:summary>'.htmlspecialchars( $settings['summary'], ENT_XML1, 'UTF-8').'</itunes:summary>';
        $output .= '<description>'.htmlspecialchars( $settings['description'], ENT_XML1, 'UTF-8').'</description>';
        $output .= '<itunes:owner>';
        if(!empty( $settings['owner_name'] ) )$output .= '<itunes:name>'.htmlspecialchars( $settings['owner_name'], ENT_XML1, 'UTF-8').'</itunes:name>';
        if(!empty( $settings['owner_email'] )&&is_email( $settings['owner_email'] ) )$output .= '<itunes:email>'.$settings['owner_email'].'</itunes:email>';
        $output .= '</itunes:owner>';
        $output .= '<itunes:explicit>'.htmlspecialchars( $settings['explicit'], ENT_XML1, 'UTF-8').'</itunes:explicit>';

        $output .='<itunes:image href="'.htmlspecialchars( $settings['image'], ENT_XML1, 'UTF-8').'" />';
        if(!empty( $settings['category'] ) )
        {
            $cat=explode("-",$settings['category'] );
            
            if(count( $cat)==2)  {$output .='<itunes:category text="'.trim(htmlspecialchars( $cat[0], ENT_XML1, 'UTF-8') ).'"><itunes:category text="'.htmlspecialchars( $cat[1], ENT_XML1, 'UTF-8').'"/></itunes:category>';}
            elseif(count( $cat)==1)  {$output .='<itunes:category text="'.trim(htmlspecialchars( $cat[0], ENT_XML1, 'UTF-8') ).'"/>';}

        }
        $output=str_replace('&amp;amp;','&amp;',$output);//fix double escape
        

        $sermonPageURL=rtrim(church_admin_find_sermon_page(),"/");
        //BODY OF RSS FEED
        foreach( $results AS $row)
        {
             
            $sermonDetailURL=esc_url( $sermonPageURL.'?sermon='.$row->file_slug);
            if(!empty( $row->file_name)||!empty( $row->external_file) )
            {
                //get speakers

                $names=!empty( $row->speaker)?church_admin_get_people( $row->speaker):__('Preacher','church-admin');
                $subtitle=!empty( $row->file_subtitle)?$row->file_subtitle:$row->file_subtitle;
                //end get speakers
                $service=$wpdb->get_var('SELECT CONCAT_WS(" ",service_name,service_time) FROM '.CA_SER_TBL.' WHERE service_id="'.esc_sql( $row->service_id).'"');
                $output .= '<item>';
                $output .= '<title>'.htmlspecialchars( $row->file_title, ENT_XML1, 'UTF-8').'</title>';
                $output .= '<itunes:title>'.htmlspecialchars( $row->file_title, ENT_XML1, 'UTF-8').'</itunes:title>';
                $output .= '<description>'.htmlspecialchars( $row->file_description, ENT_XML1, 'UTF-8').'</description>';
                $output .= '<itunes:author>'.htmlspecialchars( $names, ENT_XML1, 'UTF-8').'</itunes:author>';
                $output .= '<itunes:subtitle>'.htmlspecialchars( $subtitle, ENT_XML1, 'UTF-8').'</itunes:subtitle>';
                $output .= '<itunes:summary>'.htmlspecialchars( $row->file_description, ENT_XML1, 'UTF-8').'</itunes:summary>';
                $output .= '<link>'.$sermonDetailURL.'</link>';
                if(!empty( $row->file_name) && file_exists( $path.$row->file_name) )
                {
                    $output .= '<enclosure url="'.htmlspecialchars( $sermonFilesDirURL.$row->file_name, ENT_XML1, 'UTF-8').'" length="'.filesize( $path.$row->file_name).'" type="audio/mpeg" />';
                    $output .= '<guid>'.htmlspecialchars( $sermonFilesDirURL.$row->file_name, ENT_XML1, 'UTF-8').'</guid>';
                }
                else
                {
                    $output .= '<enclosure url="'.htmlspecialchars( $row->external_file, ENT_XML1, 'UTF-8').'" length="" type="audio/mpeg" />';
                    $output .= '<guid>'.htmlspecialchars( $row->external_file, ENT_XML1, 'UTF-8').'</guid>';
                }

                $output .= '<pubDate>'.htmlspecialchars( $row->publ_date.' '.date('O'), ENT_XML1, 'UTF-8').'</pubDate>';
                $output .= '<itunes:duration>'.htmlspecialchars( $row->length, ENT_XML1, 'UTF-8').'</itunes:duration>';
                //$output .= '<itunes:keywords></itunes:keywords>';
                $output .= '</item>'."\r\n";
            }
        }
        //CLOSE RSS FEED
        $output .= '</channel>';
        $output .= '</rss>';

        //SEND COMPLETE RSS FEED TO podcast xml file
        $fp = fopen( $path.'podcast.xml', 'w');
        fwrite( $fp, $output);
        fclose( $fp);
        return TRUE;
    }//end results
    else
    {
        if(file_exists( $path.'podcast.xml') )unlink( $path.'podcast.xml');
    }
}

function church_admin_handle_podcast_image( $settings)
{
	if ( empty( $settings['thumbnail_id'] )&&!empty( $settings['image'] ) )
			{
				$path = parse_url( $settings['image'] );
				$image=$_SERVER['DOCUMENT_ROOT'] . $path['path'];

				$filetype = wp_check_filetype( basename( $image), null );
				$filetitle = preg_replace('/\.[^.]+$/', '', basename( $image) );
				$filename = $filetitle . '.' . $filetype['ext'];
				$upload_dir = wp_upload_dir();
				/**
				* Check if the filename already exist in the directory and rename the
				* file if necessary
				*/
				$i = 0;
				while ( file_exists( $upload_dir['path'] .'/' . $filename ) )
				{
					$filename = $filetitle . '_' . $i . '.' . $filetype['ext'];
					$i++;
				}
				$filedest = $upload_dir['path'] . '/' . $filename;

				if(file_exists( $image) )
				{
					copy( $image, $filedest);
					$attachment = array('post_mime_type' => $filetype['type'],'post_title' => $filetitle,'post_content' => '','post_status' => 'inherit');
					$attachment_id = wp_insert_attachment( $attachment, $filedest );
					$settings['thumbnail_id']=$attachment_id;
					update_option('ca_podcast_settings',$settings);
					require_once( ABSPATH . "wp-admin" . '/includes/image.php' );
					$attach_data = wp_generate_attachment_metadata( $attachment_id, $filedest );
					wp_update_attachment_metadata( $attachment_id,  $attach_data );
				}
			}
			return $settings;
}

function church_admin_update_last_sermon_series()
{
    global $wpdb;
    
    $sql='SELECT MAX(pub_date) AS pub_date,series_id FROM '.CA_FIL_TBL.' GROUP BY series_id';
    $results=$wpdb->get_results( $sql);
    if(!empty( $results) )
    {
        foreach( $results AS $row)$wpdb->query('UPDATE '.CA_SERM_TBL.' SET last_sermon="'.esc_sql( $row->pub_date).'" WHERE series_id="'.(int)$row->series_id.'"');

    }
    
}

function church_admin_set_sermon_page()
{
    
    if(!empty( $_POST['page_id'] ) )
    {
        update_option('church-admin-sermon-page',(int)$_POST['page_id'] );
    }    
    
    $sermonPageID=get_option('church-admin-sermon-page');
    $args=array();
    if(!empty( $sermonPageID) ) $args['selected']= $sermonPageID;
    echo'<h2>'.__('Set which page has your main sermons shortcode/block','church-admin').'</h2>';
    echo'<form action="" method="POST">';
    wp_dropdown_pages( $args);
    echo'<p><input type="hidden" name="save-sermon-page" value="1"/><input type="submit" class="button-primary" value="'.__('Save').'"/>';

}