<?php
if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

/*****************************
*
* Choose filters to show
*
*****************************/
function church_admin_choose_filters()
{
    echo '<h1>'.__("Choose which filters are shown",'church-admin').'</h1>';
    $menuFilters=array('contact-form'=>__('Contact form','church-admin'),'address'=>__('Address','church-admin'),"genders"=>__('Genders','church-admin'),'photo-permission'=>__('Photo permission','church-admin'),'user-accounts'=>__('User accounts','church-admin'),'email-addresses'=>__('Email address','church-admin'),'phone-calls'=>__("Receive phone calls",'church-admin'),'cell'=>__('Cell phone','church-admin'),'classes'=>__('Classes','church-admin'),'gdpr'=>__('Data protection confirmed','church-admin'),'people_types'=>__('People types','church-admin'),'active'=>__('Active','church-admin'),'marital'=>__('Marital Status','church-admin'),'sites'=>__('Sites','church-admin'),'member_types'=>__('Member Types','church-admin'),'small-groups'=>__('Small groups','church-admin'),'ministries'=>__('Ministries','church-admin'),'birth-year'=>__('Birth year','church-admin'),'birth-month'=>__('Birth month','church-admin'),'parents'=>__('Parents','church-admin'),'spiritual-gifts'=>__('Spiritual gifts','church-admin'),'email-send'=>__('Email Permission','church-admin') );

    //add on custom fields
    $customFields=church_admin_get_custom_fields();
	
    if(!empty( $customFields) )
    {
        foreach ( $customFields AS $ID=>$field)
        {
            $menuFilters[sanitize_title( $field['name'] )]=$field['name'];
        }
    }
    if(!empty( $_POST['save-filters'] ) )
    {
        $chosenFilters=array();
        foreach ( $menuFilters AS $ID=>$field)
		{
            if(!empty( $_POST[$ID] ) )$chosenFilters[$ID]=TRUE;
        }
        update_option('church-admin-which-filters',$chosenFilters);
        echo'<div class="notice notice-success inline"><h2>'.__("Filter choice saved",'church-admin').'</h2></div>';
    }
	$whichFilters=get_option("church-admin-which-filters");
    echo'<form action="" method="POST">';
    echo'<table class="form-table"><tbody>';
    foreach( $menuFilters AS $ID=>$field)
    {
        echo'<tr><th scope="row">'.esc_html( $field).'</th><td><input type="checkbox" name="'.esc_html( $ID).'" ';
        if(!empty( $whichFilters[$ID] ) )echo 'checked="checked" ';
        echo' value=1/></td></tr>';
    }
    echo'<tr><td colspan=2><input type="hidden" name="save-filters" value="TRUE"/><input type="Submit" class="button-primary" value="'.__('Save','church-admin').'"/></td></tr></table>';

    
    
}
/**
 * This function sets up which modules are displayed on the tabs, default on install is all displayed
 *
 * Author:     Andy Moyle
 * Author URI: http://www.churchadminplugin.com
 *
 *
 *	2017-01-02 Improved display, using translated strings
 *
 */
function church_admin_modules()
{
	$modules=get_option('church_admin_modules');
	ksort($modules);
	if(!empty( $_POST['save-ca-modules'] ) )
	{

		foreach( $modules AS $mod=>$status)
		{
			if ( empty( $_POST[$mod] ) )  {$modules[$mod]=FALSE;}else {$modules[$mod]=TRUE;}
		}

		update_option('church_admin_modules',$modules);
        echo '<div class="notice notice-success inline"><h2>'.__('Modules updated - refresh page to show changes in menu').'</h2></div>';
	}

		echo'<h1 class="modules">'.__('Set which module tabs are visible ','church-admin').'</h1>';
		echo'<form action="" method="POST">';
		echo'<table class="form-table"><tbody>';
		$toggle=TRUE;
		foreach( $modules AS $mod=>$status)
		{
			//Need to be translateable, so used stored data and convert to translated display string
			switch( $mod)
			{
				case 'Support':$display=__('Support Church Admin','church-admin');break;
				case'Contact':$display=__('Contact','church-admin');break;
				case'People':$display=__('People','church-admin');break;
				case'Rota':$display=__('Rota','church-admin');break;
				case'Children':$display=__('Children','church-admin');break;
				case'Comms':$display=__('Comms','church-admin');break;
				case'Groups':$display=__('Groups','church-admin');break;
				case'Calendar':$display=__('Calendar','church-admin');break;
                case'Giving':$display=__('Giving','church-admin');break;
				case'Media':$display=__('Media','church-admin');break;
				case'Facilities':$display=__('Facilities','church-admin');break;
				case'Ministries':$display=__('Ministries','church-admin');break;
				case'Services':$display=__('Services','church-admin');break;
				case'Sessions':$display=__('Sessions','church-admin');break;
				case'Classes':$display=__('Classes','church-admin');break; //Added by Jostein 3.04.2019
				case'Attendance':$display=__('Attendance','church-admin');break; //Added by Jostein 3.04.2019
				case'Units':$display=__('Units','church-admin');break;
                case "Events": $display=__('Events','church-admin');break;
				default:$display=$mod;break;
			}
			if( $mod!='Podcast' && $mod!='App')
			{
				echo'<tr>';
				echo'<th scope="row">'.esc_html( $display).'</th><td><input type="checkbox" value="TRUE" name="'.esc_html( $mod).'" ';
				if(!empty( $status) ) echo' checked="checked" ';
				echo' /></td>';
				echo'</tr>';
			}
		}

		echo'<tr><th scope="row">&nbsp;</th><td><input type="hidden" name="save-ca-modules" value="TRUE"/><input type="submit" value="'.__('Save','church-admin').'" class="button-primary"/></td></tr>';
		echo'</tbody></table></form>';
	
}

/**
 * This function is for email settings
 *
 * Author:     Andy Moyle
 * Author URI: http://www.churchadminplugin.com
 *
 *
 */

function church_admin_email_settings()
{
	if(!church_admin_level_check('Email') )return __("You don't have permission to change email settings",'church-admin');
	if(!empty( $_POST['save-email-settings'] ) )
	{
		
		/***************************
		 * METHOD
		 ****************************/
		switch( $_POST['email-method'] )
		{
			case 'website':update_option('church_admin_email_method','native');break;
			case 'smtp-server':update_option('church_admin_email_method','smtp-server');break;
			case 'mailchimp':update_option('church_admin_email_method','mailchimp');break;
		}
		/***************************
		 * CRON
		 ****************************/
		if(!empty( $_POST['quantity'] ) )  {update_option('church_admin_bulk_email',$_POST['quantity'] );}else{delete_option('church_admin_bulk_email');}
		if(!empty( $_POST['cron'] ) )
		{
			$message='';
			update_option('church_admin_cron',$_POST['cron'] );
			switch( $_POST['cron'] )
			{
				case'wp-cron':
								wp_clear_scheduled_hook('church_admin_bulk_email');
								add_action('church_admin_bulk_email','church_admin_bulk_email');
								$timestamp=time();
								wp_schedule_event( $timestamp, 'hourly', 'church_admin_bulk_email');
				break;
				case 'cron':
								wp_clear_scheduled_hook('church_admin_bulk_email');
								$message='<p><a  class="button-secondary"  target="_blank" href="'.site_url().'/?ca_download=cron-instructions&amp;cron-instructions='.wp_create_nonce('cron-instructions').'">'.__('PDF Instructions for email cron setup','church-admin').'</a></p>';
				break;
				default:
								wp_clear_scheduled_hook('church_admin_bulk_email');
								update_option('church_admin_cron','immediate');
	      	    break;
			}
		}
		else{delete_option('church_admin_cron');}
		/***************************
		 * SMTP
		 ****************************/
		$expected=array('host','auth','port','username','password','secure','from','from_name');
		foreach( $expected AS $key=>$value)
		{
			if(!empty( $_POST[$value] ) )  {$settings[$value]=stripslashes( $_POST[$value] );}
		}
		if(!empty( $settings) )
		{
			update_option('church_admin_smtp_settings',$settings);
		}
		else
		{
			delete_option('church_admin_smtp_settings');
			
		}
		echo'<div class="notice notice-success inline"><h2>'.__('Email settings saved','church-admin').'</h2>';
		$email_method=get_option('church_admin_email_method');
		switch( $email_method)
		{
			case 'mailchimp':
				echo '<p><a class="button-secondary" href="admin.php?page=church_admin%2Findex.php&action=sync-mailchimp">'.__('Setup MailChimp','church-admin').'</a></p>';
			break;
			
			default:
				echo '<p><a class="button-secondary"  href="admin.php?page=church_admin%2Findex.php&action=testemail">'.__('Send test email','church-admin').'</a></p>';
			break;
		}
		echo'</div>';
	}
	$email_method=get_option('church_admin_email_method');
	if ( empty( $email_method) )
	{
		//check if MailChimp setup
		$MailChimp=get_option('church_admin_mailchimp');
		$smtp=get_option('church_admin_smtp_settings');
		if(!empty( $mailChimp) )$email_method='mailchimp';
		if(!empty( $smtp) )$email_method='smtpserver';
		if ( empty( $email_method) )$email_method='native';
	}
	
	echo'<h2>'.__('Email Settings in Church Admin Plugin','church-admin').'</h2>';
	$mailChimp=get_option('church_admin_mailchimp');
	if(!empty( $mailChimp) )echo'<p><a  class="button-secondary" href="admin.php?page=church_admin%2Findex.php&action=delete-mailchimp">'.__('Delete MailChimp settings','church-admin').'</a></p>';
	echo'<p><a  class="button-secondary" href="admin.php?page=church_admin%2Findex.php&action=test-email">'.__('Send test email','church-admin').'</a></p>';
	echo'<form action="" method="POST">';
	echo'<div class="church-admin-form-group"><input type="radio" class="email-method" name="email-method" value="website" '.checked('native',$email_method,false).'/><label>'.__('Send using native WordPress email functions','church-admin').'</label></div>';
	echo'<div class="church-admin-form-group"><input type="radio" class="email-method" name="email-method" value="smtp-server" '.checked('smtp-server',$email_method,false).'/><label>'.__('Send using SMTP server','church-admin').'</label></div>';
	echo'<div class="church-admin-form-group"><input type="radio" class="email-method" name="email-method" value="mailchimp" '.checked('mailchimp',$email_method,false).'/><label>'.__('Send using MailChimp','church-admin').'</label></div>';
	/*********************
	* cron settings
	******************/
	$cron=get_option('church_admin_cron');
	$current_cron=!empty( $cron)?$cron:'immediate';
	echo'<div id="email-cron-settings" ';
	if( $email_method=='mailchimp') echo ' style="display:none" ';
	echo'>';
	echo'<h3>'.__('Email Queueing','church-admin').'</h3>';
	echo'<div class="church-admin-form-group"><input type="radio" class="immediate"  name="cron" value="immediate" '.checked( $current_cron,'immediate',false).'/><label>'.__('Send Emails Immediately','church-admin').'('.__("Use this option if your hosting company doesn't limit how many emails you can send an hour",'church-admin').')</label></div>';
	echo'<div class="church-admin-form-group"><input type="radio"  class="cron" name="cron" value="cron" '.checked( $current_cron,'cron',false).'/><label>'.__('I want to use cron','church-admin').'('.__('Use this option if you are on a Linux server and are limited how many emails you can send an hour','church-admin').')</label></div>';
	$cronCommand='<strong>curl --silent '.admin_url().'/admin-ajax.php?action=church_admin_cronemail</strong>';
	echo'<p>'.sprintf(__('Set up a cron job with the command %1$s in your cPanel or hosting account','church-admin'),$cronCommand).'</p>';
	echo'<div class="church-admin-form-group"><input type="radio" class="wp-cron" name="cron" value="wp-cron" '.checked( $current_cron,'wp-cron',FALSE).'/><label>'.__('I want to use wp-cron','church-admin').' ('.__('Use this option if you are on a Windows server and are limited how many emails you can send an hour. It will be set to send a batch every 15 mins.','church-admin').')</label></div>';
	echo '<div class="church-admin-form-group"><label>'.__('Max emails per hour? (required)','church-admin').'</label><input class="church-admin-form-control" type="text" name="quantity" value="'.get_option('church_admin_bulk_email').'"/></div>';
	echo'</div>';
	/***************************
	* SMTP Settings
	****************************/
	$settings=get_option('church_admin_smtp_settings');
	echo'<div id="smtp-settings" ';
	if( $email_method!='smtp-server') echo ' style="display:none" ';
	echo'>';
	echo'<h3>'.__('SMTP settings','church-admin').'</h3>';
	echo'<div class="church-admin-form-group"><label>'.__('SMTP Host','church-admin').'</label><input class="church-admin-form-control" type="text" name="host" placeholder="smtp.gmail.com" ';
	if(!empty( $settings['host'] ) ) echo ' value="'.esc_html( $settings['host'] ).'" ';
	echo'/></div>';
	echo'<div class="church-admin-form-group"><label>'.__('SMTP Authorisation required?','church-admin').'</label><input class="church-admin-form-control"  type="checkbox" name="auth" value="TRUE" ';
	if(!empty( $settings['auth'] ) ) echo ' checked="checked" ';
	echo'/></div>';
	echo'<div class="church-admin-form-group"><label>'.__('SMTP Port','church-admin').'</label><input class="church-admin-form-control"  type="text" name="port" placeholder="465" ';
	if(!empty( $settings['port'] ) ) echo ' value="'.esc_html( $settings['port'] ).'" ';
	echo'/></div>';
	echo'<div class="church-admin-form-group"><label>'.__('SMTP Username','church-admin').'</label><input class="church-admin-form-control"  type="text" name="username" placeholder="yourname@gmail.com" ';
	if(!empty( $settings['username'] ) ) echo ' value="'.esc_html( $settings['username'] ).'" ';
	echo'/></div>';
	echo'<div class="church-admin-form-group"><label>'.__('SMTP Password','church-admin').'</label><input class="church-admin-form-control"  type="text" name="password" placeholder="password" ';
	if(!empty( $settings['password'] ) ) echo ' value="'.esc_html( $settings['password'] ).'" ';
	echo'/></div>';
	echo'<div class="church-admin-form-group"><label>'.__('SMTP Security','church-admin').'</label><select  class="church-admin-form-control"  name="secure"> ';
	if(!empty( $settings['secure'] ) ) echo ' <option value="'.esc_html( $settings['secure'] ).'">'.esc_html( $settings['secure'] ).'</option> ';
	echo'<option value="ssl">SSL</option><option value="tls">TLS</option><option value="">None</option>';
	echo'</select></div>';
	echo'<div class="church-admin-form-group"><label>'.__('SMTP From Email','church-admin').'</label><input class="church-admin-form-control"  type="text" name="from" placeholder="yourname@gmail.com" ';
	if(!empty( $settings['from'] ) ) echo ' value="'.esc_html( $settings['from'] ).'" ';
	echo'/></div>';
	echo'<div class="church-admin-form-group"><label>'.__('SMTP From Name','church-admin').'</label><input class="church-admin-form-control"  type="text" name="from_name" placeholder="'.__('Your name','church-admin').'" ';
	if(!empty( $settings['from_name'] ) ) echo ' value="'.esc_html( $settings['from_name'] ).'" ';
	echo'/></div>';
	echo'</div>';
	echo'<p><input type="hidden" name="save-email-settings" value="1"/><input type="submit" class="button-primary" value="'.__('Save','church-admin').'"/></form>';
	echo'<script>jQuery(document).ready(function( $)  {
		$(".email-method").change(function()  {
			var email_method=$(".email-method:checked").val();
			console.log("Email method" + email_method);
			switch(email_method)
			{
				case "mailchimp":
					$("#smtp-settings").hide();
					$("#email-cron-settings").hide();
				break;
				case "website":
					$("#smtp-settings").hide();
					$("#email-cron-settings").show();
				break;
				case "smtp-server":
					$("#smtp-settings").show();
					$("#email-cron-settings").show();
				break;
			}
		});
	});
	</script>';
}
function church_admin_email_settings_dep()
{
	
	if(!empty( $_POST['save-email-settings'] ) )
	{

		if(!empty( $_POST['quantity'] ) )  {update_option('church_admin_bulk_email',$_POST['quantity'] );}else{delete_option('church_admin_bulk_email');}
		if(!empty( $_POST['cron'] ) )
		{
			$message='';
			update_option('church_admin_cron',$_POST['cron'] );
			switch( $_POST['cron'] )
			{
				case'wp-cron':
								wp_clear_scheduled_hook('church_admin_bulk_email');
								add_action('church_admin_bulk_email','church_admin_bulk_email');
								$timestamp=time();
								wp_schedule_event( $timestamp, 'hourly', 'church_admin_bulk_email');
				break;
				case 'cron':
								wp_clear_scheduled_hook('church_admin_bulk_email');
								$message='<p><a  target="_blank" href="'.site_url().'/?ca_download=cron-instructions&amp;cron-instructions='.wp_create_nonce('cron-instructions').'">'.__('PDF Instructions for email cron setup','church-admin').'</a></p>';
				break;
				default:
								wp_clear_scheduled_hook('church_admin_bulk_email');
								update_option('church_admin_cron','immediate');
	      	    break;
			}
		}
		else{delete_option('church_admin_cron');}
		echo'<div class="notice notice-success inline"><h2>'.__('Email Settings Saved','church-admin').'</h2>'.$message.'</div>';
	
	}

		echo'<h1>'.__('Email Settings','church-admin').'</h1>';
		

        echo'<form action="" method="post">';
		echo'<table class="form-table">';
		echo'<tr><th scope="row">'.__('Send Emails Immediately','church-admin').'</th><td><input type="radio" class="immediate"  name="cron" value="immediate" ';
		if (get_option('church_admin_cron')=='immediate') echo 'checked="checked"';
		echo'/> '.__("Use this option if your hosting company doesn't limit how many emails you can send an hour",'church-admin').'</td></tr>';

		echo'<tr><th scope="row">'.__('I want to use cron','church-admin').':</th><td><input type="radio"  class="cron" name="cron" value="cron" ';
        if (get_option('church_admin_cron')=='cron') echo 'checked="checked"';
        echo'/>'.__('Use this option if you are on a Linux server and are limited how many emails you can send an hour','church-admin').'</td></tr>';
		echo'<tr><th scope="row">'.__('I want to use wp-cron:','church-admin').'</th><td><input type="radio" class="wp-cron" name="cron" value="wp-cron"';
        if (get_option('church_admin_cron')=='wp-cron') echo 'checked="checked"';
        echo'/>'.__('Use this option if you are on a Windows server and are limited how many emails you can send an hour','church-admin').'</td></tr>';
		echo '<tr class="limited" style="display:none"><th scope="row">'.__('Max emails per hour? (required)','church-admin').'</th><td><input type="text" name="quantity" value="'.get_option('church_admin_bulk_email').'"/></td></tr></td></tr>';
		echo'<tr><th scope="row">&nbsp;</th><td><input type="hidden" name="save-email-settings" value="TRUE"/><input class="button-primary" type="submit" value="'.__('Save','church-admin').'"/></td></tr>';
		echo'</tbody></table></form>';
		echo'<script>jQuery(document).ready(function( $) {
			$(".email").click(function()  {$(".ca-email").toggle();});
			$(".immediate").click(function()  {$(".limited").hide();});
			$(".cron").click(function()  {$(".limited").show();});
			$(".wp-cron").click(function()  {$(".limited").show();});
		});</script><hr/>';

}

/**
 * This function sets up smtp settings for wp_mail()
 *
 * Author:     Andy Moyle
 * Author URI: http://www.churchadminplugin.com
 *
 *
 */
function church_admin_smtp_settings()
{

	$smtp_display='display:none';
	if(!empty( $_POST['save-smtp-settings'] ) )
	{
		foreach( $_POST AS $key=>$value)
		{
			if(!empty( $_POST[$key] ) )  {$settings[$key]=stripslashes( $value);}
		}
		if(!empty( $settings) )
		{
			update_option('church_admin_smtp_settings',$settings);
			echo'<div class="notice notice-success inline"><p>'.__('SMTP Settings saved','church-admin').'</p></div>';
		}
		else
		{
			delete_option('church_admin_smtp_settings');
			echo'<div class="notice notice-success inline"><p>'.__('SMTP Settings deleted','church-admin').'</p></div>';
		}
		$smtp_display='display:block';
	}

		$settings=get_option('church_admin_smtp_settings');
		echo'<h1>'.__('Use your own smtp server settings for sending email from the website','church-admin').'</h1>';
		echo'<p>'.__('Leave blank and save to delete current settings','church-admin').'</p>';
		echo'<p>'.__('Using these settings changes the way Wordpress sends email across your whole site, to using your smtp server','church-admin').'</p>';
		echo'<p><strong>'.sprintf(__('GMAIL smtp no longer works with the settings below, unless you set your Google account to allow less secure apps at %1$s , which of course has implications. One of which, is that you have to type in your gmail password in WordPress which is visible to all admin users.  Only do that if you understand the risks! There is a great new plugin that uses Gmails more secure authentication standard %2$s','church-admin'),'<a href="https://www.google.com/settings/security/lesssecureapps">https://www.google.com/settings/security/lesssecureapps</a>','<a href="https://wordpress.org/plugins/gmail-smtp/">https://wordpress.org/plugins/gmail-smtp/</a>').'</strong></p>';
		echo'<form action="" method="POST">';
		echo'<table class="form-table"><tbody>';

		echo'<tr><th scope="row">'.__('SMTP Host','church-admin').'</th><td><input type="text" name="host" placeholder="smtp.gmail.com" ';
		if(!empty( $settings['host'] ) ) echo ' value="'.esc_html( $settings['host'] ).'" ';
		echo'/></td></tr>';
		echo'<tr><th scope="row">'.__('SMTP Authorisation required?','church-admin').'</th><td><input type="checkbox" name="auth" value="TRUE" ';
		if(!empty( $settings['auth'] ) ) echo ' checked="checked" ';
		echo'/></td></tr>';
		echo'<tr><th scope="row">'.__('SMTP Port','church-admin').'</th><td><input type="text" name="port" placeholder="465" ';
		if(!empty( $settings['port'] ) ) echo ' value="'.esc_html( $settings['port'] ).'" ';
		echo'/></td></tr>';
		echo'<tr><th scope="row">'.__('SMTP Username','church-admin').'</th><td><input type="text" name="username" placeholder="yourname@gmail.com" ';
		if(!empty( $settings['username'] ) ) echo ' value="'.esc_html( $settings['username'] ).'" ';
		echo'/></td></tr>';
		echo'<tr><th scope="row">'.__('SMTP Password','church-admin').'</th><td><input type="text" name="password" placeholder="password" ';
		if(!empty( $settings['password'] ) ) echo ' value="'.esc_html( $settings['password'] ).'" ';
		echo'/></td></tr>';
		echo'<tr><th scope="row">'.__('SMTP Security','church-admin').'</th><td><select  name="secure"> ';
		if(!empty( $settings['secure'] ) ) echo ' <option value="'.esc_html( $settings['secure'] ).'">'.esc_html( $settings['secure'] ).'</option> ';
		echo'<option value="ssl">SSL</option><option value="tls">TLS</option><option value="">None</option>';
		echo'</select></td></tr>';
		echo'<tr><th scope="row">'.__('SMTP From Email','church-admin').'</th><td><input type="text" name="from" placeholder="yourname@gmail.com" ';
		if(!empty( $settings['from'] ) ) echo ' value="'.esc_html( $settings['from'] ).'" ';
		echo'/></td></tr>';
		echo'<tr><th scope="row">'.__('SMTP From Name','church-admin').'</th><td><input type="text" name="from_name" placeholder="'.__('Your name','church-admin').'" ';
		if(!empty( $settings['from_name'] ) ) echo ' value="'.esc_html( $settings['from_name'] ).'" ';
		echo'/></td></tr>';
		echo'<tr><th scope="row">&nbsp;</th><td><input type="hidden" name="save-smtp-settings" value="TRUE"/><input class="button-primary"  type="submit" value="'.__('Save','church-admin').'"/></td></tr>';
		echo'</tbody></table></form>';

}


/**
 * This function sets up roles
 *
 * Author:     Andy Moyle
 * Author URI: http://www.churchadminplugin.com
 *
 *
 */
function church_admin_roles()
{
	global $wpdb;
	$roles_display='display:none';
	$levels=get_option('church_admin_levels');
	unset($levels['Prayer Chain']);
	$available_levels=get_option( $wpdb->prefix.'user_roles');

	if(!empty( $_POST['save-permissions'] ) )
	{
		$form=$newlevels=array();
		foreach( $_POST AS $key=>$value)$form[str_replace('_',' ',$key)]=stripslashes( $value);
		foreach( $form AS $key=>$value)  $newlevels[substr( $key,5)]=$value;

		foreach( $levels AS $key=>$value)
		{
			if(!empty( $newlevels[$key] )&&array_key_exists( $newlevels[$key],$available_levels) )$levels[$key]=$newlevels[$key];
	    }

		update_option('church_admin_levels',$levels);
		echo'<div class="notice notice-success inline"><p>'.__('Roles Updated','church-admin').'</p></div>';
		$roles_display='display:block';
	}

	$levels=get_option('church_admin_levels');
	
	unset($levels['Prayer Chain']);
	ksort($levels);
	$available_levels=get_option( $wpdb->prefix.'user_roles');
		echo'<h1>'.__('Roles','church-admin').'</h1>';
		echo'<p>'.__('You can either set individuals  or allow roles like admin/editor/subscriber to have permission for various tasks','church-admin').'</p>';
		echo'<p><a href="admin.php?page=church_admin/index.php&amp;section=settings&amp;action=permissions">'.__('Set individual permissions','church-admin').'</a></p>';

		echo'<form action="admin.php?page=church_admin/index.php&amp;action=roles&section=settings" method="POST">';
		echo'<table class="form-table"><tbody>';
		foreach( $levels AS $key=>$value)
		{

			//Need to be translateable, so used stored data and convert to translated display string
			switch( $key)
			{
				case'People':$display=__('People','church-admin');break;
				case'Rota':$display=__('Rota','church-admin');break;
				case'Children':$display=__('Children','church-admin');break;
				case 'Contact form':$display=__('Contact form','church-admin'); break;
				case'Comms':$display=__('Comms','church-admin');break;
				case'Groups':$display=__('Groups','church-admin');break;
				case'Calendar':$display=__('Calendar','church-admin');break;
				case'Media':$display=__('Media','church-admin');break;
				case'Facilities':$display=__('Facilities','church-admin');break;
				case'Ministries':$display=__('Ministries','church-admin');break;
				case'Service':$display=__('Service','church-admin');break;
				case'Sessions':$display=__('Sessions','church-admin');break;
				case'Member Type':$display=__('Member Type','church-admin');break;
				case'Sermons':$display=__('Sermons','church-admin');break;
				
				case'Attendance':$display=__('Attendance','church-admin');break;
				case'Bulk SMS':$display=__('Bulk SMS','church-admin');break;
				case'App':$display=__('App','church-admin');break;
                case'Events':$display=__('Events','church-admin');break;
				case'Bulk Email':$display=__('Bulk Email','church-admin');break;
				case'Visitor':$display=__('Visitor','church-admin');break;
				case'Funnel':$display=__('Funnel','church-admin');break;
				default:$display=$key;break;
			}
			echo'<tr><th scope="row">'.$display.'</th><td><select name="level'.$key.'">';
			echo'<option value="'.$value.'" selected="selected">'.$value.'</option>';
			foreach( $available_levels AS $avail_key=>$avail_value)echo'<option value="'.$avail_key.'">'.$avail_key.'</option>';
			echo'</select></td></tr>';
		}
		echo'<tr><th scope="row">&nbsp;</th><td><input type="hidden" name="save-permissions" value="TRUE"/><input type="submit" class="button-primary" value="'.__('Save','church-admin').'"/></td></tr>';
		echo'</tbody></table></form>';
		

}



/**
 * This function sets up Bulk SMS
 *
 * Author:     Andy Moyle
 * Author URI: http://www.churchadminplugin.com
 *
 *
 */


function church_admin_sms_settings()
{
    require_once(plugin_dir_path(dirname(__FILE__) ).'/includes/sms.php');
    $sms_country_code=get_option('church_admin_sms_iso');
    $sms_sender=get_option('church_admin_sms_reply');
    /********************************************************
    *
    * Check if old style provider is set already
    *
    **********************************************************/
    $smsProvider=get_option('church_admin_sms_provider');
    if ( empty( $smsProvider) )
    {
        $bulksms=get_option('church_admin_bulksms');
        if(!empty( $bulksms) )
        {
            $smsProvider='bulksms.com';
            update_option('church_admin_sms_provider','bulksms.com');
            delete_option('church_admin_bulksms');
        }
        $cloudservicezm=get_option('church_admin_cloudservicezm');
        if(!empty( $cloudservicezm) )
        {
            $smsProvider='cloudservicezm.com';
            update_option('church_admin_sms_provider','cloudservicezm.com');
            delete_option('church_admin_cloudservicezm');
        }
    }
    if(!empty( $smsProvider) )
    {
        $sender=get_option('church_admin_sms_reply');
        switch( $smsProvider)
        {
            case 'bulksms.com':
            case'cloudservicezm.com':
                    $sms_username=get_option('church_admin_sms_username');
                    $sms_password=get_option('church_admin_sms_password');
            break;
            case 'textmagic.com':
                    $sms_username=get_option('church_admin_sms_username');
                    $api_key=get_option('church_admin_sms_api_key');
            break;
            case 'twilio':
                    $smsSID=get_option('church_admin_twilio_SID');
                    $smsToken=get_option('church_admin_twilio_token');
            break;
        }
    }
    echo'<h2>'.__("You can send bulk SMS to your directory using one of these SMS service providers",'church-admin').'</h2>';
    if ( empty( $_POST) )
	{
		echo'<p>'.__("Click on an image to sign up with a provider",'church-admin').'</p>';
		echo'<table class="widefat wp-list-table"><thead><tr><th class="column-primary">'.__('SMS provider','church-admin').'</th><th>'.__('Details','church-admin').'</th></thead><tbody><tr>';
		echo'<tr><td class="column-primary" data-colname="Twilio">Twilio<button type="button" class="toggle-row">
		<span class="screen-reader-text">show details</span>
		</button></td><td><a href="https://www.twilio.com/referral/YjV7bl"><img src="'.plugins_url('/images/twilio-logo.png',dirname(__FILE__) ).'" alt="Twilio"/><br />'.__('Get $10 free when you purchase $10 of credit','church-admin').'</a><br />'.__('Twilio require you to purchase a cell number from them to send SMS at $1pm, but that allows you to send and receive from this website','church-admin').'<button type="button" class="toggle-row">
			<span class="screen-reader-text">show details</span>
		</button></td></tr>';
			echo'<tr><td class="column-primary"  data-colname="Textmagic">Textmagic<button type="button" class="toggle-row">
			<span class="screen-reader-text">show details</span>
		</button></td><td><a href="https://shareasale.com/r.cfm?b=1370513&u=2478286&m=75317&urllink=&afftrack="><img src="'.plugins_url('/images/textmagic-logo.jpeg',dirname(__FILE__) ).'" alt="textmagic.com"/><br />'.__('Pricing available in USD, GBP, AUD and EUR','church-admin').'</a></td></tr>';
			
			echo'<tr><td class="column-primary"  data-colname="BulkSMS">BulkSMS<button type="button" class="toggle-row">
			<span class="screen-reader-text">show details</span>
		</button></td><td><a href="https://www.bulksms.com"><img src="'.plugins_url('/images/bulksms-logo.png',dirname(__FILE__) ).'" alt="bulksms.com"/></a><br />'.__('Pricing available in GBP','church-admin').'</td></tr>';
			echo'<tr><td  class="column-primary" data-colname="Zambia CloudService">Cloudservice Zambia<button type="button" class="toggle-row">
			<span class="screen-reader-text">show details</span>
		</button></td><td><a href="https://www.cloudservicezm.com/"><img src="'.plugins_url('/images/cloudservicezm-logo.jpeg',dirname(__FILE__) ).'" alt="cloudservicezm.com"/></a><br />'.__('Unknown pricing - Zambia only','church-admin').'</td></tr>';
			echo'</tr></tbody></table>';
	}
    if(!empty( $_POST['save-sms-settings'] ) )
    {
        switch( $_POST['sms-provider'] )
        {
            case'twilio':
                update_option('church_admin_sms_provider','twilio');
                update_option('church_admin_twilio_token',stripslashes( $_POST['sms-token'] ) );
                update_option('church_admin_twilio_SID',stripslashes( $_POST['sms-SID'] ) );
                $smsSID=stripslashes( $_POST['sms-SID'] );
                $smsToken=stripslashes( $_POST['sms-token'] );
                $smsProvider='twilio';
            break;
            case'textmagic.com':
                update_option('church_admin_sms_provider','textmagic.com');
                update_option('church_admin_sms_api_key',stripslashes( $_POST['sms-api-key'] ) );
                $smsProvider='textmagic.com';
                $sms_api_key=stripslashes( $_POST['sms-api-key'] );
            break;
            case'bulksms.com':
                update_option('church_admin_sms_provider','bulksms.com');
                update_option('church_admin_sms_password',stripslashes( $_POST['sms-password'] ) );
                $smsProvider='bulksms.com';
                $sms_password=stripslashes( $_POST['sms-password'] );
            break;
            case'cloudservicezm.com':
                update_option('church_admin_sms_provider','cloudservicezm.com');
                update_option('church_admin_sms_password',stripslashes( $_POST['sms-password'] ) );
                $smsProvider='cloudservicezm.com';
                $sms_password=stripslashes( $_POST['sms-password'] );
            break;     
        }
        update_option('church_admin_sms_username',stripslashes( $_POST['sms-username'] ) );
        $sms_username=stripslashes( $_POST['sms-username'] );
        update_option('church_admin_sms_iso',stripslashes( $_POST['sms-iso'] ) );
        $sms_iso=stripslashes( $_POST['sms-iso'] );
        update_option('church_admin_sms_reply',stripslashes( $_POST['sms-sender'] ) );
        $sms_sender=stripslashes( $_POST['sms-sender'] );
        echo'<div class="notice notice-success inline"><h2>'.__('SMS provider settings saved','church-admin').'</h2></div>';
    }
        echo'<h2>'.__('SMS provider settings','church-admin').'</h2>';
        echo'<form action="" method="post">';
        echo'<table class="form-table">';
        echo'<tr><th scope="row">'.__('Country code (eg 44 for GB)','church-admin').'</th><td><input type="text" name="sms-iso" ';
        if(!empty( $sms_country_code) ) echo' value="'.esc_html( $sms_country_code).'" ';
        echo'/></td></tr>';
        echo'<tr><th scope="row">'.__('SMS sender cell eg:4412345678901, except Twilio +4412345678901','church-admin').'</th><td><input type="text" name="sms-sender" ';
        if(!empty( $sms_sender) ) echo' value="'.esc_html( $sms_sender).'" ';
        echo'/></td></tr>';
        echo'<tr><th scope="row">'.__("Select SMS provider",'church-admin').'</th><td><select class="sms_provider" name="sms-provider">';
        if(!empty( $smsProvider) )echo'<option selected="selected" value="'.esc_html( $smsProvider).'">'.esc_html( $smsProvider).'</option>';
        echo'<option value="textmagic.com">textmagic.com</option>';
        echo'<option value="twilio">Twilio</option>';
        echo'<option value="bulksms.com">bulksms.com</option>';
        echo'<option value="cloudservicezm.com">cloudservicezm.com</option>';
        echo'</select></td></tr>';
        
        if(!empty( $smsProvider) )
        {
            switch( $smsProvider)
            {
                case 'twilio':
                        $showAPI=FALSE;
                        $showP=FALSE;
                        $showSID=TRUE;
                        $showToken=TRUE;
                        $showUserName=FALSE;
                    break;
                    default:case'textmagic.com':
                        $showAPI=TRUE; $showToken=$showSID=$showP=FALSE;
                    break;
                    case 'bulksms.com':case'cloudservicezm.com':
                        $showToken=$showSID=$showAPI=FALSE;
						$showUserName=$showP=TRUE;
                    break;
            }
        }else{$showAPI=TRUE; $showUP=FALSE;}
        
        echo'<tr class="sms-username"';
        if ( empty( $showUserName) )echo ' style="display:none" ';
        echo'><th scope="row">'.__('Username','church-admin').'</th><td><input type="text" name="sms-username" ';
        if(!empty( $sms_username) )echo'value="'.esc_html( $sms_username).'" ';
        echo'/></td></tr>';
        echo'<tr class="sms-api-key"';
        if ( empty( $showAPI) )echo ' style="display:none" ';
        echo'><th scope="row">'.__('API key','church-admin').'</th><td><input type="text" name="sms-api-key" ';
        if(!empty( $api_key) )echo'value="'.esc_html( $api_key).'" ';
        echo'/></td></tr>';
        
        echo'<tr class="sms-password" ';
        if ( empty( $showP) )echo ' style="display:none" ';
        echo'><th scope="row">'.__('Password','church-admin').'</th><td><input type="text" name="sms-password" ';
        if(!empty( $sms_password) )echo'value="'.esc_html( $sms_password).'" ';
        echo'/></td></tr>';
        /*******************
        * Twilio
        ********************/
        echo'<tr class="sms-SID"';
        if ( empty( $showSID) )echo ' style="display:none" ';
        echo'><th scope="row">'.__('Twilio SID','church-admin').'</th><td><input type="text" name="sms-SID" ';
        if(!empty( $smsSID) )echo'value="'.esc_html( $smsSID).'" ';
        echo'/></td></tr>';
        echo'<tr class="sms-token"';
        if ( empty( $showToken) )echo ' style="display:none" ';
        echo'><th scope="row">'.__('Twilio Token','church-admin').'</th><td><input type="text" name="sms-token" ';
        if(!empty( $smsToken) )echo'value="'.esc_html( $smsToken).'" ';
        echo'/></td></tr>';
        echo'<tr><th scope="row">&nbsp;</th><td><input type="hidden" name="save-sms-settings" value="TRUE"/><input type="submit" value="'.__('Save','church-admin').' &raquo;" class="button-primary"/></form>';
         echo'</table>';
        
        
        echo'<script>jQuery(document).ready(function( $)  {
            $(".sms_provider").on("change",function()  {
                var sms_provider=$(this).val();
                switch(sms_provider)
                {
                    case "twilio":
                        $(".sms-api-key").hide();
                        $(".sms-password").hide();
                        $(".sms-SID").show();
                        $(".sms-token").show();
                         $(".sms-username").hide();
                    break;
                    case "textmagic.com":
                        $(".sms-api-key").show();
                        $(".sms-password").hide();
                        $(".sms-SID").hide();
                        $(".sms-token").hide();
                        $(".sms-username").show();
                    break;
                    case "bulksms.com":case"cloudservicezm.com":
                        $(".sms-api-key").hide();
                       $(".sms-username").show();
                        $(".sms-password").show();
                        $(".sms-SID").hide();
                        $(".sms-token").hide();
                    break;    
                }
            })
        });</script>';
    
    
    
    
    
}
/**
 * This function general settings
 *
 * Author:     Andy Moyle
 * Author URI: http://www.churchadminplugin.com
 *
 *
 */

 function church_admin_general_settings()
 {
	 global $wpdb;
	echo'<h1>'.__('Settings ','church-admin').'</h1>';
	//echo wp_login_url().'</br/>';
	if(!empty( $_POST['save-general-settings'] ) )
	{
        if(!empty( $_POST['prayer-request-moderation'] ) )update_option('prayer-request-moderation',stripslashes( $_POST['prayer-request-moderation'] ) );
		if(!empty( $_POST['volunteer'] ) )update_option('church-admin-volunteer-message',stripslashes( $_POST['volunteer'] ) );
        if(!empty( $_POST['acts_of_courage'] ) )  {
			update_option('church-admin-acts-of-courage',TRUE);
		}else{
			delete_option('church-admin-acts-of-courage');
		}
		if(!empty( $_POST['acts-of-courage-request-message'] ) )  {update_option('church-admin-acts-of-courage-message',stripslashes( $_POST['acts-of-courage-request-message'] ) );}else{delete_option('church-admin-acts-of-courage-message');}
		update_option('church_admin_pdf_size',$_POST['pdf_size'] );
		if(!empty( $_POST['no-bible-readings'] ) ){
			update_option('church-admin-no-bible-readings',1);
			//adjust app menu
			$chosenMenu=get_option('church_admin_app_new_menu');
			if(!empty($chosenMenu)){
				unset( $chosenMenu['bible'] );
				update_option('church_admin_app_new_menu',$chosenMenu);

			}
		}else{
			delete_option('church-admin-no-bible-readings');
			//app
			$chosenMenu=get_option('church_admin_app_new_menu');
			if(!empty($chosenMenu)){
				$chosenMenu['bible']=array('edit'=>true,'item'=>__('Bible','church-admin'),'order'=>5,'show'=>TRUE,'type'=>'app','loggedinOnly'=>0);
				update_option('church_admin_app_new_menu',$chosenMenu);
			}
		}	
		if(!empty( $_POST['no-prayer-requests'] ) )  {
			update_option('church-admin-no-prayer',1);
			//app
			$chosenMenu=get_option('church_admin_app_new_menu');
			if(!empty($chosenMenu)){
				unset( $chosenMenu['bible'] );
				update_option('church_admin_app_new_menu',$chosenMenu);

			}
		
		}else{
			
			delete_option('church-admin-no-prayer');
			//app
			//app
			$chosenMenu=get_option('church_admin_app_new_menu');
			if(!empty($chosenMenu)){
				$chosenMenu['prayer']=array('edit'=>true,'item'=>__('Prayer','church-admin'),'order'=>14,'show'=>TRUE,'type'=>'app','loggedinOnly'=>0);
				update_option('church_admin_app_new_menu',$chosenMenu);
			}
		}	
		if(!empty($_POST['register-page'])){
			update_option('church_admin_register_page',esc_url(sanitize_text_field($_POST['register-page'])));
		}
		else
		{
			delete_option('church_admin_register_page');
		}
		if(!empty( $_POST['prayer-request-message'] ) )  {update_option('church_admin_prayer_request_message',sanitize_text_field( $_POST['prayer-request-message'] ) );}else{delete_option('church_admin_prayer_request_message');}
		if(!empty( $_POST['socials'] ) )  {update_option('church-admin-socials',TRUE);}else{delete_option('church-admin-socials');}
		if(!empty( $_POST['login-redirect'] ) )
		{
			update_option('church_admin_login_redirect',$_POST['login-redirect'] );
		}else{delete_option('church_admin_login_redirect');}
        
		if(!empty( $_POST['no-push'] ) )
        {
            update_option('church_admin_no_push',TRUE);
        }
        else
        {
            delete_option('church_admin_no_push');
        }
		if ( empty( $_POST['private-prayer'] ) )
		{
			update_option('church-admin-private-prayer-requests',FALSE);

		}else
		{
			update_option('church-admin-private-prayer-requests',TRUE);

		}

		
		if(!empty( $_POST['prayer-request-admin-push'] ) )
        {
                $prayer_request_people_ids=maybe_unserialize(church_admin_get_people_id( $_POST['prayer-request-admin-push'] ) );
                update_option('church_admin_prayer_request_receive_push_to_admin', $prayer_request_people_ids);
        }
        else
        {
                delete_option('church_admin_prayer_request_receive_push_to_admin');
        }
		if ( empty( $_POST['private-acts-of-courage'] ) )
		{
			update_option('church-admin-private-acts-of-courage',FALSE);

		}else
		{
			update_option('church-admin-private-acts-of-courage',TRUE);

		}
        if ( empty( $_POST['admin-approval'] ) )
        {
            delete_option('church_admin_admin_approval_required');
        }else{update_option('church_admin_admin_approval_required',TRUE);}
		if ( empty( $_POST['socials'] ) )  {update_option('church-admin-use-socials',TRUE);}else{update_option('church-admin-use-socials',FALSE);}		if ( empty( $_POST['use_prefix'] ) )  {update_option('church_admin_use_prefix',FALSE);}else{update_option('church_admin_use_prefix',TRUE);}
		if ( empty( $_POST['use_middle'] ) )  {update_option('church_admin_use_middle_name',FALSE);}else{update_option('church_admin_use_middle_name',TRUE);}
		//if ( empty( $_POST['use_nickname'] ) )  {update_option('church_admin_use_nickname',FALSE);}else{update_option('church_admin_use_nickname',TRUE);}
		if(!empty( $_POST['google_api'] ) )  {update_option('church_admin_google_api_key',$_POST['google_api'] );}else{delete_option('church_admin_google_api_key');}
		if(!empty( $_POST['pagination'] ) )update_option('church_admin_pagination_limit',intval( $_POST['pagination'] ) );
		if(!empty( $_POST['gdpr_template'] ) )update_option('church_admin_gdpr_email',stripslashes( $_POST['gdpr_template'] ) );
		if(!empty( $_POST['user_subject'] ) )update_option('church_admin_user_created_email_subject',stripslashes( $_POST['user_subject'] ) );
		if(!empty( $_POST['user_template'] ) )update_option('church_admin_user_created_email',stripslashes( $_POST['user_template'] ) );
		if(!empty( $_POST['church_admin_receipt_email_from_name'] ) )update_option('church_admin_receipt_email_from_name',stripslashes( $_POST['church_admin_receipt_email_from_name'] ) );
		if(!empty( $_POST['church_admin_receipt_email_from_email'] ) )update_option('church_admin_receipt_email_from_email',stripslashes( $_POST['church_admin_receipt_email_from_email'] ) );
		if(!empty( $_POST['church_admin_receipt_email_template'] ) )update_option('church_admin_receipt_email_template',stripslashes( $_POST['church_admin_receipt_email_template'] ) );
		if(isset( $_POST['church_admin_label'] ) )
		{
		switch( $_POST['church_admin_label'] )
		{
			case 'L7163': $option='L7163';break;
			case '5160': $option='5160';break;
			case '5161': $option='5161';break;
			case '5162': $option='5162';break;
			case '5163': $option='5163';break;
			case '5164': $option='5164';break;
			case '8600': $option='8600';break;
			case '3422': $option='3422';break;
			default :$option='L7163';break;
		}
		update_option('church_admin_label',$option);
		}else{delete_option('church_admin_label');}
		if(isset( $_POST['what-three-words'] ) )
		{	update_option('church_admin_what_three_words','on');
			update_option('church_admin_what_three_words_language',stripslashes( $_POST['what-three-words-language'] ) );
		}else{update_option('church_admin_what_three_words','off');}
		
		echo'<div class="notice notice-success inline"><p>'.__('Settings updated','church-admin').'</p></div>';
		$generalDisplay='display:block';
	}


		
		
		echo'<form action="" method="POST">';
		
        echo'<h2>'.__('General Settings','church-admin').'</h2>';
  
     
		//login redirect
		echo'<div class="church-admin-form-group"><label>'.__('Redirect page after login by "subscriber"','church-admin').'</label><select class="church-admin-form-control" name="login-redirect">';
		$redirect=get_option('church_admin_login_redirect');
        
        //add in a dropdown of pages and post_status
		echo church_admin_posts_and_pages_dropdown($redirect);
		echo'</select></div>';
		/**************************
		 * Register page
		 **************************/
		echo'<div class="church-admin-form-group"><label>'.__('What page is your register block/shortcode on?','church-admin').'</label><select class="church-admin-form-control" name="register-page">';
		$current=get_option('church_admin_register_page');
        
        //add in a dropdown of pages and post_status
		echo church_admin_posts_and_pages_dropdown($current);
		echo'</select></div>';
	
		/***********************
		 * Serving and volunteering
		 ***********************/
		echo'<table class="form-table"><thead><tr><th colspan=2><h2>'.__('Serving and volunteering','church-admin').'</th></tr><thead><tbody>';
		
		// volunteer message
		$volunteerMessage=get_option('church-admin-volunteer-message');
		echo'<tr><th scope="row">'.__('Explanation for volunteer shortcode','church-admin').'</th><td><textarea cols=80 rows=10 name="volunteer" > ';
		if( $volunteerMessage) {echo esc_textarea( $volunteerMessage );}
		else{echo __('You can volunteer for various ministries in the church here. The team leaders will be in touch','church-admin');}
		echo '</textarea></td></tr>';
		echo'</table>';
		/***********************
		 * Acts of Courage
		 ***********************/
		echo'<table class="form-table"><thead><tr><th colspan=2><h2>'.__('Acts of Courage','church-admin').'</th></tr><thead><tbody>';
		echo'<tr><th scope="row">'.__('Acts of courage post type','church-admin').'</th><td><input type="checkbox" name="acts_of_courage" value="TRUE" ';
		$acts=get_option('church-admin-acts-of-courage');
		if( $acts) echo ' checked="checked" ';
		echo '/></td></tr>';
		echo'<tr><th scope="row">'.__('Make acts of courage viewable by logged in users only','church-admin').'</th><td><input type="checkbox" name="private-acts-of-courage" value="TRUE" ';
		
		
		$privateActs=get_option('church-admin-private-acts-of-courage');
		if( $privateActs) echo ' checked="checked" ';
		echo '/></td></tr>';
		
		echo'<tr><th scope="row">'.__('Message for Acts of Courage submission form','church-admin').'</th><td><textarea cols=80 rows=10 name="acts-of-courage-request-message">';
		$message=get_option('church-admin-acts-of-courage-message');
		if(!empty( $message) )  {echo esc_textarea( $message);}
		else{echo __('We love to hear stories of acts of courage in sharing your faith','church-admin');}
		echo'</textarea></td></tr>';
		echo'</table>';
		/***********************
		 * Bible REadings
		 ***********************/
		echo'<table class="form-table"><thead><tr><th colspan=2><h2>'.__('Bible Readings','church-admin').'</th></tr><thead><tbody>';
		$noBibleReadings=get_option('church-admin-no-bible-readings');
		echo'<tr><th scope="row">'.__('No Bible readings custom post type','church-admin').'</th><td><input type="checkbox" name="no-bible-readings" value="TRUE" ';
		if( $noBibleReadings) echo ' checked="checked" ';
		echo '/></td></tr>';
		echo'</table>';
		/***********************
		 * Prayer Requests
		 ***********************/
		echo'<table class="form-table"><thead><tr><th colspan=2><h2>'.__('Prayer Requests','church-admin').'</th></tr><thead><tbody>';

		$noPrayerRequests=get_option('church-admin-no-prayer');
		echo'<tr><th scope="row">'.__('No prayer requests custom post type','church-admin').'</th><td><input type="checkbox" name="no-prayer-requests" value="TRUE" ';
		if( $noPrayerRequests) echo ' checked="checked" ';
		echo '/></td></tr>';

		echo'<tr><th>'.__('Email address for prayer request moderation').'</th><td>';
        echo'<input type="email" name="prayer-request-moderation"  ';
        $prm=get_option('prayer-request-moderation');
        if ( empty( $prm) )  { $prm=get_option('admin_email');}
        echo' value="'.esc_html( $prm).'" ';
        echo'/></td></tr>';
		
		echo'<tr><th scope="row">'.__('Make prayer requests viewable by logged in users only','church-admin').'</th><td><input type="checkbox" name="private-prayer" value="TRUE" ';
		$private=get_option('church-admin-private-prayer-requests');
		if( $private) echo ' checked="checked" ';
		echo '/></td></tr>';
		echo'<tr><th scope="row">'.__('Message for Prayer request submission form','church-admin').'</th><td><textarea cols=80 rows=10 name="prayer-request-message">';
		$message=get_option('church_admin_prayer_request_message');
		if(!empty( $message) )echo esc_textarea( $message);
		echo'</textarea></td></tr>';

		//Admins to get prayer request moderations push notification
		if(church_admin_app_licence_check() )
		{
			echo'<tr><th scope="row">'.__('Admins to get prayer request moderation push','church-admin').'</th><td>';
			$prayer_request_people_ids=get_option('church_admin_prayer_request_receive_push_to_admin');
			$prayer_request_people='';
			if(!empty( $prayer_request_people_ids) )$prayer_request_people=church_admin_get_people( $prayer_request_people_ids);
			echo church_admin_autocomplete('prayer-request-admin-push','friends','to',$prayer_request_people,FALSE).'</td></tr>';
		}
		echo'</tbody></table>';
		/***********************
		 * GDPR
		 ***********************/
		echo'<table class="form-table"><thead><tr><th colspan=2><h2>GDPR</th></tr><thead><tbody>';
		$adminApproval=get_option('church_admin_admin_approval_required');
        echo'<tr><th>'.__('Admin approval of new users required before account given','church-admin').'</th><td>';
        echo'<input type="checkbox" name="admin-approval" value="1" ';
        if(!empty( $adminApproval) ) echo' checked="checked" ';
        echo'/></td></tr>';
		echo'<tr><th scope="row">'.__('GDPR message template ','church-admin').'</th><td>[SITE_URl],[CHURCH_NAME],[CONFIRM_URL],[EDIT_URL],[HOUSEHOLD_DETAILS]<br /><textarea cols=80 rows=10  name="gdpr_template">';
		$gdprMessage=get_option('church_admin_gdpr_email');
		echo esc_textarea( $gdprMessage);
		echo'</textarea></td></tr>';
		echo'<tr><th scope="row">'.__('New User Email Subject','church-admin').'</th><td><input type="text" name="user_subject"  ';
		$user_subject=get_option('church_admin_user_created_email_subject');
		if(!empty( $user_subject) ) echo 'value="'.esc_html( $user_subject).'"';
		echo '/></td></tr>';
		echo'<tr><th scope="row">'.__('Created user email message template ','church-admin').'</th><td>[SITE_URl],[USERNAME],[PASSWORD],[EDIT_PAGE]<br /><textarea cols=80 rows=10  name="user_template">';
		$userMessage=get_option('church_admin_user_created_email');
		if ( empty( $userMessage) )
		{
			$userMessage='<p>'.__('The web team at','church-admin'). '<a href="[SITE_URL]">[SITE_URL]</a> '.__('have just created a user login for you.','church-admin').'</p><p>'.__('Your username is','church-admin').' <strong>[USERNAME]</strong></p><p>'.__('Your password is','church-admin').' <strong>[PASSWORD]</strong></p><p>'.__('We also have an app you can download for [ANDROID] and [IOS]','church-admin').' </p>';
			update_option('church_admin_user_created_email',$userMessage);
		}

		echo esc_textarea( $userMessage);
		echo'</textarea></td></tr>';
		echo'</tbody></table>';
		/***********************
		 * Directory Settings
		 ***********************/
		echo'<table class="form-table" id="directory-settings"><thead><tr><th colspan=2><h2>'.__('Directory settings','church-admin').'</th></tr><thead><tbody>';
		echo'<tr><th scope="row">'.__('Use prefix for names','church-admin').'</th><td><input type="checkbox" name="use_prefix" value="TRUE" ';
		$prefix=get_option('church_admin_use_prefix');
		if( $prefix) echo ' checked="checked" ';
		echo '/></td></tr>';
		echo'<tr><th scope="row">'.__('Use middle name for names','church-admin').'</th><td><input type="checkbox" name="use_middle" value="TRUE" ';
		$middle=get_option('church_admin_use_middle_name');
		if( $middle) echo ' checked="checked"';
		echo '/></td></tr>';
		/*
		echo'<tr><th scope="row">'.__('Add nickname for names','church-admin').'</th><td><input type="checkbox" name="use_nickname" value="TRUE" ';
		$nickname=get_option('church_admin_use_nickname');
		if( $nickname)echo ' checked="checked"';
		echo '/></td></tr>';
		*/
		echo'<tr><th scope="row">'.__('Google Maps API key','church-admin').'</th><td><input type="text" name="google_api" value="'.get_option('church_admin_google_api_key').'"/></td></tr>';
		echo'<tr><td colspan="2"><a taregt="_blank" href="https://www.churchadminplugin.com/tutorials/google-api-key/">'.__('How to get a Google API key','church-admin').'</a></td></tr>';
		echo'<tr><th scope="row">'.__('Directory Records per page','church-admin').'</th><td><input type="text" name="pagination" value="'.get_option('church_admin_pagination_limit').'"/></td></tr>';
		
		echo'<tr><th>'.__('Stop push notification and email send on content publishing','church-admin').'</th><td>';
        echo'<input type="checkbox" name="no-push" value="1" ';
        $no_push= get_option('church_admin_no_push');
        if( $no_push) echo' checked="checked" ';
        echo'/></td></tr>';
		/***************************
		 * What three words
		 **************************/
		$googleAPI=get_option('church_admin_google_api_key');
		if(!empty( $googleAPI) )
		{//requires google API key to work
			$w3w='on';
			$w3w=get_option('church_admin_what_three_words');
			echo'<tr><th colspan=2><h2>'.__('What three words','church-admin').'</h2></th></tr>';
			echo'<tr><th colspan=2>'.__('What Three Words has divided the world into 3 metre squares and gave each square a unique combination of three words. It’s the easiest way to find and share exact locations.','church-admin').'</th></tr>';
			echo '<tr><th scope="row">'.__('What Three Words enabled').'</th><td><input type="checkbox" name="what-three-words" '.checked( $w3w,'on',false).'/></td></tr>';
			//grab what three words languages
			$response = wp_remote_get( esc_url_raw('https://api.what3words.com/v3/available-languages?key=7F5FVM60' ) );
			$api_response = json_decode( wp_remote_retrieve_body( $response ), true );
			
			$w3wLanguage=get_option('church_admin_what_three_words_language');
			if ( empty( $w3wLanguage) )$w3wLanguage='en';
			$languages=$api_response['languages'];
			if(!empty( $languages) )
			{
				echo '<tr><th scope="row">'.__('What Three Words language').'</th><td><select name="what-three-words-language">';
				foreach( $languages AS $key=>$detail)
				{
					echo'<option value="'.esc_html( $detail['code'] ).'" '.selected( $w3wLanguage,$detail['code'],false).'>'.esc_html( $detail['nativeName'] ).'</option>';
				}
				echo'</select></td></tr>';
			}

			echo'</tbody></table>';
		}
		/***********************
		 * PDF and Mailing Label settings
		 ***********************/
		echo'<table class="form-table"><thead><tr><th colspan=2><h2>'.__('PDF and Mailing Label settings','church-admin').'</th></tr><thead><tbody>';
		echo '<tr><th scope="row">'.__('PDF Page Size','church-admin').'</th><td><select name="pdf_size">';
		$pdf_size=get_option('church_admin_pdf_size');
		echo'<option value="A4" '.selected( $pdf_size,'A4').'>A4</option>';
		echo'<option value="Letter" '.selected( $pdf_size,'Letter').'>Letter</option>';
		echo'<option value="Legal" '.selected( $pdf_size,'Legal').'>Legal</option>';
		echo'</select></td></tr>';
		echo '<tr><th scope="row">Avery &#174; Label</th><td><select name="church_admin_label">';

		$l=get_option('church_admin_label');
		echo'<option value="L7163"';
		if( $l=='L7163') echo' selected="selected" ';
		echo'>L7163</option>';
		echo'<option value="5160"';
		if( $l=='5160') echo' selected="selected" ';
		echo'>5160</option>';
		echo'<option value="5161';
		if( $l=='5161') echo' selected="selected" ';
		echo'>5161</option>';
		echo'<option value="5162"';
		if( $l=='5162') echo' selected="selected" ';
		echo'>5162</option>';
		echo'<option value="5163"';
		if( $l=='5163') echo' selected="selected" ';
		echo'>5163</option>';
		echo'<option value="5164"';
		if( $l=='5164') echo' selected="selected" ';
		echo'>5164</option>';
		echo'<option value="8600"';
		if( $l=='8600') echo' selected="selected" ';
		echo'>8600</option>';
		echo'<option value="3422"';
		if( $l=='3422') echo' selected="selected" ';
		echo'>3422</option></select></td></tr>';
		/**************************************
		 * Donor Receipt email settings
		 *****************************************/
		$template=get_option('church_admin_receipt_email_template');
		$from_name=$from_email='';
		$from_name = get_option('church_admin_receipt_email_from_name');
		$from_email = get_option('church_admin_receipt_email_from_email');
		echo'<table class="form-table"><thead><tr><th colspan=2><h2>'.__('Donation receipt email settings','church-admin').'</th></tr><thead><tbody>';
		echo '<tr><th scope="row">'.__('Email from name','church-admin').'</th><td><input type="text" name="church_admin_receipt_email_from_name" value="'.esc_html( $from_name).'"/></td></tr>';
		echo '<tr><th scope="row">'.__('Email from email','church-admin').'</th><td><input type="text" name="church_admin_receipt_email_from_email" value="'.esc_html( $from_email).'"/></td></tr>';
		echo '<tr><th scope="row">'.__('Email template before amounts','church-admin').'</th><td><textarea name="church_admin_receipt_email_template"  cols=80 rows=10>'.esc_textarea( $template ).'</textarea></td></tr>';


		echo'<tr><th scope="row" >&nbsp;</th><td><input type="hidden" name="save-general-settings" value="1"/><input class="button-primary" type="submit"  value="'.__('Save Settings','church-admin').' &raquo;" /></td></tr></tbody></table></form>';




 }



 function church_admin_marital_status()
 {
 		$marital_status=get_option('church_admin_marital_status');
 		echo'<h2 class="marital-settings">'.__('Marital Status ','church-admin').'</h2>';


 		$thead='<tr><th>'.__('Edit','church-admin').'</th><th>'.__('Delete','church-admin').'</th><th>'.__('Marital Status','church-admin').'</th></tr>';
 		echo'<table class="widefat"><thead>'.$thead.'</thead><tfoot>'.$thead.'</tfoot><tbody>';
 		echo'<p><a class="button-primary"  href="'.wp_nonce_url('admin.php?page=church_admin/index.php&section=settings&action=edit_marital_status','edit_marital_status').'">'.__('Add','church-admin').'</a></p>';
 		foreach( $marital_status AS $key=>$value)
 		{
 			echo'<tr>';
 			$edit='<a href="'.wp_nonce_url('admin.php?page=church_admin/index.php&section=settings&action=edit_marital_status&amp;ID='.(int)$key,'edit_marital_status').'">'.__('Edit','church-admin').'</a>';
 			$delete='<a onclick="return confirm(\''.__('Are you sure?','church-admin').'\');" href="'.wp_nonce_url('admin.php?page=church_admin/index.php&section=settings&action=delete_marital_status&amp;ID='.(int)$key,'delete_marital_status').'">'.__('Delete','church-admin').'</a>';
 			if( $key==0)  {echo'<td>&nbsp;</td><td>&nbsp;</td>';}else{echo'<td>'.$edit.'</td><td>'.$delete.'</td>';}
 			echo'<td>'.esc_html( $value).'</td></tr>';
 		}
 		echo'</tbody></table>';
 	
 }

 function church_admin_delete_marital_status( $ID)
 {
 	global $wpdb;
 	$marital_status=get_option('church_admin_marital_status');

 	if(!empty( $marital_status[$ID] ) )
 	{
 		$old=$marital_status[$ID];
 		unset( $marital_status[$ID] );
 		update_option('church_admin_marital_status',$marital_status);
 		$wpdb->query('UPDATE '.CA_PEO_TBL.' SET marital_status=0 WHERE marital_status="'.(int)$id.'"');
 		echo'<div class="notice notice-inline notice-success">'.$old.' - '.__('Marital Status removed','church-admin').'</div>';
 	}
 	echo church_admin_marital_status();
 }

  function church_admin_edit_marital_status( $ID)
 {
 	$marital_status=get_option('church_admin_marital_status');

 	if(!empty( $marital_status[$ID] ) )
 	{
 		$old=$marital_status[$ID];
 	}
 	if(!empty( $_POST['marital_status'] ) )
 	{
 		$marital_status[]=stripslashes( $_POST['marital_status'] );
 		update_option('church_admin_marital_status',$marital_status);
 		echo'<div class="notice notice-inline notice-success">'.__('Marital Status updated','church-admin').'</div>';
 		echo church_admin_marital_status();
 	}
 	else
 	{
 		echo '<h2>'.__('Add/Edit Marital Status','church-admin').'</h2><form action="" method="POST"><table class="form-table"><tr><th scope="row">'.__('Marital Status','church-admin').'</th><td><input type="text" name="marital_status" ';
 		if(!empty( $old) ) echo' value="'.esc_html( $old).'" ';
 		echo'/></td></tr><tr><td colspacing=2><input class="button-primary" type="submit" value="'.__('Save','church-admin').'"/></td></tr></table></form>';

 	}

 }
 /**
 * This function lists people types
 *
 * Author:     Andy Moyle
 * Author URI: http://www.churchadminplugin.com
 * from v1.05
 *
 */

 function church_admin_people_types_list()
 {

 	echo'<h1>'.__('People Types ','church-admin').'</h1>';


 	echo'<p>'.__('If you add people types to "Adult", "Child"/"Teen" the shortcode [church_admin type="address-list"] will not work as expected! Use [church_admin type="directory"] instead','church-admin').'</p>';
 	echo'<p><a class="button-primary" href="'.wp_nonce_url('admin.php?page=church_admin/index.php&section=settings&action=edit_people_type','edit_people_type').'">'.__('Add People Type','church-admin').'</a></p>';
	$thead='<tr><th>'.__('Edit','church-admin').'</th><th>'.__('Delete','church-admin').'</th><th>'.__('People Type','church-admin').'</th></tr>';
 	echo'<table class="widefat"><thead>'.$thead.'</thead><tfoot>'.$thead.'</tfoot><tbody>';
	$people_types=get_option('church_admin_people_type');
 	foreach( $people_types AS $ID=>$type)
 	{
 		$edit='<a href="'.wp_nonce_url('admin.php?page=church_admin/index.php&section=settings&action=edit_people_type&amp;ID='.(int)$ID,'edit_people_type').'">'.__('Edit','church-admin').'</a>';
 		if( $ID>2)  {$delete='<a onclick="return confirm(\''.__('Are you sure?','church-admin').'\');" href="'.wp_nonce_url('admin.php?page=church_admin/index.php&section=settings&action=delete_people_type&amp;ID='.(int)$ID,'delete_people_type').'">'.__('Delete','church-admin').'</a>';}else{$delete='&nbsp;';}
 		echo'<tr><td>'.$edit.'</td><td>'.$delete.'</td><td>'.esc_html( $type).'</td></tr>';
 	}
	echo'</tbody></table>';
	
 }

 function church_admin_edit_people_type( $ID)
 {
 		$people_types=get_option('church_admin_people_type');

 		if(!empty( $_POST['people_type'] ) )
 		{
 			$out='<div class="notice notice-success inline">'.__('People type saved','church-admin').'</div>';
 			$new=stripslashes( $_POST['people_type'] );
 			if(!empty( $ID) )$people_types[$ID]=$new;
 			if ( empty( $ID)&& !empty( $new)&&!in_array( $new,$people_types) )$people_types[]=$new;
 			update_option('church_admin_people_type',$people_types);
            $out.=church_admin_people_types_list();
 		}
     else
     {
			$people_types=get_option('church_admin_people_type');
 			$out='<h2>'.__('Edit People Type','church-admin').'</h2>';
 			$out.='<form action="" method="POST"><p><label>'.__('People Type','church-admin').'</label><input type="text" name="people_type"';
 			if(!empty( $ID)&&!empty( $people_types[$ID] ) )$out.=' value="'.esc_html( $people_types[$ID] ).'" ';
 			$out.='/><input type="submit" class="button-primary" value="'.__('Save','church-admin').'"/></p></form>';
     }
 		return $out;
 }

  function church_admin_delete_people_type( $ID)
 {
 		$people_types=get_option('church_admin_people_type');
 		unset( $people_types[$ID] );
 		update_option('church_admin_people_type',$people_types);
 		$out='<div class="notice notice-success inline">'.__('People type deleted','church-admin').'</div>';
 		return $out;
 }

/******************************************************
*
* Restrict address list access from certain people
*
*******************************************************/
function church_admin_restrict_access()
{
	
	echo'<h1 >'.__('Restrict access to address list from certain people','church-admin').'</h1>';
	
	if(!empty( $_POST['save-restricted'] ) )
	{
		if(!empty( $_POST['people'] ) )$people=unserialize(church_admin_get_people_id(stripslashes( $_POST['people'] ) ));
		if(!empty( $people) )  {update_option('church-admin-restricted-access',$people);}else{delete_option('church-admin-restricted-access');}
	}
	$restrictedList=get_option('church-admin-restricted-access');
	$people='';
	if(!empty( $restrictedList) )$people=church_admin_get_people( $restrictedList);
	echo'<p>'.__('Restrict access to the directory by certain users','church-admin').'</p>';
	echo'<form action="" method="POST">';
	echo'<p>'.church_admin_autocomplete('people','friends','to',$people,FALSE).'</p>';
	echo'<input type="hidden" name="save-restricted" value="1"/><input type="submit" class="button-primary" value="'.__('Save','church-admin').'"/></p></form>';
	
 	
}


function church_admin_debug_log()
{
    echo'<h1>'.__('Debug Log','church-admin').'</h1>';
	if(defined('CA_DEBUG') )  {echo'<p>'.__('Debug mode is on','church-admin').'</p>';}else{echo'<p>'.__('Debug mode is off','church-admin').'</p>';}
	echo'<p><a class="button-primary" href="admin.php?page=church_admin/index.php&amp;section=settings&action=toggle-debug-mode">'.__('Toggle debug mode','church-admin').'</a></p>';
    //debug log display
	$upload_dir = wp_upload_dir();
	$debug_path=$upload_dir['basedir'].'/church-admin-cache/debug_log.php';
	$filesize=filesize( $debug_path);
	$debug_url=content_url().'/uploads/church-admin-cache/debug_log.php';

	if(file_exists( $debug_path) )
	{
		$filesize=filesize( $debug_path);
		$size=size_format( $filesize, $decimals = 2 );
		echo'<p>'.sprintf(__('Debug file is currently %1$s','church-admin'),$size).'</p>';
		echo'<p><a class="button-primary" download href="'.$debug_url.'">'.__('Download debug Log','church-admin').'</a></p>';
		if( $filesize<2097152)
		{
			echo'<p><a class="button-primary" href="admin.php?page=church_admin/index.php&amp;section=settings&action=send-to-support">'.__('Send debug file to support','church-admin').'</a></p>';
		}
		else
		{
			echo'<p>'.__('Your debug log is too big to send to support','church-admin').'</p>';
		}
		echo'<p><a class="button-secondary" href="'.wp_nonce_url('admin.php?page=church_admin/index.php&amp;section=settings&action=clear-debug','clear_debug').'">'.__('Clear Debug Log','church-admin').'</a></p>';
	}else{echo'<p>'.__('No debug log yet, because no errors encountered!','church-admin').'</p>';}
}

function church_admin_send_debug_to_support()
{
	global $wp_version,$church_admin_version,$wpdb;
	$upload_dir = wp_upload_dir();
	$debug_path=$upload_dir['basedir'].'/church-admin-cache/debug_log.php';
	if(!file_exists( $debug_path) ) return '<p>'.__("Debug log is empty",'church-admin').'</p>';
	$filesize=@filesize( $debug_path);
	$size=size_format( $filesize, $decimals = 2 );
	echo'<h2>'.__("Send debug log to support",'church-admin').'</h2>';
	echo'<p>'.sprintf(__('Debug file is currently %1$s','church-admin'),$size).'</p>';
	if( $filesize>2097152)  {echo '<p>'.__("Debug log is too big",'church-admin').'</p>';return;}
	if( $filesize<500)  {echo '<p>'.__("Debug log is too small to send (not enough debug data). Please repeat the task you are wanting to report a bug for and refresh this page.",'church-admin').'</p>';return;}
	
	echo'<p>'.__('This works best if you clear the debug log, recreate the issue and then send the new debug log file.','church-admin').'</p>';
	echo'<p><a class="button-secondary" href="'.wp_nonce_url('admin.php?page=church_admin/index.php&amp;section=settings&action=clear-debug','clear_debug').'">'.__('Clear Debug Log','church-admin').'</a></p>';
	
	if(!empty( $_POST['send'] ) )
	{
		$max_upload = (int)(ini_get('upload_max_filesize') );
		$max_post = (int)(ini_get('post_max_size') );
		$memory_limit = (int)(ini_get('memory_limit') );
		$file_uploads=ini_get( 'file_uploads' )?'Yes':'No';
		$upload_dir = wp_upload_dir();
		$sermonDirPath=$upload_dir['basedir'].'/sermons/';
		$url=content_url().'/uploads/sermons/';
		$hasSermonDir=is_dir( $sermonDirPath)?'Yes':'No';
		$premium=get_option('church_admin_payment_gateway');
		$hasPremium=!empty( $premium)?'Yes':'No';
		church_admin_gz( $debug_path,9);
		$fileToSend=$debug_path.'.gz';
		$subject='Debug Log from '.site_url();
		$message='<table><tr><th scope="row">Site</th><td>'.esc_html(site_url() ).'</td></tr>';
		$message.='<tr><th scope="row">WordPress version</th><td>'.esc_html( $wp_version).'</td></tr>';
		$message.='<tr><th scope="row">Church Admin Plugin version</th><td>'.esc_html( $church_admin_version).'</td></tr>';
		$message.='<tr><th scope="row">Premium?</th><td>'.esc_html( $premium).'</td></tr>';
		$message.='<tr><th scope="row">PHP version</th><td>'.esc_html(PHP_VERSION).'</td></tr>';
		
		$message.='<tr><th scope="row">Max Upload size</th><td>'.esc_html( $max_upload).'</td></tr>';
		$message.='<tr><th scope="row">Post Max size</th><td>'.esc_html( $max_post).'</td></tr>';
		$message.='<tr><th scope="row">Memory limit</th><td>'.esc_html( $memory_limit).'</td></tr>';
		$message.='<tr><th scope="row">File Uploads</th><td>'.esc_html( $file_uploads).'</td></tr>';
		$message.='<tr><th scope="row">Sermon Directory?</th><td>'.esc_html( $hasSermonDir).'</td></tr>';
		if(!empty( $sermonDirPath) )$message.='<tr><th scope="row">Sermon Directory path</th><td>'.esc_html( $sermonDirPath).'</td></tr>';
		
		$message.='<tr><th scope="row">Issue</th><td>'.wp_kses( $_POST['message'],'post').'</td></tr>';
		$message.='</table>';
		echo $message;
		add_filter( 'wp_mail_from_name','church_admin_from_name' );
		add_filter( 'wp_mail_from', 'church_admin_from_email');
		add_filter('wp_mail_content_type','church_admin_email_type');
		$success=wp_mail('support@churchadminplugin.com',$subject,$message,null,array( $fileToSend) );
		
		remove_filter( 'wp_mail_from_name','church_admin_from_name' );
		remove_filter( 'wp_mail_from', 'church_admin_from_email');
		remove_filter('wp_mail_content_type','church_admin_email_type');
		if(!empty( $success) )echo'<div class="notice notice-success"><h2>Debug log sent</h2></div>';
		if(unlink( $fileToSend) )echo'<p>'.esc_html( $fileToSend).' deleted</p>';
	}
	else
	{
		echo'<h3>'.__('Ready to send','church-admin').'</h3>';
		echo'<form action="" method="POST">';
		echo'<div class="church-admin-form-group"><label>'.__('Describe the issue in as much detail as you can, especially steps to reproduce','church-admin').'</label><textarea required class="church-admin-form-control" style="height:100px;" name="message"></textarea></div>';
		echo'<p><input type="hidden" name="send" value="yes"/><input class="button-primary" type="submit" value="'.__('Send','church-admin').'"/></p></form>';
	}
}



function church_admin_global_communications_settings()
{
	global $wpdb;
	$premium=get_option('church_admin_payment_gateway');
	echo'<h2>'.__("Global communications settings",'church-admin').'</h2>';
	echo'<p style="color:red">'.__('Use with caution as overrides individuals settings','church-admin').'</p>';
	if(!current_user_can('manage_options') )
	{
		echo '<div class="notice notice-danger"><h2>'.__('Only site administrators can change global email settings').'</h2></div>';
		return;
	}
	$results=$wpdb->get_results('SELECT people_id FROM '.CA_PEO_TBL.' WHERE email IS NOT NULL AND gdpr_reason IS NOT NULL');
	if(empty($results))
	{
		echo '<div class="notice notice-danger"><h2>'.__('No people with email address and GDPR reason set','church-admin').'</h2></div>';
		return;
	}
	$peopleIDs=array();
	foreach($results AS $row){
		$peopleIDs[]=(int)$row->people_id;
	}
	if(!empty($_POST['save'])){
		$wpdb->query('DELETE FROM '.CA_MET_TBL.' WHERE meta_type="posts" OR meta_type="bible-readings" OR meta_type="prayer-requests" OR meta_type="bible-readings-notifications" OR meta_type="prayer-requests-notifications" OR meta_type="posts-notifications"');

		$sql='INSERT INTO '.CA_MET_TBL.' (meta_type,ID,people_id,meta_date) VALUES ';


		foreach($peopleIDs AS $key=>$people_id)
		{
			//the no-one case is handled by the fact the meta key for that people_id no longer exists
			
			$values=array();
			switch($_POST['posts'])
			{
				case 'everyone':
					$values[]='("posts",1,"'.(int)$people_id.'","'.date('Y-m-d').'")';
					$message['posts']=__("Posts - everyone",'church-admin');
				break;
				default:
						$message['posts']=__("Posts - no-one",'church-admin');
				break;
			}
			switch($_POST['bible-readings'])
			{
				case 'everyone':
					$values[]='("bible-readings",1,"'.(int)$people_id.'","'.date('Y-m-d').'")';
					$message["bible-readings"]=__("Bible readings - everyone",'church-admin');
				break;
				default:
						$message["bible-readings"]=__("Bible readings - no-one",'church-admin');
					break;
			}
			switch($_POST['prayer-requests'])
			{
				case 'everyone':
					$values[]='("prayer-requests",1,"'.(int)$people_id.'","'.date('Y-m-d').'")';
					$message["prayer-requests"]=__("Prayer requests - everyone",'church-admin');
				break;
				default:
						$message["prayer-requests"]=__("Prayer requests - no-one",'church-admin');
				break;
			}
			if(!empty($premium)){
				switch($_POST['posts-notifications'])
				{
					case 'everyone':
						$values[]='("posts-notifications",1,"'.(int)$people_id.'","'.date('Y-m-d').'")';
						$message["posts-notifications"]=__("Post notifications - everyone",'church-admin');
					break;
					default:
						$message["posts-notifications"]=__("Post notifications - no-one",'church-admin');
					break;
				}
				switch($_POST['bible-readings-notifications'])
				{
					case 'everyone':
						$values[]='("bible-readings-notifications",1,"'.(int)$people_id.'","'.date('Y-m-d').'")';
						$message["bible-readings-notifications"]=__("Bible readings notifications - everyone",'church-admin');
					break;
					default:
						$message["bible-readings-notifications"]=__("Bible readings notifications - no-one",'church-admin');
					break;
				}
				switch($_POST['prayer-requests-notifications'])
				{
					case 'everyone':
						$values[]='("prayer-requests-notifications",1,"'.(int)$people_id.'","'.date('Y-m-d').'")';
						$message["prayer-requests-notifications"]=__("Prayer requests notifications - everyone",'church-admin');
					break;
					default:
						$message["prayer-requests-notifications"]=__("Prayer requests notifications - no-one",'church-admin');
					break;
					
				}

			}
		}
		if( !empty( $values ) ){
			$wpdb->query( $sql.implode( ",", $values ) );
		}
		echo'<div class="notice notice-success"><h2>'.__('Global Communications settings updated','church-admin').'</h2><p>'.implode('<br/>',$message).'</p></div>';
	}

	echo '<form action="" method="POST">';
	echo'<h3>'.__('Emails','church-admin').'</h2>';
	
	echo'<div class="church-admin-form-group"><label>'.__('Blog posts','church-admin').'</label><select class="church-admin-form-control" name="posts"><option value="everyone">'.__('Everyone','church-admin').'</option><option value="no-one">'.__('No-one','church-admin').'</option></select></div>';
	
	if(!post_type_exists('bible-readings') )
	{
		echo'<p>'.__("You don't have Bible Readings post type currently",'church-admin').'</p>';;
	}
	echo'<div class="church-admin-form-group"><label>'.__('Bible readings','church-admin').'</label><select class="church-admin-form-control" name="bible-readings"><option value="everyone">'.__('Everyone','church-admin').'</option><option value="no-one">'.__('No-one','church-admin').'</option></select></div>';
	if(!post_type_exists('prayer-requests') )
	{
		echo'<p>'.__("You don't have Bible Readings post type currently",'church-admin').'</p>';;
	}
	echo'<div class="church-admin-form-group"><label>'.__('Prayer Requests','church-admin').'</label><select class="church-admin-form-control" name="prayer-requests"><option value="everyone">'.__('Everyone','church-admin').'</option><option value="no-one">'.__('No-one','church-admin').'</option></select></div>';

	
	if(!empty($premium))
	{
		echo'<h3>'.__('Push Notifications','church-admin').'</h3>';
		echo'<div class="church-admin-form-group"><label>'.__('Blog posts','church-admin').'</label><select class="church-admin-form-control" name="posts-notifications"><option value="everyone">'.__('Everyone','church-admin').'</option><option value="no-one">'.__('No-one','church-admin').'</option></select></div>';
		echo'<div class="church-admin-form-group"><label>'.__('Bible readings','church-admin').'</label><select class="church-admin-form-control" name="bible-readings-notifications"><option value="everyone">'.__('Everyone','church-admin').'</option><option value="no-one">'.__('No-one','church-admin').'</option></select></div>';
		echo'<div class="church-admin-form-group"><label>'.__('Prayer Requests','church-admin').'</label><select class="church-admin-form-control" name="prayer-requests-notifications"><option value="everyone">'.__('Everyone','church-admin').'</option><option value="no-one">'.__('No-one','church-admin').'</option></select></div>';

	}
	/*
	echo'<h3>'.__('SMS','church-admin').'</h3>';
	echo'<div class="church-admin-form-group"><label>'.__('SMS send','church-admin').'</label><select class="church-admin-form-control" name="sms_send"><option value="everyone">'.__('Everyone','church-admin').'</option><option value="no-one">'.__('No-one','church-admin').'</option></select></div>';
	*/
	echo'<p><input type="hidden" name="save" value="1"/><input type="submit" value="'.esc_html( __( 'Save', 'church-admin' ) ).'" class="button-primary"/></p></form>';


}