<?php
if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

/************************************
*
*   Twilio listener
*
*************************************/
function church_admin_twilio_listener()
{
    global $wpdb;
    church_admin_debug("Twilio listener function fired");
    $smsProvider=get_option('church_admin_sms_provider');
    if ( empty( $smsProvider)||$smsProvider!='twilio')  {
           
        exit('Jesus loves you');
    }
    $sqlsafe=array();
    

    foreach( $_REQUEST AS $key=>$value)$sqlsafe[$key]=esc_sql(stripslashes( $value) );
    //church_admin_debug(print_r( $sqlsafe,TRUE) );
    $check=$wpdb->get_var('SELECT message_id FROM '.CA_TWI_TBL.' WHERE twilio_id="'.$sqlsafe['MessageSid'].'"');
    if ( empty( $check) )
    {
        $people_id=0;
        $people_id=$wpdb->get_var('SELECT people_id FROM '.CA_PEO_TBL.' WHERE e164cell="'.$sqlsafe['From'].'"');
        if(defined('CA_DEBUG') )church_admin_debug( $wpdb->last_query);
        $optout=array('STOP','STOPALL','QUIT','END','UNSUBSCRIBE','CANCEL');
        if(!empty( $sqlsafe['body'] )&& in_array( $sqlsafe['body'],$optout) )
        {
            //change sms_send=0
            $wpdb->query('UPDATE '.CA_PEO_TBL.' SET sms_send=0 WHERE e164cell="'.$sqlsafe['From'].'"');
        }
        if(!empty( $sqlsafe['body'] )&&$sqlsafe['body']=='START')
        {
            //change sms_send=1
            $wpdb->query('UPDATE '.CA_PEO_TBL.' SET sms_send=1 WHERE e164cell="'.$sqlsafe['From'].'"');
        }
        $wpdb->query('INSERT INTO '.CA_TWI_TBL.' (mobile,direction,message, twilio_id,message_date,people_id)VALUES("'.$sqlsafe['From'].'","0","'.$sqlsafe['Body'].'","'.$sqlsafe['MessageSid'].'","'.date('Y-m-d H:i:s').'","'.(int)$people_id.'")');
        if(defined('CA_DEBUG') )church_admin_debug( $wpdb->last_query);

        //push to admin if they have set to receive them
        $admin_people_ids=get_option('church_admin_twilio_receive_push_to_admin');
        //church_admin_debug('Admin people_ids...');
        //church_admin_debug(print_r( $admin_people_ids,TRUE) );
        if(!empty( $admin_people_ids) )
        {
            $pushTokens=church_admin_get_push_tokens_from_ids( $admin_people_ids);
            //church_admin_debug('Tokens...');
            //church_admin_debug(print_r( $pushTokens,TRUE) );
            if(!empty( $pushTokens) )
            {
                require_once(plugin_dir_path(dirname(__FILE__) ).'includes/push.php');
               
                $message=__('SMS reply','church-admin').': '.stripslashes( $_REQUEST['Body'] );
                $dataMessage=$message;
                
                church_admin_filtered_push( $message,$pushTokens,'SMS reply received',$dataMessage,'sms-thread',$sqlsafe['From'] );

            }


        }


    }

}
/******************************************
*
*   Twilio recent replies list
*
*******************************************/
function church_admin_twilio_replies_list()
{
    global $wpdb;
    echo'<h2>'.__('Twilio replies list','church-admin').'</h2>';
    require_once(plugin_dir_path(dirname(__FILE__) ).'includes/sms.php');
    church_admin_sms_credits();
    

    $smsProvider=get_option('church_admin_sms_provider');
    if ( empty( $smsProvider)||$smsProvider!='twilio')  {
        echo '<p><strong>'.__('You need to set Twilio as your SMS provider to use this feature','church-admin').'</strong></p>';
        echo'<p><a href="admin.php?page=church_admin/index.php&amp;action=sms-settings" class="button-primary">'.__('SMS Settings','church-admin').'</a></p>';
    }
    else
    {   
        //set up push notifications for replies
        if(!empty( $_POST['twilio-admin-push-form'] ) )
        {
            if(!empty( $_POST['twilio-admin-push'] ) )
            {
                $twilio_people_id=maybe_unserialize(church_admin_get_people_id( $_POST['twilio-admin-push'] ) );
                update_option('church_admin_twilio_receive_push_to_admin',$twilio_people_id);
            }
            else
            {
                delete_option('church_admin_twilio_receive_push_to_admin');
            }
        }
        echo'<form action="" method="POST"><h3>'.__('Set one person who you would like to receive push notificiation of Twilio SMS replies... ','church-admin').'</h3>';
        $people='';
        $twilio_people_ids=get_option('church_admin_twilio_receive_push_to_admin');
        if(!empty( $twilio_people_ids) )$people=church_admin_get_people( $twilio_people_ids);
        echo '<p>'.church_admin_autocomplete('twilio-admin-push','friends','to',$people,FALSE).'</p>';
        echo'<input type="hidden" name="twilio-admin-push-form" value="yes"/><input type="submit" class="button-secondary" value="'.__('Set Twilio reply push','church-admin').'"/></p></form>';




        $SMSnumber=get_option('church_admin_sms_reply');
        if(!empty( $SMSnumber) )echo '<p>'.sprintf(__('SMS number: %1$s','church-admin'),$SMSnumber).'</p>';
        echo'<p>'.sprintf(__('To receive replies make sure you set this webhook %1$s at %2$s. Instruction at %3$s','church-admin'),'<strong>'.admin_url('admin-ajax.php?action=church_admin_twilio_listener').'</strong>','<a target="_blank" href="https://www.twilio.com/console/phone-numbers/incoming">Twilio Numbers page</a>','<a target="_blank"  href="https://www.churchadminplugin.com/tutorials/twilio-incoming-numbers">tutorial page</a>').'</p>';
        echo'<p>'.__('This list refreshes automatically every 10secs. Best to delete threads when finished to save data!','church-admin').'</p>';
        
        
        echo'<table class="widefat wp-list-table striped bordered">';
        $tableHeader='<tr><th class="column-primary">'.__('Cell number','church-admin').'</th><th>'.__('Delete thread','church-admin').'</th><th>'.__('Last message received','church-admin').'</th><th>'.__('Name','church-admin').'</th><th>'.__('Message','church-admin').'</th><th>'.__('View thread','church-admin').'</th><tr>';
        echo'<thead>'.$tableHeader.'</thead><tfoot>'.$tableHeader.'</tfoot><tbody class="ca-sms-replies">';
        echo church_admin_sms_replies_list();
        echo'</tbody></table>';
        $nonce=wp_create_nonce('refresh-sms-replies');
        echo'<script>
        jQuery(document).ready(function( $)  {
            var timeout = setInterval(reloadChat, 10000);    
            function reloadChat () {
               
                var data={"action":"church_admin","method":"refresh-sms-replies","nonce":"'.$nonce.'"};
		 	  
		 	    $.getJSON({
		 			url: ajaxurl,
		 			type: "POST",
		 			data: data,
		 			success: function(res) 
                    {
                    
                        $(".ca-sms-replies").html(res)
		 			}
		 	    });
                
            }
        
        });
    
    </script>';    
        
    }
}
function church_admin_sms_replies_list()
{
    global $wpdb;
     $results=$wpdb->get_results('SELECT t1.* FROM '.CA_TWI_TBL.' t1 INNER JOIN ( SELECT `mobile`, MAX(message_date) AS max_message_date FROM '.CA_TWI_TBL.' WHERE direction=0 GROUP BY `mobile` ) t2 ON t1.`mobile` = t2.`mobile` AND t1.message_date = t2.max_message_date');

        if(!empty( $results) )
        {
            $out='';
            foreach( $results AS $row)
            {
                $name='&nbsp;';
                $nameObj=$wpdb->get_row('SELECT first_name,prefix,last_name FROM '.CA_PEO_TBL.' WHERE e164cell="'.esc_sql( $row->mobile).'"');
                if(!empty( $nameObj) )$name=implode(" ",array_filter(array( $nameObj->first_name,$nameObj->prefix,$nameObj->last_name) ));
                $deleteThread='<a onclick="return confirm(\''.__('Are you sure?','church-admin').'\')"  href="'.wp_nonce_url('admin.php?page=church_admin/index.php&section=comms&amp;action=delete-sms-thread&mobile='.urlencode( $row->mobile),'delete-sms-thread').'">'.__('Delete SMS thread','church-admin').'</a>';
                $viewThread='<a href="'.wp_nonce_url('admin.php?page=church_admin/index.php&amp;action=view-sms-thread&section=comms&mobile='.urlencode( $row->mobile),'view-sms-thread').'">'.__('View SMS thread','church-admin').'</a>';
                if ( empty( $row->mobile) )$row->mobile=__('Unknown','church-admin');
                
                $out.='<tr>
                    <td data-colname="'.__('Cell number','church-admin').'" class="column-primary">'.esc_html( $row->mobile).'<button type="button" class="toggle-row"><span class="screen-reader-text">show details</span></button></td>
                    <td data-colname="'.__('Delete thread','church-admin').'">'.$deleteThread.'</td>
                    <td data-colname="'.__('Message date','church-admin').'">'.mysql2date(get_option('date_format').' '.get_option('time_format'),$row->message_date).'</td>
                    <td data-colname="'.__('Name','church-admin').'">'.$name.'</td>
                    <td data-colname="'.__('Message','church-admin').'">'.esc_html( $row->message).'</td>
                    <td data-colname="'.__('View thread?','church-admin').'">'.$viewThread.'</td>
                </tr>';
            }
        }else $out='<tr><td colspan=6>'.__('No replies received yet','church-admin').'</td></tr>';
    return $out;
}
/******************************************
*
*   Delete SMS thread
*
*******************************************/
function church_admin_delete_sms_thread( $mobile)
{
    global $wpdb;
    $e164cell='+'.trim( $mobile);
    $wpdb->query('DELETE FROM '.CA_TWI_TBL.' WHERE mobile="'.esc_sql( $e164cell).'"');
    echo '<div class="notice notice-success"><h2>'.sprintf(__('Message thread for %1$s deleted','church-admin'),$e164cell).'</h2></div>';
    church_admin_twilio_replies_list();
}

/******************************************
*
*   View thread
*
*******************************************/
function church_admin_view_sms_thread( $mobile)
{
    global $wpdb;
    require_once(plugin_dir_path(dirname(__FILE__) ).'includes/sms.php');
    $e164cell='+'.trim( $mobile);
    $name='';
    $nameObj=$wpdb->get_row('SELECT first_name,prefix,last_name FROM '.CA_PEO_TBL.' WHERE e164cell="'.esc_sql( $e164cell).'"');
    if(!empty( $nameObj) )$name=implode(" ",array_filter(array( $nameObj->first_name,$nameObj->prefix,$nameObj->last_name) ));
    if(!empty( $_POST['e164cell'] ) )
    {
        
        church_admin_sms(stripslashes( $_POST['e164cell'] ),stripslashes( $_POST['ca-sms-message'] ),FALSE);
        
    }
    echo'<h2>'.sprintf(__('Message thread for %1$s %2$s','church-admin'),$name, $e164cell).'</h2>';
     echo'<p>'.__('This list refreshes automatically every 5secs.','church-admin').'</p>';
    church_admin_sms_credits();
    $results=$wpdb->get_results('SELECT * FROM '.CA_TWI_TBL.' WHERE mobile="'.esc_sql( $e164cell).'" ORDER BY message_date ASC');
    if(!empty( $results) )
    {
        echo'<div class="ca-message-container"><div class="ca-sms-messages">';
        foreach( $results AS $row)
        {
            switch( $row->direction)
            {
                case '0': 
                    $class= 'class="ca-message-blue"';
                    $tsClass='class="ca-message-timestamp-left"';
                break;
                case '1': 
                    $class= 'class="ca-message-orange"';
                    $tsClass='class="ca-message-timestamp-right"';    
                break;
            }
            echo'<div '.$class.'>';
            $message=esc_html( $row->message);
            if(function_exists('make_clickable') )$message=make_clickable( $message);
            echo '<div class="ca-message-content">'.esc_html( $message ).'</div>'."\r\n";
            echo'<div '.$tsClass.'>'.esc_html( mysql2date( get_option( 'date_format' ).' '.get_option( 'time_format' ), $row->message_date ) ).'</div></div>'."\r\n";
        }
        $messageID=(int)$row->message_id;
        echo'</div>'."\r\n".'<div class="message_id" data-messageid="'.$messageID.'"></div>'."\r\n";
        echo'</div>'."\r\n";
    }
    echo'<h3>'.__('Send reply','church-admin').'</h3>';
    echo'<form action="" class="ca-send-form" method="post">';
    echo'<textarea class="ca-send-message" name="ca-sms-message"></textarea>';
    echo'<input type="hidden" name="e164cell" value="'.esc_html( $e164cell).'"/>';
    echo'<p><input type="submit" class="button-primary" value="'.__('Send','church-admin').'"/></p></form>'; $nonce=wp_create_nonce('refresh-sms');
    echo'<script>
        jQuery(document).ready(function( $)  {
            var timeout = setInterval(reloadChat, 5000);    
            function reloadChat () {
            /* must use .attr as .data doesnt pick up changed DOM! */
                var lastID=$("body .message_id").attr("data-messageid");
                var e164cell="'.esc_html( $e164cell).'";
                var data={"action":"church_admin","method":"refresh-sms","lastID":lastID,"e164cell":e164cell,"nonce":"'.$nonce.'"};
		 	  
		 	    $.getJSON({
		 			url: ajaxurl,
		 			type: "POST",
		 			data: data,
		 			success: function(res) 
                    {
                        if(res.messages)$(".ca-sms-messages").append(res.messages)
                        if(res.id)$(".message_id").attr("data-messageid",res.id);
		 			}
		 	    });
                
            }
        
        });
    
    </script>';
}